/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.eas.ma.mbg.app.olap.face.IDebugLogger;
import org.apache.log4j.Logger;

public class DebugLogger
implements IDebugLogger {
    private Logger logger = null;
    private long startTime = 0L;
    private long beginTime = 0L;

    public DebugLogger(Logger logger) {
        this.logger = logger;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    @Override
    public boolean isDebug() {
        return this.logger.isDebugEnabled();
    }

    private void out(String context) {
        this.logger.debug((Object)context);
    }

    @Override
    public void debugStart(String content) {
        if (this.isDebug()) {
            this.out(content);
            this.setStartTime(System.currentTimeMillis());
            this.setBeginTime(this.getStartTime());
        }
    }

    @Override
    public void debugBegin(String content) {
        if (this.isDebug()) {
            this.out(content);
            this.setBeginTime(System.currentTimeMillis());
        }
    }

    @Override
    public void debugUseTime(String content) {
        if (this.isDebug()) {
            this.out("invoke " + content + " process use = " + (System.currentTimeMillis() - this.getBeginTime()) + " ms;");
        }
    }

    @Override
    public void debugEnd(String content) {
        if (this.isDebug()) {
            this.out("invoke " + content + " process All use = " + (System.currentTimeMillis() - this.getStartTime()) + " ms;");
        }
    }

    @Override
    public void debugContent(String content) {
        if (this.isDebug()) {
            this.out(content);
        }
    }

    @Override
    public void start(String content) {
        this.out(content);
        this.setStartTime(System.currentTimeMillis());
        this.setBeginTime(this.getStartTime());
    }

    @Override
    public void begin(String content) {
        this.out(content);
        this.setBeginTime(System.currentTimeMillis());
    }

    @Override
    public void end(String content) {
        this.out("invoke " + content + " process All use = " + (System.currentTimeMillis() - this.getStartTime()) + " ms;");
    }

    @Override
    public void useTime(String content) {
        this.out("invoke " + content + " process use = " + (System.currentTimeMillis() - this.getBeginTime()) + " ms;");
    }

    @Override
    public void content(String content) {
        this.out(content);
    }
}

