/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.mbg.app.olap.face.IDebugLogger;
import com.kingdee.eas.ma.mbg.app.olap.face.IMDXStrategy;
import com.kingdee.eas.ma.mbg.app.olap.impl.DebugLogger;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgMdxUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimDataUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MDXStrategy
implements IMDXStrategy {
    private static Logger logger = Logger.getLogger(MDXStrategy.class);
    private IDebugLogger debug = null;
    protected Map<String, IMember> accMemberMap = null;
    protected Map<String, IMember> periodMemberMap = null;
    private String calcStr = null;

    public MDXStrategy() {
        this.setDebug(this.createDebug());
    }

    public void setDebug(IDebugLogger debug) {
        this.debug = debug;
    }

    public IDebugLogger getDebug() {
        return this.debug;
    }

    public IDebugLogger createDebug() {
        return new DebugLogger(logger);
    }

    protected Map<String, IMember> getAccMemberMap(Context ctx, IDimensionParameter parameter) throws Exception {
        if (this.accMemberMap == null) {
            this.accMemberMap = this.queryAccDimMemberMap(ctx, parameter);
        }
        return this.accMemberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IMember> queryAccDimMemberMap(Context ctx, IDimensionParameter parameter) throws Exception {
        String factTable = parameter.getDataManager().getOptimizeParams().get(DimensionConstants.BGINDEX_FACT_TABLE);
        String tmpBgIndexTable = parameter.getDataManager().getOptimizeParams().get(DimensionConstants.BGINDEX_FILTER);
        if (StringUtils.isEmpty((String)factTable) || StringUtils.isEmpty((String)tmpBgIndexTable)) {
            return DimUtils.getDimMemberMap(parameter.getDimension(DimensionConstants.DEF_BGINDEX_FIELD));
        }
        HashMap<String, IMember> result = new HashMap<String, IMember>();
        IRowSet rst = null;
        String number = null;
        String longNumber = null;
        MemberObject member = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)("select FDimNumber, FDimLongNumber from " + factTable + " where exists (select FNumber from " + tmpBgIndexTable + " where FNumber = " + factTable + ".FDimNumber)"));
            while (rst.next()) {
                number = rst.getString("FDimNumber");
                longNumber = rst.getString("FDimLongNumber");
                member = new MemberObject();
                member.setNumber(number);
                member.setName(number);
                member.setMdxNumber(longNumber);
                member.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
                result.put(number, member);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return result;
    }

    protected Map<String, IMember> getPeriodMemberMap(Context ctx, IDimensionParameter parameter) throws Exception {
        if (this.periodMemberMap == null) {
            this.periodMemberMap = this.queryPeriodDimMemberMap(ctx, parameter);
        }
        return this.periodMemberMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IMember> queryPeriodDimMemberMap(Context ctx, IDimensionParameter parameter) throws Exception {
        String factTable = DimensionConstants.PERIOD_FACTTABLE_NAME;
        if (parameter.getDataManager().getOptimizeParams().containsKey(DimensionConstants.PERIOD_FISCALYEAR)) {
            factTable = ClosureUtils.HK_PERIOD_TABLE_FACT;
        }
        String sql = null;
        if (parameter.getDataManager().getOptimizeParams().containsKey(DimensionConstants.PERIOD_SQL) && (sql = parameter.getDataManager().getOptimizeParams().get(DimensionConstants.PERIOD_SQL)).indexOf(DimensionConstants.CUBE_NAME) > 0) {
            if (sql.indexOf("p.FTypeId") > 0 && DimensionConstants.PERIOD_FACTTABLE_NAME.equals(factTable)) {
                factTable = "T_MBG_BgPeriodDisp";
            }
            sql = sql.replaceAll(DimensionConstants.CUBE_NAME, factTable);
        }
        if (sql == null) {
            return DimUtils.getDimMemberMap(parameter.getDimension(DimensionConstants.DEF_PERIOD_FIELD));
        }
        HashMap<String, IMember> result = new HashMap<String, IMember>();
        IRowSet rst = null;
        String number = null;
        String longNumber = null;
        MemberObject member = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rst.next()) {
                number = rst.getString("FNumber");
                longNumber = rst.getString("FLongNumber");
                member = new MemberObject();
                member.setNumber(number);
                member.setName(number);
                member.setMdxNumber(longNumber);
                member.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                result.put(number, member);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return result;
    }

    @Override
    public void transCalcMdx(Context ctx, IDimensionParameter parameter) throws Exception {
        Set<String> refPeriods;
        if (ctx == null || parameter == null) {
            return;
        }
        this.calcStr = parameter.getDataManager().getCalcStrategy().bizCalcMdx(ctx, parameter);
        boolean isPeriodFlag = BgParamNHelper.isPeriodAlgorithm((Context)ctx);
        if (!isPeriodFlag) {
            return;
        }
        if ((parameter.getDataManager().getOpeningNumber() == null || parameter.getDataManager().getOpeningNumber().isEmpty()) && (parameter.getDataManager().getEndNumber() == null || parameter.getDataManager().getEndNumber().isEmpty())) {
            return;
        }
        StringBuffer periodCalcStr = new StringBuffer();
        Map<String, IMember> perMemberMap = this.queryPeriodDimMemberMap(ctx, parameter);
        Map<String, IMember> accMemberMap = this.queryAccDimMemberMap(ctx, parameter);
        String parent = null;
        for (String child : parameter.getBgPeriodParentMap().keySet()) {
            parent = parameter.getBgPeriodParentMap().get(child);
            if (!parameter.getBgPeriodChildMap().containsKey(parent)) {
                parameter.getBgPeriodChildMap().put(parent, new ArrayList());
            }
            if (parameter.getBgPeriodChildMap().get(parent).contains(child)) continue;
            parameter.getBgPeriodChildMap().get(parent).add(child);
        }
        if (parameter.getDataManager().getCalcStrategy() != null && parameter.getDataManager().getCalcStrategy().getRefNumMap() != null && (refPeriods = parameter.getDataManager().getCalcStrategy().getRefNumMap().get(DimensionConstants.DEF_PERIOD_FIELD)) != null && !refPeriods.isEmpty()) {
            String[] lns = null;
            String pNumber = null;
            String cNumber = null;
            HashMap<String, Set<String>> allParentChildMap = new HashMap<String, Set<String>>();
            for (IMember member : perMemberMap.values()) {
                lns = member.getMdxNumber().split("!");
                if (lns.length == 1) continue;
                pNumber = lns[lns.length - 2];
                cNumber = lns[lns.length - 1];
                if (!allParentChildMap.containsKey(pNumber)) {
                    allParentChildMap.put(pNumber, new HashSet());
                }
                ((Set)allParentChildMap.get(pNumber)).add(cNumber);
            }
            this.addToParentChildMap(refPeriods, allParentChildMap, parameter.getBgPeriodChildMap());
        }
        String[] lns = null;
        for (IMember member : perMemberMap.values()) {
            lns = member.getMdxNumber().split("!");
            if (lns.length <= 1 || !parameter.getBgPeriodChildMap().containsKey(lns[lns.length - 2]) || parameter.getBgPeriodChildMap().get(lns[lns.length - 2]).contains(member.getNumber())) continue;
            parameter.getBgPeriodChildMap().get(lns[lns.length - 2]).add(member.getNumber());
        }
        Iterator<List<String>> itC = parameter.getBgPeriodChildMap().values().iterator();
        while (itC.hasNext()) {
            Collections.sort(itC.next());
        }
        this.transPeriodMdx(parameter.getDataManager().getEndNumber(), false, isPeriodFlag, parameter, periodCalcStr, perMemberMap, accMemberMap);
        this.transPeriodMdx(parameter.getDataManager().getOpeningNumber(), true, isPeriodFlag, parameter, periodCalcStr, perMemberMap, accMemberMap);
        if (periodCalcStr.length() > 0) {
            this.calcStr = StringUtils.isEmpty((String)this.calcStr) ? "WITH " + periodCalcStr.toString() : this.calcStr + "\r\n" + periodCalcStr;
        }
    }

    private void addToParentChildMap(Set<String> periods, Map<String, Set<String>> allParentChildMap, Map<String, List<String>> periodChildMap) {
        for (String period : periods) {
            Set<String> childs;
            if (periodChildMap.containsKey(period) || (childs = allParentChildMap.get(period)) == null || childs.isEmpty()) continue;
            periodChildMap.put(period, new ArrayList<String>(childs));
            this.addToParentChildMap(childs, allParentChildMap, periodChildMap);
        }
    }

    private void transPeriodMdx(Set<String> accNumbers, boolean isOpenPeriod, boolean isPeriodFlag, IDimensionParameter parameter, StringBuffer periodCalcStr, Map<String, IMember> perMemberMap, Map<String, IMember> accMemberMap) {
        if (accNumbers == null || accNumbers.isEmpty()) {
            return;
        }
        if (!isPeriodFlag) {
            return;
        }
        if (parameter.getDimension(DimensionConstants.DEF_BGINDEX_FIELD) == null) {
            logger.error((Object)"MDXStrategy.transPeriodMdx Not Period Dimension");
            return;
        }
        HashMap mdxNumMap = new HashMap();
        IMember pMember = null;
        IMember accMember = null;
        IMember cMember = null;
        int calcSeq = 0;
        int calcSubSeq = 0;
        int exprSeq = 0;
        int subSeq = 0;
        List<String> childPeriods = null;
        String parent2 = null;
        HashSet<String> checkSet = new HashSet<String>();
        for (String parent2 : parameter.getBgPeriodChildMap().keySet()) {
            pMember = this.getPeriodMember(parent2, perMemberMap);
            if (pMember == null) {
                pMember = perMemberMap.get(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, parent2));
            }
            if (pMember == null) {
                logger.error((Object)("MDXStrategy.transPeriodMdx Parent Period Not Exitst: " + parent2));
                continue;
            }
            childPeriods = parameter.getBgPeriodChildMap().get(parent2);
            if (childPeriods == null || childPeriods.isEmpty()) continue;
            String cPeriod = null;
            cPeriod = isOpenPeriod ? childPeriods.get(0) : childPeriods.get(childPeriods.size() - 1);
            cMember = this.getPeriodMember(cPeriod, perMemberMap);
            if (cMember == null) {
                logger.error((Object)("MDXStrategy.transPeriodMdx Child Period Not Exitst: " + cPeriod));
                continue;
            }
            subSeq = 0;
            for (String accNumber : accNumbers) {
                accMember = accMemberMap.get(accNumber);
                if (accMember == null) {
                    if (checkSet.contains(accNumber)) continue;
                    logger.error((Object)("MDXStrategy.transPeriodMdx Account Member Not Exitst: " + accNumber));
                    checkSet.add(accNumber);
                    continue;
                }
                periodCalcStr.append(" CELL CALCULATION ");
                periodCalcStr.append(BizExprUtils.getCalcNumber((String)("PAlGO" + (isOpenPeriod ? "O" : "E")), (int)calcSeq, (int)calcSubSeq, (int)exprSeq, (int)subSeq));
                periodCalcStr.append(" FOR ");
                periodCalcStr.append("(");
                periodCalcStr.append("{(");
                periodCalcStr.append("");
                periodCalcStr.append(BizExprUtils.getMdxField((String)DimensionConstants.DEF_BGINDEX_FIELD) + BizExprUtils.getMdxNumber((String)DimensionConstants.DEF_BGINDEX_FIELD, (String)DimensionConstants.DEF_INDEX_SRCNUMBER, (String)accMember.getMdxNumber(), mdxNumMap, null, (boolean)false) + ",");
                periodCalcStr.append(BizExprUtils.getMdxField((String)DimensionConstants.DEF_PERIOD_FIELD) + BizExprUtils.getMdxNumber((String)pMember.getMdxNumber()));
                periodCalcStr.append(")})");
                periodCalcStr.append(" AS ");
                periodCalcStr.append("'(");
                periodCalcStr.append(BizExprUtils.getMdxField((String)DimensionConstants.DEF_PERIOD_FIELD) + BizExprUtils.getMdxNumber((String)cMember.getMdxNumber()));
                periodCalcStr.append(")'");
                periodCalcStr.append("\r\n");
                ++subSeq;
            }
            ++calcSeq;
        }
    }

    private IMember getPeriodMember(String period, Map<String, IMember> perMemberMap) {
        if (StringUtils.isEmpty((String)period)) {
            return null;
        }
        IMember pMember = perMemberMap.get(DimensionFormulaHelper.getCombination(BizConstants.BGPERIOD_DIMENSION_CODE, period));
        if (pMember == null) {
            pMember = perMemberMap.get(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, period));
        }
        if (pMember == null) {
            pMember = perMemberMap.get(period);
        }
        return pMember;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String transMdx(Context ctx, IDimensionParameter parameter) throws Exception {
        if (ctx == null || parameter == null || this.checkQuery(parameter)) {
            return null;
        }
        this.getDebug().debugStart("invoke Begin parse MDX!");
        MDXStrategy.transProcessType(parameter);
        StringBuffer mdxSql = new StringBuffer();
        if (!StringUtils.isEmpty((String)this.calcStr)) {
            mdxSql.append(this.calcStr);
        }
        int colCount = 1;
        for (int i = 0; i < parameter.getColDims().size(); colCount *= parameter.getColDims().get(i).getDimensionMember().size(), ++i) {
        }
        mdxSql.append(" SELECT ");
        if (parameter.getColDims() != null && !parameter.getColDims().isEmpty()) {
            mdxSql.append(" NON EMPTY {").append(DimUtils.getSetOfMember(ctx, parameter.getColDims(), false)).append(" * ");
            mdxSql.append("{" + DimDataUtils.getTypeValue(parameter) + "}} ON COLUMNS ");
        } else {
            mdxSql.append(" NON EMPTY {" + DimDataUtils.getTypeValue(parameter) + "} ON COLUMNS ");
        }
        int rowCount = 1;
        for (int i = 0; i < parameter.getRowDims().size(); rowCount *= parameter.getRowDims().get(i).getDimensionMember().size(), ++i) {
        }
        boolean hasRelData = this.checkHasRelationData(parameter);
        boolean hasRelMap = this.checkHasRelation(parameter);
        if (rowCount >= 1500 && (hasRelData || hasRelMap)) {
            List<String[]> relationData = null;
            relationData = hasRelData ? parameter.getDataManager().getRelationData(parameter) : this.getRelationData(ctx, parameter);
            if (relationData.size() <= 1) {
                this.getDebug().content("not dimension relation!");
                return "";
            }
            rowCount = relationData.size();
            this.getDebug().content("use dimension relation!");
            String[] dimData = relationData.get(0);
            Set<String> hideDims = DimUtils.getFilterDimsOfRel(parameter, dimData);
            if (!hideDims.isEmpty()) {
                relationData = DimUtils.filterRelationData(hideDims, relationData);
                parameter.getDataManager().setRelationData(relationData);
            }
            mdxSql.append(", NON EMPTY " + DimUtils.getSetOfTuple(ctx, parameter, relationData) + " ON ROWS ");
        } else if (parameter.getRowDims() != null && !parameter.getRowDims().isEmpty()) {
            if (!parameter.getControlManager().isExpressionCalc()) {
                this.getDebug().content("cant use dimension relation!");
                mdxSql.append(", NON EMPTY " + DimUtils.getSetOfMember(ctx, parameter.getRowDims(), false) + " ON ROWS ");
            } else {
                ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> processTypeDims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
                for (int i = 0; i < parameter.getRowDims().size(); ++i) {
                    if (!DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(parameter.getRowDims().get(i).getNumber())) continue;
                    processTypeDims.add(parameter.getRowDims().get(i));
                    break;
                }
                if (parameter.getControlManager().isMultiProcessType() && !processTypeDims.isEmpty()) {
                    mdxSql.append(", NON EMPTY " + DimUtils.getSetOfTupleByCalc(parameter.getBgIndexDimension(), parameter.getExpressionParams()) + " * " + DimUtils.getSetOfMember(ctx, processTypeDims, parameter.isOrgLongNumber()) + " ON ROWS ");
                } else {
                    mdxSql.append(", NON EMPTY " + DimUtils.getSetOfTupleByCalc(parameter.getBgIndexDimension(), parameter.getExpressionParams()) + " ON ROWS ");
                }
            }
        }
        mdxSql.append(" from BudgetCube");
        if (parameter.getPageDims() != null) {
            StringBuffer where = new StringBuffer();
            where.append(DimUtils.getTupleOfPageDim(ctx, parameter.getPageDims(), parameter.isOrgLongNumber()));
            if (where.length() > 0) {
                mdxSql.append(" where ").append(where);
            }
        }
        this.getDebug().debugEnd("End parse MDX");
        this.checkMaxCellSize(rowCount, colCount, parameter);
        return mdxSql.toString();
    }

    protected void checkMaxCellSize(int rowCount, int colCount, IDimensionParameter parameter) throws Exception {
    }

    private boolean checkQuery(IDimensionParameter parameter) {
        if (parameter == null) {
            return true;
        }
        if (parameter.getRowDims().isEmpty() || parameter.getColDims().isEmpty()) {
            return true;
        }
        if (parameter.getColDims().isEmpty() && parameter.getDataManager().getRelationData(parameter).isEmpty()) {
            return true;
        }
        ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = new ArrayList<com.kingdee.eas.ma.mbg.dimension.face.IDimension>();
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = (com.kingdee.eas.ma.mbg.dimension.face.IDimension)dims.get(i);
            if (!parameter.getControlManager().isCheckNullMember() || !dim.getDimensionMember().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String transMdx(Context ctx, IDimensionParameter parameter, IQueryData query) throws Exception {
        if (ctx == null || parameter == null || query == null || query.getMbgDimMap().isEmpty()) {
            return null;
        }
        MDXStrategy.transQueryProcessType(ctx, parameter, query);
        IDimension dimension2 = null;
        String[] refFields = null;
        if (query.getFilters() != null && query.getFilters().length == 2 && query.getFilters()[1] != null && !query.getFilters()[1].isEmpty()) {
            refFields = query.getFilters()[1].get(0);
        }
        if (refFields != null && refFields.length > 0) {
            List list = Arrays.asList(refFields);
            for (IDimension dimension2 : query.getMbgDimMap().values()) {
                if (list.contains(dimension2.getField())) {
                    query.getRows().add(dimension2);
                    continue;
                }
                if (dimension2.getMembers().size() == 1) {
                    query.getViews().add(dimension2);
                    continue;
                }
                query.getCols().add(dimension2);
            }
            if (query.getCols().isEmpty() && !query.getViews().isEmpty()) {
                dimension2 = query.getViews().remove(query.getViews().size() - 1);
                query.getCols().add(dimension2);
            }
        } else {
            int i;
            for (IDimension dimension2 : query.getMbgDimMap().values()) {
                if (DimUtils.checkBaseDimension(dimension2.getNumber())) {
                    if (dimension2.getNumber() != null && DimensionConstants.DEF_PROCESSTYPE_NUMBER.equals(dimension2.getNumber())) {
                        query.getRows().add(dimension2);
                        continue;
                    }
                    query.getCols().add(dimension2);
                    continue;
                }
                query.getRows().add(dimension2);
            }
            for (i = query.getRows().size() - 1; i >= 0 && query.getRows().size() > 1; --i) {
                dimension2 = query.getRows().get(i);
                if (dimension2.getMembers().size() != 1) continue;
                query.getRows().remove(dimension2);
                query.getViews().add(dimension2);
            }
            for (i = query.getCols().size() - 1; i >= 0 && query.getCols().size() > 1; --i) {
                dimension2 = query.getCols().get(i);
                if (dimension2.getMembers().size() != 1) continue;
                query.getCols().remove(dimension2);
                query.getViews().add(dimension2);
            }
        }
        if (this.checkQuery(query)) {
            return null;
        }
        return MbgMdxUtils.transMdx(this.calcStr, query.getRows(), query.getCols(), query.getViews());
    }

    protected boolean checkQuery(IQueryData query) {
        int i;
        if (query == null || query.getRows().isEmpty() || query.getCols().isEmpty()) {
            return true;
        }
        boolean re = false;
        IDimension dimension = null;
        int in = query.getRows().size();
        for (i = 0; i < in && !re; ++i) {
            dimension = query.getRows().get(i);
            if (!dimension.getMembers().isEmpty()) continue;
            re = true;
        }
        in = query.getCols().size();
        for (i = 0; i < in && !re; ++i) {
            dimension = query.getCols().get(i);
            if (!dimension.getMembers().isEmpty()) continue;
            re = true;
        }
        return re;
    }

    protected boolean checkHasRelation(IDimensionParameter parameter) {
        return parameter != null && parameter.getDataManager() != null && parameter.getDataManager().getRelation() != null && !parameter.getDataManager().getRelation().isEmpty();
    }

    protected boolean checkHasRelationData(IDimensionParameter parameter) {
        List<String[]> relDatas;
        boolean check = false;
        if (parameter != null && parameter.getDataManager() != null && (relDatas = parameter.getDataManager().getRelationData(parameter)) != null && !relDatas.isEmpty()) {
            check = true;
        }
        return check;
    }

    protected List<String[]> getRelationData(Context ctx, IDimensionParameter parameter) {
        List<String[]> relationData = RelationUtils.getInstance(parameter.getDataManager().getMbgDims()).queryRelation(parameter.getDataManager().getRelation(), parameter);
        parameter.getDataManager().setRelationData(relationData);
        return relationData;
    }

    public static void transProcessType(IDimensionParameter parameter) {
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dim;
        Map<String, String> params = parameter.getDataManager().getOptimizeParams();
        if (parameter.getControlManager().isMultiProcessType() && (dim = DimUtils.getBgProcessTypeDim(DimUtils.getProcessType(params), parameter)) != null) {
            parameter.getColDims().add(dim);
        }
    }

    public static void transQueryProcessType(Context ctx, IDimensionParameter parameter, IQueryData query) throws Exception {
        Map<String, String> params = parameter.getDataManager().getOptimizeParams();
        if (parameter.getControlManager().isMultiProcessType()) {
            com.kingdee.eas.ma.mbg.dimension.face.IDimension dim = DimUtils.getBgProcessTypeDim(DimUtils.getProcessType(params), parameter);
            IDimension dimension = dim.toMbgDim(ctx, parameter);
            query.getMbgDimMap().put(dimension.getField(), dimension);
        }
    }
}

