/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.olap.face.IDebugLogger;
import com.kingdee.eas.ma.mbg.app.olap.face.IOlapService;
import com.kingdee.eas.ma.mbg.app.olap.face.IQueryStrategy;
import com.kingdee.eas.ma.mbg.app.olap.face.ISchemeCube;
import com.kingdee.eas.ma.mbg.app.olap.impl.AbstractOlapService;
import com.kingdee.eas.ma.mbg.app.olap.impl.DebugLogger;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OlapService
extends AbstractOlapService {
    private static Logger logger = Logger.getLogger(OlapService.class);
    public static final String JDBCCONNSTR = "JDBCCONNSTR";
    private IDebugLogger debug = null;
    private ISchemeCube schemeCube = null;
    private IQueryStrategy queryStrategy = null;

    public OlapService() {
        this.setDebug(this.createDebug());
        this.setSchemeCube(this.createSchemeCube());
        this.setQueryStrategy(this.createQueryStrategy());
    }

    public void setDebug(IDebugLogger debug) {
        this.debug = debug;
    }

    public IDebugLogger getDebug() {
        return this.debug;
    }

    public IDebugLogger createDebug() {
        return new DebugLogger(logger);
    }

    @Override
    public ISchemeCube getSchemeCube() {
        return this.schemeCube;
    }

    @Override
    public void setSchemeCube(ISchemeCube schemeCube) {
        this.schemeCube = schemeCube;
    }

    public abstract ISchemeCube createSchemeCube();

    @Override
    public void setQueryStrategy(IQueryStrategy queryStrategy) {
        this.queryStrategy = queryStrategy;
    }

    @Override
    public IQueryStrategy getQueryStrategy() {
        return this.queryStrategy;
    }

    public abstract IQueryStrategy createQueryStrategy();

    public static IOlapService getImpl(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        Class<?> _class = null;
        Object _obj = null;
        try {
            _class = Class.forName(className);
            if (IOlapService.class.isAssignableFrom(_class)) {
                _obj = Class.forName(className).newInstance();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Create OlapService Impl Error:", (Throwable)ex);
        }
        return _obj;
    }

    @Override
    public void pretreatment(Context ctx, IDimensionParameter parameter) throws Exception {
        if (ctx == null || parameter == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        IDimension orgDim = DimUtils.getOrgUnitDimension(parameter);
        BOSUuid orgUnitId = parameter.getOrgUnitId();
        BOSUuid schemeId = parameter.getBgSchemeId();
        if (orgDim == null && orgUnitId == null || schemeId == null) {
            throw new DimensionException(DimensionException.PARAMETERORGUNITORSCHEMEERROR);
        }
    }

    protected void checkDimension(Context ctx, IDimensionParameter parameter) throws Exception {
        if (parameter.getControlManager().isExpressionCalc() || parameter.getControlManager().isControlData()) {
            return;
        }
        ArrayList<String> relFields = new ArrayList<String>();
        List<String[]> relationData = parameter.getDataManager().getRelationData(parameter);
        IDimension dimension = null;
        if (relationData != null && !relationData.isEmpty()) {
            String[] relFieldData = relationData.get(0);
            for (int i = 0; i < relFieldData.length; ++i) {
                relFields.add(relFieldData[i]);
            }
            ArrayList<IDimension> tmpList = new ArrayList<IDimension>();
            tmpList.addAll(parameter.getRowDims());
            tmpList.addAll(parameter.getColDims());
            tmpList.addAll(parameter.getPageDims());
            parameter.getRowDims().clear();
            parameter.getColDims().clear();
            parameter.getPageDims().clear();
            for (IDimension _dimension : tmpList) {
                if (relFields.contains(_dimension.getField())) {
                    parameter.getRowDims().add(_dimension);
                    continue;
                }
                if (parameter.getColDims().isEmpty()) {
                    parameter.getColDims().add(_dimension);
                    continue;
                }
                if (_dimension.getDimensionMember().size() == 1) {
                    parameter.getPageDims().add(_dimension);
                    continue;
                }
                parameter.getColDims().add(_dimension);
            }
        }
        if (parameter.getColDims().isEmpty()) {
            if (!parameter.getPageDims().isEmpty()) {
                for (int p = parameter.getPageDims().size() - 1; p >= 0; --p) {
                    if (StringUtils.isEmpty((String)parameter.getPageDims().get(p).getNumber()) || !parameter.getPageDims().get(p).getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) continue;
                    dimension = parameter.getPageDims().get(p);
                    parameter.getPageDims().remove(p);
                    parameter.getColDims().add(dimension);
                    break;
                }
                if (parameter.getColDims().isEmpty() && !parameter.getPageDims().isEmpty()) {
                    dimension = parameter.getPageDims().remove(parameter.getPageDims().size() - 1);
                    parameter.getColDims().add(dimension);
                }
            } else if (!parameter.getRowDims().isEmpty()) {
                for (int i = parameter.getRowDims().size() - 1; i >= 0; --i) {
                    dimension = parameter.getRowDims().get(i);
                    if (relFields.contains(dimension.getField())) continue;
                    parameter.getRowDims().remove(i);
                    parameter.getColDims().add(dimension);
                }
            }
        }
        if (parameter.getRowDims().isEmpty()) {
            if (parameter.getColDims().size() > 1) {
                dimension = parameter.getColDims().remove(parameter.getColDims().size() - 1);
                parameter.getRowDims().add(dimension);
            } else if (!parameter.getPageDims().isEmpty()) {
                dimension = parameter.getPageDims().remove(parameter.getPageDims().size() - 1);
                parameter.getRowDims().add(dimension);
            }
        }
    }

    @Override
    public void transJDBCConnStr(Context ctx, Map<String, Object> olapParamsMap) throws Exception {
        if (ctx == null || olapParamsMap == null) {
            return;
        }
        boolean hasSqlServer = false;
        boolean hasOracle = false;
        boolean hasDB2 = false;
        boolean hasPostgreSql = false;
        StringBuffer connStr = new StringBuffer("Provider=mondrian;Jdbc=");
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            String product = conn.getMetaData().getDatabaseProductName();
            if (product != null) {
                if (product.toLowerCase().indexOf("sql server") >= 0 || product.indexOf("microsoft sql server") >= 0) {
                    hasSqlServer = true;
                } else if (product.toLowerCase().indexOf("oracle") >= 0) {
                    hasOracle = true;
                } else if (product.toLowerCase().indexOf("postgresql") >= 0) {
                    hasPostgreSql = true;
                } else {
                    hasDB2 = true;
                }
            }
            String url = conn.getMetaData().getURL();
            if (hasOracle) {
                url = url.replaceAll("//", "").replaceAll("/", ":");
                int length = url.lastIndexOf(":");
                url = url.substring(0, length) + "/" + url.substring(length + 1);
            }
            String userName = conn.getMetaData().getUserName();
            String connInfo = this.getConnectionInfo(conn);
            int indexOf1 = connInfo.indexOf("password");
            int indexOf2 = connInfo.indexOf("}", indexOf1);
            String passwordStr = connInfo.substring(indexOf1 + 9, indexOf2);
            String password = KSqlUtil.decodePassword((String)passwordStr);
            connStr.append(url).append("; ");
            connStr.append("Catalog=NULL; ");
            connStr.append("DynamicSchemaProcessor=com.kingdee.eas.ma.mbg.dimension.BgDynamicSchemaProcessor; ");
            connStr.append("JdbcUser=").append(userName).append("; ");
            connStr.append("JdbcPassword=").append(password).append("; ");
            if (hasSqlServer) {
                connStr.append("JdbcDrivers=net.sourceforge.jtds.jdbc.Driver");
            } else if (hasOracle) {
                connStr.append("JdbcDrivers=oracle.jdbc.driver.OracleDriver");
            } else if (hasDB2) {
                connStr.append("JdbcDrivers=com.ibm.db2.jcc.DB2Driver");
            } else if (hasPostgreSql) {
                connStr.append("JdbcDrivers=org.postgresql.Driver");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        olapParamsMap.put(JDBCCONNSTR, connStr.toString());
    }

    private String getConnectionInfo(Connection conn) throws BOSException {
        StringBuffer sb = new StringBuffer();
        try {
            Field[] filds = conn.getClass().getDeclaredFields();
            HashSet<Object> objectSet = new HashSet<Object>();
            for (int i = 0; i < filds.length; ++i) {
                Field f1 = filds[i];
                Object o1 = this.getSafeValue(conn, f1);
                if (o1 == null) continue;
                if (o1 instanceof String) {
                    sb.append(f1.getName() + ":" + o1);
                    sb.append("\n");
                    continue;
                }
                Field[] f1s = o1.getClass().getDeclaredFields();
                for (int j = 0; j < f1s.length; ++j) {
                    Field f2 = f1s[j];
                    Object o2 = this.getSafeValue(o1, f2);
                    if (o2 == null || objectSet.contains(o2)) continue;
                    objectSet.add(o2);
                    if (o2 instanceof String) {
                        sb.append(f2.getName() + ":" + o2);
                        sb.append("\n");
                        continue;
                    }
                    Field[] f2s = o2.getClass().getDeclaredFields();
                    for (int k = 0; k < f2s.length; ++k) {
                        Field f3 = f2s[k];
                        Object o3 = this.getSafeValue(o2, f3);
                        if (o3 == null || objectSet.contains(o3)) continue;
                        objectSet.add(o3);
                        if (o3 instanceof String) {
                            sb.append(f2.getName() + ":" + o2);
                            sb.append("\n");
                            continue;
                        }
                        Field[] f3s = o3.getClass().getDeclaredFields();
                        for (int l = 0; l < f3s.length; ++l) {
                            Field f4 = f3s[l];
                            Object o4 = this.getSafeValue(o3, f4);
                            if (o4 == null || objectSet.contains(o4)) continue;
                            objectSet.add(o4);
                            if (o4 instanceof String) {
                                sb.append(f3.getName() + ":" + o3);
                                sb.append("\n");
                                continue;
                            }
                            sb.append(f3.getName() + ":" + o3);
                            sb.append("\n");
                        }
                    }
                }
                sb.append("\n");
            }
            sb.append("\nURL: " + conn.getMetaData().getURL());
            sb.append("\nUSER: " + conn.getMetaData().getUserName());
            sb.append("\nUSER: " + ((Object)objectSet).toString());
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sb.toString();
    }

    private Object getSafeValue(Object o2, Field f3) {
        f3.setAccessible(true);
        Object o3 = null;
        try {
            o3 = f3.get(o2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o3;
    }
}

