/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.mbg.app.olap.BgPeriodData;
import com.kingdee.eas.ma.mbg.app.olap.ResultObject;
import com.kingdee.eas.ma.mbg.app.olap.face.IDebugLogger;
import com.kingdee.eas.ma.mbg.app.olap.face.IResultStrategy;
import com.kingdee.eas.ma.mbg.app.olap.impl.DebugLogger;
import com.kingdee.eas.ma.mbg.common.BgDimDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimData;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class ResultStrategy
implements IResultStrategy {
    private static Logger logger = Logger.getLogger(ResultStrategy.class);
    private IDebugLogger debug = null;
    private Context ctx = null;
    private IDimensionParameter parameter = null;

    public ResultStrategy() {
        this.setDebug(this.createDebug());
    }

    public void setDebug(IDebugLogger debug) {
        this.debug = debug;
    }

    public IDebugLogger getDebug() {
        return this.debug;
    }

    public IDebugLogger createDebug() {
        return new DebugLogger(logger);
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setParameter(IDimensionParameter parameter) {
        this.parameter = parameter;
    }

    public IDimensionParameter getParameter() {
        return this.parameter;
    }

    @Override
    public Map<String, Object> transResult(Context ctx, IDimensionParameter parameter, Object result, Map<String, Object> bgDataMap) {
        List dimData;
        if (ctx == null || result == null || parameter == null) {
            return bgDataMap;
        }
        this.setCtx(ctx);
        this.setParameter(parameter);
        ResultParam param = new ResultParam();
        param.views = parameter.getPageDims();
        Object[] objs = this.transResultData(parameter, result);
        if (objs != null && objs.length >= 2 && (dimData = (List)objs[0]) != null && !dimData.isEmpty()) {
            bgDataMap = this.getParameter().getControlManager().isControlData() ? this.getControlData(objs, param, bgDataMap) : this.getBgDimData(objs, param, bgDataMap);
        }
        return bgDataMap;
    }

    @Override
    public Map<String, Object> transResult(Context ctx, IDimensionParameter parameter, IQueryData queryData, Object result, Map<String, Object> bgDataMap) {
        List dimData;
        if (ctx == null || queryData == null || result == null || bgDataMap == null) {
            return bgDataMap;
        }
        this.setCtx(ctx);
        this.setParameter(parameter);
        ResultParam param = new ResultParam();
        param.views = queryData.getViews();
        Object[] objs = this.transResultData(parameter, result);
        if (objs != null && objs.length >= 2 && (dimData = (List)objs[0]) != null && !dimData.isEmpty()) {
            bgDataMap = this.getBgDimData(objs, param, bgDataMap);
        }
        return bgDataMap;
    }

    protected abstract Object[] transResultData(IDimensionParameter var1, Object var2);

    protected Map<String, Object> getControlData(Object[] objs, ResultParam param, Map<String, Object> bgDataMap) {
        int i;
        if (objs == null || objs.length < 2 || param == null) {
            return bgDataMap;
        }
        Map<String, Object> valueMap = bgDataMap;
        if (valueMap == null) {
            valueMap = new HashMap<String, Object>();
        }
        List dimDatas = (List)objs[0];
        Map dimIndexMap = (Map)objs[1];
        int valueType = 0;
        Object obj = null;
        String orgNumber = null;
        String dimItemNumber = null;
        String bgPeriodNum = null;
        String bgElementNum = null;
        String currencyNum = null;
        String scenarioNum = null;
        String key2 = null;
        String[] rowData = null;
        BigDecimal numeric = null;
        Map<String, Map<String, IBgDimData>> orgMap = null;
        Map<String, IBgDimData> bgDimMap = null;
        Map<String, IObjectValue> scenarioMap = this.getParameter().getDataManager().getBgScenarioMap();
        Map<String, String> scenInnIdMap = this.getParameter().getDataManager().getInnNumMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        IDimension mbgDim = null;
        IBgDimData dimData = null;
        ResultObject dimMemObj = null;
        String[] viewData = new String[dimIndexMap.size() + param.views.size()];
        int orgIndex = dimIndexMap.containsKey("orgUnit") ? (Integer)dimIndexMap.get("orgUnit") : -1;
        int dataIndex = dimIndexMap.size();
        int i2 = 0;
        int in = param.views.size();
        while (i2 < in) {
            obj = param.views.get(i2);
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dimension = obj;
                viewData[dataIndex] = DimUtils.checkBaseDimension(dimension) ? (DimensionBaseConstants.DEF_VERSION_FIELD.equals(dimension.getField()) || DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(dimension.getField()) ? String.valueOf(dimension.getDimensionMember().get(0).getInnerId()) : dimension.getDimensionMember().get(0).getNumber()) : dimension.getDimensionMember().get(0).getDimNumber();
                dimIndexMap.put(DimUtils.getDimensionTag(dimension.getNumber(), dimension.getField()), dataIndex);
            } else if (obj instanceof IDimension) {
                mbgDim = obj;
                viewData[dataIndex] = DimUtils.checkBaseDimension(mbgDim.getNumber()) ? (DimensionBaseConstants.DEF_VERSION_FIELD.equals(mbgDim.getField()) || DimensionBaseConstants.DEF_SCENARIO_FIELD.equals(mbgDim.getField()) ? String.valueOf(mbgDim.getMembers().get(0).getInnerId()) : mbgDim.getMembers().get(0).getNumber()) : mbgDim.getMembers().get(0).getDimNumber();
                dimIndexMap.put(DimUtils.getDimensionTag(mbgDim.getNumber(), mbgDim.getField()), dataIndex);
            }
            ++i2;
            ++dataIndex;
        }
        String defCurrencyNum = this.getParameter().getDataManager().getDefCurrency() != null ? this.getParameter().getDataManager().getDefCurrency()[0] : null;
        String defElementNum = this.getParameter().getDataManager().getDefElement() != null ? this.getParameter().getDataManager().getDefElement()[0] : null;
        String defVersionNum = this.getParameter().getDataManager().getDefVersion() != null ? this.getParameter().getDataManager().getDefVersion()[0] : null;
        String defScenarioNum = this.getParameter().getDataManager().getDefScenario() != null ? this.getParameter().getDataManager().getDefScenario()[0] : null;
        int periodIndex = (Integer)dimIndexMap.get("period");
        int elemIndex = dimIndexMap.containsKey("element") ? (Integer)dimIndexMap.get("element") : -1;
        int currIndex = dimIndexMap.containsKey("currency") ? (Integer)dimIndexMap.get("currency") : -1;
        int scenIndex = dimIndexMap.containsKey("scenario") ? (Integer)dimIndexMap.get("scenario") : -1;
        ArrayList<String> indexs = new ArrayList<String>();
        for (String key2 : dimIndexMap.keySet()) {
            if (!key2.startsWith("DIM")) continue;
            indexs.add(key2);
        }
        Collections.sort(indexs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(4);
                String str2 = o2.substring(4);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        int[] itemIndex = new int[indexs.size()];
        int in2 = itemIndex.length;
        for (i = 0; i < in2; ++i) {
            itemIndex[i] = (Integer)dimIndexMap.get(indexs.get(i));
        }
        orgNumber = this.getParameter().getDataManager().getOrgUnit() == null ? null : this.getParameter().getDataManager().getOrgUnit().getNumber();
        in2 = dimDatas.size();
        for (i = 0; i < in2; ++i) {
            dimMemObj = (ResultObject)dimDatas.get(i);
            rowData = dimMemObj.getDimData();
            dimItemNumber = this.getItemNumber(itemIndex, rowData, viewData);
            bgPeriodNum = this.getNumber(periodIndex, rowData, viewData);
            bgElementNum = elemIndex == -1 ? defElementNum : this.getNumber(elemIndex, rowData, viewData);
            currencyNum = currIndex == -1 ? defCurrencyNum : this.getNumber(currIndex, rowData, viewData);
            String string = scenarioNum = scenIndex == -1 ? defScenarioNum : scenInnIdMap.get(this.getNumber(scenIndex, rowData, viewData));
            if (orgIndex >= 0) {
                orgNumber = this.getNumber(orgIndex, rowData, viewData);
            }
            if ((numeric = dimMemObj.getValue()) == null) continue;
            if (valueMap.containsKey(orgNumber)) {
                orgMap = (Map)bgDataMap.get(orgNumber);
            } else {
                orgMap = new HashMap();
                valueMap.put(orgNumber, orgMap);
            }
            key2 = BgControlUtils.getControlKey((String)dimItemNumber, (String)bgElementNum, (String)currencyNum, (String)scenarioNum);
            if (orgMap.containsKey(key2)) {
                bgDimMap = (Map)orgMap.get(key2);
            } else {
                bgDimMap = new HashMap();
                orgMap.put(key2, bgDimMap);
            }
            if (bgDimMap.containsKey(bgPeriodNum)) {
                dimData = (IBgDimData)bgDimMap.get(bgPeriodNum);
            } else {
                dimData = new BgDimDataInfo();
                dimData.setDimItemNumber(dimItemNumber);
                dimData.setBgPeriodNumber(bgPeriodNum);
                dimData.setBgElementNumber(bgElementNum);
                dimData.setCurrencyNumber(currencyNum);
                dimData.setBgScenarioNumber(scenarioNum);
                bgDimMap.put(dimData.getBgPeriodNumber(), dimData);
            }
            DimUtils.setValue(dimData, numeric, valueType, scenarioMap);
        }
        return valueMap;
    }

    protected Map<String, Object> getBgDimData(Object[] objs, ResultParam param, Map<String, Object> bgDataMap) {
        if (objs == null || param == null) {
            return bgDataMap;
        }
        Map valueMap = null;
        valueMap = this.getParameter().getControlManager().isMultiProcessType() && this.getParameter().getControlManager().isSaveMultiData() ? this.getMultiProcessDimData(objs, param, bgDataMap) : this.getDimData(objs, param, bgDataMap);
        return valueMap;
    }

    private Map getDimData(Object[] objs, ResultParam param, Map bgDataMap) {
        if (objs == null || objs.length < 2 || param == null) {
            return bgDataMap;
        }
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        boolean periodFlag = BgParamNHelper.isPeriodAlgorithm((Context)this.getCtx());
        if (bgDataMap != null && !bgDataMap.isEmpty()) {
            if (bgDataMap.values().toArray()[0] instanceof Map) {
                resultMap.putAll(bgDataMap);
            } else if (this.getParameter().getOrgUnitId() != null) {
                resultMap.put(this.getParameter().getOrgUnitId().toString(), bgDataMap);
            }
        }
        Map valueMap = null;
        List dimDatas = (List)objs[0];
        Map dimIndexMap = (Map)objs[1];
        Object obj = null;
        String[] parameter = null;
        String[] rowData = null;
        String formula = null;
        String endKey = null;
        String parentNumber = null;
        String bgIndexNum = null;
        String dimKey2 = null;
        String scenarioNum = null;
        String versionNum = null;
        BigDecimal numeric = null;
        IBgNData bgData = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        IDimension mbgDim = null;
        ResultObject dimMemObj = null;
        IObjectValue objValue2 = null;
        int valueType = this.getParameter().getValueType();
        Map<String, String> scenarioMap = this.getParameter().getDataManager().getInnNumMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
        Map<String, String> versionMap = this.getParameter().getDataManager().getInnNumMap().get(DimensionConstants.DEF_VERSION_FIELD);
        Map<String, IObjectValue> scenObjMap = this.getParameter().getDataManager().getBgScenarioMap();
        HashSet<String> budgetScens = new HashSet<String>();
        for (IObjectValue objValue2 : scenObjMap.values()) {
            if (0 != ((BgScenarioInfo)objValue2).getType().getValue()) continue;
            budgetScens.add(((BgScenarioInfo)objValue2).getNumber());
        }
        BgPeriodData bgPeriodData = null;
        BgPeriodData childData = null;
        Map<String, BgPeriodData> periodMap = null;
        HashMap endPeriodMultiOrg = new HashMap();
        HashMap openPeriodMultiOrg = new HashMap();
        Map _endPeriodMap = null;
        Map _openPeriodMap = null;
        Set<String> endNumber = this.getParameter().getDataManager().getEndNumber();
        Set<String> openingNumber = this.getParameter().getDataManager().getOpeningNumber();
        boolean hasEnd = !endNumber.isEmpty();
        boolean hasOpening = !openingNumber.isEmpty();
        boolean hasBudget = false;
        String[] viewData = new String[dimIndexMap.size() + param.views.size()];
        int dataIndex = dimIndexMap.size();
        int i = 0;
        int in = param.views.size();
        while (i < in) {
            obj = param.views.get(i);
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dimension = obj;
                viewData[dataIndex] = DimUtils.checkBaseDimension(dimension) ? (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()) || DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) ? String.valueOf(dimension.getDimensionMember().get(0).getInnerId()) : dimension.getDimensionMember().get(0).getNumber()) : dimension.getDimensionMember().get(0).getDimNumber();
                dimIndexMap.put(DimUtils.getDimensionTag(dimension.getNumber(), dimension.getField()), dataIndex);
            } else if (obj instanceof IDimension) {
                mbgDim = obj;
                viewData[dataIndex] = DimUtils.checkBaseDimension(mbgDim.getNumber()) ? (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber()) || DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(mbgDim.getNumber()) ? String.valueOf(mbgDim.getMembers().get(0).getInnerId()) : mbgDim.getMembers().get(0).getNumber()) : mbgDim.getMembers().get(0).getDimNumber();
                dimIndexMap.put(DimUtils.getDimensionTag(mbgDim.getNumber(), mbgDim.getField()), dataIndex);
            }
            ++i;
            ++dataIndex;
        }
        String defCurrencyNum = this.getParameter().getDataManager().getDefCurrency() != null ? this.getParameter().getDataManager().getDefCurrency()[0] : null;
        String defElementNum = this.getParameter().getDataManager().getDefElement() != null ? this.getParameter().getDataManager().getDefElement()[0] : null;
        String defVersionNum = this.getParameter().getDataManager().getDefVersion() != null ? this.getParameter().getDataManager().getDefVersion()[0] : null;
        String defScenarioNum = this.getParameter().getDataManager().getDefScenario() != null ? this.getParameter().getDataManager().getDefScenario()[0] : null;
        int periodIndex = (Integer)dimIndexMap.get("period");
        int elemIndex = dimIndexMap.containsKey("element") ? (Integer)dimIndexMap.get("element") : -1;
        int currIndex = dimIndexMap.containsKey("currency") ? (Integer)dimIndexMap.get("currency") : -1;
        int scenIndex = dimIndexMap.containsKey("scenario") ? (Integer)dimIndexMap.get("scenario") : -1;
        int versIndex = dimIndexMap.containsKey("version") ? (Integer)dimIndexMap.get("version") : -1;
        int orgIndex = dimIndexMap.containsKey("orgUnit") ? (Integer)dimIndexMap.get("orgUnit") : -1;
        ArrayList<String> indexs = new ArrayList<String>();
        for (String dimKey2 : dimIndexMap.keySet()) {
            if (!dimKey2.startsWith("DIM")) continue;
            indexs.add(dimKey2);
        }
        Collections.sort(indexs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(4);
                String str2 = o2.substring(4);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        int[] itemIndex = new int[indexs.size()];
        int in2 = itemIndex.length;
        for (int i2 = 0; i2 < in2; ++i2) {
            itemIndex[i2] = (Integer)dimIndexMap.get(indexs.get(i2));
        }
        String orgUnitId2 = this.getParameter().getOrgUnitId() != null ? this.getParameter().getOrgUnitId().toString() : null;
        String orgNumber = null;
        int in3 = dimDatas.size();
        for (int i3 = 0; i3 < in3; ++i3) {
            dimMemObj = (ResultObject)dimDatas.get(i3);
            rowData = dimMemObj.getDimData();
            if (orgIndex >= 0) {
                orgNumber = this.getNumber(orgIndex, rowData, viewData);
                if (this.getParameter().getDataManager().getOrgUnitMap().get(orgNumber) == null) continue;
                orgUnitId2 = this.getParameter().getDataManager().getOrgUnitMap().get(orgNumber).getId().toString();
            }
            if (!resultMap.containsKey(orgUnitId2)) {
                resultMap.put(orgUnitId2, new HashMap());
            }
            valueMap = (Map)resultMap.get(orgUnitId2);
            if (!endPeriodMultiOrg.containsKey(orgUnitId2)) {
                endPeriodMultiOrg.put(orgUnitId2, new HashMap());
            }
            _endPeriodMap = (Map)endPeriodMultiOrg.get(orgUnitId2);
            if (!openPeriodMultiOrg.containsKey(orgUnitId2)) {
                openPeriodMultiOrg.put(orgUnitId2, new HashMap());
            }
            _openPeriodMap = (Map)openPeriodMultiOrg.get(orgUnitId2);
            parameter = new String[5];
            parameter[0] = this.getItemNumber(itemIndex, rowData, viewData);
            if (parameter[0] == null) continue;
            scenarioNum = scenIndex == -1 ? defScenarioNum : scenarioMap.get(this.getNumber(scenIndex, rowData, viewData));
            versionNum = versIndex == -1 ? defVersionNum : versionMap.get(this.getNumber(versIndex, rowData, viewData));
            parameter[1] = this.getNumber(periodIndex, rowData, viewData);
            parameter[2] = elemIndex == -1 ? defElementNum : this.getNumber(elemIndex, rowData, viewData);
            parameter[3] = scenarioNum;
            parameter[4] = currIndex == -1 ? defCurrencyNum : this.getNumber(currIndex, rowData, viewData);
            formula = BgNFSHelper.getFormulaFromParam(parameter);
            dimKey2 = DimUtils.getDimDataKey(formula, versionNum);
            bgIndexNum = this.getNumber(itemIndex[0], rowData, viewData);
            hasBudget = true;
            numeric = dimMemObj.getValue();
            if (numeric == null) continue;
            if (valueMap.containsKey(dimKey2)) {
                bgData = (IBgNData)valueMap.get(dimKey2);
            } else {
                bgData = new BgNViewDataInfo();
                bgData.setFormula(formula);
                bgData.setBgItemNumber(parameter[0]);
                bgData.setBgPeriodNumber(parameter[1]);
                ((BgNDataInfo)bgData).setBgIndexNum(bgIndexNum);
                ((BgNDataInfo)bgData).setBgElementNumber(parameter[2]);
                ((BgNDataInfo)bgData).setCurrencyNumber(parameter[4]);
                bgData.setBgScenario(scenarioNum);
                bgData.setBgVersion(versionNum);
                bgData.setBgDataSource(1);
            }
            DimUtils.setValue(bgData, numeric, valueType, scenObjMap);
            if (hasBudget) {
                if (hasEnd && endNumber.contains(bgIndexNum)) {
                    endKey = parameter[0] + "_" + parameter[2] + "_" + parameter[3] + "_" + parameter[4] + "_" + bgData.getBgVersion();
                    if (_endPeriodMap.containsKey(endKey)) {
                        periodMap = (Map)_endPeriodMap.get(endKey);
                    } else {
                        periodMap = new HashMap();
                        _endPeriodMap.put(endKey, periodMap);
                    }
                    if (periodMap.containsKey(bgData.getBgPeriodNumber())) {
                        bgPeriodData = (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                    } else {
                        bgPeriodData = new BgPeriodData();
                        bgPeriodData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                        periodMap.put(bgPeriodData.getBgPeriodNumber(), bgPeriodData);
                    }
                    if (!periodFlag) {
                        parentNumber = this.getParameter().getBgPeriodParentMap().get(bgData.getBgPeriodNumber());
                        if (periodMap.containsKey(parentNumber)) {
                            bgPeriodData = (BgPeriodData)periodMap.get(parentNumber);
                        } else {
                            bgPeriodData = new BgPeriodData();
                            bgPeriodData.setBgPeriodNumber(parentNumber);
                            periodMap.put(parentNumber, bgPeriodData);
                        }
                        childData = periodMap.containsKey(bgData.getBgPeriodNumber()) ? (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber()) : new BgPeriodData();
                        childData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                        childData.setBgData(bgData);
                        bgPeriodData.getChild().add(childData);
                    }
                } else if (hasOpening && openingNumber.contains(bgIndexNum)) {
                    endKey = parameter[0] + "_" + parameter[2] + "_" + parameter[3] + "_" + parameter[4] + "_" + bgData.getBgVersion();
                    if (_openPeriodMap.containsKey(endKey)) {
                        periodMap = (Map)_openPeriodMap.get(endKey);
                    } else {
                        periodMap = new HashMap();
                        _openPeriodMap.put(endKey, periodMap);
                    }
                    if (periodMap.containsKey(bgData.getBgPeriodNumber())) {
                        bgPeriodData = (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                    } else {
                        bgPeriodData = new BgPeriodData();
                        bgPeriodData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                        periodMap.put(bgPeriodData.getBgPeriodNumber(), bgPeriodData);
                    }
                    if (!periodFlag) {
                        parentNumber = this.getParameter().getBgPeriodParentMap().get(bgData.getBgPeriodNumber());
                        if (periodMap.containsKey(parentNumber)) {
                            bgPeriodData = (BgPeriodData)periodMap.get(parentNumber);
                        } else {
                            bgPeriodData = new BgPeriodData();
                            bgPeriodData.setBgPeriodNumber(parentNumber);
                            periodMap.put(parentNumber, bgPeriodData);
                        }
                        childData = periodMap.containsKey(bgData.getBgPeriodNumber()) ? (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber()) : new BgPeriodData();
                        childData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                        childData.setBgData(bgData);
                        bgPeriodData.getChild().add(childData);
                    }
                }
            }
            valueMap.put(dimKey2, bgData);
        }
        HashSet<String> removeKey = new HashSet<String>();
        for (String orgUnitId2 : resultMap.keySet()) {
            if (!periodFlag) {
                this.checkPeriodAlgorithmValue((Map)openPeriodMultiOrg.get(orgUnitId2), this.getParameter().getValueType(), true);
                this.checkPeriodAlgorithmValue((Map)endPeriodMultiOrg.get(orgUnitId2), this.getParameter().getValueType(), false);
                continue;
            }
            this.checkPeriodAlgorithmValue((Map)openPeriodMultiOrg.get(orgUnitId2), this.getParameter().getValueType(), removeKey, this.getParameter().getOpenningPeriodMap());
            this.checkPeriodAlgorithmValue((Map)endPeriodMultiOrg.get(orgUnitId2), this.getParameter().getValueType(), removeKey, this.getParameter().getEndingPeriodMap());
            this.checkValueMap((Map)resultMap.get(orgUnitId2), removeKey);
        }
        if (this.getParameter().getOrgUnitId() != null) {
            return (Map)resultMap.get(this.getParameter().getOrgUnitId().toString());
        }
        return resultMap;
    }

    private void checkValueMap(Map<String, IBgNData> valueMap, Set<String> removeKey) {
        if (removeKey == null || removeKey.isEmpty()) {
            return;
        }
        for (String key : removeKey) {
            if (!valueMap.containsKey(key)) continue;
            valueMap.remove(key);
        }
    }

    private void checkPeriodAlgorithmValue(Map<String, Map<String, BgPeriodData>> periodAlgorithmMap, int valueType, boolean isOpen) {
        if (periodAlgorithmMap == null) {
            return;
        }
        BgPeriodData bgPeriodData2 = null;
        Map<String, BgPeriodData> periodMap2 = null;
        for (Map<String, BgPeriodData> periodMap2 : periodAlgorithmMap.values()) {
            for (BgPeriodData bgPeriodData2 : periodMap2.values()) {
                if (isOpen) {
                    this.checkPeriodOpenValue(bgPeriodData2, valueType);
                    continue;
                }
                this.checkPeriodEndValue(bgPeriodData2, valueType);
            }
        }
    }

    private void checkPeriodOpenValue(BgPeriodData bgPeriodData, int valueType) {
        if (bgPeriodData == null) {
            return;
        }
        Map<String, IObjectValue> scenObjMap = this.getParameter().getDataManager().getBgScenarioMap();
        if (bgPeriodData.getChild().isEmpty()) {
            if (bgPeriodData.getBgData() != null) {
                bgPeriodData.setValue(DimUtils.getValue(bgPeriodData.getBgData(), valueType, scenObjMap));
            }
        } else {
            BgPeriodData child = null;
            int in = bgPeriodData.getChild().size();
            for (int i = 0; i < in; ++i) {
                child = bgPeriodData.getChild().get(i);
                if (child.getValue() != null) continue;
                this.checkPeriodOpenValue(child, valueType);
            }
            if (!bgPeriodData.isHasSort()) {
                Collections.sort(bgPeriodData.getChild(), new Comparator<BgPeriodData>(){

                    @Override
                    public int compare(BgPeriodData o1, BgPeriodData o2) {
                        return o1.getBgPeriodNumber().compareTo(o2.getBgPeriodNumber());
                    }
                });
                bgPeriodData.setHasSort(true);
            }
            child = bgPeriodData.getChild().get(0);
            bgPeriodData.setValue(child.getValue());
            DimUtils.setValue(bgPeriodData.getBgData(), bgPeriodData.getValue(), valueType, scenObjMap);
        }
    }

    private void checkPeriodEndValue(BgPeriodData bgPeriodData, int valueType) {
        if (bgPeriodData == null) {
            return;
        }
        Map<String, IObjectValue> scenObjMap = this.getParameter().getDataManager().getBgScenarioMap();
        if (bgPeriodData.getChild().isEmpty()) {
            if (bgPeriodData.getBgData() != null) {
                bgPeriodData.setValue(DimUtils.getValue(bgPeriodData.getBgData(), valueType, scenObjMap));
            }
        } else {
            BgPeriodData child = null;
            int in = bgPeriodData.getChild().size();
            for (int i = 0; i < in; ++i) {
                child = bgPeriodData.getChild().get(i);
                if (child.getValue() != null) continue;
                this.checkPeriodEndValue(child, valueType);
            }
            if (!bgPeriodData.isHasSort()) {
                Collections.sort(bgPeriodData.getChild(), new Comparator<BgPeriodData>(){

                    @Override
                    public int compare(BgPeriodData o1, BgPeriodData o2) {
                        return -1 * o1.getBgPeriodNumber().compareTo(o2.getBgPeriodNumber());
                    }
                });
                bgPeriodData.setHasSort(true);
            }
            child = bgPeriodData.getChild().get(0);
            bgPeriodData.setValue(child.getValue());
            DimUtils.setValue(bgPeriodData.getBgData(), bgPeriodData.getValue(), valueType, scenObjMap);
        }
    }

    private void checkPeriodAlgorithmValue(Map<String, Map<String, BgPeriodData>> bgPeriodMap, int valueType, Set<String> removeKey, Map<String, IMember> periodAlgorithmMap) {
        if (bgPeriodMap == null) {
            return;
        }
        BgPeriodData bgPeriodData = null;
        String periodNumber = null;
        String dimKey = null;
        Map<String, BgPeriodData> periodMap2 = null;
        Map<String, IObjectValue> scenObjMap = this.getParameter().getDataManager().getBgScenarioMap();
        for (Map<String, BgPeriodData> periodMap2 : bgPeriodMap.values()) {
            for (Map.Entry<String, BgPeriodData> pEntry : periodMap2.entrySet()) {
                periodNumber = pEntry.getKey();
                bgPeriodData = pEntry.getValue();
                if (!periodAlgorithmMap.containsKey(periodNumber)) continue;
                String number = periodAlgorithmMap.get(periodNumber).getNumber();
                if (periodMap2.containsKey(number)) {
                    BgPeriodData openningPeriodData = periodMap2.get(number);
                    bgPeriodData.setValue(DimUtils.getValue(openningPeriodData.getBgData(), valueType, scenObjMap));
                    DimUtils.setValue(bgPeriodData.getBgData(), bgPeriodData.getValue(), valueType, scenObjMap);
                    continue;
                }
                dimKey = DimUtils.getDimDataKey(bgPeriodData.getBgData().getFormula(), bgPeriodData.getBgData().getBgVersion());
                removeKey.add(dimKey);
            }
        }
    }

    private Map getMultiProcessDimData(Object[] objs, ResultParam param, Map bgDataMap) {
        if (objs == null || objs.length < 2 || param == null) {
            return bgDataMap;
        }
        Map<String, Map<String, IBgNData>> multiDataMap = bgDataMap;
        if (multiDataMap == null) {
            multiDataMap = new HashMap();
        }
        HashMap resultMap = new HashMap();
        if (multiDataMap != null && !multiDataMap.isEmpty()) {
            if (multiDataMap.values().toArray()[0] instanceof Map) {
                resultMap.putAll(bgDataMap);
            } else if (this.getParameter().getOrgUnitId() != null) {
                resultMap.put(this.getParameter().getOrgUnitId().toString(), multiDataMap);
            }
        }
        List dimDatas = (List)objs[0];
        Map dimIndexMap = (Map)objs[1];
        Object obj = null;
        String[] parameter = null;
        String[] rowData = null;
        String formula = null;
        String endKey = null;
        String parentNumber = null;
        String bgIndexNum = null;
        String dimKey2 = null;
        String scenarioNum = null;
        String versionNum = null;
        String processType = null;
        BigDecimal numeric = null;
        IBgNData bgData = null;
        com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension = null;
        IDimension mbgDim = null;
        ResultObject dimMemObj = null;
        IObjectValue objValue2 = null;
        int valueType = this.getParameter().getValueType();
        Map<String, String> scenarioMap = this.getParameter().getDataManager().getInnNumMap().get(DimensionConstants.DEF_SCENARIO_FIELD);
        Map<String, String> versionMap = this.getParameter().getDataManager().getInnNumMap().get(DimensionConstants.DEF_VERSION_FIELD);
        Map<String, IObjectValue> scenObjMap = this.getParameter().getDataManager().getBgScenarioMap();
        HashSet<String> budgetScens = new HashSet<String>();
        for (IObjectValue objValue2 : scenObjMap.values()) {
            if (0 != ((BgScenarioInfo)objValue2).getType().getValue()) continue;
            budgetScens.add(((BgScenarioInfo)objValue2).getNumber());
        }
        BgPeriodData bgPeriodData = null;
        BgPeriodData childData = null;
        Map<String, BgPeriodData> periodMap = null;
        HashMap<String, Map<String, BgPeriodData>> endPeriodMap = new HashMap<String, Map<String, BgPeriodData>>();
        HashMap<String, Map<String, BgPeriodData>> openPeriodMap = new HashMap<String, Map<String, BgPeriodData>>();
        Set<String> endNumber = this.getParameter().getDataManager().getEndNumber();
        Set<String> openingNumber = this.getParameter().getDataManager().getOpeningNumber();
        boolean hasEnd = !endNumber.isEmpty();
        boolean hasOpening = !openingNumber.isEmpty();
        boolean hasBudget = false;
        String[] viewData = new String[dimIndexMap.size() + param.views.size()];
        int dataIndex = dimIndexMap.size();
        int i = 0;
        int in = param.views.size();
        while (i < in) {
            obj = param.views.get(i);
            if (obj instanceof com.kingdee.eas.ma.mbg.dimension.face.IDimension) {
                dimension = obj;
                viewData[dataIndex] = DimUtils.checkBaseDimension(dimension) ? (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()) || DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) ? String.valueOf(dimension.getDimensionMember().get(0).getInnerId()) : dimension.getDimensionMember().get(0).getNumber()) : dimension.getDimensionMember().get(0).getDimNumber();
                dimIndexMap.put(DimUtils.getDimensionTag(dimension.getNumber(), dimension.getField()), dataIndex);
            } else if (obj instanceof IDimension) {
                mbgDim = obj;
                viewData[dataIndex] = DimUtils.checkBaseDimension(mbgDim.getNumber()) ? (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber()) || DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(mbgDim.getNumber()) ? String.valueOf(mbgDim.getMembers().get(0).getInnerId()) : mbgDim.getMembers().get(0).getNumber()) : mbgDim.getMembers().get(0).getDimNumber();
                dimIndexMap.put(DimUtils.getDimensionTag(mbgDim.getNumber(), mbgDim.getField()), dataIndex);
            }
            ++i;
            ++dataIndex;
        }
        String defCurrencyNum = this.getParameter().getDataManager().getDefCurrency() != null ? this.getParameter().getDataManager().getDefCurrency()[0] : null;
        String defElementNum = this.getParameter().getDataManager().getDefElement() != null ? this.getParameter().getDataManager().getDefElement()[0] : null;
        String defVersionNum = this.getParameter().getDataManager().getDefVersion() != null ? this.getParameter().getDataManager().getDefVersion()[0] : null;
        String defScenarioNum = this.getParameter().getDataManager().getDefScenario() != null ? this.getParameter().getDataManager().getDefScenario()[0] : null;
        int periodIndex = (Integer)dimIndexMap.get("period");
        int elemIndex = dimIndexMap.containsKey("element") ? (Integer)dimIndexMap.get("element") : -1;
        int currIndex = dimIndexMap.containsKey("currency") ? (Integer)dimIndexMap.get("currency") : -1;
        int scenIndex = dimIndexMap.containsKey("scenario") ? (Integer)dimIndexMap.get("scenario") : -1;
        int versIndex = dimIndexMap.containsKey("version") ? (Integer)dimIndexMap.get("version") : -1;
        int orgIndex = dimIndexMap.containsKey("orgUnit") ? (Integer)dimIndexMap.get("orgUnit") : -1;
        int processTypeIndex = dimIndexMap.containsKey("processType") ? (Integer)dimIndexMap.get("processType") : -1;
        ArrayList<String> indexs = new ArrayList<String>();
        for (String dimKey2 : dimIndexMap.keySet()) {
            if (!dimKey2.startsWith("DIM")) continue;
            indexs.add(dimKey2);
        }
        Collections.sort(indexs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(4);
                String str2 = o2.substring(4);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        int[] itemIndex = new int[indexs.size()];
        int in2 = itemIndex.length;
        for (int i2 = 0; i2 < in2; ++i2) {
            itemIndex[i2] = (Integer)dimIndexMap.get(indexs.get(i2));
        }
        String orgUnitId = this.getParameter().getOrgUnitId() != null ? this.getParameter().getOrgUnitId().toString() : null;
        String orgNumber = null;
        int in3 = dimDatas.size();
        for (int i3 = 0; i3 < in3; ++i3) {
            dimMemObj = (ResultObject)dimDatas.get(i3);
            rowData = dimMemObj.getDimData();
            if (orgIndex >= 0) {
                orgNumber = this.getNumber(orgIndex, rowData, viewData);
                orgUnitId = this.getParameter().getDataManager().getOrgUnitMap().get(orgNumber).getId().toString();
            }
            if (!resultMap.containsKey(orgUnitId)) {
                resultMap.put(orgUnitId, new HashMap());
            }
            multiDataMap = (Map)resultMap.get(orgUnitId);
            parameter = new String[5];
            parameter[0] = this.getItemNumber(itemIndex, rowData, viewData);
            if (parameter[0] == null) continue;
            scenarioNum = scenIndex == -1 ? defScenarioNum : scenarioMap.get(this.getNumber(scenIndex, rowData, viewData));
            versionNum = versIndex == -1 ? defVersionNum : versionMap.get(this.getNumber(versIndex, rowData, viewData));
            parameter[1] = this.getNumber(periodIndex, rowData, viewData);
            parameter[2] = elemIndex == -1 ? defElementNum : this.getNumber(elemIndex, rowData, viewData);
            parameter[3] = scenarioNum;
            parameter[4] = currIndex == -1 ? defCurrencyNum : this.getNumber(currIndex, rowData, viewData);
            formula = BgNFSHelper.getFormulaFromParam(parameter);
            dimKey2 = DimUtils.getDimDataKey(formula, versionNum);
            bgIndexNum = this.getNumber(itemIndex[0], rowData, viewData);
            hasBudget = budgetScens.contains(parameter[3]);
            processType = this.getNumber(processTypeIndex, rowData, viewData);
            numeric = dimMemObj.getValue();
            if (numeric == null) continue;
            Map<String, IBgNData> valueMap = null;
            if (multiDataMap.containsKey(processType)) {
                valueMap = (Map)multiDataMap.get(processType);
            } else {
                valueMap = new HashMap();
                multiDataMap.put(processType, valueMap);
            }
            if (valueMap.containsKey(dimKey2)) {
                bgData = (IBgNData)valueMap.get(dimKey2);
            } else {
                bgData = new BgNViewDataInfo();
                bgData.setFormula(formula);
                bgData.setBgItemNumber(parameter[0]);
                bgData.setBgPeriodNumber(parameter[1]);
                ((BgNDataInfo)bgData).setBgIndexNum(bgIndexNum);
                ((BgNDataInfo)bgData).setBgElementNumber(parameter[2]);
                ((BgNDataInfo)bgData).setCurrencyNumber(parameter[4]);
                bgData.setBgScenario(scenarioNum);
                bgData.setBgVersion(versionNum);
                bgData.setBgDataSource(1);
            }
            DimUtils.setValue(bgData, numeric, valueType, scenObjMap);
            if (hasBudget) {
                if (hasEnd && endNumber.contains(bgIndexNum)) {
                    endKey = parameter[0] + "_" + parameter[2] + "_" + parameter[3] + "_" + parameter[4] + "_" + bgData.getBgVersion();
                    if (endPeriodMap.containsKey(endKey)) {
                        periodMap = (Map)endPeriodMap.get(endKey);
                    } else {
                        periodMap = new HashMap();
                        endPeriodMap.put(endKey, periodMap);
                    }
                    if (periodMap.containsKey(bgData.getBgPeriodNumber())) {
                        bgPeriodData = (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                    } else {
                        bgPeriodData = new BgPeriodData();
                        bgPeriodData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                        periodMap.put(bgPeriodData.getBgPeriodNumber(), bgPeriodData);
                    }
                    parentNumber = this.getParameter().getBgPeriodParentMap().get(bgData.getBgPeriodNumber());
                    if (periodMap.containsKey(parentNumber)) {
                        bgPeriodData = (BgPeriodData)periodMap.get(parentNumber);
                    } else {
                        bgPeriodData = new BgPeriodData();
                        bgPeriodData.setBgPeriodNumber(parentNumber);
                        periodMap.put(parentNumber, bgPeriodData);
                    }
                    childData = periodMap.containsKey(bgData.getBgPeriodNumber()) ? (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber()) : new BgPeriodData();
                    childData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                    childData.setBgData(bgData);
                    bgPeriodData.getChild().add(childData);
                } else if (hasOpening && openingNumber.contains(bgIndexNum)) {
                    endKey = parameter[0] + "_" + parameter[2] + "_" + parameter[3] + "_" + parameter[4] + "_" + bgData.getBgVersion();
                    if (openPeriodMap.containsKey(endKey)) {
                        periodMap = (Map)openPeriodMap.get(endKey);
                    } else {
                        periodMap = new HashMap();
                        openPeriodMap.put(endKey, periodMap);
                    }
                    if (periodMap.containsKey(bgData.getBgPeriodNumber())) {
                        bgPeriodData = (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                    } else {
                        bgPeriodData = new BgPeriodData();
                        bgPeriodData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                        bgPeriodData.setBgData(bgData);
                        periodMap.put(bgPeriodData.getBgPeriodNumber(), bgPeriodData);
                    }
                    parentNumber = this.getParameter().getBgPeriodParentMap().get(bgData.getBgPeriodNumber());
                    if (periodMap.containsKey(parentNumber)) {
                        bgPeriodData = (BgPeriodData)periodMap.get(parentNumber);
                    } else {
                        bgPeriodData = new BgPeriodData();
                        bgPeriodData.setBgPeriodNumber(parentNumber);
                        periodMap.put(parentNumber, bgPeriodData);
                    }
                    childData = periodMap.containsKey(bgData.getBgPeriodNumber()) ? (BgPeriodData)periodMap.get(bgData.getBgPeriodNumber()) : new BgPeriodData();
                    childData.setBgPeriodNumber(bgData.getBgPeriodNumber());
                    childData.setBgData(bgData);
                    bgPeriodData.getChild().add(childData);
                }
            }
            valueMap.put(dimKey2, bgData);
        }
        HashSet<String> removeKey = new HashSet<String>();
        this.checkPeriodAlgorithmValue(openPeriodMap, this.getParameter().getValueType(), removeKey, this.getParameter().getOpenningPeriodMap());
        this.checkPeriodAlgorithmValue(endPeriodMap, this.getParameter().getValueType(), removeKey, this.getParameter().getEndingPeriodMap());
        Iterator it = multiDataMap.values().iterator();
        while (it.hasNext()) {
            this.checkValueMap((Map)it.next(), removeKey);
        }
        return resultMap;
    }

    protected String getNumber(int index, String[] rowData, String[] viewData) {
        return index >= rowData.length ? viewData[index] : rowData[index];
    }

    protected String getItemNumber(int[] itemIndex, String[] rowData, String[] viewData) {
        StringBuffer number = new StringBuffer();
        for (int i = 0; i < itemIndex.length; ++i) {
            number.append(this.getNumber(itemIndex[i], rowData, viewData) + ",");
        }
        if (number.length() > 0) {
            number.setLength(number.length() - 1);
        }
        return number.toString();
    }

    class ResultParam {
        public List views = null;

        ResultParam() {
        }
    }
}

