/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.olap.face.IDataFilter;
import com.kingdee.eas.ma.mbg.app.olap.face.IDimCheck;
import com.kingdee.eas.ma.mbg.app.olap.face.ISchemeCube;
import com.kingdee.eas.ma.mbg.app.olap.utils.CubeUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SchemeCube
implements ISchemeCube {
    private static Logger logger = Logger.getLogger(SchemeCube.class);
    private IDataFilter filter = null;
    private IDimCheck check = null;

    public SchemeCube() {
        this.setFilter(this.createDataFilter());
        this.setCheck(this.createDimCheck());
    }

    @Override
    public void setFilter(IDataFilter filter) {
        this.filter = filter;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public abstract IDataFilter createDataFilter();

    @Override
    public void setCheck(IDimCheck check) {
        this.check = check;
    }

    @Override
    public IDimCheck getCheck() {
        return this.check;
    }

    public abstract IDimCheck createDimCheck();

    @Override
    public Map<String, String> transCubeParams(Context ctx, Connection pConn, IDimensionParameter parameter) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ctx == null || pConn == null || parameter == null) {
            return params;
        }
        long begin = System.currentTimeMillis();
        logger.debug((Object)"begin transCubeParams!");
        if (parameter.getDataManager().getOptimizeParams() != null) {
            params.putAll(parameter.getDataManager().getOptimizeParams());
        }
        BgSchemeInfo bgScheme = null;
        if (parameter.getDataManager().getBgScheme() == null) {
            bgScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, parameter.getBgSchemeId());
            parameter.getDataManager().setBgScheme(bgScheme);
        } else {
            bgScheme = parameter.getDataManager().getBgScheme();
        }
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        params.put(DimensionConstants.DATA_VALUE_TYPE, String.valueOf(parameter.getValueType()));
        params.put(DimensionConstants.IS_AUDIT_BUDGET, String.valueOf(parameter.isAuditBudgetData()));
        if (parameter.getControlManager().isAdjust()) {
            params.put(DimensionConstants.DATA_TABLE_FIELD, Boolean.TRUE.toString());
        }
        try {
            IDimension dimension;
            conn = BgDBUtils.getConnection((Context)ctx);
            BOSUuid _orgUnitId = null;
            if (parameter.getOrgUnitId() != null) {
                _orgUnitId = parameter.getOrgUnitId();
            } else {
                Set<String> orgUnitSet = parameter.getQueryOrgIds();
                Iterator<String> iterator = orgUnitSet.iterator();
                if (iterator.hasNext()) {
                    String orgid = iterator.next();
                    _orgUnitId = BOSUuid.read((String)orgid);
                }
            }
            String[] mbgOrgTables = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)parameter.getBgOrgViewId(), (BOSUuid)_orgUnitId, (BOSUuid)parameter.getUnionId());
            String mbgOrgFact = null;
            if (mbgOrgTables != null) {
                mbgOrgFact = mbgOrgTables[2];
                mbgOrgFact = mbgOrgTables[0];
                if (parameter.getDataManager().getOrgFactTable() != null && parameter.getOrgUnitId() != null) {
                    mbgOrgFact = parameter.getDataManager().getOrgFactTable();
                }
            }
            if (parameter.getUnionId() != null) {
                mbgOrgFact = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)parameter.getUnionId());
            }
            params.put(DimensionConstants.ORGUNIT_FACT_TABLENAME, mbgOrgFact);
            String orgTmpTable = null;
            boolean isMultiProcessType = parameter.getControlManager().isMultiProcessType();
            if (!(DimensionCommonHelper.isDecompose(parameter.getValueType()) && !isMultiProcessType || mbgOrgTables == null || parameter.getBgOrgViewId() == null || parameter.getOrgUnitId() == null || parameter.getUnionId() != null || parameter.getDataManager().getBgOrgUnit() == null || parameter.getDataManager().getBgOrgUnit().isIsLeaf())) {
                orgTmpTable = CubeUtils.getOrgTmpTable(ctx, pConn, parameter, mbgOrgTables);
            } else if (parameter.isOrgLongNumber()) {
                orgTmpTable = CubeUtils.getOrgTmpTable(ctx, pConn, parameter, mbgOrgTables);
            }
            if (DimensionCommonHelper.isDecompose(parameter.getValueType()) || isMultiProcessType) {
                StringBuffer orgIds;
                if (!StringUtils.isEmpty((String)orgTmpTable)) {
                    params.put(DimensionConstants.DATA_ORG_SQL, (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + "FOrgUnitID IN (select FID from " + orgTmpTable + ")");
                } else {
                    params.put(DimensionConstants.DATA_ORG_SQL, (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + "FOrgUnitID  = '" + parameter.getOrgUnitId() + "'");
                }
                if (parameter.getQueryOrgDecompIds() != null && !parameter.getQueryOrgDecompIds().isEmpty()) {
                    orgIds = new StringBuffer();
                    for (String string : parameter.getQueryOrgDecompIds()) {
                        if (orgIds.length() > 0) {
                            orgIds.append(", ");
                        }
                        orgIds.append("'").append(string).append("'");
                    }
                    params.put(DimensionConstants.DECOMP_ORG_SQL, (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + "FOrgUnitID  IN (" + orgIds + ")");
                } else if (parameter.getOrgUnitId() != null) {
                    params.put(DimensionConstants.DECOMP_ORG_SQL, (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + "FOrgUnitID  = '" + parameter.getOrgUnitId() + "'");
                } else {
                    orgIds = new StringBuffer();
                    for (String string : parameter.getQueryOrgIds()) {
                        if (orgIds.length() > 0) {
                            orgIds.append(", ");
                        }
                        orgIds.append("'").append(string).append("'");
                    }
                    params.put(DimensionConstants.DECOMP_ORG_SQL, (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + "FOrgUnitID IN (" + orgIds + ")");
                }
            }
            params.put(DimensionConstants.DATA_TABLE_SQL_GROUP, Boolean.TRUE.toString());
            StringBuffer sql = new StringBuffer();
            if (StringUtils.isEmpty((String)orgTmpTable)) {
                if (parameter.getOrgUnitId() == null && parameter.getQueryOrgIds() != null && !parameter.getQueryOrgIds().isEmpty()) {
                    StringBuffer orgSql = new StringBuffer();
                    for (String id : parameter.getQueryOrgIds()) {
                        if (orgSql.length() > 0) {
                            orgSql.append(", ");
                        }
                        orgSql.append("'").append(id).append("'");
                    }
                    sql.append("select * from " + DimensionConstants.CUBE_NAME + " where " + (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + " FOrgUnitID IN(" + orgSql + ")");
                    params.put(DimensionConstants.DATA_TABLE_SQL_GROUP, Boolean.FALSE.toString());
                } else {
                    String orgUnitId = parameter.getOrgUnitId().toString();
                    sql.append("select * from " + DimensionConstants.CUBE_NAME + " where " + (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + " FOrgUnitID  = '" + orgUnitId + "'");
                    params.put(DimensionConstants.DATA_TABLE_SQL_GROUP, Boolean.FALSE.toString());
                    String string = DimensionBaseConstants.DEF_ORGUNIT_FIELD + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER;
                    params.put(string, orgTmpTable);
                }
            } else {
                sql.append("select * from " + DimensionConstants.CUBE_NAME + " where " + (parameter.getUnionId() != null ? " FUnionID = '" + parameter.getUnionId().toString() + "' and " : "") + " FOrgUnitID IN (select FID from " + orgTmpTable + ")");
                params.put(DimensionConstants.ORG_TMP_TABLE, orgTmpTable);
                if (parameter.isUseAccInt() && BgDBUtils.existColumn((Connection)pConn, (String)orgTmpTable, (String)"FIntID") != BgDBUtils.YES) {
                    BgDBUtils.executeUpdate((Connection)pConn, (String)("Alter Table " + orgTmpTable + " Add FIntID INT"));
                }
                BgDBUtils.executeUpdate((Connection)pConn, (String)("Update " + orgTmpTable + " t0 Set FIntID = (Select FIntId FROM T_MBG_BgOrgUnit Where FViewId = ? and FIsVirtual = 0 AND FOrgUnitId = t0.FID)"), (Object[])new Object[]{parameter.getBgOrgViewId().toString()});
            }
            if (parameter.getControlManager().isControlData() && !(dimension = DimUtils.getDimension(parameter.getDims(), DimensionBaseConstants.DEF_ACCOUNT_NUMBER)).getDimensionMember().isEmpty()) {
                if (parameter.isUseAccInt()) {
                    sql.append(" and F2 IN (Select FIntId FROM T_MBG_BgAccount Where FBgAccountViewId = '" + parameter.getDataManager().getBgScheme().getViewId(DimensionConstants.DEF_ACCOUNT_NUMBER) + "' and Fnumber IN(select FNumber from " + (String)params.get(DimensionConstants.BGINDEX_FACT_TABLE) + " where (");
                } else {
                    sql.append(" and F2 IN (select FDimNumber from " + (String)params.get(DimensionConstants.BGINDEX_FACT_TABLE) + " where (");
                }
                for (IMember member : dimension.getDimensionMember()) {
                    sql.append("(FDimNumber = '" + member.getDimNumber() + "' OR FDimLongNumber LIKE '" + member.transMdxNumber() + "!%') OR ");
                }
                if (sql.length() > 0) {
                    sql.delete(sql.length() - 4, sql.length());
                }
                sql.append("))");
                if (parameter.isUseAccInt()) {
                    sql.append(")");
                }
            }
            params.put(DimensionConstants.DATA_TABLE_SQL, sql.toString());
            if (parameter.getValueType() == 2 || parameter.getValueType() == 8) {
                params.put(DimensionConstants.DEF_STATE_NUMBER, DimensionConstants.DEF_STATE_NUMBER);
            }
            if (!parameter.getDataManager().getCustomState().isEmpty()) {
                String _state = "";
                for (Integer state : parameter.getDataManager().getCustomState()) {
                    _state = _state + String.valueOf(state) + ",";
                }
                _state = _state.substring(0, _state.length() - 1);
                params.put(DimensionConstants.DATA_CUSTOM_STATE, _state);
            }
            if (parameter.getControlManager().isFiscalYear()) {
                params.put(DimensionConstants.PERIOD_FISCALYEAR, String.valueOf(true));
            }
            logger.debug((Object)("end transCubeParams! use = " + (System.currentTimeMillis() - begin) + " ms."));
        }
        catch (Exception ex) {
            logger.error((Object)"prep Olap Properties SQL Error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return params;
    }
}

