/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.kdolap;

import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcExpreUtils;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapFunDef;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.ExpressValues;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Member;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Evaluator;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.FunCall;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.Literal;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.Calc;
import com.kingdee.eas.ma.mbg.streamwork.cuba.mdx.calc.impl.AbstractCalc;
import java.util.HashMap;

class CalcBizExpressCalc
extends AbstractCalc {
    public CalcBizExpressCalc(FunCall exp) {
        super(exp);
    }

    @Override
    public Object evaluate(Evaluator evaluator) throws CUBAException {
        ExpressValues expressValues = KDOlapFunDef.expressMap.get(Thread.currentThread());
        if (expressValues == null) {
            return null;
        }
        HashMap<String, String> memberMap = new HashMap<String, String>();
        String srcNumber = null;
        String number = null;
        String dimNumber = null;
        String orgNumber = null;
        for (Member member : evaluator.getCurrentMembers()) {
            srcNumber = null;
            number = member.getName();
            dimNumber = member.getDimension().getName();
            if ("orgUnit".equals(dimNumber)) {
                srcNumber = DimensionConstants.DEF_ORGUNIT_SRCNUMBER;
                orgNumber = number;
            } else if ("period".equals(dimNumber)) {
                srcNumber = DimensionConstants.DEF_PERIOD_SRCNUMBER;
            } else if ("element".equals(dimNumber)) {
                srcNumber = DimensionConstants.DEF_ELEMENT_SRCNUMBER;
            } else if ("currency".equals(dimNumber)) {
                srcNumber = DimensionConstants.DEF_CURRENCY_SRCNUMBER;
            } else if ("scenario".equals(dimNumber)) {
                srcNumber = DimensionConstants.DEF_SCENARIO_SRCNUMBER;
            } else if ("version".equals(dimNumber)) {
                srcNumber = DimensionConstants.DEF_VERSION_SRCNUMBER;
            } else {
                srcNumber = DimUtils.getSrcNumber(member.getName());
                number = DimUtils.getNumber(member.getName());
            }
            memberMap.put(srcNumber, number);
        }
        FunCall call = (FunCall)this.exp;
        Literal arg = (Literal)call.getArg(0);
        String o = (String)arg.getValueObject();
        String express = o.replaceAll("'", "\"").replaceAll(":`", ":[").replaceAll("`", "]");
        IDimensionParameter parameter = expressValues.parameter;
        if (parameter != null && orgNumber == null) {
            String localOrgNum = parameter.getLocalOrgNum();
            memberMap.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, localOrgNum);
        }
        BizCalcExpreUtils calcUtils = new BizCalcExpreUtils(expressValues.ctx, expressValues.conn, expressValues.parameter);
        try {
            return calcUtils.calcExpressValue(memberMap, express, expressValues);
        }
        catch (Exception e) {
            throw new CUBAException("CalcBizExpress exception", e);
        }
    }

    @Override
    public Calc[] getCalcs() {
        return null;
    }
}

