/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.kdolap;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.app.olap.face.IMDXStrategy;
import com.kingdee.eas.ma.mbg.app.olap.face.IResultStrategy;
import com.kingdee.eas.ma.mbg.app.olap.impl.MDXStrategy;
import com.kingdee.eas.ma.mbg.app.olap.impl.OlapService;
import com.kingdee.eas.ma.mbg.app.olap.impl.QueryStrategy;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapFunDef;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapResultStrategy;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAConfig;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBADriver;
import com.kingdee.eas.ma.mbg.streamwork.cuba.Connection;
import com.kingdee.eas.ma.mbg.streamwork.cuba.MdxResult;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KDOlapQueryStrategy
extends QueryStrategy {
    private static Logger logger = Logger.getLogger(KDOlapQueryStrategy.class);
    private final String SEPARATOR_LEFT_STR = "\\[";
    private final String SEPARATOR_RIGTH_STR = "\\]";
    private final String SEPARATOR_STR = "\\`";

    public KDOlapQueryStrategy(OlapService service) {
        super(service);
    }

    @Override
    public IMDXStrategy createMdxStrategy() {
        return new MDXStrategy();
    }

    @Override
    public IResultStrategy createRstStrategy() {
        return new KDOlapResultStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> query(Context ctx, java.sql.Connection pConn, IDimensionParameter parameter, Map<String, Object> olapParamsMap) throws Exception {
        Map<String, Object> bgDataMap = new HashMap<String, Object>();
        if (ctx == null || parameter == null || olapParamsMap == null) {
            return bgDataMap;
        }
        Map cubeParam = (Map)olapParamsMap.get(DimensionConstants.OLAP_SCHEME);
        if (cubeParam == null) {
            return bgDataMap;
        }
        KDOlapFunDef.defineMyFun();
        if (parameter.getExpressValues() != null) {
            KDOlapFunDef.expressMap.put(Thread.currentThread(), parameter.getExpressValues());
        }
        String mdx = null;
        InputStream input = null;
        Connection olapConn = null;
        MdxResult rst = null;
        CUBAConfig config = new CUBAConfig();
        config.supportSelfData = true;
        config.useSelfData = false;
        config.BUILD_AUTOJOINFACTSQL = false;
        if (128 != parameter.getValueType() && 64 != parameter.getValueType() || parameter.getUnionId() != null) {
            // empty if block
        }
        try {
            olapParamsMap.put("JdbcConnection", pConn);
            String cubeScheme = this.getService().getSchemeCube().getSchemeCube(ctx, pConn, cubeParam, olapParamsMap, parameter);
            input = new ByteArrayInputStream(cubeScheme.getBytes());
            this.getDebug().debugBegin("begin get Connection");
            olapConn = CUBADriver.openConnection(input, olapParamsMap, config);
            this.getDebug().debugUseTime("end get Connection");
            if (parameter.getBgTemplateId() != null && parameter.getBgTemplateId().length > 0) {
                IRowSet res = null;
                try {
                    if (BgDBUtils.existColumn((java.sql.Connection)pConn, (String)"T_MBG_BgTemplate", (String)"FIsLeafBeforeCalc") == BgDBUtils.YES && (res = BgDBUtils.executeQuery((java.sql.Connection)pConn, (String)"Select FIsLeafBeforeCalc FROM T_MBG_BgTemplate Where FID = ?", (Object[])new Object[]{String.valueOf(parameter.getBgTemplateId()[0])})).next()) {
                        olapConn.setLeafBeforeCalc(res.getBoolean("FIsLeafBeforeCalc"));
                    }
                }
                finally {
                    SQLUtils.cleanup(res);
                }
            }
            try {
                this.getMdxStrategy().transCalcMdx(ctx, parameter);
                mdx = this.getMdxStrategy().transMdx(ctx, parameter);
                if (mdx != null) {
                    mdx = mdx.replaceAll("\\[", "\\`").replaceAll("\\]", "\\`");
                }
                if (!StringUtils.isEmpty((String)mdx)) {
                    rst = olapConn.executeMdxQuery(mdx, parameter.getDataManager().getMdxFilters(parameter));
                    bgDataMap = this.getRstStrategy().transResult(ctx, parameter, rst, bgDataMap);
                }
                if (!parameter.getQuerys().isEmpty()) {
                    IQueryData query = null;
                    int in = parameter.getQuerys().size();
                    for (int i = 0; i < in; ++i) {
                        query = parameter.getQuerys().get(i);
                        mdx = this.getMdxStrategy().transMdx(ctx, parameter, query);
                        if (mdx != null) {
                            mdx = mdx.replaceAll("\\[", "\\`").replaceAll("\\]", "\\`");
                        }
                        if (StringUtils.isEmpty((String)mdx)) continue;
                        rst = olapConn.executeMdxQuery(mdx, query.getMdxFilters(parameter));
                        bgDataMap = this.getRstStrategy().transResult(ctx, parameter, query, rst, bgDataMap);
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Object)("dimense Query Error:" + mdx));
                logger.error((Object)"dimense Query Error:", (Throwable)ex);
                throw ex;
            }
            finally {
                if (rst != null) {
                    rst.close();
                }
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (olapConn != null) {
                try {
                    olapConn.close();
                }
                catch (Exception exception) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            KDOlapFunDef.expressMap.remove(Thread.currentThread());
            parameter.removeLocalOrgNum();
        }
        if (bgDataMap != null && bgDataMap.size() <= 1000) {
            logger.error((Object)("KDOlapQueryStrategy query bgDataMap:" + bgDataMap));
        }
        return bgDataMap;
    }
}

