/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.kdolap;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.AccIntOlapBatchTable;
import com.kingdee.eas.ma.mbg.app.olap.face.IDataFilter;
import com.kingdee.eas.ma.mbg.app.olap.face.IDimCheck;
import com.kingdee.eas.ma.mbg.app.olap.impl.DataFilter;
import com.kingdee.eas.ma.mbg.app.olap.impl.DimensionCheck;
import com.kingdee.eas.ma.mbg.app.olap.impl.SchemeCube;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapBatchTable;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapPastDataBatchTable;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimDataUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.streamwork.cuba.CUBAException;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

public class KDOlapSchemeCube
extends SchemeCube {
    private static final Logger logger = Logger.getLogger(KDOlapSchemeCube.class);
    private boolean hasAuditDataState = false;
    private boolean hasAdjustData = false;
    private BOSUuid singleOrgId = null;
    private String FACT_NAME = "budgetFact";

    @Override
    public IDataFilter createDataFilter() {
        return new DataFilter();
    }

    @Override
    public IDimCheck createDimCheck() {
        return new DimensionCheck();
    }

    @Override
    public Map<String, String> transCubeParams(Context ctx, Connection pConn, IDimensionParameter parameter) throws Exception {
        this.setSingleOrgId(parameter.getOrgUnitId());
        Map<String, String> params = super.transCubeParams(ctx, pConn, parameter);
        return params;
    }

    public void setHasAuditDataState(boolean hasAuditDataState) {
        this.hasAuditDataState = hasAuditDataState;
    }

    public boolean isHasAuditDataState() {
        return this.hasAuditDataState;
    }

    public void setHasAdjustData(boolean hasAdjustData) {
        this.hasAdjustData = hasAdjustData;
    }

    public boolean isHasAdjustData() {
        return this.hasAdjustData;
    }

    public void setSingleOrgId(BOSUuid singleOrgId) {
        this.singleOrgId = singleOrgId;
    }

    public BOSUuid getSingleOrgId() {
        return this.singleOrgId;
    }

    private void verdictParams(Map<String, String> params) throws Exception {
        int valueType;
        if (params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String type = params.get(DimensionConstants.DATA_VALUE_TYPE);
        String isbudgetData = params.get(DimensionConstants.IS_AUDIT_BUDGET);
        boolean isAuditBudgetData = StringUtils.isEmpty((String)isbudgetData) ? true : Boolean.valueOf(isbudgetData);
        int n = valueType = StringUtils.isEmpty((String)type) ? 1 : Integer.valueOf(type);
        if (DimDataUtils.hasType(valueType, 2) || DimDataUtils.hasType(valueType, 8) && isAuditBudgetData) {
            this.setHasAuditDataState(true);
        }
        String dataField = params.get(DimensionConstants.DATA_TABLE_FIELD);
        String dataType = params.get(DimensionConstants.DATA_VALUE_TYPE);
        this.setHasAdjustData(false);
        if ((String.valueOf(2).equals(dataType) || String.valueOf(1).equals(dataType) || String.valueOf(256).equals(dataType) || String.valueOf(1024).equals(dataType)) && Boolean.valueOf(dataField).booleanValue()) {
            this.setHasAdjustData(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemeCube(Context ctx, Connection pConn, Map<String, String> params, Map<String, Object> olapParamsMap, IDimensionParameter parameter) throws Exception {
        if (params == null) {
            return null;
        }
        this.verdictParams(params);
        ByteArrayOutputStream os = null;
        XMLStreamWriter writer = null;
        String scheme = null;
        try {
            os = new ByteArrayOutputStream();
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(DimensionConstants.SCHEME);
            writer.writeAttribute(DimensionConstants.NAME, "KDOLAP");
            if (parameter.getUnionId() == null && parameter.isUseAccInt() && (DimensionCommonHelper.getProcessEnum(parameter.getValueType()).getValue() == 1 || DimUtils.isMultiProcessType(params))) {
                this.outAccIntTable(pConn, writer, params, olapParamsMap, parameter);
            } else {
                this.outTable(pConn, writer, params, olapParamsMap, parameter);
            }
            if (parameter.isAdjustPastData()) {
                this.outAdjustTable(ctx, pConn, olapParamsMap, parameter);
            }
            this.dimensionOrgUnit(writer, params, parameter);
            this.dimensionItem(writer, params);
            this.dimensionPeriod(writer, params, parameter);
            this.dimensionElement(writer, params);
            this.dimensionCurrency(writer, params);
            this.dimensionScenario(writer, params);
            this.dimensionVersion(writer, params);
            this.dimensionState(writer, params);
            this.dimensionProcessType(writer, params);
            this.schemeCube(writer, params);
            this.relation(writer, params);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            scheme = ((Object)os).toString();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        return scheme;
    }

    private void outAdjustTable(Context ctx, Connection pConn, Map<String, Object> olapParamsMap, IDimensionParameter parameter) throws Exception {
        if (olapParamsMap.get(this.FACT_NAME) instanceof KDOlapBatchTable) {
            KDOlapBatchTable table = (KDOlapBatchTable)olapParamsMap.get(this.FACT_NAME);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String[] columnNames = table.getColumnNames();
            String tmpTable = pool.createTempTable(this.createTmpTableSql(table));
            BgDBUtils.executeBatch((Connection)pConn, (String)("insert into " + tmpTable + " " + table.getSql()), table.getParamList());
            StringBuffer buffer = new StringBuffer();
            buffer.append(" select ");
            for (String columnName : columnNames) {
                if (!"FTMPVALUE".equals(columnName) && !"FVALUE".equals(columnName)) {
                    buffer.append(" tmp.").append(columnName).append(" As ").append(columnName).append(",");
                    continue;
                }
                buffer.append(" sum(past.FPASTVALUE) As FVALUE").append(" ,");
            }
            buffer.delete(buffer.length() - 1, buffer.length());
            buffer.append(" from T_MBG_bgPastData past inner join " + tmpTable + " tmp on past.FBgDataID = tmp.FID group by ");
            for (String columnName : columnNames) {
                if ("FTMPVALUE".equals(columnName) || "FVALUE".equals(columnName)) continue;
                buffer.append(" tmp.").append(columnName).append(",");
            }
            buffer.delete(buffer.length() - 1, buffer.length());
            KDOlapPastDataBatchTable pastDataTable = new KDOlapPastDataBatchTable();
            pastDataTable.setConn(pConn);
            pastDataTable.setSql(buffer.toString());
            olapParamsMap.put(this.FACT_NAME, pastDataTable);
            parameter.getTempTableManager(ctx).getTempTables().add(tmpTable);
        }
    }

    private String createTmpTableSql(KDOlapBatchTable table) throws CUBAException {
        String[] columnNames = table.getColumnNames();
        StringBuffer createSql = new StringBuffer();
        createSql.append(" create table T_MBG_TMPLBGDATA( ");
        for (String columnName : columnNames) {
            int columnType = table.getColumnType(table.getColumnIndex(columnName.toUpperCase()));
            createSql.append(columnName).append(" " + this.getFieldType(columnType)).append(",");
        }
        createSql.delete(createSql.length() - 1, createSql.length());
        createSql.append(" )");
        return createSql.toString();
    }

    private String getFieldType(int columnType) {
        switch (columnType) {
            case 2: {
                return "NUMERIC(21,6)";
            }
            case 12: {
                return "Varchar(44)";
            }
            case 93: {
                return "DateTime";
            }
        }
        return "Varchar(44)";
    }

    protected void outAccIntTable(Connection pConn, XMLStreamWriter writer, Map<String, String> params, Map<String, Object> olapParamsMap, IDimensionParameter parameter) throws Exception {
        boolean hasBudget;
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String defCurrencyId = null;
        String defElementId = null;
        String defVersionId = null;
        String defScenarioId = null;
        String cslNums = null;
        if (params.containsKey(DimensionConstants.REMOVE_CURRENCY)) {
            defCurrencyId = params.get(DimensionConstants.REMOVE_CURRENCY_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_ELEMENT)) {
            defElementId = params.get(DimensionConstants.REMOVE_ELEMENT_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_VERSION)) {
            defVersionId = params.get(DimensionConstants.REMOVE_VERSION_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_SCENARIO)) {
            defScenarioId = params.get(DimensionConstants.REMOVE_SCENARIO_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_CSL)) {
            cslNums = params.get(DimensionConstants.REMOVE_CSL_MEMBER);
        }
        int valueType = Integer.valueOf(params.get(DimensionConstants.DATA_VALUE_TYPE));
        boolean hasUnion = false;
        if ((valueType == 16 || valueType == 32 || valueType == 2048) && (hasBudget = Boolean.valueOf(params.get(DimensionConstants.SCENARIO_BUDGET)).booleanValue())) {
            hasUnion = true;
        }
        boolean hasGroup = false;
        String GroupStr = params.get(DimensionConstants.DATA_TABLE_SQL_GROUP);
        if (GroupStr != null && Boolean.valueOf(GroupStr).booleanValue()) {
            hasGroup = true;
        }
        boolean hasFilter = params.containsKey(DimensionConstants.MEMBER_FILTER);
        String cubeName = params.get(DimensionConstants.TABLE_NAME);
        String baseCubeName = parameter.getDataManager().getBgScheme().getRefCube();
        String otherCubeName = null;
        Boolean isMultiProcessType = DimUtils.isMultiProcessType(params);
        if ((hasUnion || isMultiProcessType.booleanValue()) && (otherCubeName = params.get(DimensionConstants.TABLE_CUBE)).equals(baseCubeName)) {
            String tmp = cubeName;
            cubeName = otherCubeName;
            otherCubeName = tmp;
        }
        String cType = DimUtils.getCurProcessType(cubeName);
        String refFieldStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_REFFIELD));
        String fieldValue = "FVALUE";
        if (this.isHasAdjustData() && this.checkHasBudget(params)) {
            fieldValue = "FTMPVALUE";
        }
        String tmpBgIndexTable = params.get(DimensionConstants.BGINDEX_FILTER);
        String defSql = "";
        ArrayList<String> defIds = new ArrayList<String>();
        ArrayList<Object> defintIds = new ArrayList<Object>();
        if (defCurrencyId != null) {
            defSql = defSql + " and FCurrencyID = ? ";
            defIds.add(defCurrencyId);
            defintIds.add(defCurrencyId);
        }
        if (defElementId != null) {
            defSql = defSql + " and FBgElementID = ? ";
            defIds.add(defElementId);
            defintIds.add(parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_ELEMENT_FIELD).get(defElementId));
        }
        if (defScenarioId != null) {
            defSql = defSql + " and FSCENARIO = ? ";
            defIds.add(defScenarioId);
            defintIds.add(defScenarioId);
        }
        if (defVersionId != null) {
            defSql = defSql + " and FVERSION = ? ";
            defIds.add(defVersionId);
            defintIds.add(defVersionId);
        }
        if (cslNums != null) {
            defSql = defSql + " and F100 IN " + cslNums + " ";
        }
        String sql = null;
        if (params.containsKey(DimensionConstants.DATA_TABLE_SQL)) {
            Object union = null;
            sql = params.get(DimensionConstants.DATA_TABLE_SQL);
            AccIntOlapBatchTable batchTable = null;
            String closureTable = null;
            if (tmpBgIndexTable != null) {
                closureTable = params.get(DimensionConstants.BGINDEX_CLOSURE_TABLE);
                if (closureTable != null) {
                    logger.error((Object)("KDOlapSchemeCube outAccIntTable TmpTable:" + Arrays.toString(MbgSqlHelper.executeBatchQuery((Connection)pConn, (String)("select FNumber from " + tmpBgIndexTable), null).toArray())));
                    HashSet indexNumbers = new HashSet(MbgSqlHelper.executeQuery((Connection)pConn, (String)("select FChildId from " + closureTable + " where exists (select FNumber from " + tmpBgIndexTable + " where FNumber = " + closureTable + ".FID)"), null));
                    HashMap<String, List<Object[]>> paramList = new HashMap<String, List<Object[]>>();
                    int batchCount = 50;
                    if (baseCubeName.equals(cubeName)) {
                        HashSet indexInts = new HashSet();
                        Map<String, Integer> intMap = parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_BGINDEX_FIELD);
                        logger.error((Object)("KDOlapSchemeCube outAccIntTable indexNumbers:" + Arrays.toString(indexNumbers.toArray())));
                        batchTable = new AccIntOlapBatchTable();
                        batchTable.setAdjustPastData(parameter.isAdjustPastData());
                        batchTable.setConn(pConn);
                        batchTable.setBaseCube(parameter.getDataManager().getBgScheme().getRefCube());
                        batchTable.setDimIntMap(parameter.getDataManager().getDimIntMap(), parameter.getDataManager().getFieldSrcMap());
                        if (parameter.getQueryOrgIds() != null && !parameter.getQueryOrgIds().isEmpty()) {
                            for (String string : parameter.getQueryOrgIds()) {
                                batchTable.getOrgIntMap().put(string, parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_ORGUNIT_FIELD).get(string));
                            }
                        } else if (parameter.getOrgUnitId() != null) {
                            batchTable.getOrgIntMap().put(parameter.getOrgUnitId().toString(), parameter.getDataManager().getDimIntMap().get(DimensionConstants.DEF_ORGUNIT_FIELD).get(parameter.getOrgUnitId().toString()));
                        }
                        HashMap splitQuery = new HashMap();
                        for (String accNumber : indexNumbers) {
                            String refCube;
                            String number = DimensionFormulaHelper.getMemberNumber(accNumber);
                            if (!intMap.containsKey(number) || (refCube = parameter.getDataManager().getSplitMap().get(number)) == null) continue;
                            if (!splitQuery.containsKey(refCube)) {
                                splitQuery.put(refCube, new HashSet());
                            }
                            ((Set)splitQuery.get(refCube)).add(intMap.get(number));
                        }
                        for (String refCube : splitQuery.keySet()) {
                            paramList.put(refCube, MbgSqlHelper.getBatchParams(null, (Object[])((Set)splitQuery.get(refCube)).toArray(), (Object[])defintIds.toArray(), (int)batchCount));
                        }
                        if (paramList != null && !paramList.isEmpty()) {
                            for (List batchParams : paramList.values()) {
                                for (Object[] objs : batchParams) {
                                    for (int b = 0; b < objs.length; ++b) {
                                        if (!"#".equals(objs[b])) continue;
                                        objs[b] = -1;
                                    }
                                }
                            }
                        }
                    } else {
                        this.outTable(pConn, writer, params, olapParamsMap, parameter);
                        return;
                    }
                    if ((hasUnion || isMultiProcessType.booleanValue()) && !cubeName.equals(otherCubeName)) {
                        paramList.put(otherCubeName, MbgSqlHelper.getBatchParams(null, (Object[])indexNumbers.toArray(), (Object[])defIds.toArray(), (int)batchCount));
                    }
                    batchTable.setParamList(paramList);
                    if (indexNumbers.isEmpty() || paramList.isEmpty()) {
                        batchTable.setEmpty(true);
                    }
                } else {
                    throw new BgTemplateException(BgTemplateException.NEEDBGACC);
                }
            }
            if (!StringUtils.isEmpty((String)refFieldStr)) {
                refFieldStr = refFieldStr.replaceAll(";", ",");
                if (this.getSingleOrgId() == null || parameter.isOrgLongNumber()) {
                    refFieldStr = " FOrgUnitId, " + refFieldStr;
                }
                String repStr = null;
                repStr = hasGroup || hasFilter ? (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, sum(" + fieldValue + ") " + fieldValue : (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, " + fieldValue;
                if (isMultiProcessType.booleanValue()) {
                    repStr = repStr + ", '" + cType + "' as FProcessType ";
                }
                sql = sql.replaceAll("\\*", repStr);
                if (tmpBgIndexTable != null) {
                    if (batchTable == null) {
                        sql = sql + " and exists (select FChildId from " + closureTable + " where exists (select FNumber from " + tmpBgIndexTable + " where FNumber = " + closureTable + ".FID) AND " + cubeName + ".F2 = FChildId) ";
                    } else {
                        StringBuffer inSql = new StringBuffer();
                        MbgSqlHelper.addPlaceHolder((StringBuffer)inSql);
                        sql = sql + " and " + DimensionConstants.CUBE_NAME + ".F2 IN(" + inSql + ") ";
                    }
                }
                if (this.isHasAuditDataState()) {
                    sql = sql + " AND FState IN (9,11,13)";
                } else {
                    String customState = params.get(DimensionConstants.DATA_CUSTOM_STATE);
                    if (!StringUtils.isEmpty((String)customState)) {
                        sql = sql + " AND FState IN (" + customState + ")";
                    }
                }
                if (defSql.length() > 0) {
                    sql = sql + defSql;
                }
                if (hasGroup || hasFilter) {
                    sql = sql + " group by " + (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION";
                }
            }
            StringBuffer leafAndNoLeafSql = null;
            if ((parameter.getOrgUnitId() == null || parameter.isOrgLongNumber()) && params.get(DimensionConstants.ORG_TMP_TABLE) != null && !DimensionCommonHelper.isDecompose(valueType)) {
                HashSet<String> queryOrgIds = new HashSet<String>();
                if (parameter.getQueryOrgIds() != null && !parameter.getQueryOrgIds().isEmpty()) {
                    queryOrgIds.addAll(parameter.getQueryOrgIds());
                } else {
                    queryOrgIds.add(parameter.getOrgUnitId().toString());
                }
                boolean hasLeaf = false;
                boolean hasNoLeaf = false;
                HashSet noLeafOrgIds = new HashSet(MbgSqlHelper.executeQuery((Connection)pConn, (String)"select FOrgUnitId FROM T_MBG_BgOrgUnit Where FIsVirtual = 0 AND FIsLeaf = 0 AND FViewId = ?", (Object[])new Object[]{parameter.getBgOrgViewId().toString()}));
                for (String string : queryOrgIds) {
                    if (noLeafOrgIds.contains(string)) {
                        hasNoLeaf = true;
                        continue;
                    }
                    hasLeaf = true;
                }
                if (hasNoLeaf) {
                    String orgTmpTable = params.get(DimensionConstants.ORG_TMP_TABLE);
                    leafAndNoLeafSql = new StringBuffer();
                    if (hasLeaf) {
                        leafAndNoLeafSql.append(sql.toString().replace(orgTmpTable, orgTmpTable + " Where FID = FParentId AND FID NOT IN(Select FParentId FROM " + orgTmpTable + " Where FID <> FParentID)"));
                    }
                    for (String orgId : queryOrgIds) {
                        if (!noLeafOrgIds.contains(orgId)) continue;
                        if (leafAndNoLeafSql.length() > 0) {
                            leafAndNoLeafSql.append(" union all ");
                        }
                        leafAndNoLeafSql.append(sql.toString().replaceFirst("FOrgUnitId", "'" + orgId + "' FOrgUnitId").replace(orgTmpTable, orgTmpTable + " Where FParentId = '\"" + orgId + "'"));
                    }
                }
            }
            if (isMultiProcessType.booleanValue()) {
                if (params.containsKey(DimensionConstants.DECOMP_ORG_SQL) && params.containsKey(DimensionConstants.DATA_ORG_SQL)) {
                    sql = DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(cType)) ? sql.replace(params.get(DimensionConstants.DATA_ORG_SQL), params.get(DimensionConstants.DECOMP_ORG_SQL)) : sql.replace(params.get(DimensionConstants.DECOMP_ORG_SQL), params.get(DimensionConstants.DATA_ORG_SQL));
                }
                if (leafAndNoLeafSql != null) {
                    sql = leafAndNoLeafSql.toString();
                }
            } else if (leafAndNoLeafSql != null) {
                sql = leafAndNoLeafSql.toString();
            }
            if (batchTable == null) {
                writer.writeStartElement(DimensionConstants.TABLE);
                writer.writeAttribute(DimensionConstants.NAME, this.FACT_NAME);
                writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
                writer.writeEndElement();
            } else {
                writer.writeStartElement("Parameter");
                writer.writeAttribute(DimensionConstants.NAME, this.FACT_NAME);
                writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TABLE);
                writer.writeEndElement();
                batchTable.setName(this.FACT_NAME);
                batchTable.setSql(sql);
                int batchCount = sql.split("union all").length;
                if (batchCount > 1 && batchTable.getParamList() != null && !batchTable.getParamList().isEmpty()) {
                    ArrayList<Object[]> unionBatchParams = new ArrayList<Object[]>();
                    ArrayList<Object> result = new ArrayList<Object>();
                    ArrayList<Object> tmpList = null;
                    for (List<Object[]> list : batchTable.getParamList().values()) {
                        unionBatchParams.clear();
                        for (Object[] obj : list) {
                            result.clear();
                            tmpList = new ArrayList<Object>(Arrays.asList(obj));
                            for (int i = 0; i < batchCount; ++i) {
                                result.addAll(tmpList);
                            }
                            unionBatchParams.add(result.toArray());
                        }
                        list.clear();
                        list.addAll(unionBatchParams);
                    }
                }
                olapParamsMap.put(this.FACT_NAME, batchTable);
            }
        }
    }

    protected void outTable(Connection pConn, XMLStreamWriter writer, Map<String, String> params, Map<String, Object> olapParamsMap, IDimensionParameter parameter) throws Exception {
        boolean hasBudget;
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String defCurrencyId = null;
        String defElementId = null;
        String defVersionId = null;
        String defScenarioId = null;
        String cslNums = null;
        if (params.containsKey(DimensionConstants.REMOVE_CURRENCY)) {
            defCurrencyId = params.get(DimensionConstants.REMOVE_CURRENCY_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_ELEMENT)) {
            defElementId = params.get(DimensionConstants.REMOVE_ELEMENT_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_VERSION)) {
            defVersionId = params.get(DimensionConstants.REMOVE_VERSION_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_SCENARIO)) {
            defScenarioId = params.get(DimensionConstants.REMOVE_SCENARIO_MEMBER);
        }
        if (params.containsKey(DimensionConstants.REMOVE_CSL)) {
            cslNums = params.get(DimensionConstants.REMOVE_CSL_MEMBER);
        }
        int valueType = Integer.valueOf(params.get(DimensionConstants.DATA_VALUE_TYPE));
        boolean hasUnion = false;
        if ((valueType == 16 || valueType == 32 || valueType == 2048) && (hasBudget = Boolean.valueOf(params.get(DimensionConstants.SCENARIO_BUDGET)).booleanValue())) {
            hasUnion = true;
        }
        boolean hasGroup = false;
        String GroupStr = params.get(DimensionConstants.DATA_TABLE_SQL_GROUP);
        if (GroupStr != null && Boolean.valueOf(GroupStr).booleanValue()) {
            hasGroup = true;
        }
        boolean hasFilter = params.containsKey(DimensionConstants.MEMBER_FILTER);
        String cubeName = params.get(DimensionConstants.TABLE_NAME);
        String refFieldStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_REFFIELD));
        String fieldValue = "FVALUE";
        if (this.isHasAdjustData() && this.checkHasBudget(params)) {
            fieldValue = "FTMPVALUE";
        }
        String tmpBgIndexTable = params.get(DimensionConstants.BGINDEX_FILTER);
        Boolean isMultiProcessType = DimUtils.isMultiProcessType(params);
        String cType = DimUtils.getCurProcessType(cubeName);
        String sql = null;
        if (params.containsKey(DimensionConstants.DATA_TABLE_SQL)) {
            int batchCount;
            String union = null;
            sql = params.get(DimensionConstants.DATA_TABLE_SQL);
            sql = sql.replaceAll(DimensionConstants.CUBE_NAME, cubeName);
            KDOlapBatchTable batchTable = null;
            String closureTable = null;
            if (tmpBgIndexTable != null) {
                closureTable = params.get(DimensionConstants.BGINDEX_CLOSURE_TABLE);
                if (closureTable != null) {
                    logger.error((Object)("KDOlapSchemeCube outTable TmpTable:" + Arrays.toString(MbgSqlHelper.executeBatchQuery((Connection)pConn, (String)("select FNumber from " + tmpBgIndexTable), null).toArray())));
                    HashSet indexNumbers = new HashSet(MbgSqlHelper.executeQuery((Connection)pConn, (String)("select FChildId from " + closureTable + " where exists (select FNumber from " + tmpBgIndexTable + " where FNumber = " + closureTable + ".FID)"), null));
                    logger.error((Object)("KDOlapSchemeCube outTable indexNumbers:" + Arrays.toString(indexNumbers.toArray())));
                    batchCount = 50;
                    batchTable = new KDOlapBatchTable();
                    batchTable.setConn(pConn);
                    List batchParams = MbgSqlHelper.getBatchParams(null, (Object[])indexNumbers.toArray(), (int)batchCount);
                    batchTable.setParamList(batchParams);
                    if (indexNumbers.isEmpty()) {
                        batchTable.setEmpty(true);
                    }
                } else {
                    throw new BgTemplateException(BgTemplateException.NEEDBGACC);
                }
            }
            if (!StringUtils.isEmpty((String)refFieldStr)) {
                refFieldStr = refFieldStr.replaceAll(";", ",");
                if (this.getSingleOrgId() == null || parameter.isOrgLongNumber()) {
                    refFieldStr = " FOrgUnitId, " + refFieldStr;
                }
                String repStr = null;
                repStr = hasGroup || hasFilter ? (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, sum(" + fieldValue + ") " + fieldValue : (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION, " + fieldValue;
                if (isMultiProcessType.booleanValue()) {
                    repStr = repStr + ", '" + cType + "' as FProcessType ";
                }
                sql = sql.replaceAll("\\*", repStr);
                if (tmpBgIndexTable != null) {
                    if (batchTable == null) {
                        sql = sql + " and exists (select FChildId from " + closureTable + " where exists (select FNumber from " + tmpBgIndexTable + " where FNumber = " + closureTable + ".FID) AND " + cubeName + ".F2 = FChildId) ";
                    } else {
                        StringBuffer inSql = new StringBuffer();
                        MbgSqlHelper.addPlaceHolder((StringBuffer)inSql);
                        sql = sql + " and " + cubeName + ".F2 IN(" + inSql + ") ";
                    }
                }
                if (this.isHasAuditDataState()) {
                    sql = sql + " AND FState IN (9,11,13)";
                } else {
                    String customState = params.get(DimensionConstants.DATA_CUSTOM_STATE);
                    if (!StringUtils.isEmpty((String)customState)) {
                        sql = sql + " AND FState IN (" + customState + ")";
                    }
                }
                if (defCurrencyId != null) {
                    sql = sql + " and FCurrencyID = '" + defCurrencyId + "' ";
                }
                if (defElementId != null) {
                    sql = sql + " and FBgElementID = '" + defElementId + "' ";
                }
                if (defScenarioId != null) {
                    sql = sql + " and FSCENARIO = " + defScenarioId + " ";
                }
                if (defVersionId != null) {
                    sql = sql + " and FVERSION = " + defVersionId + " ";
                }
                if (cslNums != null) {
                    sql = sql + " and F100 IN " + cslNums + " ";
                }
                if (hasUnion) {
                    union = " union all " + sql.replaceAll(params.get(DimensionConstants.TABLE_NAME), params.get(DimensionConstants.TABLE_CUBE)) + " and FScenario in (select FSCENARIOID from T_MBG_BGSCENARIO where FTYPE = 0)";
                }
                if (hasGroup || hasFilter) {
                    sql = sql + " group by " + (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION";
                    if (hasUnion) {
                        union = union + " group by " + (parameter.isAdjustPastData() ? "FID, " : "") + refFieldStr + " FBgPeriodID, FBgElementID, FCurrencyID, FSCENARIO, FVERSION";
                    }
                }
            }
            if (hasUnion) {
                sql = sql + union;
            }
            StringBuffer leafAndNoLeafSql = null;
            if ((parameter.getOrgUnitId() == null || parameter.isOrgLongNumber()) && params.get(DimensionConstants.ORG_TMP_TABLE) != null && !DimensionCommonHelper.isDecompose(valueType)) {
                HashSet<String> queryOrgIds = new HashSet<String>();
                if (parameter.getQueryOrgIds() != null && !parameter.getQueryOrgIds().isEmpty()) {
                    queryOrgIds.addAll(parameter.getQueryOrgIds());
                } else {
                    queryOrgIds.add(parameter.getOrgUnitId().toString());
                }
                boolean hasLeaf = false;
                boolean hasNoLeaf = false;
                HashSet noLeafOrgIds = new HashSet(MbgSqlHelper.executeQuery((Connection)pConn, (String)"select FOrgUnitId FROM T_MBG_BgOrgUnit Where FIsVirtual = 0 AND FIsLeaf = 0 AND FViewId = ?", (Object[])new Object[]{parameter.getBgOrgViewId().toString()}));
                for (String string : queryOrgIds) {
                    if (noLeafOrgIds.contains(string)) {
                        hasNoLeaf = true;
                        continue;
                    }
                    hasLeaf = true;
                }
                if (hasNoLeaf) {
                    String orgTmpTable = params.get(DimensionConstants.ORG_TMP_TABLE);
                    leafAndNoLeafSql = new StringBuffer();
                    if (hasLeaf) {
                        leafAndNoLeafSql.append(sql.toString().replace(orgTmpTable, orgTmpTable + " Where FID = FParentId AND FID NOT IN(Select FParentId FROM " + orgTmpTable + " Where FID <> FParentID)"));
                    }
                    for (String orgId : queryOrgIds) {
                        if (!noLeafOrgIds.contains(orgId)) continue;
                        if (leafAndNoLeafSql.length() > 0) {
                            leafAndNoLeafSql.append(" union all ");
                        }
                        leafAndNoLeafSql.append(sql.toString().replaceFirst("FOrgUnitId", "'" + orgId + "' FOrgUnitId").replace(orgTmpTable, orgTmpTable + " Where FParentId = '" + orgId + "'"));
                    }
                }
            }
            if (isMultiProcessType.booleanValue()) {
                if (params.containsKey(DimensionConstants.DECOMP_ORG_SQL) && params.containsKey(DimensionConstants.DATA_ORG_SQL)) {
                    sql = DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(cType)) ? sql.replace(params.get(DimensionConstants.DATA_ORG_SQL), params.get(DimensionConstants.DECOMP_ORG_SQL)) : sql.replace(params.get(DimensionConstants.DECOMP_ORG_SQL), params.get(DimensionConstants.DATA_ORG_SQL));
                }
                sql = leafAndNoLeafSql != null ? leafAndNoLeafSql + this.combineProcessTypeSql(params, cubeName, sql) : sql + this.combineProcessTypeSql(params, cubeName, sql);
            } else if (leafAndNoLeafSql != null) {
                sql = leafAndNoLeafSql.toString();
            }
            if (batchTable == null) {
                writer.writeStartElement(DimensionConstants.TABLE);
                writer.writeAttribute(DimensionConstants.NAME, this.FACT_NAME);
                writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
                writer.writeEndElement();
            } else {
                writer.writeStartElement("Parameter");
                writer.writeAttribute(DimensionConstants.NAME, this.FACT_NAME);
                writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TABLE);
                writer.writeEndElement();
                batchTable.setName(this.FACT_NAME);
                batchTable.setSql(sql);
                batchCount = sql.split("union all").length;
                if (batchCount > 1 && batchTable.getParamList() != null && !batchTable.getParamList().isEmpty()) {
                    ArrayList<Object[]> unionBatchParams = new ArrayList<Object[]>();
                    ArrayList<Object> result = new ArrayList<Object>();
                    ArrayList<Object> tmpList = null;
                    for (Object[] objectArray : batchTable.getParamList()) {
                        result.clear();
                        tmpList = new ArrayList<Object>(Arrays.asList(objectArray));
                        for (int i = 0; i < batchCount; ++i) {
                            result.addAll(tmpList);
                        }
                        unionBatchParams.add(result.toArray());
                    }
                    batchTable.setParamList(unionBatchParams);
                }
                olapParamsMap.put(this.FACT_NAME, batchTable);
            }
        }
    }

    private boolean checkHasBudget(Map<String, String> params) {
        if (params.get(DimensionConstants.DATA_VALUE_TYPE) != null) {
            boolean isDecompose;
            boolean isBudgetType = Integer.parseInt(params.get(DimensionConstants.DATA_VALUE_TYPE)) == 1;
            boolean isBudgetAuditType = Integer.parseInt(params.get(DimensionConstants.DATA_VALUE_TYPE)) == 2;
            boolean bl = isDecompose = Integer.parseInt(params.get(DimensionConstants.DATA_VALUE_TYPE)) == 256 || Integer.parseInt(params.get(DimensionConstants.DATA_VALUE_TYPE)) == 1024;
            if (isBudgetType || isBudgetAuditType || isDecompose) {
                return true;
            }
        }
        return false;
    }

    protected void dimensionOrgUnit(XMLStreamWriter writer, Map<String, String> params, IDimensionParameter parameter) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (this.getSingleOrgId() == null || parameter.isOrgLongNumber()) {
            String factTable = DimensionConstants.ORG_FACTTABLE_NAME;
            if (params.containsKey(DimensionConstants.ORGUNIT_FACT_TABLENAME)) {
                factTable = params.get(DimensionConstants.ORGUNIT_FACT_TABLENAME);
            }
            String tmpKey = null;
            String tmpTableKey = null;
            String tmpTable = null;
            writer.writeStartElement(DimensionConstants.DIMENSION);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ORGUNIT_DIM_NAME);
            writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
            writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), factTable.toUpperCase());
            tmpKey = DimensionBaseConstants.DEF_ORGUNIT_FIELD + "_" + DimensionConstants.MEMBER_NUMBER;
            tmpTableKey = DimensionBaseConstants.DEF_ORGUNIT_FIELD + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER;
            if (params.containsKey(tmpKey)) {
                writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), "select * from " + factTable + " where FID IN (" + params.get(tmpKey) + ")");
            } else if (params.get(tmpTableKey) != null) {
                tmpTable = params.get(tmpTableKey);
                writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), "select * from " + factTable + " where exists (select FID from " + tmpTable + " where FID = " + factTable + ".FID)");
            }
            writer.writeStartElement(DimensionConstants.HIERARCHY);
            writer.writeStartElement(DimensionConstants.LEVEL);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ORGUNIT_DIM_NAME + " Level");
            writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
            writer.writeStartElement(DimensionConstants.PROPERTY);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
            writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    protected void dimensionItem(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.BGITEMPROPCHECKERROR);
        }
        String tmpKey = null;
        String tmpRoot = null;
        String rootMember = null;
        String tmpTableKey = null;
        String tmpTable = null;
        String refFieldStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_REFFIELD));
        String factStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_FACT));
        String[] refFields = refFieldStr.split(";");
        String[] facts = factStr.split(";");
        if (refFields != null && refFields.length > 0 && facts != null && facts.length > 0) {
            String refField = null;
            String factTable = null;
            int in = refFields.length;
            for (int i = 0; i < in; ++i) {
                refField = refFields[i].toUpperCase();
                factTable = facts[i].toUpperCase();
                writer.writeStartElement(DimensionConstants.DIMENSION);
                writer.writeAttribute(DimensionConstants.NAME, "DIM" + refField.toUpperCase());
                writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_DIMNUMBER);
                writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), factTable.toUpperCase());
                tmpKey = refField + "_" + DimensionConstants.MEMBER_NUMBER;
                tmpRoot = refField + "_" + DimensionConstants.MEMBER_ROOT;
                tmpTableKey = refField + "_" + DimensionConstants.MEMBER_TMPTABLE_MEMBER;
                if (params.containsKey(tmpKey)) {
                    writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), "select * from " + factTable + " where FNumber IN (" + params.get(tmpKey) + ")");
                } else if (params.containsKey(tmpRoot)) {
                    rootMember = params.get(refField + "_" + DimensionConstants.MEMBER_ROOT_NUMBER);
                    if (rootMember != null) {
                        writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), "select * from " + factTable + " where FNumber = '" + rootMember + "'");
                    }
                } else if (params.containsKey(tmpTableKey)) {
                    tmpTable = params.get(tmpTableKey);
                    writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), "select * from " + factTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + factTable + ".FDimNumber)");
                }
                writer.writeStartElement(DimensionConstants.HIERARCHY);
                writer.writeStartElement(DimensionConstants.LEVEL);
                writer.writeAttribute(DimensionConstants.NAME, refField + " Level");
                writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_DIMNUMBER);
                writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTNUMBER);
                if (DimensionBaseConstants.DEF_BGINDEX_FIELD.equals(refField)) {
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmcalc");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FPolAlgorithm");
                    writer.writeEndElement();
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmtype");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FBgAccountType");
                    writer.writeEndElement();
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmdatatype");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FBgAccountDataType");
                    writer.writeEndElement();
                    writer.writeStartElement(DimensionConstants.PROPERTY);
                    writer.writeAttribute(DimensionConstants.NAME, "kmdctype");
                    writer.writeAttribute(DimensionConstants.COLUMN, "FBgDecreditAlgorithm");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    protected void dimensionPeriod(XMLStreamWriter writer, Map<String, String> params, IDimensionParameter parameter) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String factTable = DimensionConstants.PERIOD_FACTTABLE_NAME;
        if (params.containsKey(DimensionConstants.PERIOD_FISCALYEAR)) {
            factTable = ClosureUtils.HK_PERIOD_TABLE_FACT;
        }
        String sql = null;
        if (params.containsKey(DimensionConstants.PERIOD_SQL)) {
            sql = params.get(DimensionConstants.PERIOD_SQL);
            if (sql.indexOf(DimensionConstants.CUBE_NAME) > 0) {
                sql = sql.replaceAll(DimensionConstants.CUBE_NAME, factTable);
            }
            if (!params.containsKey(DimensionConstants.PERIOD_FISCALYEAR)) {
                CalendarHelper calendarHelper = new CalendarHelper();
                sql = sql.replaceAll(DimensionConstants.PERIOD_SELF_SQL, "FBeginDate IS NULL");
            }
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PERIOD_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), factTable.toUpperCase());
        if (sql != null) {
            writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
        }
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PERIOD_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.ORDER_BY, DimensionConstants.COLUMN_LONGNUMBER);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, DimensionConstants.COLUMN_PARENTID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "type");
        writer.writeAttribute(DimensionConstants.COLUMN, "FPERIODTYPE");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionElement(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (params.containsKey(DimensionConstants.REMOVE_ELEMENT)) {
            return;
        }
        String sql = null;
        String numbers = params.get(DimensionConstants.ELEMENT_NUMBERS);
        if (!StringUtils.isEmpty((String)numbers)) {
            sql = "select * from " + DimensionConstants.ELEMENT_FACTTABLE_NAME + " where FNumber IN (" + numbers + ")";
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ELEMENT_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.ELEMENT_FACTTABLE_NAME);
        if (sql != null) {
            writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
        }
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ELEMENT_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "name");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionCurrency(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (params.containsKey(DimensionConstants.REMOVE_CURRENCY)) {
            return;
        }
        String sql = null;
        String numbers = params.get(DimensionConstants.CURRENCY_NUMBERS);
        if (!StringUtils.isEmpty((String)numbers)) {
            sql = "select * from " + DimensionConstants.CURRENCY_FACTTABLE_NAME + " where FNumber IN (" + numbers + ")";
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.CURRENCY_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_FID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.CURRENCY_FACTTABLE_NAME);
        if (sql != null) {
            writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
        }
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.CURRENCY_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "name");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_NUMBER);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionScenario(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (params.containsKey(DimensionConstants.REMOVE_SCENARIO)) {
            return;
        }
        String sql = null;
        String numbers = params.get(DimensionConstants.SCENARIO_NUMBERS);
        if (!StringUtils.isEmpty((String)numbers)) {
            sql = "select * from " + DimensionConstants.SCENARIO_FACTTABLE_NAME + " where FNumber IN (" + numbers + ")";
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.SCENARIO_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_SCENARIOID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.SCENARIO_FACTTABLE_NAME);
        if (sql != null) {
            writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
        }
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.SCENARIO_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_SCENARIOID);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionVersion(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        if (params.containsKey(DimensionConstants.REMOVE_VERSION)) {
            return;
        }
        String sql = null;
        String numbers = params.get(DimensionConstants.VERSION_NUMBERS);
        if (!StringUtils.isEmpty((String)numbers)) {
            sql = "select * from " + DimensionConstants.VERSION_FACTTABLE_NAME + " where FNumber IN (" + numbers + ")";
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VERSION_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_VERSIONID);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.VERSION_FACTTABLE_NAME);
        if (sql != null) {
            writer.writeAttribute(DimensionConstants.SQL.toLowerCase(), sql);
        }
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VERSION_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_FID);
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.NAME);
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_VERSIONID);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void dimensionState(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
    }

    protected void dimensionProcessType(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (!DimUtils.isMultiProcessType(params)) {
            return;
        }
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PROCESS_DIM_NAME);
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, DimensionConstants.COLUMN_PROCESSTYPE);
        writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), DimensionConstants.PROCESSTYPE_FACTTABLE_NAME);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PROCESS_DIM_NAME + " Level");
        writer.writeAttribute(DimensionConstants.COLUMN, DimensionConstants.COLUMN_PROCESSTYPE);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected void schemeCube(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        boolean hasSQL = false;
        String cubeName = params.get(DimensionConstants.TABLE_NAME);
        String dataSql = params.get(DimensionConstants.DATA_TABLE_SQL);
        if (!StringUtils.isEmpty((String)dataSql)) {
            hasSQL = true;
        }
        writer.writeStartElement(DimensionConstants.CUBE);
        writer.writeAttribute(DimensionConstants.NAME, "budgetCube");
        if (hasSQL) {
            writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), this.FACT_NAME);
        } else {
            writer.writeAttribute(DimensionConstants.TABLE.toLowerCase(), cubeName);
        }
        if (this.getSingleOrgId() == null) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ORGUNIT_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FORGUNITID");
            writer.writeEndElement();
        }
        this.dimensionUsage(writer, params);
        writer.writeStartElement(DimensionConstants.DIMUSAGE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PERIOD_DIM_NAME);
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FBGPERIODID");
        writer.writeEndElement();
        if (!params.containsKey(DimensionConstants.REMOVE_ELEMENT)) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.ELEMENT_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FBGELEMENTID");
            writer.writeEndElement();
        }
        if (!params.containsKey(DimensionConstants.REMOVE_CURRENCY)) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.CURRENCY_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FCURRENCYID");
            writer.writeEndElement();
        }
        if (!params.containsKey(DimensionConstants.REMOVE_SCENARIO)) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.SCENARIO_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, DimensionConstants.COLUMN_SCENARIO);
            writer.writeEndElement();
        }
        if (!params.containsKey(DimensionConstants.REMOVE_VERSION)) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VERSION_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, DimensionConstants.COLUMN_VERSION);
            writer.writeEndElement();
        }
        if (DimUtils.isMultiProcessType(params)) {
            writer.writeStartElement(DimensionConstants.DIMUSAGE);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PROCESS_DIM_NAME);
            writer.writeAttribute(DimensionConstants.FOREIGNKEY, DimensionConstants.COLUMN_PROCESSTYPE.toUpperCase());
            writer.writeEndElement();
        }
        this.cubeMeasure(writer, params);
        writer.writeEndElement();
    }

    protected void dimensionUsage(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String refFieldStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_REFFIELD));
        String[] refFields = refFieldStr.split(";");
        if (refFields != null && refFields.length > 0) {
            String refField = null;
            int in = refFields.length;
            for (int i = 0; i < in; ++i) {
                refField = refFields[i].toUpperCase();
                writer.writeStartElement(DimensionConstants.DIMUSAGE);
                writer.writeAttribute(DimensionConstants.NAME, "DIM" + refField.toUpperCase());
                writer.writeAttribute(DimensionConstants.FOREIGNKEY, refField.toUpperCase());
                writer.writeEndElement();
            }
        }
    }

    protected void cubeMeasure(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        this.measure(writer, params);
    }

    protected void measure(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String fieldValue = this.isHasAdjustData() ? "FTMPVALUE" : "FVALUE";
        writer.writeStartElement(DimensionConstants.MRESURE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VALUE);
        writer.writeAttribute(DimensionConstants.COLUMN, fieldValue);
        writer.writeAttribute(DimensionConstants.AGGREGATOR, "sum");
        writer.writeEndElement();
    }

    protected void relation(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String relationFields = params.get(DimensionConstants.RELATION);
        if (StringUtils.isEmpty((String)relationFields)) {
            return;
        }
        String[] relFields = relationFields.split(",");
        HashSet<String> relFieldSet = new HashSet<String>();
        for (int i = 0; i < relFields.length; ++i) {
            relFieldSet.add(relFields[i]);
        }
        String refFieldStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_REFFIELD));
        String[] refFields = refFieldStr.split(";");
        HashSet<String> refFieldSet = new HashSet<String>();
        if (refFields != null && refFields.length > 0) {
            int in = refFields.length;
            for (int i = 0; i < in; ++i) {
                refFieldSet.add(refFields[i].toUpperCase());
            }
        }
        if (relFieldSet.containsAll(refFieldSet) && refFieldSet.containsAll(relFieldSet)) {
            writer.writeStartElement(DimensionConstants.RELATION);
            writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.RELATION);
            writer.writeAttribute(DimensionConstants.DIMENSIONS, relationFields);
            writer.writeEndElement();
        }
    }

    protected void partition(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.PARTITION);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.PARTITION);
        writer.writeAttribute(DimensionConstants.DIMENSIONS, DimensionConstants.ELEMENT_DIM_NAME);
        writer.writeEndElement();
    }

    private String getNotNullStr(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private String combineProcessTypeSql(Map<String, String> params, String cubeName, String sql) {
        StringBuffer unionSql = new StringBuffer();
        String tableCube = params.get(DimensionConstants.TABLE_CUBE);
        if (params.containsKey(DimensionConstants.BIZCALC_PROCESS_TYPE)) {
            String str = params.get(DimensionConstants.BIZCALC_PROCESS_TYPE);
            String cType = DimUtils.getCurProcessType(cubeName);
            String newSql = null;
            if (!StringUtils.isEmpty((String)str)) {
                if (str.indexOf(";") > 0) {
                    String[] types;
                    for (String type : types = str.split(";")) {
                        if (type.equals(cType)) continue;
                        newSql = sql.replaceAll(cubeName, BgCubeUtils.getCubeName(tableCube, DimensionCommonHelper.getDataType(BgProcessEnum.getEnum(type))));
                        newSql = newSql.replaceAll(", '" + cType + "' as FProcessType", ", '" + type + "' as FProcessType");
                        if (params.containsKey(DimensionConstants.DECOMP_ORG_SQL) && params.containsKey(DimensionConstants.DATA_ORG_SQL)) {
                            newSql = DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(type)) ? newSql.replace(params.get(DimensionConstants.DATA_ORG_SQL), params.get(DimensionConstants.DECOMP_ORG_SQL)) : newSql.replace(params.get(DimensionConstants.DECOMP_ORG_SQL), params.get(DimensionConstants.DATA_ORG_SQL));
                        }
                        unionSql = unionSql.append(" union all " + newSql);
                    }
                } else if (!str.equals(cType)) {
                    newSql = sql.replaceAll(cubeName, BgCubeUtils.getCubeName(tableCube, DimensionCommonHelper.getDataType(BgProcessEnum.getEnum(str))));
                    newSql = newSql.replaceAll(", '" + cType + "' as FProcessType", ", '" + str + "' as FProcessType");
                    if (params.containsKey(DimensionConstants.DECOMP_ORG_SQL) && params.containsKey(DimensionConstants.DATA_ORG_SQL)) {
                        newSql = DimensionCommonHelper.isDecompose(BgProcessEnum.getEnum(str)) ? newSql.replace(params.get(DimensionConstants.DATA_ORG_SQL), params.get(DimensionConstants.DECOMP_ORG_SQL)) : newSql.replace(params.get(DimensionConstants.DECOMP_ORG_SQL), params.get(DimensionConstants.DATA_ORG_SQL));
                    }
                    unionSql = unionSql.append(" union all " + newSql);
                }
            }
        }
        return unionSql.toString();
    }
}

