/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.kdolap;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.mbg.app.olap.face.IQueryStrategy;
import com.kingdee.eas.ma.mbg.app.olap.face.ISchemeCube;
import com.kingdee.eas.ma.mbg.app.olap.impl.OlapService;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapQueryStrategy;
import com.kingdee.eas.ma.mbg.app.olap.kdolap.KDOlapSchemeCube;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KDOlapServiceImpl
extends OlapService {
    private static Logger logger = Logger.getLogger(KDOlapServiceImpl.class);

    @Override
    public ISchemeCube createSchemeCube() {
        return new KDOlapSchemeCube();
    }

    @Override
    public IQueryStrategy createQueryStrategy() {
        return new KDOlapQueryStrategy(this);
    }

    @Override
    public void pretreatment(Context ctx, IDimensionParameter parameter) throws Exception {
        super.pretreatment(ctx, parameter);
    }

    @Override
    public Map<String, Object> olapQuery(Context ctx, Connection pConn, IDimensionParameter parameter) throws Exception {
        Map<String, Object> bgDataMap = new HashMap<String, Object>();
        if (ctx == null || parameter == null) {
            return bgDataMap;
        }
        this.getDebug().debugStart("begin dimension Query");
        this.pretreatment(ctx, parameter);
        Map<String, Object> olapParamsMap = this.getOlapParams(ctx, pConn, parameter);
        this.checkDimension(ctx, parameter);
        try {
            bgDataMap = this.getQueryStrategy().query(ctx, pConn, parameter, olapParamsMap);
        }
        catch (Exception ex) {
            logger.error((Object)"kdOlap Query Error:", (Throwable)ex);
            throw ex;
        }
        this.getDebug().debugEnd("end dimension Query");
        return bgDataMap;
    }

    protected Map<String, Object> getOlapParams(Context ctx, Connection pConn, IDimensionParameter parameter) throws Exception {
        HashMap<String, Object> olapParamsMap = new HashMap<String, Object>();
        this.getDebug().debugBegin("begin Preprocess Data");
        Map<String, String> cubeParams = this.getSchemeCube().transCubeParams(ctx, pConn, parameter);
        olapParamsMap.put(DimensionConstants.OLAP_SCHEME, cubeParams);
        this.getDebug().debugUseTime("end Preprocess Data");
        return olapParamsMap;
    }
}

