/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.mondrian;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.app.olap.face.IDataFilter;
import com.kingdee.eas.ma.mbg.app.olap.face.IDimCheck;
import com.kingdee.eas.ma.mbg.app.olap.impl.DataFilter;
import com.kingdee.eas.ma.mbg.app.olap.impl.DimensionCheck;
import com.kingdee.eas.ma.mbg.app.olap.impl.SchemeCube;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;

public class MondrianSchemeCube
extends SchemeCube {
    @Override
    public IDataFilter createDataFilter() {
        return new DataFilter();
    }

    @Override
    public IDimCheck createDimCheck() {
        return new DimensionCheck();
    }

    @Override
    public Map<String, String> transCubeParams(Context ctx, Connection pConn, IDimensionParameter parameter) throws Exception {
        return super.transCubeParams(ctx, pConn, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemeCube(Context ctx, Connection pConn, Map<String, String> params, Map<String, Object> olapParamsMap, IDimensionParameter parameter) throws Exception {
        ByteArrayOutputStream os = null;
        XMLStreamWriter writer = null;
        String scheme = null;
        try {
            os = new ByteArrayOutputStream();
            writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(DimensionConstants.SCHEME);
            writer.writeAttribute(DimensionConstants.NAME, "Mondrian");
            writer.writeStartElement(DimensionConstants.CUBE);
            writer.writeAttribute(DimensionConstants.NAME, "budgetCube");
            this.dimensionTableSQL(writer, params);
            this.dimensionOrgUnit(writer, params);
            this.dimensionItem(writer, params);
            this.dimensionPeriod(writer, params);
            this.dimensionElement(writer, params);
            this.dimensionCurrency(writer, params);
            this.dimensionMeasure(writer, params);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            scheme = ((Object)os).toString();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (os != null) {
                ((OutputStream)os).close();
            }
        }
        return scheme;
    }

    private void dimensionTableSQL(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        boolean hasSQL = false;
        String strKey = null;
        if (params != null && !StringUtils.isEmpty((String)(strKey = params.get(DimensionConstants.DATA_TABLE_SQL)))) {
            hasSQL = true;
        }
        if (hasSQL) {
            writer.writeStartElement(DimensionConstants.VIEW);
            writer.writeAttribute(DimensionConstants.ALIAS, "location_view");
            writer.writeStartElement(DimensionConstants.SQL);
            writer.writeAttribute(DimensionConstants.DIALECT, "generic");
            writer.writeCharacters(strKey);
            writer.writeEndElement();
            writer.writeEndElement();
        } else {
            writer.writeStartElement(DimensionConstants.TABLE);
            writer.writeAttribute(DimensionConstants.NAME, params.get(DimensionConstants.TABLE_NAME).toUpperCase());
            writer.writeEndElement();
        }
    }

    private void dimensionOrgUnit(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String tableName = DimensionConstants.ORG_FACTTABLE_NAME;
        if (params.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
            tableName = params.get(DimensionConstants.DEF_ORGUNIT_NUMBER).toUpperCase();
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, "orgUnit");
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FORGUNITID");
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TYPE_STANDARD);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeAttribute(DimensionConstants.NAME, "orgUnit");
        writer.writeAttribute(DimensionConstants.HASALL, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.ALLMEMBERNAME, "all orgUnit");
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, "FID");
        writer.writeAttribute(DimensionConstants.PRIMARYKEYTABLE, tableName);
        writer.writeStartElement(DimensionConstants.TABLE);
        writer.writeAttribute(DimensionConstants.NAME, tableName);
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, "orgUnit Level");
        writer.writeAttribute(DimensionConstants.UNIQUEMEMBERS, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.DATATYPE_STRING);
        writer.writeAttribute(DimensionConstants.COLUMN, "FID");
        writer.writeAttribute(DimensionConstants.NAMECOLUMN, "FNUMBER");
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, "FPARENTID");
        writer.writeAttribute(DimensionConstants.NULLPARENTVALUE, "null");
        writer.writeStartElement(DimensionConstants.CLOSURE);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, "FID");
        writer.writeAttribute(DimensionConstants.CHILDCOLUMN, "FCHILDID");
        writer.writeStartElement(DimensionConstants.TABLE);
        writer.writeAttribute(DimensionConstants.NAME, this.getNotNullStr(params.get(DimensionConstants.ORGUNIT_CLOSURE_TABLENAME)).toUpperCase());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void dimensionItem(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        String refFieldStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_REFFIELD));
        String factStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_FACT));
        String closureStr = this.getNotNullStr(params.get(DimensionConstants.BGITEM_DIM_CLOSURE));
        String[] refFields = refFieldStr.split(";");
        String[] facts = factStr.split(";");
        String[] closures = closureStr.split(";");
        if (refFields != null && refFields.length > 0 && facts != null && facts.length > 0 && closures != null && closures.length > 0) {
            String refField = null;
            String factTable = null;
            String closureTable = null;
            int in = refFields.length;
            for (int i = 0; i < in; ++i) {
                refField = refFields[i].toUpperCase();
                factTable = facts[i].toUpperCase();
                closureTable = closures[i].toUpperCase();
                if (!StringUtils.isEmpty((String)closureTable)) {
                    writer.writeStartElement(DimensionConstants.DIMENSION);
                    writer.writeAttribute(DimensionConstants.NAME, "DIM" + refField);
                    writer.writeAttribute(DimensionConstants.FOREIGNKEY, refField.toUpperCase());
                    writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TYPE_STANDARD);
                    writer.writeStartElement(DimensionConstants.HIERARCHY);
                    writer.writeAttribute(DimensionConstants.NAME, "DIM" + refField);
                    writer.writeAttribute(DimensionConstants.HASALL, Boolean.TRUE.toString());
                    writer.writeAttribute(DimensionConstants.ALLMEMBERNAME, "all " + refField);
                    writer.writeAttribute(DimensionConstants.PRIMARYKEY, "FDIMNUMBER");
                    writer.writeAttribute(DimensionConstants.PRIMARYKEYTABLE, factTable);
                    writer.writeStartElement(DimensionConstants.TABLE);
                    writer.writeAttribute(DimensionConstants.NAME, factTable);
                    writer.writeEndElement();
                    writer.writeStartElement(DimensionConstants.LEVEL);
                    writer.writeAttribute(DimensionConstants.NAME, refField + " Level");
                    writer.writeAttribute(DimensionConstants.UNIQUEMEMBERS, Boolean.TRUE.toString());
                    writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.DATATYPE_STRING);
                    writer.writeAttribute(DimensionConstants.COLUMN, "FDIMNUMBER");
                    writer.writeAttribute(DimensionConstants.NAMECOLUMN, "FDIMNUMBER");
                    writer.writeAttribute(DimensionConstants.PARENTCOLUMN, "FPARENTNUMBER");
                    writer.writeAttribute(DimensionConstants.NULLPARENTVALUE, "null");
                    writer.writeStartElement(DimensionConstants.CLOSURE);
                    writer.writeAttribute(DimensionConstants.PARENTCOLUMN, "FID");
                    writer.writeAttribute(DimensionConstants.CHILDCOLUMN, "FCHILDID");
                    writer.writeStartElement(DimensionConstants.TABLE);
                    writer.writeAttribute(DimensionConstants.NAME, closureTable);
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeEndElement();
                    continue;
                }
                writer.writeStartElement(DimensionConstants.DIMENSION);
                writer.writeAttribute(DimensionConstants.NAME, "DIM" + refField);
                writer.writeAttribute(DimensionConstants.FOREIGNKEY, refField);
                writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TYPE_STANDARD);
                writer.writeStartElement(DimensionConstants.HIERARCHY);
                writer.writeAttribute(DimensionConstants.NAME, refField);
                writer.writeAttribute(DimensionConstants.HASALL, Boolean.TRUE.toString());
                writer.writeAttribute(DimensionConstants.ALLMEMBERNAME, "all " + refField);
                writer.writeAttribute(DimensionConstants.PRIMARYKEY, "FDIMNUMBER");
                writer.writeAttribute(DimensionConstants.PRIMARYKEYTABLE, factTable);
                writer.writeStartElement(DimensionConstants.TABLE);
                writer.writeAttribute(DimensionConstants.NAME, factTable);
                writer.writeEndElement();
                writer.writeStartElement(DimensionConstants.LEVEL);
                writer.writeAttribute(DimensionConstants.NAME, refField);
                writer.writeAttribute(DimensionConstants.UNIQUEMEMBERS, Boolean.TRUE.toString());
                writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.DATATYPE_STRING);
                writer.writeAttribute(DimensionConstants.COLUMN, "FDIMNUMBER");
                writer.writeAttribute(DimensionConstants.NAMECOLUMN, "FDIMNUMBER");
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    private void dimensionPeriod(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, "period");
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FBGPERIODID");
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TYPE_STANDARD);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeAttribute(DimensionConstants.NAME, "period");
        writer.writeAttribute(DimensionConstants.HASALL, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.ALLMEMBERNAME, "all period");
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, "FID");
        writer.writeAttribute(DimensionConstants.PRIMARYKEYTABLE, "T_MBG_BGPERIOD");
        writer.writeStartElement(DimensionConstants.TABLE);
        writer.writeAttribute(DimensionConstants.NAME, "T_MBG_BGPERIOD");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, "period Level");
        writer.writeAttribute(DimensionConstants.UNIQUEMEMBERS, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.DATATYPE_STRING);
        writer.writeAttribute(DimensionConstants.COLUMN, "FID");
        writer.writeAttribute(DimensionConstants.NAMECOLUMN, "FNUMBER");
        writer.writeAttribute(DimensionConstants.ORDERCOLUMN, "FLONGNUMBER");
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, "FPARENTID");
        writer.writeAttribute(DimensionConstants.NULLPARENTVALUE, "null");
        writer.writeStartElement(DimensionConstants.PROPERTY);
        writer.writeAttribute(DimensionConstants.NAME, "type");
        writer.writeAttribute(DimensionConstants.COLUMN, "FPERIODTYPE");
        writer.writeAttribute(DimensionConstants.TYPE, "Integer");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.CLOSURE);
        writer.writeAttribute(DimensionConstants.PARENTCOLUMN, "FID");
        writer.writeAttribute(DimensionConstants.CHILDCOLUMN, "FCHILDID");
        writer.writeStartElement(DimensionConstants.TABLE);
        writer.writeAttribute(DimensionConstants.NAME, this.getNotNullStr(params.get(DimensionConstants.BGPERIOD_CLOSURE_TABLENAME)).toUpperCase());
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void dimensionElement(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, "element");
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FBGELEMENTID");
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TYPE_STANDARD);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeAttribute(DimensionConstants.NAME, "element");
        writer.writeAttribute(DimensionConstants.HASALL, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.ALLMEMBERNAME, "all element");
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, "FID");
        writer.writeAttribute(DimensionConstants.PRIMARYKEYTABLE, "T_MBG_BGELEMENT");
        writer.writeStartElement(DimensionConstants.TABLE);
        writer.writeAttribute(DimensionConstants.NAME, "T_MBG_BGELEMENT");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, "elementId");
        writer.writeAttribute(DimensionConstants.UNIQUEMEMBERS, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.DATATYPE_STRING);
        writer.writeAttribute(DimensionConstants.COLUMN, "FID");
        writer.writeAttribute(DimensionConstants.NAMECOLUMN, "FNUMBER");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void dimensionCurrency(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        writer.writeStartElement(DimensionConstants.DIMENSION);
        writer.writeAttribute(DimensionConstants.NAME, "currency");
        writer.writeAttribute(DimensionConstants.FOREIGNKEY, "FCURRENCYID");
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.TYPE_STANDARD);
        writer.writeStartElement(DimensionConstants.HIERARCHY);
        writer.writeAttribute(DimensionConstants.NAME, "currency");
        writer.writeAttribute(DimensionConstants.HASALL, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.ALLMEMBERNAME, "all currency");
        writer.writeAttribute(DimensionConstants.PRIMARYKEY, "FID");
        writer.writeAttribute(DimensionConstants.PRIMARYKEYTABLE, "T_BD_CURRENCY");
        writer.writeStartElement(DimensionConstants.TABLE);
        writer.writeAttribute(DimensionConstants.NAME, "T_BD_CURRENCY");
        writer.writeEndElement();
        writer.writeStartElement(DimensionConstants.LEVEL);
        writer.writeAttribute(DimensionConstants.NAME, "currencyId");
        writer.writeAttribute(DimensionConstants.UNIQUEMEMBERS, Boolean.TRUE.toString());
        writer.writeAttribute(DimensionConstants.TYPE, DimensionConstants.DATATYPE_STRING);
        writer.writeAttribute(DimensionConstants.COLUMN, "FID");
        writer.writeAttribute(DimensionConstants.NAMECOLUMN, "FNUMBER");
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void dimensionMeasure(XMLStreamWriter writer, Map<String, String> params) throws Exception {
        if (writer == null || params == null) {
            throw new DimensionException(DimensionException.PARAMETERCHECKERROR);
        }
        this.dimensionCommonMeasure(writer);
    }

    private void dimensionCommonMeasure(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement(DimensionConstants.MRESURE);
        writer.writeAttribute(DimensionConstants.NAME, DimensionConstants.VALUE);
        writer.writeAttribute(DimensionConstants.COLUMN, "FVALUE");
        writer.writeAttribute(DimensionConstants.AGGREGATOR, "sum");
        writer.writeAttribute(DimensionConstants.DATATYPE, DimensionConstants.DATATYPE_NUMERIC);
        writer.writeEndElement();
    }

    private String getNotNullStr(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }
}

