/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.olap.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CubeUtils {
    private static Logger logger = Logger.getLogger(CubeUtils.class);

    public static String getOrgTmpTable(Context ctx, Connection conn, IDimensionParameter parameter, String[] mbgOrgTables) throws Exception {
        if (ctx == null || conn == null || parameter == null || mbgOrgTables == null) {
            return null;
        }
        long st = System.currentTimeMillis();
        logger.error((Object)"begin getOrgTmpTable ");
        TempTablePool pool = parameter.getTempTableManager(ctx).getTempTablePool();
        String orgViewId = parameter.getBgOrgViewId().toString();
        String tmpOrgTable = null;
        String queryOrgTable = null;
        String ignoreOrgTable = null;
        Object rst = null;
        try {
            tmpOrgTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44) NOT NULL, FParentID VARCHAR(44) NOT NULL, FIsIgnore INT DEFAULT 0 NOT NULL, FIntId INT)");
            queryOrgTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            ignoreOrgTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44) NOT NULL, FParentID VARCHAR(44) NOT NULL)");
            if (tmpOrgTable != null) {
                pool.createIndex(tmpOrgTable, "FID", false, false);
                pool.createIndex(tmpOrgTable, "FParentID, FID", true, false);
                pool.createIndex(ignoreOrgTable, "FParentID, FID", false, false);
                pool.createIndex(queryOrgTable, "FID", true, false);
                Set<String> orgIds = parameter.getQueryOrgIds();
                if (orgIds == null || orgIds.isEmpty()) {
                    orgIds = new HashSet<String>();
                    orgIds.add(parameter.getOrgUnitId().toString());
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + queryOrgTable + "(FID) Values(?)"), orgIds);
                List closures = new ArrayList<String>();
                if (parameter.getUnionId() == null) {
                    closures = MbgVirtualView.getMbgOrgUnitClosure((Connection)conn, (BOSUuid)parameter.getBgOrgViewId());
                } else {
                    closures.add(mbgOrgTables[3]);
                }
                Iterator it = closures.iterator();
                while (it.hasNext()) {
                    if (BgDBUtils.existTable((Connection)conn, (String)((String)it.next())) == BgDBUtils.YES) continue;
                    it.remove();
                }
                for (String closure : closures) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID, FParentID) Select distinct FChildID, FID from " + closure + " t0 where FID IN(Select FID FROM " + queryOrgTable + ") AND not exists (select FID from " + tmpOrgTable + " where FID = t0.FChildID AND FParentID = t0.FID)"));
                }
                for (String closure : closures) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID, FParentID)\tSelect distinct FChildID, FID from " + closure + " t0 where FID IN(Select FID FROM " + tmpOrgTable + ") AND not exists (select FID from " + tmpOrgTable + " where FID = t0.FChildID AND FParentID = t0.FID)"));
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID, FParentID)  Select distinct t0.FID, t1.FParentID from " + tmpOrgTable + " t0 Inner Join " + tmpOrgTable + " t1 ON t0.FParentID = t1.FID Where not exists (select FID from " + tmpOrgTable + " where FID = t0.FID AND FParentID = t1.FParentID)"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpOrgTable + " Set FIsIgnore = 1 Where FID <> FParentId AND FID IN(Select FOrgUnitID from T_MBG_BgOrgUnit where FViewID = ? and FPolAlgorithm = " + 3 + ")"), (Object[])new Object[]{orgViewId});
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + ignoreOrgTable + " (FID, FParentID) Select tChild.FID, tParent.FParentID FROM " + tmpOrgTable + " tChild, " + tmpOrgTable + " tParent Where tParent.FID = tChild.FParentId AND tParent.FIsIgnore = 1 AND tParent.FIsIgnore = 1 "));
                BgDBUtils.executeUpdate((Connection)conn, (String)("Delete FROM " + tmpOrgTable + " t0 Where Exists (Select FID FROM " + ignoreOrgTable + " Where FID = t0.FID AND FParentId = t0.FParentId)"));
                BgDBUtils.executeUpdate((Connection)conn, (String)("Delete FROM " + tmpOrgTable + " t0 Where FParentID NOT IN(Select FID FROM " + queryOrgTable + ")"));
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            parameter.getTempTableManager(ctx).getTempTables().add(tmpOrgTable);
            parameter.getTempTableManager(ctx).getTempTables().add(queryOrgTable);
            parameter.getTempTableManager(ctx).getTempTables().add(ignoreOrgTable);
        }
        logger.error((Object)("end getOrgTmpTable " + (System.currentTimeMillis() - st) + " ms"));
        return tmpOrgTable;
    }

    public static void queryNotAggEle(Connection conn, IDimensionParameter parameter) throws EASBizException {
        if (conn == null || parameter == null) {
            return;
        }
        List<String> elementNums = parameter.getDataManager().getBgScheme().getMemberNumber(DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        HashSet<String> elementSet = new HashSet<String>(elementNums);
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_MBG_BgElement where (FDataType = 1 OR FDataType = 3) and FShowData = 0");
            while (rst.next()) {
                if (!elementSet.contains(rst.getString("FNumber"))) continue;
                parameter.getDataManager().getNotAggEle().add(rst.getString("FNumber"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"queryNotAggEle sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    public static void getRefDimensionInfo(List<IDimension> dimensions, List<String> refFields) {
        if (dimensions == null || refFields == null) {
            return;
        }
        IDimension dimension = null;
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            dimension = dimensions.get(i);
            if (DimUtils.checkBaseDimension(dimension) || dimension.getField() == null || refFields.contains(dimension.getField())) continue;
            refFields.add(dimension.getField());
        }
    }

    public static void getRefDimensionInfo(Map<String, IDimension> dimensionMap, List<String> refFields) {
        if (dimensionMap == null || refFields == null) {
            return;
        }
        IDimension dimension2 = null;
        for (IDimension dimension2 : dimensionMap.values()) {
            if (DimUtils.checkBaseDimension(dimension2) || dimension2.getField() == null || refFields.contains(dimension2.getField())) continue;
            refFields.add(dimension2.getField());
        }
    }

    public static void deleteOrgDimension(IDimensionParameter parameter) {
        if (parameter == null) {
            return;
        }
        CubeUtils.deleteOrgDimension(parameter.getRowDims());
        CubeUtils.deleteOrgDimension(parameter.getColDims());
        CubeUtils.deleteOrgDimension(parameter.getPageDims());
        parameter.getDimensionMap().remove(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
        if (!parameter.getQuerys().isEmpty()) {
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                CubeUtils.deleteOrgDimension(parameter.getQuerys().get(i));
            }
        }
    }

    private static void deleteOrgDimension(List<IDimension> mbgDims) {
        if (mbgDims == null || mbgDims.isEmpty()) {
            return;
        }
        IDimension dimension = null;
        IDimension orgDimension = null;
        int in = mbgDims.size();
        for (int i = 0; i < in; ++i) {
            dimension = mbgDims.get(i);
            if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) continue;
            orgDimension = dimension;
            break;
        }
        if (orgDimension != null) {
            mbgDims.remove(orgDimension);
        }
    }

    private static void deleteOrgDimension(IQueryData queryData) {
        if (queryData == null) {
            return;
        }
        queryData.getMbgDimMap().remove(DimensionBaseConstants.DEF_ORGUNIT_FIELD);
    }
}

