/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.qingstore;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseIntegrateFactory;
import com.kingdee.eas.ma.mbg.MbgQingDataParam;
import com.kingdee.eas.ma.mbg.app.qingstore.MbgQingStoreUtils;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgQingDataPool {
    private static Logger logger = Logger.getLogger((String)MbgQingDataPool.class.getName());
    private MbgQingStoreUtils utils = null;
    private String poolKey = null;
    public Map<String, Map<String, IBgNData>> writeBgDataMap = new HashMap<String, Map<String, IBgNData>>();
    public Map<String, Map<String, IBgNData>> bufferBgDataMap = new HashMap<String, Map<String, IBgNData>>();
    public Map<String, Map<String, BgDimensionMember>> writeMemberMap = new HashMap<String, Map<String, BgDimensionMember>>();
    public Map<String, Map<String, BgDimensionMember>> bufferMemberMap = new HashMap<String, Map<String, BgDimensionMember>>();
    protected Boolean isWrite = false;

    public MbgQingDataPool(MbgQingStoreUtils utils, String poolKey) {
        this.utils = utils;
        this.poolKey = poolKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(Context ctx, MbgQingDataParam param, Map<String, Map<String, IBgNData>> bgDataMap) {
        this.writeToBuffer(ctx, param, bgDataMap);
        if (!this.isWrite.booleanValue()) {
            Map<String, Map<String, IBgNData>> map = this.bufferBgDataMap;
            synchronized (map) {
                this.writeBgDataMap.putAll(this.bufferBgDataMap);
                this.bufferBgDataMap.clear();
            }
            MbgQingWriteThread thread = new MbgQingWriteThread(ctx, param);
            this.utils.qingThreadPool.execute(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToBuffer(Context ctx, MbgQingDataParam param, Map<String, Map<String, IBgNData>> bgDataMap) {
        logger.info((Object)(" start write data to bufferBgDataMap,poolKey:" + this.poolKey));
        Map<String, Map<String, IBgNData>> map = this.bufferBgDataMap;
        synchronized (map) {
            String processType = null;
            String formulaKey = null;
            String nullKey22 = null;
            String orgUnitId = null;
            String formulaAndProcessKey = null;
            IBgNData value = null;
            Map<String, IBgNData> waitSaveData = null;
            Map<String, IBgNData> dataMap = null;
            for (Map.Entry<String, Map<String, IBgNData>> processEntry : bgDataMap.entrySet()) {
                processType = processEntry.getKey();
                waitSaveData = processEntry.getValue();
                if (this.bufferBgDataMap.containsKey(processType)) {
                    dataMap = this.bufferBgDataMap.get(processType);
                    for (Map.Entry<String, Object> entry : waitSaveData.entrySet()) {
                        formulaKey = entry.getKey();
                        value = (IBgNData)entry.getValue();
                        if (dataMap == null) {
                            dataMap = new HashMap<String, IBgNData>();
                        }
                        dataMap.put(formulaKey, value);
                    }
                    continue;
                }
                this.bufferBgDataMap.put(processType, waitSaveData);
            }
            Set<String> nullKeys = param.getNullKeys();
            if (nullKeys != null && !nullKeys.isEmpty()) {
                for (String nullKey22 : nullKeys) {
                    orgUnitId = nullKey22.substring(0, nullKey22.indexOf("_"));
                    formulaAndProcessKey = nullKey22.substring(nullKey22.indexOf("_") + 1, nullKey22.length());
                    formulaKey = formulaAndProcessKey.substring(0, formulaAndProcessKey.lastIndexOf("_"));
                    processType = formulaAndProcessKey.substring(formulaAndProcessKey.lastIndexOf("_") + 1, formulaAndProcessKey.length());
                    if (!this.bufferBgDataMap.containsKey(processType)) continue;
                    dataMap = this.bufferBgDataMap.get(processType);
                    if (!param.getBgOrgUnitInfo().getOrgUnitID().equals(orgUnitId) || !dataMap.containsKey(formulaKey)) continue;
                    dataMap.remove(formulaKey);
                }
            }
            Map<String, Map<String, BgDimensionMember>> queryMemberMap = param.getQueryMemberMap();
            for (Map.Entry<String, Map<String, BgDimensionMember>> entry : queryMemberMap.entrySet()) {
                String refField = entry.getKey();
                Map<String, BgDimensionMember> memberMap = entry.getValue();
                if (this.bufferMemberMap.containsKey(refField)) {
                    this.bufferMemberMap.get(refField).putAll(memberMap);
                    continue;
                }
                this.bufferMemberMap.put(refField, memberMap);
            }
            this.bufferMemberMap.putAll(queryMemberMap);
        }
        logger.info((Object)"end write data to bufferBgDataMap");
    }

    class MbgQingWriteThread
    extends Thread {
        private Context ctx;
        private MbgQingDataParam param;

        public MbgQingWriteThread(Context ctx, MbgQingDataParam param) {
            this.ctx = ctx;
            this.param = param;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MbgQingDataPool.this.isWrite = true;
                long time = System.currentTimeMillis();
                while (!MbgQingDataPool.this.writeBgDataMap.isEmpty()) {
                    logger.info((Object)("start write bgDataMap of mbgQingWriteThread:" + MbgQingDataPool.this.poolKey));
                    MbgQingAnalyseIntegrateFactory.getLocalInstance(this.ctx).saveSingleOrgData(this.param, MbgQingDataPool.this.writeBgDataMap);
                    MbgQingDataPool.this.writeBgDataMap.clear();
                    MbgQingDataPool.this.writeMemberMap.clear();
                    Map<String, Map<String, IBgNData>> map = MbgQingDataPool.this.bufferBgDataMap;
                    synchronized (map) {
                        if (MbgQingDataPool.this.bufferBgDataMap.isEmpty()) {
                            break;
                        }
                        logger.info((Object)("start write bufferBgDataMap of mbgQingWriteThread :" + MbgQingDataPool.this.poolKey));
                        MbgQingDataPool.this.writeBgDataMap.putAll(MbgQingDataPool.this.bufferBgDataMap);
                        MbgQingDataPool.this.bufferBgDataMap.clear();
                        MbgQingDataPool.this.writeMemberMap.putAll(MbgQingDataPool.this.bufferMemberMap);
                        this.param.setQueryMemberMap(MbgQingDataPool.this.writeMemberMap);
                        MbgQingDataPool.this.bufferMemberMap.clear();
                    }
                }
                logger.info((Object)("end write mbgQingWriteThread:" + MbgQingDataPool.this.poolKey + " , use time :" + (System.currentTimeMillis() - time) + ".ms"));
            }
            catch (EASBizException e) {
                logger.error((Object)"saveSingleOrgData error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"saveSingleOrgData error:", (Throwable)e);
            }
            finally {
                MbgQingDataPool.this.isWrite = false;
                MbgQingDataPool.this.utils.releasePool(MbgQingDataPool.this.poolKey);
            }
        }
    }
}

