/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.qingstore;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.MbgQingDataParam;
import com.kingdee.eas.ma.mbg.app.qingstore.MbgQingDataPool;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class MbgQingStoreUtils {
    private static Logger logger = Logger.getLogger((String)MbgQingStoreUtils.class.getName());
    private static MbgQingStoreUtils instance;
    public ThreadPoolExecutor qingThreadPool;
    private static long keepAliveTime;
    private Map<String, MbgQingDataPool> poolMap = new HashMap<String, MbgQingDataPool>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MbgQingStoreUtils getInstance(Connection conn) {
        if (instance != null) return instance;
        Class<MbgQingStoreUtils> clazz = MbgQingStoreUtils.class;
        synchronized (MbgQingStoreUtils.class) {
            if (instance != null) return instance;
            instance = new MbgQingStoreUtils(conn);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private MbgQingStoreUtils(Connection conn) {
        this.initThreadPool(conn);
    }

    private void initThreadPool(Connection conn) {
        try {
            this.qingThreadPool = new ThreadPoolExecutor(MultiThreadQuery.getPoolSize(conn), Integer.MAX_VALUE, keepAliveTime, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.qingThreadPool.allowCoreThreadTimeOut(true);
        }
        catch (EASBizException e) {
            logger.error((Object)"initThreadPool error:", (Throwable)e);
        }
    }

    private MbgQingStoreUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MbgQingDataPool getPool(String poolKey) {
        Map<String, MbgQingDataPool> map = this.poolMap;
        synchronized (map) {
            if (this.poolMap.containsKey(poolKey)) {
                return this.poolMap.get(poolKey);
            }
            MbgQingDataPool pool = new MbgQingDataPool(this, poolKey);
            this.poolMap.put(poolKey, pool);
            return pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releasePool(String poolKey) {
        Map<String, MbgQingDataPool> map = this.poolMap;
        synchronized (map) {
            this.poolMap.remove(poolKey);
        }
    }

    public void writeData(Context ctx, MbgQingDataParam param, Map<String, Map<String, IBgNData>> processValue) throws EASBizException, BOSException {
        MbgQingDataPool pool = this.getPool(this.getPoolKey(ctx, param.getDimenisonParameter().getBgSchemeId().toString(), param.getBgOrgUnitInfo().getOrgUnitID()));
        pool.writeData(ctx, param, processValue);
    }

    public String getPoolKey(Context ctx, String bgSchemeId, String orgUnitId) {
        return ctx.getAIS() + "_" + bgSchemeId + "_" + orgUnitId;
    }

    static {
        keepAliveTime = 3L;
    }
}

