/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgDataAddnewImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataDeleteImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataUpdateImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.DataHelper;
import com.kingdee.eas.ma.mbg.app.utils.IDataFacade;
import com.kingdee.eas.ma.mbg.app.utils.IDataHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractDataFacadeImpl
implements IDataFacade {
    private static final Logger logger = Logger.getLogger(AbstractDataFacadeImpl.class);
    public static final int ADDNEW = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public static final int FORMULA = 3;
    public static final int DATAREF = 4;
    public static final String VALUE_FIELD = "dataValue";
    private IDataHelper dataHelper = null;
    private Context ctx = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Set<String> filterSet = new HashSet<String>();
    public static final String DEF_VALUE_FIELD = "FValue";
    public static final String TMP_VALUE_FIELD = "FTmpValue";

    private void setDataHelper(IDataHelper dataHelper) {
        this.dataHelper = dataHelper;
    }

    @Override
    public IDataHelper getDataHelper() {
        return this.dataHelper;
    }

    public IDataHelper createDataHelper() {
        return new DataHelper();
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.getDataHelper().getBgSchemeInfo().getId().toString());
        }
        return this.schemeHelper;
    }

    public AbstractDataFacadeImpl(Context ctx, IObjectValue model) {
        this.setCtx(ctx);
        this.setDataHelper(this.createDataHelper());
        this.getDataHelper().setModel(model);
    }

    @Override
    public void addData(IBgNData data) {
        if (data != null) {
            data.splitFormula();
            this.getDataHelper().getDatas().add(data);
            this.getDataHelper().getFormulas().add(data.getFormula());
        }
    }

    @Override
    public void save() throws BOSException, EASBizException {
        Object[] objs = this.compareData(this.getCtx(), this.getDataHelper().getModel());
        if (objs != null) {
            this.addNewValue(this.getCtx(), objs[0]);
            this.updateValue(this.getCtx(), objs[1]);
            this.deleteValue(this.getCtx(), objs[2]);
            this.saveDataRef(this.getCtx(), objs[4]);
        }
    }

    @Override
    public void audit(Map<String, String> auditParams) throws BOSException, EASBizException {
    }

    protected Object[] compareData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String _bgTemplateId;
        if (ctx == null || this.checkModel(model)) {
            return null;
        }
        BOSUuid billId = this.getBillId(model);
        BOSUuid orgUnitId = this.getOrgUnitId(model);
        BOSUuid bgSchemeId = this.getBgSchemeId(model);
        BOSUuid bgTemplateId = this.getBgTemplateId(model);
        String _orgUnitId = orgUnitId.toString();
        String _bgSchemeId = bgSchemeId.toString();
        String string = _bgTemplateId = bgTemplateId == null ? null : bgTemplateId.toString();
        if (this.getDataHelper().getBgSchemeInfo() == null) {
            this.getDataHelper().setBgSchemeInfo(BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeId));
        }
        if (this.getDataHelper().getBgSchemeInfo() == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)this.getDataHelper().getCubeName())) {
            this.getDataHelper().setCubeName(this.transCube());
        }
        if (StringUtils.isEmpty((String)this.getDataHelper().getCubeEntryName())) {
            this.getDataHelper().setCubeEntryName(this.transCubeEntry());
        }
        HashSet<String> formulas = new HashSet<String>();
        formulas.addAll(this.getDataHelper().getFormulas());
        HashSet<String> versions = new HashSet<String>();
        versions.add(this.getVersionNumber(model));
        DimensionMemberCheckHelper checkhelper = this.getMemberCheckHelper(ctx, null, _orgUnitId, _bgTemplateId, _bgSchemeId, formulas, versions);
        Map<String, IBgNData> dataMap = this.queryFormula(ctx, billId);
        Map<String, IBgNData> schemeDataMap = this.querySchemeData(ctx, billId, orgUnitId);
        HashMap<String, BgNDataInfo> _addnew = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _update = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _delete = new HashMap<String, BgNDataInfo>();
        ArrayList<String> _dataRef = new ArrayList<String>();
        HashSet<String> _formulas = new HashSet<String>();
        Object[] _objs = new Object[]{_addnew, _update, _delete, _formulas, _dataRef};
        BgNDataInfo _dataInfo = null;
        BgNDataInfo oldData = null;
        BigDecimal value = null;
        boolean canSave = true;
        int in = this.getDataHelper().getDatas().size();
        for (int i = 0; i < in; ++i) {
            _dataInfo = (BgNDataInfo)this.getDataHelper().getDatas().get(i);
            oldData = null;
            if (!_dataInfo.isCanSave() || checkhelper != null && !checkhelper.canSave(_dataInfo, null, this.getVersionNumber(model))) continue;
            value = this.getValue(_dataInfo);
            if (value == null) {
                if (dataMap.containsKey(_dataInfo.getFormula())) {
                    oldData = (BgNDataInfo)dataMap.get(_dataInfo.getFormula());
                    _dataInfo.setBgDataId(oldData.getBgDataId());
                } else if (schemeDataMap.containsKey(_dataInfo.getFormula())) {
                    oldData = (BgNDataInfo)schemeDataMap.get(_dataInfo.getFormula());
                    _dataInfo.setBgDataId(oldData.getBgDataId());
                }
                this.after(_dataInfo, oldData);
                if (!this.checkCanDelete(oldData)) continue;
                _delete.put(_dataInfo.getFormula(), _dataInfo);
                continue;
            }
            canSave = this.canSaveValue(value);
            _formulas.add(_dataInfo.getFormula());
            if (dataMap.containsKey(_dataInfo.getFormula())) {
                oldData = (BgNDataInfo)dataMap.get(_dataInfo.getFormula());
                _dataInfo.setBgDataId(oldData.getBgDataId());
                _dataRef.add(_dataInfo.getBgDataId());
                this.after(_dataInfo, oldData);
                if (!this.checkState(oldData)) continue;
                if (canSave) {
                    if (this.compareBgDataInfo(_dataInfo, oldData)) continue;
                    _update.put(_dataInfo.getFormula(), _dataInfo);
                    continue;
                }
                _delete.put(_dataInfo.getFormula(), _dataInfo);
                continue;
            }
            if (schemeDataMap.containsKey(_dataInfo.getFormula())) {
                oldData = (BgNDataInfo)schemeDataMap.get(_dataInfo.getFormula());
                _dataInfo.setBgDataId(oldData.getBgDataId());
                _dataRef.add(_dataInfo.getBgDataId());
                this.after(_dataInfo, oldData);
                if (!this.checkState(oldData)) continue;
                if (canSave) {
                    _update.put(_dataInfo.getFormula(), _dataInfo);
                    continue;
                }
                _delete.put(_dataInfo.getFormula(), _dataInfo);
                continue;
            }
            if (!canSave) continue;
            _addnew.put(_dataInfo.getFormula(), _dataInfo);
        }
        return _objs;
    }

    protected void after(BgNDataInfo bgData, BgNDataInfo oldData) {
    }

    protected DimensionMemberCheckHelper getMemberCheckHelper(Context ctx, DimensionCacheHelper cacheHelper, String orgUnitId, String bgTemplateId, String bgSchemeId, Collection formulas, Set<String> versionNumber) throws BOSException, EASBizException {
        return DimensionMemberCheckHelper.getLocalIntance(ctx, null, orgUnitId, bgTemplateId, this.getSchemeHelper(), formulas, versionNumber, this.getDataHelper().isDecompose());
    }

    protected boolean checkState(BgNDataInfo oldData) {
        return oldData != null && oldData.getState() == 1;
    }

    public String getCubeInfo() {
        return this.getDataHelper().getBgSchemeInfo().getRefCube();
    }

    public abstract boolean checkModel(IObjectValue var1);

    public abstract BOSUuid getBillId(IObjectValue var1);

    public abstract BOSUuid getOrgUnitId(IObjectValue var1);

    public abstract BOSUuid getBgSchemeId(IObjectValue var1);

    public abstract BOSUuid getBgTemplateId(IObjectValue var1);

    public abstract BOSUuid getUserId(IObjectValue var1);

    public abstract BOSUuid getVersionId(IObjectValue var1);

    public abstract int getVersionIntId(IObjectValue var1) throws BOSException;

    public abstract String getVersionNumber(IObjectValue var1);

    public abstract String transCube();

    public abstract String transCubeEntry();

    public abstract void setValue(BgNDataInfo var1, BigDecimal var2);

    public abstract BigDecimal getValue(BgNDataInfo var1);

    public abstract boolean canSaveValue(BigDecimal var1);

    public boolean checkCanDelete(BgNDataInfo dataInfo) {
        return dataInfo != null && dataInfo.getState() == 1;
    }

    protected boolean compareBgDataInfo(BgNDataInfo info1, BgNDataInfo info2) {
        if (info1 == null || info2 == null || info1 == info2) {
            return true;
        }
        return this.getValue(info1).compareTo(this.getValue(info2)) == 0;
    }

    public Set<String> getFilterSet() {
        return this.filterSet;
    }

    protected Map<String, IBgNData> queryFormula(Context ctx, BOSUuid billId) throws BOSException {
        HashMap<String, IBgNData> _dataMap = new HashMap<String, IBgNData>();
        if (ctx == null || billId == null) {
            return _dataMap;
        }
        BgNDataInfo _dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        this.getFilterSet().clear();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(this.getQuerySql());
            pstmt.setString(1, billId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _dataInfo = this.dealBgDataInfo(rst, true);
                _dataMap.put(_dataInfo.getFormula(), this.dealBgDataInfo(_dataInfo));
                this.getFilterSet().add(_dataInfo.getFormula());
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryFormula Error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Map<String, IBgNData>> queryFormula(Context ctx, BOSUuid billId, Set<String> orgIdSet, Set<String> formIdSet) throws BOSException {
        TempTablePool pool;
        String tmpFormTable;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashMap<String, Map<String, IBgNData>> _dataMap;
        block17: {
            _dataMap = new HashMap<String, Map<String, IBgNData>>();
            if (ctx == null) return _dataMap;
            if (billId == null) return _dataMap;
            if (orgIdSet == null) return _dataMap;
            if (orgIdSet.isEmpty()) return _dataMap;
            if (formIdSet == null) return _dataMap;
            if (formIdSet.isEmpty()) {
                return _dataMap;
            }
            BgNDataInfo _dataInfo = null;
            conn = null;
            pstmt = null;
            rst = null;
            this.getFilterSet().clear();
            String tmpTable = null;
            tmpFormTable = null;
            pool = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                int processType = DimUtils.getProcessType(conn, billId.toString());
                if (orgIdSet != null && !orgIdSet.isEmpty()) {
                    pool = TempTablePool.getInstance((Context)ctx);
                    tmpTable = this.getTmpTable(ctx, orgIdSet, conn, pool);
                }
                if (formIdSet != null && !formIdSet.isEmpty()) {
                    if (pool == null) {
                        pool = TempTablePool.getInstance((Context)ctx);
                    }
                    tmpFormTable = this.getTmpFromTable(ctx, formIdSet, conn, pool);
                }
                pstmt = conn.prepareStatement(this.getQuerySql(tmpTable, orgIdSet, tmpFormTable, formIdSet, processType));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _dataInfo = this.dealBgDataInfo(rst, true);
                    if (!_dataMap.containsKey(_dataInfo.getOrgUnitId())) {
                        _dataMap.put(_dataInfo.getOrgUnitId(), new HashMap());
                    }
                    if (!((Map)_dataMap.get(_dataInfo.getOrgUnitId())).containsKey(_dataInfo.getFormula())) {
                        ((Map)_dataMap.get(_dataInfo.getOrgUnitId())).put(_dataInfo.getFormula(), this.dealBgDataInfo(_dataInfo));
                    }
                    this.getFilterSet().add(_dataInfo.getFormula());
                }
                if (_dataMap.isEmpty() && orgIdSet != null && !orgIdSet.isEmpty()) {
                    String orgId2222222 = null;
                    for (String orgId2222222 : orgIdSet) {
                        if (StringUtils.isEmpty((String)orgId2222222)) continue;
                        _dataMap.put(orgId2222222, new HashMap());
                    }
                }
                if (tmpTable == null) break block17;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"queryFormula Error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                    catch (EASBizException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable(pool, tmpTable);
                    }
                    if (tmpFormTable != null) {
                        BgDBUtils.releaseTmpTable(pool, tmpFormTable);
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        if (tmpFormTable != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpFormTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    private String getTmpFromTable(Context ctx2, Set<String> formIdSet, Connection conn, TempTablePool pool) throws BOSException, EASBizException, SQLException {
        String tmpFromTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpFromTable + " (FID) values (?)"), formIdSet);
        return tmpFromTable;
    }

    private String getTmpTable(Context ctx, Set<String> orgIdSet, Connection conn, TempTablePool pool) throws BOSException, EASBizException, SQLException {
        String tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), orgIdSet);
        return tmpTable;
    }

    protected String getQuerySql() {
        return "select bgData.FID, bgData.FFormula, bgData." + this.getValueField() + " " + VALUE_FIELD + " , bgData.FState, bgVersion.FNumber bgVersion_FNumber, bgData.FOrgUnitId from " + this.getDataHelper().getCubeName() + " bgData, T_Mbg_BgVersion bgVersion where bgData.FVersion = bgVersion.FVersionId and bgData.Fid in (select FDataId From " + this.getDataHelper().getCubeEntryName() + " Where FFormId = ?) and bgVersion.FNumber = '" + this.getVersionNumber(this.getDataHelper().getModel()) + "'";
    }

    protected String getQuerySql(String tmpTable, Set<String> orgIdSet, String tmpFormTable, Set<String> formIdSet, int processType) {
        String sql = "select bgData.FID, bgData.FFormula, bgData." + this.getValueField() + " " + VALUE_FIELD + " , bgData.FState, bgData.FOrgUnitId, bgData.FOldValue, bgVersion.FNumber bgVersion_FNumber  from " + this.getDataHelper().getCubeName() + " bgData, " + this.getDataHelper().getCubeEntryName() + " bgEntryData, T_Mbg_BgVersion bgVersion  where bgData.FId = bgEntryData.FDataID  and bgData.FVersion = bgVersion.FVersionId  and bgVersion.FNumber = '" + this.getVersionNumber(this.getDataHelper().getModel()) + "'";
        if (this.getDataHelper().getCubeName().equalsIgnoreCase("T_MBG_BGTMPDATA")) {
            sql = sql + " and FProcessType = " + processType;
        }
        if (orgIdSet != null && !orgIdSet.isEmpty() && !StringUtils.isEmpty((String)tmpTable)) {
            sql = sql + " and bgData.FOrgUnitId in (select tmp.FID from " + tmpTable + " tmp)";
        }
        if (formIdSet != null && !formIdSet.isEmpty() && !StringUtils.isEmpty((String)tmpFormTable)) {
            sql = sql + " and bgEntryData.FFormID in (select tmpForm.FID from " + tmpFormTable + " tmpForm)";
        }
        return sql;
    }

    protected String getSchemeQuerySql(String tmpTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("select bgData.FID, bgData.FFormula, bgData." + this.getValueField() + " " + VALUE_FIELD + " , bgData.FState, bgVersion.FNumber bgVersion_FNumber , bgData.FOrgUnitId ").append("from " + this.getDataHelper().getCubeName() + " bgData ").append("inner join T_MBg_BgVersion bgVersion on bgVersion.FVersionId = bgData.FVersion ").append("where bgData.FOrgUnitId = ? ").append("and bgData.FFormula in (Select FFormula from " + tmpTable + ") and bgVersion.FNumber = '" + this.getVersionNumber(this.getDataHelper().getModel()) + "'");
        return sql.toString();
    }

    protected String getValueField() {
        return DEF_VALUE_FIELD;
    }

    protected BgNDataInfo dealBgDataInfo(ResultSet rst, boolean hasOldValue) throws SQLException {
        BgNDataInfo bgData = new BgNDataInfo();
        if (rst == null) {
            return bgData;
        }
        bgData.setBgDataId(rst.getString("FID"));
        bgData.setFormula(rst.getString("FFormula"));
        this.setValue(bgData, rst.getBigDecimal(VALUE_FIELD));
        bgData.setState(rst.getInt("FState"));
        bgData.setOrgUnitId(rst.getString("FOrgUnitId"));
        bgData.setBgVersion(rst.getString("bgVersion_FNumber"));
        return bgData;
    }

    protected BgNDataInfo dealBgDataInfo(BgNDataInfo bgData) {
        return bgData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, IBgNData> querySchemeData(Context ctx, BOSUuid billId, BOSUuid orgUnitId) throws BOSException {
        HashMap<String, IBgNData> _dataMap = new HashMap<String, IBgNData>();
        if (ctx == null || orgUnitId == null || billId == null || this.getDataHelper().getDatas().isEmpty()) {
            return _dataMap;
        }
        String _orgUnitId = orgUnitId.toString();
        HashSet<String> querySet = new HashSet<String>();
        int in = this.getDataHelper().getDatas().size();
        for (int i = 0; i < in; ++i) {
            querySet.add(this.getDataHelper().getDatas().get(i).getFormula());
        }
        querySet.removeAll(this.getFilterSet());
        if (querySet.isEmpty()) {
            return _dataMap;
        }
        long beginTime = System.currentTimeMillis();
        logger.debug((Object)"begin querySchemeData!");
        ArrayList queryList = new ArrayList(querySet);
        BgNDataInfo _dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this.getCtx());
        String tmpTableName = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            tmpTableName = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))", conn);
            BgDBUtils.insertKey((Connection)conn, (String)("INSERT INTO " + tmpTableName + "(FFormula) VALUES (?) "), queryList);
            pstmt = conn.prepareStatement(this.getSchemeQuerySql(tmpTableName));
            pstmt.setString(1, _orgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _dataInfo = this.dealBgDataInfo(rst, false);
                _dataMap.put(_dataInfo.getFormula(), this.dealBgDataInfo(_dataInfo));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"querySchemeData Error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
                catch (Exception ex2) {
                    logger.error((Object)"querySchemeData Error:", (Throwable)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                try {
                    pool.releaseDBSystemTempTable(tmpTableName, conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        try {
            pool.releaseDBSystemTempTable(tmpTableName, conn);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        logger.debug((Object)("end querySchemeData! use = " + (System.currentTimeMillis() - beginTime)));
        return _dataMap;
    }

    public void addNewValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof Map)) {
            return;
        }
        Map valueMap = (Map)value;
        if (valueMap.isEmpty()) {
            return;
        }
        this.getAddnewInstance().addnew(this.getCtx(), valueMap);
    }

    protected BgDataAddnewImpl getAddnewInstance() {
        return BgDataAddnewImpl.getInstance(this);
    }

    public void updateValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof Map)) {
            return;
        }
        Map valueMap = (Map)value;
        if (valueMap.isEmpty()) {
            return;
        }
        this.getUpdateInstance().update(this.getCtx(), valueMap);
    }

    protected BgDataUpdateImpl getUpdateInstance() {
        return BgDataUpdateImpl.getInstance(this);
    }

    public void deleteValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof Map)) {
            return;
        }
        Map valueMap = (Map)value;
        if (valueMap.isEmpty()) {
            return;
        }
        this.getDeleteInstance().delete(this.getCtx(), valueMap);
    }

    protected BgDataDeleteImpl getDeleteInstance() {
        return BgDataDeleteImpl.getInstance(this);
    }

    public void saveDataRef(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof List)) {
            return;
        }
        BOSUuid billId = this.getBillId(this.getDataHelper().getModel());
        if (billId == null) {
            return;
        }
        String _billId = billId.toString();
        String[] sqlParam = null;
        ArrayList<String[]> bgDataIds = new ArrayList<String[]>();
        List dataRefs = (List)value;
        if (dataRefs != null && !dataRefs.isEmpty()) {
            for (String bgDataId : dataRefs) {
                sqlParam = new String[]{_billId, bgDataId};
                bgDataIds.add(sqlParam);
            }
        }
        if (!bgDataIds.isEmpty()) {
            String tmpTable = null;
            Connection conn = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                tmpTable = pool.createDBSystemTempTable("Create Table TEML_KSQL_1 (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)", conn);
                if (tmpTable != null) {
                    BgDBUtils.insertValue1((Connection)conn, (String)("Insert Into " + tmpTable + " (FFormID, FDataID) values (?,?)"), bgDataIds);
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + this.getDataHelper().getCubeEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + tmpTable + " where not exists (select FDataID from " + this.getDataHelper().getCubeEntryName() + " where FFormID = " + tmpTable + ".FFormID and FDataID = " + tmpTable + ".FDataID)"));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"saveDataRef Error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            finally {
                if (tmpTable != null) {
                    try {
                        pool.releaseDBSystemTempTable(tmpTable, conn);
                    }
                    catch (Exception exception) {}
                }
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }
}

