/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.SQLUtil;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.mbg.BgActualRecordCollection;
import com.kingdee.eas.ma.mbg.BgActualRecordException;
import com.kingdee.eas.ma.mbg.BgActualRecordFactory;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsCollection;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgActualRecord;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListControlUtils;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.utils.ClosureUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgUnAuditCheckResult;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ActualRecordControlUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.utils.ActualRecordControlUtils");
    private Map permissionOrgMap = new HashMap();
    private Set<String> sysActDataID = new HashSet<String>();
    private BgSchemeInfo schemeInfo = null;
    private Context ctx = null;
    private Map<String, BgSchemeDimensionHelper> bgSchemeHelperMap = new HashMap<String, BgSchemeDimensionHelper>();

    public BgSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(BgSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    public Set<String> getSysActDataID() {
        return this.sysActDataID;
    }

    public void setSysActDataID(Set<String> sysActDataID) {
        this.sysActDataID = sysActDataID;
    }

    private BgSchemeDimensionHelper getBgSchemeHelper(String bgSchemeId) throws EASBizException, BOSException {
        if (!this.bgSchemeHelperMap.containsKey(bgSchemeId)) {
            this.bgSchemeHelperMap.put(bgSchemeId, new BgSchemeDimensionHelper(this.ctx, bgSchemeId));
        }
        return this.bgSchemeHelperMap.get(bgSchemeId);
    }

    private RelationUtils getRelationUtils(String bgSchemeId) throws EASBizException, BOSException {
        return RelationUtils.getInstance(this.getBgSchemeHelper(bgSchemeId));
    }

    public ActualRecordControlUtils(Context ctx) {
        this.ctx = ctx;
    }

    public static void addResult(List<String[]> resultList, BgActualRecordInfo info) {
        resultList.add(new String[]{info.getBgForm().getOrgUnit().getName(), info.getNumber()});
    }

    public List<String[]> auditSubOrgActualRecord(BOSUuid billId, BOSUuid audBgOrgUnitId, BOSUuid audUserId, int valueType, int bgDataState, String permissionItem, Set<String> successAuditIds) throws EASBizException, BOSException {
        String tmpAccIntTable;
        TempTablePool pool;
        String tmpTableName;
        String FdataIdTable;
        long begin;
        ArrayList<String[]> result;
        block32: {
            if (successAuditIds == null) {
                successAuditIds = new HashSet<String>();
            }
            result = new ArrayList<String[]>();
            if (this.ctx == null || billId == null || audBgOrgUnitId == null || audUserId == null || successAuditIds != null && successAuditIds.contains(billId.toString())) {
                return result;
            }
            this.setPermissionOrgMap(audUserId, permissionItem);
            logger.debug((Object)"begin audit actualRecordForm ");
            begin = System.currentTimeMillis();
            BgOrgUnitInfo bgOrgUnitInfo = this.getBgOrgUnitInfo(this.ctx, audBgOrgUnitId);
            IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(this.ctx);
            BgActualRecordInfo bgActualRecordInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelectorItemColls());
            if (bgActualRecordInfo == null) {
                return result;
            }
            String bgSchemeId = bgActualRecordInfo.getBgForm().getBgScheme().getId().toString();
            String bgCurrencyId = bgActualRecordInfo.getBgForm().getCurrency().getId().toString();
            String bgPeriodId = bgActualRecordInfo.getBgForm().getBgPeriod().getId().toString();
            String bgVersionId = bgActualRecordInfo.getBgForm().getBgVersion().getId().toString();
            String bgActualPeriodId = bgActualRecordInfo.getBgPeriod().getId().toString();
            String orgUnitId = bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString();
            String bgRootTemplateId = bgActualRecordInfo.getBgForm().getBgTemplate().getRootId().toString();
            BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgActualRecordInfo.getBgForm().getBgScheme());
            if (schemeInfo == null) {
                return result;
            }
            this.setSchemeInfo(schemeInfo);
            String bgOrgViewId = schemeInfo.getEditOrgViewId().toString();
            schemeInfo.setPeriod(bgActualRecordInfo.getBgPeriod().getPeriodType());
            BgFormInfo formInfo = BgViewServerHelper.getBgFormInfo(this.ctx, bgActualRecordInfo.getBgForm().getId(), false);
            BgSpecialItemsCollection bgSpecialItems = formInfo.getBgSpecialItems();
            String actualCube = BgCubeUtils.getActualCubeName(schemeInfo.getRefCube());
            String dailyTable = BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube());
            String dailyEntry = BgCubeUtils.getDailyActualEntryCubeName(schemeInfo.getRefCube());
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.ctx, schemeInfo.getId().toString());
            List<String> refFields = schemeHelper.getRefDims();
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(this.ctx, schemeHelper, actualCube);
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            String refFieldStr = DimUtils.getDimField(refFields);
            FdataIdTable = null;
            String orgUnitTmpTable = null;
            tmpTableName = null;
            List<bgBaseData> bgBaseDatas = null;
            Connection conn = null;
            pool = null;
            List<String> orgUnitIds = null;
            Set<String> pOrgUnitIds = null;
            HashSet<String> upBgDataIds = new HashSet<String>();
            ArrayList<String> auditedActualForm = new ArrayList<String>();
            HashSet<String> tempSet = new HashSet<String>();
            tmpAccIntTable = null;
            try {
                conn = BgDBUtils.getConnection((Context)this.ctx);
                pool = TempTablePool.getInstance((Context)this.ctx);
                orgUnitIds = this.getSubOrgUnitIds(conn, bgOrgViewId, this.getOrgLongNumber(conn, bgOrgViewId, orgUnitId, bgOrgUnitInfo.getLongNumber()));
                if (orgUnitIds.isEmpty()) {
                    ArrayList<String[]> arrayList = result;
                    return arrayList;
                }
                pOrgUnitIds = this.getParentOrgUnitIds(conn, bgOrgViewId, bgOrgUnitInfo.getLongNumber());
                orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                tmpAccIntTable = BgSchemeConvertToAccIntUtils.createTmpBgDataTable(this.ctx, conn, pool, schemeHelper, "T_MBG_BgAccInt");
                if (accIntHelper.isUseAccInt()) {
                    pool.createIndex(tmpAccIntTable, "F2", false, false);
                }
                HashSet<String> permOrgUnitIds = new HashSet<String>();
                for (int i = 0; i < orgUnitIds.size(); ++i) {
                    if (!this.permissionOrgMap.containsKey(orgUnitIds.get(i))) continue;
                    permOrgUnitIds.add(orgUnitIds.get(i));
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), permOrgUnitIds);
                List<String> bgActualRecordIds = this.getActualRecordIds(conn, bgSchemeId, orgUnitTmpTable, bgRootTemplateId, bgPeriodId, bgCurrencyId, bgVersionId, bgActualPeriodId, auditedActualForm, bgSpecialItems);
                if (!bgActualRecordIds.isEmpty()) {
                    for (String actualRecordId : bgActualRecordIds) {
                        BgActualRecordInfo bgactualRecordInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(actualRecordId), this.get4SelectorItemColls());
                        String bgOrgId = bgactualRecordInfo.getBgForm().getOrgUnit().getId().toString();
                        bgBaseDatas = this.queryBaseData(conn, dailyTable, dailyEntry, actualRecordId, pOrgUnitIds, orgUnitIds, bgOrgId);
                        logger.debug((Object)("first way : bgbasedatas-" + bgBaseDatas.size()));
                        if (bgBaseDatas.isEmpty()) continue;
                        HashSet<String> fdataIds = new HashSet<String>();
                        for (int j = 0; j < bgBaseDatas.size(); ++j) {
                            fdataIds.add(bgBaseDatas.get(j).getFid());
                        }
                        this.getSysActDataID().addAll(fdataIds);
                        FdataIdTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + FdataIdTable + " (FID) values (?)"), fdataIds);
                        tmpTableName = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEMPTABLE (FFormula NVARCHAR(300), FVersion INT DEFAULT 0 NOT NULL)");
                        for (String cubeName : cubeNames) {
                            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTableName + "(FFormula, FVersion) Select FFormula, FVersion from " + cubeName + " where FOrgUnitId = ?"), (Object[])new Object[]{accIntHelper.convertOrgObject(bgOrgId)});
                        }
                        this.updateAudOrgUnitCheck(bgBaseDatas, bgDataState);
                        this.updateActualRecord(conn, pool, actualRecordId, bgOrgId, dailyTable, dailyEntry, accIntHelper, refFieldStr, tmpTableName, FdataIdTable, tmpAccIntTable);
                        String[] cubeName = new String[]{dailyTable, dailyEntry, BgCubeUtils.getControlCubeName(schemeInfo.getRefCube()), tmpTableName, FdataIdTable};
                        this.writeBgCtrlRecord(conn, bgactualRecordInfo, cubeName);
                        Set<String> tmpSet = this.updateBaseData(conn, dailyTable, bgBaseDatas, bgOrgUnitInfo.getOrgUnitID(), audUserId.toString(), bgActualRecordInfo, true);
                        if (tmpSet == null || tmpSet.isEmpty()) continue;
                        upBgDataIds.addAll(tmpSet);
                    }
                    bgActualRecordIds.removeAll(auditedActualForm);
                    tempSet.addAll(bgActualRecordIds);
                    if (successAuditIds != null) {
                        successAuditIds.addAll(tempSet);
                    }
                    this.updateAudFormState(this.ctx, conn, bgActualRecordInfo, bgActualRecordIds, audUserId, 2);
                }
                IBgDimensionManagerBase manager = null;
                IMbgViewBase view = this.loadViewManager(formInfo, orgUnitId);
                if (view != null && view.getSheetManagers() != null) {
                    int in = view.getSheetManagers().size();
                    for (int i = 0; i < in; ++i) {
                        manager = view.getSheetManagers().get(i).getDimensionManager();
                        if (manager == null) continue;
                        IBizData bizData = this.getBizDataInstance(view);
                        bgBaseDatas = bizData.queryBaseData(conn, pool, dailyTable, view, manager, formInfo, schemeInfo, orgUnitIds, pOrgUnitIds, upBgDataIds, bgActualPeriodId);
                        if (!bgBaseDatas.isEmpty()) {
                            HashSet<String> fdataIds = new HashSet<String>();
                            for (int j = 0; j < bgBaseDatas.size(); ++j) {
                                if (bgBaseDatas.get(j).getState() != 1 && !orgUnitIds.contains(bgBaseDatas.get(j).getAudOrgUnitId())) continue;
                                fdataIds.add(bgBaseDatas.get(j).getFid());
                            }
                            if (fdataIds.isEmpty()) continue;
                            StringBuffer sql = null;
                            Set<Object> dataOrgIds = new HashSet();
                            dataOrgIds = this.getDataOrgIds(conn, dailyTable, fdataIds);
                            Object[] strArr = new Object[dataOrgIds.size()];
                            int r = 0;
                            tmpTableName = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEMPTABLE (FFormula NVARCHAR(300), FVersion INT DEFAULT 0 NOT NULL)");
                            sql = new StringBuffer("Insert Into " + tmpTableName + "(FFormula, FVersion) Select FFormula, FVersion from " + DimensionConstants.CUBE_NAME + " where FOrgUnitId IN (");
                            for (String string : dataOrgIds) {
                                sql.append("?,");
                                strArr[r++] = accIntHelper.convertOrgObject(string);
                            }
                            for (String string : cubeNames) {
                                BgDBUtils.executeUpdate((Connection)conn, (String)(sql.substring(0, sql.length() - 1) + ")").replace(DimensionConstants.CUBE_NAME, string), (Object[])strArr);
                            }
                            FdataIdTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + FdataIdTable + " (FID) values (?)"), fdataIds);
                            this.updateAudOrgUnitCheck(bgBaseDatas, bgDataState);
                            this.updateActualRecord(conn, pool, null, orgUnitId, dailyTable, dailyEntry, accIntHelper, refFieldStr, tmpTableName, FdataIdTable, tmpAccIntTable);
                            String[] cubeName = new String[]{dailyTable, dailyEntry, BgCubeUtils.getControlCubeName(schemeInfo.getRefCube()), tmpTableName, FdataIdTable};
                            this.writeBgCtrlRecord(conn, bgActualRecordInfo, cubeName);
                            Set<String> set = this.updateBaseData(conn, dailyTable, bgBaseDatas, bgOrgUnitInfo.getOrgUnitID(), audUserId.toString(), bgActualRecordInfo, true);
                            if (set != null) {
                                upBgDataIds.addAll(set);
                            }
                        }
                        tempSet.add(billId.toString());
                        if (successAuditIds == null) continue;
                        successAuditIds.add(billId.toString());
                    }
                }
                ActualRecordControlUtils.addResult(result, bgActualRecordInfo);
                SQLUtils.cleanup((Connection)conn);
                if (orgUnitTmpTable == null) break block32;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
                if (orgUnitTmpTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, orgUnitTmpTable);
                }
                if (tmpTableName != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
                }
                if (FdataIdTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, FdataIdTable);
                }
                if (tmpAccIntTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpAccIntTable);
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)orgUnitTmpTable);
        }
        if (tmpTableName != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
        }
        if (FdataIdTable != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, FdataIdTable);
        }
        if (tmpAccIntTable != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpAccIntTable);
        }
        logger.debug((Object)"end Audit actualRecordForm Data!");
        long end = System.currentTimeMillis();
        logger.debug((Object)("audit actualRecordForm cost " + (end - begin)));
        return result;
    }

    private BgOrgUnitInfo getBgOrgUnitInfo(Context ctx, BOSUuid bgOrgUnitId) throws EASBizException, BOSException {
        return BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, orgUnitId, longNumber where id = '" + bgOrgUnitId + "'");
    }

    private BgOrgUnitCollection getBgOrgUnitInfoByorgUnitIdAndViewID(Context ctx, String bgOrgUnitId, String viewID) throws EASBizException, BOSException {
        return BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id, orgUnitId, longNumber where orgUnitId = '" + bgOrgUnitId + "' and viewId = '" + viewID + "'");
    }

    public static BgOrgUnitInfo getBgOrgUnitInfoByorgUnitIdAndViewID(Context ctx, String bgOrgUnitId, String viewID, boolean isVirtual) throws EASBizException, BOSException {
        return BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, orgUnitId,name,number, longNumber where isVirtual = 0 and orgUnitId = '" + bgOrgUnitId + "' and viewId = '" + viewID + "'");
    }

    private BgOrgUnitCollection getBgOrgUnitCollectionByViewID(Context ctx, String viewID) throws EASBizException, BOSException {
        return BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id, name,orgUnitId, longNumber,number,isLeaf where  viewId = '" + viewID + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgOrgUnitInfo getFirstOrgUnit(Context ctx, List<String> orgUnitIds, String bgOrgViewId) {
        BgOrgUnitInfo result = new BgOrgUnitInfo();
        Connection conn = null;
        try {
            Iterator iterator;
            conn = BgDBUtils.getConnection((Context)ctx);
            StringBuffer query = new StringBuffer();
            query.append("select fid, forgUnitId,fname_" + ctx.getLocale() + " ,fnumber,flongNumber from T_mbg_BgOrgUnit where  fviewID = '" + bgOrgViewId + "' and forgUnitid in( ");
            for (int i = 1; i < 50; ++i) {
                query.append("?,");
            }
            query.append("?)  order by flongNumber desc ");
            List executeBatchQuery = BgDBUtils.executeBatchQuery((Connection)conn, (String)query.toString(), new ArrayList<String>(orgUnitIds));
            if (executeBatchQuery != null && !executeBatchQuery.isEmpty() && (iterator = executeBatchQuery.iterator()).hasNext()) {
                Object[] obj = (Object[])iterator.next();
                result.setId(BOSUuid.read((String)((String)obj[0])));
                result.setOrgUnitID((String)obj[1]);
                result.setName((String)obj[2]);
                result.setNumber((String)obj[3]);
                result.setLongNumber((String)obj[3]);
                BgOrgUnitInfo bgOrgUnitInfo = result;
                return bgOrgUnitInfo;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    private Set<String> getDataOrgIds(Connection conn, String dailyTable, Set<String> fdataIds) throws SQLException {
        StringBuffer sql = null;
        HashSet<String> dataOrgIds = new HashSet<String>();
        sql = new StringBuffer("SELECT distinct forgunitid FROM " + dailyTable + " WHERE FId IN (");
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.addAll(fdataIds);
        int batchNum = 1000;
        for (int i = 0; i < batchNum; ++i) {
            if (i == batchNum - 1) {
                sql.append("?)");
                continue;
            }
            sql.append("?,");
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int size = dataList.size();
            int count = (size - 1) / batchNum + 1;
            int pos = 0;
            for (int index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)dataList.get(pos));
                    } else {
                        pstmt.setString(k, "#");
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    dataOrgIds.add(rst.getString("forgunitid"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return dataOrgIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getOrgNumById(Set<String> success) throws BOSException {
        if (this.ctx == null || success.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> tempRes = new ArrayList<String>();
        IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(this.ctx);
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("bgForm.orgUnit.name"));
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", success, CompareType.INCLUDE));
            view.setFilter(filter);
            BgActualRecordCollection actualRecordColls = iface.getBgActualRecordCollection(view);
            for (int i = 0; i < actualRecordColls.size(); ++i) {
                String msg = actualRecordColls.get(i).getBgForm().getOrgUnit().getName() + "@" + actualRecordColls.get(i).getNumber();
                tempRes.add(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempRes;
    }

    public List<String[]> unAuditSubOrgActualRecord(BOSUuid billId, BOSUuid audBgOrgUnitId, BOSUuid audUserId, int valueType, int bgDataState, String permissionItem, List<String> cantUnAuditIds, Map<String, Map<String, String[]>> dealActualRecords, Map<String, List<String>> parentOrgNumbers) throws EASBizException, BOSException {
        TempTablePool pool;
        String toDeleteData;
        String FdataIdTable;
        String tmpTableName;
        ArrayList<String[]> success;
        block37: {
            success = new ArrayList<String[]>();
            if (this.ctx == null || billId == null || audBgOrgUnitId == null || audUserId == null) {
                return success;
            }
            this.setPermissionOrgMap(audUserId, permissionItem);
            long begin = System.currentTimeMillis();
            IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(this.ctx);
            BgActualRecordInfo bgActualRecordInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelectorItemColls());
            BgActualRecordInfo tempInfo = null;
            if (bgActualRecordInfo == null) {
                return success;
            }
            BgOrgUnitInfo bgOrgUnit = this.getBgOrgUnitInfo(this.ctx, audBgOrgUnitId);
            String bgSchemeId = bgActualRecordInfo.getBgForm().getBgScheme().getId().toString();
            String bgCurrencyId = bgActualRecordInfo.getBgForm().getCurrency().getId().toString();
            String bgPeriodId = bgActualRecordInfo.getBgForm().getBgPeriod().getId().toString();
            String bgVersionId = bgActualRecordInfo.getBgForm().getBgVersion().getId().toString();
            String bgActualPeriodId = bgActualRecordInfo.getBgPeriod().getId().toString();
            String orgUnitId = bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString();
            String bgRootTemplateId = bgActualRecordInfo.getBgForm().getBgTemplate().getRootId().toString();
            BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgActualRecordInfo.getBgForm().getBgScheme());
            if (schemeInfo == null) {
                return success;
            }
            this.setSchemeInfo(schemeInfo);
            schemeInfo.setPeriod(bgActualRecordInfo.getBgPeriod().getPeriodType());
            String bgOrgViewId = schemeInfo.getEditOrgViewId().toString();
            BgFormInfo formInfo = BgViewServerHelper.getBgFormInfo(this.ctx, bgActualRecordInfo.getBgForm().getId(), false);
            BgSpecialItemsCollection bgSpecialItems = formInfo.getBgSpecialItems();
            String actualCube = BgCubeUtils.getActualCubeName(schemeInfo.getRefCube());
            String dailyTable = BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube());
            String dailyEntry = BgCubeUtils.getDailyActualEntryCubeName(schemeInfo.getRefCube());
            String conCube = BgCubeUtils.getControlCubeName(schemeInfo.getRefCube());
            BgSchemeDimensionHelper schemeHelper = this.getBgSchemeHelper(schemeInfo.getId().toString());
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(this.ctx, schemeHelper, actualCube);
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            tmpTableName = null;
            String orgUnitTmpTable = null;
            FdataIdTable = null;
            toDeleteData = null;
            List<Object> bgBaseDatas = new ArrayList();
            Connection conn = null;
            Statement pstmt = null;
            pool = null;
            List<String> orgUnitIds = null;
            List<String> unAuditOrgChildOrgs = null;
            Set<String> pOrgUnitIds = null;
            HashSet<String> upBgDataIds = new HashSet<String>();
            ArrayList<String> auditedActualForm = new ArrayList<String>();
            HashSet tempSet = new HashSet();
            try {
                conn = BgDBUtils.getConnection((Context)this.ctx);
                pool = TempTablePool.getInstance((Context)this.ctx);
                StringBuffer sql = new StringBuffer();
                orgUnitIds = this.getSubOrgUnitIds(conn, bgOrgViewId, this.getOrgLongNumber(conn, bgOrgViewId, orgUnitId, bgOrgUnit.getLongNumber()));
                if (orgUnitIds.isEmpty()) {
                    ArrayList<String[]> arrayList = success;
                    return arrayList;
                }
                pOrgUnitIds = this.getParentOrgUnitIds(conn, bgOrgViewId, bgOrgUnit.getLongNumber());
                unAuditOrgChildOrgs = this.getSubOrgUnitIds(conn, bgOrgViewId, this.getOrgLongNumber(conn, bgOrgViewId, bgOrgUnit.getOrgUnitID(), bgOrgUnit.getLongNumber()));
                orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                HashSet<String> permOrgUnitIds = new HashSet<String>();
                for (int i = 0; i < orgUnitIds.size(); ++i) {
                    if (!this.permissionOrgMap.containsKey(orgUnitIds.get(i))) continue;
                    permOrgUnitIds.add(orgUnitIds.get(i));
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), permOrgUnitIds);
                List<String> bgActualRecordIds = this.getActualRecordIds(conn, bgSchemeId, orgUnitTmpTable, bgRootTemplateId, bgPeriodId, bgCurrencyId, bgVersionId, bgActualPeriodId, auditedActualForm, bgSpecialItems);
                ArrayList cantUnAuditActualIds = new ArrayList();
                HashMap<String, BgOrgUnitInfo> orgMap = new HashMap<String, BgOrgUnitInfo>();
                BgOrgUnitCollection bgOrgUnitCollection = this.getBgOrgUnitCollectionByViewID(this.ctx, bgOrgViewId);
                for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                    orgMap.put(bgOrgUnitCollection.get(i).getOrgUnitID(), bgOrgUnitCollection.get(i));
                }
                if (!bgActualRecordIds.isEmpty()) {
                    StringBuffer resultOrgId = new StringBuffer();
                    List checkBatchUnAudit = this.checkBatchUnAudit(bgActualRecordIds, audUserId, audBgOrgUnitId);
                    if (!checkBatchUnAudit.isEmpty()) {
                        for (int i = 0; i < checkBatchUnAudit.size(); ++i) {
                            BgUnAuditCheckResult object = (BgUnAuditCheckResult)checkBatchUnAudit.get(i);
                            if (object.isCanUnAudit() || !auditedActualForm.contains(object.getId())) continue;
                            auditedActualForm.remove(object.getId());
                        }
                    }
                    for (String bgActualRecordId : bgActualRecordIds) {
                        tempInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgActualRecordId), this.getSelectorItemColls());
                        FullOrgUnitInfo bgOrgInfo = tempInfo.getBgForm().getOrgUnit();
                        tempInfo.getBgForm().setOrgUnit(((BgOrgUnitInfo)orgMap.get(bgOrgInfo.getId().toString())).castToFullOrgUnitInfo());
                        boolean checkData = false;
                        boolean checkParentForm = false;
                        boolean isHasSubData = false;
                        boolean isHasParentData = false;
                        resultOrgId.setLength(0);
                        if (!checkBatchUnAudit.isEmpty()) {
                            for (int i = 0; i < checkBatchUnAudit.size(); ++i) {
                                BgUnAuditCheckResult object = (BgUnAuditCheckResult)checkBatchUnAudit.get(i);
                                if (!object.getId().equals(bgActualRecordId)) continue;
                                checkData = object.isHaveData();
                                isHasSubData = object.isHaveSubData();
                                isHasParentData = object.isHaveParentbData();
                                break;
                            }
                        }
                        if (checkParentForm = ActualRecordControlUtils.checkParentNoEdit(tempInfo, dealActualRecords, parentOrgNumbers, resultOrgId)) {
                            if (!checkData || !isHasSubData || isHasParentData) {
                                cantUnAuditIds.add(bgActualRecordId);
                            }
                        } else if (checkData && (!isHasSubData || isHasParentData) && (isHasSubData || isHasParentData || ((BgOrgUnitInfo)orgMap.get(bgOrgInfo.getId().toString())).isIsLeaf())) {
                            cantUnAuditIds.add(bgActualRecordId);
                        }
                        if ((bgBaseDatas = this.queryBaseData(conn, dailyTable, dailyEntry, bgActualRecordId, pOrgUnitIds, unAuditOrgChildOrgs, bgOrgInfo.getId().toString())).isEmpty()) continue;
                        this.UnAudOrgUnitCheck(bgBaseDatas, bgDataState);
                        Set<String> tmpSet = this.updateBaseData(conn, dailyTable, bgBaseDatas, bgOrgUnit.getOrgUnitID(), audUserId.toString(), bgActualRecordInfo, false);
                        if (tmpSet != null && !tmpSet.isEmpty()) {
                            upBgDataIds.addAll(tmpSet);
                        }
                        this.getSysActDataID().addAll(upBgDataIds);
                        tmpTableName = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEMPTABLE (FFormula NVARCHAR(300), FVersion INT DEFAULT 0 NOT NULL)");
                        for (String cubeName : cubeNames) {
                            BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpTableName + "(FFormula, FVersion) Select a.FFormula, a.FVersion from " + cubeName + " a left join " + dailyEntry + " e on e.FDATAID = a.FID  where a.FOrgUnitId = ? and e.FFORMID = ? "), (Object[])new Object[]{accIntHelper.convertOrgObject(bgOrgInfo.getId().toString()), bgActualRecordId});
                        }
                        this.updateUnActualRecord(conn, pool, dailyTable, dailyEntry, accIntHelper, bgActualRecordId, tmpSet);
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Delete from " + conCube + " where FBillID = ? or (exists (select * from " + tmpTableName + " t where " + conCube + ".FFormula = t.FFormula and " + conCube + ".FVERSION = t.FVersion) and " + conCube + ".FBIZORGUNITID = ?  and " + conCube + ".FBILLTYPE ='87500EF6' )"), (Object[])new Object[]{bgActualRecordId, bgOrgInfo.getId().toString()});
                    }
                    if (cantUnAuditIds != null) {
                        auditedActualForm.removeAll(cantUnAuditIds);
                    }
                    auditedActualForm.removeAll(cantUnAuditActualIds);
                    this.updateUnActualRecordForm(conn, auditedActualForm);
                }
                IBgDimensionManagerBase manager = null;
                IMbgViewBase view = this.loadViewManager(formInfo, orgUnitId);
                if (view != null && view.getSheetManagers() != null) {
                    int in = view.getSheetManagers().size();
                    for (int i = 0; i < in; ++i) {
                        IBizData bizData;
                        manager = view.getSheetManagers().get(i).getDimensionManager();
                        if (manager == null || (bgBaseDatas = (bizData = this.getBizDataInstance(view)).queryBaseData(conn, pool, dailyTable, view, manager, formInfo, schemeInfo, orgUnitIds, pOrgUnitIds, upBgDataIds, bgActualPeriodId)).isEmpty()) continue;
                        HashSet<String> fdataIds = new HashSet<String>();
                        for (int j = 0; j < bgBaseDatas.size(); ++j) {
                            if (((bgBaseData)bgBaseDatas.get(j)).getState() != 9) continue;
                            fdataIds.add(((bgBaseData)bgBaseDatas.get(j)).getFid());
                        }
                        if (fdataIds.isEmpty()) continue;
                        this.getSysActDataID().addAll(fdataIds);
                        String[] strArr = new String[fdataIds.size()];
                        boolean r = false;
                        if (FdataIdTable == null) {
                            FdataIdTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                        } else {
                            BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + FdataIdTable));
                        }
                        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + FdataIdTable + " (FID) values (?)"), fdataIds);
                        toDeleteData = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEMPTABLE (FFormula NVARCHAR(300), FOrgUnitId VARCHAR(44),FVersion INT DEFAULT 0 NOT NULL)");
                        sql = new StringBuffer("Insert Into " + toDeleteData + "(FFormula, FVersion, FOrgUnitId) Select FFormula, FVersion,FOrgUnitId from " + dailyTable + " where exists (select FID from " + FdataIdTable + " where FID = " + dailyTable + ".FID)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                        this.UnAudOrgUnitCheck(bgBaseDatas, bgDataState);
                        Set<String> tmpSet = this.updateBaseData(conn, dailyTable, bgBaseDatas, bgOrgUnit.getOrgUnitID(), audUserId.toString(), bgActualRecordInfo, false);
                        this.updateUnActualRecord(conn, pool, dailyTable, dailyEntry, accIntHelper, null, tmpSet);
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Delete from " + conCube + " where " + conCube + ".FBILLTYPE ='87500EF6' and exists (select * from " + toDeleteData + " t where " + conCube + ".FFormula = t.FFormula and " + conCube + ".FVERSION = t.FVersion and " + conCube + ".FbizOrgUnitId = t.FOrgUnitId)"));
                    }
                }
                ActualRecordControlUtils.addResult(success, bgActualRecordInfo);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                if (orgUnitTmpTable == null) break block37;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                if (orgUnitTmpTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, orgUnitTmpTable);
                }
                if (tmpTableName != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
                }
                if (FdataIdTable != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, FdataIdTable);
                }
                if (toDeleteData != null) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, toDeleteData);
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)orgUnitTmpTable);
        }
        if (tmpTableName != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
        }
        if (FdataIdTable != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, FdataIdTable);
        }
        if (toDeleteData != null) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, toDeleteData);
        }
        long end = System.currentTimeMillis();
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnActualRecordForm(Connection conn, List<String> bgActualRecordIds) throws SQLException {
        if (conn == null || bgActualRecordIds == null || bgActualRecordIds.isEmpty()) {
            return;
        }
        int batchIndex = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("update t_mbg_bgactualrecord set FState = ?, FAuditorId = null , FAuditedTime = null where FID = ?");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (String bgActualRecordId : bgActualRecordIds) {
                pstmt.setInt(1, 1);
                pstmt.setString(2, bgActualRecordId);
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtil.cleanup(pstmt);
            throw throwable;
        }
        SQLUtil.cleanup((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BgUnAuditCheckResult checkCanUnAudit(String actualRecordId, String auditBgOrgId, String auditUserId) throws BOSException, EASBizException {
        Object object;
        String orgUnitTmpTable;
        IRowSet rst;
        Statement pstmt;
        Connection conn;
        TempTablePool pool;
        block36: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            if (this.ctx == null) return null;
                            if (actualRecordId == null) return null;
                            if (auditBgOrgId == null) return null;
                            if (auditUserId == null) {
                                return null;
                            }
                            IBgActualRecord iface = BgActualRecordFactory.getLocalInstance(this.ctx);
                            BgActualRecordInfo bgActualRecordInfo = iface.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(actualRecordId), this.getSelectorItemColls());
                            if (bgActualRecordInfo == null) {
                                return null;
                            }
                            BgOrgUnitInfo bgOrgUnit = this.getBgOrgUnitInfo(this.ctx, BOSUuid.read((String)auditBgOrgId));
                            String bgSchemeId = bgActualRecordInfo.getBgForm().getBgScheme().getId().toString();
                            String bgCurrencyId = bgActualRecordInfo.getBgForm().getCurrency().getId().toString();
                            String bgPeriodId = bgActualRecordInfo.getBgForm().getBgPeriod().getId().toString();
                            String bgVersionId = bgActualRecordInfo.getBgForm().getBgVersion().getId().toString();
                            String bgActualPeriodId = bgActualRecordInfo.getBgPeriod().getId().toString();
                            String orgUnitId = bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString();
                            String bgRootTemplateId = bgActualRecordInfo.getBgForm().getBgTemplate().getRootId().toString();
                            String bgFormId = bgActualRecordInfo.getBgForm().getId().toString();
                            BgFormInfo formInfo = BgViewServerHelper.getBgFormInfo(this.ctx, bgActualRecordInfo.getBgForm().getId(), false);
                            BgSpecialItemsCollection bgSpecialItems = formInfo.getBgSpecialItems();
                            BgSchemeInfo schemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(this.ctx, bgActualRecordInfo.getBgForm().getBgScheme());
                            if (schemeInfo == null) {
                                return null;
                            }
                            String bgOrgViewId = schemeInfo.getEditOrgViewId().toString();
                            schemeInfo.setPeriod(bgActualRecordInfo.getBgPeriod().getPeriodType());
                            String dailyTable = BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube());
                            String dailyEntry = BgCubeUtils.getDailyActualEntryCubeName(schemeInfo.getRefCube());
                            pool = TempTablePool.getInstance((Context)this.ctx);
                            conn = null;
                            pstmt = null;
                            rst = null;
                            orgUnitTmpTable = null;
                            bgBaseData data = null;
                            List<String> orgUnitIds = null;
                            List<String> tmpList = null;
                            Set<String> pOrgUnitIds = null;
                            HashSet<String> subOrgUnitIds = new HashSet<String>();
                            ArrayList<String> auditedActualForm = new ArrayList<String>();
                            try {
                                conn = BgDBUtils.getConnection((Context)this.ctx);
                                orgUnitIds = this.getSubOrgUnitIds(conn, bgOrgViewId, this.getOrgLongNumber(conn, bgOrgViewId, orgUnitId.toString(), bgOrgUnit.getLongNumber()));
                                if (orgUnitIds.isEmpty()) {
                                    BgUnAuditCheckResult bgUnAuditCheckResult = null;
                                    return bgUnAuditCheckResult;
                                }
                                String audOrgLongNumber = bgOrgUnit.getLongNumber();
                                pOrgUnitIds = this.getParentOrgUnitIds(conn, bgOrgViewId, audOrgLongNumber);
                                tmpList = this.getSubOrgUnitIds(conn, bgOrgViewId, audOrgLongNumber);
                                subOrgUnitIds.addAll(tmpList);
                                orgUnitTmpTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + orgUnitTmpTable + " (FID) values (?)"), orgUnitIds);
                                List<String> bgActualRecordIds = this.getActualRecordIds(conn, bgSchemeId, orgUnitTmpTable, bgRootTemplateId, bgPeriodId, bgCurrencyId, bgVersionId, bgActualPeriodId, auditedActualForm, bgSpecialItems);
                                boolean isHavaData = false;
                                boolean isHavaParentData = false;
                                boolean isHaveSubData = false;
                                if (!bgActualRecordIds.isEmpty()) {
                                    String sql = "select FID, FState, FAudOrgUnitID from " + dailyTable + " where FID in (select FDataID from " + dailyEntry + " where FFormID = ?)";
                                    for (String bgActualRecordId : bgActualRecordIds) {
                                        if (isHavaParentData && isHaveSubData) continue;
                                        try {
                                            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{bgActualRecordId});
                                            while (rst.next()) {
                                                if (!isHavaData) {
                                                    isHavaData = true;
                                                }
                                                data = new bgBaseData();
                                                data.setFid(rst.getString("FID"));
                                                data.setState(rst.getInt("FState"));
                                                data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                                if (!isHaveSubData && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                                                    isHaveSubData = true;
                                                }
                                                if (!isHavaParentData && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                                                    isHavaParentData = true;
                                                }
                                                if (!isHavaParentData || !isHaveSubData) continue;
                                                break;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            SQLUtils.cleanup(rst);
                                            throw throwable;
                                        }
                                        SQLUtils.cleanup((ResultSet)rst);
                                    }
                                }
                                if (!isHaveSubData || !isHavaParentData) {
                                    IBgDimensionManagerBase manager = null;
                                    BgUnAuditCheckData checkData = null;
                                    IMbgViewBase view = this.loadViewManager(formInfo, orgUnitId);
                                    if (view != null && view.getSheetManagers() != null) {
                                        int in = view.getSheetManagers().size();
                                        for (int i = 0; i < in; ++i) {
                                            manager = view.getSheetManagers().get(i).getDimensionManager();
                                            if (manager == null || isHaveSubData && isHavaParentData) continue;
                                            IBizData bizData = this.getBizDataInstance(view);
                                            checkData = bizData.checkData(conn, pool, dailyTable, view, manager, formInfo, schemeInfo, orgUnitIds, pOrgUnitIds, subOrgUnitIds, new HashSet<String>(), isHaveSubData, isHavaParentData, bgActualPeriodId);
                                            isHaveSubData = checkData.isHaveSubData;
                                            isHavaParentData = checkData.isHavaParentData();
                                            if (isHaveSubData || isHavaParentData) {
                                                isHavaData = true;
                                            }
                                            if (isHavaParentData && isHaveSubData) break;
                                        }
                                    }
                                }
                                BgUnAuditCheckResult result = new BgUnAuditCheckResult();
                                result.setId(actualRecordId);
                                result.setName(formInfo.getName());
                                result.setNumber(formInfo.getOrgUnit().getName() + "@" + bgActualRecordInfo.getNumber());
                                if (isHavaData) {
                                    result.setHaveData(true);
                                    if (isHaveSubData) {
                                        if (isHavaParentData) {
                                            result.setCanUnAudit(false);
                                            result.setNeedMes(true);
                                            object = result;
                                            SQLUtil.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                                            if (orgUnitTmpTable == null) return object;
                                            break block32;
                                        }
                                        result.setHaveSubData(true);
                                        object = result;
                                        SQLUtil.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                                        break block33;
                                    }
                                    if (isHavaParentData) {
                                        result.setCanUnAudit(false);
                                        result.setNeedMes(true);
                                        object = result;
                                        SQLUtil.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                                        break block34;
                                    }
                                    result.setCanUnAudit(true);
                                    object = result;
                                    SQLUtil.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                                    break block35;
                                }
                                result.setCanUnAudit(true);
                                object = result;
                                SQLUtil.cleanup((ResultSet)rst, pstmt, (Connection)conn);
                                break block36;
                            }
                            catch (Exception e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                        pool.releaseTable(orgUnitTmpTable);
                        return object;
                    }
                    if (orgUnitTmpTable == null) return object;
                    pool.releaseTable(orgUnitTmpTable);
                    return object;
                }
                if (orgUnitTmpTable == null) return object;
                pool.releaseTable(orgUnitTmpTable);
                return object;
            }
            if (orgUnitTmpTable == null) return object;
            pool.releaseTable(orgUnitTmpTable);
            return object;
        }
        if (orgUnitTmpTable == null) return object;
        pool.releaseTable(orgUnitTmpTable);
        return object;
        finally {
            SQLUtil.cleanup(rst, pstmt, (Connection)conn);
            if (orgUnitTmpTable != null) {
                pool.releaseTable(orgUnitTmpTable);
            }
        }
    }

    public static boolean checkParentNoEdit(BgActualRecordInfo bgActualRecordInfo, Map<String, Map<String, String[]>> dealActualRecords, Map<String, List<String>> parentOrgNumbers, StringBuffer resultOrgId) {
        int i;
        List<String> list = parentOrgNumbers.get(bgActualRecordInfo.getBgForm().getOrgUnit().getId().toString());
        if (list == null || list.size() == 0) {
            return false;
        }
        String[] parentNumbers = bgActualRecordInfo.getBgForm().getOrgUnit().getLongNumber().split("!");
        String key = bgActualRecordInfo.getBgForm().getBgScheme().getId().toString() + "_" + bgActualRecordInfo.getBgForm().getBgTemplate().getId().toString() + "_" + bgActualRecordInfo.getBgForm().getCurrency().getId().toString() + "_" + bgActualRecordInfo.getBgPeriod().getId().toString() + "_" + bgActualRecordInfo.getBgForm().getBgVersion().getId().toString();
        Map<String, String[]> noEditForm = dealActualRecords.get(key);
        if (noEditForm == null || noEditForm.isEmpty()) {
            return false;
        }
        for (i = parentNumbers.length - 2; i >= 0; --i) {
            if (!noEditForm.containsKey(parentNumbers[i])) continue;
            resultOrgId.append(noEditForm.get(parentNumbers[i])[2]);
            return true;
        }
        for (i = list.size() - 1; i >= 0; --i) {
            if (!noEditForm.containsKey(list.get(i))) continue;
            resultOrgId.append(noEditForm.get(list.get(i))[2]);
            return true;
        }
        return false;
    }

    public List checkBatchUnAudit(List actualRecordIds, BOSUuid auditUserId, BOSUuid auditOrgId) throws BOSException, EASBizException {
        if (this.ctx == null || actualRecordIds == null || actualRecordIds.isEmpty() || auditUserId == null || auditOrgId == null) {
            return null;
        }
        long begin = System.currentTimeMillis();
        ArrayList<BgUnAuditCheckResult> msgList = new ArrayList<BgUnAuditCheckResult>();
        int size = actualRecordIds.size();
        for (int index = 0; index < size; ++index) {
            BgUnAuditCheckResult result = this.checkCanUnAudit(actualRecordIds.get(index).toString(), auditOrgId.toString(), auditUserId.toString());
            if (result == null) continue;
            msgList.add(result);
        }
        long end = System.currentTimeMillis();
        return msgList;
    }

    private void updateUnActualRecord(Connection conn, TempTablePool pool, String dailyTable, String dailyEntry, BgSchemeAccIntHelper accIntHelper, String bgActualRecordId, Set<String> upBgDataIds) throws BOSException {
        if (upBgDataIds.isEmpty()) {
            return;
        }
        HashMap<String, BgNViewDataInfo> datas = new HashMap<String, BgNViewDataInfo>();
        BgNViewDataInfo dataInfo2 = null;
        PreparedStatement pstmt = null;
        IRowSet rst = null;
        String tmpAuditingTableName = null;
        try {
            tmpAuditingTableName = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpAuditingTableName + " (FID) values (?)"), upBgDataIds);
            int index = 0;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FOrgUnitId, FFormula, FValue, FVersion from " + dailyTable + " where FID IN (select FID from " + tmpAuditingTableName + ")");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                dataInfo2 = new BgNViewDataInfo();
                dataInfo2.setOrgUnitId(rst.getString("FOrgUnitId"));
                dataInfo2.setFormula(rst.getString("FFormula"));
                dataInfo2.setActualValue(rst.getBigDecimal("FValue"));
                dataInfo2.setBgVersionValue(rst.getInt("FVersion"));
                dataInfo2.splitFormula();
                datas.put(String.valueOf(index), dataInfo2);
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!datas.isEmpty()) {
                Map splitDatas = accIntHelper.splitBgDatas(conn, datas, new HashSet<String>());
                for (String cubeName : splitDatas.keySet()) {
                    int batchIndex = 0;
                    int batchSize = 50;
                    pstmt = conn.prepareStatement("Update " + cubeName + " Set FValue = FValue - ?, FTmpValue = FTmpValue - ? where FOrgUnitId = ? and FFormula = ? and FVersion = ?");
                    for (BgNViewDataInfo dataInfo2 : splitDatas.get(cubeName).values()) {
                        pstmt.setBigDecimal(1, dataInfo2.getActualValue());
                        pstmt.setBigDecimal(2, dataInfo2.getActualValue());
                        pstmt.setObject(3, accIntHelper.convertOrgObject(dataInfo2.getOrgUnitId()));
                        pstmt.setString(4, dataInfo2.getFormula());
                        pstmt.setInt(5, dataInfo2.getBgVersionValue());
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex > 0) {
                        pstmt.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
    }

    private void writeBgCtrlRecord(Connection conn, BgActualRecordInfo bgActualRecord, String[] cubeName) throws BgFormException, BgActualRecordException {
        if (conn == null || bgActualRecord == null || cubeName == null) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        String dailyCube = cubeName[0];
        String conCube = cubeName[2];
        String tmpTableName = cubeName[3];
        String FdataIdTable = cubeName[4];
        String billId = bgActualRecord.getId().toString();
        Class<?> _class = null;
        Object _obj = null;
        Object _bosType = null;
        Method _method = null;
        try {
            _class = Class.forName("com.kingdee.eas.ma.control.BgControlRecordObj");
            if (_class != null) {
                _obj = _class.newInstance();
                _method = _class.getMethod("getBOSType", null);
                _bosType = _method.invoke(_obj, null);
            }
        }
        catch (Exception ex) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        if (_bosType == null) {
            throw new BgActualRecordException(BgActualRecordException.WRITECONTROLRECORDERROR);
        }
        String bosType = _bosType.toString();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + conCube + " (FID, FCreateTime, FBillID, FBillNumber, FBillType, FActaulAmount, FBizDate, FActualID, FBizOrgUnitID, FReqOrgUnitID, FControlType, FFormula, FBgIndexNum, FItemExtNumber, FBgPeriodID, FCurrencyID, FBgElementID, FScenario, FVersion) Select newbosid('" + bosType + "'), ?, ?, ?, ?, t.FValue, ?, ?, t.FOrgUnitId, t.FOrgUnitId, ?, FFormula, t.F2, t.fbgitemcombination, t.FBgPeriodId, t.FCurrencyID, t.FBgElementID, t.FScenario, t.FVersion from " + dailyCube + " t where t.FState <> " + 9 + " AND  t.FID IN (");
        sql.append("select Fid from " + FdataIdTable + ")");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setTimestamp(1, timestamp);
            pstmt.setString(2, billId);
            pstmt.setString(3, bgActualRecord.getNumber());
            pstmt.setString(4, bosType);
            pstmt.setTimestamp(5, timestamp);
            pstmt.setString(6, bosType);
            pstmt.setInt(7, 0);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sysActDataWithControlRecord() throws BgFormException {
        String actualTableName = null;
        Object redList = null;
        Connection conn = null;
        String FdataIdTable = null;
        TempTablePool pool = null;
        IRowSet rst = null;
        Object[] reocrd = null;
        ArrayList<Object[]> recordList = new ArrayList<Object[]>();
        ArrayList<Object[]> recordList1 = new ArrayList<Object[]>();
        try {
            BgSchemeInfo schemeInfo = this.getSchemeInfo();
            if (schemeInfo == null) {
                return;
            }
            actualTableName = schemeInfo.getRefCube();
            String cubeControl = BgCubeUtils.getControlCubeName(actualTableName);
            String dailyTable = BgCubeUtils.getDailyActualCubeName(schemeInfo.getRefCube());
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(this.ctx, schemeInfo.getId().toString(), actualTableName);
            HashMap<String, BizCalcData> dataMap = new HashMap<String, BizCalcData>();
            BizCalcData bizData2 = null;
            conn = BgDBUtils.getConnection((Context)this.ctx);
            pool = TempTablePool.getInstance((Context)this.ctx);
            FdataIdTable = BgDBUtils.createTmpTable((Context)this.ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + FdataIdTable + " (FID) values (?)"), this.getSysActDataID());
            StringBuffer select = new StringBuffer();
            StringBuffer update = new StringBuffer();
            select.append("select forgunitid,fformula,fscenario from " + dailyTable + " where fid in ( ");
            select.append("select Fid from " + FdataIdTable + ")");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)select.toString());
            while (rst.next()) {
                bizData2 = new BizCalcData();
                bizData2.setOrgUnitId(rst.getString("forgunitid"));
                bizData2.setFormula(rst.getString("fformula"));
                bizData2.setDimNumber(BgNFSHelper.parseFormulaPara(bizData2.getFormula())[0]);
                bizData2.setBgScenario(rst.getInt("fscenario"));
                bizData2.setBgVersion(BgVersionHelper.DEF_VERSION_VALUE);
                dataMap.put(bizData2.getDimDataKey(), bizData2);
            }
            SQLUtils.cleanup((ResultSet)rst);
            Map splitDatas = accIntHelper.splitBgDatas(conn, dataMap, new HashSet<String>());
            for (String cubeName : splitDatas.keySet()) {
                update.setLength(0);
                recordList.clear();
                recordList1.clear();
                for (BizCalcData bizData2 : splitDatas.get(cubeName).values()) {
                    reocrd = new Object[]{bizData2.getOrgUnitId(), reocrd[0], accIntHelper.convertOrgObject(bizData2.getOrgUnitId()), bizData2.getFormula(), bizData2.getBgScenario()};
                    recordList.add(reocrd);
                    reocrd = new Object[]{accIntHelper.convertOrgObject(bizData2.getOrgUnitId()), bizData2.getFormula()};
                    recordList1.add(reocrd);
                }
                update.append("update " + cubeName + " t1 set fvalue = case ");
                update.append(" when (select sum(t3.factaulamount) from ").append(cubeControl);
                update.append(" t3 where t3.fbizorgunitid = ? and t1.fformula = t3.fformula) is null then 0 ");
                update.append(" else (select sum(t3.factaulamount) from ").append(cubeControl).append(" t3 where t3.fbizorgunitid = ? and t1.fformula = t3.fformula) end ");
                update.append(" where forgunitid = ? and fformula = ? and fscenario = ? and fversion = 1");
                BgDBUtils.executeBatch((Connection)conn, (String)update.toString(), recordList);
                BgDBUtils.executeBatch((Connection)conn, (String)("update " + cubeName + " set FTmpValue = fValue where forgunitid = ? and fformula = ? and fversion = 1"), recordList1);
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
            if (FdataIdTable == null) return;
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, null, conn);
            if (FdataIdTable != null) {
                BgDBUtils.releaseTmpTable(pool, FdataIdTable);
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)FdataIdTable);
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateActualRecord(Connection conn, TempTablePool pool, String actualRecordId, String bgOrgUnitId, String dailyTable, String dailyEntry, BgSchemeAccIntHelper accIntHelper, String refFieldStr, String tmpTableName, String FDataIds, String tmpAccIntTable) throws EASBizException, SQLException, BOSException {
        IRowSet rst;
        PreparedStatement pstmt;
        block25: {
            HashMap<String, BgNViewDataInfo> datas = new HashMap<String, BgNViewDataInfo>();
            StringBuffer sql = new StringBuffer();
            BgNViewDataInfo dataInfo2 = null;
            pstmt = null;
            rst = null;
            try {
                sql = new StringBuffer();
                if (!accIntHelper.isUseAccInt()) {
                    sql.append("Insert Into " + accIntHelper.getBgDataTable() + "(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, " + refFieldStr + ",fbgitemcombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate)  Select FID, FCreatorID, FCreateTime, FLastUpdateUserID,  FLastUpdateTime, FOrgUnitId, FFormula, FValue, FValue, " + refFieldStr + ", fbgitemcombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, " + 9 + ", 1  from " + dailyTable + " t where FOrgUnitID = '" + bgOrgUnitId + "' and FState <> " + 9 + " AND FID IN (");
                    if (FDataIds != null) {
                        sql.append("select Fid from " + FDataIds + ")");
                        sql.append(" AND NOT EXISTS (Select * from " + tmpTableName + " where t.FFormula = FFormula and t.FVersion = FVersion)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                    } else {
                        sql.append("select FDataID from " + dailyEntry + " where FFormID = ?) ");
                        sql.append(" AND NOT EXISTS (Select * from " + tmpTableName + " where t.FFormula = FFormula and t.FVersion = FVersion)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new String[]{actualRecordId});
                    }
                } else {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpAccIntTable));
                    sql.append("Insert Into " + tmpAccIntTable + "(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitId, FOrgUnitIntId, FFormula, FValue, FTmpValue, " + refFieldStr + ",fbgitemcombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate)  Select FID, FCreatorID, FCreateTime, FLastUpdateUserID,  FLastUpdateTime, FOrgUnitId, " + accIntHelper.convertOrgObject(bgOrgUnitId) + ", FFormula, FValue, FValue, " + refFieldStr + ", fbgitemcombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, " + 9 + ", 1  from " + dailyTable + " t where FOrgUnitID = '" + bgOrgUnitId + "' and FState <> " + 9 + " AND FID IN (");
                    if (FDataIds != null) {
                        sql.append("select Fid from " + FDataIds + ")");
                        sql.append(" AND NOT EXISTS (Select * from " + tmpTableName + " where t.FFormula = FFormula and t.FVersion = FVersion)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                    } else {
                        sql.append("select FDataID from " + dailyEntry + " where FFormID = ?) ");
                        sql.append(" AND NOT EXISTS (Select * from " + tmpTableName + " where t.FFormula = FFormula and t.FVersion = FVersion)");
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new String[]{actualRecordId});
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpAccIntTable + " t0 Set FBgPeriodIntId = (Select FIntId FROM T_MBG_BgPeriod Where FID = t0.FBgPeriodId)"));
                    BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpAccIntTable + " t0 Set FBgElementIntId = (Select FIntId FROM T_MBG_BgElement Where FID = t0.FBgElementId)"));
                    for (String dimNumber : accIntHelper.getSchemeHelper().getAccAndOtherDim(false)) {
                        String refField = accIntHelper.getSchemeHelper().getRefField(dimNumber);
                        if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber)) {
                            BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpAccIntTable + " t0 Set F" + refField + " = (Select FIntId FROM T_MBG_BgAccount Where FBgAccountViewId = ? AND FNumber = SUBSTRING(t0." + refField + ", 5, 99))"), (Object[])new Object[]{accIntHelper.getSchemeHelper().getDimension(dimNumber).getViewId()});
                            continue;
                        }
                        BgDBUtils.executeUpdate((Connection)conn, (String)("Update " + tmpAccIntTable + " t0 Set F" + refField + " = (Select FIntId FROM T_MBG_MbgMember Where FViewId = ? AND FNumber = SUBSTRING(t0." + refField + ", 5, 99))"), (Object[])new Object[]{accIntHelper.getSchemeHelper().getDimension(dimNumber).getViewId()});
                    }
                    HashMap<Object, BizCalcData> dataMap = new HashMap<Object, BizCalcData>();
                    HashSet<String> formulaSet = new HashSet<String>();
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select distinct FFormula FROM " + tmpAccIntTable));
                    while (rst.next()) {
                        BizCalcData data = new BizCalcData();
                        data.setFormula(rst.getString("FFormula"));
                        formulaSet.add(data.getFormula());
                        data.setValue(BgNConstants.ONE);
                        data.setDimNumber(BgNFSHelper.parseFormulaPara(data.getFormula())[0]);
                        String indexNumber = DimensionFormulaHelper.splitCombinations(data.getDimNumber())[0];
                        dataMap.put(indexNumber, data);
                    }
                    if (dataMap.isEmpty()) {
                        SQLUtils.cleanup((ResultSet)rst, pstmt);
                        return;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    Map splitMap = accIntHelper.splitBgDatas(conn, dataMap, formulaSet);
                    for (String cubeName : splitMap.keySet()) {
                        String refField;
                        sql.setLength(0);
                        sql.append("Insert Into " + cubeName + "(FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitId, FFormula, FValue, FTmpValue, fbgitemcombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate ");
                        for (String dimNumber : accIntHelper.getSchemeHelper().getAccAndOtherDim(false)) {
                            refField = accIntHelper.getSchemeHelper().getRefField(dimNumber);
                            sql.append(", ").append(refField);
                        }
                        sql.append(") Select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitIntId, FFormula, FValue, FTmpValue, fbgitemcombination, FBgPeriodIntID, FBgElementIntID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate ");
                        for (String dimNumber : accIntHelper.getSchemeHelper().getAccAndOtherDim(false)) {
                            refField = accIntHelper.getSchemeHelper().getRefField(dimNumber);
                            sql.append(", F").append(refField);
                        }
                        sql.append(" FROM ").append(tmpAccIntTable).append(" Where F2 = ?");
                        MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), new ArrayList<String>(splitMap.get(cubeName).keySet()));
                    }
                }
                sql = new StringBuffer();
                HashSet formulaSet = new HashSet();
                sql.append("Select FOrgUnitId, FFormula, FValue, FVersion from " + dailyTable + " t where FState <> " + 9 + " AND FID IN (");
                if (FDataIds != null) {
                    sql.append("select Fid from " + FDataIds + ")");
                    sql.append(" AND EXISTS (Select * from " + tmpTableName + " where t.FFormula = FFormula and t.FVersion = FVersion)");
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                } else {
                    sql.append("select FDataID from " + dailyEntry + " where FFormID = ?)");
                    sql.append(" AND EXISTS (Select * from " + tmpTableName + " m where t.FFormula = m.FFormula and t.FVersion = m.FVersion)");
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{actualRecordId});
                }
                while (rst.next()) {
                    dataInfo2 = new BgNViewDataInfo();
                    dataInfo2.setOrgUnitId(rst.getString("FOrgUnitId"));
                    dataInfo2.setFormula(rst.getString("FFormula"));
                    dataInfo2.setActualValue(rst.getBigDecimal("FValue"));
                    dataInfo2.setBgVersionValue(rst.getInt("FVersion"));
                    datas.put(dataInfo2.getOrgUnitId() + "_" + dataInfo2.getFormula() + "_" + dataInfo2.getBgVersionValue(), dataInfo2);
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (datas.isEmpty()) break block25;
                Map splitDatas = accIntHelper.splitBgDatas(conn, datas, new HashSet<String>());
                for (String cubeName : splitDatas.keySet()) {
                    int batchIndex = 0;
                    int batchSize = 50;
                    pstmt = conn.prepareStatement("Update " + cubeName + " Set FValue = FValue + ?, FTmpValue = FTmpValue + ?  where FOrgUnitId = ? and FFormula = ? and FVersion = ?");
                    for (BgNViewDataInfo dataInfo2 : splitDatas.get(cubeName).values()) {
                        pstmt.setBigDecimal(1, dataInfo2.getActualValue());
                        pstmt.setBigDecimal(2, dataInfo2.getActualValue());
                        pstmt.setString(3, dataInfo2.getOrgUnitId());
                        pstmt.setString(4, dataInfo2.getFormula());
                        pstmt.setInt(5, dataInfo2.getBgVersionValue());
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex > 0) {
                        pstmt.executeBatch();
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, pstmt);
        return;
    }

    private List<String> getActualRecordIds(Connection conn, String bgSchemeId, String orgUnitTmpTable, String bgRootTemplateId, String bgPeriodId, String bgCurrencyId, String bgVersionId, String bgActualPeriodId, List<String> auditedActualForm, BgSpecialItemsCollection bgSpecialItems) throws BOSException {
        ArrayList<String> actualRecordIds = new ArrayList<String>();
        if (conn == null || bgSchemeId == null || bgRootTemplateId == null || bgPeriodId == null || bgPeriodId == null || bgVersionId == null) {
            return actualRecordIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select a.fid , a.fstate from t_mbg_bgactualrecord a  where  a.fbgperiodid = ? and a.fbgformid in");
        sql.append("( select f.fid from t_mbg_bgform f ");
        sql.append(" join t_mbg_bgtemplate t on f.FBgTemplateID = t.FID ");
        if (bgSpecialItems != null && !bgSpecialItems.isEmpty()) {
            sql.append(" Left Join T_MBG_BgSpecialItems t1 ON t1.FBgFormId = f.FID ");
        }
        sql.append(" where f.fbgschemeid = ? and t.frootid = ? and ");
        sql.append(" f.fbgperiodid = ? and f.fcurrencyid = ? and f.fbgversionid = ? and f.forgunitid in (");
        IRowSet rst = null;
        Object[] object = null;
        try {
            sql.append(" SELECT FID FROM " + orgUnitTmpTable + " ").append(")");
            if (bgSpecialItems != null && !bgSpecialItems.isEmpty()) {
                sql.append(" AND (t1.FDimensionNumber = ? OR t1.FDimensionNumber IS NULL) ");
                object = new Object[]{bgActualPeriodId, bgSchemeId, bgRootTemplateId, bgPeriodId, bgCurrencyId, bgVersionId, bgSpecialItems.get(0).getDimensionNumber()};
            } else {
                object = new Object[]{bgActualPeriodId, bgSchemeId, bgRootTemplateId, bgPeriodId, bgCurrencyId, bgVersionId};
            }
            sql.append(")");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])object);
            while (rst.next()) {
                if (rst.getInt("FSTATE") == 2) {
                    auditedActualForm.add(rst.getString("FID"));
                }
                actualRecordIds.add(rst.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return actualRecordIds;
    }

    private void setPermissionOrgMap(BOSUuid userid, String permissionItem) throws EASBizException, BOSException {
        FullOrgUnitCollection orgCol = null;
        orgCol = BgFacadeFactory.getLocalInstance(this.ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userid), OrgType.CostCenter, null, permissionItem);
        for (int i = 0; i < orgCol.size(); ++i) {
            this.permissionOrgMap.put(orgCol.get(i).getId().toString(), null);
        }
    }

    private Map getPermissionOrgMap() {
        return this.permissionOrgMap;
    }

    public SelectorItemCollection getSelectorItemColls() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.orgUnit.longNumber");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.bgScheme.bgDimSettings.*");
        sic.add("bgForm.bgScheme.bgTemplate.id");
        sic.add("bgForm.bgScheme.currency.id");
        sic.add("bgForm.bgScheme.bgPeriod.id");
        sic.add("bgForm.bgTemplate.parent.id");
        sic.add("bgForm.bgTemplate.root.id");
        sic.add("bgForm.bgTemplate.id");
        sic.add("bgForm.bgTemplate.formType");
        sic.add("bgForm.bgVersion.id");
        sic.add("bgForm.id");
        sic.add("bgForm.bgPeriod");
        sic.add("bgForm.currency");
        sic.add("bgForm.bgSpecialItems.dimensionNumber");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.periodType");
        sic.add("currency.id");
        return sic;
    }

    private SelectorItemCollection get4SelectorItemColls() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.isleaf");
        sic.add("bgForm.orgUnit.name");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSubOrgUnitIds(Connection conn, String orgViewId, String orgLongNumber) throws SQLException {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (conn == null || orgViewId == null || orgLongNumber == null) {
            return orgUnitIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FOrgUnitID from T_MBG_BgOrgUnit t where t.FViewId = ? and (t.FLongNumber = ? OR t.FLongNumber like ?) order by t.FLongNumber");
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{orgViewId.toString(), orgLongNumber, orgLongNumber + "!%"});
            while (rst.next()) {
                orgUnitIds.add(rst.getString("FOrgUnitID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return orgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getParentOrgUnitIds(Connection conn, String orgViewId, String orgLongNumber) throws SQLException {
        HashSet<String> pOrgUnitIds = new HashSet<String>();
        if (conn == null || orgViewId == null || orgLongNumber == null) {
            return pOrgUnitIds;
        }
        String[] pOrgUnitNums = orgLongNumber.split("!");
        if (pOrgUnitNums != null && pOrgUnitNums.length > 1) {
            String query = "select FOrgUnitID from T_MBG_BgOrgUnit where FVIewId = ? AND FNumber IN (";
            int in = pOrgUnitNums.length - 1;
            for (int i = 0; i < in; ++i) {
                query = query + "'" + pOrgUnitNums[i] + "',";
            }
            query = query.substring(0, query.length() - 1) + ")";
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query, (Object[])new Object[]{orgViewId});
                while (rst.next()) {
                    pOrgUnitIds.add(rst.getString("FOrgUnitID"));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        return pOrgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrgLongNumber(Connection conn, String orgViewId, String orgUnitId, String bgOrgUnitLongNumber) throws SQLException {
        ResultSet rst;
        PreparedStatement pstmt;
        block3: {
            String string;
            if (conn == null) {
                return null;
            }
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement("Select FLongNumber FROM T_Mbg_BgOrgUnit Where FViewId = ? AND FOrgUnitID = ? and (FlongNumber = ? Or FlongNumber like ?)");
                pstmt.setString(1, orgViewId);
                pstmt.setString(2, orgUnitId);
                pstmt.setString(3, bgOrgUnitLongNumber);
                pstmt.setString(4, bgOrgUnitLongNumber + "!%");
                rst = pstmt.executeQuery();
                if (!rst.next()) break block3;
                string = rst.getString("FLongNumber");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return null;
    }

    private void UnAudOrgUnitCheck(List<bgBaseData> bgBaseDatas, int bgDataState) {
        if (bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return;
        }
        ArrayList<bgBaseData> tmpList = new ArrayList<bgBaseData>();
        bgBaseData data = null;
        int in = bgBaseDatas.size();
        for (int i = 0; i < in; ++i) {
            data = bgBaseDatas.get(i);
            if (data.getState() != 9) continue;
            tmpList.add(data);
            data.setState(bgDataState);
            data.setAudOrgUnitId(null);
        }
        bgBaseDatas.clear();
        bgBaseDatas.addAll(tmpList);
    }

    private List<bgBaseData> queryBaseData(Connection conn, String dailyTable, String dailyEntry, String bgFormId, Set<String> pOrgUnitIds, List<String> orgUnitIds, String bgOrgId) throws SQLException {
        ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
        this.isHasBaseData(conn, dailyTable, dailyEntry, bgFormId, pOrgUnitIds, orgUnitIds, bgBaseDatas, bgOrgId);
        return bgBaseDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHasBaseData(Connection conn, String dailyTable, String dailyEntry, String bgFormId, Set<String> pOrgUnitIds, List<String> orgUnitIds, List<bgBaseData> bgBaseDatas, String bgOrgId) throws SQLException {
        boolean isHasData = false;
        if (conn == null || StringUtils.isEmpty((String)dailyTable) || StringUtils.isEmpty((String)dailyEntry) || StringUtils.isEmpty((String)bgFormId)) {
            return false;
        }
        String querySql = "select FID, FState, FAudOrgUnitID from " + dailyTable + " where FID in (select FDataID from " + dailyEntry + " where FFormID = ?) and ForgUnitid = ?";
        bgBaseData data = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)querySql, (Object[])new Object[]{bgFormId, bgOrgId});
            while (rst.next()) {
                data = new bgBaseData();
                data.setFid(rst.getString("FID"));
                data.setState(rst.getInt("FState"));
                data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                if (data.getAudOrgUnitId() == null || !pOrgUnitIds.contains(data.getAudOrgUnitId()) && orgUnitIds.contains(data.getAudOrgUnitId())) {
                    bgBaseDatas.add(data);
                }
                isHasData = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return isHasData;
    }

    private void updateAudOrgUnitCheck(List<bgBaseData> bgBaseDatas, int bgDataState) {
        if (bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return;
        }
        bgBaseData data = null;
        int in = bgBaseDatas.size();
        for (int i = 0; i < in; ++i) {
            data = bgBaseDatas.get(i);
            if (data.getState() >= bgDataState) continue;
            data.setState(bgDataState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> updateBaseData(Connection conn, String dailyActualName, List<bgBaseData> bgBaseDatas, String audOrgUnitId, String audUserId, BgActualRecordInfo bgActualRecordInfo, boolean isAudit) throws SQLException, BOSException {
        HashSet<String> bgDataIds = new HashSet<String>();
        if (conn == null || StringUtils.isEmpty((String)dailyActualName) || bgBaseDatas == null || bgBaseDatas.isEmpty()) {
            return bgDataIds;
        }
        BgCubeUtils.checkTable(conn);
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt2 = null;
        try {
            int i;
            bgBaseData data = null;
            int batchIndex = 0;
            String updateSql = "update " + dailyActualName + " set FAudFormId = ? where FID = ? " + (isAudit ? "and FAudFormId is null" : "");
            pstmt1 = conn.prepareStatement(updateSql);
            int in = bgBaseDatas.size();
            for (i = 0; i < in; ++i) {
                data = bgBaseDatas.get(i);
                bgDataIds.add(data.getFid());
                if (isAudit) {
                    pstmt1.setString(1, bgActualRecordInfo.getId().toString());
                } else {
                    pstmt1.setString(1, null);
                }
                pstmt1.setString(2, data.getFid());
                pstmt1.addBatch();
                if (++batchIndex < 50) continue;
                pstmt1.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt1.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt1);
            updateSql = "update " + dailyActualName + " set FState = ?, FAudOrgUnitID = ?, FAudUserID = ? where FID = ?";
            pstmt2 = conn.prepareStatement(updateSql);
            in = bgBaseDatas.size();
            for (i = 0; i < in; ++i) {
                data = bgBaseDatas.get(i);
                bgDataIds.add(data.getFid());
                pstmt2.setInt(1, data.getState());
                if (!isAudit || data.getState() == 1) {
                    pstmt2.setString(2, null);
                    pstmt2.setString(3, null);
                } else {
                    pstmt2.setString(2, audOrgUnitId);
                    pstmt2.setString(3, audUserId);
                }
                pstmt2.setString(4, data.getFid());
                pstmt2.addBatch();
                if (++batchIndex < 50) continue;
                pstmt2.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt2.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt1);
            SQLUtils.cleanup(pstmt2);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt1);
        SQLUtils.cleanup((Statement)pstmt2);
        return bgDataIds;
    }

    private void updateAudFormState(Context ctx, Connection conn, BgActualRecordInfo bgActualRecordInfo, List<String> bgActualRecordIds, BOSUuid audUserId, int formState) throws SQLException, BOSException {
        if (conn == null || bgActualRecordIds == null || bgActualRecordIds.isEmpty() || audUserId == null) {
            return;
        }
        int batchIndex = 0;
        String _auUserId = audUserId.toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        if (formState == 2) {
            sql.append("update t_mbg_bgactualrecord set FState = ?, FAuditorId = ?, FAuditedTime = ? where FID = ?");
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (String bgActualRecordId : bgActualRecordIds) {
                pstmt.setInt(1, formState);
                pstmt.setString(2, _auUserId);
                pstmt.setTimestamp(3, _time);
                pstmt.setString(4, bgActualRecordId);
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex > 0) {
                pstmt.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private IMbgViewBase loadViewManager(BgFormInfo formInfo, String bgOrgUnitId) throws EASBizException, BOSException {
        IMbgViewBase view = DimensionCommonHelper.getBgFormView(this.ctx, formInfo);
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formInfo.getBgTemplate().getFormType())) {
            view = MBGFormFacadeFactory.getLocalInstance(this.ctx).loadViewManager(formInfo.getId().toString(), null, (IMbgViewManager)view, null, bgOrgUnitId, true, false);
        } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)formInfo.getBgTemplate().getFormType())) {
            Map resultMap = MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).initViewListData(formInfo, null, null, (MbgViewListManager)view, null);
            view = (IMbgViewBase)resultMap.get("dimensino.member");
        }
        return view;
    }

    private IBizData getBizDataInstance(IMbgViewBase view) {
        if (view instanceof MbgViewListManager) {
            return new BizViewListDataImpl();
        }
        if (view instanceof IMbgViewManager) {
            if (this.hasRelation((IMbgViewManager)view)) {
                return new BizViewDataImpl();
            }
            return new BizFixDataImpl();
        }
        return null;
    }

    private boolean hasRelation(IMbgViewManager view) {
        return view != null && view.getRelationMaps() != null && !view.getRelationMaps().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkOrgUnitHasData(Connection conn, String cubeName, String orgUnitId) throws SQLException {
        if (conn == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean hasData = false;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FID from " + cubeName + " where FOrgUnitId = ?"), (Object[])new Object[]{orgUnitId});
            if (rst.next()) {
                hasData = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return hasData;
    }

    class BgUnAuditCheckData {
        private BgUnAuditCheckResult result = null;
        private boolean isHaveSubData = false;
        private boolean isHavaParentData = false;

        BgUnAuditCheckData() {
        }

        public void setResult(BgUnAuditCheckResult result) {
            this.result = result;
        }

        public BgUnAuditCheckResult getResult() {
            return this.result;
        }

        public boolean isHaveSubData() {
            return this.isHaveSubData;
        }

        public void setHaveSubData(boolean isHaveSubData) {
            this.isHaveSubData = isHaveSubData;
        }

        public boolean isHavaParentData() {
            return this.isHavaParentData;
        }

        public void setHavaParentData(boolean isHavaParentData) {
            this.isHavaParentData = isHavaParentData;
        }
    }

    class BizFixDataImpl
    extends AbstractBizData {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<bgBaseData> queryBaseData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> upBgDataIds, String bgActualPeriodId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || upBgDataIds == null) {
                throw new BgActualRecordException(BgActualRecordException.CANTUNAUDIT);
            }
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, bgDims);
            String field = null;
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ? AND d.FBgPeriodID = ?");
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            int pos = 0;
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            IRowSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = ActualRecordControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        pstmt.setString(1, orgUnitId);
                        pstmt.setInt(2, bgVersionId);
                        pstmt.setString(3, bgActualPeriodId);
                        pstmt.addBatch();
                        if (++pos <= 50) continue;
                        pstmt.executeBatch();
                        pos = 0;
                    }
                    if (pos > 0) {
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer query = new StringBuffer();
                query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
                while (rst.next()) {
                    data = new bgBaseData();
                    data.setFid(rst.getString("FID"));
                    data.setState(rst.getInt("FState"));
                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                    if (upBgDataIds.contains(data.getFid()) || data.getAudOrgUnitId() != null && (pOrgUnitIds.contains(data.getAudOrgUnitId()) || !orgUnitIds.contains(data.getAudOrgUnitId()))) continue;
                    bgBaseDatas.add(data);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            return bgBaseDatas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public BgUnAuditCheckData checkData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> subOrgUnitIds, Set<String> bgDataIds, boolean isHaveSubData, boolean isHavaParentData, String bgActualPeriodId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || subOrgUnitIds == null || bgDataIds == null) {
                throw new BgActualRecordException(BgActualRecordException.CANTUNAUDIT);
            }
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            BgUnAuditCheckData checkData = new BgUnAuditCheckData();
            checkData.setHaveSubData(isHaveSubData);
            checkData.setHavaParentData(isHavaParentData);
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, bgDims);
            String field = null;
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ? AND d.FBgPeriodID = ? ");
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            StringBuffer query = new StringBuffer();
            query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            IRowSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData;
                        if (checkData.isHaveSubData() && checkData.isHavaParentData() || !(hasData = ActualRecordControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId))) continue;
                        pstmt.setString(1, orgUnitId);
                        pstmt.setInt(2, bgVersionId);
                        pstmt.setString(3, bgActualPeriodId);
                        pstmt.executeUpdate();
                        try {
                            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
                            while (rst.next()) {
                                data = new bgBaseData();
                                data.setFid(rst.getString("FID"));
                                data.setState(rst.getInt("FState"));
                                data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                if (!checkData.isHaveSubData() && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                                    checkData.setHaveSubData(true);
                                }
                                if (!checkData.isHavaParentData() && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                                    checkData.setHavaParentData(true);
                                }
                                if (!checkData.isHavaParentData() || !checkData.isHaveSubData()) continue;
                            }
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rst);
                            throw throwable;
                            return checkData;
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            }
        }

        private Map<String, String> getSubMemberTmpTableMap(Connection conn, TempTablePool pool, BgSchemeInfo rootScheme, List<IDimension> bgDims) throws Exception {
            HashMap<String, String> subMemberTmpTableMap = new HashMap<String, String>();
            if (conn == null || pool == null || bgDims == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            HashSet<String> dimNumber = new HashSet<String>();
            IDimension dimension = null;
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                int j;
                int jn;
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                dimNumber.clear();
                if (DimUtils.checkBaseDimension(dimension)) {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getNumber());
                    }
                } else {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getDimNumber());
                    }
                }
                if (!DimUtils.checkBaseDimension(dimension)) {
                    this.bulidCommTmpTable(conn, pool, subMemberTmpTableMap, dimension, dimNumber, rootScheme);
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                    this.buildPeriodTmpTable(conn, pool, rootScheme, subMemberTmpTableMap, dimension, dimNumber);
                    continue;
                }
                if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                this.bulidCommTmpTable(conn, pool, subMemberTmpTableMap, dimension, dimNumber, rootScheme);
            }
            return subMemberTmpTableMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulidCommTmpTable(Connection conn, TempTablePool pool, Map<String, String> subMemberTmpTableMap, IDimension dimension, Set<String> dimNumber, BgSchemeInfo rootScheme) throws Exception {
            int re;
            if (conn == null || subMemberTmpTableMap == null || dimension == null || dimNumber == null) {
                return;
            }
            String tmpTableName = null;
            ArrayList<String> sqlParam = new ArrayList<String>();
            sqlParam.addAll(dimNumber);
            if (subMemberTmpTableMap.containsKey(dimension.getField())) {
                tmpTableName = subMemberTmpTableMap.get(dimension.getField());
                subMemberTmpTableMap.remove(dimension.getField());
                BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpTableName));
            }
            tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDimNumber NVARCHAR(84))");
            pool.createIndex(tmpTableName, "FDimNumber", false, false);
            subMemberTmpTableMap.put(dimension.getField(), tmpTableName);
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            String factName = ClosureUtils.getFactTableName(dimension.getNumber());
            if (rootScheme.getViewId(dimension.getNumber()) != null) {
                factName = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)rootScheme.getViewId(dimension.getNumber()));
            }
            if (!((re = BgDBUtils.existColumn((Connection)conn, (String)factName, (String)"FLongNumber")) != BgDBUtils.YES || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()))) {
                StringBuffer sql = new StringBuffer("select FLongNumber from " + factName + " where FDimNumber IN (");
                int jn = 50;
                for (int j = 1; j < jn; ++j) {
                    sql.append("?,");
                }
                sql.append("?)");
                StringBuffer query = new StringBuffer("select FDIMLONGNUMBER from " + factName + " where ");
                int jn2 = 50;
                for (int j = 1; j < jn2; ++j) {
                    query.append(" FLongNumber like ? OR");
                }
                query.append(" FLongNumber like ?");
                String longNumber = null;
                String[] tmpStrs = null;
                HashSet<String> sqlData = new HashSet<String>();
                List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParam);
                if (!result.isEmpty()) {
                    int size = result.size();
                    int count = (size - 1) / 50 + 1;
                    int pos = 0;
                    try {
                        pstmt = conn.prepareStatement(query.toString());
                        for (int index = 0; index < count; ++index) {
                            int x = 1;
                            while (x <= 50) {
                                if (pos < size) {
                                    pstmt.setObject(x, ((Object[])result.get(pos))[0] + "%");
                                } else {
                                    pstmt.setObject(x, BgBaseConstants.noFindStr);
                                }
                                ++x;
                                ++pos;
                            }
                            try {
                                rst = pstmt.executeQuery();
                                while (rst.next()) {
                                    longNumber = rst.getString("FDIMLONGNUMBER");
                                    tmpStrs = longNumber.split("!");
                                    if (tmpStrs == null) continue;
                                    int jn3 = tmpStrs.length;
                                    for (int j = 0; j < jn3; ++j) {
                                        sqlData.add(tmpStrs[j]);
                                    }
                                }
                                continue;
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                    }
                    finally {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                    }
                }
                if (!sqlData.isEmpty()) {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber) values (?)"), sqlData);
                }
            } else if (!dimNumber.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber) values (?)"), dimNumber);
            }
        }
    }

    class BizViewDataImpl
    extends AbstractBizData {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<bgBaseData> queryBaseData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> upBgDataIds, String bgActualPeriodId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || upBgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
            List<String[]> relationData = ActualRecordControlUtils.this.getRelationUtils(rootScheme.getId().toString()).queryRelation(((IMbgViewManager)view).getRelationMaps(), (IBgDimensionManager)manager);
            if (relationData == null || relationData.isEmpty()) {
                return bgBaseDatas;
            }
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            String[] relField = relationData.get(0);
            if (relField == null || relField.length == 0) {
                return bgBaseDatas;
            }
            List<IDimension> bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            Set<String> refFields = this.getRefFields(relationData);
            String queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            Map<String, String> subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, refFields, relationData, bgDims);
            HashMap<String, Integer> refIndexMap = new HashMap<String, Integer>();
            int jn = relField.length;
            for (int j = 0; j < jn; ++j) {
                refIndexMap.put(relField[j], j);
            }
            String field = null;
            String[] relData = null;
            ArrayList<Object> params = new ArrayList<Object>();
            IDimension dimension = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ? AND d.FBgPeriodID = ?");
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND e.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND c.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND s.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (refFields.contains(field)) {
                    sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + " where FParentNumber = ?)");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            IRowSet rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        boolean hasData = ActualRecordControlUtils.this.checkOrgUnitHasData(conn, cubeName, orgUnitId);
                        if (!hasData) continue;
                        int pos = 0;
                        int xn = relationData.size();
                        for (int x = 1; x < xn; ++x) {
                            relData = relationData.get(x);
                            params.clear();
                            params.add(orgUnitId);
                            params.add(bgVersionId);
                            params.add(bgActualPeriodId);
                            int yn = bgDims.size();
                            for (int y = 0; y < yn; ++y) {
                                dimension = bgDims.get(y);
                                field = dimension.getField();
                                if (DimensionConstants.DEF_VERSION_FIELD.equals(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field) || !refFields.contains(field)) continue;
                                params.add(relData[(Integer)refIndexMap.get(field)]);
                            }
                            int zn = params.size();
                            for (int z = 0; z < zn; ++z) {
                                pstmt.setObject(z + 1, params.get(z));
                            }
                            pstmt.addBatch();
                            if (++pos <= 50) continue;
                            pstmt.executeBatch();
                            pos = 0;
                        }
                        if (pos <= 0) continue;
                        pstmt.executeBatch();
                    }
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                StringBuffer query = new StringBuffer();
                query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
                rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
                while (rst.next()) {
                    data = new bgBaseData();
                    data.setFid(rst.getString("FID"));
                    data.setState(rst.getInt("FState"));
                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                    if (upBgDataIds.contains(data.getFid()) || data.getAudOrgUnitId() != null && (pOrgUnitIds.contains(data.getAudOrgUnitId()) || !orgUnitIds.contains(data.getAudOrgUnitId()))) continue;
                    bgBaseDatas.add(data);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            return bgBaseDatas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BgUnAuditCheckData checkData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> subOrgUnitIds, Set<String> bgDataIds, boolean isHaveSubData, boolean isHavaParentData, String bgActualPeriodId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || subOrgUnitIds == null || bgDataIds == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            checkData = new BgUnAuditCheckData();
            checkData.setHaveSubData(isHaveSubData);
            checkData.setHavaParentData(isHavaParentData);
            bgVersionId = formInfo.getBgVersion().getVersionId();
            relationData = ActualRecordControlUtils.access$300(ActualRecordControlUtils.this, rootScheme.getId().toString()).queryRelation(((IMbgViewManager)view).getRelationMaps(), (IBgDimensionManager)manager);
            if (relationData == null || relationData.isEmpty()) {
                return checkData;
            }
            relField = relationData.get(0);
            if (relField == null || relField.length == 0) {
                return checkData;
            }
            bgDims = DimUtils.transDimension((IBgDimensionManager)manager, formInfo);
            refFields = this.getRefFields(relationData);
            queryTmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44) NOT NULL, FFormula NVARCHAR(300) NOT NULL, FVersion INT)");
            subMemberTmpTableMap = this.getSubMemberTmpTableMap(conn, pool, rootScheme, refFields, relationData, bgDims);
            refIndexMap = new HashMap<String, Integer>();
            jn = relField.length;
            for (j = 0; j < jn; ++j) {
                refIndexMap.put(relField[j], j);
            }
            field = null;
            relData = null;
            params = new ArrayList<Object>();
            dimension = null;
            sql = new StringBuffer();
            sql.append("Insert Into " + queryTmpTable + " (FOrgUnitId, FFormula, FVersion) Select d.FOrgUnitId, d.FFormula, d.FVersion from " + cubeName + " d LEFT JOIN T_MBG_BGELEMENT e ON d.FBgElementId = e.FID LEFT JOIN T_BD_CURRENCY c ON d.FCurrencyId = c.FID LEFT JOIN T_MBG_BgScenario s ON d.FScenario = s.FScenarioId where d.FOrgUnitId = ? AND d.FVersion = ? AND d.FBgPeriodID = ?");
            in = bgDims.size();
            for (i = 0; i < in; ++i) {
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER) || dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                field = dimension.getField();
                if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND e.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND e.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND c.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND c.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                    if (refFields.contains(field)) {
                        sql.append(" AND s.FNumber = ? ");
                        continue;
                    }
                    sql.append(" AND s.FNumber IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
                    continue;
                }
                if (refFields.contains(field)) {
                    sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + " where FParentNumber = ?)");
                    continue;
                }
                sql.append(" AND d." + field + " IN (select FDimNumber from " + subMemberTmpTableMap.get(field) + ")");
            }
            sql.append(" AND d.FBgPeriodID IN (select FID from " + subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD) + ")");
            query = new StringBuffer();
            query.append("Select d.FID, d.FState, d.FAudOrgUnitID from " + cubeName + " d where exists (Select FOrgUnitId, FFormula, FVersion from " + queryTmpTable + " where d.FOrgUnitId = FOrgUnitId and d.FFormula = FFormula and d.FVersion = FVersion)");
            data = null;
            pstmt = null;
            rst = null;
            try {
                pstmt = conn.prepareStatement(sql.toString());
                try {
                    for (String orgUnitId : orgUnitIds) {
                        block34: {
                            if (checkData.isHaveSubData() && checkData.isHavaParentData() || !(hasData = ActualRecordControlUtils.access$400(ActualRecordControlUtils.this, conn, cubeName, orgUnitId))) continue;
                            pos = 0;
                            xn = relationData.size();
                            for (x = 1; x < xn; ++x) {
                                relData = relationData.get(x);
                                params.clear();
                                params.add(orgUnitId);
                                params.add(bgVersionId);
                                params.add(bgActualPeriodId);
                                yn = bgDims.size();
                                for (y = 0; y < yn; ++y) {
                                    dimension = bgDims.get(y);
                                    field = dimension.getField();
                                    if (DimensionConstants.DEF_VERSION_FIELD.equals(field) || DimensionConstants.DEF_PERIOD_FIELD.equals(field) || !refFields.contains(field)) continue;
                                    params.add(relData[(Integer)refIndexMap.get(field)]);
                                }
                                zn = params.size();
                                for (z = 0; z < zn; ++z) {
                                    pstmt.setObject(z + 1, params.get(z));
                                }
                                pstmt.addBatch();
                                if (++pos <= 50) continue;
                                pstmt.executeBatch();
                                pos = 0;
                            }
                            if (pos > 0) {
                                pstmt.executeBatch();
                            }
                            try {
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString());
lbl113:
                                // 2 sources

                                while (rst.next()) {
                                    data = new bgBaseData();
                                    data.setFid(rst.getString("FID"));
                                    data.setState(rst.getInt("FState"));
                                    data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                    if (bgDataIds.contains(data.getFid())) {
                                        result = new BgUnAuditCheckResult();
                                        result.setId(formInfo.getId().toString());
                                        result.setName(formInfo.getName());
                                        result.setNumber(formInfo.getNumber());
                                        result.setCanUnAudit(false);
                                        result.setHasAdjust(true);
                                        checkData.setResult(result);
                                        var38_45 = checkData;
                                        break block34;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl144
                            }
                            catch (Throwable var41_48) {
                                SQLUtils.cleanup(rst);
                                throw var41_48;
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
                        return var38_45;
lbl-1000:
                        // 1 sources

                        {
                            if (!checkData.isHaveSubData() && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                                checkData.setHaveSubData(true);
                            }
                            if (!checkData.isHavaParentData() && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                                checkData.setHavaParentData(true);
                            }
                            if (!checkData.isHavaParentData() || !checkData.isHaveSubData()) ** GOTO lbl113
lbl144:
                            // 2 sources

                            BgDBUtils.executeUpdate((Connection)conn, (String)("truncate Table " + queryTmpTable));
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                    return checkData;
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)queryTmpTable);
            }
        }

        private Set<String> getRefFields(List<String[]> relationData) {
            HashSet<String> refFields = new HashSet<String>();
            if (relationData == null || relationData.isEmpty()) {
                return refFields;
            }
            String[] fields = relationData.get(0);
            int in = fields.length;
            for (int i = 0; i < in; ++i) {
                refFields.add(fields[i]);
            }
            return refFields;
        }

        private Map<String, String> getSubMemberTmpTableMap(Connection conn, TempTablePool pool, BgSchemeInfo rootScheme, Set<String> refFields, List<String[]> relationData, List<IDimension> bgDims) throws Exception {
            HashMap<String, String> subMemberTmpTableMap = new HashMap<String, String>();
            if (conn == null || pool == null || relationData == null || bgDims == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            HashSet<String> dimNumber = new HashSet<String>();
            IDimension dimension = null;
            String[] fields = relationData.get(0);
            int in = bgDims.size();
            for (int i = 0; i < in; ++i) {
                int j;
                int jn;
                dimension = bgDims.get(i);
                if (dimension.getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                dimNumber.clear();
                int fieldIndex = -1;
                if (refFields.contains(dimension.getField())) {
                    int xn = fields.length;
                    for (int x = 0; x < xn; ++x) {
                        if (!dimension.getField().equals(fields[x])) continue;
                        fieldIndex = x;
                        break;
                    }
                    jn = relationData.size();
                    for (j = 1; j < jn; ++j) {
                        dimNumber.add(relationData.get(j)[fieldIndex]);
                    }
                } else if (DimUtils.checkBaseDimension(dimension)) {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getNumber());
                    }
                } else {
                    jn = dimension.getDimensionMember().size();
                    for (j = 0; j < jn; ++j) {
                        dimNumber.add(dimension.getDimensionMember().get(j).getDimNumber());
                    }
                }
                if (!DimUtils.checkBaseDimension(dimension)) {
                    this.bulidCommTmpTable(conn, pool, subMemberTmpTableMap, dimension, dimNumber, rootScheme);
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                    this.buildPeriodTmpTable(conn, pool, rootScheme, subMemberTmpTableMap, dimension, dimNumber);
                    continue;
                }
                if (!DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) && !DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) continue;
                this.bulidCommTmpTable(conn, pool, subMemberTmpTableMap, dimension, dimNumber, rootScheme);
            }
            return subMemberTmpTableMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bulidCommTmpTable(Connection conn, TempTablePool pool, Map<String, String> subMemberTmpTableMap, IDimension dimension, Set<String> dimNumber, BgSchemeInfo rootScheme) throws Exception {
            int re;
            if (conn == null || subMemberTmpTableMap == null || dimension == null) {
                return;
            }
            String tmpTableName = null;
            ArrayList sqlParams = new ArrayList();
            ArrayList<String> sqlParam = new ArrayList<String>();
            sqlParam.addAll(dimNumber);
            if (subMemberTmpTableMap.containsKey(dimension.getField())) {
                tmpTableName = subMemberTmpTableMap.get(dimension.getField());
                subMemberTmpTableMap.remove(dimension.getField());
                BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpTableName));
            }
            tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FDimNumber NVARCHAR(84), FParentNumber NVARCHAR(84))");
            pool.createIndex(tmpTableName, "FParentNumber", false, false);
            subMemberTmpTableMap.put(dimension.getField(), tmpTableName);
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            String factName = ClosureUtils.getFactTableName(dimension.getNumber());
            if (rootScheme.getViewId(dimension.getNumber()) != null) {
                factName = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)rootScheme.getViewId(dimension.getNumber()));
            }
            if (!((re = BgDBUtils.existColumn((Connection)conn, (String)factName, (String)"FLongNumber")) != BgDBUtils.YES || DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber()) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber()))) {
                StringBuffer sql = new StringBuffer("select FLongNumber from " + factName + " where FDimNumber IN (");
                int jn = 50;
                for (int j = 1; j < jn; ++j) {
                    sql.append("?,");
                }
                sql.append("?)");
                StringBuffer query = new StringBuffer("select FDimNumber, FDIMLONGNUMBER from " + factName + " where ");
                int jn2 = 50;
                for (int j = 1; j < jn2; ++j) {
                    query.append(" FLongNumber like ? OR");
                }
                query.append(" FLongNumber like ?");
                String number = null;
                String longNumber = null;
                String subNumber2 = null;
                String[] tmpStrs = null;
                HashMap sqlDataMap = new HashMap();
                Set<String> sqlData = null;
                List result = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParam);
                if (!result.isEmpty()) {
                    int size = result.size();
                    int count = (size - 1) / 50 + 1;
                    int pos = 0;
                    try {
                        pstmt = conn.prepareStatement(query.toString());
                        for (int index = 0; index < count; ++index) {
                            int x = 1;
                            while (x <= 50) {
                                if (pos < size) {
                                    pstmt.setObject(x, ((Object[])result.get(pos))[0] + "%");
                                } else {
                                    pstmt.setObject(x, BgBaseConstants.noFindStr);
                                }
                                ++x;
                                ++pos;
                            }
                            try {
                                rst = pstmt.executeQuery();
                                while (rst.next()) {
                                    number = rst.getString("FDimNumber");
                                    longNumber = rst.getString("FDIMLONGNUMBER");
                                    tmpStrs = longNumber.split("!");
                                    if (tmpStrs == null) continue;
                                    int jn3 = tmpStrs.length;
                                    for (int j = 0; j < jn3; ++j) {
                                        if (!dimNumber.contains(tmpStrs[j])) continue;
                                        if (sqlDataMap.containsKey(tmpStrs[j])) {
                                            sqlData = (Set)sqlDataMap.get(tmpStrs[j]);
                                        } else {
                                            sqlData = new HashSet();
                                            sqlDataMap.put(tmpStrs[j], sqlData);
                                        }
                                        sqlData.add(number);
                                    }
                                }
                                continue;
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                    }
                    finally {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                    }
                }
                if (!sqlDataMap.isEmpty()) {
                    Map.Entry entry2 = null;
                    for (Map.Entry entry2 : sqlDataMap.entrySet()) {
                        number = (String)entry2.getKey();
                        for (String subNumber2 : (Set)entry2.getValue()) {
                            sqlParam = new ArrayList();
                            sqlParam.add(subNumber2);
                            sqlParam.add(number);
                            sqlParams.add(sqlParam);
                        }
                    }
                    BgDBUtils.insertValue((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber, FParentNumber) values (?,?)"), sqlParams);
                }
            } else {
                for (String str : dimNumber) {
                    sqlParam = new ArrayList();
                    sqlParam.add(str);
                    sqlParam.add(str);
                    sqlParams.add(sqlParam);
                }
                BgDBUtils.insertValue((Connection)conn, (String)("Insert Into " + tmpTableName + " (FDimNumber, FParentNumber) values (?,?)"), sqlParams);
            }
        }
    }

    class BizViewListDataImpl
    extends AbstractBizData {
        BizViewListDataImpl() {
        }

        @Override
        public List<bgBaseData> queryBaseData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> upBgDataIds, String bgActualPeriodId) throws Exception {
            if (conn == null || pool == null || view == null || manager == null || formInfo == null || rootScheme == null || orgUnitIds == null || pOrgUnitIds == null || upBgDataIds == null) {
                throw new BgActualRecordException(BgActualRecordException.CANTUNAUDIT);
            }
            BgSchemeDimensionHelper schemeHelper = ActualRecordControlUtils.this.getBgSchemeHelper(rootScheme.getId().toString());
            int bgVersionId = formInfo.getBgVersion().getVersionId();
            ArrayList<bgBaseData> bgBaseDatas = new ArrayList<bgBaseData>();
            MbgViewListControlUtils viewListUtils = new MbgViewListControlUtils(ActualRecordControlUtils.this.ctx, conn, formInfo.getOrgUnit().getId().toString(), schemeHelper, pool, (MbgViewListDimensionManager)manager, formInfo.getBgVersion().getNumber());
            Map<String, String> subMemberTmpTableMap = viewListUtils.getSubMemberTmpTableMap();
            String querySql = viewListUtils.getQuerySql(subMemberTmpTableMap, cubeName);
            bgBaseData data = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(querySql);
                List paramList = MbgSqlHelper.getBatchParams(null, (Object[])orgUnitIds.toArray(), (int)50);
                for (int i = 0; i < paramList.size(); ++i) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        data = new bgBaseData();
                        data.setFid(rst.getString("FID"));
                        data.setState(rst.getInt("FState"));
                        data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                        if (upBgDataIds.contains(data.getFid()) || data.getAudOrgUnitId() != null && (pOrgUnitIds.contains(data.getAudOrgUnitId()) || !orgUnitIds.contains(data.getAudOrgUnitId()))) continue;
                        bgBaseDatas.add(data);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            }
            return bgBaseDatas;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public BgUnAuditCheckData checkData(Connection conn, TempTablePool pool, String cubeName, IMbgViewBase view, IBgDimensionManagerBase manager, BgFormInfo formInfo, BgSchemeInfo rootScheme, List<String> orgUnitIds, Set<String> pOrgUnitIds, Set<String> subOrgUnitIds, Set<String> bgDataIds, boolean isHaveSubData, boolean isHavaParentData, String bgActualPeriodId) throws Exception {
            block12: {
                block11: {
                    if (conn == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (pool == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (view == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (manager == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (formInfo == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (rootScheme == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (orgUnitIds == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (pOrgUnitIds == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (subOrgUnitIds == null) throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    if (bgDataIds == null) {
                        throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
                    }
                    schemeHelper = ActualRecordControlUtils.access$100(ActualRecordControlUtils.this, rootScheme.getId().toString());
                    bgVersionId = formInfo.getBgVersion().getVersionId();
                    checkData = new BgUnAuditCheckData();
                    checkData.setHaveSubData(isHaveSubData);
                    checkData.setHavaParentData(isHavaParentData);
                    viewListUtils = new MbgViewListControlUtils(ActualRecordControlUtils.access$200(ActualRecordControlUtils.this), conn, formInfo.getOrgUnit().getId().toString(), schemeHelper, pool, (MbgViewListDimensionManager)manager, formInfo.getBgVersion().getNumber());
                    subMemberTmpTableMap = viewListUtils.getSubMemberTmpTableMap();
                    querySql = viewListUtils.getQuerySql(subMemberTmpTableMap, cubeName);
                    data = null;
                    pstmt = null;
                    rst = null;
                    try {
                        pstmt = conn.prepareStatement(querySql);
                        paramList = MbgSqlHelper.getBatchParams(null, (Object[])orgUnitIds.toArray(), (int)50);
                        i = 0;
lbl27:
                        // 2 sources

                        while (i < paramList.size()) {
                            MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                            rst = pstmt.executeQuery();
lbl30:
                            // 2 sources

                            while (rst.next()) {
                                data = new bgBaseData();
                                data.setFid(rst.getString("FID"));
                                data.setState(rst.getInt("FState"));
                                data.setAudOrgUnitId(rst.getString("FAudOrgUnitID"));
                                if (bgDataIds.contains(data.getFid())) {
                                    result = new BgUnAuditCheckResult();
                                    result.setId(formInfo.getId().toString());
                                    result.setName(formInfo.getName());
                                    result.setNumber(formInfo.getNumber());
                                    result.setCanUnAudit(false);
                                    result.setHasAdjust(true);
                                    checkData.setResult(result);
                                    var27_28 = checkData;
                                    break block11;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl64
                        }
                        break block12;
                    }
                    catch (SQLException ex) {
                        try {
                            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        }
                        catch (Throwable var28_29) {
                            SQLUtils.cleanup(rst, (Statement)pstmt);
                            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                            throw var28_29;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
                return var27_28;
lbl-1000:
                // 1 sources

                {
                    if (!checkData.isHaveSubData() && (data.getAudOrgUnitId() == null || subOrgUnitIds.contains(data.getAudOrgUnitId()))) {
                        checkData.setHaveSubData(true);
                    }
                    if (!checkData.isHavaParentData() && pOrgUnitIds.contains(data.getAudOrgUnitId())) {
                        checkData.setHavaParentData(true);
                    }
                    if (!checkData.isHavaParentData() || !checkData.isHaveSubData()) ** GOTO lbl30
lbl64:
                    // 2 sources

                    SQLUtils.cleanup((ResultSet)rst);
                    ++i;
                    ** GOTO lbl27
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, subMemberTmpTableMap.values());
            return checkData;
        }
    }

    abstract class AbstractBizData
    implements IBizData {
        AbstractBizData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void buildPeriodTmpTable(Connection conn, TempTablePool pool, BgSchemeInfo rootScheme, Map<String, String> subMemberTmpTableMap, IDimension dimension, Set<String> dimNumber) throws Exception {
            if (conn == null || pool == null || rootScheme == null || subMemberTmpTableMap == null || dimension == null) {
                throw new BgFormException(BgFormException.BATCHAUDITPARAMERROR);
            }
            String tmpTableName = null;
            IRowSet rst = null;
            HashSet<String> periodIds = new HashSet<String>();
            ArrayList<String> tmpNumber = new ArrayList<String>();
            tmpNumber.addAll(dimNumber);
            Map<String, BgPeriodInfo> periodMap = BgViewServerHelper.getBgPeriodMap(conn, tmpNumber);
            BgPeriodInfo bgPeriodInfo2 = null;
            int periodType = rootScheme.getPeriod().getValue();
            for (BgPeriodInfo bgPeriodInfo2 : periodMap.values()) {
                try {
                    if (bgPeriodInfo2.getBeginDate() != null) {
                        rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_MBG_BgPeriod where FBeginDate >= ? and FEndDate <= ? and FPeriodType = ?", (Object[])new Object[]{new Timestamp(BgNPeriodHelper.getDayBegin((Date)bgPeriodInfo2.getBeginDate()).getTime()), new Timestamp(BgNPeriodHelper.getDayEnd((Date)bgPeriodInfo2.getEndDate()).getTime()), periodType});
                        while (rst.next()) {
                            periodIds.add(rst.getString("FID"));
                        }
                        continue;
                    }
                    periodIds.add(bgPeriodInfo2.getId().toString());
                }
                finally {
                    SQLUtils.cleanup(rst);
                }
            }
            if (subMemberTmpTableMap.containsKey(DimensionConstants.DEF_PERIOD_FIELD)) {
                tmpTableName = subMemberTmpTableMap.get(DimensionConstants.DEF_PERIOD_FIELD);
                BgDBUtils.executeUpdate((Connection)conn, (String)("truncate table " + tmpTableName));
            } else {
                tmpTableName = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                subMemberTmpTableMap.put(DimensionConstants.DEF_PERIOD_FIELD, tmpTableName);
            }
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), periodIds);
        }
    }

    static interface IBizData {
        public List<bgBaseData> queryBaseData(Connection var1, TempTablePool var2, String var3, IMbgViewBase var4, IBgDimensionManagerBase var5, BgFormInfo var6, BgSchemeInfo var7, List<String> var8, Set<String> var9, Set<String> var10, String var11) throws Exception;

        public BgUnAuditCheckData checkData(Connection var1, TempTablePool var2, String var3, IMbgViewBase var4, IBgDimensionManagerBase var5, BgFormInfo var6, BgSchemeInfo var7, List<String> var8, Set<String> var9, Set<String> var10, Set<String> var11, boolean var12, boolean var13, String var14) throws Exception;
    }

    public class bgBaseData
    implements Serializable {
        private static final long serialVersionUID = 1722814966647918183L;
        private String fid = null;
        private int state = 1;
        private String audOrgUnitId = null;

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getFid() {
            return this.fid;
        }

        public void setState(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public void setAudOrgUnitId(String audOrgUnitId) {
            this.audOrgUnitId = audOrgUnitId;
        }

        public String getAudOrgUnitId() {
            return this.audOrgUnitId;
        }
    }
}

