/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgActualAddnewImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataAddnewImpl;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BgActualDataFacadeImpl
extends AbstractDataFacadeImpl {
    public BgActualDataFacadeImpl(Context ctx, IObjectValue model) {
        super(ctx, model);
    }

    @Override
    public boolean checkModel(IObjectValue model) {
        return !(model instanceof BgActualRecordInfo);
    }

    @Override
    public BOSUuid getBillId(IObjectValue model) {
        return model.getBOSUuid(model.getPKField());
    }

    @Override
    public BOSUuid getOrgUnitId(IObjectValue model) {
        return ((BgActualRecordInfo)model).getBgForm().getOrgUnit().getId();
    }

    @Override
    public BOSUuid getVersionId(IObjectValue model) {
        return ((BgActualRecordInfo)model).getBgForm().getBgVersion().getId();
    }

    @Override
    public int getVersionIntId(IObjectValue model) throws BOSException {
        return BgVersionHelper.DEF_VERSION_VALUE;
    }

    @Override
    public String getVersionNumber(IObjectValue model) {
        return "Ve";
    }

    @Override
    public BOSUuid getBgSchemeId(IObjectValue model) {
        return ((BgActualRecordInfo)model).getBgForm().getBgScheme().getId();
    }

    @Override
    public BOSUuid getBgTemplateId(IObjectValue model) {
        return ((BgActualRecordInfo)model).getBgForm().getBgTemplate().getId();
    }

    @Override
    public BOSUuid getUserId(IObjectValue model) {
        BgActualRecordInfo bgActualRecordInfo = (BgActualRecordInfo)model;
        if (bgActualRecordInfo.getLastUpdateUser() != null) {
            return bgActualRecordInfo.getLastUpdateUser().getId();
        }
        return bgActualRecordInfo.getCreator().getId();
    }

    @Override
    public String transCube() {
        return BgCubeUtils.getDailyActualCubeName(this.getCubeInfo());
    }

    @Override
    public String transCubeEntry() {
        return BgCubeUtils.getDailyActualEntryCubeName(this.getCubeInfo());
    }

    @Override
    public void setValue(BgNDataInfo data, BigDecimal value) {
        if (data != null) {
            data.setActualValue(value);
        }
    }

    @Override
    public BigDecimal getValue(BgNDataInfo data) {
        return data.getActualValueNoDef();
    }

    @Override
    public boolean canSaveValue(BigDecimal value) {
        return true;
    }

    @Override
    protected boolean checkState(BgNDataInfo oldData) {
        return oldData != null && oldData.getState() == 1;
    }

    protected String getQuerySql(String valueField) {
        return "select FID, FFormula, FValue, FState , FOrgUnitId from " + this.getDataHelper().getCubeName() + " where Fid in (select FDataId From " + this.getDataHelper().getCubeEntryName() + " Where FFormId = ?)";
    }

    protected String getSchemeQuerySql() {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FFormula, FValue, FState , FOrgUnitId").append("from " + this.getDataHelper().getCubeName() + " ").append("where FOrgUnitId = ? ").append("and FID not in (Select FDataID From " + this.getDataHelper().getCubeEntryName() + " Where FFormId = ?) ").append("and FFormula in (");
        int in = 50;
        for (int i = 1; i < in; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        return sql.toString();
    }

    protected BgNDataInfo dealBgDataInfo(ResultSet rst) throws SQLException {
        BgNDataInfo bgData = new BgNDataInfo();
        if (rst == null) {
            return bgData;
        }
        bgData.setBgDataId(rst.getString("FID"));
        bgData.setFormula(rst.getString("FFormula"));
        this.setValue(bgData, rst.getBigDecimal(this.getValueField()));
        bgData.setState(rst.getInt("FState"));
        bgData.setBgVersion("Ve");
        return bgData;
    }

    @Override
    protected BgDataAddnewImpl getAddnewInstance() {
        return BgActualAddnewImpl.getInstance(this);
    }
}

