/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataAddnewImpl;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public class BgAdjustAddNewImpl
extends BgDataAddnewImpl {
    private boolean isAdjustTmpData = false;

    public BgAdjustAddNewImpl(AbstractDataFacadeImpl facade) {
        super(facade);
    }

    public static synchronized BgDataAddnewImpl getInstance(AbstractDataFacadeImpl facade) {
        return new BgAdjustAddNewImpl(facade);
    }

    public boolean isAdjustTmpData() {
        return this.isAdjustTmpData;
    }

    public void setAdjustTmpData(boolean isAdjustTmpData) {
        this.isAdjustTmpData = isAdjustTmpData;
    }

    @Override
    protected void createTmpTableName(TempTablePool pool, Connection conn, BgDataAddnewImpl.BgDataParam bgDataParam) throws Exception {
        if (pool == null || conn == null || bgDataParam == null) {
            return;
        }
        if (this.getFacade().getDataHelper().getCubeName().equals("T_MBG_BgTmpData") && this.getFacade().getDataHelper().getCubeEntryName().equals("T_MBG_BgTmpDataEntry")) {
            this.setAdjustTmpData(true);
        }
        if (this.isAdjustTmpData()) {
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlFields = new StringBuffer();
            sql.append("Create Table TEML_KSQL_0 (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FBgSchemeRootID VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FOldValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FAdjustReason NVARCHAR(256), FState INT DEFAULT 1 NOT NULL)");
            sqlFields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FBgSchemeRootID, FOrgUnitID, FFormula, FValue, FOldValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FAdjustReason, FState");
            bgDataParam.setTableName(BgDBUtils.createTmpTable((Context)this.getFacade().getCtx(), (TempTablePool)pool, (String)sql.toString()));
            bgDataParam.setSqlFields(sqlFields.toString());
            sql = new StringBuffer();
            sql.append("Create Table TEML_KSQL_1 (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)");
            bgDataParam.setEntryName(BgDBUtils.createTmpTable((Context)this.getFacade().getCtx(), (TempTablePool)pool, (String)sql.toString()));
        } else {
            super.createTmpTableName(pool, conn, bgDataParam);
        }
    }

    @Override
    protected void setSqlData(PreparedStatement pstmt, BgDataAddnewImpl.BgDataParam bgDataParam, BgNDataInfo bgData, String orgUnitId, String userId, Timestamp time) throws SQLException, EASBizException {
        if (this.isAdjustTmpData()) {
            this.setTmpSqlData(pstmt, bgDataParam, bgData, orgUnitId, userId, time);
        } else {
            super.setSqlData(pstmt, bgDataParam, bgData, orgUnitId, userId, time);
        }
    }

    protected void setTmpSqlData(PreparedStatement pstmt, BgDataAddnewImpl.BgDataParam bgDataParam, BgNDataInfo bgData, String orgUnitId, String userId, Timestamp time) throws SQLException, EASBizException {
        if (pstmt == null || bgData == null) {
            return;
        }
        pstmt.setString(1, bgData.getBgDataId());
        pstmt.setString(2, userId);
        pstmt.setTimestamp(3, time);
        pstmt.setString(4, userId);
        pstmt.setTimestamp(5, time);
        pstmt.setString(6, bgDataParam.getBgSchemeId());
        pstmt.setString(7, orgUnitId == null ? bgData.getOrgUnitId() : orgUnitId);
        pstmt.setString(8, bgData.getFormula());
        pstmt.setBigDecimal(9, this.getFacade().getValue(bgData).setScale(8, 4));
        pstmt.setBigDecimal(10, bgData.getBudgetValueNoDef() != null ? bgData.getBudgetValueNoDef() : BgNConstants.ZERO);
        String _itemId = bgData.getBgItemNumber();
        if (_itemId == null) {
            this.exceptionItem(bgData);
        } else {
            pstmt.setString(11, _itemId);
        }
        BgPeriodInfo bgPeriodInfo = bgDataParam.getBgPeriodMap().get(bgData.getBgPeriodNumber());
        if (bgPeriodInfo == null) {
            this.exceptionPeriod(bgData);
        } else {
            pstmt.setString(12, bgPeriodInfo.getString(bgPeriodInfo.getPKField()));
        }
        BgElementInfo bgElementInfo = bgDataParam.getBgElementMap().get(bgData.getBgElementNumber());
        if (bgElementInfo == null) {
            this.exceptionElement(bgData);
        } else {
            pstmt.setString(13, bgElementInfo.getString(bgElementInfo.getPKField()));
        }
        CurrencyInfo currencyInfo = bgDataParam.getCurrencyMap().get(bgData.getCurrencyNumber());
        if (currencyInfo == null) {
            this.exceptionCurrency(bgData);
        } else {
            pstmt.setString(14, currencyInfo.getString(currencyInfo.getPKField()));
        }
        BgScenarioInfo scenario = bgDataParam.getScenarioMap().get(bgData.getBgScenario());
        if (scenario == null) {
            this.exceptionScenario(bgData);
        } else {
            pstmt.setInt(15, scenario.getScenarioId());
        }
        pstmt.setInt(16, this.getVersionInnId());
        pstmt.setString(17, bgData.getAdjustReason());
        pstmt.setInt(18, this.getTmpState());
        pstmt.addBatch();
    }

    @Override
    protected void afterSqlData(PreparedStatement pstmt, BgDataAddnewImpl.BgDataParam bgDataParam, BgNDataInfo bgData) throws SQLException {
        super.afterSqlData(pstmt, bgDataParam, bgData);
        pstmt.setBigDecimal(8, BgNConstants.ZERO);
    }

    @Override
    protected int getState() {
        return 3;
    }

    protected int getTmpState() {
        return 1;
    }

    public void addnewTmpData(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null || this.getFacade() == null || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        this.addNewValueBySql(ctx, valueMap);
    }

    @Override
    protected String[] getAddnewDataSql(List<String> dimRefs, BgDataAddnewImpl.BgDataParam dataParam) {
        if (this.isAdjustTmpData()) {
            return this.getAddnewTmpDataSql(dataParam);
        }
        return super.getAddnewDataSql(dimRefs, dataParam);
    }

    protected String[] getAddnewTmpDataSql(BgDataAddnewImpl.BgDataParam dataParam) {
        String tableName = this.getCubeName();
        if (dataParam.getTableName() != null) {
            tableName = dataParam.getTableName();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FBgSchemeRootID, FOrgUnitID, FFormula, FValue, FOldValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FAdjustReason, FState) Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String entryName = this.getEntryName();
        if (dataParam.getEntryName() != null) {
            entryName = dataParam.getEntryName();
        }
        String[] sqls = new String[]{sql.toString(), "Insert Into " + entryName + " (FFormID, FDataID) values (?,?)"};
        return sqls;
    }
}

