/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgAdjustException;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustAddNewImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustDeleteImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustUpdateImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataAddnewImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataDeleteImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataUpdateImpl;
import com.kingdee.eas.ma.mbg.app.utils.IDataHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustDataFacadeImpl
extends AbstractDataFacadeImpl {
    private static final Logger logger = Logger.getLogger(BgAdjustDataFacadeImpl.class);
    public static final String TMP_DATA = "T_MBG_BgTmpData";
    public static final String TMP_DATA_ENTRY = "T_MBG_BgTmpDataEntry";
    private BgDataAddnewImpl addnewIns = null;
    private BgDataUpdateImpl updateIns = null;
    private BgDataDeleteImpl deleteIns = null;
    private boolean queryTmpData = false;

    public BgAdjustDataFacadeImpl(Context ctx, IObjectValue model) {
        super(ctx, model);
    }

    @Override
    public IDataHelper createDataHelper() {
        return super.createDataHelper();
    }

    @Override
    public boolean checkModel(IObjectValue model) {
        return !(model instanceof BgFormInfo);
    }

    @Override
    public BOSUuid getBillId(IObjectValue model) {
        return ((BgFormInfo)model).getAdjust().getId();
    }

    @Override
    public BOSUuid getOrgUnitId(IObjectValue model) {
        return ((BgFormInfo)model).getOrgUnit().getId();
    }

    @Override
    public BOSUuid getVersionId(IObjectValue model) {
        return ((BgFormInfo)model).getBgVersion().getId();
    }

    @Override
    public int getVersionIntId(IObjectValue model) throws BOSException {
        return ((BgFormInfo)model).getBgVersion().getVersionId();
    }

    @Override
    public String getVersionNumber(IObjectValue model) {
        return ((BgFormInfo)model).getBgVersion().getNumber();
    }

    @Override
    public BOSUuid getBgSchemeId(IObjectValue model) {
        return ((BgFormInfo)model).getBgScheme().getId();
    }

    @Override
    public BOSUuid getBgTemplateId(IObjectValue model) {
        return ((BgFormInfo)model).getBgTemplate().getId();
    }

    @Override
    public BOSUuid getUserId(IObjectValue model) {
        BgFormInfo info = (BgFormInfo)model;
        if (info.getLastUpdateUser() != null) {
            return info.getLastUpdateUser().getId();
        }
        if (info.getCreator() != null) {
            return info.getCreator().getId();
        }
        return ContextUtil.getCurrentUserInfo((Context)this.getCtx()).getId();
    }

    @Override
    public String transCube() {
        return this.getCubeInfo();
    }

    @Override
    public String transCubeEntry() {
        return BgCubeUtils.getBudgetEntryCubeName(this.getCubeInfo());
    }

    @Override
    public void setValue(BgNDataInfo data, BigDecimal value) {
        if (data != null) {
            data.setAdjustValue(value);
        }
    }

    @Override
    public BigDecimal getValue(BgNDataInfo data) {
        return data.getAdjustValue();
    }

    @Override
    public boolean canSaveValue(BigDecimal value) {
        return value != null;
    }

    @Override
    protected boolean checkState(BgNDataInfo oldData) {
        return true;
    }

    @Override
    protected void after(BgNDataInfo bgData, BgNDataInfo oldData) {
        if (bgData == null || oldData == null) {
            return;
        }
        bgData.setBudgetValue(oldData.getAdjustValue());
    }

    @Override
    public void save() throws BOSException, EASBizException {
        super.save();
        this.saveTmpData();
    }

    @Override
    protected synchronized BgDataAddnewImpl getAddnewInstance() {
        if (this.addnewIns == null) {
            this.addnewIns = BgAdjustAddNewImpl.getInstance(this);
        }
        return this.addnewIns;
    }

    @Override
    protected synchronized BgDataUpdateImpl getUpdateInstance() {
        if (this.updateIns == null) {
            this.updateIns = BgAdjustUpdateImpl.getInstance(this);
        }
        return this.updateIns;
    }

    @Override
    protected BgDataDeleteImpl getDeleteInstance() {
        if (this.deleteIns == null) {
            this.deleteIns = BgAdjustDeleteImpl.getInstance(this);
        }
        return this.deleteIns;
    }

    public void saveTmpData() throws BOSException, EASBizException {
        Object[] objs;
        this.getDataHelper().setCubeName(TMP_DATA);
        this.getDataHelper().setCubeEntryName(TMP_DATA_ENTRY);
        this.setQueryTmpData(true);
        IBgNData bgData = null;
        BgNDataInfo bgNData = null;
        ArrayList<IBgNData> datas = new ArrayList<IBgNData>();
        int in = this.getDataHelper().getDatas().size();
        for (int i = 0; i < in; ++i) {
            bgData = this.getDataHelper().getDatas().get(i);
            if (!(bgData instanceof BgNDataInfo) || !(bgNData = (BgNDataInfo)bgData).compareValue(bgNData.getAdjustValue(), bgNData.getBudgetValueNoDef())) continue;
            datas.add(bgData);
        }
        if (!datas.isEmpty()) {
            this.getDataHelper().getDatas().removeAll(datas);
        }
        if ((objs = this.compareData(this.getCtx(), this.getDataHelper().getModel())) != null) {
            this.addNewTmpValue(this.getCtx(), (Map)objs[0]);
            this.updateTmpValue(this.getCtx(), (Map)objs[1]);
            this.deleteTmpValue(this.getCtx(), (Map)objs[2]);
            this.saveDataRef(this.getCtx(), objs[4]);
        }
    }

    public boolean isQueryTmpData() {
        return this.queryTmpData;
    }

    public void setQueryTmpData(boolean queryTmpData) {
        this.queryTmpData = queryTmpData;
    }

    protected void addNewTmpValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof Map)) {
            return;
        }
        Map valueMap = (Map)value;
        if (valueMap.isEmpty()) {
            return;
        }
        ((BgAdjustAddNewImpl)this.getAddnewInstance()).addnewTmpData(this.getCtx(), valueMap);
    }

    protected void updateTmpValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof Map)) {
            return;
        }
        Map valueMap = (Map)value;
        if (valueMap.isEmpty()) {
            return;
        }
        ((BgAdjustUpdateImpl)this.getUpdateInstance()).updateTmpData(this.getCtx(), valueMap);
    }

    public void deleteTmpValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || !(value instanceof Map)) {
            return;
        }
        Map valueMap = (Map)value;
        if (valueMap.isEmpty()) {
            return;
        }
        ((BgAdjustDeleteImpl)this.getDeleteInstance()).deleteTmpData(this.getCtx(), valueMap);
    }

    public Map<String, Map<String, IBgNData>> getNewAdjustData(Set<String> orgIdSet, Set<String> formIdSet) throws BOSException {
        if (this.getDataHelper().getCubeName().equals(TMP_DATA) && this.getDataHelper().getCubeEntryName().equals(TMP_DATA_ENTRY)) {
            this.setQueryTmpData(true);
        } else {
            this.setQueryTmpData(false);
        }
        return this.queryFormula(this.getCtx(), this.getBillId(this.getDataHelper().getModel()), orgIdSet, formIdSet);
    }

    @Override
    protected String getQuerySql() {
        if (this.isQueryTmpData()) {
            return this.getQueryTmpSql();
        }
        return super.getQuerySql();
    }

    @Override
    protected String getValueField() {
        if (this.isQueryTmpData()) {
            return "FValue";
        }
        return "FTmpValue";
    }

    protected String getQueryTmpSql() {
        return "select bgData.FID, bgData.FFormula, bgData.FValue dataValue , bgData.FOldValue, bgData.FState, bgData.ForgUnitId, bgVersion.FNumber bgVersion_FNumber from " + this.getDataHelper().getCubeName() + " bgData, T_Mbg_BgVersion bgVersion where bgData.FVersion = bgVersion.FVersionId and bgData.Fid in (select FDataId From " + this.getDataHelper().getCubeEntryName() + " Where FFormId = ?)";
    }

    @Override
    protected BgNDataInfo dealBgDataInfo(ResultSet rst, boolean hasOldValue) throws SQLException {
        BgNDataInfo bgData = super.dealBgDataInfo(rst, hasOldValue);
        if (bgData != null && this.isQueryTmpData() && hasOldValue) {
            bgData.setBudgetValue(rst.getBigDecimal("FOldValue"));
        }
        return bgData;
    }

    @Override
    public void audit(Map<String, String> auditParams) throws BOSException, EASBizException {
        if (this.getCtx() == null || this.getDataHelper() == null) {
            return;
        }
        String _billId = this.getBillId(this.getDataHelper().getModel()).toString();
        String _audOrgUnitId = null;
        String _audUserId = null;
        if (auditParams != null) {
            if (auditParams.containsKey("ORGUNIT_AUDIT_ID")) {
                _audOrgUnitId = auditParams.get("ORGUNIT_AUDIT_ID");
            }
            if (auditParams.containsKey("USER_ID")) {
                _audUserId = auditParams.get("USER_ID");
            }
        }
        String cubeName = this.getDataHelper().getBgSchemeInfo().getRefCube();
        if (this.getDataHelper().getModel() instanceof BgFormInfo && this.getDataHelper().isDecompose()) {
            cubeName = BgCubeUtils.getCubeName(this.getDataHelper().getBgSchemeInfo().getRefCube(), ((BgFormInfo)this.getDataHelper().getModel()).getProcessType());
        }
        String sqlValue = "Update " + DimensionConstants.CUBE_NAME + " Set FValue = FTmpValue  where FID IN (Select FDataID from " + TMP_DATA_ENTRY + " where FFormID = ?)";
        String sqlState = "Update " + DimensionConstants.CUBE_NAME + " Set FState = " + 9 + ", FAudOrgUnitID = ?, FAudUserID = ?,FAudFormId = ? where FID IN (Select FDataID from " + TMP_DATA_ENTRY + " where FFormID = ?) and FState NOT IN(" + 11 + ", " + 13 + ")";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getCtx());
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(this.getCtx(), this.getDataHelper().getBgSchemeInfo().getId().toString(), cubeName);
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            for (String cube : cubeNames) {
                pstmt = conn.prepareStatement(sqlValue.replace(DimensionConstants.CUBE_NAME, cube));
                pstmt.setString(1, _billId);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
                pstmt = conn.prepareStatement(sqlState.replace(DimensionConstants.CUBE_NAME, cube));
                pstmt.setString(1, _audOrgUnitId);
                pstmt.setString(2, _audUserId);
                pstmt.setString(3, _billId);
                pstmt.setString(4, _billId);
                pstmt.executeUpdate();
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"bgAdjustData Aduit Error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkAdjustBillData(BOSUuid bgSchemeId, BOSUuid orgUnitId, BOSUuid versionId) throws BOSException, EASBizException {
        String tmpTable;
        TempTablePool pool;
        IRowSet rst;
        Connection conn;
        block17: {
            if (this.getCtx() == null) return;
            if (bgSchemeId == null) return;
            if (orgUnitId == null) return;
            if (versionId == null) return;
            if (this.getDataHelper().getFormulas().isEmpty()) {
                return;
            }
            conn = null;
            rst = null;
            pool = null;
            tmpTable = null;
            int type = 0;
            String number = null;
            StringBuffer strs = new StringBuffer();
            try {
                conn = BgDBUtils.getConnection((Context)this.getCtx());
                pool = TempTablePool.getInstance((Context)this.getCtx());
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FFormula) values (?)"), this.getDataHelper().getFormulas());
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FNumber, t.FType, e.FIndexMemberName, e.FMEMBERCOMBINNAME, p.FName_" + this.getCtx().getLocale() + "  , u.FNumber AS ForgNum ,u.FName_" + this.getCtx().getLocale() + " AS ForgName from T_MBG_BgAdjustBill t join T_MBG_BgAdjustBillEntry e on t.FID = e.FBGADJUSTBILL join T_MBG_BgPeriod p on e.FPERIOD = p.FID join T_MBG_BgOrgUnit u on e.FORGUNIT = u.FID where t.FBGSCHEME = ? and t.FSTATE not in( " + 4 + " , " + 5 + ") and t.FBGVERSIONID = ? and u.FOrgUnitId = ? and e.FFormula IN (select FFormula from " + tmpTable + ") order by t.FNumber"), (Object[])new Object[]{bgSchemeId.toString(), versionId.toString(), orgUnitId.toString()});
                while (rst.next()) {
                    type = rst.getInt("FType");
                    number = rst.getString("FNumber");
                    Object[] objs = new Object[]{rst.getString(5), StringUtils.isEmpty((String)rst.getString("FMEMBERCOMBINNAME")) ? rst.getString("FIndexMemberName") : rst.getString("FIndexMemberName") + "," + rst.getString("FMEMBERCOMBINNAME"), number, rst.getString("ForgNum"), rst.getString("ForgName")};
                    String tmpStr = null;
                    tmpStr = type == 0 || type == 1 ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkInnAdjustDataExists", (Locale)this.getCtx().getLocale(), (Object[])objs) : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkAdjustDataExists", (Locale)this.getCtx().getLocale(), (Object[])objs);
                    strs.append(tmpStr + "\r\n");
                }
                if (strs.length() > 0) {
                    throw new BgAdjustException(BgAdjustException.CHECKADJUSTDATAEXISTS, new String[]{strs.toString()});
                }
                if (pool == null) break block17;
            }
            catch (SQLException ex) {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    logger.error((Object)ex3);
                    return;
                }
            }
            try {
                pool.releaseTable(tmpTable);
            }
            catch (Exception objs) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return;
        finally {
            if (pool != null) {
                try {
                    pool.releaseTable(tmpTable);
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkViewAdjustBillData(IObjectValue bgForm) throws BOSException, EASBizException {
        String tmpTable;
        TempTablePool pool;
        IRowSet rst;
        Connection conn;
        block18: {
            if (bgForm == null) return;
            if (this.getDataHelper().getDatas().isEmpty()) {
                return;
            }
            String bgSchemeId = ((BgFormInfo)bgForm).getBgScheme().getId().toString();
            String versionId = ((BgFormInfo)bgForm).getBgVersion().getId().toString();
            conn = null;
            rst = null;
            pool = null;
            tmpTable = null;
            int type = 0;
            String number = null;
            StringBuffer strs = new StringBuffer();
            try {
                conn = BgDBUtils.getConnection((Context)this.getCtx());
                pool = TempTablePool.getInstance((Context)this.getCtx());
                tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FOrgUnitId VARCHAR(44), FFormula NVARCHAR(300), FVersionId VARCHAR(44))", conn);
                ArrayList sqlParams2333332 = new ArrayList();
                ArrayList<String> tmps = null;
                for (IBgNData bgData : this.getDataHelper().getDatas()) {
                    tmps = new ArrayList<String>();
                    tmps.add(((BgNDataInfo)bgData).getOrgUnitId());
                    tmps.add(((BgNDataInfo)bgData).getFormula());
                    tmps.add(versionId);
                    sqlParams2333332.add(tmps);
                }
                BgDBUtils.insertValue((Connection)conn, (String)("Insert Into " + tmpTable + " (FOrgUnitId, FFormula, FVersionId) values (?,?,?)"), sqlParams2333332);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select t.FNumber, t.FType, e.FIndexMemberName, e.FMEMBERCOMBINNAME, p.FName_" + this.getCtx().getLocale() + "  , u.FNumber AS ForgNum ,u.FName_" + this.getCtx().getLocale() + " AS ForgName from T_MBG_BgAdjustBill t join T_MBG_BgAdjustBillEntry e on t.FID = e.FBGADJUSTBILL join T_MBG_BgPeriod p on e.FPERIOD = p.FID join T_MBG_BgOrgUnit u on e.FORGUNIT = u.FID where t.FBGSCHEME = ? and t.FSTATE <> " + 4 + " and exists (select * from " + tmpTable + " where FOrgUnitId = u.FOrgUnitId and FFormula = e.FFormula and FVersionId = t.FBgVersionId) order by t.FNumber"), (Object[])new Object[]{bgSchemeId});
                while (rst.next()) {
                    type = rst.getInt("FType");
                    number = rst.getString("FNumber");
                    Object[] objs = new Object[]{rst.getString(5), StringUtils.isEmpty((String)rst.getString("FMEMBERCOMBINNAME")) ? rst.getString("FIndexMemberName") : rst.getString("FIndexMemberName") + "," + rst.getString("FMEMBERCOMBINNAME"), number, rst.getString("ForgNum"), rst.getString("ForgName")};
                    String tmpStr = null;
                    tmpStr = type == 0 || type == 1 ? ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkInnAdjustDataExists", (Locale)this.getCtx().getLocale(), (Object[])objs) : ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustBillResource", (String)"checkAdjustDataExists", (Locale)this.getCtx().getLocale(), (Object[])objs);
                    strs.append(tmpStr + "\r\n");
                }
                if (strs.length() > 0) {
                    throw new BgAdjustException(BgAdjustException.CHECKADJUSTDATAEXISTS, new String[]{strs.toString()});
                }
                if (pool == null) break block18;
            }
            catch (SQLException ex) {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    logger.error((Object)ex3);
                    return;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpTable, conn);
            }
            catch (Exception sqlParams2333332) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return;
        finally {
            if (pool != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpTable, conn);
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
    }
}

