/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.app.utils.BgDataFacadeUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.DataHelper;
import com.kingdee.eas.ma.mbg.app.utils.IDataFacade;
import com.kingdee.eas.ma.mbg.app.utils.IDataHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAdjustDataImp
implements IDataFacade {
    private static final Logger logger = Logger.getLogger(BgAdjustDataImp.class);
    private IDataHelper dataHelper = null;
    private Context ctx = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, DimensionMemberCheckHelper> orgDimMemberCheckHelperMap = new HashMap<String, DimensionMemberCheckHelper>();

    private void setDataHelper(IDataHelper dataHelper) {
        this.dataHelper = dataHelper;
    }

    @Override
    public IDataHelper getDataHelper() {
        return this.dataHelper;
    }

    public IDataHelper createDataHelper() {
        return new DataHelper();
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.getDataHelper().getBgSchemeInfo().getId().toString());
        }
        return this.schemeHelper;
    }

    public BgAdjustDataImp(Context ctx, IObjectValue model) {
        this.setCtx(ctx);
        this.setDataHelper(this.createDataHelper());
        this.getDataHelper().setModel(model);
    }

    @Override
    public void addData(IBgNData data) {
        if (data != null) {
            data.splitFormula();
            this.getDataHelper().getDatas().add(data);
            this.getDataHelper().getFormulas().add(data.getFormula());
        }
    }

    @Override
    public void save() throws BOSException, EASBizException {
        Object[] objs = this.compareData(this.getCtx(), this.getDataHelper().getModel());
        if (objs != null) {
            this.addNewValue(this.getCtx(), objs[0]);
            this.updateValue(this.getCtx(), objs[1]);
            this.deleteValue(this.getCtx(), objs[2]);
        }
    }

    @Override
    public void audit(Map<String, String> auditParams) throws BOSException, EASBizException {
    }

    protected Object[] compareData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || !this.checkModel(model)) {
            return null;
        }
        BOSUuid bgSchemeId = this.getBgSchemeId(model);
        if (bgSchemeId == null) {
            return null;
        }
        if (this.getDataHelper().getCubeName() == null) {
            this.getDataHelper().setCubeName(this.getCubeName());
        }
        if (this.getDataHelper().getCubeEntryName() == null) {
            this.getDataHelper().setCubeEntryName(this.getCubeEntryName());
        }
        String _bgSchemeId = bgSchemeId.toString();
        Set<String> orgUnitIds = this.getOrgUnitIds();
        HashSet<String> formulas = new HashSet<String>();
        formulas.addAll(this.getDataHelper().getFormulas());
        Map<String, Map<String, IBgNData>> orgDataMap = this.querySchemeData(ctx, _bgSchemeId, orgUnitIds);
        Map<String, IBgNData> bgDataMap = null;
        HashMap<String, BgNDataInfo> _addnew = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _update = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _delete = new HashMap<String, BgNDataInfo>();
        HashSet _formulas = new HashSet();
        Object[] _objs = new Object[]{_addnew, _update, _delete, _formulas};
        BgNDataInfo bgData = null;
        BgNDataInfo oldData = null;
        DimensionMemberCheckHelper checkhelper = null;
        boolean canSave = true;
        String _dimkey = null;
        int in = this.getDataHelper().getDatas().size();
        for (int i = 0; i < in; ++i) {
            bgData = (BgNDataInfo)this.getDataHelper().getDatas().get(i);
            if (!bgData.isCanSave()) continue;
            try {
                checkhelper = this.getMemberCheckHelper(ctx, bgData.getOrgUnitId(), null, _bgSchemeId, formulas);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (checkhelper != null && !checkhelper.canSave(bgData, null, null)) continue;
            canSave = this.canSaveValue(bgData);
            if (orgDataMap.containsKey(bgData.getOrgUnitId())) {
                bgDataMap = orgDataMap.get(bgData.getOrgUnitId());
                if (bgDataMap.containsKey(_dimkey = this.getDimDataKey(bgData))) {
                    oldData = (BgNDataInfo)bgDataMap.get(_dimkey);
                    bgData.setBgDataId(oldData.getBgDataId());
                    if (canSave) {
                        _update.put(bgData.getFormula(), bgData);
                        continue;
                    }
                    _delete.put(bgData.getFormula(), bgData);
                    continue;
                }
                if (!canSave) continue;
                _addnew.put(bgData.getFormula(), bgData);
                continue;
            }
            if (!canSave) continue;
            _addnew.put(bgData.getFormula(), bgData);
        }
        return _objs;
    }

    protected boolean checkModel(IObjectValue model) {
        return model instanceof BgAdjustBillInfo;
    }

    protected BOSUuid getBgSchemeId(IObjectValue model) {
        return ((BgAdjustBillInfo)model).getBgScheme().getId();
    }

    protected String getCubeName() {
        return BgDataFacadeUtils.TABLE_TMP_DATA;
    }

    protected String getCubeEntryName() {
        return BgDataFacadeUtils.TABLE_TMPENTRY_DATA;
    }

    protected Map<String, DimensionMemberCheckHelper> getOrgCheckMap() {
        return this.orgDimMemberCheckHelperMap;
    }

    protected Set<String> getOrgUnitIds() {
        HashSet<String> orgUnitIds = new HashSet<String>();
        BgAdjustBillInfo bgAdjust = (BgAdjustBillInfo)this.getDataHelper().getModel();
        int in = bgAdjust.getEntity().size();
        for (int i = 0; i < in; ++i) {
            orgUnitIds.add(bgAdjust.getEntity().get(i).getOrgUnit().getOrgUnitID());
        }
        return orgUnitIds;
    }

    protected DimensionMemberCheckHelper getMemberCheckHelper(Context ctx, String orgUnitId, String bgTemplateId, String bgSchemeId, Collection<String> formulas) throws Exception {
        DimensionMemberCheckHelper helper = null;
        if (this.getOrgCheckMap().containsKey(orgUnitId)) {
            helper = this.getOrgCheckMap().get(orgUnitId);
        } else {
            helper = DimensionMemberCheckHelper.getLocalIntance(ctx, null, orgUnitId, bgTemplateId, this.getSchemeHelper(), formulas, this.getDataHelper().isDecompose());
            this.getOrgCheckMap().put(orgUnitId, helper);
        }
        return helper;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Map<String, IBgNData>> querySchemeData(Context ctx, String bgSchemeId, Set<String> orgUnitIds) throws BOSException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        long beginTime;
        HashMap<String, Map<String, IBgNData>> orgDataMap;
        block18: {
            orgDataMap = new HashMap<String, Map<String, IBgNData>>();
            if (ctx == null || bgSchemeId == null || orgUnitIds == null || this.getDataHelper().getFormulas().isEmpty()) {
                return orgDataMap;
            }
            beginTime = System.currentTimeMillis();
            System.out.print("begin querySchemeData!");
            BgAdjustBillInfo bgAdjustBill = (BgAdjustBillInfo)this.getDataHelper().getModel();
            HashSet<String> formulas = new HashSet<String>();
            formulas.addAll(this.getDataHelper().getFormulas());
            conn = null;
            pstmt = null;
            rst = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpOrgUnitName = null;
            String tmpFormulaName = null;
            BgNDataInfo bgData = null;
            Map<String, BgNDataInfo> bgDataMap = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                tmpOrgUnitName = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
                BgDBUtils.insertKey((Connection)conn, (String)("INSERT INTO " + tmpOrgUnitName + "(FID) VALUES (?) "), orgUnitIds);
                tmpFormulaName = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormula NVARCHAR(300))", conn);
                BgDBUtils.insertKey((Connection)conn, (String)("INSERT INTO " + tmpFormulaName + "(FFormula) VALUES (?) "), formulas);
                StringBuffer sql2333332 = new StringBuffer();
                sql2333332.append("select FID, FOrgUnitId, FFormula, FValue from " + this.getCubeName() + " where FBgSchemeRootID = ? and FOrgUnitId IN (select FID from " + tmpOrgUnitName + ") and FFormula in (select FFormula from " + tmpFormulaName + ") and FVersion = ?");
                pstmt = conn.prepareStatement(sql2333332.toString());
                pstmt.setString(1, bgAdjustBill.getBgScheme().getId().toString());
                pstmt.setInt(2, bgAdjustBill.getBgVersion().getVersionId());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgData = new BgNDataInfo();
                    bgData.setBgDataId(rst.getString("FID"));
                    bgData.setOrgUnitId(rst.getString("FOrgUnitId"));
                    bgData.setFormula(rst.getString("FFormula"));
                    bgData.setAdjustValue(rst.getBigDecimal("FValue"));
                    if (orgDataMap.containsKey(bgData.getOrgUnitId())) {
                        bgDataMap = (Map)orgDataMap.get(bgData.getOrgUnitId());
                    } else {
                        bgDataMap = new HashMap();
                        orgDataMap.put(bgData.getOrgUnitId(), bgDataMap);
                    }
                    bgDataMap.put(bgData.getFormula(), bgData);
                }
                if (pool == null) break block18;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"error", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                    catch (Exception ex2) {
                        logger.error((Object)"error", (Throwable)ex2);
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpOrgUnitName, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            pool.releaseDBSystemTempTable(tmpFormulaName, conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpOrgUnitName, conn);
            }
            catch (Exception sql2333332) {
                // empty catch block
            }
            try {
                pool.releaseDBSystemTempTable(tmpFormulaName, conn);
            }
            catch (Exception sql2333332) {
                // empty catch block
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        System.out.print("end querySchemeData! invoke queryUse = " + (System.currentTimeMillis() - beginTime) + " ms;");
        return orgDataMap;
    }

    protected boolean canSaveValue(BgNDataInfo bgData) {
        return true;
    }

    protected String getDimDataKey(BgNDataInfo bgData) {
        if (bgData != null) {
            return bgData.getFormula();
        }
        return null;
    }

    protected void addNewValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || value == null) {
            return;
        }
        Map bgDataMap = (Map)value;
        if (bgDataMap.isEmpty()) {
            return;
        }
        BgNDataInfo bgData2 = null;
        ArrayList<String> _bgPeriod = new ArrayList<String>();
        ArrayList<String> _bgElement = new ArrayList<String>();
        ArrayList<String> _currency = new ArrayList<String>();
        BgAdjustBillInfo bgAdjustBill = (BgAdjustBillInfo)this.getDataHelper().getModel();
        String userId = bgAdjustBill.getLastUpdateUser().getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String _billId = bgAdjustBill.getId().toString();
        String _bgSchemeId = bgAdjustBill.getBgScheme().getId().toString();
        for (BgNDataInfo bgData2 : bgDataMap.values()) {
            _bgPeriod.add(bgData2.getBgPeriodNumber());
            _bgElement.add(bgData2.getBgElementNumber());
            _currency.add(bgData2.getCurrencyNumber());
        }
        Map<String, BgPeriodInfo> bgPeriodMap = BgViewServerHelper.getBgPeriodMap(ctx, _bgPeriod);
        Map<String, BgElementInfo> bgElementMap = BgViewServerHelper.getBgElementMap(ctx, _bgElement);
        Map<String, CurrencyInfo> currencyMap = BgViewServerHelper.getCurrencyMap(ctx, _currency);
        Map scenarioMap = BgScenarioHelper.getScenariooObjMap((Context)ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pest = null;
        int batchIndex = 0;
        BOSUuid uuid = null;
        BOSObjectType type = new BgDataInfo().getBOSType();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + this.getCubeName() + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FBgSchemeRootID, FOrgUnitID, FFormula, FValue, FOldValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FAdjustReason, FState) Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        StringBuffer eSql = new StringBuffer();
        eSql.append("Insert Into " + this.getCubeEntryName() + " (FFormId, FDataId) Values (?,?)");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pest = conn.prepareStatement(eSql.toString());
            for (BgNDataInfo bgData2 : bgDataMap.values()) {
                uuid = BOSUuid.create((BOSObjectType)type);
                pstmt.setString(1, uuid.toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, time);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, time);
                pstmt.setString(6, _bgSchemeId);
                pstmt.setString(7, bgData2.getOrgUnitId());
                pstmt.setString(8, bgData2.getFormula());
                pstmt.setBigDecimal(9, bgData2.getAdjustValue());
                pstmt.setBigDecimal(10, bgData2.getBudgetValueNoDef() != null ? bgData2.getBudgetValueNoDef() : BgNConstants.ZERO);
                String _itemId = bgData2.getBgItemNumber();
                if (_itemId == null) {
                    this.exceptionItem(bgData2);
                } else {
                    pstmt.setString(11, _itemId);
                }
                BgPeriodInfo bgPeriodInfo = bgPeriodMap.get(bgData2.getBgPeriodNumber());
                if (bgPeriodInfo == null) {
                    this.exceptionPeriod(bgData2);
                } else {
                    pstmt.setString(12, bgPeriodInfo.getString(bgPeriodInfo.getPKField()));
                }
                BgElementInfo bgElementInfo = bgElementMap.get(bgData2.getBgElementNumber());
                if (bgElementInfo == null) {
                    this.exceptionElement(bgData2);
                } else {
                    pstmt.setString(13, bgElementInfo.getString(bgElementInfo.getPKField()));
                }
                CurrencyInfo currencyInfo = currencyMap.get(bgData2.getCurrencyNumber());
                if (currencyInfo == null) {
                    this.exceptionCurrency(bgData2);
                } else {
                    pstmt.setString(14, currencyInfo.getString(currencyInfo.getPKField()));
                }
                BgScenarioInfo scenario = (BgScenarioInfo)scenarioMap.get(bgData2.getBgScenario());
                if (scenario == null) {
                    this.exceptionScenario(bgData2);
                } else {
                    pstmt.setInt(15, scenario.getScenarioId());
                }
                pstmt.setInt(16, bgAdjustBill.getBgVersion().getVersionId());
                pstmt.setString(17, bgData2.getAdjustReason());
                pstmt.setInt(18, 1);
                pstmt.addBatch();
                pest.setString(1, _billId);
                pest.setString(2, uuid.toString());
                pest.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                pest.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
                pest.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"data addNew:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pest);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pest);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void updateValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || value == null) {
            return;
        }
        Map bgDataMap = (Map)value;
        if (bgDataMap.isEmpty()) {
            return;
        }
        BgNDataInfo bgData2 = null;
        BgAdjustBillInfo bgAdjustBill = (BgAdjustBillInfo)this.getDataHelper().getModel();
        String userId = bgAdjustBill.getLastUpdateUser().getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchIndex = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + this.getCubeName() + " Set FValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FID = ?");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (BgNDataInfo bgData2 : bgDataMap.values()) {
                pstmt.setBigDecimal(1, bgData2.getAdjustValue());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, time);
                pstmt.setString(4, bgData2.getBgDataId());
                pstmt.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"data addNew:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void deleteValue(Context ctx, Object value) throws BOSException, EASBizException {
        if (ctx == null || value == null) {
            return;
        }
        Map bgDataMap = (Map)value;
        if (bgDataMap.isEmpty()) {
            return;
        }
        BgNDataInfo bgData2 = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pest = null;
        int batchIndex = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + this.getCubeName() + " where FID = ?");
        StringBuffer eSql = new StringBuffer();
        eSql.append("delete from " + this.getCubeEntryName() + " where FDataId = ?");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pest = conn.prepareStatement(eSql.toString());
            for (BgNDataInfo bgData2 : bgDataMap.values()) {
                pstmt.setString(1, bgData2.getBgDataId());
                pstmt.addBatch();
                pest.setString(1, bgData2.getBgDataId());
                pest.addBatch();
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                pest.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
                pest.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"data addNew:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pest);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pest);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void exceptionCurrency(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("currency number error:" + bgData.getCurrencyNumber()));
        throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{bgData.getCurrencyNumber()});
    }

    protected void exceptionElement(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgElement number error:" + bgData.getBgElementNumber()));
        throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{bgData.getBgElementNumber()});
    }

    protected void exceptionItem(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgItem number error:" + bgData.getBgItemNumber()));
        throw new BgFormException(BgFormException.SUBMITNOITEM, new String[]{bgData.getBgItemNumber()});
    }

    protected void exceptionPeriod(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgPeriod number error:" + bgData.getBgPeriodNumber()));
        throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{bgData.getBgPeriodNumber()});
    }

    protected void exceptionScenario(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgScenario number error:" + bgData.getBgScenario()));
        throw new BgFormException(BgFormException.SUBMITNOBGSCENARIO, new String[]{bgData.getBgScenario()});
    }
}

