/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgDataDeleteImpl;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAdjustDeleteImpl
extends BgDataDeleteImpl {
    private static final Logger logger = Logger.getLogger(BgAdjustDeleteImpl.class);

    public BgAdjustDeleteImpl(AbstractDataFacadeImpl facade) {
        super(facade);
    }

    public static synchronized BgDataDeleteImpl getInstance(AbstractDataFacadeImpl facade) {
        return new BgAdjustDeleteImpl(facade);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteTmpData(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (this.getFacade() == null) return;
        if (valueMap == null) return;
        if (valueMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        TempTablePool pool = null;
        String tmpTableName = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTableName = BgDBUtils.createTmpTable((Context)this.getFacade().getCtx(), (TempTablePool)pool, (String)this.getDeleteTmpTableSql());
            if (tmpTableName != null) {
                Object var6_6 = null;
                ArrayList<String> sqlParams = new ArrayList<String>();
                for (BgNDataInfo bgNDataInfo : valueMap.values()) {
                    sqlParams.add(bgNDataInfo.getBgDataId());
                }
                BgDBUtils.insertKey((Connection)conn, (String)this.getInsertTmpTableSql(tmpTableName), sqlParams);
                BgDBUtils.executeUpdate((Connection)conn, (String)this.getDeleteSql(tmpTableName));
                BgDBUtils.executeUpdate((Connection)conn, (String)this.getUpdataTmpValueSql(tmpTableName));
                BgDBUtils.executeUpdate((Connection)conn, (String)this.getDeleteTmpSql(tmpTableName));
                BgDBUtils.executeUpdate((Connection)conn, (String)this.getDeleteTmpEntrySql(tmpTableName));
            }
        }
        catch (SQLException sQLException) {
            try {
                logger.error((Object)"AdjustData Delete Error:", (Throwable)sQLException);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{sQLException.getMessage()});
            }
            catch (Throwable throwable) {
                try {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTableName);
                }
                catch (Exception ex2) {
                    logger.error((Object)"releaseDBSystemTempTable Error:", (Throwable)ex2);
                }
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        try {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTableName);
        }
        catch (Exception exception) {
            logger.error((Object)"releaseDBSystemTempTable Error:", (Throwable)exception);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    protected String getDeleteTmpTableSql() {
        return "Create Table TEML_KSQL_0 (FBgDataID VARCHAR(44) DEFAULT '' NOT NULL)";
    }

    protected String getInsertTmpTableSql(String tmpTableName) {
        return "Insert Into " + tmpTableName + " (FBgDataID) values (?)";
    }

    protected String getDeleteSql(String tmpTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete " + this.getFacade().getDataHelper().getBgSchemeInfo().getRefCube() + " where FID IN (select FBgDataID from " + tmpTableName + ") and FValue <> FTmpValue and FState = " + 1);
        return sql.toString();
    }

    protected String getUpdataTmpValueSql(String tmpTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("update " + this.getFacade().getDataHelper().getBgSchemeInfo().getRefCube() + " Set FTmpValue = FValue where FID IN (select FBgDataID from " + tmpTableName + ") and FValue <> FTmpValue");
        return sql.toString();
    }

    protected String getDeleteTmpSql(String tmpTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete T_MBG_BgTmpData where FID IN (select FBgDataID from " + tmpTableName + ")");
        return sql.toString();
    }

    protected String getDeleteTmpEntrySql(String tmpTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete T_MBG_BgTmpDataEntry where FDataID IN (select FBgDataID from " + tmpTableName + ")");
        return sql.toString();
    }
}

