/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BgAdjustHelper {
    public static void dealViewManagerMap(Context ctx, boolean isOrgOnPageOrView, int curSheetIndex, Map result, MbgViewListManager curViewManager, String bgOrgViewId, Map<String, BgFormInfo> successAddBgForms, Map<String, OrgUnitInfo> layoutDiff) throws BOSException, EASBizException {
        if (!successAddBgForms.isEmpty()) {
            HashMap<String, MbgViewListManager> successFromViews = new HashMap<String, MbgViewListManager>();
            IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
            HashSet<String> addOrgNumbers = new HashSet<String>(successAddBgForms.keySet());
            for (String orgNumber : addOrgNumbers) {
                if (!iBgForm.exists((IObjectPK)new ObjectUuidPK(successAddBgForms.get(orgNumber).getId()))) continue;
                BgFormInfo _bgForm = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(successAddBgForms.get(orgNumber).getId()), BgFormInfo.getFormSelector2());
                MbgViewListManager viewManager = (MbgViewListManager)DimensionCommonHelper.getBgFormView(ctx, _bgForm);
                if (DimensionCommonHelper.isDifference(curViewManager, viewManager, curSheetIndex)) {
                    layoutDiff.put(orgNumber, (OrgUnitInfo)_bgForm.getOrgUnit());
                    successAddBgForms.remove(orgNumber);
                    continue;
                }
                Map otherMap = BgAdjustHelper.getInitBgViewDimensionInfo(ctx, viewManager, _bgForm.getId().toString(), bgOrgViewId, _bgForm.getOrgUnit().getId().toString(), false, false);
                BgViewHelper.additionalForViewListManager(ctx, _bgForm, otherMap, viewManager);
                successFromViews.put(orgNumber, viewManager);
            }
            result.put(MbgViewListDescriptionHelper.successFromViews, successFromViews);
        }
    }

    public static EntityViewInfo getOrgView(String bgOrgViewId, Set<String> bgOrgLongNums) {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("orgUnitID"));
        view.getSelector().add(new SelectorItemInfo("viewID"));
        view.getSelector().add(new SelectorItemInfo("isVirtual"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", bgOrgLongNums, CompareType.INCLUDE));
        return view;
    }

    public static Map<String, OrgUnitInfo> getOrgMap(Context ctx, Set orgUnitNumbers) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)orgUnitNumbers, CompareType.INCLUDE));
        CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        for (int i = 0; i < col.size(); ++i) {
            orgMap.put(col.get(i).getId().toString(), (OrgUnitInfo)col.get(i));
        }
        return orgMap;
    }

    public static Map<String, BgFormInfo> getBgFormMap(Context ctx, Connection conn, BgFormInfo bgForm, boolean isContainNoForm) throws BOSException {
        return BgAdjustHelper.getBgFormMap(ctx, conn, bgForm, isContainNoForm, null, true, false);
    }

    public static Map<String, BgFormInfo> getBgFormMap(Context ctx, Connection conn, BgFormInfo bgForm, boolean isContainNoForm, String bgOrgViewId, boolean isContainSealUp, boolean isRoll) throws BOSException {
        if (bgForm == null) {
            return null;
        }
        HashMap<String, BgFormInfo> bgForms = new HashMap<String, BgFormInfo>();
        HashSet<String> fullOrgIds = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            StringBuffer sql = MbgViewListFormServerHelper.getQuerySQL(ctx);
            sql.append(" and bgForm.FBgTemplateId = bgTemplate.FID and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId =? and bgForm.FBgVersionId = ? and bgForm.FProcessType = ?");
            sql.append(" and bgForm.FState <> 15");
            if (!isContainNoForm) {
                sql.append(" and bgForm.FID is not null ");
            }
            sql.append(" where bgScheme.FId = ? ");
            sql.append(" and bgTemplate.FID = ? ");
            if (bgOrgViewId != null) {
                sql.append(" and bgOrgUnit.FViewId = ?");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgForm.getBgPeriod().getId().toString());
            pstmt.setString(2, bgForm.getCurrency().getId().toString());
            pstmt.setString(3, bgForm.getBgVersion().getId().toString());
            pstmt.setInt(4, bgForm.getProcessType().getValue());
            pstmt.setString(5, bgForm.getBgScheme().getId().toString());
            pstmt.setString(6, bgForm.getBgTemplate().getId().toString());
            if (bgOrgViewId != null) {
                pstmt.setString(7, bgOrgViewId);
            }
            res = pstmt.executeQuery();
            while (res.next()) {
                BgFormInfo b = MbgViewListFormServerHelper.buildBgFormInfo(res);
                bgForms.put(b.getOrgUnit().getId().toString(), b);
                fullOrgIds.add(b.getOrgUnit().getId().toString());
            }
            SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
            BgAdjustHelper.reFilterSealUp(ctx, bgForms, fullOrgIds, bgOrgViewId, isContainSealUp);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        return bgForms;
    }

    public static void reFilterSealUp(Context ctx, Map<String, BgFormInfo> bgForms, Set<String> fullOrgIds, String bgOrgViewId, boolean isContainSealUp) throws BOSException {
        if (!(fullOrgIds.isEmpty() || StringUtils.isEmpty((String)bgOrgViewId) || isContainSealUp)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("isOUSealUp"));
            view.getSelector().add(new SelectorItemInfo("orgUnitID"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", fullOrgIds, CompareType.INCLUDE));
            BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
            if (colls != null && !colls.isEmpty()) {
                BgOrgUnitInfo orgUnitInfo = null;
                int size = colls.size();
                for (int i = 0; i < size; ++i) {
                    orgUnitInfo = colls.get(i);
                    if (!orgUnitInfo.isIsOUSealUp() || !bgForms.containsKey(orgUnitInfo.getOrgUnitID())) continue;
                    bgForms.remove(orgUnitInfo.getOrgUnitID());
                }
            }
        }
    }

    public static Map getInitBgViewDimensionInfo(Context ctx, MbgViewListManager viewListManager, String bgFormId, String orgViewId, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        if (viewListManager == null || StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        BgFormInfo bgForm = MbgViewListFormServerHelper.queryBgFormInfo(ctx, bgFormId);
        if (bgForm == null) {
            return null;
        }
        HashMap<String, Map<Object, Object>> resMap = new HashMap<String, Map<Object, Object>>();
        HashMap periodMap = new HashMap();
        Map tempMap = null;
        for (int s = 0; s < viewListManager.getSheetManagers().size(); ++s) {
            tempMap = BgViewServerHelper.queryBgViewBgPeriod(ctx, ((MbgViewListSheetManager)viewListManager.getSheetManagers().get(s)).getDimensionManager(), bgForm, null);
            if (tempMap == null) continue;
            periodMap.putAll(tempMap);
        }
        resMap.put("BGPERIOD", periodMap);
        resMap.put("ORGUNIT", BgViewServerHelper.queryBgViewOrgUnit(ctx, null, bgForm, orgViewId, false, isOnlyCurrOrg, currOrgId, isOnlyLeaf, null));
        return resMap;
    }

    public static Map<String, String> getOrgIdAndFormIdForApproved(Connection connection, Context ctx, BgFormInfo bgForm, Set orgIdSet) throws EASBizException, BOSException {
        HashMap<String, String> orgIdFormIdMap = new HashMap<String, String>();
        if (connection == null || ctx == null) {
            return orgIdFormIdMap;
        }
        PreparedStatement pstmt = null;
        ResultSet res = null;
        TempTablePool pool = null;
        String tmpTableName = null;
        try {
            if (bgForm != null && orgIdSet != null && !orgIdSet.isEmpty()) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), (Collection)orgIdSet);
                pstmt = BgAdjustHelper.getPrmt(connection, tmpTableName, bgForm);
                res = pstmt.executeQuery();
                while (res.next()) {
                    if (StringUtils.isEmpty((String)res.getString("FOrgUnitID")) || StringUtils.isEmpty((String)res.getString("bgformId"))) continue;
                    orgIdFormIdMap.put(res.getString("FOrgUnitID"), res.getString("bgformId"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTableName != null) {
                BgDBUtils.releaseTmpTable(pool, tmpTableName);
            }
            SQLUtils.cleanup(res, pstmt, (Connection)connection);
        }
        return orgIdFormIdMap;
    }

    private static PreparedStatement getPrmt(Connection connection, String tmpTableName, BgFormInfo bgForm) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bgForm.FAdjustID bgformId , FOrgUnitID , FState ");
        sql.append("FROM T_MBg_bgform bgForm , ").append(tmpTableName).append(" tmp ");
        sql.append(" WHERE tmp.FID = bgForm.FOrgUnitID ");
        sql.append(" AND bgForm.FState <> ").append(15);
        sql.append(" AND bgForm.Fid = bgForm.FAdjustID ");
        sql.append(" AND bgForm.FBgPeriodId = ? ");
        sql.append(" AND bgForm.FCurrencyId = ? ");
        sql.append(" AND bgForm.FBgVersionId = ? ");
        sql.append(" AND bgForm.FProcessType = ? ");
        sql.append(" AND bgForm.FBgSchemeID = ? ");
        sql.append(" AND bgForm.FBgTemplateID = ? ");
        PreparedStatement pstmt = connection.prepareStatement(sql.toString());
        pstmt.setString(1, bgForm.getBgPeriod().getId().toString());
        pstmt.setString(2, bgForm.getCurrency().getId().toString());
        pstmt.setString(3, bgForm.getBgVersion().getId().toString());
        pstmt.setInt(4, bgForm.getProcessType().getValue());
        pstmt.setString(5, bgForm.getBgScheme().getId().toString());
        pstmt.setString(6, bgForm.getBgTemplate().getId().toString());
        return pstmt;
    }

    public static Map<String, String> getOrgFormIdMap(Connection connection, Context ctx, BgFormInfo bgForm, Set orgIdSet) throws EASBizException, BOSException {
        HashMap<String, String> orgIdFormIdMap = new HashMap<String, String>();
        if (connection == null || ctx == null) {
            return orgIdFormIdMap;
        }
        PreparedStatement pstmt = null;
        ResultSet res = null;
        TempTablePool pool = null;
        String tmpTableName = null;
        try {
            if (bgForm != null && orgIdSet != null && !orgIdSet.isEmpty()) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), (Collection)orgIdSet);
                pstmt = BgAdjustHelper.getPrmtForBgform(connection, tmpTableName, bgForm);
                res = pstmt.executeQuery();
                while (res.next()) {
                    if (StringUtils.isEmpty((String)res.getString("FOrgUnitID")) || StringUtils.isEmpty((String)res.getString("bgformId"))) continue;
                    orgIdFormIdMap.put(res.getString("FOrgUnitID"), res.getString("bgformId"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTableName != null) {
                BgDBUtils.releaseTmpTable(pool, tmpTableName);
            }
            SQLUtils.cleanup(res, pstmt, (Connection)connection);
        }
        return orgIdFormIdMap;
    }

    public static Map<String, String> getOrgAndFormIdAdjustBillIdMap(Connection connection, Context ctx, String bgFormId, Set orgIdSet) throws EASBizException, BOSException {
        HashMap<String, String> orgIdFormIdMap = new HashMap<String, String>();
        if (connection == null || ctx == null) {
            return orgIdFormIdMap;
        }
        PreparedStatement pstmt = null;
        ResultSet res = null;
        TempTablePool pool = null;
        String tmpTableName = null;
        try {
            if (!StringUtils.isEmpty((String)bgFormId) && orgIdSet != null && !orgIdSet.isEmpty()) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), (Collection)orgIdSet);
                BgFormInfo bgForm = MbgViewListFormServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormId), false);
                pstmt = BgAdjustHelper.getPrmtForBgformAndAdjustBill(connection, tmpTableName, bgForm);
                res = pstmt.executeQuery();
                while (res.next()) {
                    if (StringUtils.isEmpty((String)res.getString("orgId")) || StringUtils.isEmpty((String)res.getString("bgformId"))) continue;
                    orgIdFormIdMap.put(res.getString("orgId"), res.getString("bgformId"));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTableName != null) {
                BgDBUtils.releaseTmpTable(pool, tmpTableName);
            }
            SQLUtils.cleanup(res, pstmt, (Connection)connection);
        }
        return orgIdFormIdMap;
    }

    public static Map<String, BgFormStateEnum> getOrgFormStateMap(Connection connection, Context ctx, String bgFormId, Set orgIdSet) throws EASBizException, BOSException {
        HashMap<String, BgFormStateEnum> orgIdFormStateMap = new HashMap<String, BgFormStateEnum>();
        if (connection == null || ctx == null) {
            return orgIdFormStateMap;
        }
        PreparedStatement pstmt = null;
        ResultSet res = null;
        TempTablePool pool = null;
        String tmpTableName = null;
        try {
            if (!StringUtils.isEmpty((String)bgFormId) && orgIdSet != null && !orgIdSet.isEmpty()) {
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableName = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)connection, (String)("Insert Into " + tmpTableName + " (FID) values (?)"), (Collection)orgIdSet);
                BgFormInfo bgForm = MbgViewListFormServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormId), false);
                pstmt = BgAdjustHelper.getPrmtForBgform(connection, tmpTableName, bgForm);
                res = pstmt.executeQuery();
                while (res.next()) {
                    if (StringUtils.isEmpty((String)res.getString("FOrgUnitID")) || StringUtils.isEmpty((String)res.getString("bgformId"))) continue;
                    orgIdFormStateMap.put(res.getString("FOrgUnitID"), BgFormStateEnum.getEnum(res.getInt("FState")));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpTableName != null) {
                BgDBUtils.releaseTmpTable(pool, tmpTableName);
            }
            SQLUtils.cleanup(res, pstmt, (Connection)connection);
        }
        return orgIdFormStateMap;
    }

    private static PreparedStatement getPrmtForBgform(Connection connection, String tmpTableName, BgFormInfo bgForm) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bgForm.FAdjustID bgformId , FOrgUnitID , FState ");
        sql.append("FROM T_MBg_bgform bgForm , ").append(tmpTableName).append(" tmp ");
        sql.append(" WHERE tmp.FID = bgForm.FOrgUnitID ");
        sql.append(" AND bgForm.FState <> ").append(15);
        sql.append(" AND bgForm.FBgPeriodId = ? ");
        sql.append(" AND bgForm.FCurrencyId = ? ");
        sql.append(" AND bgForm.FBgVersionId = ? ");
        sql.append(" AND bgForm.FProcessType = ? ");
        sql.append(" AND bgForm.FBgSchemeID = ? ");
        sql.append(" AND bgForm.FBgTemplateID = ? ");
        sql.append(" order by bgForm.FLASTUPDATETIME ");
        PreparedStatement pstmt = connection.prepareStatement(sql.toString());
        pstmt.setString(1, bgForm.getBgPeriod().getId().toString());
        pstmt.setString(2, bgForm.getCurrency().getId().toString());
        pstmt.setString(3, bgForm.getBgVersion().getId().toString());
        pstmt.setInt(4, bgForm.getProcessType().getValue());
        pstmt.setString(5, bgForm.getBgScheme().getId().toString());
        pstmt.setString(6, bgForm.getBgTemplate().getId().toString());
        return pstmt;
    }

    private static PreparedStatement getPrmtForBgformAndAdjustBill(Connection connection, String tmpTableName, BgFormInfo bgForm) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT bgForm.FAdjustID bgformId , FOrgUnitID ");
        sql.append("FROM T_MBg_bgform bgForm , ").append(tmpTableName).append(" tmp ");
        sql.append(" WHERE tmp.FID = bgForm.FOrgUnitID ");
        sql.append(" AND bgForm.FState <> ").append(15);
        sql.append(" AND bgForm.Fid <> bgForm.FAdjustID ");
        sql.append(" AND bgForm.FBgPeriodId = ? ");
        sql.append(" AND bgForm.FCurrencyId = ? ");
        sql.append(" AND bgForm.FBgVersionId = ? ");
        sql.append(" AND bgForm.FProcessType = ? ");
        sql.append(" AND bgForm.FBgSchemeID = ? ");
        sql.append(" AND bgForm.FBgTemplateID = ? ");
        sql.append(" union all ");
        sql.append("SELECT b.FID bgformId, en.FOrgUnit orgId FROM T_MBG_BgAdjustBill b, T_MBG_BgAdjustBillEntry en, ").append(tmpTableName).append(" tmp ");
        sql.append(" where b.FID = en.FBgAdjustBill AND tmp.FID = en.FOrgUnit ");
        sql.append(" AND b.FBgScheme = ? ");
        sql.append(" AND b.FCurrency = ? ");
        sql.append(" AND b.FBgVersionID  = ? ");
        sql.append(" AND en.FPeriod = ? ");
        PreparedStatement pstmt = connection.prepareStatement(sql.toString());
        pstmt.setString(1, bgForm.getBgPeriod().getId().toString());
        pstmt.setString(2, bgForm.getCurrency().getId().toString());
        pstmt.setString(3, bgForm.getBgVersion().getId().toString());
        pstmt.setInt(4, bgForm.getProcessType().getValue());
        pstmt.setString(5, bgForm.getBgScheme().getId().toString());
        pstmt.setString(6, bgForm.getBgTemplate().getId().toString());
        pstmt.setString(7, bgForm.getBgScheme().getId().toString());
        pstmt.setString(8, bgForm.getCurrency().getId().toString());
        pstmt.setString(9, bgForm.getBgVersion().getId().toString());
        pstmt.setString(10, bgForm.getBgPeriod().getId().toString());
        return pstmt;
    }
}

