/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class BgClosureMapUtils {
    private BgSchemeInfo schemeInfo = null;
    Map<String, Set<String>> closureMap = null;
    private boolean isContainsSelf = true;

    public Map<String, Set<String>> getClosureMap() {
        return this.closureMap;
    }

    public boolean isContainsSelf() {
        return this.isContainsSelf;
    }

    public void setContainsSelf(boolean isContainsSelf) {
        this.isContainsSelf = isContainsSelf;
    }

    public BgClosureMapUtils(BgSchemeInfo schemeInfo, Connection conn) throws Exception {
        this.schemeInfo = schemeInfo;
        this.buildClosureMap(conn);
    }

    private void buildClosureMap(Connection conn) throws Exception {
        List<BOSUuid> bgPeriodViewIds = this.schemeInfo.getBgPeriodViewIds();
        if (bgPeriodViewIds == null || bgPeriodViewIds.isEmpty()) {
            return;
        }
        if (this.closureMap == null) {
            this.closureMap = new HashMap<String, Set<String>>();
        }
        ResultSet rst = null;
        PreparedStatement prepareStatement = null;
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuilder sql = new StringBuilder();
            sql.append(" select d.FlongNumber,p.Fnumber from T_MBG_BGPERIOD p, T_MBG_BGPERIODDisp d ");
            sql.append(" where d.FBgPeriodId = p.FId  and d.FTypeId IN ");
            sql.append(" (" + BgClosureMapUtils.getSqlParam(bgPeriodViewIds.size()) + ") ");
            sql.append(" and (p.FBeginDate <= {ts'" + format.format(this.schemeInfo.getDateTo()) + "'} and p.FEndDate >= {ts'" + format.format(this.schemeInfo.getDateFrom()) + "'}) ");
            sql.append(" order by p.FlongNumber");
            prepareStatement = conn.prepareStatement(sql.toString());
            for (int i = 0; i < bgPeriodViewIds.size(); ++i) {
                BOSUuid bosUuid = bgPeriodViewIds.get(i);
                prepareStatement.setString(i + 1, bosUuid.toString());
            }
            rst = prepareStatement.executeQuery();
            TreeMap<String, String> tree = new TreeMap<String, String>();
            while (rst.next()) {
                tree.put(rst.getString("FlongNumber"), rst.getString("Fnumber"));
            }
            String curKey = null;
            String curValue = null;
            SortedMap tailMap = null;
            for (Map.Entry entry : tree.entrySet()) {
                curKey = (String)entry.getKey();
                curValue = (String)entry.getValue();
                if (!this.closureMap.containsKey(curValue)) {
                    this.closureMap.put(curValue, new LinkedHashSet());
                }
                tailMap = tree.tailMap(curKey);
                for (String childKey : tailMap.keySet()) {
                    if (!childKey.startsWith(curKey)) break;
                    if (this.isContainsSelf()) {
                        this.closureMap.get(curValue).add((String)tailMap.get(childKey));
                        continue;
                    }
                    if (curValue.equals(childKey)) continue;
                    this.closureMap.get(curValue).add((String)tailMap.get(childKey));
                }
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup(prepareStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)prepareStatement);
    }

    public static String getSqlParam(int paramSize) {
        StringBuffer params = new StringBuffer();
        int in = paramSize;
        for (int i = 1; i < in; ++i) {
            params.append("?,");
        }
        params.append("?");
        return params.toString();
    }
}

