/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgBizFacade;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDataAddnewImpl
extends BgBizFacade {
    private static final Logger logger = Logger.getLogger(BgDataAddnewImpl.class);
    private int versionInnId = 0;
    private Map<String, String> valueMap = new HashMap<String, String>();
    private int fixParam = 17;

    public static synchronized BgDataAddnewImpl getInstance(AbstractDataFacadeImpl facade) {
        return new BgDataAddnewImpl(facade);
    }

    public BgDataAddnewImpl(AbstractDataFacadeImpl facade) {
        super(facade);
    }

    public void setVersionInnId(int versionInnId) {
        this.versionInnId = versionInnId;
    }

    public int getVersionInnId() {
        return this.versionInnId;
    }

    public void addnew(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null || this.getFacade() == null || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        if (BgDBUtils.isMSSQL((Context)ctx)) {
            this.addNewValueBySql(ctx, valueMap);
        } else {
            this.addNewValueByDefault(ctx, valueMap);
        }
    }

    protected void addNewValueByDefault(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null || valueMap == null) {
            return;
        }
        BgDataParam bgDataParam = this.getBgDataParam(ctx, valueMap);
        this.addNewBgDataValue(ctx, null, bgDataParam);
    }

    protected void addNewValueBySql(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null || valueMap == null) {
            return;
        }
        Connection conn = null;
        TempTablePool pool = null;
        BgDataParam bgDataParam = new BgDataParam();
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            this.createTmpTableName(pool, conn, bgDataParam);
            if (bgDataParam.getTableName() != null && bgDataParam.getEntryName() != null) {
                bgDataParam = this.getBgDataParam(ctx, valueMap, bgDataParam);
                this.addNewBgDataValue(ctx, conn, bgDataParam);
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + this.getCubeName() + " (" + bgDataParam.getSqlFields() + ") Select " + bgDataParam.getSqlFields() + " from " + bgDataParam.getTableName()));
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + this.getEntryName() + " (FFormID, FDataID) Select FFormID, FDataID from " + bgDataParam.getEntryName()));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"addNewValueBySql Error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            try {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgDataParam.getEntryName());
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)bgDataParam.getTableName());
            }
            catch (Exception exception) {}
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void createTmpTableName(TempTablePool pool, Connection conn, BgDataParam bgDataParam) throws Exception {
        if (pool == null || conn == null || bgDataParam == null) {
            return;
        }
        String tmpStr = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlFields = new StringBuffer();
        sql.append("Create Table TEML_KSQL_0 (FID VARCHAR(44) DEFAULT '' NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
        sqlFields.append("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, ");
        List<String> dims = BgCubeUtils.getRefDims(this.getFacade().getCtx(), this.getFacade().getDataHelper().getBgSchemeInfo(), false);
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            tmpStr = dims.get(i);
            if (DimensionConstants.DEF_BGINDEX_FIELD.equals(tmpStr)) {
                sql.append(tmpStr + " NVARCHAR(84) DEFAULT '' NOT NULL, ");
            } else {
                sql.append(tmpStr + " NVARCHAR(84), ");
            }
            sqlFields.append(tmpStr + ",");
        }
        sql.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL)");
        sqlFields.append("FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState");
        bgDataParam.setTableName(BgDBUtils.createTmpTable((Context)this.getFacade().getCtx(), (TempTablePool)pool, (String)sql.toString()));
        bgDataParam.setSqlFields(sqlFields.toString());
        sql = new StringBuffer();
        sql.append("Create Table TEML_KSQL_1 (FFormID VARCHAR(44) DEFAULT '' NOT NULL, FDataID VARCHAR(44) DEFAULT '' NOT NULL)");
        bgDataParam.setEntryName(BgDBUtils.createTmpTable((Context)this.getFacade().getCtx(), (TempTablePool)pool, (String)sql.toString()));
    }

    protected BgDataParam getBgDataParam(Context ctx, Map<String, IBgNData> dataMap) throws BOSException, EASBizException {
        return this.getBgDataParam(ctx, dataMap, null);
    }

    protected BgDataParam getBgDataParam(Context ctx, Map<String, IBgNData> dataMap, BgDataParam dataParam) throws BOSException, EASBizException {
        if (ctx == null || dataMap == null) {
            return null;
        }
        Object var4_4 = null;
        ArrayList<String> _bgPeriod = new ArrayList<String>();
        ArrayList<String> _bgElement = new ArrayList<String>();
        ArrayList<String> _currency = new ArrayList<String>();
        for (BgNDataInfo bgNDataInfo : dataMap.values()) {
            _bgPeriod.add(bgNDataInfo.getBgPeriodNumber());
            _bgElement.add(bgNDataInfo.getBgElementNumber());
            _currency.add(bgNDataInfo.getCurrencyNumber());
        }
        Map<String, BgPeriodInfo> bgPeriodMap = BgViewServerHelper.getBgPeriodMap(ctx, _bgPeriod);
        Map<String, BgElementInfo> bgElementMap = BgViewServerHelper.getBgElementMap(ctx, _bgElement);
        Map<String, CurrencyInfo> currencyMap = BgViewServerHelper.getCurrencyMap(ctx, _currency);
        Map scenarioMap = BgScenarioHelper.getScenariooObjMap((Context)ctx);
        BgSchemeDimensionHelper schemehelper = new BgSchemeDimensionHelper(this.getFacade().getCtx(), this.getFacade().getDataHelper().getBgSchemeInfo().getId().toString());
        List<String> dimRefs = schemehelper.getRefDims();
        if (dataParam == null) {
            dataParam = new BgDataParam();
        }
        dataParam.setBgSchemeId(this.getFacade().getDataHelper().getBgSchemeInfo().getId().toString());
        dataParam.setBgPeriodMap(bgPeriodMap);
        dataParam.setBgElementMap(bgElementMap);
        dataParam.setCurrencyMap(currencyMap);
        dataParam.setScenarioMap(scenarioMap);
        dataParam.setSqls(this.getAddnewDataSql(dimRefs, dataParam));
        dataParam.setRefDims(dimRefs);
        dataParam.setDataMap(dataMap);
        return dataParam;
    }

    protected String[] getAddnewDataSql(List<String> dimRefs, BgDataParam dataParam) {
        int i;
        if (dimRefs == null || dimRefs.isEmpty()) {
            return null;
        }
        String tableName = this.getCubeName();
        if (dataParam.getTableName() != null) {
            tableName = dataParam.getTableName();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState");
        int in = dimRefs.size();
        for (i = 0; i < in; ++i) {
            sql.append("," + dimRefs.get(i));
        }
        sql.append(") Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        in = dimRefs.size();
        for (i = 0; i < in; ++i) {
            sql.append(",?");
        }
        sql.append(")");
        String entryName = this.getEntryName();
        if (dataParam.getEntryName() != null) {
            entryName = dataParam.getEntryName();
        }
        String[] sqls = new String[]{sql.toString(), "Insert Into " + entryName + " (FFormID, FDataID) values (?,?)"};
        return sqls;
    }

    private void addNewBgDataValue(Context ctx, Connection conn, BgDataParam bgDataParam) throws BOSException, EASBizException {
        if (ctx == null || bgDataParam == null || bgDataParam.check()) {
            return;
        }
        IObjectValue model = this.getFacade().getDataHelper().getModel();
        Object var5_5 = null;
        int batchSize = 100;
        int batchIndex = 0;
        BOSObjectType type = new BgDataInfo().getBOSType();
        String _billId = this.getFacade().getBillId(model).toString();
        BOSUuid orgUnitId = this.getFacade().getOrgUnitId(model);
        String _orgUnitId = orgUnitId != null ? orgUnitId.toString() : null;
        String _userId = this.getFacade().getUserId(model).toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        this.setVersionInnId(this.getFacade().getVersionIntId(model));
        if (this.getVersionInnId() < 0) {
            throw new BOSException("no found bgversion!");
        }
        String srcStr22 = null;
        String[] tmpStrs = null;
        String[] tmpSrc = null;
        Map<String, String> srcFields = DimUtils.getDimSourceMap(ctx);
        Connection _conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstent = null;
        try {
            if (conn == null) {
                _conn = BgDBUtils.getConnection((Context)ctx);
                pstmt = _conn.prepareStatement(bgDataParam.getSqls()[0]);
                pstent = _conn.prepareStatement(bgDataParam.getSqls()[1]);
            } else {
                pstmt = conn.prepareStatement(bgDataParam.getSqls()[0]);
                pstent = conn.prepareStatement(bgDataParam.getSqls()[1]);
            }
            for (BgNDataInfo bgNDataInfo : bgDataParam.getDataMap().values()) {
                this.getValueMap().clear();
                tmpStrs = bgNDataInfo.getBgItemNumber().split(",");
                if (tmpStrs != null) {
                    for (String srcStr22 : tmpStrs) {
                        tmpSrc = srcStr22.split(":");
                        if (!srcFields.containsKey(tmpSrc[0])) continue;
                        this.getValueMap().put(srcFields.get(tmpSrc[0]), srcStr22);
                    }
                }
                if (bgNDataInfo.getBgDataId() == null) {
                    bgNDataInfo.setBgDataId(BOSUuid.create((BOSObjectType)type).toString());
                }
                this.setSqlData(pstmt, bgDataParam, bgNDataInfo, _orgUnitId, _userId, _time);
                pstent.setString(1, _billId);
                pstent.setString(2, bgNDataInfo.getBgDataId());
                pstent.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                pstent.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
                pstent.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"data addNew:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstent);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)_conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstent);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)_conn);
    }

    protected void setSqlData(PreparedStatement pstmt, BgDataParam bgDataParam, BgNDataInfo bgData, String orgUnitId, String userId, Timestamp time) throws SQLException, EASBizException {
        if (pstmt == null || bgData == null) {
            return;
        }
        this.beforeSqlData(pstmt, bgDataParam, bgData);
        pstmt.setString(1, bgData.getBgDataId());
        pstmt.setString(2, userId);
        pstmt.setTimestamp(3, time);
        pstmt.setString(4, userId);
        pstmt.setTimestamp(5, time);
        pstmt.setString(6, orgUnitId);
        pstmt.setString(7, bgData.getFormula());
        BigDecimal _value = this.getFacade().getValue(bgData).setScale(8, 4);
        pstmt.setBigDecimal(8, _value);
        pstmt.setBigDecimal(9, _value);
        String _itemId = bgData.getBgItemNumber();
        if (_itemId == null) {
            this.exceptionItem(bgData);
        } else {
            pstmt.setString(10, _itemId);
        }
        BgPeriodInfo bgPeriodInfo = bgDataParam.getBgPeriodMap().get(bgData.getBgPeriodNumber());
        if (bgPeriodInfo == null) {
            this.exceptionPeriod(bgData);
        } else {
            pstmt.setString(11, bgPeriodInfo.getString(bgPeriodInfo.getPKField()));
        }
        BgElementInfo bgElementInfo = bgDataParam.getBgElementMap().get(bgData.getBgElementNumber());
        if (bgElementInfo == null) {
            this.exceptionElement(bgData);
        } else {
            pstmt.setString(12, bgElementInfo.getString(bgElementInfo.getPKField()));
        }
        CurrencyInfo currencyInfo = bgDataParam.getCurrencyMap().get(bgData.getCurrencyNumber());
        if (currencyInfo == null) {
            this.exceptionCurrency(bgData);
        } else {
            pstmt.setString(13, currencyInfo.getString(currencyInfo.getPKField()));
        }
        BgScenarioInfo scenario = bgDataParam.getScenarioMap().get(bgData.getBgScenario());
        if (scenario == null) {
            this.exceptionScenario(bgData);
        } else {
            pstmt.setInt(14, scenario.getScenarioId());
        }
        pstmt.setInt(15, this.getVersionInnId());
        pstmt.setInt(16, this.getState());
        String dimStr = null;
        int in = bgDataParam.getRefDims().size();
        for (int i = 0; i < in; ++i) {
            dimStr = bgDataParam.getRefDims().get(i);
            if (this.getValueMap().containsKey(dimStr)) {
                pstmt.setString(this.getFaramIndex() + i, this.getValueMap().get(dimStr));
                continue;
            }
            pstmt.setString(this.getFaramIndex() + i, null);
        }
        this.afterSqlData(pstmt, bgDataParam, bgData);
        pstmt.addBatch();
    }

    protected void beforeSqlData(PreparedStatement pstmt, BgDataParam bgDataParam, BgNDataInfo bgData) throws SQLException {
    }

    protected void afterSqlData(PreparedStatement pstmt, BgDataParam bgDataParam, BgNDataInfo bgData) throws SQLException {
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    protected int getFaramIndex() {
        return this.fixParam;
    }

    protected int getState() {
        return 1;
    }

    protected void exceptionCurrency(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("currency number error:" + bgData.getCurrencyNumber()));
        throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{bgData.getCurrencyNumber()});
    }

    protected void exceptionElement(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgElement number error:" + bgData.getBgElementNumber()));
        throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{bgData.getBgElementNumber()});
    }

    protected void exceptionItem(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgItem number error:" + bgData.getBgItemNumber()));
        throw new BgFormException(BgFormException.SUBMITNOITEM, new String[]{bgData.getBgItemNumber()});
    }

    protected void exceptionPeriod(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgPeriod number error:" + bgData.getBgPeriodNumber()));
        throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{bgData.getBgPeriodNumber()});
    }

    protected void exceptionScenario(BgNDataInfo bgData) throws EASBizException {
        logger.debug((Object)("bgScenario number error:" + bgData.getBgScenario()));
        throw new BgFormException(BgFormException.SUBMITNOBGSCENARIO, new String[]{bgData.getBgScenario()});
    }

    class BgDataParam {
        private Map<String, BgPeriodInfo> bgPeriodMap = null;
        private Map<String, BgElementInfo> bgElementMap = null;
        private Map<String, CurrencyInfo> currencyMap = null;
        private Map<String, BgScenarioInfo> scenarioMap = null;
        private String tableName = null;
        private String entryName = null;
        private String sqlFields = null;
        private String[] sqls = null;
        private List<String> refDims = null;
        private Map<String, IBgNData> dataMap = null;
        private String bgSchemeId = null;

        BgDataParam() {
        }

        public void setBgSchemeId(String bgSchemeId) {
            this.bgSchemeId = bgSchemeId;
        }

        public String getBgSchemeId() {
            return this.bgSchemeId;
        }

        public void setBgPeriodMap(Map<String, BgPeriodInfo> bgPeriodMap) {
            this.bgPeriodMap = bgPeriodMap;
        }

        public Map<String, BgPeriodInfo> getBgPeriodMap() {
            return this.bgPeriodMap;
        }

        public void setBgElementMap(Map<String, BgElementInfo> bgElementMap) {
            this.bgElementMap = bgElementMap;
        }

        public Map<String, BgElementInfo> getBgElementMap() {
            return this.bgElementMap;
        }

        public void setCurrencyMap(Map<String, CurrencyInfo> currencyMap) {
            this.currencyMap = currencyMap;
        }

        public Map<String, CurrencyInfo> getCurrencyMap() {
            return this.currencyMap;
        }

        public void setScenarioMap(Map<String, BgScenarioInfo> scenarioMap) {
            this.scenarioMap = scenarioMap;
        }

        public Map<String, BgScenarioInfo> getScenarioMap() {
            return this.scenarioMap;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public void setSqlFields(String sqlFields) {
            this.sqlFields = sqlFields;
        }

        public String getSqlFields() {
            return this.sqlFields;
        }

        public void setSqls(String[] sqls) {
            this.sqls = sqls;
        }

        public String[] getSqls() {
            return this.sqls;
        }

        public void setRefDims(List<String> refDims) {
            this.refDims = refDims;
        }

        public List<String> getRefDims() {
            return this.refDims;
        }

        public void setDataMap(Map<String, IBgNData> dataMap) {
            this.dataMap = dataMap;
        }

        public Map<String, IBgNData> getDataMap() {
            return this.dataMap;
        }

        public boolean check() {
            return this.bgPeriodMap == null || this.bgElementMap == null || this.currencyMap == null || this.sqls == null || this.refDims == null || this.dataMap == null || this.dataMap.isEmpty();
        }
    }
}

