/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgDataAssistResultReader;
import com.kingdee.eas.ma.mbg.app.utils.BgDataAssistSqlHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionDescriptionHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgDataAssistHelper {
    private Map<String, Map<String, String>> bgDescriptionMap = new HashMap<String, Map<String, String>>();
    private String bgSchemeRootId;
    private String bgFormId;
    private Context ctx;

    public BgDataAssistHelper(Context ctx, String bgSchemeRootId, String bgFormId) {
        this.bgSchemeRootId = bgSchemeRootId;
        this.bgFormId = bgFormId;
        this.ctx = ctx;
    }

    public void add(String orgId, String formula, String value) {
        BgViewHelper.getSubMap(this.bgDescriptionMap, orgId, true).put(formula, value);
    }

    public Map<String, Map<String, String>> getBgDescriptionMap() {
        return this.bgDescriptionMap;
    }

    public void add(Map<String, Map<String, String>> bgDescriptionMap) {
        if (bgDescriptionMap != null) {
            for (String orgId : bgDescriptionMap.keySet()) {
                Map subMap = BgViewHelper.getSubMap(bgDescriptionMap, orgId, false);
                if (subMap == null) continue;
                BgViewHelper.getSubMap(this.getBgDescriptionMap(), orgId, true).putAll(subMap);
            }
        }
    }

    public void save() throws BOSException {
        Map existsDesc = this.queryBgSchemeDescription();
        this.saveDescription(existsDesc);
    }

    private void saveDescription(Map existsDesc) throws BOSException {
        BgDataAssistSqlHelper sqlHelper = new BgDataAssistSqlHelper(this.ctx, this.bgSchemeRootId, this.bgFormId, this.getBgDescriptionMap().keySet());
        sqlHelper.init();
        HashMap formulaCache = new HashMap();
        for (String orgId : this.getBgDescriptionMap().keySet()) {
            Map<String, String> formulaMap = this.getBgDescriptionMap().get(orgId);
            if (formulaMap == null || formulaMap.isEmpty()) continue;
            Map existSubMap = BgViewHelper.getSubMap(existsDesc, orgId, true);
            for (String formula : formulaMap.keySet()) {
                String value = formulaMap.get(formula);
                String memberNumber = DimensionDescriptionHelper.getMemberNumber(formula, formulaCache);
                String descName = DimensionDescriptionHelper.getDescriptionName(formula, formulaCache);
                if (existSubMap.containsKey(formula)) {
                    if (value != null && value.trim().length() > 0) {
                        sqlHelper.update(orgId, memberNumber, descName, value, (String)existSubMap.get(formula));
                        continue;
                    }
                    sqlHelper.delete(orgId, memberNumber, descName);
                    continue;
                }
                if (value == null || value.trim().length() <= 0) continue;
                sqlHelper.addNew(orgId, memberNumber, descName, value);
            }
        }
        sqlHelper.commit();
    }

    private Map queryBgSchemeDescription() throws BOSException {
        if (!this.getBgDescriptionMap().isEmpty()) {
            BgDataAssistResultReader reader = new BgDataAssistResultReader();
            StringBuffer sql = new StringBuffer();
            sql.append(reader.getSelectSql()).append(" Where FBgRootSchemeId = ? And FOrgUnitId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            Object[] orgIds = this.getBgDescriptionMap().keySet().toArray();
            List paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{this.bgSchemeRootId}, (Object[])orgIds, (int)50);
            MbgSqlHelper.executeBatchQuery((Context)this.ctx, (String)sql.toString(), (List)paramList, (IResultReader)reader);
            return reader.getResult();
        }
        return new HashMap();
    }

    public Map query(Map queryMap) throws BOSException {
        if (queryMap == null || queryMap.isEmpty()) {
            return null;
        }
        HashMap formulaCache = new HashMap();
        BgDataAssistResultReader reader = new BgDataAssistResultReader();
        StringBuffer sql = new StringBuffer();
        sql.append(reader.getSelectSql());
        sql.append(" Where FBgRootSchemeId = ? AND FOrgUnitId = ? AND FColumnName = ? AND FMemberNumber IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        ArrayList paramList = new ArrayList();
        Object[] commonParam = new Object[3];
        commonParam[0] = this.bgSchemeRootId;
        HashMap tempMap = new HashMap();
        for (String orgId : queryMap.keySet()) {
            commonParam[1] = orgId;
            Map subMap = (Map)queryMap.get(orgId);
            if (subMap == null || subMap.isEmpty()) continue;
            tempMap.clear();
            for (String formula : subMap.keySet()) {
                String columnName = DimensionDescriptionHelper.getDescriptionName(formula, formulaCache);
                String memberNumber = DimensionDescriptionHelper.getMemberNumber(formula, formulaCache);
                BgViewHelper.getSubMap(tempMap, columnName, true).put(memberNumber, null);
            }
            for (String columnName : tempMap.keySet()) {
                commonParam[2] = columnName;
                Object[] members = BgViewHelper.getSubMap(tempMap, columnName, false).keySet().toArray();
                paramList.addAll(MbgSqlHelper.getBatchParams((Object[])commonParam, (Object[])members, (int)50));
            }
        }
        MbgSqlHelper.executeBatchQuery((Context)this.ctx, (String)sql.toString(), paramList, (IResultReader)reader);
        return reader.getResult();
    }

    public static void clearBgDataAssist(Connection conn, BgFormInfo bgFormInfo) throws SQLException, EASBizException {
        if (conn == null || bgFormInfo == null) {
            return;
        }
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete T_MBg_BgDataAssistEntry where FBgFormId = ?", (Object[])new Object[]{bgFormInfo.getId().toString()});
        Object[] objs = new Object[]{bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getBgScheme().getId().toString()};
        BgDBUtils.executeUpdate((Connection)conn, (String)"delete From T_MBg_BgDataAssist Where FOrgUnitId = ? and FBgRootSchemeId = ? and not exists (Select de.fid From T_MBg_BgDataAssistEntry de Where de.fassistid = T_MBg_BgDataAssist.fid)", (Object[])objs);
    }
}

