/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.BgDataAssistEntryInfo;
import com.kingdee.eas.ma.mbg.BgDataAssistInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgDataAssistSqlHelper {
    private static final Logger logger = Logger.getLogger((String)BgDataAssistSqlHelper.class.getName());
    private Context ctx;
    private String bgSchemeRootId;
    private String bgFormId;
    private Set orgIds;
    private static final String bosType = new BgDataAssistInfo().getBOSType().toString();
    private static final String entryBosType = new BgDataAssistEntryInfo().getBOSType().toString();
    private Map bgFormMap = new HashMap();
    private static final String insertSql = "Insert Into T_Mbg_BgDataAssist(FID, FOrgUnitId, FBgSchemeId, FMemberNumber,FColumnName, FValue, FBgRootSchemeId) Values(?,?,?,?,?,?,?)";
    private static final String updateSql = "Update T_Mbg_BgDataAssist Set FValue = ? Where FBgRootSchemeId = ? AND FOrgUnitId = ? AND FMemberNumber = ? AND FColumnName = ?";
    private static final String deleteSql = "Delete T_Mbg_BgDataAssist Where FBgRootSchemeId = ? AND FOrgUnitId = ? AND FMemberNumber = ? AND FColumnName = ?";
    private static final String addEntrySql = "Insert into T_MBG_BgDataAssistEntry(FID, FBgFormId, FAssistId) Select newbosid('" + entryBosType + "'), ?, assistData.Fid From T_MBg_BgDataAssist assistData Where assistData.FBgRootSchemeId = ? AND assistData.FOrgUnitId = ? and assistData.FMemberNumber = ? and assistData.FColumnName = ? And not exists(Select de.fid From T_MBG_BgDataAssistEntry de Where de.FBgFormId = ? and de.FAssistId = assistData.FID)";
    private List<Object[]> insertParams = new ArrayList<Object[]>();
    private List<Object[]> updateParams = new ArrayList<Object[]>();
    private List<Object[]> deleteParams = new ArrayList<Object[]>();
    private List<Object[]> addEntryParams = new ArrayList<Object[]>();

    public BgDataAssistSqlHelper(Context ctx, String bgSchemeRootId, String bgFormId, Set orgIds) {
        this.ctx = ctx;
        this.bgSchemeRootId = bgSchemeRootId;
        this.bgFormId = bgFormId;
        this.orgIds = orgIds;
    }

    public void init() throws BOSException {
        BgFormCollection col = BgFormFactory.getLocalInstance(this.ctx).getBgFormCollection("select id, bgScheme.id, bgTemplate.root.id, currency.id, bgPeriod.id where id = '" + this.bgFormId + "'");
        if (col != null && !col.isEmpty()) {
            this.bgFormMap = BgViewServerHelper.queryBgFormByOrgUnitId(this.ctx, col.get(0), this.orgIds.toArray());
        }
    }

    public void commit() throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)insertSql, this.insertParams);
            MbgSqlHelper.executeBatch((Connection)conn, (String)updateSql, this.updateParams);
            MbgSqlHelper.executeBatch((Connection)conn, (String)addEntrySql, this.addEntryParams);
            StringBuffer sql = new StringBuffer();
            sql.append("Delete From T_MBG_BgDataAssistEntry Where FAssistId IN (Select Fid From T_Mbg_BgDataAssist Where FBgRootSchemeId = ? AND FOrgUnitId = ? and FMemberNumber = ? And FColumnName = ?)");
            DbUtil.executeBatch((Context)this.ctx, (String)sql.toString(), this.deleteParams);
            MbgSqlHelper.executeBatch((Connection)conn, (String)deleteSql, this.deleteParams);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void addNew(String orgId, String memberNumber, String descName, String value) throws BOSException {
        String id = BOSUuid.create((String)bosType).toString();
        BgFormInfo bgFormInfo = (BgFormInfo)this.bgFormMap.get(orgId);
        if (bgFormInfo == null) {
            return;
        }
        Object[] param = new Object[7];
        this.insertParams.add(param);
        param[0] = id;
        param[1] = orgId;
        param[2] = bgFormInfo.getBgScheme().getId().toString();
        param[3] = memberNumber;
        param[4] = descName;
        param[5] = value;
        param[6] = this.bgSchemeRootId;
        this.addEntry(orgId, memberNumber, descName);
    }

    public void addEntry(String orgId, String memberNumber, String descName) {
        BgFormInfo bgFormInfo = (BgFormInfo)this.bgFormMap.get(orgId);
        if (bgFormInfo == null) {
            return;
        }
        Object[] param = new Object[6];
        this.addEntryParams.add(param);
        param[0] = bgFormInfo.getId().toString();
        param[1] = this.bgSchemeRootId;
        param[2] = orgId;
        param[3] = memberNumber;
        param[4] = descName;
        param[5] = bgFormInfo.getId().toString();
    }

    public void update(String orgId, String memberNumber, String descName, String value, String oldValue) throws BOSException {
        this.addEntry(orgId, memberNumber, descName);
        if (StringUtils.equals((String)value, (String)oldValue)) {
            return;
        }
        Object[] param = new Object[5];
        this.updateParams.add(param);
        param[0] = value;
        param[1] = this.bgSchemeRootId;
        param[2] = orgId;
        param[3] = memberNumber;
        param[4] = descName;
    }

    public void delete(String orgId, String memberNumber, String descName) throws BOSException {
        Object[] param = new Object[4];
        this.deleteParams.add(param);
        param[0] = this.bgSchemeRootId;
        param[1] = orgId;
        param[2] = memberNumber;
        param[3] = descName;
    }
}

