/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgBizFacade;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDataDeleteImpl
extends BgBizFacade {
    private static final Logger logger = Logger.getLogger(BgDataDeleteImpl.class);

    public static synchronized BgDataDeleteImpl getInstance(AbstractDataFacadeImpl facade) {
        return new BgDataDeleteImpl(facade);
    }

    public BgDataDeleteImpl(AbstractDataFacadeImpl facade) {
        super(facade);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (this.getFacade() == null) return;
        if (valueMap == null) return;
        if (valueMap.isEmpty()) {
            return;
        }
        int batchSize = 50;
        int batchIndex = 0;
        Object var5_5 = null;
        IObjectValue model = this.getFacade().getDataHelper().getModel();
        String _billId = this.getFacade().getBillId(model).toString();
        ArrayList<String> bgDataIds = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("delete from " + this.getEntryName() + " where FFormID = ? and FDataID = ?");
            for (BgNDataInfo bgNDataInfo : valueMap.values()) {
                bgDataIds.add(bgNDataInfo.getBgDataId());
                pstmt.setString(1, _billId);
                pstmt.setString(2, bgNDataInfo.getBgDataId());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
            HashSet<String> refDataIds = new HashSet<String>();
            int size = bgDataIds.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            StringBuffer sql = new StringBuffer();
            sql.append("select FDataID from " + this.getEntryName() + " where FFormID <> ? and FDataID IN (");
            for (int i = 1; i < batchSize; ++i) {
                sql.append("?,");
            }
            sql.append("?)");
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                pstmt.setString(1, _billId);
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x + 1, (String)bgDataIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x + 1, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    refDataIds.add(rst.getString("FDataID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            batchIndex = 0;
            pstmt = conn.prepareStatement("delete from " + this.getCubeName() + " where FID = ?");
            for (BgNDataInfo bgNDataInfo : valueMap.values()) {
                if (refDataIds.contains(bgNDataInfo.getBgDataId())) continue;
                pstmt.setString(1, bgNDataInfo.getBgDataId());
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"bgData Delete Error:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }
}

