/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgDataInfo;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.app.data.MbgDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgDataHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.IBgDataFacade;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgDataFacadeImpl
implements IBgDataFacade {
    private static final Logger logger = Logger.getLogger(BgDataFacadeImpl.class);
    private BgDataHelper helper = null;
    private Context ctx = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private BgSchemeAccIntHelper accIntHelper = null;
    private Map<BOSUuid, Boolean> checkMap = new HashMap<BOSUuid, Boolean>();
    private Set<String> filterSet = new HashSet<String>();
    private Set<String> versionNums = new HashSet<String>();
    private boolean isDeleteData = true;

    public BgDataFacadeImpl(Context ctx, BgDataHelper helper) {
        this.ctx = ctx;
        this.helper = helper;
    }

    public void setHelper(BgDataHelper helper) {
        this.helper = helper;
    }

    public BgDataHelper getHelper() {
        return this.helper;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        if (this.schemeHelper == null) {
            if (this.helper.getCacheHelper() != null && this.helper.getCacheHelper().getMemberCacheHelper() != null) {
                this.schemeHelper = this.helper.getCacheHelper().getMemberCacheHelper().getSchemeHelper();
            } else {
                try {
                    this.schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.getHelper().getRootSchemeInfo().getId().toString());
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    SysUtil.abort();
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    SysUtil.abort();
                }
            }
        }
        return this.schemeHelper;
    }

    public BgSchemeAccIntHelper getAccIntHelper() {
        if (this.accIntHelper == null) {
            this.accIntHelper = new BgSchemeAccIntHelper(this.ctx, this.schemeHelper, this.getCube());
        }
        return this.accIntHelper;
    }

    private String getCube() {
        if (this.getHelper().isDecompose()) {
            return BgCubeUtils.getCubeName(this.getHelper().getRootSchemeInfo().getRefCube(), this.getHelper().getDataType());
        }
        return this.getHelper().getRootSchemeInfo().getRefCube();
    }

    public Set<String> getCubeName(Set<String> accNumbers) throws BOSException, EASBizException {
        boolean isUseAccInt = this.getAccIntHelper().isUseAccInt();
        return BgSchemeConvertToAccIntUtils.getSplitTablesByAcc(isUseAccInt, this.getCube(), accNumbers, this.getAccIntHelper().getSplitMap());
    }

    private String getCubeEntryName() {
        if (this.getHelper().isDecompose()) {
            return BgCubeUtils.getCubeEntryName(this.getHelper().getRootSchemeInfo().getRefCube(), this.getHelper().getDataType());
        }
        return BgCubeUtils.getBudgetEntryCubeName(this.getCube());
    }

    private List<String> getDimRefs() {
        List<String> dimRefs = this.getSchemeHelper().getRefDims();
        DimUtils.sortFields(dimRefs);
        return dimRefs;
    }

    @Override
    public Object[] compareBgDataInfo(Context ctx, BgFormInfo model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return null;
        }
        BOSUuid bgFormId = model.getId();
        String orgUnitId = model.getOrgUnit().getId().toString();
        String bgShcemeId = model.getBgScheme().getId().toString();
        String bgTemplateId = model.getBgTemplate().getId().toString();
        BgNDataInfo _dataInfo = null;
        BgNDataInfo oldData = null;
        HashSet<String> formulas = new HashSet<String>();
        int in = this.getHelper().getFormulas().size();
        for (int i = 0; i < in; ++i) {
            _dataInfo = (BgNDataInfo)this.getHelper().getFormulas().get(i);
            formulas.add(_dataInfo.getFormula());
        }
        DimensionMemberCheckHelper helper = DimensionMemberCheckHelper.getLocalIntance(ctx, this.helper.getCacheHelper(), orgUnitId, bgTemplateId, this.getSchemeHelper(), formulas, this.getHelper().isDecompose());
        BgProcessEnum processType = model.getProcessType();
        helper = BgProcessEnum.C03.equals((Object)processType) ? DimensionMemberCheckHelper.getLocalIntance(ctx, this.helper.getCacheHelper(), orgUnitId, bgTemplateId, this.getSchemeHelper(), formulas, this.getHelper().isDecompose(), true) : DimensionMemberCheckHelper.getLocalIntance(ctx, this.helper.getCacheHelper(), orgUnitId, bgTemplateId, this.getSchemeHelper(), formulas, this.getHelper().isDecompose());
        HashMap<String, BgNDataInfo> _newInfo = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _updInfo = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _delInfo = new HashMap<String, BgNDataInfo>();
        HashMap<String, BgNDataInfo> _refInfo = new HashMap<String, BgNDataInfo>();
        HashSet<String> _formulas = new HashSet<String>();
        Object[] _objs = new Object[]{_newInfo, _updInfo, _delInfo, _formulas, _refInfo};
        boolean checkRemoveDataZero = BgParamUtils.removeDataSetZero(ctx);
        boolean checkRef = false;
        boolean checkIsInProInst = this.checkIsInProInst(ctx, bgFormId);
        Map<String, IBgNData> _dataMap = this.queryBgFormula(ctx, bgFormId);
        Map<String, IBgNData> _schemeDataMap = this.querySchemeData(ctx, orgUnitId, bgShcemeId, model);
        if (_dataMap != null) {
            String _dimKey = null;
            int in2 = this.getHelper().getFormulas().size();
            for (int i = 0; i < in2; ++i) {
                _dataInfo = (BgNDataInfo)this.getHelper().getFormulas().get(i);
                if (!_dataInfo.isCanSave() || !model.getBgVersion().getNumber().equals(_dataInfo.getBgVersion())) continue;
                checkRef = false;
                oldData = null;
                _dimKey = DimUtils.getDimDataKey(_dataInfo);
                if (checkRemoveDataZero && _dataMap.containsKey(_dimKey) && _dataInfo.getBudgetValueNoDef() == null) {
                    _dataInfo.setBudgetValue(BgNConstants.ZERO);
                }
                if (_dataInfo.getBudgetValueNoDef() == null) {
                    if (_dataMap.containsKey(_dimKey)) {
                        oldData = (BgNDataInfo)_dataMap.get(_dimKey);
                        checkRef = true;
                    } else if (_schemeDataMap.containsKey(_dimKey)) {
                        oldData = (BgNDataInfo)_schemeDataMap.get(_dimKey);
                    }
                    if (oldData == null) continue;
                    _dataInfo.setBgDataId(oldData.getBgDataId());
                    if (oldData.getState() == 1) {
                        _delInfo.put(_dimKey, _dataInfo);
                        continue;
                    }
                    if (oldData.getState() != 3 || !checkIsInProInst) continue;
                    _delInfo.put(_dimKey, _dataInfo);
                    continue;
                }
                if (!helper.canSave(_dataInfo.getFormula(), null, null)) continue;
                _formulas.add(_dimKey);
                if (_dataMap.containsKey(_dimKey)) {
                    oldData = (BgNDataInfo)_dataMap.get(_dimKey);
                    checkRef = true;
                } else if (_schemeDataMap.containsKey(_dimKey)) {
                    oldData = (BgNDataInfo)_schemeDataMap.get(_dimKey);
                }
                if (oldData != null) {
                    _dataInfo.setBgDataId(oldData.getBgDataId());
                    _dataInfo.setState(oldData.getState());
                    if (oldData.getState() == 1) {
                        if (!this.compareBgDataInfo(_dataInfo, oldData)) {
                            _updInfo.put(_dimKey, _dataInfo);
                            if (checkRef) continue;
                            _refInfo.put(_dimKey, _dataInfo);
                            continue;
                        }
                        if (checkRef) continue;
                        _refInfo.put(_dimKey, _dataInfo);
                        continue;
                    }
                    if (oldData.getState() != 3 || !this.checkIsInProInst(ctx, bgFormId) && (this.checkIsInProInst(ctx, bgFormId) || !BgFormStateEnum.REFERRING.equals((Object)model.getState()) && !BgFormStateEnum.Approving.equals((Object)model.getState()))) continue;
                    if (!this.compareBgDataInfo(_dataInfo, oldData)) {
                        _updInfo.put(_dimKey, _dataInfo);
                        if (checkRef) continue;
                        _refInfo.put(_dimKey, _dataInfo);
                        continue;
                    }
                    if (checkRef) continue;
                    _refInfo.put(_dimKey, _dataInfo);
                    continue;
                }
                _newInfo.put(_dimKey, _dataInfo);
                _refInfo.put(_dimKey, _dataInfo);
            }
        }
        return _objs;
    }

    private boolean checkIsInProInst(Context ctx, BOSUuid bgFormId) throws BOSException {
        boolean check = true;
        if (this.checkMap.containsKey(bgFormId)) {
            check = this.checkMap.get(bgFormId);
        } else {
            check = BgNFSHelper.checkLocalInProInst(ctx, bgFormId.toString());
            this.checkMap.put(bgFormId, check);
        }
        return check;
    }

    private Map<String, IBgNData> querySchemeData(Context ctx, String orgId, String bgSchemeId, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        Map<String, IBgNData> _dataMap = new HashMap<String, IBgNData>();
        if (ctx == null || orgId == null || bgSchemeId == null || this.getHelper().getFormulas().isEmpty()) {
            return _dataMap;
        }
        HashSet<String> formulas = new HashSet<String>();
        int in = this.getHelper().getFormulas().size();
        for (int i = 0; i < in; ++i) {
            BgNDataInfo _dataInfo = (BgNDataInfo)this.getHelper().getFormulas().get(i);
            formulas.add(_dataInfo.getFormula());
        }
        if (!this.versionNums.isEmpty() && this.versionNums.size() > 1) {
            formulas.removeAll(this.getFilterSet());
        }
        if (formulas.isEmpty()) {
            return _dataMap;
        }
        long beginTime = System.currentTimeMillis();
        logger.info((Object)"begin querySchemeData!");
        _dataMap = MbgDataUtils.querySchemeData(ctx, bgFormInfo.getBgScheme(), orgId, formulas, bgFormInfo.getBgVersion(), this.getHelper().getDataType(), this.getHelper().getTableUtils()).get(orgId);
        logger.info((Object)("end querySchemeData! invoke queryUse = " + (System.currentTimeMillis() - beginTime) + " ms;"));
        return _dataMap;
    }

    public Set<String> getFilterSet() {
        return this.filterSet;
    }

    private Map<String, IBgNData> queryBgFormula(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        HashMap<String, IBgNData> _dataMap = new HashMap<String, IBgNData>();
        if (ctx == null || bgFormId == null) {
            return _dataMap;
        }
        BgNDataInfo _dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        this.getFilterSet().clear();
        this.versionNums.clear();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Set<String> cubes = this.getCubeName(null);
            for (String cubeName : cubes) {
                pstmt = conn.prepareStatement("select t.FID, t.FFormula, t.FValue, t.FState, v.FNumber from " + cubeName + " t join T_MBG_BgVersion v on t.FVersion = v.FVersionid where t.Fid in (select FDataId From " + this.getCubeEntryName() + " Where FFormId = ?)");
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _dataInfo = new BgNDataInfo();
                    _dataInfo.setBgDataId(rst.getString("FID"));
                    _dataInfo.setFormula(rst.getString("FFormula"));
                    _dataInfo.setBudgetValue(rst.getBigDecimal("FValue"));
                    _dataInfo.setState(rst.getInt("FState"));
                    _dataInfo.setBgVersion(rst.getString("FNumber"));
                    _dataMap.put(DimUtils.getDimDataKey(_dataInfo), _dataInfo);
                    this.getFilterSet().add(_dataInfo.getFormula());
                    this.versionNums.add(_dataInfo.getBgVersion());
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return _dataMap;
    }

    private boolean compareBgDataInfo(BgNDataInfo info1, BgNDataInfo info2) {
        if (info1 == null || info2 == null || info1 == info2) {
            return true;
        }
        return info1.getBudgetValue().compareTo(info2.getBudgetValue()) == 0;
    }

    @Override
    public void disposeBgDataValue(Context ctx, BgFormInfo model, Object[] objs) throws BOSException, EASBizException {
        if (ctx == null || objs == null) {
            return;
        }
        this.addNewBgDataValue(ctx, model, objs[0]);
        this.updateBgDataValue(ctx, model, objs[1]);
        if (this.isDeleteData()) {
            this.removeBgDataValue(ctx, model, objs[2]);
        }
        this.addDataEntries(ctx, objs[4], model);
        ViewListMemberCacheHelper cacheHelper = null;
        if (this.getHelper().getCacheHelper() != null) {
            cacheHelper = this.getHelper().getCacheHelper().getMemberCacheHelper();
            cacheHelper.setQueryId(true);
        }
        if (!(BgNFSHelper.isEmptyMap(objs[0]) && BgNFSHelper.isEmptyMap(objs[1]) && BgNFSHelper.isEmptyMap(objs[2]))) {
            BgFacadeHelper.saveBgDataRef(ctx, this.getCube(), this.getCubeEntryName(), this.getSchemeHelper(), model, cacheHelper, (Set<String>)(this.getAccIntHelper().isUseAccInt() ? new HashSet<String>(this.getAccIntHelper().getSplitMap().values()) : null), this.accIntHelper.isUseAccInt());
        }
    }

    @Override
    public void addNewBgDataValue(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return;
        }
        if (BgNSHelper.isMSSQL(ctx)) {
            this.addNewBgDataValueBySQL(ctx, model, obj);
        } else {
            this.addNewBgDataValueByDefault(ctx, model, obj);
        }
    }

    @Override
    public void addNewBgDataValue(Context ctx, BgFormInfo model, Object obj, BgDataStateEnum stateEnum) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        obj = this.checkData(ctx, model, obj);
        if (BgNSHelper.isMSSQL(ctx)) {
            this.addNewBgDataValueBySQL(ctx, model, obj, stateEnum);
        } else {
            this.addNewBgDataValueByDefault(ctx, model, obj, stateEnum);
        }
    }

    private Map checkData(Context ctx, BgFormInfo model, Object obj) throws EASBizException, BOSException {
        if (ctx == null || model == null) {
            return null;
        }
        HashSet formulas = new HashSet();
        if (obj instanceof Map) {
            formulas.addAll(((Map)obj).keySet());
        }
        DimensionMemberCheckHelper helper = DimensionMemberCheckHelper.getLocalIntance(ctx, null, model.getOrgUnit().getId().toString(), model.getBgTemplate().getId().toString(), this.getSchemeHelper(), formulas, this.getHelper().isDecompose());
        HashMap newMap = new HashMap();
        for (String formula : formulas) {
            if (!helper.canSave(formula, null, null)) continue;
            newMap.put(formula, ((Map)obj).get(formula));
        }
        return newMap;
    }

    private void addNewBgDataValueByDefault(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        this.addNewBgDataValueByDefault(ctx, model, obj, BgDataStateEnum.Edited);
    }

    private void addNewBgDataValueByDefault(Context ctx, BgFormInfo model, Object obj, BgDataStateEnum stateEnum) throws BOSException, EASBizException {
        if (ctx == null || model == null || obj == null) {
            return;
        }
        Map _tmpMap = (Map)obj;
        if (_tmpMap == null || _tmpMap.isEmpty()) {
            return;
        }
        MBgTemplateHelper.logTime("Start BgDataFacadeImpl addNewBgDataValueByDefault");
        BgNDataInfo _info2 = null;
        ArrayList<String> _bgPeriod = new ArrayList<String>();
        ArrayList<String> _bgElement = new ArrayList<String>();
        ArrayList<String> _bgScenario = new ArrayList<String>();
        ArrayList<String> _currency = new ArrayList<String>();
        for (BgNDataInfo _info2 : _tmpMap.values()) {
            _bgPeriod.add(_info2.getBgPeriodNumber());
            _bgElement.add(_info2.getBgElementNumber());
            _bgScenario.add(_info2.getBgScenario());
            _currency.add(_info2.getCurrencyNumber());
        }
        Map<String, String> _bgPeriodMap = BgDataFacadeImpl.getBgPeriodMap(ctx, _bgPeriod);
        Map<String, String> _bgElementMap = BgDataFacadeImpl.getBgElementMap(ctx, _bgElement);
        Map<String, BgScenarioInfo> _bgScenarioMap = BgDataFacadeImpl.getBgScenarioMap(ctx, _bgScenario);
        Map<String, String> _currencyMap = BgDataFacadeImpl.getCurrencyMap(ctx, _currency);
        MBgTemplateHelper.logTime("End BgDataFacadeImpl Member Map");
        List<String> dimRefs = this.getDimRefs();
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            boolean isUseAccInt = this.getAccIntHelper().isUseAccInt();
            Map splitDataMap = this.getAccIntHelper().splitBgDatas(conn, _tmpMap, this.getFilterSet());
            for (String cubeName : splitDataMap.keySet()) {
                String[] sqls = this.getBgDataSql(cubeName, dimRefs);
                MBgTemplateHelper.logTime("Start BgDataFacadeImpl addNewBgDataValue");
                this.addNewBgDataValue(ctx, null, model, splitDataMap.get(cubeName), sqls, stateEnum, _bgPeriodMap, _bgElementMap, _currencyMap, _bgScenarioMap, dimRefs, isUseAccInt);
                MBgTemplateHelper.logTime("End BgDataFacadeImpl addNewBgDataValue");
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void addNewBgDataValueBySQL(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        this.addNewBgDataValueBySQL(ctx, model, obj, BgDataStateEnum.Edited);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewBgDataValueBySQL(Context ctx, BgFormInfo model, Object obj, BgDataStateEnum dataStateEnum) throws BOSException, EASBizException {
        Connection conn;
        long _endTime;
        long _beginTime;
        long _startTime;
        block17: {
            if (ctx == null || model == null || obj == null) {
                return;
            }
            Map _tmpMap = (Map)obj;
            if (_tmpMap == null || _tmpMap.isEmpty()) {
                return;
            }
            _startTime = 0L;
            _beginTime = 0L;
            _endTime = 0L;
            _beginTime = _startTime = System.currentTimeMillis();
            _endTime = _startTime;
            logger.info((Object)"invoke begin add bgData!");
            BgNDataInfo _info2222222 = null;
            ArrayList<String> _bgPeriod = new ArrayList<String>();
            ArrayList<String> _bgElement = new ArrayList<String>();
            ArrayList<String> _bgScenario = new ArrayList<String>();
            ArrayList<String> _currency = new ArrayList<String>();
            for (BgNDataInfo _info2222222 : _tmpMap.values()) {
                _bgPeriod.add(_info2222222.getBgPeriodNumber());
                _bgElement.add(_info2222222.getBgElementNumber());
                _bgScenario.add(_info2222222.getBgScenario());
                _currency.add(_info2222222.getCurrencyNumber());
            }
            Map<String, String> _bgPeriodMap = BgDataFacadeImpl.getBgPeriodMap(ctx, _bgPeriod);
            Map<String, String> _bgElementMap = BgDataFacadeImpl.getBgElementMap(ctx, _bgElement);
            Map<String, BgScenarioInfo> _bgScenarioMap = BgDataFacadeImpl.getBgScenarioMap(ctx, _bgScenario);
            Map<String, String> _currencyMap = BgDataFacadeImpl.getCurrencyMap(ctx, _currency);
            List<String> dimRefs = this.getDimRefs();
            TempTablePool pool = null;
            String _tableName = null;
            StringBuffer sql = new StringBuffer("Create Table TMP_Table_Name(FID VARCHAR(44) NOT NULL, FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
            int in = dimRefs.size();
            for (int i = 0; i < in; ++i) {
                String tmpStr = dimRefs.get(i);
                if (DimensionConstants.DEF_BGINDEX_FIELD.equals(tmpStr)) {
                    sql.append(tmpStr + " NVARCHAR(80) DEFAULT '' NOT NULL, ");
                    continue;
                }
                sql.append(tmpStr + " NVARCHAR(80), ");
            }
            sql.append("FBgItemCombination NVARCHAR(300) DEFAULT '' NOT NULL, FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 1 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 0 NOT NULL, FAudOrgUnitID VARCHAR(44) DEFAULT '', FAudUserID VARCHAR(44) DEFAULT '', FDataSource NUMERIC(21,8),FDetail INT DEFAULT 1 NOT NULL,FAudFormId VARCHAR(44) DEFAULT '')");
            conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                _tableName = pool.createDBSystemTempTable(sql.toString(), conn);
                String[] sqls = this.getBgDataSql(_tableName, dimRefs);
                boolean isUseAccInt = this.getAccIntHelper().isUseAccInt();
                Map splitData = this.getAccIntHelper().splitBgDatas(conn, _tmpMap, this.getFilterSet());
                for (String cubeName : splitData.keySet()) {
                    MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + _tableName));
                    this.addNewBgDataValue(ctx, conn, model, splitData.get(cubeName), sqls, dataStateEnum, _bgPeriodMap, _bgElementMap, _currencyMap, _bgScenarioMap, dimRefs, isUseAccInt);
                    StringBuffer _tmpSql = new StringBuffer("FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue");
                    int in2 = dimRefs.size();
                    for (int i = 0; i < in2; ++i) {
                        _tmpSql.append(", " + dimRefs.get(i));
                    }
                    _tmpSql.append(", FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate,FDataSource ");
                    sql = new StringBuffer("Insert Into " + cubeName + "(").append(_tmpSql).append(") Select ").append(_tmpSql).append(" from " + _tableName);
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                }
                if (pool == null) break block17;
            }
            catch (EASBizException ex) {
                try {
                    throw ex;
                    catch (Exception ex2) {
                        logger.error((Object)"bgData addNew:", (Throwable)ex2);
                        throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        try {
                            pool.releaseDBSystemTempTable(_tableName, conn);
                        }
                        catch (Exception ex3) {
                            logger.error((Object)"releaseDBSystemTempTable:", (Throwable)ex3);
                        }
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(_tableName, conn);
            }
            catch (Exception ex) {
                logger.error((Object)"releaseDBSystemTempTable:", (Throwable)ex);
            }
        }
        SQLUtils.cleanup((Connection)conn);
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end add bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    private String[] getBgDataSql(String tableName, List<String> dimRefs) {
        int i;
        if (StringUtils.isEmpty((String)tableName) || dimRefs == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tableName + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate , FAudOrgUnitID, FAudUserID,FDataSource,FDetail,FAudFormId ");
        int in = dimRefs.size();
        for (i = 0; i < in; ++i) {
            sql.append(", " + dimRefs.get(i));
        }
        sql.append(") Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?");
        in = dimRefs.size();
        for (i = 0; i < in; ++i) {
            sql.append(",?");
        }
        sql.append(")");
        String[] sqls = new String[2];
        sqls[0] = sql.toString();
        return sqls;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addNewBgDataValue(Context ctx, Connection conn, BgFormInfo model, Map<String, IBgNData> bgDataMap, String[] sqls, BgDataStateEnum dataState, Map<String, String> bgPeriodMap, Map<String, String> bgElementMap, Map<String, String> currencyMap, Map<String, BgScenarioInfo> bgscenarioMap, List<String> dimRefs, boolean isUseInt) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (model == null) return;
        if (bgDataMap == null) return;
        if (sqls == null) return;
        if (bgPeriodMap == null) return;
        if (bgElementMap == null) return;
        if (currencyMap == null) return;
        if (bgscenarioMap == null) {
            return;
        }
        long sqlTime = 0L;
        long time = System.currentTimeMillis();
        long t = 0L;
        Object var19_16 = null;
        BigDecimal budgetValue = null;
        int batchSize = 100;
        int batchIndex = 0;
        int fixParam = 23;
        int state = dataState == null ? 1 : dataState.getValue();
        BOSObjectType type = new BgDataInfo().getBOSType();
        String _bgDateId = null;
        String _id = null;
        String _bgFormId = model.getId().toString();
        String _orgUnitId = model.getOrgUnit().getId().toString();
        String dimStr = null;
        String srcStr2222 = null;
        String[] tmpStrs = null;
        String[] tmpSrc = null;
        String _userId = model.getLastUpdateUser() == null ? model.getCreator().getId().toString() : model.getLastUpdateUser().getId().toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        Map<String, String> srcFields = DimUtils.getDimSourceMap(ctx);
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Connection _conn = conn;
        PreparedStatement pstmt = null;
        try {
            if (conn == null) {
                _conn = BgDBUtils.getConnection((Context)ctx);
            }
            pstmt = _conn.prepareStatement(sqls[0]);
            for (BgNDataInfo bgNDataInfo : bgDataMap.values()) {
                valueMap.clear();
                budgetValue = bgNDataInfo.getBudgetValueNoDef();
                if (budgetValue == null) continue;
                tmpStrs = bgNDataInfo.getBgItemNumber().split(",");
                if (tmpStrs != null) {
                    for (String srcStr2222 : tmpStrs) {
                        tmpSrc = srcStr2222.split(":");
                        if (!srcFields.containsKey(tmpSrc[0])) continue;
                        valueMap.put(srcFields.get(tmpSrc[0]), srcStr2222);
                    }
                }
                if (bgNDataInfo instanceof BgNViewDataInfo) {
                    _bgDateId = ((BgNViewDataInfo)bgNDataInfo).getId();
                } else {
                    _bgDateId = BOSUuid.create((BOSObjectType)type).toString();
                    bgNDataInfo.setBgDataId(_bgDateId);
                }
                pstmt.setString(1, _bgDateId);
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, _time);
                pstmt.setString(4, _userId);
                pstmt.setTimestamp(5, _time);
                this.getAccIntHelper().setParam(pstmt, 6, _orgUnitId, DimensionConstants.DEF_ORGUNIT_FIELD);
                pstmt.setString(7, bgNDataInfo.getFormula());
                pstmt.setBigDecimal(8, budgetValue.setScale(8, 4));
                pstmt.setBigDecimal(9, budgetValue.setScale(8, 4));
                _id = bgNDataInfo.getBgItemNumber();
                if (_id == null) {
                    logger.debug((Object)("bgItem number error:" + bgNDataInfo.getBgItemNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOITEM, new String[]{bgNDataInfo.getBgItemNumber()});
                }
                pstmt.setString(10, _id);
                _id = bgPeriodMap.get(bgNDataInfo.getBgPeriodNumber());
                if (_id == null) {
                    logger.debug((Object)("bgPeriod number error:" + bgNDataInfo.getBgPeriodNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOPERIOD, new String[]{bgNDataInfo.getBgPeriodNumber()});
                }
                this.getAccIntHelper().setParam(pstmt, 11, _id, DimensionConstants.DEF_PERIOD_FIELD);
                _id = bgElementMap.get(bgNDataInfo.getBgElementNumber());
                if (_id == null) {
                    logger.debug((Object)("bgElement number error:" + bgNDataInfo.getBgElementNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOELEMENT, new String[]{bgNDataInfo.getBgElementNumber()});
                }
                this.getAccIntHelper().setParam(pstmt, 12, _id, DimensionConstants.DEF_ELEMENT_FIELD);
                _id = currencyMap.get(bgNDataInfo.getCurrencyNumber());
                if (_id == null) {
                    logger.debug((Object)("currency number error:" + bgNDataInfo.getCurrencyNumber()));
                    throw new BgFormException(BgFormException.SUBMITNOCURRENCY, new String[]{bgNDataInfo.getCurrencyNumber()});
                }
                pstmt.setString(13, _id);
                pstmt.setInt(14, bgscenarioMap.get(bgNDataInfo.getBgScenario()).getScenarioId());
                pstmt.setInt(15, model.getBgVersion().getVersionId());
                if (this.checkIsInProInst(ctx, model.getId())) {
                    pstmt.setInt(16, 3);
                    pstmt.setInt(17, 1);
                    pstmt.setString(18, model.getOrgUnit().getId().toString());
                    pstmt.setString(19, ctx.getCaller().toString());
                    pstmt.setInt(20, bgNDataInfo.getBgDataSource());
                    pstmt.setInt(21, 1);
                    pstmt.setString(22, model.getId().toString());
                } else {
                    pstmt.setInt(16, state);
                    pstmt.setInt(17, 1);
                    pstmt.setString(18, null);
                    pstmt.setString(19, null);
                    pstmt.setInt(20, bgNDataInfo.getBgDataSource());
                    pstmt.setInt(21, 0);
                    pstmt.setString(22, null);
                }
                if (BgScenarioType.ActualData.equals((Object)bgscenarioMap.get(bgNDataInfo.getBgScenario()).getType())) {
                    pstmt.setInt(16, 9);
                }
                int in = dimRefs.size();
                for (int i = 0; i < in; ++i) {
                    dimStr = dimRefs.get(i);
                    if (valueMap.containsKey(dimStr)) {
                        this.getAccIntHelper().setParam(pstmt, fixParam + i, (String)valueMap.get(dimStr), dimStr);
                        continue;
                    }
                    pstmt.setString(fixParam + i, null);
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                t = System.currentTimeMillis();
                pstmt.executeBatch();
                sqlTime += System.currentTimeMillis() - t;
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"bgData addNew:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                if (conn != null) throw throwable;
                SQLUtils.cleanup((Connection)_conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        if (conn != null) return;
        SQLUtils.cleanup((Connection)_conn);
    }

    @Override
    public void updateBgDataValue(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null || model == null || obj == null) {
            return;
        }
        Map _tmpMap = (Map)obj;
        if (_tmpMap == null || _tmpMap.isEmpty()) {
            return;
        }
        int batchSize = 100;
        int batchIndex = 0;
        String _orgUnitId = model.getOrgUnit().getId().toString();
        String _userId = model.getLastUpdateUser() == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : model.getLastUpdateUser().getId().toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        BigDecimal budgetValue = null;
        BgNDataInfo _info2 = null;
        ArrayList<String> formula = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Map splitData = this.getAccIntHelper().splitBgDatas(conn, _tmpMap, this.getFilterSet());
            for (String cubeName : splitData.keySet()) {
                String sql = "Update " + cubeName + " Set FValue = ?, FTmpValue = ?, FLastUpdateUserId = ?, FlastUpdateTime = ?, FIsUpdate = 1 where FOrgUnitID = ? and FFormula = ? and FVersion = ? and FState IN (" + 1 + ", " + 3 + ")";
                pstmt = conn.prepareStatement(sql);
                for (BgNDataInfo _info2 : splitData.get(cubeName).values()) {
                    budgetValue = _info2.getBudgetValue().setScale(8, 4);
                    formula.add(_info2.getBgDataId());
                    pstmt.setBigDecimal(1, budgetValue);
                    pstmt.setBigDecimal(2, budgetValue);
                    pstmt.setString(3, _userId);
                    pstmt.setTimestamp(4, _time);
                    this.getAccIntHelper().setParam(pstmt, 5, _orgUnitId, DimensionConstants.DEF_ORGUNIT_FIELD);
                    pstmt.setString(6, _info2.getFormula());
                    pstmt.setInt(7, model.getBgVersion().getVersionId());
                    pstmt.addBatch();
                    if (++batchIndex < batchSize) continue;
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                if (batchIndex != 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"bgData Update:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeBgDataValue(Context ctx, Map<String, BgFormInfo> bgFormMap, Map<String, Map<String, IBgNData>> deleteMap) throws EASBizException {
        block34: {
            block32: {
                block33: {
                    if (ctx == null) return;
                    if (bgFormMap == null) return;
                    if (bgFormMap.isEmpty() != false) return;
                    if (deleteMap == null) return;
                    if (deleteMap.isEmpty()) {
                        return;
                    }
                    var4_4 = null;
                    formulaMap = new HashMap<String, HashSet<E>>();
                    temp = null;
                    conn = null;
                    pstmt = null;
                    rst = null;
                    pool = TempTablePool.getInstance((Context)ctx);
                    tmpTable = null;
                    try {
                        conn = EJBFactory.getConnection((Context)ctx);
                        splitDataMap = new HashMap<String, HashMap<K, V>>();
                        subSplitMap = null;
                        for (String orgId : deleteMap.keySet()) {
                            temp = deleteMap.get(orgId);
                            subSplitMap = this.getAccIntHelper().splitBgDatas(conn, temp, this.getFilterSet());
                            for (String cubeName : subSplitMap.keySet()) {
                                if (!splitDataMap.containsKey(cubeName)) {
                                    splitDataMap.put(cubeName, new HashMap<K, V>());
                                }
                                if (((Map)splitDataMap.get(cubeName)).get(orgId) == null) {
                                    ((Map)splitDataMap.get(cubeName)).put(orgId, subSplitMap.get(cubeName));
                                    continue;
                                }
                                ((Map)((Map)splitDataMap.get(cubeName)).get(orgId)).putAll(subSplitMap.get(cubeName));
                            }
                        }
                        tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
                        pool.createDBSystemTempTableIndex(tmpTable, "FID", false, false, conn);
lbl36:
                        // 2 sources

                        for (String cubeName : splitDataMap.keySet()) {
                            MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tmpTable));
                            sql = new StringBuffer();
                            fixParamCount = 2;
                            sql.append("insert into " + tmpTable + " select FID from " + cubeName + " where FOrgUnitId = ? and FVersion = ? and FFormula IN( ");
                            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                            paramList = new ArrayList<Object[]>();
                            formids = new StringBuffer();
                            for (String orgId : deleteMap.keySet()) {
                                temp = deleteMap.get(orgId);
                                bgForm = bgFormMap.get(orgId);
                                formids.append("'").append(bgForm.getId().toString()).append("'").append(",");
                                if (temp == null || temp.isEmpty() || temp.isEmpty()) continue;
                                formulas = new HashSet<String>();
                                formulaMap.put(orgId, formulas);
                                params = null;
                                paramIndex = 0;
                                for (BgNDataInfo var4_6 : temp.values()) {
                                    formulas.add(var4_6.getFormula());
                                    if (paramIndex == 0) {
                                        params = new Object[52];
                                        params[0] = this.getAccIntHelper().convertOrgObject(orgId);
                                        params[1] = bgForm.getBgVersion().getVersionId();
                                        for (i = 2; i < params.length; ++i) {
                                            params[i] = "#";
                                        }
                                        paramList.add(params);
                                    }
                                    if (params != null) {
                                        params[2 + paramIndex] = var4_6.getFormula();
                                    }
                                    if (++paramIndex < 50) continue;
                                    paramIndex = 0;
                                }
                            }
                            MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), paramList);
                            sql.delete(0, sql.length());
                            sql.append("select dataEntry.FFormID FFormID ").append("from " + this.getCubeEntryName() + " dataEntry ").append("join " + tmpTable + " tmp on tmp.FID = dataEntry.FDataId ");
                            pstmt = conn.prepareStatement(sql.toString());
                            rst = pstmt.executeQuery();
                            refFormId = new ArrayList<String>();
                            while (rst.next()) {
                                bgFormId = rst.getString("FFormID");
                                for (String orgId : formulaMap.keySet()) {
                                    bgForm = bgFormMap.get(orgId);
                                    formid = bgForm.getId().toString();
                                    if (bgFormId.equals(formid) || refFormId.contains(bgFormId)) continue;
                                    refFormId.add(bgFormId);
                                }
                            }
                            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                            sql.delete(0, sql.length());
                            if (refFormId.size() > 0) {
                                formids.deleteCharAt(formids.length() - 1);
                                sql.append("delete from " + this.getCubeEntryName() + " where FDataId IN (select FID from " + tmpTable + ") and FFormID in (" + formids.toString() + ")");
                            } else {
                                sql.append("delete from " + this.getCubeEntryName() + " where FDataId IN (select FID from " + tmpTable + ")");
                            }
                            MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
                            if (refFormId.size() > 0 && BgParamUtils.removeDataCheckRef(ctx)) {
                                if (pool == null || tmpTable == null) break block32;
                                break block33;
                            }
                            ** GOTO lbl-1000
                        }
                        break block34;
                    }
                    catch (SQLException ex) {
                        try {
                            BgDataFacadeImpl.logger.error((Object)"bgData remove:", (Throwable)ex);
                            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                            catch (Exception ex) {
                                BgDataFacadeImpl.logger.error((Object)"bgData remove:", (Throwable)ex);
                                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                            }
                        }
                        catch (Throwable var28_37) {
                            if (pool != null && tmpTable != null) {
                                try {
                                    pool.releaseDBSystemTempTable(tmpTable, conn);
                                }
                                catch (Exception e) {
                                    BgDataFacadeImpl.logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)e);
                                }
                            }
                            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                            throw var28_37;
                        }
                    }
                }
                try {
                    pool.releaseDBSystemTempTable(tmpTable, conn);
                }
                catch (Exception e) {
                    BgDataFacadeImpl.logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)e);
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return;
lbl-1000:
            // 1 sources

            {
                paramList.clear();
                for (String orgId : formulaMap.keySet()) {
                    bgForm = bgFormMap.get(orgId);
                    formulas = (Set)formulaMap.get(orgId);
                    if (bgForm == null || formulas == null || formulas.isEmpty()) continue;
                    iter = formulas.iterator();
                    while (iter.hasNext()) {
                        params = new Object[]{this.getAccIntHelper().convertOrgObject(orgId), iter.next(), bgForm.getBgVersion().getVersionId()};
                        paramList.add(params);
                    }
                }
                MbgSqlHelper.executeBatch((Connection)conn, (String)("delete from " + cubeName + " where FOrgUnitID = ? and FFormula = ? and FVersion = ?"), paramList);
                ** GOTO lbl36
            }
        }
        if (pool != null && tmpTable != null) {
            try {
                pool.releaseDBSystemTempTable(tmpTable, conn);
            }
            catch (Exception e) {
                BgDataFacadeImpl.logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)e);
            }
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
    }

    @Override
    public void removeBgDataValue(Context ctx, BgFormInfo model, Object obj) throws BOSException, EASBizException {
        if (ctx == null || model == null || obj == null) {
            return;
        }
        Map _tmpMap = (Map)obj;
        if (_tmpMap == null || _tmpMap.isEmpty()) {
            return;
        }
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        bgFormMap.put(model.getOrgUnit().getId().toString(), model);
        HashMap<String, Map<String, IBgNData>> deleteMap = new HashMap<String, Map<String, IBgNData>>();
        deleteMap.put(model.getOrgUnit().getId().toString(), _tmpMap);
        this.removeBgDataValue(ctx, bgFormMap, deleteMap);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addDataEntries(Context ctx, Object obj, BgFormInfo model) throws BOSException, EASBizException {
        PreparedStatement pstmt;
        Connection conn;
        block15: {
            if (ctx == null) return;
            if (obj == null) return;
            if (model == null) {
                return;
            }
            Map refData = (Map)obj;
            if (refData == null) return;
            if (refData.isEmpty()) {
                return;
            }
            int index = 0;
            String bgFormId = model.getId().toString();
            String tmpTable = null;
            IBgNData bgData2222222 = null;
            HashSet<String> bgDataIds = new HashSet<String>();
            conn = null;
            pstmt = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                tmpTable = pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FFormID VARCHAR(44), FDataID VARCHAR(44))", conn);
                pool.createDBSystemTempTableIndex(tmpTable, "FFormID, FDataID", false, false, conn);
                pstmt = conn.prepareStatement("Insert into " + tmpTable + " (FFormID, FDataID) values (?,?)");
                for (IBgNData bgData2222222 : refData.values()) {
                    if (bgDataIds.contains(bgData2222222.getBgDataId())) continue;
                    bgDataIds.add(bgData2222222.getBgDataId());
                    pstmt.setString(1, bgFormId);
                    pstmt.setString(2, bgData2222222.getBgDataId());
                    pstmt.addBatch();
                    if (++index < 50) continue;
                    pstmt.executeBatch();
                    index = 0;
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + this.getCubeEntryName() + " Select FFormID, FDataID from " + tmpTable + " where not exists (select * from " + this.getCubeEntryName() + " where FFormID = " + tmpTable + ".FFormID and FDataID = " + tmpTable + ".FDataID and FFormID = ?)"), (Object[])new Object[]{bgFormId});
                if (pool == null || tmpTable == null) break block15;
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        logger.error((Object)"bgData remove:", (Throwable)ex2);
                        throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                    catch (Exception ex3) {
                        throw new BOSException((Throwable)ex3);
                    }
                }
                catch (Throwable throwable) {
                    if (pool != null && tmpTable != null) {
                        try {
                            pool.releaseDBSystemTempTable(tmpTable, conn);
                        }
                        catch (Exception e) {
                            logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)e);
                        }
                    }
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseDBSystemTempTable(tmpTable, conn);
            }
            catch (Exception e) {
                logger.error((Object)"releaseDBSystemTempTable error:", (Throwable)e);
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static Map<String, String> getBgPeriodMap(Context ctx, List<String> bgPeriods) throws EASBizException {
        HashMap<String, String> bgPeriodMap = new HashMap<String, String>();
        if (ctx == null || bgPeriods == null || bgPeriods.isEmpty()) {
            return bgPeriodMap;
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        ArrayList<String> _bgPeriodList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgPeriodId = null;
        String bgPeriodNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FBgPeriodID, FNumber from T_MBG_BgPeriodDisp where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        _bgPeriodSet.addAll(bgPeriods);
        _bgPeriodList.addAll(_bgPeriodSet);
        size = _bgPeriodList.size();
        count = (size - 1) / 50 + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgPeriodList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodId = rst.getString(1);
                    bgPeriodNum = rst.getString(2);
                    bgPeriodMap.put(bgPeriodNum, bgPeriodId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgPeriodMap;
    }

    public static Map<String, String> getBgElementMap(Context ctx, List<String> bgElements) throws EASBizException {
        HashMap<String, String> bgElementMap = new HashMap<String, String>();
        if (ctx == null || bgElements == null || bgElements.isEmpty()) {
            return bgElementMap;
        }
        HashSet<String> _bgElementSet = new HashSet<String>();
        ArrayList<String> _bgElementList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int size = 0;
        int count = 0;
        int pos = 0;
        String bgElementId = null;
        String bgElementNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_MBg_BgElement where FNumber IN (");
        for (index = 1; index < 50; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        _bgElementSet.addAll(bgElements);
        _bgElementList.addAll(_bgElementSet);
        size = _bgElementList.size();
        count = (size - 1) / 50 + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= 50) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgElementList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementId = rst.getString(1);
                    bgElementNum = rst.getString(2);
                    bgElementMap.put(bgElementNum, bgElementId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgElementMap;
    }

    public static Map<String, BgScenarioInfo> getBgScenarioMap(Context ctx, List<String> bgScenarioNums) throws EASBizException {
        HashMap<String, BgScenarioInfo> bgScenarioMap = new HashMap<String, BgScenarioInfo>();
        if (ctx == null || bgScenarioNums == null || bgScenarioNums.isEmpty()) {
            return bgScenarioMap;
        }
        HashSet<String> _bgScenarioSet = new HashSet<String>();
        ArrayList<String> _bgScenarioList = new ArrayList<String>();
        BgScenarioInfo scenario = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = 0;
        int count = 0;
        int pos = 0;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber, FScenarioid from T_MBG_BgScenario where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        _bgScenarioSet.addAll(bgScenarioNums);
        _bgScenarioList.addAll(_bgScenarioSet);
        size = _bgScenarioList.size();
        count = (size - 1) / batchNum + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_bgScenarioList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    scenario = new BgScenarioInfo();
                    scenario.setId(BOSUuid.read((String)rst.getString("FID")));
                    scenario.setNumber(rst.getString("FNumber"));
                    scenario.setScenarioId(rst.getInt("FScenarioid"));
                    bgScenarioMap.put(scenario.getNumber(), scenario);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgScenarioMap;
    }

    public static Map<String, String> getCurrencyMap(Context ctx, List<String> currencys) throws EASBizException {
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        if (ctx == null || currencys == null || currencys.isEmpty()) {
            return currencyMap;
        }
        HashSet<String> _currencySet = new HashSet<String>();
        ArrayList<String> _currencyList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = 0;
        int count = 0;
        int pos = 0;
        String currencyId = null;
        String currencyNum = null;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        _currencySet.addAll(currencys);
        _currencyList.addAll(_currencySet);
        size = _currencyList.size();
        count = (size - 1) / batchNum + 1;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int k = 1;
                while (k <= batchNum) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_currencyList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyId = rst.getString(1);
                    currencyNum = rst.getString(2);
                    currencyMap.put(currencyNum, currencyId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return currencyMap;
    }

    private String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    @Override
    public boolean isDeleteData() {
        return this.isDeleteData;
    }

    @Override
    public void setDeleteData(boolean b) {
        this.isDeleteData = b;
    }
}

