/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.data.MbgDataTempTableUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.IBgDataFacade;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BgDataHelper {
    private IBgDataFacade impl = null;
    private List<IBgNData> formulas = new ArrayList<IBgNData>();
    private Map<String, BgNDataInfo> bgDataMap = new HashMap<String, BgNDataInfo>();
    private BgSchemeInfo rootSchemeInfo = null;
    private int dataType = 1;
    private MbgDataTempTableUtils tableUtils = null;
    private DimensionCacheHelper cacheHelper = null;

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isDecompose() {
        return DimensionCommonHelper.isDecompose(this.getDataType());
    }

    public BgDataHelper(Context ctx) {
        this.impl = new BgDataFacadeImpl(ctx, this);
    }

    public List<IBgNData> getFormulas() {
        return this.formulas;
    }

    public IBgDataFacade getImpl() {
        return this.impl;
    }

    public void setCacheHelper(DimensionCacheHelper cacheHelper) {
        this.cacheHelper = cacheHelper;
    }

    public DimensionCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void setTableUtils(MbgDataTempTableUtils tableUtils) {
        this.tableUtils = tableUtils;
    }

    public MbgDataTempTableUtils getTableUtils() {
        return this.tableUtils;
    }

    public void setRootSchemeInfo(BgSchemeInfo rootSchemeInfo) {
        this.rootSchemeInfo = rootSchemeInfo;
    }

    public BgSchemeInfo getRootSchemeInfo() {
        return this.rootSchemeInfo;
    }

    public void addBgDataInfo(Cell cell, String formula, String version, BigDecimal value, Set<String> exprFormulas) throws EASBizException {
        this.addBgDataInfo(cell, formula, version, value, exprFormulas, 0);
    }

    public void addBgDataInfo(Cell cell, String formula, String version, BigDecimal value, Set<String> exprFormulas, int dataSource) throws EASBizException {
        String key = formula + "_" + version;
        BgNDataInfo _dataInfo = this.bgDataMap.get(key);
        if (_dataInfo == null) {
            _dataInfo = this.addBaseValue(cell, formula, version, value, dataSource);
            BgNFSHelper.checkUpdataValueByTime(cell, _dataInfo);
            if (_dataInfo != null) {
                this.bgDataMap.put(key, _dataInfo);
                this.getFormulas().add(_dataInfo);
            }
        } else if (exprFormulas != null && exprFormulas.contains(formula)) {
            _dataInfo.setBudgetValue(value);
        } else if (BgNFSHelper.checkUpdataValueByTime(cell, _dataInfo).booleanValue()) {
            _dataInfo.setBudgetValue(value);
        } else {
            BgNFSHelper.setValue(cell, _dataInfo.getBudgetValueNoDef());
        }
    }

    private BgNDataInfo addBaseValue(Cell cell, String formula, String version, BigDecimal value, int dataSource) throws EASBizException {
        BgNDataInfo _dataInfo = null;
        if (!StringUtils.isEmpty((String)formula)) {
            _dataInfo = new BgNDataInfo();
            if (cell != null) {
                _dataInfo.setRow(cell.getRow());
                _dataInfo.setCol(cell.getCol());
            }
            _dataInfo.setFormula(formula);
            _dataInfo.setBgVersion(version);
            _dataInfo.setBudgetValue(value);
            _dataInfo.setBgDataSource(dataSource);
            this.parseBgFormula(_dataInfo);
        }
        return _dataInfo;
    }

    public String parseBgFormula(String[] formulaPara, String SpecialNumber) {
        if (formulaPara == null || StringUtils.isEmpty((String)SpecialNumber)) {
            return null;
        }
        String[] _tmpStrs = (String[])formulaPara.clone();
        String _formula = null;
        String _newItemNumber = null;
        String _itemNumber = formulaPara[0];
        if (StringUtils.isEmpty((String)_itemNumber)) {
            return null;
        }
        String[] _strs = _itemNumber.split(",");
        if (_strs != null) {
            int in = _strs.length;
            for (int i = 0; i < in; ++i) {
                if (!SpecialNumber.equals(_strs[i])) continue;
                int jn = _strs.length;
                for (int j = 0; j < jn; ++j) {
                    if (j == i) continue;
                    _newItemNumber = _formula != null ? _formula + "," + _strs[j] : _strs[j];
                }
                break;
            }
            _tmpStrs[0] = _newItemNumber;
            _formula = BgNFSHelper.getFormulaFromParam(_tmpStrs);
        }
        return _formula;
    }

    private void parseBgFormula(BgNDataInfo info) throws EASBizException {
        if (info != null && !StringUtils.isEmpty((String)info.getFormula())) {
            String[] _para = BgNFSHelper.parseFormulaPara(info.getFormula());
            BgNFSHelper.checkFormulaPara(info.getFormula(), _para);
            if (_para != null) {
                info.setBgItemNumber(_para[0]);
                info.setBgPeriodNumber(_para[1]);
                info.setBgElementNumber(_para[2]);
                info.setCurrencyNumber(_para[5]);
                info.setBgScenario(_para[3]);
            }
        }
    }

    public void removeBgDataInfo(String formula) {
        this.getFormulas().remove(formula);
    }

    public Object[] compareBgDataInfo(Context ctx, BgFormInfo model) throws BOSException, EASBizException {
        return this.getImpl().compareBgDataInfo(ctx, model);
    }

    public void disposeBgDataValue(Context ctx, BgFormInfo model, Object[] objs) throws BOSException, EASBizException {
        this.getImpl().disposeBgDataValue(ctx, model, objs);
    }

    public void addBgDataValueByAddActualAudit(Context ctx, BgFormInfo model, Map<String, BgNDataInfo> _newInfo) throws BOSException, EASBizException {
        this.getImpl().addNewBgDataValue(ctx, model, _newInfo, BgDataStateEnum.Approved);
    }

    public void setDeleteData(boolean b) {
        this.getImpl().setDeleteData(b);
    }

    public void isDeleteData(boolean b) {
        this.getImpl().isDeleteData();
    }
}

