/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.app.utils.AbstractDataFacadeImpl;
import com.kingdee.eas.ma.mbg.app.utils.BgBizFacade;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDataUpdateImpl
extends BgBizFacade {
    private static final Logger logger = Logger.getLogger(BgDataUpdateImpl.class);
    private int versionInnId = 0;
    private static String UPDATE_VALUE_FIELD = "FValue";

    public static synchronized BgDataUpdateImpl getInstance(AbstractDataFacadeImpl facade) {
        return new BgDataUpdateImpl(facade);
    }

    public BgDataUpdateImpl(AbstractDataFacadeImpl facade) {
        super(facade);
    }

    public void setVersionInnId(int versionInnId) {
        this.versionInnId = versionInnId;
    }

    public int getVersionInnId() {
        return this.versionInnId;
    }

    public void update(Context ctx, Map<String, IBgNData> valueMap) throws BOSException, EASBizException {
        if (ctx == null || this.getFacade() == null || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        int batchIndex = 0;
        IObjectValue model = this.getFacade().getDataHelper().getModel();
        String _billId = this.getFacade().getBillId(model).toString();
        BOSUuid orgUnitId = this.getFacade().getOrgUnitId(model);
        String _orgUnitId = orgUnitId == null ? null : orgUnitId.toString();
        String _userId = this.getFacade().getUserId(model).toString();
        Timestamp _time = new Timestamp(System.currentTimeMillis());
        this.setVersionInnId(this.getFacade().getVersionIntId(model));
        Object var10_10 = null;
        ArrayList<String> formula = new ArrayList<String>();
        String sql = this.getUpdateSql();
        String eSql = this.getUpdateEntrySql();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            for (BgNDataInfo bgNDataInfo : valueMap.values()) {
                formula.add(bgNDataInfo.getBgDataId());
                this.setSqlData(pstmt, bgNDataInfo, _orgUnitId, _userId, _time);
                if (++batchIndex < 50) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
            int size = formula.size();
            int count = (size - 1) / 50 + 1;
            int pos = 0;
            pstmt = conn.prepareStatement(eSql.toString());
            for (int index = 0; index < count; ++index) {
                pstmt.setString(1, _billId);
                int x = 1;
                while (x <= 50) {
                    if (pos < size) {
                        pstmt.setString(x + 1, (String)formula.get(pos));
                    } else {
                        pstmt.setString(x + 1, "#");
                    }
                    ++x;
                    ++pos;
                }
                pstmt.setString(52, _billId);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"bgData Update:", (Throwable)ex);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected String getUpdateSql() {
        return "Update " + this.getCubeName() + " Set " + this.getUpdateValueField() + " = ?, FLastUpdateUserId = ?, FlastUpdateTime = ? where FOrgUnitID = ? and FFormula = ? and FVersion = ?";
    }

    protected String getUpdateEntrySql() {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + this.getEntryName() + " (FFormID, FDataID) Select ?, FID From " + this.getCubeName() + " bgData Where FID IN (");
        for (int i = 1; i < 50; ++i) {
            sql.append("?,");
        }
        sql.append("?) And NOT EXISTS(Select FDataID From " + this.getEntryName() + " Where FFormID = ? And FDataID = bgData.FID)");
        return sql.toString();
    }

    protected String getUpdateValueField() {
        return UPDATE_VALUE_FIELD;
    }

    protected void setSqlData(PreparedStatement pstmt, BgNDataInfo bgData, String orgUnitId, String userId, Timestamp time) throws SQLException {
        if (pstmt == null || bgData == null) {
            return;
        }
        pstmt.setBigDecimal(1, this.getFacade().getValue(bgData).setScale(8, 4));
        pstmt.setString(2, userId);
        pstmt.setTimestamp(3, time);
        pstmt.setString(4, orgUnitId);
        pstmt.setString(5, bgData.getFormula());
        pstmt.setInt(6, this.getVersionInnId());
        pstmt.addBatch();
    }
}

