/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.bgcsl.BgExamRefCslTempHistFactory;
import com.kingdee.eas.ma.bgcsl.BgExamRefCslTempHistInfo;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateCollection;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateFactory;
import com.kingdee.eas.ma.bgcsl.BgExamineRefCslTemplateInfo;
import com.kingdee.eas.ma.mbg.BgExamRefBgTempHistFactory;
import com.kingdee.eas.ma.mbg.BgExamRefBgTempHistInfo;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineHistFactory;
import com.kingdee.eas.ma.mbg.BgExamineHistInfo;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineParseException;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgExamineSubsetCollection;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgScopeCollection;
import com.kingdee.eas.ma.mbg.parse.BgExamineFormulaVerifyHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgExamineServelHelper {
    public static final String incorrectNumSet = "incorrectNumSet";
    public static String DEFAULT_VERSION = "1.0";

    public static BgExamineCollection getBgExamineCollectionByIds(Context ctx, String bgSchemeId, Set bgExamineIds) throws BOSException {
        if (ctx == null || bgExamineIds == null || bgExamineIds.isEmpty()) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("hint");
        sic.add("errorData");
        sic.add("noPass");
        sic.add("formula");
        sic.add("bgScope.*");
        sic.add("state");
        sic.add("version");
        sic.add("srcNumbers");
        sic.add("creator.id");
        sic.add("CreateTime");
        sic.add("LastUpdateUser.id");
        sic.add("LastUpdateTime");
        sic.add("enableTime");
        sic.add("enableUser.id");
        sic.add("disableTime");
        sic.add("disableUser.id");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("bgExamineGroup.id");
        sic.add("bgExamineGroup.number");
        sic.add("bgExamineGroup.name");
        sic.add("orgTree.id");
        sic.add("orgTree.number");
        sic.add("orgTree.name");
        sic.add("bgExamineSubset.*");
        sic.add("bgExamineSubset.bgScope.*");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        if (!StringUtils.isEmpty((String)bgSchemeId)) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgExamineIds, CompareType.INCLUDE));
        BgExamineCollection examineInfoColls = BgExamineFactory.getLocalInstance(ctx).getBgExamineCollection(evi);
        return examineInfoColls;
    }

    public static Map<String, String> getVerifyResultMsgByExamineColls(Context ctx, Set<BgExamineInfo> examineInfoSet, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (ctx == null || examineInfoSet == null || examineInfoSet.isEmpty() || schemeHelper == null) {
            return resultMap;
        }
        LinkedHashMap<String, LinkedHashMap<String, String>> bizCalcFormulaMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        LinkedHashMap<String, Map<String, Set<String>>> bizScopeSrcMap = new LinkedHashMap<String, Map<String, Set<String>>>();
        LinkedHashMap<String, Map<String, BgScopeCollection>> bizScopeMap = new LinkedHashMap<String, Map<String, BgScopeCollection>>();
        BgExamineFormulaVerifyHelper.buildParseParam(examineInfoSet, bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper);
        BgExamineFormulaVerifyHelper formulaParser = new BgExamineFormulaVerifyHelper(bizCalcFormulaMap, bizScopeSrcMap, bizScopeMap, schemeHelper, true);
        formulaParser.batchParse();
        HashSet<String> parseErrorNumber = new HashSet<String>();
        for (String number : formulaParser.getAllExceptions().keySet()) {
            Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(number);
            for (Map<Integer, List<Exception>> lineException : subsetException.values()) {
                if (lineException.isEmpty()) continue;
                parseErrorNumber.add(number);
            }
        }
        StringBuffer result = null;
        Object msgRes = null;
        if (!parseErrorNumber.isEmpty()) {
            for (String parseErrorNum : parseErrorNumber) {
                result = new StringBuffer();
                if (formulaParser.getAllExceptions().containsKey(parseErrorNum)) {
                    Map<String, Map<Integer, List<Exception>>> subsetException = formulaParser.getAllExceptions().get(parseErrorNum);
                    for (String subsetName : subsetException.keySet()) {
                        Map<Integer, List<Exception>> lineException = subsetException.get(subsetName);
                        ArrayList<Integer> keyList = new ArrayList<Integer>(lineException.keySet());
                        Collections.sort(keyList);
                        for (Integer line : keyList) {
                            List<Exception> Exceptions = lineException.get(line);
                            for (Exception exception : Exceptions) {
                                result.append(new BgExamineParseException(BgExamineParseException.ERROR_SHOWBIZNAME, new Object[]{parseErrorNum, exception.getMessage()}).getMessage()).append("\r\n");
                            }
                        }
                    }
                }
                resultMap.put(parseErrorNum, result.toString());
            }
        }
        return resultMap;
    }

    public static String combineAllKeysToStr(Map<String, String> verifyResultMsg) {
        if (verifyResultMsg.isEmpty()) {
            return null;
        }
        String calcNum2 = null;
        StringBuffer resultStr = new StringBuffer();
        for (String calcNum2 : verifyResultMsg.keySet()) {
            resultStr.append(verifyResultMsg.get(calcNum2)).append(" ");
        }
        return resultStr.toString();
    }

    public static void addOrgTreeFilter(Context ctx, FilterInfo filter, String orgTreeId) throws BOSException {
        if (ctx == null || filter == null || StringUtils.isEmpty((String)orgTreeId)) {
            return;
        }
        String oql = "select unit.id where tree.id = '" + orgTreeId + "' and unit.isgrouping = 1";
        OrgStructureCollection colls = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(oql);
        if (colls != null && !colls.isEmpty()) {
            HashSet<String> ids = new HashSet<String>();
            for (int index = 0; index < colls.size(); ++index) {
                ids.add(colls.get(index).getUnit().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        }
    }

    @Deprecated
    public static void deleteScopes(Context ctx, String bgExamineId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)bgExamineId)) {
            return;
        }
        Connection connection = null;
        String sql = "delete from T_MBG_BgScope where FBgExamineSubSetID in (select FID from T_MBG_BgExamineSubset where FBgExamineID = ?) ";
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)connection, (String)sql, (Object[])new Object[]{bgExamineId});
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    public static void deleteSubsets(Context ctx, String bgExamineId) throws BOSException {
        if (ctx == null || StringUtils.isEmpty((String)bgExamineId)) {
            return;
        }
        Connection connection = null;
        String sqlScope = "delete from T_MBG_BgScope where FBgExamineSubSetID in (select FID from T_MBG_BgExamineSubset where FBgExamineID = ?) ";
        String sqlSubset = "delete from T_MBG_BgExamineSubSet where FBgExamineID = ?";
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)connection, (String)sqlScope, (Object[])new Object[]{bgExamineId});
            BgDBUtils.executeUpdate((Connection)connection, (String)sqlSubset, (Object[])new Object[]{bgExamineId});
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    @Deprecated
    public static void deleteScopes(Context ctx, Object[] ids) throws BOSException {
        if (ctx == null || ids == null || ids.length == 0) {
            return;
        }
        Object[] bgExamineIds = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            bgExamineIds[i] = String.valueOf(ids[i]);
        }
        Connection connection = null;
        StringBuffer sql = new StringBuffer("delete from T_MBG_BgScope where FBgExamineSubSetID in (select FID from T_MBG_BgExamineSubset where FBgExamineID in ( ");
        int in = bgExamineIds.length;
        for (int i = 0; i < in; ++i) {
            sql.append("?,");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") ");
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)connection, (String)sql.toString(), (Object[])bgExamineIds);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    public static void deleteSubsets(Context ctx, Object[] ids) throws BOSException {
        if (ctx == null || ids == null || ids.length == 0) {
            return;
        }
        Object[] bgExamineIds = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            bgExamineIds[i] = String.valueOf(ids[i]);
        }
        Connection connection = null;
        StringBuffer sqlScope = new StringBuffer("delete from T_MBG_BgScope where FBgExamineSubSetID in (select FID from T_MBG_BgExamineSubset where FBgExamineID in (");
        int in = bgExamineIds.length;
        for (int i = 0; i < in; ++i) {
            sqlScope.append("?,");
        }
        sqlScope.delete(sqlScope.length() - 1, sqlScope.length());
        sqlScope.append("))");
        StringBuffer sqlSubset = new StringBuffer("delete from T_MBG_BgExamineSubSet where FBgExamineID in (");
        int in2 = bgExamineIds.length;
        for (int i = 0; i < in2; ++i) {
            sqlSubset.append("?,");
        }
        sqlSubset.delete(sqlSubset.length() - 1, sqlSubset.length());
        sqlSubset.append(") ");
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            BgDBUtils.executeUpdate((Connection)connection, (String)sqlScope.toString(), (Object[])bgExamineIds);
            BgDBUtils.executeUpdate((Connection)connection, (String)sqlSubset.toString(), (Object[])bgExamineIds);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Set<String>> queryRefExamine(Context ctx, Connection conn, TempTablePool pool, Collection<String> billIds) throws BOSException, EASBizException {
        TempTablePool _pool;
        HashMap<String, Set<String>> examines = new HashMap<String, Set<String>>();
        if (conn == null) return examines;
        if (billIds == null) return examines;
        if (billIds.isEmpty()) {
            return examines;
        }
        boolean isBgAdjustBill = false;
        String _tmpTableName = null;
        Set<String> examineSet = null;
        TempTablePool tempTablePool = _pool = pool != null ? pool : TempTablePool.getInstance((Context)ctx);
        if (_pool == null) {
            return examines;
        }
        HashSet<String> bosSet = new HashSet<String>();
        String bosType222 = null;
        for (String string : billIds) {
            bosType222 = BOSUuid.read((String)string).getType().toString();
            bosSet.add(bosType222);
            if (!"210CFD59".equals(bosType222)) continue;
            isBgAdjustBill = true;
        }
        if (isBgAdjustBill) {
            List adjExamines = BgExamineFacadeFactory.getLocalInstance(ctx).canExamineByAdjustBill(new ArrayList<String>(billIds));
            if (adjExamines == null) return null;
            if (adjExamines.isEmpty()) return null;
            examineSet = new HashSet(adjExamines);
            Iterator<String> iterator = billIds.iterator();
            while (iterator.hasNext()) {
                String billId = iterator.next();
                examines.put(billId, examineSet);
            }
            return examines;
        }
        IRowSet rst = null;
        Iterator iterator = bosSet.iterator();
        while (iterator.hasNext()) {
            bosType222 = (String)iterator.next();
            try {
                _tmpTableName = _pool.createDBSystemTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))", conn);
                if (_tmpTableName == null) {
                    HashMap<String, Set<String>> billId = examines;
                    return billId;
                }
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + _tmpTableName + " (FID) values (?)"), billIds);
                StringBuffer sql2332 = new StringBuffer();
                if ("3BA5F027".equals(bosType222)) {
                    sql2332.append("select f.FID, t.FBgExamineID from T_MBG_BgExamineRefBgTemplate t  join T_MBG_BgExamine e on t.FBgExamineID = e.FID  join T_MBG_BgForm f on t.FBgTemplateID = f.FBgTemplateID ");
                } else if ("655ADD42".equals(bosType222)) {
                    sql2332.append("select f.FID, t.FBgExamineID from T_MBG_BgExamineRefcslTemplate t  join T_MBG_BgExamine e on t.FBgExamineID = e.FID  join T_MBG_BgCslForm f on t.FTemplateID = f.FBgCslTemplateID ");
                } else if ("9E7BD5E2".equals(bosType222)) {
                    sql2332.append("select f.FID, t.FBgExamineID from T_MBG_BgExamineRefcslTemplate t  join T_MBG_BgExamine e on t.FBgExamineID = e.FID  join T_MBG_MbgWorkPaper f on t.FTemplateID = f.FWorkTemplateID ");
                } else if ("AD34C4CD".equals(bosType222)) {
                    sql2332.append("select f.FID, t.FBgExamineID from T_MBG_BgExamineRefcslTemplate t  join T_MBG_BgExamine e on t.FBgExamineID = e.FID  join T_MBG_BgCslAdjForm f on t.FTemplateID = f.FBgCslTemplateID ");
                }
                sql2332.append(" where exists (select FID from " + _tmpTableName + " where FID = f.FID) and e.FState = " + 1);
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql2332.toString());
                while (rst.next()) {
                    if (examines.containsKey(rst.getString("FID"))) {
                        examineSet = (Set)examines.get(rst.getString("FID"));
                    } else {
                        examineSet = new HashSet();
                        examines.put(rst.getString("FID"), examineSet);
                    }
                    examineSet.add(rst.getString("FBgExamineID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            if (_tmpTableName == null || _pool == null) continue;
            try {
                _pool.releaseDBSystemTempTable(_tmpTableName, conn);
            }
            catch (Exception sql2332) {}
        }
        return examines;
        finally {
            SQLUtils.cleanup(rst);
            if (_tmpTableName != null && _pool != null) {
                try {
                    _pool.releaseDBSystemTempTable(_tmpTableName, conn);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void removeScopeFromResult(BgExamineResult result) {
        List<BgExamineInfo> examines = result.examines;
        BgExamineSubsetCollection subsetColls = null;
        BgExamineSubsetInfo subsetInfo = null;
        if (examines != null && !examines.isEmpty()) {
            for (int i = 0; i < examines.size(); ++i) {
                BgExamineInfo examineInfo = examines.get(i);
                examineInfo.remove("bgScope");
                subsetColls = examineInfo.getBgExamineSubset();
                if (subsetColls == null || subsetColls.isEmpty()) continue;
                for (int j = 0; j < subsetColls.size(); ++j) {
                    subsetInfo = subsetColls.get(j);
                    subsetInfo.remove("bgScope");
                }
            }
        }
    }

    public static void updateHist(Context ctx, String id) throws BOSException {
        HashSet<String> rmSet = new HashSet<String>();
        rmSet.add(id);
        BgExamineServelHelper.updateHist(ctx, rmSet);
    }

    public static void updateHist(Context ctx, Set<String> rmSet) throws BOSException {
        if (rmSet == null || rmSet.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MBG_BgExamineHist set FIsDelete = 1, FDELETETIME = now() where FsourceBgExamineid in ( ");
        for (String id : rmSet) {
            sql.append("'").append(id).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" )");
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)sql.toString());
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void addHist(Context ctx, CoreBaseCollection updateColls, boolean isDelete, boolean isFromCancel) throws EASBizException, BOSException {
        if (updateColls.isEmpty()) {
            return;
        }
        CoreBaseCollection histColls = new CoreBaseCollection();
        CoreBaseCollection refHistCols = new CoreBaseCollection();
        HashMap<BOSUuid, Set<BgExamineRefBgTemplateInfo>> refTpts = new HashMap<BOSUuid, Set<BgExamineRefBgTemplateInfo>>();
        CoreBaseCollection refCslHistCols = new CoreBaseCollection();
        HashMap<BOSUuid, Set<BgExamineRefCslTemplateInfo>> refCslTpts = new HashMap<BOSUuid, Set<BgExamineRefCslTemplateInfo>>();
        HashSet<String> ids = new HashSet<String>();
        int in = updateColls.size();
        for (int i = 0; i < in; ++i) {
            ids.add(updateColls.get(i).getId().toString());
        }
        BgExamineServelHelper.getRefBgCslTemplateByBizCalc(ctx, ids, refCslTpts);
        BgExamineServelHelper.getRefTemplateByBgExamine(ctx, ids, refTpts);
        DecimalFormat format = new DecimalFormat("#0.0");
        int in2 = updateColls.size();
        for (int i = 0; i < in2; ++i) {
            String tarVersion;
            BgExamineInfo tmpCalcInfo = (BgExamineInfo)updateColls.get(i);
            BgExamineHistInfo hisInfo = new BgExamineHistInfo();
            hisInfo.clone(tmpCalcInfo);
            hisInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
            hisInfo.setEnableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            hisInfo.setDeleteTime(new Timestamp(System.currentTimeMillis()));
            hisInfo.setDeleteUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            hisInfo.setIsDelete(isDelete);
            histColls.add((CoreBaseInfo)hisInfo);
            String version = tmpCalcInfo.getVersion();
            String string = tarVersion = version == null ? DEFAULT_VERSION : format.format((double)Float.parseFloat(version) + 0.1);
            if (isFromCancel) {
                if (version == null && tarVersion.equals(DEFAULT_VERSION)) {
                    hisInfo.setVersion(tarVersion);
                    tmpCalcInfo.setVersion(tarVersion);
                } else {
                    hisInfo.setVersion(version);
                    tmpCalcInfo.setVersion(version);
                }
                tmpCalcInfo.setDisableTime(new Timestamp(System.currentTimeMillis()));
                tmpCalcInfo.setDisableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            } else {
                hisInfo.setVersion(tarVersion);
                tmpCalcInfo.setVersion(tarVersion);
                tmpCalcInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
                tmpCalcInfo.setEnableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                if (tarVersion.equals(DEFAULT_VERSION)) {
                    hisInfo.setDisableTime(new Timestamp(System.currentTimeMillis()));
                    hisInfo.setDisableUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                }
            }
            if (refTpts.containsKey(tmpCalcInfo.getId())) {
                Set set = (Set)refTpts.get(tmpCalcInfo.getId());
                for (BgExamineRefBgTemplateInfo refTptInfo : set) {
                    BgExamRefBgTempHistInfo refTptHistInfo = new BgExamRefBgTempHistInfo();
                    refTptHistInfo.setBgExamine(hisInfo);
                    refTptHistInfo.setBgTemplate(refTptInfo.getBgTemplate());
                    refHistCols.add((CoreBaseInfo)refTptHistInfo);
                }
            }
            if (!refCslTpts.containsKey(tmpCalcInfo.getId())) continue;
            Set refCsltpts = (Set)refCslTpts.get(tmpCalcInfo.getId());
            for (BgExamineRefCslTemplateInfo info : refCsltpts) {
                BgExamRefCslTempHistInfo refCslTptInfo = new BgExamRefCslTempHistInfo();
                refCslTptInfo.setBgExamineID(hisInfo.getId());
                refCslTptInfo.setTemplateID(info.getTemplateID());
                refCslTptInfo.setType(info.getType());
                refCslHistCols.add((CoreBaseInfo)refCslTptInfo);
            }
        }
        BgExamineHistFactory.getLocalInstance(ctx).saveBatchData(histColls);
        BgExamRefBgTempHistFactory.getLocalInstance(ctx).saveBatchData(refHistCols);
        BgExamRefCslTempHistFactory.getLocalInstance((Context)ctx).saveBatchData(refCslHistCols);
    }

    private static Map<BOSUuid, Set<BgExamineRefCslTemplateInfo>> getRefBgCslTemplateByBizCalc(Context ctx, Set<String> bizCalcIds, Map<BOSUuid, Set<BgExamineRefCslTemplateInfo>> result) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("bgExamineID"));
        evi.getSelector().add(new SelectorItemInfo("templateID"));
        evi.getSelector().add(new SelectorItemInfo("type"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgExamineID", bizCalcIds, CompareType.INCLUDE));
        evi.setFilter(filter);
        BgExamineRefCslTemplateCollection refCols = BgExamineRefCslTemplateFactory.getLocalInstance((Context)ctx).getBgExamineRefCslTemplateCollection(evi);
        if (refCols == null || refCols.isEmpty()) {
            return result;
        }
        int in = refCols.size();
        for (int i = 0; i < in; ++i) {
            BgExamineRefCslTemplateInfo refTptInfo = refCols.get(i);
            if (!result.containsKey(refTptInfo.getBgExamineID())) {
                result.put(refTptInfo.getBgExamineID(), new HashSet());
            }
            result.get(refTptInfo.getBgExamineID()).add(refTptInfo);
        }
        return result;
    }

    public static void getRefTemplateByBgExamine(Context ctx, Set<String> ids, Map<BOSUuid, Set<BgExamineRefBgTemplateInfo>> result) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("bgexamine"));
        evi.getSelector().add(new SelectorItemInfo("bgTemplate"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgexamine.id", ids, CompareType.INCLUDE));
        evi.setFilter(filter);
        BgExamineRefBgTemplateCollection refCols = BgExamineRefBgTemplateFactory.getLocalInstance(ctx).getBgExamineRefBgTemplateCollection(evi);
        if (refCols == null || refCols.isEmpty()) {
            return;
        }
        int in = refCols.size();
        for (int i = 0; i < in; ++i) {
            BgExamineRefBgTemplateInfo refTptInfo = refCols.get(i);
            if (!result.containsKey(refTptInfo.getBgExamine().getId())) {
                result.put(refTptInfo.getBgExamine().getId(), new HashSet());
            }
            result.get(refTptInfo.getBgExamine().getId()).add(refTptInfo);
        }
    }
}

