/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.base.app.utils.BgRefDimMemberHelper;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgGatherFactory;
import com.kingdee.eas.ma.mbg.BgGatherInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFacadeHelper {
    private static final Logger logger = Logger.getLogger(BgFacadeHelper.class);

    public static void saveBgDataRef(Context ctx, String cubeName, BgSchemeDimensionHelper schemeHelper, BgFormInfo model, ViewListMemberCacheHelper memberCacheHelper) throws EASBizException, BOSException {
        String cubeEntryName = BgCubeUtils.getBudgetEntryCubeName(cubeName);
        if (BgSchemeConvertToAccIntUtils.isUseAccInt(model.getBgScheme(), cubeName)) {
            BgFacadeHelper.saveBgDataRef(ctx, cubeName, cubeEntryName, schemeHelper, model, memberCacheHelper, new HashSet<String>(BgSchemeConvertToAccIntUtils.querySplit(ctx, cubeName).values()), true);
        } else {
            BgFacadeHelper.saveBgDataRef(ctx, cubeName, cubeEntryName, schemeHelper, model, memberCacheHelper, null, false);
        }
    }

    public static Map<String, String> readBaseDataMap(Connection conn, String tableName, String keyField, String filterField, String filterValue) throws SQLException {
        Map<String, Integer> baseDataMap = BgSchemeConvertToAccIntUtils.readBaseDataMap(conn, tableName, keyField, filterField, filterValue);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String id : baseDataMap.keySet()) {
            result.put(String.valueOf(baseDataMap.get(id)), id);
        }
        return result;
    }

    public static void saveBgDataRef(Context ctx, String cubeName, String cubeEntryName, BgSchemeDimensionHelper schemeHelper, BgFormInfo model, ViewListMemberCacheHelper memberCacheHelper, Set<String> splitCube, final boolean isUseInt) throws EASBizException, BOSException {
        if (model == null || StringUtils.isEmpty((String)cubeName)) {
            return;
        }
        if (splitCube == null) {
            splitCube = new HashSet<String>();
            splitCube.add(cubeName);
        }
        final HashMap<String, String> eleIntIdMap = new HashMap<String, String>();
        final HashMap<String, String> perIntIdMap = new HashMap<String, String>();
        if (isUseInt) {
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                eleIntIdMap.putAll(BgFacadeHelper.readBaseDataMap(conn, "T_MBG_BgElement", "FID", null, null));
                perIntIdMap.putAll(BgFacadeHelper.readBaseDataMap(conn, "T_MBG_BgPeriod", "FID", null, null));
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        String bgSchemeId = model.getBgScheme().getId().toString();
        String orgUnitId = model.getOrgUnit().getId().toString();
        String bgFormId = model.getId().toString();
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId);
        if (schemeHelper == null) {
            schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        }
        if (memberCacheHelper == null) {
            memberCacheHelper = new ViewListMemberCacheHelper();
            memberCacheHelper.setCtx(ctx);
            memberCacheHelper.setSchemeHelper(schemeHelper);
        }
        memberCacheHelper.setQueryId(true);
        final HashSet scenarioIds = new HashSet();
        final HashSet<String> baseDataIds = new HashSet<String>();
        for (String cube : splitCube) {
            MbgSqlHelper.executeBatchQuery((Context)ctx, (String)("Select distinct FBgPeriodID, FBgElementID, FCurrencyID, FScenario FROM " + cube + " Where FID IN(Select FDataId FROM " + cubeEntryName + " Where FFormId = ?)"), bgFormIds, (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    if (isUseInt) {
                        baseDataIds.add(perIntIdMap.get(res.getString("FBgPeriodID")));
                        baseDataIds.add(eleIntIdMap.get(res.getString("FBgElementID")));
                    } else {
                        baseDataIds.add(res.getString("FBgPeriodID"));
                        baseDataIds.add(res.getString("FBgElementID"));
                    }
                    baseDataIds.add(res.getString("FCurrencyID"));
                    scenarioIds.add(res.getInt("FScenario"));
                }
            });
        }
        if (!scenarioIds.isEmpty()) {
            StringBuffer sql = new StringBuffer("Select FID FROM T_MBg_BgScenario Where FScenarioId IN (");
            int oneBatchCount = 0;
            if (scenarioIds.size() > 50) {
                oneBatchCount = 50;
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            } else {
                oneBatchCount = scenarioIds.size();
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)scenarioIds.size()).append(")");
            }
            MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParamsForNumber(null, (Object[])scenarioIds.toArray(), (int)oneBatchCount), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    baseDataIds.add(res.getString("FID"));
                }
            });
            final HashMap queryMaps = new HashMap();
            for (String cube : splitCube) {
                MbgSqlHelper.executeBatchQuery((Context)ctx, (String)("Select distinct FBgItemCombination FROM " + cube + " Where FID IN(Select FDataId FROM " + cubeEntryName + " Where FFormId = ?)"), bgFormIds, (IResultReader)new IResultReader(){

                    public void read(ResultSet res) throws SQLException {
                        String[] itemComb = DimensionFormulaHelper.splitCombinations(res.getString("FBgItemCombination"));
                        for (int i = 0; i < itemComb.length; ++i) {
                            String srcNumber = DimensionFormulaHelper.getSrcNumber(itemComb[i]);
                            String number = DimensionFormulaHelper.getMemberNumber(itemComb[i]);
                            if (!queryMaps.containsKey(srcNumber)) {
                                queryMaps.put(srcNumber, new HashMap());
                            }
                            ((Map)queryMaps.get(srcNumber)).put(number, new BgDimensionMember(srcNumber, srcNumber, null, number));
                        }
                    }
                });
            }
            Map<String, BgDimensionInfo> dimensions = schemeHelper.getDimensionBySrcNumber();
            BgDimensionMember member2 = null;
            for (String srcNumber : queryMaps.keySet()) {
                Map members = (Map)queryMaps.get(srcNumber);
                memberCacheHelper.updateMemberName(orgUnitId, dimensions.get(srcNumber).getNumber(), members);
                for (BgDimensionMember member2 : members.values()) {
                    if (member2.getName() == null) continue;
                    baseDataIds.add(member2.getName());
                }
            }
        }
        ArrayList<String[]> baseDatas = new ArrayList<String[]>();
        Iterator it = baseDataIds.iterator();
        while (it.hasNext()) {
            baseDatas.add(new String[]{(String)it.next(), orgUnitId});
        }
        BgRefDimMemberHelper.saveRef((Context)ctx, (String)bgSchemeId, (BgRefDimMemberEnum)BgRefDimMemberEnum.BgData, (String)bgFormId, baseDatas);
    }

    public static void saveViewRef1(Context ctx, BgSchemeDimensionHelper schemeHelper, String refId, String orgUnitId, BgRefDimMemberEnum refType, IMbgViewBase view, boolean saveMapRelation) throws EASBizException, BOSException {
        if (view instanceof IMbgViewManager) {
            BgFacadeHelper.saveViewRef(ctx, schemeHelper, refId, orgUnitId, refType, (IMbgViewManager)view, saveMapRelation);
        } else if (view instanceof MbgViewListManager) {
            BgFacadeHelper.saveViewListRef(ctx, schemeHelper, refId, orgUnitId, refType, (MbgViewListManager)view);
        }
    }

    public static void saveViewRef(Context ctx, String bgSchemeId, String refId, String orgUnitId, BgRefDimMemberEnum refType, IMbgViewBase view, boolean saveMapRelation) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        BgFacadeHelper.saveViewRef1(ctx, schemeHelper, refId, orgUnitId, refType, view, saveMapRelation);
    }

    private static void saveViewListRef(Context ctx, BgSchemeDimensionHelper schemeHelper, String refId, String orgUnitId, BgRefDimMemberEnum refType, MbgViewListManager view) throws EASBizException, BOSException {
        BgDimensionMember member2;
        Set subSet;
        if (StringUtils.isEmpty((String)refId) || view == null) {
            return;
        }
        HashMap dimMembers = new HashMap();
        HashSet<String> otherIds = new HashSet<String>();
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimensions.addAll(((MbgViewListSheetManager)view.getSheetManagers().get(s)).getDimensionManager().getAllDimensions());
        }
        for (int d = 0; d < dimensions.size(); ++d) {
            MbgViewListDimensionInfo dimension = (MbgViewListDimensionInfo)dimensions.get(d);
            if (DimensionMemberValueModeEnum.All.equals((Object)dimension.getMemberValueType())) continue;
            ArrayList members = new ArrayList();
            members.addAll(dimension.getSelectMembers());
            members.addAll(dimension.getMember());
            for (int m = 0; m < members.size(); ++m) {
                if (members.get(m) instanceof CoreBaseInfo) {
                    if (members.get(m) instanceof BgPeriodInfo) {
                        BgPeriodInfo info = (BgPeriodInfo)members.get(m);
                        if (!dimMembers.containsKey(dimension.getNumber())) {
                            dimMembers.put(dimension.getNumber(), new HashSet());
                        }
                        subSet = (Set)dimMembers.get(dimension.getNumber());
                        subSet.add(info.getNumber());
                        continue;
                    }
                    CoreBaseInfo baseInfo = (CoreBaseInfo)members.get(m);
                    if (baseInfo.getId() == null) continue;
                    otherIds.add(baseInfo.getId().toString());
                    continue;
                }
                if (!(members.get(m) instanceof BgDimensionMember)) continue;
                member2 = (BgDimensionMember)members.get(m);
                if (!dimMembers.containsKey(dimension.getNumber())) {
                    dimMembers.put(dimension.getNumber(), new HashSet());
                }
                subSet = (Set)dimMembers.get(dimension.getNumber());
                subSet.add(member2.getNumber());
            }
        }
        List<IMbgViewListObject> rowCols = view.getRowCols();
        MbgViewListRowCol rowCol = null;
        String[] types = null;
        String[] numbers = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol) || !(rowCol = (MbgViewListRowCol)rowCols.get(i)).isCombin()) continue;
            for (int m = 0; m < rowCol.getCombinMembers().size(); ++m) {
                member2 = rowCol.getCombinMembers().get(m);
                types = member2.getType().split(",", -1);
                numbers = member2.getNumber().split(",", -1);
                for (int t = 0; t < types.length; ++t) {
                    if (!dimMembers.containsKey(types[t])) {
                        dimMembers.put(types[t], new HashSet());
                    }
                    subSet = (Set)dimMembers.get(types[t]);
                    if (numbers.length <= t) continue;
                    subSet.add(numbers[t]);
                }
            }
        }
        MbgViewListSheetManager sheet = null;
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            sheet = (MbgViewListSheetManager)view.getSheetManagers().get(s);
            for (int d = 0; d < sheet.getDimensionManager().getDimension().size(); ++d) {
                if (!(sheet.getDimensionManager().getDimension().get(d) instanceof MbgViewListAtribute) || ((MbgViewListAtribute)sheet.getDimensionManager().getDimension().get(d)).getPropertySort().getId() == null) continue;
                otherIds.add(((MbgViewListAtribute)sheet.getDimensionManager().getDimension().get(d)).getPropertySort().getId().toString());
            }
        }
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        Iterator it = otherIds.iterator();
        while (it.hasNext()) {
            paramList.add(new String[]{(String)it.next(), orgUnitId});
        }
        for (String dimNumber : dimMembers.keySet()) {
            subSet = (Set)dimMembers.get(dimNumber);
            Map baseDatas = DimensionFormulaFacadeFactory.getLocalInstance(ctx).queryMembers(orgUnitId, schemeHelper, dimNumber, subSet, true, null);
            if (baseDatas == null || baseDatas.isEmpty()) continue;
            for (BgDimensionMember member2 : baseDatas.values()) {
                paramList.add(new String[]{member2.getSortValue().toString(), orgUnitId});
            }
        }
        BgRefDimMemberHelper.saveRef((Context)ctx, (String)schemeHelper.getBgSchemeId(), (BgRefDimMemberEnum)refType, (String)refId, paramList);
    }

    public static void saveViewRef(Context ctx, BgSchemeDimensionHelper schemeHelper, String refId, String orgUnitId, BgRefDimMemberEnum refType, IMbgViewManager view, boolean saveMapRelation) throws EASBizException, BOSException {
        Set subSet;
        if (StringUtils.isEmpty((String)refId) || view == null) {
            return;
        }
        HashMap dimMembers = new HashMap();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            IBgDimensionManager dimManager = view.getSheetManagers().get(s).getDimensionManager();
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                BgDimensionInfo dimension = (BgDimensionInfo)dimManager.getDimension().get(d);
                if (DimensionMemberValueModeEnum.All.equals((Object)dimension.getMemberValueType()) || !saveMapRelation && DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
                for (int m = 0; m < dimension.getMember().size(); ++m) {
                    BgDimensionMember member = (BgDimensionMember)dimension.getMember().get(m);
                    if (!dimMembers.containsKey(dimension.getNumber())) {
                        dimMembers.put(dimension.getNumber(), new HashSet());
                    }
                    subSet = (Set)dimMembers.get(dimension.getNumber());
                    subSet.add(member.getNumber());
                }
            }
        }
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        for (String dimNumber : dimMembers.keySet()) {
            subSet = (Set)dimMembers.get(dimNumber);
            Map baseDatas = DimensionFormulaFacadeFactory.getLocalInstance(ctx).queryMembers(orgUnitId, schemeHelper, dimNumber, subSet, true, null);
            if (baseDatas == null || baseDatas.isEmpty()) continue;
            for (BgDimensionMember member : baseDatas.values()) {
                paramList.add(new String[]{member.getSortValue().toString(), orgUnitId});
            }
        }
        BgRefDimMemberHelper.saveRef((Context)ctx, (String)schemeHelper.getBgSchemeId(), (BgRefDimMemberEnum)refType, (String)refId, paramList);
    }

    public static void saveBgTemplateRef(Context ctx, String bgTemplateId, IMbgViewBase view) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"Select FBgSchemeId, FOrgUnitId FROM T_MBg_BgTemplate Where FID = ?", (Object[])new Object[]{bgTemplateId});
        try {
            if (rs.next()) {
                BgFacadeHelper.saveViewRef(ctx, rs.getString("FBgSchemeId"), bgTemplateId, rs.getString("FOrgUnitId"), BgRefDimMemberEnum.BgTemplate, view, false);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void deleteRef(Context ctx, String refId) throws BOSException {
        BgRefDimMemberHelper.deleteRef((Context)ctx, (String)refId);
    }

    public static void deleteRef(Context ctx, List<String> refId) throws BOSException {
        BgRefDimMemberHelper.deleteRef((Context)ctx, refId);
    }

    public static void saveFixelViewRef(Context ctx, String bgFormId, String orgUnitId, String bgTemplateId) throws BOSException {
        BgRefDimMemberHelper.copyRefForFixelForm((Context)ctx, (String)bgFormId, (String)orgUnitId, (String)bgTemplateId);
    }

    public static void saveGatherInfos(final Context ctx, final List<BgGatherInfo> gatherInfos) {
        if (ctx == null || gatherInfos == null || gatherInfos.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    BgFacadeHelper.innerSaveGatherInfos(ctx, gatherInfos);
                }
                catch (Exception e) {
                    logger.error((Object)"SaveGatherInfos In Theead", (Throwable)e);
                }
            }
        };
        thread.start();
    }

    private static void innerSaveGatherInfos(Context ctx, List<BgGatherInfo> gatherInfos) throws EASBizException, BOSException {
        if (ctx == null || gatherInfos == null || gatherInfos.isEmpty()) {
            return;
        }
        HashSet<String> formulaSet = new HashSet<String>();
        for (BgGatherInfo info : gatherInfos) {
            formulaSet.add(info.getFormula());
        }
        HashMap<String, DimensionMemberCheckHelper> checkHelpers = new HashMap<String, DimensionMemberCheckHelper>();
        DimensionMemberCheckHelper helper = null;
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
        HashSet<String> formulaKeys = new HashSet<String>();
        CoreBaseCollection saveCol = new CoreBaseCollection();
        String formulaKey = null;
        Object[] param = null;
        BgSchemeDimensionHelper schemeHelper = null;
        for (BgGatherInfo info : gatherInfos) {
            if (schemeHelper == null) {
                schemeHelper = new BgSchemeDimensionHelper(ctx, info.getBgSchemeId().toString());
            }
            if (!checkHelpers.containsKey(info.getOrgUnitId().toString())) {
                checkHelpers.put(info.getOrgUnitId().toString(), DimensionMemberCheckHelper.getLocalIntance(ctx, null, info.getOrgUnitId().toString(), null, schemeHelper, formulaSet, true));
            }
            if (!(helper = (DimensionMemberCheckHelper)checkHelpers.get(info.getOrgUnitId().toString())).canSave(info.getFormula(), null, null)) continue;
            param = new Object[]{info.getBgSchemeId().toString(), info.getOrgUnitId().toString(), info.getFormula(), info.getVersionId(), info.getType()};
            formulaKey = Arrays.toString(param);
            if (!formulaKeys.contains(formulaKey)) {
                deleteParams.add(param);
            } else {
                formulaKeys.add(formulaKey);
            }
            if (info.getSourceOrgUnitId() == null) continue;
            saveCol.add((CoreBaseInfo)info);
        }
        DbUtil.executeBatch((Context)ctx, (String)"Delete FROM T_MBG_BgGather Where FBgSchemeId = ? AND FOrgUnitId = ? AND FFormula = ? AND FVersionId = ? AND FType = ?", deleteParams);
        BgGatherFactory.getLocalInstance(ctx).addnewBatchData(saveCol);
    }
}

