/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.MbgConvertExcelFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BgFormExportServerThread {
    private static Logger logger = Logger.getLogger((String)BgFormExportServerThread.class.getName());
    private String fileFormat = ".xlsx";
    private static int availableProcessors = Runtime.getRuntime().availableProcessors();
    private static int CALC_DEFAULT_POOLSIZE = availableProcessors / 2 + 1;
    private Context ctx = null;
    private String bgOrgViewId = null;
    private Map<String, Set<String>> bgFormMap = null;
    private String exportPath = null;

    public BgFormExportServerThread(Context ctx, String bgOrgViewId, Map<String, Set<String>> bgFormMap, String exportPath) {
        this.ctx = ctx;
        this.bgOrgViewId = bgOrgViewId;
        this.bgFormMap = bgFormMap;
        this.exportPath = exportPath;
    }

    public Map<String, Boolean> export() throws BOSException {
        Hashtable<String, Boolean> resultMap = new Hashtable<String, Boolean>();
        if (this.ctx == null || this.bgFormMap == null || this.bgFormMap.isEmpty() || StringUtils.isEmpty((String)this.bgOrgViewId) || StringUtils.isEmpty((String)this.exportPath)) {
            return resultMap;
        }
        try {
            int optimalPoolSize = BgFormExportServerThread.getOptimalPoolSize(this.ctx);
            if (optimalPoolSize >= this.bgFormMap.keySet().size()) {
                optimalPoolSize = this.bgFormMap.keySet().size();
            }
            logger.error((Object)("BgFormExportServerThread POOL_SIZE is: " + optimalPoolSize));
            Map<String, String> orgFilePathMap = this.getOrgFilePath(this.bgOrgViewId, this.exportPath);
            if (optimalPoolSize == 1 || this.bgFormMap.keySet().size() == 1) {
                for (String orgId : this.bgFormMap.keySet()) {
                    Map<String, Boolean> result = this.exportOrgUnitFile(this.ctx, orgId, this.bgFormMap.get(orgId), orgFilePathMap.get(orgId));
                    resultMap.putAll(result);
                }
            } else {
                ArrayList<Future<Map<String, Boolean>>> lst = new ArrayList<Future<Map<String, Boolean>>>();
                ExecutorService threadPool = Executors.newFixedThreadPool(optimalPoolSize);
                for (String orgId : this.bgFormMap.keySet()) {
                    ExportBgForms exportCall = new ExportBgForms(orgId, this.bgFormMap.get(orgId), orgFilePathMap.get(orgId));
                    Future<Map<String, Boolean>> result = threadPool.submit(exportCall);
                    lst.add(result);
                }
                threadPool.shutdown();
                for (int i = 0; i < lst.size(); ++i) {
                    resultMap.putAll((Map)((Future)lst.get(i)).get());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resultMap;
    }

    public Map<String, String> getOrgFilePath(String bgOrgViewId, String exportPath) throws EASBizException, BOSException {
        HashMap<String, String> orgFilePathMap = new HashMap<String, String>();
        TreeModel model = BgOrgUnitFactory.getLocalInstance(this.ctx).getFullBgOrgModel(bgOrgViewId, null, false, false, false, true, false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
        this.getFilePath(orgFilePathMap, root, exportPath);
        return orgFilePathMap;
    }

    public void getFilePath(Map<String, String> orgFilePathMap, DefaultKingdeeTreeNode root, String filePath) {
        BgOrgUnitInfo bgOrgUnitInfo = null;
        String orgFilePath = null;
        if (root.getUserObject() instanceof BgOrgUnitInfo) {
            bgOrgUnitInfo = (BgOrgUnitInfo)root.getUserObject();
            if (!StringUtils.isEmpty((String)bgOrgUnitInfo.getName()) && !StringUtils.isEmpty((String)bgOrgUnitInfo.getOrgUnitID())) {
                orgFilePath = filePath + File.separator + bgOrgUnitInfo.getName().replaceAll(" ", "");
                orgFilePathMap.put(bgOrgUnitInfo.getOrgUnitID(), orgFilePath);
            } else {
                orgFilePath = filePath;
            }
            if (root.getChildCount() > 0) {
                int in = root.getChildCount();
                for (int i = 0; i < in; ++i) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                    this.getFilePath(orgFilePathMap, node, orgFilePath);
                }
            }
        }
    }

    protected void exportDirectory(String filepath) throws Exception {
        if (StringUtils.isEmpty((String)filepath)) {
            return;
        }
        String codeStr = BgFormExportServerThread.getEncode(this.ctx);
        File _file = null;
        _file = !StringUtils.isEmpty((String)codeStr) ? new File(new String(filepath.getBytes(codeStr))) : new File(filepath);
        logger.error((Object)("exportDirectory filePatch : " + _file.getPath()));
        if (!_file.exists()) {
            boolean ismk = false;
            try {
                ismk = _file.mkdirs();
                logger.error((Object)("ismk value is :" + ismk));
                logger.error((Object)("file path is : " + _file.getPath()));
                File[] dirfiles = _file.listFiles();
                if (dirfiles != null && dirfiles.length > 0) {
                    for (int i = 0; i < dirfiles.length; ++i) {
                        logger.error((Object)("server get file path is  " + dirfiles[i].getName()));
                    }
                } else if (_file.getParentFile() != null && _file.getParentFile().listFiles() != null && _file.getParentFile().listFiles().length > 0) {
                    for (int i = 0; i < _file.getParentFile().listFiles().length; ++i) {
                        logger.error((Object)("server get file path is  " + _file.getParentFile().listFiles()[i].getName()));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> exportOrgUnitFile(Context ctx, String orgId, Set<String> bgFormIds, String orgFilePath) throws Exception {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (bgFormIds == null || bgFormIds.isEmpty() || StringUtils.isEmpty((String)orgFilePath)) {
            result.put(orgId, Boolean.FALSE);
            return result;
        }
        String codeStr = BgFormExportServerThread.getEncode(ctx);
        this.exportDirectory(orgFilePath);
        for (String bgFormId : bgFormIds) {
            BgFormInfo info = new BgFormInfo();
            info = info.getInfo(ctx, BOSUuid.read((String)bgFormId));
            byte[] datas = (byte[])MbgConvertExcelFacadeFactory.getLocalInstance(ctx).convert(BOSUuid.read((String)bgFormId));
            if (datas == null) continue;
            FilterOutputStream os = null;
            Charset charset = Charset.defaultCharset();
            logger.error((Object)("Charset.defaultCharset() is " + charset));
            try {
                String fileName = this.getFileName(info, (OrgUnitInfo)info.getOrgUnit());
                String exportFileName = orgFilePath + File.separator + fileName;
                File file = null;
                file = !StringUtils.isEmpty((String)codeStr) ? new File(new String(exportFileName.getBytes(codeStr))) : new File(exportFileName);
                if (!file.isFile() && !file.createNewFile()) continue;
                os = new BufferedOutputStream(new FileOutputStream(file));
                XSSFWorkbook book = new XSSFWorkbook(ZipUtil.unpack((byte[])datas));
                book.write((OutputStream)os);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
        result.put(orgId, Boolean.TRUE);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOptimalPoolSize(Context ctx) throws Exception {
        int poolSize = CALC_DEFAULT_POOLSIZE;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FVALUE FROM T_MBg_PARAM where FNUMBER = ?");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{"CALC_POOL_SIZE"});
            if (rst.next()) {
                poolSize = Integer.parseInt(rst.getString("FVALUE"));
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncode(Context ctx) throws Exception {
        String codeString = "";
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FVALUE FROM T_MBg_PARAM where FNUMBER = ?");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{"ENCODE"});
            if (rst.next()) {
                codeString = rst.getString("FVALUE");
            }
            SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return codeString;
    }

    private String getFileName(BgFormInfo _bgFormInfo, OrgUnitInfo orgUnitInfo) {
        StringBuffer filename = new StringBuffer();
        filename = new StringBuffer();
        filename.append(orgUnitInfo.getName().trim());
        filename.append("_");
        filename.append(_bgFormInfo.getBgScheme().getName().trim());
        filename.append("_");
        filename.append(_bgFormInfo.getNumber().trim());
        filename.append("_");
        filename.append(_bgFormInfo.getBgTemplate().getName().trim());
        filename.append("_");
        filename.append(_bgFormInfo.getBgPeriod().getName().trim());
        filename.append("_");
        filename.append(_bgFormInfo.getCurrency().getName().trim());
        filename.append("_");
        filename.append(_bgFormInfo.getBgVersion().getName().trim());
        if (!BgProcessEnum.C01.equals((Object)_bgFormInfo.getProcessType())) {
            filename.append("_");
            filename.append(_bgFormInfo.getProcessType().getAlias());
        }
        filename.append(this.fileFormat);
        return filename.toString();
    }

    private class ExportBgForms
    implements Callable<Map<String, Boolean>> {
        private String orgId = null;
        private Set<String> bgFormIds = null;
        private String exportPath = null;

        public ExportBgForms(String orgId, Set<String> bgFormIds, String exportPath) {
            this.orgId = orgId;
            this.bgFormIds = bgFormIds;
            this.exportPath = exportPath;
        }

        @Override
        public Map<String, Boolean> call() throws Exception {
            return BgFormExportServerThread.this.exportOrgUnitFile(BgFormExportServerThread.this.ctx, this.orgId, this.bgFormIds, this.exportPath);
        }
    }
}

