/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgSpecialInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.utils.BgCommentCommonHelper;
import com.kingdee.eas.ma.mbg.utils.BgExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNPeriodNameHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.mbg.utils.BgTemplateComment;
import com.kingdee.eas.ma.mbg.utils.BgTemplateCommentTank;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFormUpdateBookUtils {
    private static Logger logger = Logger.getLogger((String)BgFormUpdateBookUtils.class.getName());

    public static Book updateBook(Context ctx, Book newTemplateBook, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws Exception {
        int ss;
        int s;
        int s2;
        Book returnBook = bgFormInfo.getBook();
        Book oldTemplateBook = IOHelper.unpackBook((byte[])bgFormInfo.getTemplateData());
        BgNFSHelper.disableCal(newTemplateBook);
        BgNFSHelper.disableUndo(newTemplateBook);
        BgNFSHelper.disableCal(returnBook);
        BgNFSHelper.disableUndo(returnBook);
        BgNFSHelper.disableCal(oldTemplateBook);
        BgNFSHelper.disableUndo(oldTemplateBook);
        BgFormUpdateBookUtils.updateBookInfo(newTemplateBook, oldTemplateBook, returnBook);
        String sheetSign = null;
        Sheet newSheet = null;
        Sheet returnSheet = null;
        Sheet oldSheet = null;
        HashSet<String> addNewSheetNames = new HashSet<String>();
        ArrayList<Sheet> returnSheets = new ArrayList<Sheet>();
        Map<String, Integer> sameSigns = BgFormUpdateBookUtils.sheetSignCount(newTemplateBook);
        for (s2 = 0; s2 < newTemplateBook.getSheetCount(); ++s2) {
            newSheet = newTemplateBook.getSheet(s2);
            sheetSign = BgNFSHelper.getSheetSign(newSheet);
            if (StringUtils.isEmpty((String)sheetSign)) {
                logger.error((Object)("sheet sign is null: " + bgFormInfo.getId() + " " + newSheet.getSheetName()));
                continue;
            }
            returnSheet = null;
            for (int ss2 = 0; ss2 < returnBook.getSheetCount(); ++ss2) {
                if (!sheetSign.equals(BgNFSHelper.getSheetSign(returnBook.getSheet(ss2)))) continue;
                if (sameSigns.get(sheetSign) == 1) {
                    returnSheet = returnBook.getSheet(ss2);
                    returnSheet.setHide(newSheet.isHide());
                    break;
                }
                if (!newSheet.getSheetName().equals(returnBook.getSheet(ss2).getSheetName())) continue;
                returnSheet = returnBook.getSheet(ss2);
                returnSheet.setHide(newSheet.isHide());
                break;
            }
            if (returnSheet == null) {
                addNewSheetNames.add(newSheet.getSheetName());
                returnSheet = new Sheet(returnBook, newSheet.getSheetName());
                BgNFSHelper.setSheetSign(returnSheet, sheetSign);
                returnBook.insertSheet(s2, returnSheet);
                returnSheet.copySheetFrom(newSheet);
                returnSheet.setHide(newSheet.isHide());
                returnSheets.add(returnSheet);
                continue;
            }
            returnSheets.add(returnSheet);
        }
        for (s2 = returnBook.getSheetCount() - 1; s2 >= 0; --s2) {
            returnBook.removeSheet(s2, false);
        }
        for (s2 = 0; s2 < newTemplateBook.getSheetCount(); ++s2) {
            returnSheet = (Sheet)returnSheets.get(s2);
            returnSheet.setName(newTemplateBook.getSheetName(s2));
            returnBook.addSheet(returnSheet);
        }
        BgSheetRange[] commentRange = new BgSheetRange[returnBook.getSheetCount()];
        for (s = 0; s < returnBook.getSheetCount(); ++s) {
            returnSheet = returnBook.getSheet(s);
            sheetSign = BgNFSHelper.getSheetSign(returnSheet);
            newSheet = newTemplateBook.getSheet(s);
            oldSheet = null;
            for (ss = 0; ss < oldTemplateBook.getSheetCount(); ++ss) {
                if (!sheetSign.equals(BgNFSHelper.getSheetSign(oldTemplateBook.getSheet(ss)))) continue;
                oldSheet = oldTemplateBook.getSheet(ss);
                break;
            }
            BgFormUpdateBookUtils.synRowCol(newSheet, oldSheet, returnSheet);
        }
        for (s = 0; s < returnBook.getSheetCount(); ++s) {
            returnSheet = returnBook.getSheet(s);
            sheetSign = BgNFSHelper.getSheetSign(returnSheet);
            newSheet = newTemplateBook.getSheet(s);
            oldSheet = null;
            for (ss = 0; ss < oldTemplateBook.getSheetCount(); ++ss) {
                if (!sheetSign.equals(BgNFSHelper.getSheetSign(oldTemplateBook.getSheet(ss)))) continue;
                oldSheet = oldTemplateBook.getSheet(ss);
                break;
            }
            commentRange[s] = BgFormUpdateBookUtils.updateSheet(ctx, bgFormInfo, newSheet, oldSheet, returnSheet);
        }
        if (BgSpecialBudgetHelper.checkIsSpecialBudget(bgFormInfo)) {
            BgSpecialBudgetHelper.fillAndbuildFormula(ctx, returnBook, bgFormInfo, schemeHelper);
        }
        BgNFSHelper.setIsNotEnumerateCellLocked(ctx, returnBook, false);
        BgNFSHelper.enableCal(newTemplateBook);
        BgNFSHelper.enableUndo(newTemplateBook);
        BgNFSHelper.enableCal(returnBook);
        BgNFSHelper.enableUndo(returnBook);
        BgNFSHelper.enableCal(oldTemplateBook);
        BgNFSHelper.enableUndo(oldTemplateBook);
        BgFormUpdateBookUtils.synCommentForItemFormula(ctx, bgFormInfo, commentRange, returnBook, schemeHelper.getBgOrgViewId());
        return returnBook;
    }

    private static Map<String, Integer> sheetSignCount(Book newTemplateBook) {
        HashMap<String, Integer> sameSigns = new HashMap<String, Integer>();
        int in = newTemplateBook.getSheetCount();
        for (int i = 0; i < in; ++i) {
            String sheetSign = BgNFSHelper.getSheetSign(newTemplateBook.getSheet(i));
            if (sameSigns.containsKey(sheetSign)) {
                Integer integer = (Integer)sameSigns.get(sheetSign) + 1;
                sameSigns.put(sheetSign, integer);
                continue;
            }
            sameSigns.put(sheetSign, 1);
        }
        return sameSigns;
    }

    private static void synCommentForItemFormula(Context ctx, BgFormInfo bgFormInfo, BgSheetRange[] commentRange, Book book, String bgOrgViewId) throws Exception {
        HashSet<String> formulaList = new HashSet<String>();
        Range range = null;
        ArrayList<Range> ranges = new ArrayList<Range>();
        Sheet sheet = null;
        CellBlock block = null;
        String formula = null;
        for (BgSheetRange bgRange : commentRange) {
            range = bgRange.getRange();
            if (range == null || range.isEmpty()) continue;
            ranges.add(range);
            sheet = range.getRangeSheets().getSheet(0);
            int bSize = range.size();
            for (int bIndex = 0; bIndex < bSize; ++bIndex) {
                block = range.getBlock(bIndex);
                for (int r = block.getRow(); r <= Math.min(block.getRow2(), sheet.getMaxRowIndex()); ++r) {
                    for (int c = block.getCol(); c <= Math.min(block.getCol2(), sheet.getMaxColIndex()); ++c) {
                        formula = BgNFSHelper.getFormulaOfCell(sheet.getCell(r, c, false));
                        if (StringUtils.isEmpty((String)formula)) continue;
                        formulaList.add(formula);
                    }
                }
            }
        }
        HashSet<String> versionNumber = new HashSet<String>();
        versionNumber.add(bgFormInfo.getBgVersion().getNumber());
        MbgViewManagerImpl viewManager = DimensionFormulaHelper.buildViewMamager(ctx, new ArrayList<String>(formulaList), versionNumber);
        BgCommentCommonHelper.fillBgComments(ctx, book, bgFormInfo, bgOrgViewId, viewManager);
        BgCommentCommonHelper.saveBgComments(ctx, ranges, bgFormInfo, true);
    }

    private static void updateBookInfo(Book newTemplateBook, Book oldTemplateBook, Book returnBook) {
        BgFormUpdateBookUtils.copyBookUserObject(newTemplateBook, oldTemplateBook, returnBook);
    }

    private static void copyBookUserObject(Book newTemplateBook, Book oldTemplateBook, Book returnBook) {
        Map<String, Object> newMap = BgFormUpdateBookUtils.convertToMap(newTemplateBook.getUserObjects());
        Map<String, Object> oldMap = BgFormUpdateBookUtils.convertToMap(oldTemplateBook.getUserObjects());
        Map<String, Object> returnMap = BgFormUpdateBookUtils.convertToMap(returnBook.getUserObjects());
        Set<String> removeSet = BgFormUpdateBookUtils.copyMap(newMap, oldMap, returnMap, new String[]{"VARIABLES"});
        for (String rKey : removeSet) {
            returnBook.removeUserObject(rKey);
        }
        for (String key : returnMap.keySet()) {
            returnBook.setUserObject(key, returnMap.get(key));
        }
        ReportVariables newVar = (ReportVariables)newTemplateBook.getUserObjectValue("VARIABLES");
        ReportVariables oldVar = (ReportVariables)oldTemplateBook.getUserObjectValue("VARIABLES");
        ReportVariables returnVar = (ReportVariables)returnBook.getUserObjectValue("VARIABLES");
        if (returnVar == null && (newVar != null || oldVar != null)) {
            returnVar = new ReportVariables();
            returnBook.setUserObject("VARIABLES", (Object)returnVar);
        }
        BgFormUpdateBookUtils.copyReportVariables(newVar, oldVar, returnVar);
    }

    private static Map<String, Object> convertToMap(SortedUserObjectArray userObjects) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (userObjects == null) {
            return result;
        }
        for (int i = 0; i < userObjects.size(); ++i) {
            result.put(userObjects.getUserObject(i).getKey(), userObjects.getUserObject(i).getValue());
        }
        return result;
    }

    private static void copyReportVariables(ReportVariables newTemplateBook, ReportVariables oldTemplateBook, ReportVariables returnBook) {
        Map<String, Object> newMap = BgFormUpdateBookUtils.convertToMap(newTemplateBook);
        Map<String, Object> oldMap = BgFormUpdateBookUtils.convertToMap(oldTemplateBook);
        Map<String, Object> returnMap = BgFormUpdateBookUtils.convertToMap(returnBook);
        BgFormUpdateBookUtils.copyMap(newMap, oldMap, returnMap, null);
        returnBook.clear();
        for (Object var : returnMap.values()) {
            returnBook.add((VariableEntry)var);
        }
    }

    private static Map<String, Object> convertToMap(ReportVariables newTemplateBook) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (newTemplateBook != null) {
            for (int i = 0; i < newTemplateBook.size(); ++i) {
                result.put(BgFormUpdateBookUtils.getVarKey(newTemplateBook.get(i)), newTemplateBook.get(i));
            }
        }
        return result;
    }

    private static String getVarKey(VariableEntry var) {
        return var.getSheetName() + "!" + var.getName();
    }

    private static Set<String> copyMap(Map<String, Object> newTemplateBook, Map<String, Object> oldTemplateBook, Map<String, Object> returnBook, String[] excludedKeys) {
        HashSet<String> userKeys = new HashSet<String>();
        if (excludedKeys != null && excludedKeys.length > 0) {
            userKeys.addAll(Arrays.asList(excludedKeys));
        }
        HashSet<String> removeKeys = new HashSet<String>();
        for (String key : oldTemplateBook.keySet()) {
            if (userKeys.contains(key)) continue;
            if (newTemplateBook.get(key) == null) {
                returnBook.remove(key);
            }
            removeKeys.add(key);
        }
        Object newValue = null;
        for (String key : newTemplateBook.keySet()) {
            if (userKeys.contains(key)) continue;
            newValue = newTemplateBook.get(key);
            if (newValue instanceof VariableEntry || oldTemplateBook.get(key) instanceof VariableEntry) {
                if (DimensionCommonHelper.isEquals(StringUtils.cnulls((Object)newValue), StringUtils.cnulls((Object)oldTemplateBook.get(key)))) continue;
                returnBook.put(key, newValue);
                continue;
            }
            if (DimensionCommonHelper.isEquals(newValue, oldTemplateBook.get(key))) continue;
            returnBook.put(key, newValue);
        }
        return removeKeys;
    }

    private static BgSheetRange updateSheet(Context ctx, BgFormInfo bgFormInfo, Sheet newSheet, Sheet oldSheet, Sheet returnSheet) throws Exception {
        BgSheetRange commenRange = BgFormUpdateBookUtils.synCell(ctx, bgFormInfo, newSheet, oldSheet, returnSheet);
        BgFormUpdateBookUtils.synSheetSplit(newSheet, oldSheet, returnSheet);
        BgFormUpdateBookUtils.synMergeManager(newSheet, oldSheet, returnSheet);
        return commenRange;
    }

    private static void synMergeManager(Sheet newSheet, Sheet oldSheet, Sheet returnSheet) {
        if (newSheet == null || returnSheet == null) {
            return;
        }
        returnSheet.getSheetOption().getMerger(true).clear();
        LinkedHashMap<String, Integer> returnRowSign = BgFormUpdateBookUtils.getRowSign(returnSheet);
        LinkedHashMap<String, Integer> returnColSign = BgFormUpdateBookUtils.getColSign(returnSheet);
        MergeBlocks mblist = newSheet.getSheetOption().getMerger(false);
        if (mblist != null && !mblist.isEmpty()) {
            for (int n = 0; n < mblist.size(); ++n) {
                CellBlock cellBlock = mblist.getBlock(n);
                CellBlock returnBlock = (CellBlock)cellBlock.clone();
                if (returnRowSign.get(BgNFSHelper.getRowSign(newSheet.getRow(returnBlock.getRow(), false))) != null) {
                    returnBlock.setRow(((Integer)returnRowSign.get(BgNFSHelper.getRowSign(newSheet.getRow(returnBlock.getRow(), false)))).intValue());
                } else {
                    returnBlock.setRow(returnBlock.getRow());
                }
                if (returnRowSign.get(BgNFSHelper.getRowSign(newSheet.getRow(returnBlock.getRow2(), false))) != null) {
                    returnBlock.setRow2(((Integer)returnRowSign.get(BgNFSHelper.getRowSign(newSheet.getRow(returnBlock.getRow2(), false)))).intValue());
                } else {
                    returnBlock.setRow2(returnBlock.getRow2());
                }
                if (returnColSign.get(BgNFSHelper.getColSign(newSheet.getColumn(returnBlock.getCol(), false))) != null) {
                    returnBlock.setCol(((Integer)returnColSign.get(BgNFSHelper.getColSign(newSheet.getColumn(returnBlock.getCol(), false)))).intValue());
                } else {
                    returnBlock.setCol(returnBlock.getCol());
                }
                if (returnColSign.get(BgNFSHelper.getColSign(newSheet.getColumn(returnBlock.getCol2(), false))) != null) {
                    returnBlock.setCol2(((Integer)returnColSign.get(BgNFSHelper.getColSign(newSheet.getColumn(returnBlock.getCol2(), false)))).intValue());
                } else {
                    returnBlock.setCol2(returnBlock.getCol2());
                }
                returnSheet.getRange(returnBlock.getRow(), returnBlock.getCol(), returnBlock.getRow2(), returnBlock.getCol2()).merge();
                returnSheet.getSheetOption().getMerger(true).insert((Object)returnBlock);
            }
        }
    }

    private static void synSheetSplit(Sheet newSheet, Sheet oldSheet, Sheet returnSheet) {
        boolean oldIsFreeze;
        if (newSheet == null || returnSheet == null) {
            return;
        }
        ViewSplitInfo newVs = newSheet.getSheetOption().getViewSplitInfo();
        ViewSplitInfo oldVs = oldSheet != null ? oldSheet.getSheetOption().getViewSplitInfo() : null;
        boolean newIsFreeze = newVs.isFreezed();
        boolean bl = oldIsFreeze = oldVs != null ? oldVs.isFreezed() : false;
        if (!newIsFreeze) {
            if (oldIsFreeze) {
                returnSheet.getSheetOption().getViewSplitInfo().setFreezed(false);
                returnSheet.getSheetOption().getViewSplitInfo().copyFrom(newVs);
            }
        } else {
            boolean isChange = DimensionCommonHelper.isEquals(new Integer(newVs.getActivePane()), oldVs != null ? new Integer(oldVs.getActivePane()) : null);
            boolean bl2 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getColFixLine(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getColFixLine()) : null, true) ? true : (isChange = false);
            boolean bl3 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getColSplit(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getColSplit()) : null, true) ? true : (isChange = false);
            boolean bl4 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getFirstCol(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getFirstCol()) : null, true) ? true : (isChange = false);
            boolean bl5 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getFirstCol2(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getFirstCol2()) : null, true) ? true : (isChange = false);
            boolean bl6 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getFirstRow(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getFirstRow()) : null, false) ? true : (isChange = false);
            boolean bl7 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getFirstRow2(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getFirstRow2()) : null, false) ? true : (isChange = false);
            boolean bl8 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getRowFixLine(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getRowFixLine()) : null, false) ? true : (isChange = false);
            boolean bl9 = isChange || BgFormUpdateBookUtils.isChangeSplit(newSheet, newVs.getRowSplit(), oldSheet, oldVs != null ? Integer.valueOf(oldVs.getRowSplit()) : null, false) ? true : (isChange = false);
            if (isChange) {
                LinkedHashMap<String, Integer> returnSign = BgFormUpdateBookUtils.getRowSign(returnSheet);
                returnSheet.getSheetOption().getViewSplitInfo().setFreezed(true);
                returnSheet.getSheetOption().getViewSplitInfo().setActivePane(newVs.getActivePane());
                if (returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getColFixLine(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setColFixLine(((Integer)returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getColFixLine(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setColFixLine(newSheet.getSheetOption().getViewSplitInfo().getColFixLine());
                }
                if (returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getColSplit(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setColSplit(((Integer)returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getColSplit(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setColSplit(newSheet.getSheetOption().getViewSplitInfo().getColSplit());
                }
                if (returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getFirstCol(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstCol(((Integer)returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getFirstCol(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstCol(newSheet.getSheetOption().getViewSplitInfo().getFirstCol());
                }
                if (returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getFirstCol2(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstCol2(((Integer)returnSign.get(BgNFSHelper.getColSign(newSheet.getColumn(newSheet.getSheetOption().getViewSplitInfo().getFirstCol2(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstCol2(newSheet.getSheetOption().getViewSplitInfo().getFirstCol2());
                }
                returnSign = BgFormUpdateBookUtils.getColSign(returnSheet);
                if (returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getFirstRow(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstRow(((Integer)returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getFirstRow(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstRow(newSheet.getSheetOption().getViewSplitInfo().getFirstRow());
                }
                if (returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getFirstRow2(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstRow2(((Integer)returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getFirstRow2(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setFirstRow2(newSheet.getSheetOption().getViewSplitInfo().getFirstRow2());
                }
                if (returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getRowFixLine(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setRowFixLine(((Integer)returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getRowFixLine(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setRowFixLine(newSheet.getSheetOption().getViewSplitInfo().getRowFixLine());
                }
                if (returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getRowSplit(), false))) != null) {
                    returnSheet.getSheetOption().getViewSplitInfo().setRowSplit(((Integer)returnSign.get(BgNFSHelper.getRowSign(newSheet.getRow(newSheet.getSheetOption().getViewSplitInfo().getRowSplit(), false)))).intValue());
                } else {
                    returnSheet.getSheetOption().getViewSplitInfo().setRowSplit(newSheet.getSheetOption().getViewSplitInfo().getRowSplit());
                }
            }
        }
    }

    private static boolean isChangeSplit(Sheet newSheet, Integer newIndex, Sheet oldSheet, Integer oldIndex, boolean isCol) {
        if (oldSheet == null || oldIndex == null) {
            return true;
        }
        String newSign = null;
        String oldSign = null;
        if (isCol) {
            newSign = BgNFSHelper.getColSign(newSheet.getColumn(newIndex.intValue(), false));
            oldSign = BgNFSHelper.getColSign(oldSheet.getColumn(oldIndex.intValue(), false));
        } else {
            newSign = BgNFSHelper.getRowSign(newSheet.getRow(newIndex.intValue(), false));
            oldSign = BgNFSHelper.getRowSign(oldSheet.getRow(oldIndex.intValue(), false));
        }
        return StringUtils.equals((String)newSign, (String)oldSign);
    }

    private static BgSheetRange synCell(Context ctx, BgFormInfo bgformInfo, Sheet newSheet, Sheet oldSheet, Sheet returnSheet) throws Exception {
        BgNPeriodNameHelper bgNPeriodNameHelper = new BgNPeriodNameHelper();
        BgSheetRange commentChangeRange = new BgSheetRange(returnSheet);
        LinkedHashMap<String, Integer> newRowSign = BgFormUpdateBookUtils.getRowSign(newSheet);
        LinkedHashMap<String, Integer> oldRowSign = BgFormUpdateBookUtils.getRowSign(oldSheet);
        LinkedHashMap<String, Integer> newColSign = BgFormUpdateBookUtils.getColSign(newSheet);
        LinkedHashMap<String, Integer> oldColSign = BgFormUpdateBookUtils.getColSign(oldSheet);
        Row returnRow = null;
        Row oldRow = null;
        Row newRow = null;
        Object returnCol = null;
        Column oldCol = null;
        Column newCol = null;
        String rowSign = null;
        String colSign = null;
        Cell newCell = null;
        Cell oldCell = null;
        Cell returnCell = null;
        Range newRange = null;
        Range oldRange = null;
        Range returnRange = null;
        for (int r = 0; r <= returnSheet.getMaxRowIndex(); ++r) {
            returnRow = returnSheet.getRow(r, false);
            rowSign = BgNFSHelper.getRowSign(returnRow);
            if (StringUtils.isEmpty((String)rowSign) || !newRowSign.containsKey(rowSign)) continue;
            newRow = newSheet.getRow(newRowSign.get(rowSign).intValue(), false);
            oldRow = oldRowSign.containsKey(rowSign) ? oldSheet.getRow(oldRowSign.get(rowSign).intValue(), false) : null;
            for (int c = 0; c <= returnSheet.getMaxColIndex(); ++c) {
                String oldFormula;
                String newFormula;
                Object oldValue;
                Object newValue;
                colSign = BgNFSHelper.getColSign(returnSheet.getColumn(c, false));
                if (StringUtils.isEmpty((String)colSign) || !newColSign.containsKey(colSign)) continue;
                newCol = newSheet.getColumn(newColSign.get(colSign).intValue(), false);
                oldCol = oldColSign.containsKey(colSign) ? oldSheet.getColumn(oldColSign.get(colSign).intValue(), false) : null;
                newCell = newSheet.getCell(newRow.getRow(), newCol.getCol(), false);
                newRange = newSheet.getRange(newRow.getRow(), newCol.getCol());
                returnCell = returnSheet.getCell(r, c, false);
                returnRange = returnSheet.getRange(r, c);
                if (newCell != null) {
                    returnCell = returnSheet.getCell(r, c, true);
                }
                if (oldRow != null && oldCol != null) {
                    oldCell = oldSheet.getCell(oldRow.getRow(), oldCol.getCol(), false);
                    oldRange = oldSheet.getRange(oldRow.getRow(), oldCol.getCol());
                } else {
                    oldRange = null;
                    oldCell = null;
                }
                String newExpress = BgNFSHelper.getExpression(newCell);
                String oldExpress = BgNFSHelper.getExpression(oldCell);
                String returnExpress = BgNFSHelper.getExpression(returnCell);
                if (!StringUtils.equalsIgnoreCase((String)newExpress, (String)oldExpress) || !StringUtils.equalsIgnoreCase((String)newExpress, (String)returnExpress)) {
                    String tmpExpr;
                    if (StringUtils.isEmpty((String)newExpress)) {
                        if (!StringUtils.isEmpty((String)oldExpress)) {
                            BgNFSHelper.setExpression(returnCell, newExpress);
                            BgNFSHelper.setValue(returnCell, null);
                        }
                    } else {
                        BgNFSHelper.setExpression(returnCell, newExpress);
                        BgNFSHelper.setValue(returnCell, null);
                    }
                    if (newExpress != null && newExpress.toUpperCase().indexOf("ACCT") >= 0) {
                        Expression expression = ExcelFormulaPaserHelper.parse((String)newExpress);
                        expression = BgExpressionHelper.checkExpression(ctx, expression, (IObjectValue)bgformInfo, false);
                        String tmpExpr2 = "=" + expression.toString();
                        if (tmpExpr2 != null && !tmpExpr2.equalsIgnoreCase(newExpress)) {
                            BgNFSHelper.setExpression(returnCell, tmpExpr2);
                        }
                    } else if (newExpress != null && newExpress.toUpperCase().indexOf("MBG") >= 0 && bgformInfo instanceof IBgSpecialInfo && (tmpExpr = BgNExpressionHelper.checkExpression(ctx, returnCell, newExpress, (IObjectValue)bgformInfo, bgformInfo.getOrgUnit().getNumber(), false, false)) != null && !tmpExpr.equalsIgnoreCase(newExpress)) {
                        BgNFSHelper.setExpression(returnCell, tmpExpr);
                    }
                }
                if (!DimensionCommonHelper.isEquals(newValue = BgNFSHelper.getValue(newCell), oldValue = BgNFSHelper.getValue(oldCell))) {
                    BgNFSHelper.setValue(returnCell, newValue);
                }
                if (!StringUtils.equals((String)(newFormula = BgNFSHelper.getFormulaOfCell(newCell)), (String)(oldFormula = BgNFSHelper.getFormulaOfCell(oldCell)))) {
                    if (StringUtils.isEmpty((String)newFormula)) {
                        BgNFSHelper.clearFormulaOfCell(returnCell);
                        BgNFSHelper.setValue(returnCell, null);
                        if (BgFormStateEnum.Adjusted.equals((Object)bgformInfo.getState())) {
                            StyleAttributes sa = Styles.getEmptySA();
                            StyleAttributes saInnerBorder = Styles.getEmptySA();
                            returnRange.setIgnoreProtected(true);
                            returnRange.getStyle(sa, saInnerBorder);
                            if (BgNConstants.EDIT_COLOR.equals(sa.getBackground())) {
                                StyleAttributes saNew = Styles.getEmptySA();
                                newRange.getStyle(saNew, null);
                                sa.setBackground(saNew.getBackground());
                                returnRange.setStyle(sa, saInnerBorder);
                            }
                        }
                    } else {
                        newFormula = BgNFSHelper.checkFormula(null, newFormula, (IObjectValue)bgformInfo);
                        BgNFSHelper.setFormulaOfCell(returnCell, newFormula, true);
                        BgNFSHelper.setFormulaEditOfDisable(returnCell);
                        BgNFSHelper.setValue(returnCell, null);
                    }
                }
                BgFormUpdateBookUtils.copyCellUserObject(newCell, oldCell, returnCell, new String[]{"ITEM"});
                BgFormUpdateBookUtils.copyRange(newRange, oldRange, returnRange);
                if (newRange != null && (oldRange == null || newRange.isCellLocked() != oldRange.isCellLocked())) {
                    if (returnCell == null) {
                        returnCell = returnSheet.getCell(r, c, true);
                    }
                    BgNFSHelper.setLockOfCell(ctx, returnCell, newRange.isCellLocked());
                }
                BgFormUpdateBookUtils.updateBgLink(newCell, oldCell, returnCell);
                BgFormUpdateBookUtils.updateFillType(newCell, oldCell, returnCell);
                bgNPeriodNameHelper.addCell(returnCell);
                BgFormUpdateBookUtils.updateName(newCell, oldCell, returnCell);
                BgFormUpdateBookUtils.updateHyperLink(newCell, oldCell, returnCell);
                BgFormUpdateBookUtils.updateForceLock(newCell, oldCell, returnCell);
                BgFormUpdateBookUtils.updateValidation(newRange, oldRange, returnRange);
                BgFormUpdateBookUtils.updateComment(newCell, oldCell, returnCell, commentChangeRange);
            }
        }
        bgNPeriodNameHelper.end();
        return commentChangeRange;
    }

    private static void updateComment(Cell newCell, Cell oldCell, Cell returnCell, BgSheetRange commentChangeRange) {
        Comment oldComment;
        if (newCell == null || returnCell == null) {
            return;
        }
        if (BgFormUpdateBookUtils.checkNotRptComment(newCell)) {
            return;
        }
        Comment newComment = newCell.getComment();
        Comment comment = oldComment = oldCell == null ? null : oldCell.getComment();
        if (newComment == null) {
            if (oldComment != null) {
                returnCell.setComment(null);
                if (BgNFSHelper.checkHasItemFormula(returnCell)) {
                    commentChangeRange.addCell(returnCell.getRow(), returnCell.getCol());
                }
            }
        } else {
            if (newComment instanceof BgTemplateCommentTank) {
                RptCommentTank ct = new RptCommentTank();
                returnCell.setComment((Comment)ct);
                BgTemplateComment temComment = null;
                for (int i = 0; i < ((BgTemplateCommentTank)newComment).getSize(); ++i) {
                    RptComment rptComment = new RptComment();
                    temComment = ((BgTemplateCommentTank)newComment).getEntry(i);
                    rptComment.author = temComment.author;
                    rptComment.setContent(temComment.getContent());
                    rptComment.date = temComment.getDateTimeStamp();
                    rptComment.author = temComment.author;
                    ct.addEntry(rptComment);
                }
            }
            if (BgNFSHelper.checkHasItemFormula(returnCell)) {
                commentChangeRange.addCell(returnCell.getRow(), returnCell.getCol());
            }
        }
    }

    private static boolean checkNotRptComment(Cell cell) {
        return cell != null && cell.getComment() != null && !(cell.getComment() instanceof RptCommentTank) && !(cell.getComment() instanceof BgTemplateCommentTank);
    }

    private static void updateValidation(Range newRange, Range oldRange, Range returnRange) {
        if (newRange == null || returnRange == null) {
            return;
        }
        MessagedValidate newValidate = BgFormUpdateBookUtils.getValidate(newRange);
        MessagedValidate oldValidate = BgFormUpdateBookUtils.getValidate(oldRange);
        if (newValidate == null) {
            if (oldValidate != null) {
                returnRange.getRangeSheets().getSheet(0).getValidations().remove(returnRange.getBlock(0).getRow(), returnRange.getBlock(0).getCol());
            }
        } else if (!DimensionCommonHelper.isEquals(newValidate, oldValidate)) {
            returnRange.getRangeSheets().getSheet(0).getValidations().insertValidation(newValidate, (SortedCellBlockArray)returnRange);
        }
    }

    private static MessagedValidate getValidate(Range range) {
        if (range == null) {
            return null;
        }
        return range.getRangeSheets().getSheet(0).getValidations().getValidate(range.getBlock(0).getRow(), range.getBlock(0).getCol());
    }

    private static void updateForceLock(Cell newCell, Cell oldCell, Cell returnCell) {
        String oldForceLock;
        if (newCell == null || returnCell == null) {
            return;
        }
        String newForceLock = BgNTemplateHelper.getForceLockLongNumber(newCell);
        if (!StringUtils.equals((String)newForceLock, (String)(oldForceLock = BgNTemplateHelper.getForceLockLongNumber(oldCell)))) {
            if (StringUtils.isEmpty((String)newForceLock)) {
                BgNTemplateHelper.removeForceLock(returnCell);
            } else {
                BgNTemplateHelper.setForceLock(returnCell, newForceLock);
            }
        }
    }

    private static void updateHyperLink(Cell newCell, Cell oldCell, Cell returnCell) {
        HyperLink oldLink;
        if (newCell == null || returnCell == null) {
            return;
        }
        HyperLink newLink = newCell.getHyperLink();
        HyperLink hyperLink = oldLink = oldCell != null ? oldCell.getHyperLink() : null;
        if (!DimensionCommonHelper.isEquals(newLink, oldLink)) {
            returnCell.setHyperLink(newLink);
        }
    }

    private static void updateName(Cell newCell, Cell oldCell, Cell returnCell) throws SyntaxErrorException {
        if (newCell != null && returnCell != null) {
            String oldName;
            Range newRange = newCell.getSheet().getRange(newCell);
            Range returnRange = returnCell.getSheet().getRange(returnCell);
            Range oldRange = oldCell != null ? oldCell.getSheet().getRange(oldCell) : null;
            String newName = newRange.getName(false, false, true);
            String string = oldName = oldRange != null ? oldRange.getName(false, false, true) : null;
            if (!StringUtils.equals((String)newName, (String)oldName)) {
                if (StringUtils.isEmpty((String)newName)) {
                    String returnName = returnRange.getName(false, false, true);
                    if (!StringUtils.isEmpty((String)returnName)) {
                        returnRange.setName(returnName, null);
                    }
                } else {
                    Sheet tSheet = returnCell.getSheet();
                    String referto = tSheet.getSyntaxName() + '!' + Sheet.getBlocksName((SortedCellBlockArray)returnRange, (boolean)tSheet.getBook().getDeps().isA1Style(), (boolean)true);
                    returnRange.setName(newName, referto);
                }
            }
        }
    }

    private static void updateFillType(Cell newCell, Cell oldCell, Cell returnCell) {
        if (returnCell == null || newCell == null) {
            return;
        }
        String newFillType = (String)BgNTemplateHelper.getBgFillType(newCell);
        String newFillValue = (String)BgNTemplateHelper.getBgFillValue(newCell);
        String oldFillType = (String)BgNTemplateHelper.getBgFillType(oldCell);
        String oldFillValue = (String)BgNTemplateHelper.getBgFillValue(oldCell);
        String[] otherValue = new String[]{"bgFillValueType_item", "bgFillValueType_period", "bgFillValueType_element", "bgFillValueType_currency", "bgFillValueType_scenario", "bgFillSrcNumber", "bgFillValue_itemId"};
        if (StringUtils.isEmpty((String)newFillType) && !StringUtils.isEmpty((String)oldFillValue)) {
            BgNTemplateHelper.removeDataValue(returnCell, "bgFillType", false);
            BgNTemplateHelper.removeDataValue(returnCell, "bgFillValue", false);
            for (String key : otherValue) {
                BgNTemplateHelper.removeDataValue(returnCell, key, false);
            }
        } else {
            if (!StringUtils.equals((String)newFillType, (String)oldFillType)) {
                BgNTemplateHelper.setBgDataValue(returnCell, "bgFillType", newFillType, false);
            }
            if (!StringUtils.equals((String)newFillValue, (String)newFillValue)) {
                BgNTemplateHelper.setBgDataValue(returnCell, "bgFillValue", newFillValue, false);
            }
            for (String key : otherValue) {
                BgFormUpdateBookUtils.updateOtherFillType(newCell, oldCell, returnCell, key);
            }
        }
    }

    private static void updateOtherFillType(Cell newCell, Cell oldCell, Cell returnCell, String fillKey) {
        String oldValue;
        String newValue = BgNTemplateHelper.getBgDataValue(newCell, fillKey);
        if (!StringUtils.equals((String)newValue, (String)(oldValue = BgNTemplateHelper.getBgDataValue(oldCell, fillKey)))) {
            BgNTemplateHelper.setBgDataValue(returnCell, fillKey, newValue, false);
        }
    }

    private static void updateBgLink(Cell newCell, Cell oldCell, Cell returnCell) {
        if (returnCell == null || newCell == null) {
            return;
        }
        boolean newLink = BgNFSHelper.checkHasLinked(newCell);
        boolean oldLink = BgNFSHelper.checkHasLinked(oldCell);
        if (!newLink && oldLink) {
            BgNFSHelper.clearLinkOfCell(returnCell);
        } else if (newLink) {
            String[] linkkeys;
            for (String linkKey : linkkeys = new String[]{"BG_LINK_FORM_ID", "BG_LINK_ORGUNIT_ID", "BG_LINK_SCHEME_ID", "BG_LINK_SCHEME_NUMBER", "BG_LINK_TEMPLATE_ID", "BG_LINK_TEMPLATE_NUMBER", "BG_LINK_PERIOD_ID", "BG_LINK_CURRENCY_ID", "BG_LINK_VERSION_ID", "BG_LINK_BGSPECALITEMS_FORMULA"}) {
                BgFormUpdateBookUtils.updateBgLink(newCell, oldCell, returnCell, linkKey);
            }
        }
    }

    private static void updateBgLink(Cell newCell, Cell oldCell, Cell returnCell, String linkKey) {
        String oldValue;
        String newValue = (String)BgNFSHelper.getCellData(newCell, linkKey);
        if (!StringUtils.equals((String)newValue, (String)(oldValue = (String)BgNFSHelper.getCellData(oldCell, linkKey)))) {
            BgNFSHelper.setCellData(returnCell, linkKey, newValue);
        }
    }

    protected static void synRowCol(Sheet newSheet, Sheet oldSheet, Sheet returnSheet) {
        LinkedHashMap<String, Integer> newSign = BgFormUpdateBookUtils.getRowSign(newSheet);
        LinkedHashMap<String, Integer> oldSign = BgFormUpdateBookUtils.getRowSign(oldSheet);
        LinkedHashMap<String, Integer> returnSign = BgFormUpdateBookUtils.getRowSign(returnSheet);
        String[] signArray = newSign.keySet().toArray(new String[0]);
        String sign = null;
        int insertIndex = -1;
        Row newRow = null;
        Row oldRow = null;
        Row returnRow = null;
        for (int i = signArray.length - 1; i >= 0; --i) {
            sign = signArray[i];
            if (returnSign.containsKey(sign) || oldSign.containsKey(sign)) continue;
            insertIndex = BgFormUpdateBookUtils.findInsertIndex(i, signArray, returnSign);
            returnRow = oldSheet != null ? BgFormUpdateBookUtils.addRowWithOutMode(returnSheet, insertIndex) : returnSheet.getRow(i, false);
            newRow = newSheet.getRow(newSign.get(sign).intValue(), false);
            oldRow = null;
            BgFormUpdateBookUtils.copyRowUserObject(newRow, oldRow, returnRow, new String[]{"SIGN_DATA_ID", "DATA_SOURCE_TEMPLATE"});
            BgNFSHelper.setRowSign(returnRow, sign);
            BgNFSHelper.setRowSource(returnRow, "DATA_SOURCE_TEMPLATE");
        }
        for (int r = returnSheet.getMaxRowIndex(); r >= 0; --r) {
            sign = BgNFSHelper.getRowSign(returnSheet.getRow(r, false));
            if (sign == null) continue;
            if (!newSign.containsKey(sign) && oldSign.containsKey(sign)) {
                BgNFSHelper.removeRow(returnSheet, r);
                continue;
            }
            returnRow = returnSheet.getRow(r, false);
            newRow = newSign.get(sign) != null ? newSheet.getRow(newSign.get(sign).intValue(), false) : null;
            Row row = oldRow = oldSign.get(sign) != null ? oldSheet.getRow(oldSign.get(sign).intValue(), false) : null;
            if (oldRow != null) {
                BgFormUpdateBookUtils.copyRowUserObject(newRow, oldRow, returnRow, new String[]{"SIGN_DATA_ID", "DATA_SOURCE_TEMPLATE"});
            }
            BgFormUpdateBookUtils.copyRowColRange(newSheet, newRow == null ? null : Integer.valueOf(newRow.getRow()), oldSheet, oldRow == null ? null : Integer.valueOf(oldRow.getRow()), returnSheet, returnRow == null ? null : Integer.valueOf(returnRow.getRow()), false);
        }
        newSign = BgFormUpdateBookUtils.getColSign(newSheet);
        oldSign = BgFormUpdateBookUtils.getColSign(oldSheet);
        returnSign = BgFormUpdateBookUtils.getColSign(returnSheet);
        Column newCol = null;
        Column oldCol = null;
        Column returnCol = null;
        signArray = newSign.keySet().toArray(new String[0]);
        for (int i = signArray.length - 1; i >= 0; --i) {
            sign = signArray[i];
            if (returnSign.containsKey(sign) || oldSign.containsKey(sign)) continue;
            insertIndex = BgFormUpdateBookUtils.findInsertIndex(i, signArray, returnSign);
            returnCol = oldSheet != null ? BgFormUpdateBookUtils.addColumnWithOutMode(returnSheet, insertIndex) : returnSheet.getColumn(i, false);
            if (returnCol == null) continue;
            newCol = newSheet.getColumn(newSign.get(sign).intValue(), false);
            oldCol = null;
            returnCol = returnSheet.getColumn(returnCol.getCol(), true);
            BgFormUpdateBookUtils.copyColumnUserObject(newCol, oldCol, returnCol, new String[]{"SIGN_DATA_ID", "DATA_SOURCE_TEMPLATE"});
            BgNFSHelper.setColSign(returnCol, sign);
            BgNFSHelper.setColSource(returnCol, "DATA_SOURCE_TEMPLATE");
        }
        for (int c = returnSheet.getMaxColIndex(); c >= 0; --c) {
            sign = BgNFSHelper.getColSign(returnSheet.getColumn(c, false));
            if (sign == null) continue;
            if (!newSign.containsKey(sign) && oldSign.containsKey(sign)) {
                BgNFSHelper.removeColumn(returnSheet, c);
                continue;
            }
            returnCol = returnSheet.getColumn(c, false);
            newCol = newSign.get(sign) != null ? newSheet.getColumn(newSign.get(sign).intValue(), false) : null;
            oldCol = oldSign.get(sign) != null ? oldSheet.getColumn(oldSign.get(sign).intValue(), false) : null;
            BgFormUpdateBookUtils.copyColumnUserObject(newSign.get(sign) != null ? newSheet.getColumn(newSign.get(sign).intValue(), false) : null, oldSign.get(sign) != null ? oldSheet.getColumn(oldSign.get(sign).intValue(), false) : null, returnSheet.getColumn(c, false), new String[]{"SIGN_DATA_ID", "DATA_SOURCE_TEMPLATE"});
            BgFormUpdateBookUtils.copyRowColRange(newSheet, newCol == null ? null : Integer.valueOf(newCol.getCol()), oldSheet, oldCol == null ? null : Integer.valueOf(oldCol.getCol()), returnSheet, returnCol == null ? null : Integer.valueOf(returnCol.getCol()), true);
        }
    }

    private static void copyRowColRange(Sheet newSheet, Integer newIndex, Sheet oldSheet, Integer oldIndex, Sheet returnSheet, Integer returnIndex, boolean isCol) {
        if (newIndex == null || returnIndex == null) {
            return;
        }
        SortedAttributeSpanArray.AttributeSpan newSpan = BgFormUpdateBookUtils.getSpans(BgFormUpdateBookUtils.getSheetSpans(newSheet, isCol), newIndex);
        SortedAttributeSpanArray.AttributeSpan returnSpan = BgFormUpdateBookUtils.getSpans(BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol), returnIndex);
        SortedAttributeSpanArray.AttributeSpan oldSpan = BgFormUpdateBookUtils.getSpans(BgFormUpdateBookUtils.getSheetSpans(oldSheet, isCol), oldIndex);
        if (!BgCommHelper.isEmpty((Object)newSpan)) {
            if (oldSpan == null || oldSpan.getSSA() == null) {
                if (returnSpan == null) {
                    returnSpan = (SortedAttributeSpanArray.AttributeSpan)BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol).createDefaultSpan(new Span(returnIndex.intValue(), returnIndex.intValue()));
                    returnSpan.setLength(newSpan.getLength());
                    BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol).append((Object)returnSpan);
                } else {
                    returnSpan.setLength(newSpan.getLength());
                    BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol).append((Object)returnSpan);
                }
                returnSpan.setSSA((ShareStyleAttributes)Styles.getSA((ShareStyleAttributes)newSpan.getSSA()));
            } else {
                StyleAttributes saOld = Styles.getSA((ShareStyleAttributes)oldSpan.getSSA());
                long crashBits = newSpan.getSSA().crashBits((ShareStyleAttributes)saOld, false);
                if (returnSpan == null) {
                    returnSpan = (SortedAttributeSpanArray.AttributeSpan)BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol).createDefaultSpan(new Span(returnIndex.intValue(), returnIndex.intValue()));
                    BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol).append((Object)returnSpan);
                }
                if (crashBits > 0L) {
                    returnSpan.setSSA((ShareStyleAttributes)Styles.getSA((ShareStyleAttributes)newSpan.getSSA()));
                }
                returnSpan.setLength(newSpan.getLength());
                BgFormUpdateBookUtils.getSheetSpans(returnSheet, isCol).append((Object)returnSpan);
            }
        }
    }

    private static SortedAttributeSpanArray getSheetSpans(Sheet sheet, boolean isCol) {
        if (sheet == null) {
            return null;
        }
        return isCol ? sheet.getColSpans() : sheet.getRowSpans();
    }

    private static SortedAttributeSpanArray.AttributeSpan getSpans(SortedAttributeSpanArray spans, Integer index) {
        if (spans == null || index == null) {
            return null;
        }
        Span[] ss = spans.getSpecifiedSpans(index.intValue(), index.intValue());
        if (ss != null && ss.length > 0) {
            return (SortedAttributeSpanArray.AttributeSpan)ss[0];
        }
        return null;
    }

    private static void copyRange(Range newRange, Range oldRange, Range returnRange) {
        if (newRange == null || returnRange == null) {
            return;
        }
        StyleAttributes saNew = Styles.getEmptySA();
        StyleAttributes saInnerBorderNew = Styles.getEmptySA();
        newRange.getStyle(saNew, saInnerBorderNew);
        returnRange.setIgnoreProtected(true);
        if (oldRange == null) {
            if (!saNew.isEmpty()) {
                saNew.setDirty(saNew.getAllBits());
            }
            returnRange.setStyle(saNew, saInnerBorderNew);
        } else {
            StyleAttributes saOld = Styles.getEmptySA();
            StyleAttributes saInnerBorderOld = Styles.getEmptySA();
            oldRange.getStyle(saOld, saInnerBorderOld);
            long crashBits = saNew.crashBits((ShareStyleAttributes)saOld, false);
            boolean hasStyle = false;
            if (crashBits > 0L) {
                hasStyle = true;
                saOld.clearAttributes();
                saOld.replace((ShareStyleAttributes)saNew, crashBits);
            }
            crashBits = saInnerBorderNew.crashBits((ShareStyleAttributes)saInnerBorderOld, false);
            saInnerBorderNew.clearAttributes();
            if (crashBits > 0L) {
                hasStyle = true;
                saInnerBorderOld.clearAttributes();
                saInnerBorderOld.replace((ShareStyleAttributes)saInnerBorderNew, crashBits);
            }
            if (hasStyle) {
                returnRange.setStyle(saOld, saInnerBorderOld);
            }
        }
    }

    private static Range getRowRange(Sheet sheet, Row row) {
        if (sheet == null || row == null) {
            return null;
        }
        return sheet.getRowRange(row.getRow(), row.getRow());
    }

    private static Range getColumnRange(Sheet sheet, Column col) {
        if (sheet == null || col == null) {
            return null;
        }
        return sheet.getColRange(col.getCol(), col.getCol());
    }

    private static void copyRowUserObject(Row newRow, Row oldRow, Row returnRow, String[] excludedKeys) {
        if (returnRow == null) {
            return;
        }
        Map<String, Object> newMap = BgFormUpdateBookUtils.convertToMap(newRow == null ? null : newRow.getUserObjects());
        Map<String, Object> oldMap = BgFormUpdateBookUtils.convertToMap(oldRow == null ? null : oldRow.getUserObjects());
        Map<String, Object> returnMap = BgFormUpdateBookUtils.convertToMap(returnRow == null ? null : returnRow.getUserObjects());
        Set<String> removeSet = BgFormUpdateBookUtils.copyMap(newMap, oldMap, returnMap, excludedKeys);
        for (String rKey : removeSet) {
            returnRow.removeUserObject(rKey);
        }
        for (String key : returnMap.keySet()) {
            returnRow.setUserObject(key, returnMap.get(key));
        }
    }

    private static void copyColumnUserObject(Column newRow, Column oldRow, Column returnRow, String[] excludedKeys) {
        if (returnRow == null) {
            return;
        }
        Map<String, Object> newMap = BgFormUpdateBookUtils.convertToMap(newRow == null ? null : newRow.getUserObjects());
        Map<String, Object> oldMap = BgFormUpdateBookUtils.convertToMap(oldRow == null ? null : oldRow.getUserObjects());
        Map<String, Object> returnMap = BgFormUpdateBookUtils.convertToMap(returnRow == null ? null : returnRow.getUserObjects());
        Set<String> removeSet = BgFormUpdateBookUtils.copyMap(newMap, oldMap, returnMap, excludedKeys);
        for (String rKey : removeSet) {
            returnRow.removeUserObject(rKey);
        }
        for (String key : returnMap.keySet()) {
            returnRow.setUserObject(key, returnMap.get(key));
        }
    }

    private static void copyCellUserObject(Cell newCell, Cell oldCell, Cell returnCell, String[] excludedKeys) {
        if (returnCell == null) {
            return;
        }
        Map<String, Object> newMap = BgFormUpdateBookUtils.convertToMap(newCell == null ? null : newCell.getUserObjects(false));
        Map<String, Object> oldMap = BgFormUpdateBookUtils.convertToMap(oldCell == null ? null : oldCell.getUserObjects(false));
        Map<String, Object> returnMap = BgFormUpdateBookUtils.convertToMap(returnCell == null ? null : returnCell.getUserObjects(false));
        Set<String> removeSet = BgFormUpdateBookUtils.copyMap(newMap, oldMap, returnMap, excludedKeys);
        for (String rKey : removeSet) {
            returnCell.removeUserObject(rKey);
        }
        for (String key : returnMap.keySet()) {
            returnCell.setUserObject(key, returnMap.get(key));
        }
    }

    private static int findInsertIndex(int index, String[] signArray, LinkedHashMap<String, Integer> returnSign) {
        int insertIndex = 0;
        for (int i = index - 1; i >= 0; --i) {
            if (!returnSign.containsKey(signArray[i])) continue;
            return returnSign.get(signArray[i]) + 1;
        }
        return insertIndex;
    }

    private static LinkedHashMap<String, Integer> getRowSign(Sheet sheet) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        if (sheet == null) {
            return result;
        }
        for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
            if (BgNFSHelper.getRowSign(sheet.getRow(r, false)) == null) continue;
            result.put(BgNFSHelper.getRowSign(sheet.getRow(r, false)), r);
        }
        return result;
    }

    private static LinkedHashMap<String, Integer> getColSign(Sheet sheet) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        if (sheet == null) {
            return result;
        }
        for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
            result.put(BgNFSHelper.getColSign(sheet.getColumn(c, false)), c);
        }
        return result;
    }

    public static Row addRowWithOutMode(Sheet sheet, int rowIndex) {
        if (sheet == null || rowIndex < 0) {
            return null;
        }
        Range range = sheet.getRowRange(rowIndex, rowIndex);
        range.setIgnoreProtected(true);
        range.insert(false, InsertType.NOSTYLE);
        Row row = sheet.getRow(rowIndex, true);
        int maxColIndex = row.size();
        for (int i = 0; i < maxColIndex; ++i) {
            BgNTemplateHelper.clearAll(row.getAt(i), false);
        }
        return row;
    }

    public static Column addColumnWithOutMode(Sheet sheet, int colIndex) {
        if (sheet == null || colIndex < 0) {
            return null;
        }
        Range range = sheet.getColRange(colIndex, colIndex);
        range.setIgnoreProtected(true);
        range.insert(false, InsertType.NOSTYLE);
        Column col = sheet.getColumn(colIndex, true);
        int maxRowIndex = sheet.getMaxRowIndex() + 1;
        for (int i = 0; i < maxRowIndex; ++i) {
            BgNTemplateHelper.clearAll(sheet.getCell(i, colIndex, false), false);
        }
        return col;
    }
}

