/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.OrderObject;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitException;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.IBgOrgAddResult;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgOrgAddServerHelper {
    private static final long serialVersionUID = -5224354907151369447L;
    private static final Logger logger = Logger.getLogger((String)BgOrgAddServerHelper.class.getName());
    private static int PER_BATCH_COUNT = 5;
    private static Set<Integer> stateSet = new HashSet<Integer>();
    private static String MBG_RESOURCE = "com.kingdee.eas.ma.mbg.MBGFormResource";
    private Set<String> bgFormIdSet = null;
    private Set<String> orgUnitIdSet = null;
    private BgSchemeInfo bgSchemeInfo = null;
    private BOSUuid bgOrgViewId = null;
    public IBgOrgAddResult resultImpl = null;
    public String addNewPermissionNumber = null;
    private String viewPermissionNumber = null;
    private Context ctx = null;

    public BgOrgAddServerHelper(Set<String> bgFormIdSet, Set<String> orgUnitIdSet, BgSchemeInfo bgSchemeInfo, BOSUuid bgOrgViewId) throws BgOrgUnitException {
        this.bgFormIdSet = bgFormIdSet;
        this.orgUnitIdSet = orgUnitIdSet;
        this.bgSchemeInfo = bgSchemeInfo;
        this.bgOrgViewId = bgOrgViewId;
    }

    public void setResultImpl(IBgOrgAddResult resultImpl) {
        this.resultImpl = resultImpl;
    }

    public String getAddNewPermissionNumber() {
        return this.addNewPermissionNumber;
    }

    public void setAddNewPermissionNumber(String addNewPermissionNumber) {
        this.addNewPermissionNumber = addNewPermissionNumber;
    }

    public void setViewPermissionNumber(String viewPermissionNumber) {
        this.viewPermissionNumber = viewPermissionNumber;
    }

    public String getViewPermissionNumber() {
        return this.viewPermissionNumber;
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    private void dealOrgMember(List<BgDimensionMember> newMembers, List<BgDimensionMember> intersectionMembers, MbgViewListDimensionInfo orgDimension, String formOrgUnitNumber) {
        HashSet<String> intersectionSet = new HashSet<String>();
        HashSet deleteNumberSet = new HashSet();
        HashSet<String> newNumberSet = new HashSet<String>();
        HashSet<String> curNumberSet = new HashSet<String>();
        if (newMembers != null) {
            int i;
            for (i = 0; i < newMembers.size(); ++i) {
                if (newMembers.get(i) == null || StringUtils.isEmpty((String)newMembers.get(i).getNumber())) continue;
                newNumberSet.add(newMembers.get(i).getNumber());
            }
            if (intersectionMembers != null) {
                for (i = 0; i < intersectionMembers.size(); ++i) {
                    if (intersectionMembers.get(i) == null || StringUtils.isEmpty((String)intersectionMembers.get(i).getNumber())) continue;
                    intersectionSet.add(intersectionMembers.get(i).getNumber());
                }
            }
            Map<String, Set<String>> map = BgNFSHelper.getIncrementAndDecrementSet(newNumberSet, intersectionSet);
            if (orgDimension != null && orgDimension.getMember() != null) {
                BgDimensionMember bgDimensionMember;
                int i2;
                List currMembers = DimensionCommonHelper.deepclone((ArrayList)orgDimension.getMember());
                for (i2 = 0; i2 < currMembers.size(); ++i2) {
                    bgDimensionMember = (BgDimensionMember)currMembers.get(i2);
                    if (bgDimensionMember == null || StringUtils.isEmpty((String)bgDimensionMember.getNumber())) continue;
                    if (map.get(BgNFSHelper.DECREMENT_SET).contains(bgDimensionMember.getNumber()) && !bgDimensionMember.getNumber().equals(formOrgUnitNumber)) {
                        currMembers.remove(i2);
                        --i2;
                    }
                    curNumberSet.add(bgDimensionMember.getNumber());
                }
                for (i2 = 0; i2 < newMembers.size(); ++i2) {
                    bgDimensionMember = newMembers.get(i2);
                    if (bgDimensionMember == null || StringUtils.isEmpty((String)bgDimensionMember.getNumber()) || !map.get(BgNFSHelper.INCREMENT_SET).contains(bgDimensionMember.getNumber())) continue;
                    currMembers.add(bgDimensionMember);
                }
                newMembers.clear();
                newMembers.addAll(currMembers);
            }
        }
    }

    private boolean isAllOnView(List<MbgViewListSheetManager> mbgviewlistSheetManagers) {
        boolean isAllOnView = true;
        MbgViewListSheetManager mbgViewListSheetManaget = null;
        MbgViewListDimensionManager mbgViewListDimensionManager = null;
        for (int i = 0; i < mbgviewlistSheetManagers.size(); ++i) {
            mbgViewListSheetManaget = mbgviewlistSheetManagers.get(i);
            if (mbgViewListSheetManaget == null || (mbgViewListDimensionManager = mbgViewListSheetManaget.getDimensionManager()) == null || DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, mbgViewListDimensionManager.getViewDimension()) != null) continue;
            return false;
        }
        return isAllOnView;
    }

    private boolean isOrgInRowCol(List<MbgViewListSheetManager> mbgviewlistSheetManagers) {
        MbgViewListSheetManager mbgViewListSheetManaget = null;
        MbgViewListDimensionManager mbgViewListDimensionManager = null;
        for (int i = 0; i < mbgviewlistSheetManagers.size(); ++i) {
            mbgViewListSheetManaget = mbgviewlistSheetManagers.get(i);
            if (mbgViewListSheetManaget == null || (mbgViewListDimensionManager = mbgViewListSheetManaget.getDimensionManager()) == null || BgOrgAddServerHelper.isOrgOnPageOrView(mbgViewListDimensionManager)) continue;
            return true;
        }
        return false;
    }

    public MbgViewListManager getViewlistFormViewManager(Context ctx, BgFormInfo bgFormInfo) throws BOSException {
        byte[] bytes = null;
        try {
            CoreBaseCollection col = BgFormEntryFactory.getLocalInstance(ctx).getCollection("select dimensionData, dimensionStyle where bgForm.id = '" + bgFormInfo.getId() + "'");
            if (col != null && !col.isEmpty()) {
                bytes = ((BgFormEntryInfo)col.get(0)).getDimensionData();
            }
            return new MbgViewListXMLParser(ctx).parse(bytes);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public IMbgViewBase dealViewManager(List<BgDimensionMember> newMembers, boolean newIsRowColShowByTemp, int orgAddType, BgFormInfo bgFormInfo, List<Map<OrderObject, String>> messages, Set<Integer> sheetIndexs, List<BgDimensionMember> selectMembers, boolean canEditOtherAddedBgForm) throws EASBizException, BOSException {
        MbgViewListManager viewManager = this.getViewlistFormViewManager(this.getContext(), bgFormInfo);
        if (viewManager == null) {
            return viewManager;
        }
        MbgViewListSheetManager mbgViewListSheetManaget = null;
        MbgViewListManager mbgViewListViewManager = null;
        List<MbgViewListSheetManager> mbgviewlistSheetManagers = null;
        MbgViewListDimensionManager mbgViewListDimensionManager = null;
        if (viewManager instanceof MbgViewListManager) {
            mbgViewListViewManager = viewManager;
            mbgviewlistSheetManagers = mbgViewListViewManager.getSheetManagers();
            if (mbgviewlistSheetManagers == null) {
                return null;
            }
            if (this.isAllOnView(mbgviewlistSheetManagers)) {
                return null;
            }
            boolean isOrgInRowCol = this.isOrgInRowCol(mbgviewlistSheetManagers);
            MbgViewListDimensionInfo orgDimension = null;
            try {
                boolean isFirst = true;
                for (int i = 0; i < mbgviewlistSheetManagers.size(); ++i) {
                    mbgViewListSheetManaget = mbgviewlistSheetManagers.get(i);
                    if (mbgViewListSheetManaget == null) continue;
                    mbgViewListSheetManaget.setCanEditOtherAddedBgForm(canEditOtherAddedBgForm);
                    mbgViewListDimensionManager = mbgViewListSheetManaget.getDimensionManager();
                    if (mbgViewListDimensionManager == null) continue;
                    if (BgOrgAddServerHelper.isOrgOnPageOrView(mbgViewListDimensionManager)) {
                        orgDimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, mbgViewListDimensionManager);
                        if (orgDimension.getMember() != null && orgDimension.getMember().isEmpty()) {
                            orgDimension.getMember().add(this.getOrgDimensionMember(bgFormInfo));
                        }
                    } else {
                        orgDimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, mbgViewListDimensionManager);
                        if (orgDimension.getMember() != null && orgDimension.getMember().isEmpty()) {
                            orgDimension.getMember().add(this.getOrgDimensionMember(bgFormInfo));
                        }
                        MbgViewListSheetManager cloneSheet = DimensionCommonHelper.cloneSheetManager(mbgViewListSheetManaget);
                        orgDimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, cloneSheet.getDimensionManager());
                    }
                    ArrayList<BgDimensionMember> cloneMembers = new ArrayList<BgDimensionMember>(newMembers);
                    this.dealOrgMember(cloneMembers, selectMembers, orgDimension, bgFormInfo.getOrgUnit().getNumber());
                    if (sheetIndexs != null && !sheetIndexs.isEmpty()) {
                        if (orgAddType == 2 && sheetIndexs.contains(i)) {
                            this.dealSheetViewManager(cloneMembers, orgDimension, isOrgInRowCol, newIsRowColShowByTemp, orgAddType, mbgViewListSheetManaget, mbgViewListSheetManaget.isRowColShowbyTemp(), bgFormInfo, mbgViewListViewManager, messages, isFirst, canEditOtherAddedBgForm);
                        } else if (orgAddType != 2) {
                            this.dealSheetViewManager(cloneMembers, orgDimension, isOrgInRowCol, newIsRowColShowByTemp, orgAddType, mbgViewListSheetManaget, mbgViewListSheetManaget.isRowColShowbyTemp(), bgFormInfo, mbgViewListViewManager, messages, isFirst, canEditOtherAddedBgForm);
                        }
                    } else {
                        this.dealSheetViewManager(cloneMembers, orgDimension, isOrgInRowCol, newIsRowColShowByTemp, orgAddType, mbgViewListSheetManaget, mbgViewListSheetManaget.isRowColShowbyTemp(), bgFormInfo, mbgViewListViewManager, messages, isFirst, canEditOtherAddedBgForm);
                    }
                    isFirst = false;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return viewManager;
    }

    private BgDimensionMember getOrgDimensionMember(BgFormInfo bgFormInfo) {
        BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getOrgUnit().getName(), bgFormInfo.getOrgUnit().getNumber());
        member.setLevel(bgFormInfo.getOrgUnit().getLevel());
        member.setSortValue((Comparable)((Object)bgFormInfo.getOrgUnit().getLongNumber()));
        member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        member.setSimpleName(bgFormInfo.getOrgUnit().getSimpleName());
        member.setLongName(bgFormInfo.getOrgUnit().getDisplayName());
        return MbgViewListDimensionMember.getInstance(member);
    }

    public void dealSheetViewManager(List<BgDimensionMember> newMembers, MbgViewListDimensionInfo orgDimension, boolean isOrgInRowCol, boolean newIsRowColShowByTemp, int orgAddType, MbgViewListSheetManager curMbgSheetManager, boolean oldIsRowColShowbyTemp, BgFormInfo bgFormInfo, MbgViewListManager curMbgViewManager, List<Map<OrderObject, String>> messages, boolean isFirst, boolean canEditOtherAddedBgForm) throws Exception {
        boolean hasChange = this.hasChangBefore(newMembers, orgDimension, newIsRowColShowByTemp, oldIsRowColShowbyTemp);
        if (!hasChange) {
            return;
        }
        int curSheetIndex = -1;
        if (2 == orgAddType) {
            curSheetIndex = curMbgSheetManager.getSheetIndex();
        }
        Map result = this.execBatchAddNew(bgFormInfo.getId().toString(), newMembers, isOrgInRowCol, curSheetIndex, bgFormInfo, messages, newIsRowColShowByTemp, isFirst, canEditOtherAddedBgForm);
        hasChange = this.hasChangeAfter(newMembers, orgDimension, newIsRowColShowByTemp, oldIsRowColShowbyTemp);
        if (!hasChange) {
            return;
        }
        if (bgFormInfo.getBgTemplate().getBgScheme() == null && bgFormInfo.getBgScheme() != null) {
            bgFormInfo.getBgTemplate().setBgScheme(bgFormInfo.getBgScheme());
        }
        Map templateData = null;
        templateData = this.getContext() == null ? ViewListFacadeFactory.getRemoteInstance().initTemplateData(bgFormInfo.getBgTemplate(), this.getTemplateStyle(bgFormInfo), bgFormInfo.getOrgUnit().getId().toString(), false) : ViewListFacadeFactory.getLocalInstance(this.ctx).initTemplateData(bgFormInfo.getBgTemplate(), this.getTemplateStyle(bgFormInfo), bgFormInfo.getOrgUnit().getId().toString(), false);
        MbgViewListManager templateViewManager = (MbgViewListManager)templateData.get("dimensino.member");
        this.processManager(newMembers, orgDimension, newIsRowColShowByTemp, orgAddType, curMbgSheetManager.getSheetIndex(), oldIsRowColShowbyTemp, result, templateViewManager, curMbgViewManager, bgFormInfo);
    }

    private Map execBatchAddNew(String bgFormId, List<BgDimensionMember> newMembers, boolean isOrgInRowCol, int curSheetIndex, BgFormInfo bgFormInfo, List<Map<OrderObject, String>> messages, boolean newIsRowColShowByTemp, boolean isFirst, boolean canEditOtherAddedBgForm) throws Exception {
        Map result = null;
        if (StringUtils.isEmpty((String)bgFormId) || newMembers == null || newMembers.isEmpty()) {
            return result;
        }
        HashMap<String, BgDimensionMember> numbers = new HashMap<String, BgDimensionMember>();
        for (int i = 0; i < newMembers.size(); ++i) {
            numbers.put(newMembers.get(i).getNumber(), newMembers.get(i));
        }
        result = this.resultImpl != null ? this.resultImpl.getResult(newMembers, isOrgInRowCol, curSheetIndex) : this.getBatchAddNewResult(newMembers, isOrgInRowCol, curSheetIndex, bgFormInfo, newIsRowColShowByTemp, canEditOtherAddedBgForm);
        if (result == null || result.isEmpty()) {
            return result;
        }
        String title = ResourceBase.getString((String)MBG_RESOURCE, (String)((String)result.remove("result")), (Locale)this.getContext().getLocale());
        if (result.isEmpty() || result.keySet().size() == 1 && result.containsKey(MbgViewListDescriptionHelper.successFromViews)) {
            return result;
        }
        if (messages != null && this.getContext() != null) {
            this.buildDetailMessage(newMembers, numbers, result, messages, bgFormInfo, isFirst);
        }
        return result;
    }

    public StringBuffer buildDetailMessage(List<BgDimensionMember> newMembers, Map<String, BgDimensionMember> numbers, Map result, List<Map<OrderObject, String>> messages, BgFormInfo form, boolean isFirst) {
        StringBuffer detail = new StringBuffer();
        Map orgs = null;
        String msgKey2 = null;
        String msg = null;
        Object[] orgNumbers = null;
        OrderObject formTitle = null;
        OrderObject orgTitle = null;
        OrderObject addOrgTitle = null;
        OrderObject failedTitle = null;
        Object checkPeriodRange = null;
        if (this.getContext() != null) {
            formTitle = new OrderObject("formTitle", ResourceBase.getString((String)MBG_RESOURCE, (String)"formTitle", (Locale)this.ctx.getLocale()), 2);
            orgTitle = new OrderObject("orgTitle", ResourceBase.getString((String)MBG_RESOURCE, (String)"orgTitle", (Locale)this.ctx.getLocale()), 1);
            addOrgTitle = new OrderObject("addOrgTitle", ResourceBase.getString((String)MBG_RESOURCE, (String)"addOrgTitle", (Locale)this.ctx.getLocale()), 3);
            failedTitle = new OrderObject("failedTitle", ResourceBase.getString((String)MBG_RESOURCE, (String)"failedTitle", (Locale)this.ctx.getLocale()), 4);
        }
        for (String msgKey2 : result.keySet()) {
            if (msgKey2.equals(MbgViewListDescriptionHelper.successFromViews) || !isFirst && "addViewOrgLayoutDiff".equals(msgKey2)) continue;
            if (msgKey2.equals("checkPeriodRangeError")) {
                Map periodError = (Map)result.get(msgKey2);
                for (String temp : periodError.keySet()) {
                    HashMap<OrderObject, String> baseMsg = new HashMap<OrderObject, String>();
                    baseMsg.put(formTitle, form.getNumber() + "(" + form.getName() + ")");
                    baseMsg.put(orgTitle, form.getOrgUnit().getNumber() + "(" + form.getOrgUnit().getName() + ")");
                    baseMsg.put(addOrgTitle, temp);
                    msg = (String)periodError.get(temp);
                    msg = msg.substring(msg.indexOf("\uff0c") + 1);
                    baseMsg.put(failedTitle, msg);
                    if (messages == null) continue;
                    messages.add(baseMsg);
                }
                continue;
            }
            orgs = (Map)result.get(msgKey2);
            msg = EASResource.getString((String)MBG_RESOURCE, (String)msgKey2);
            orgNumbers = orgs.keySet().toArray();
            Arrays.sort(orgNumbers);
            for (int i = 0; i < orgNumbers.length; ++i) {
                if (newMembers != null && numbers != null) {
                    newMembers.remove(numbers.get(orgNumbers[i]));
                }
                HashMap<OrderObject, String> baseMsg = new HashMap<OrderObject, String>();
                String msgItem = MessageFormat.format(msg, ((DataBaseInfo)orgs.get(orgNumbers[i])).getName());
                msgItem = msgItem.substring(msgItem.indexOf("\uff0c") + 1);
                baseMsg.put(formTitle, form.getNumber() + "(" + form.getName() + ")");
                baseMsg.put(orgTitle, form.getOrgUnit().getNumber() + "(" + form.getOrgUnit().getName() + ")");
                baseMsg.put(addOrgTitle, ((DataBaseInfo)orgs.get(orgNumbers[i])).getNumber() + "(" + ((DataBaseInfo)orgs.get(orgNumbers[i])).getName() + ")");
                baseMsg.put(failedTitle, msgItem);
                if (messages == null) continue;
                messages.add(baseMsg);
            }
        }
        return detail;
    }

    private boolean hasChangBefore(List<BgDimensionMember> newMembers, MbgViewListDimensionInfo orgDimension, boolean newIsRowColShowByTemp, boolean oldIsRowColShowbyTemp) {
        boolean hasChange;
        boolean bl = hasChange = newMembers.size() != orgDimension.getMember().size();
        if (!hasChange) {
            for (int i = 0; i < newMembers.size(); ++i) {
                if (newMembers.get(i).getNumber().equals(((BgDimensionMember)orgDimension.getMember().get(i)).getNumber())) continue;
                hasChange = true;
                break;
            }
        }
        if (oldIsRowColShowbyTemp != newIsRowColShowByTemp) {
            hasChange = true;
        }
        if (!hasChange) {
            hasChange = false;
        }
        return hasChange;
    }

    private boolean hasChangeAfter(List<BgDimensionMember> newMembers, MbgViewListDimensionInfo orgDimension, boolean newIsRowColShowByTemp, boolean oldIsRowColShowbyTemp) {
        boolean hasChange = true;
        if (oldIsRowColShowbyTemp == newIsRowColShowByTemp) {
            int i;
            HashSet<String> oldNumbers = new HashSet<String>();
            for (i = 0; i < orgDimension.getMember().size(); ++i) {
                oldNumbers.add(BgViewHelper.getNumber(orgDimension.getMember().get(i)));
            }
            if (oldNumbers.size() == newMembers.size()) {
                hasChange = false;
                for (i = 0; i < newMembers.size(); ++i) {
                    if (oldNumbers.contains(BgViewHelper.getNumber(newMembers.get(i)))) continue;
                    hasChange = true;
                    break;
                }
                if (!hasChange && newMembers.size() == orgDimension.getMember().size()) {
                    for (i = 0; i < newMembers.size(); ++i) {
                        if (newMembers.get(i).getNumber().equals(((BgDimensionMember)orgDimension.getMember().get(i)).getNumber())) continue;
                        hasChange = true;
                        break;
                    }
                }
                if (!hasChange) {
                    hasChange = false;
                }
            }
        }
        return hasChange;
    }

    private TemplateStyleInfo getTemplateStyle(BgFormInfo bgFormInfo) throws Exception {
        BgTemplateInfo bgTemplate;
        if (bgFormInfo == null) {
            return null;
        }
        if (bgFormInfo.getBgTemplate() != null && (bgTemplate = bgFormInfo.getBgTemplate()).getStyleSet() != null && bgTemplate.getStyleSet().getData() != null) {
            this.getParser();
            return MbgViewListXMLParser.parseStyle(bgTemplate.getStyleSet().getData());
        }
        return null;
    }

    private MbgViewListXMLParser getParser() {
        return new MbgViewListXMLParser(this.ctx);
    }

    private void processManager(List<BgDimensionMember> newMembers, MbgViewListDimensionInfo orgDimension, boolean newIsRowColShowByTemp, int orgAddType, int curIndex, boolean oldIsRowColShowbyTemp, Map result, MbgViewListManager templateViewManager, MbgViewListManager curMbgViewManager, BgFormInfo bgFormInfo) throws DimensionException {
        curMbgViewManager.setOrgAddType(orgAddType);
        for (int s = 0; s < curMbgViewManager.getSheetManagers().size(); ++s) {
            if (s != curIndex) continue;
            MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)curMbgViewManager.getSheetManagers().get(s);
            sheetManager.setRowColShowbyTemp(newIsRowColShowByTemp);
            if (!BgOrgAddServerHelper.isOrgOnPageOrView(sheetManager.getDimensionManager()) && result != null && result.containsKey(MbgViewListDescriptionHelper.successFromViews)) {
                this.processOrgMemberOnRowCol(result, sheetManager, orgDimension, newMembers, oldIsRowColShowbyTemp, bgFormInfo.getOrgUnit().getNumber(), (MbgViewListSheetManager)templateViewManager.getSheetManagers().get(s));
                continue;
            }
            MbgViewListDimensionInfo sheetOrgDim = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, sheetManager.getDimensionManager());
            sheetOrgDim.getMember().clear();
            sheetOrgDim.getMember().addAll(newMembers);
            sheetOrgDim.getSelectMembers().clear();
            sheetOrgDim.getSelectMembers().addAll(newMembers);
            sheetOrgDim.unParseMember();
        }
    }

    private void processOrgMemberOnRowCol(Map result, MbgViewListSheetManager sheetManger, MbgViewListDimensionInfo orgDimension, List<BgDimensionMember> newMembers, boolean oldIsRowColShowbyTemp, String currentOrgNum, MbgViewListSheetManager templateSheetManager) {
        boolean isRowColShowbyTemp = sheetManger.isRowColShowbyTemp();
        if (isRowColShowbyTemp) {
            this.processRowColShowbyTemp(result, sheetManger, orgDimension, newMembers, oldIsRowColShowbyTemp, currentOrgNum, templateSheetManager);
        } else {
            this.processRowColShowbyOrg(result, sheetManger, orgDimension, newMembers, oldIsRowColShowbyTemp, currentOrgNum);
        }
    }

    private void processRowColShowbyOrg(Map result, MbgViewListSheetManager sheetManager, MbgViewListDimensionInfo orgDimension, List<BgDimensionMember> newMembers, boolean oldIsRowColShowbyTemp, String currentOrgNum) {
        Boolean isOrgOnRow = MbgViewListFormServerHelper.isOrgOnRow(sheetManager.getDimensionManager());
        Map viewlistManagerMap = (Map)result.get(MbgViewListDescriptionHelper.successFromViews);
        ArrayList<String> newOrgNums = new ArrayList<String>();
        for (int i = 0; i < newMembers.size(); ++i) {
            newOrgNums.add(newMembers.get(i).getNumber());
        }
        String orgNum2 = null;
        MbgViewListManager viewManager = null;
        ArrayList<IMbgViewListObject> addRowCols = new ArrayList<IMbgViewListObject>();
        Map<String, List<IMbgViewListObject>> oldOrgAndRowCols = null;
        if (oldIsRowColShowbyTemp && orgDimension.getMember().size() != 1) {
            Map<String, Map<Integer, IMbgViewListObject>> tMap = MbgViewListFormServerHelper.getViewListIndexObjectsByTemp(sheetManager.getDimensionManager(), isOrgOnRow, currentOrgNum);
            oldOrgAndRowCols = new HashMap<String, List<IMbgViewListObject>>();
            if (tMap != null && !tMap.isEmpty()) {
                for (String oNum : tMap.keySet()) {
                    Map<Integer, IMbgViewListObject> oMap = tMap.get(oNum);
                    if (!oldOrgAndRowCols.containsKey(oNum)) {
                        oldOrgAndRowCols.put(oNum, new ArrayList());
                    }
                    oldOrgAndRowCols.get(oNum).addAll(oMap.values());
                    if (oNum.equals(currentOrgNum) || !viewlistManagerMap.containsKey(oNum)) continue;
                    List<IMbgViewListObject> notCurrentOrgObjs = isOrgOnRow != false ? ((MbgViewListSheetManager)((MbgViewListManager)viewlistManagerMap.get(oNum)).getSheetManagers().get(sheetManager.getSheetIndex())).getDimensionManager().getRows() : ((MbgViewListSheetManager)((MbgViewListManager)viewlistManagerMap.get(oNum)).getSheetManagers().get(sheetManager.getSheetIndex())).getDimensionManager().getColumns();
                    for (int mn = 0; mn < notCurrentOrgObjs.size(); ++mn) {
                        if (!(notCurrentOrgObjs.get(mn) instanceof MbgViewListCalcutor) && !(notCurrentOrgObjs.get(mn) instanceof MbgViewListDescription)) continue;
                        oldOrgAndRowCols.get(oNum).add(notCurrentOrgObjs.get(mn));
                    }
                }
            }
        } else {
            oldOrgAndRowCols = MbgViewListFormServerHelper.getViewListObjectsByOrg(sheetManager.getDimensionManager(), isOrgOnRow);
        }
        for (String orgNum2 : newOrgNums) {
            if (oldOrgAndRowCols != null && oldOrgAndRowCols.containsKey(orgNum2)) {
                addRowCols.addAll((Collection)oldOrgAndRowCols.get(orgNum2));
                continue;
            }
            if (!viewlistManagerMap.containsKey(orgNum2)) continue;
            viewManager = (MbgViewListManager)viewlistManagerMap.get(orgNum2);
            if (isOrgOnRow.booleanValue()) {
                addRowCols.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetManager.getSheetIndex())).getDimensionManager().getRows());
                continue;
            }
            addRowCols.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetManager.getSheetIndex())).getDimensionManager().getColumns());
        }
        if (isOrgOnRow.booleanValue()) {
            sheetManager.getDimensionManager().getRows().clear();
            sheetManager.getDimensionManager().getRows().addAll(addRowCols);
        } else {
            sheetManager.getDimensionManager().getColumns().clear();
            sheetManager.getDimensionManager().getColumns().addAll(addRowCols);
        }
        this.resetObjectIndex(isOrgOnRow != false ? sheetManager.getDimensionManager().getRows() : sheetManager.getDimensionManager().getColumns());
    }

    private void processRowColShowbyTemp(Map result, MbgViewListSheetManager sheetManager, MbgViewListDimensionInfo orgDimension, List<BgDimensionMember> newMembers, boolean oldIsRowColShowbyTemp, String currentOrgNum, MbgViewListSheetManager templateSheetManager) {
        Boolean isOrgOnRow = MbgViewListFormServerHelper.isOrgOnRow(sheetManager.getDimensionManager());
        Map viewlistManagerMap = (Map)result.get(MbgViewListDescriptionHelper.successFromViews);
        List oldMembers = orgDimension.getMember();
        HashSet<String> oldOrgNums = new HashSet<String>();
        for (int i = 0; i < oldMembers.size(); ++i) {
            oldOrgNums.add(((BgDimensionMember)oldMembers.get(i)).getNumber());
        }
        ArrayList<String> newOrgNums = new ArrayList<String>();
        for (int i = 0; i < newMembers.size(); ++i) {
            newOrgNums.add(newMembers.get(i).getNumber());
        }
        String orgNum2 = null;
        Integer objectIndex = -1;
        ArrayList<Integer> indexLst = new ArrayList<Integer>();
        Map<String, Map<Integer, IMbgViewListObject>> newViewlistObjMap = MbgViewListFormServerHelper.getViewListIndexObjects(viewlistManagerMap, sheetManager.getSheetIndex(), isOrgOnRow);
        List<IMbgViewListObject> oldRowCols = isOrgOnRow != false ? sheetManager.getDimensionManager().getRows() : sheetManager.getDimensionManager().getColumns();
        for (IMbgViewListObject iObject : oldRowCols) {
            if (indexLst.contains(MbgViewListFormServerHelper.getIndex(iObject))) continue;
            indexLst.add(MbgViewListFormServerHelper.getIndex(iObject));
        }
        Collections.sort(indexLst);
        Map<String, Map<Integer, IMbgViewListObject>> oldRowColMap = MbgViewListFormServerHelper.getViewListIndexObjectsByTemp(oldRowCols, currentOrgNum);
        ArrayList<IMbgViewListObject> addRowCols = new ArrayList<IMbgViewListObject>();
        for (int i = 0; i < indexLst.size(); ++i) {
            objectIndex = (Integer)indexLst.get(i);
            for (String orgNum2 : newOrgNums) {
                Map<Integer, IMbgViewListObject> tmpMap;
                if (newViewlistObjMap.containsKey(orgNum2)) {
                    tmpMap = newViewlistObjMap.get(orgNum2);
                    if (tmpMap.get(objectIndex) instanceof MbgViewListRowCol) {
                        addRowCols.add(tmpMap.get(objectIndex));
                        continue;
                    }
                    if (!orgNum2.equals(currentOrgNum)) continue;
                    addRowCols.add(tmpMap.get(objectIndex));
                    continue;
                }
                if (!oldRowColMap.containsKey(orgNum2) || (tmpMap = newViewlistObjMap.get(orgNum2)) == null || !tmpMap.containsKey(objectIndex)) continue;
                addRowCols.add(tmpMap.get(objectIndex));
            }
        }
        if (isOrgOnRow.booleanValue()) {
            sheetManager.getDimensionManager().getRows().clear();
            sheetManager.getDimensionManager().getRows().addAll(addRowCols);
        } else {
            sheetManager.getDimensionManager().getColumns().clear();
            sheetManager.getDimensionManager().getColumns().addAll(addRowCols);
        }
        Map<String, Map<Integer, IMbgViewListObject>> oldViewlistObjMap = MbgViewListFormServerHelper.getViewListIndexObjectsByTemp(sheetManager.getDimensionManager(), isOrgOnRow, currentOrgNum);
        for (String orgNum2 : oldOrgNums) {
            if (viewlistManagerMap.containsKey(orgNum2) || !oldViewlistObjMap.containsKey(orgNum2)) continue;
            Map<Integer, IMbgViewListObject> tMap = oldViewlistObjMap.get(orgNum2);
            for (IMbgViewListObject vObject : tMap.values()) {
                if (isOrgOnRow.booleanValue()) {
                    sheetManager.getDimensionManager().getRows().remove(vObject);
                    continue;
                }
                sheetManager.getDimensionManager().getColumns().remove(vObject);
            }
        }
        this.resetObjectIndex(isOrgOnRow != false ? sheetManager.getDimensionManager().getRows() : sheetManager.getDimensionManager().getColumns());
        this.processViewListCellsByTemp(sheetManager, isOrgOnRow, templateSheetManager, currentOrgNum);
    }

    private void resetObjectIndex(List<IMbgViewListObject> list) {
        if (list != null && !list.isEmpty()) {
            for (int index = 0; index < list.size(); ++index) {
                list.get(index).setIndex(index);
            }
        }
    }

    private void processViewListCellsByTemp(MbgViewListSheetManager sheetManager, boolean isOrgOnRow, MbgViewListSheetManager templateSheetManager, String currentOrgNum) {
        List<MbgViewListCell> oldViewListCells = templateSheetManager.getDimensionManager().getCells();
        MbgViewListSheetManager cloneSheetManager = DimensionCommonHelper.cloneSheetManager(sheetManager);
        Map<String, Map<String, MbgViewListCell>> viewListCells = MbgViewListFormServerHelper.getViewListCellsByTemp(cloneSheetManager.getDimensionManager(), isOrgOnRow, currentOrgNum);
        if (oldViewListCells == null || oldViewListCells.isEmpty() || viewListCells == null || viewListCells.isEmpty()) {
            return;
        }
        MbgViewListCell viewListCell = null;
        HashMap<String, MbgViewListCell> cellsMap = new HashMap<String, MbgViewListCell>();
        for (int i = 0; i < oldViewListCells.size(); ++i) {
            viewListCell = oldViewListCells.get(i);
            IMbgViewListObject row = viewListCell.getRow();
            IMbgViewListObject col = viewListCell.getCol();
            cellsMap.put(row.getIndex() + BgBaseConstants.SEP_FOUR_STR + col.getIndex(), viewListCell);
        }
        IMbgViewListObject rowCol = null;
        HashMap<IMbgViewListObject, Integer> indexMap = new HashMap<IMbgViewListObject, Integer>();
        List<IMbgViewListObject> rowCols = isOrgOnRow ? cloneSheetManager.getDimensionManager().getRows() : cloneSheetManager.getDimensionManager().getColumns();
        for (int index = 0; index < rowCols.size(); ++index) {
            rowCol = rowCols.get(index);
            if (indexMap.containsKey(rowCol.getIndex())) continue;
            indexMap.put(rowCol, index);
        }
        sheetManager.getDimensionManager().getCells().clear();
        for (String orgNum : viewListCells.keySet()) {
            Map<String, MbgViewListCell> temMap = viewListCells.get(orgNum);
            HashMap cloneCellMap = new HashMap();
            cloneCellMap.putAll(DimensionCommonHelper.deepclone(cellsMap));
            for (String key : temMap.keySet()) {
                IMbgViewListObject tRowCol;
                MbgViewListCell cell = temMap.get(key);
                if (!cloneCellMap.containsKey(key)) continue;
                if (isOrgOnRow) {
                    rowCol = cell.getRow();
                    tRowCol = ((MbgViewListCell)cloneCellMap.get(key)).getRow();
                } else {
                    rowCol = cell.getCol();
                    tRowCol = ((MbgViewListCell)cloneCellMap.get(key)).getCol();
                }
                if (!indexMap.containsKey(rowCol)) continue;
                tRowCol.setIndex((Integer)indexMap.get(rowCol));
                sheetManager.getDimensionManager().getCells().add((MbgViewListCell)cloneCellMap.get(key));
            }
        }
    }

    private Map getBatchAddNewResult(List<BgDimensionMember> newMembers, boolean isOrgInRowCol, int curSheetIndex, BgFormInfo bgFormInfo, boolean isShowByTemp, boolean canEditOtherAddedBgForm) throws EASBizException, BOSException {
        if (this.getContext() == null) {
            return MBGViewListFormFacadeFactory.getRemoteInstance().addNewViewListFormInfo(bgFormInfo.getId().toString(), new HashSet<BgDimensionMember>(newMembers), this.getAddNewPermissionNumber(), !isOrgInRowCol, curSheetIndex, true, isShowByTemp, canEditOtherAddedBgForm);
        }
        return MBGViewListFormFacadeFactory.getLocalInstance(this.ctx).addNewViewListFormInfo(bgFormInfo.getId().toString(), new HashSet<BgDimensionMember>(newMembers), this.getAddNewPermissionNumber(), !isOrgInRowCol, curSheetIndex, true, isShowByTemp, canEditOtherAddedBgForm);
    }

    public static boolean isOrgOnPageOrView(IBgDimensionManagerBase dimensionManager) {
        List viewDimension = dimensionManager.getViewDisplayDimension();
        for (int i = 0; i < viewDimension.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)viewDimension.get(i)).getNumber())) continue;
            return Boolean.TRUE;
        }
        List pageDimension = dimensionManager.getPageDisplayDimension();
        for (int i = 0; i < pageDimension.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)pageDimension.get(i)).getNumber())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        stateSet.add(42);
        stateSet.add(1);
    }
}

