/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgDimRelationRefServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class BgViewServerHelper {
    private static final Logger logger = Logger.getLogger((String)BgViewServerHelper.class.getName());

    public static StringBuffer getQuerySQL(Context ctx) {
        StringBuffer sql = new StringBuffer("select bgForm.FID bgForm_FID, bgForm.FSourceType bgForm_FSourceType, bgForm.FNumber bgForm_FNumber, bgForm.FName bgForm_FName, bgForm.FDescription bgForm_FDescription, bgForm.FState bgForm_FState, ");
        sql.append(" bgScheme.FID bgScheme_FID, tNode.FOrgUnitId bgScheme_FOrgUnitId, orgUnit.FNumber orgUnit_FNumber, bgOrgUnit.FLongNumber bgOrgUnit_FLongNumber,bgOrgUnit.FIsLeaf bgOrgUnit_FIsLeaf, orgUnit.FName_" + ctx.getLocale() + " orgUnit_FName, bgTemplate.FID bgTemplate_FID,");
        sql.append(" bgTemplate.FLastUpdateTime bgTemplate_FLastUpdateTime, bgTemplate.FBgTypeId bgTemplate_FBgTypeId, ");
        sql.append(" bgTemplate.FDefaultMeasureUnitID bgTemplate_FDMUID, bgForm.FBgPeriodId bgForm_FBgPeriodId, bgForm.FCurrencyID bgForm_FCurrencyID,");
        sql.append(" bgForm.FCreatorID bgForm_FCreatorID ");
        sql.append(" from T_MBg_bgTemplate bgTemplate ");
        sql.append(" inner join T_Mbg_BgTemplateNode tNode on tNode.FBgTemplateId = bgTemplate.FID ");
        sql.append(" left join T_MBg_bgscheme bgScheme on bgScheme.FID = bgTemplate.FBgSchemeID ");
        sql.append(" left join T_Org_CostCenter orgUnit on tNode.FOrgUnitId = orgUnit.FID ");
        sql.append(" left join T_Mbg_BgOrgUnit bgOrgUnit on bgOrgUnit.FOrgUnitId = orgUnit.FID and bgOrgUnit.FIsVirtual = 0");
        sql.append(" left join T_MBg_bgform bgForm on bgForm.FBgSchemeId = bgScheme.FID and bgForm.FBgTemplateId = bgTemplate.FID and bgForm.FOrgUnitId = tNode.FOrgUnitId");
        return sql;
    }

    public static BgFormInfo buildBgFormInfo(ResultSet res) throws SQLException {
        BgFormInfo b = new BgFormInfo();
        if (!StringUtils.isEmpty((String)res.getString("bgForm_FID"))) {
            b.setId(BOSUuid.read((String)res.getString("bgForm_FID")));
            b.setNumber(res.getString("bgForm_FNumber"));
            b.setName(res.getString("bgForm_FName"));
            b.setDescription(res.getString("bgForm_FDescription"));
            b.setBgPeriod(new BgPeriodInfo());
            b.getBgPeriod().setId(BOSUuid.read((String)res.getString("bgForm_FBgPeriodId")));
            b.setCurrency(new CurrencyInfo());
            b.getCurrency().setId(BOSUuid.read((String)res.getString("bgForm_FCurrencyID")));
            b.setState(BgFormStateEnum.getEnum(res.getInt("bgForm_FState")));
            b.setSourceType(com.kingdee.eas.fi.rpt.RptSrcTypeEnum.getEnum((int)res.getInt("bgForm_FSourceType")));
        }
        b.setBgScheme(new BgSchemeInfo());
        b.getBgScheme().setId(BOSUuid.read((String)res.getString("bgScheme_FID")));
        b.setOrgUnit(new FullOrgUnitInfo());
        b.getOrgUnit().setId(BOSUuid.read((String)res.getString("bgScheme_FOrgUnitId")));
        b.getOrgUnit().setNumber(res.getString("orgUnit_FNumber"));
        b.getOrgUnit().setName(res.getString("orgUnit_FName"));
        b.getOrgUnit().setLongNumber(res.getString("bgOrgUnit_FLongNumber"));
        b.getOrgUnit().setIsLeaf(res.getBoolean("bgOrgUnit_FIsLeaf"));
        b.setBgTemplate(new BgTemplateInfo());
        b.getBgTemplate().setId(BOSUuid.read((String)res.getString("bgTemplate_FID")));
        b.setTemplateLastUpdateTime(res.getTimestamp("bgTemplate_FLastUpdateTime"));
        if (!StringUtils.isEmpty((String)res.getString("bgTemplate_FBgTypeId"))) {
            b.setBgType(new BgTypeInfo());
            b.getBgType().setId(BOSUuid.read((String)res.getString("bgTemplate_FBgTypeId")));
        }
        b.setMeasureUnit(new MeasureUnitInfo());
        b.getMeasureUnit().setId(BOSUuid.read((String)res.getString("bgTemplate_FDMUID")));
        if (res.getString("bgForm_FCreatorID") != null) {
            b.setCreator(new UserInfo());
            b.getCreator().setId(BOSUuid.read((String)res.getString("bgForm_FCreatorID")));
        }
        return b;
    }

    public static void batchAddNewView(Context ctx, Connection conn, List newForms, boolean isCheckNumber, String bgSchemeId) throws BOSException, EASBizException {
        if (ctx != null && !newForms.isEmpty()) {
            boolean closeConn = false;
            try {
                if (conn == null) {
                    closeConn = true;
                    conn = EJBFactory.getConnection((Context)ctx);
                }
                if (isCheckNumber) {
                    BgViewServerHelper.checkNumber(ctx, conn, newForms, bgSchemeId);
                }
                BgViewServerHelper.fillRptPeriod(ctx, newForms);
                BgViewServerHelper.fillOrgInfo(ctx, conn, newForms);
                BgViewServerHelper.batchAddNew(ctx, conn, newForms);
                BgViewServerHelper.batchUpdateRelationByInfo(ctx, conn, newForms);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (closeConn) {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
    }

    private static void checkNumber(Context ctx, Connection conn, List newForms, String bgSchemeId) throws BOSException, EASBizException {
        int i;
        BgFormInfo b;
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashMap<String, Set> numbers = new HashMap<String, Set>();
        for (int i2 = 0; i2 < newForms.size(); ++i2) {
            b = (BgFormInfo)newForms.get(i2);
            if (!numbers.containsKey(b.getNumber())) {
                numbers.put(b.getNumber(), new HashSet());
            }
            ((Set)numbers.get(b.getNumber())).add(b.getOrgUnit().getId().toString());
        }
        Object[] ns = numbers.keySet().toArray();
        for (i = 0; i < ns.length; ++i) {
            String number = (String)ns[i];
            Set orgIds = (Set)numbers.get(ns[i]);
            if ((orgIds = BgViewServerHelper.checkNumber(ctx, conn, "FNumber", number, "FOrgUnitID", orgIds, false, bgSchemeId)) == null) {
                numbers.remove(number);
                continue;
            }
            numbers.put(number, orgIds);
        }
        for (i = newForms.size() - 1; i >= 0; --i) {
            Set orgIds;
            b = (BgFormInfo)newForms.get(i);
            if (numbers.get(b.getNumber()) == null || !(orgIds = (Set)numbers.get(b.getNumber())).contains(b.getOrgUnit().getId().toString())) continue;
            newForms.remove(i);
        }
    }

    private static void fillRptPeriod(Context ctx, List newForms) throws BOSException, EASBizException {
        int i;
        BgFormInfo b;
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashSet<String> periodIds = new HashSet<String>();
        for (int i2 = 0; i2 < newForms.size(); ++i2) {
            b = (BgFormInfo)newForms.get(i2);
            periodIds.add(String.valueOf(b.getBgPeriod().getId()));
        }
        HashMap<String, BgPeriodInfo> bgPeriods = new HashMap<String, BgPeriodInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("periodType");
        evi.getSelector().add("year");
        evi.getSelector().add("month");
        evi.getSelector().add("halfYear");
        evi.getSelector().add("quart");
        evi.getSelector().add("beginDate");
        evi.getSelector().add("endDate");
        evi.getSelector().add("week");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
        if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
            for (i = 0; i < bgPeriodCol.size(); ++i) {
                bgPeriods.put(bgPeriodCol.get(i).getId().toString(), bgPeriodCol.get(i));
            }
        }
        for (i = 0; i < newForms.size(); ++i) {
            b = (BgFormInfo)newForms.get(i);
            b.setBgPeriod((BgPeriodInfo)bgPeriods.get(b.getBgPeriod().getId().toString()));
            BgViewHelper.converPeriodToRPT(b);
        }
    }

    private static void fillOrgInfo(Context ctx, Connection conn, List newForms) throws BOSException, EASBizException {
        if (conn == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashMap orgInfo = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < newForms.size(); ++i) {
            ids.add(String.valueOf(((BgFormInfo)newForms.get(i)).getOrgUnit().getId()));
        }
        PreparedStatement pstmt = null;
        try {
            StringBuffer sql = new StringBuffer("Select FID, FControlUnitID, FParentID, FIsCompanyOrgUnit From T_Org_CostCenter Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            BgViewServerHelper.queryOrgInfo(pstmt, ids, orgInfo);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        ArrayList<BgFormInfo> rmForm = new ArrayList<BgFormInfo>();
        for (int i = 0; i < newForms.size(); ++i) {
            BgFormInfo b = (BgFormInfo)newForms.get(i);
            if (orgInfo.get(b.getOrgUnit().getId().toString()) == null) {
                rmForm.add(b);
                continue;
            }
            b.setCU(((FullOrgUnitInfo)orgInfo.get(b.getOrgUnit().getId().toString())).getCU());
            b.setCompany(new CompanyOrgUnitInfo());
            b.getCompany().setId(BgViewServerHelper.getCompanyId(b.getOrgUnit().getId().toString(), orgInfo));
        }
        newForms.removeAll(rmForm);
    }

    private static BOSUuid getCompanyId(String id, Map orgInfo) {
        if (StringUtils.isEmpty((String)id) || orgInfo == null || !orgInfo.containsKey(id)) {
            return null;
        }
        FullOrgUnitInfo org = (FullOrgUnitInfo)orgInfo.get(id);
        if (org.isIsCompanyOrgUnit()) {
            return org.getId();
        }
        if (org.getParent() == null) {
            return null;
        }
        return BgViewServerHelper.getCompanyId(org.getParent().getId().toString(), orgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryOrgInfo(PreparedStatement pstmt, Set ids, Map orgInfo) throws SQLException {
        if (pstmt == null || ids == null || ids.isEmpty() || orgInfo == null) {
            return;
        }
        ids.removeAll(orgInfo.keySet());
        if (ids.isEmpty()) {
            return;
        }
        Object[] params = ids.toArray();
        int batchCount = (params.length - 1) / 50 + 1;
        HashSet<String> newIds = new HashSet<String>();
        ResultSet res = null;
        try {
            for (int i = 0; i < batchCount; ++i) {
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)50, (Object[])params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    FullOrgUnitInfo org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)res.getString("FID")));
                    org.setIsCompanyOrgUnit(res.getBoolean("FIsCompanyOrgUnit"));
                    org.setCU(new CtrlUnitInfo());
                    org.getCU().setId(BOSUuid.read((String)res.getString("FControlUnitID")));
                    if (!StringUtils.isEmpty((String)res.getString("FParentID"))) {
                        org.setParent(new FullOrgUnitInfo());
                        org.getParent().setId(BOSUuid.read((String)res.getString("FParentID")));
                    }
                    if (!org.isIsCompanyOrgUnit() && org.getParent() != null) {
                        newIds.add(org.getParent().getId().toString());
                    }
                    orgInfo.put(org.getId().toString(), org);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        finally {
            SQLUtils.cleanup(res);
        }
        BgViewServerHelper.queryOrgInfo(pstmt, newIds, orgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchAddNew(Context ctx, Connection conn, List newForms) throws BOSException, EASBizException {
        if (ctx == null || conn == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        String tempForm = null;
        try {
            tempForm = BgViewServerHelper.createTempFormTable(ctx, conn);
            BgViewServerHelper.insertTempFormTable(ctx, conn, tempForm, newForms);
            BgViewServerHelper.updateTempFormXml(ctx, conn, tempForm);
            BgViewServerHelper.insertIntoBgFormTable(ctx, conn, tempForm);
        }
        finally {
            if (tempForm != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempForm);
            }
        }
    }

    private static String createTempFormTable(Context ctx, Connection conn) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String sql = "Create Table T_MBg_BgFormTemp (FID VARCHAR(44) ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName NVARCHAR(80),FNumber NVARCHAR(80),FDescription NVARCHAR(2000),FYear INT,FPeriod INT,FStartDate DateTime,FEndDate DateTime,FAuditorID VARCHAR(44),FTemplateID VARCHAR(44),FCompanyID VARCHAR(44),FPeriodType INT,FPublicStatus INT,FPublishedStatus INT,FCommittedStatus INT,FHandleStatus INT,FSourceType INT,FOrgTreeID VARCHAR(44),FCurrencyID VARCHAR(44),FAuditedTime DateTime,FAuditedStatus INT,FCheckedStatus INT,FData BLOB(10485760),FAdjustMapData BLOB(1048576),FDataSource INT,FState INT,FProcessType INT DEFAULT 1,FBgSchemeID VARCHAR(44),FBgTemplateID VARCHAR(44),FBgPeriodID VARCHAR(44), FBgVersionId VARCHAR(44), FOrgUnitID VARCHAR(44),FBgTypeID VARCHAR(44),FMeasureUnitID VARCHAR(44),FVersionNo NUMERIC(21,8) ,FAdjustID VARCHAR(44),FTemplateLastUpdateTime DateTime NOT NULL ,FXNum VARCHAR(100) ,FIsChangeType INT ,FCourseOrgId VARCHAR(44),FCourseUserId VARCHAR(44),FCourseTime DateTime,FCertificateUserId VARCHAR(44),FCertificateTime DateTime,FBackUserId VARCHAR(44),FBackTime DateTime,FStateBeforeAudit INT,FBgItemGroupID VARCHAR(44),FRecord INT ,FBgItemID VARCHAR(44), FEntryID varchar(44), FDimensionData BLOB(10485760),FBgRollRuleId VARCHAR(44))";
        try {
            return pool.createTempTable(sql);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private static void insertTempFormTable(Context ctx, Connection conn, String tempForm, List newForms) throws BOSException, EASBizException {
        if (ctx == null || conn == null || tempForm == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        BOSObjectType bosType = new BgFormEntryInfo().getBOSType();
        int batchCount = 100;
        PreparedStatement pstmt = null;
        Object[] fs = BgViewServerHelper.getInsertFormFields();
        StringBuffer sql = new StringBuffer("INSERT INTO ").append(tempForm).append("(");
        BgViewHelper.convertArray(fs, sql);
        sql.append(", FEntryId) values (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)(fs.length + 1)).append(")");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int index = 0;
            for (int i = 0; i < newForms.size(); ++i) {
                BgFormInfo newForm = (BgFormInfo)newForms.get(i);
                pstmt.setString(1, newForm.getId().toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, now);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, now);
                pstmt.setString(6, newForm.getCU().getId().toString());
                pstmt.setString(7, newForm.getName());
                pstmt.setString(8, newForm.getNumber());
                pstmt.setString(9, newForm.getDescription());
                pstmt.setInt(10, newForm.getYear());
                pstmt.setInt(11, newForm.getPeriod());
                pstmt.setDate(12, new java.sql.Date(newForm.getBgPeriod().getBeginDate().getTime()));
                pstmt.setDate(13, new java.sql.Date(newForm.getBgPeriod().getEndDate().getTime()));
                pstmt.setString(14, newForm.getCompany().getId().toString());
                if (newForm.getPeriodType() != null) {
                    pstmt.setInt(15, newForm.getPeriodType().getValue());
                } else {
                    pstmt.setInt(15, newForm.getBgPeriod().getPeriodType().getValue());
                }
                pstmt.setInt(16, newForm.getSourceType().getValue());
                pstmt.setString(17, newForm.getCurrency().getId().toString());
                pstmt.setInt(18, 1);
                pstmt.setInt(19, 1);
                pstmt.setBytes(20, null);
                pstmt.setInt(21, 0);
                pstmt.setInt(22, 1);
                pstmt.setString(23, newForm.getBgScheme().getId().toString());
                pstmt.setString(24, newForm.getBgTemplate().getId().toString());
                pstmt.setString(25, newForm.getBgPeriod().getId().toString());
                pstmt.setString(26, newForm.getBgVersion().getId().toString());
                pstmt.setString(27, newForm.getOrgUnit().getId().toString());
                if (newForm.getBgType() == null) {
                    pstmt.setString(28, null);
                } else {
                    pstmt.setString(28, newForm.getBgType().getId().toString());
                }
                pstmt.setString(29, newForm.getMeasureUnit().getId().toString());
                pstmt.setBigDecimal(30, BgNConstants.ONE);
                pstmt.setString(31, newForm.getId().toString());
                if (newForm.getTemplateLastUpdateTime() == null) {
                    pstmt.setTimestamp(32, now);
                } else {
                    pstmt.setTimestamp(32, newForm.getTemplateLastUpdateTime());
                }
                pstmt.setString(33, "");
                pstmt.setBoolean(34, false);
                pstmt.setInt(35, 1);
                pstmt.setInt(36, 0);
                pstmt.setInt(37, newForm.getProcessType().getValue());
                if (newForm.getBgRollRule() != null && newForm.getBgRollRule().getId() != null) {
                    pstmt.setString(38, newForm.getBgRollRule().getId().toString());
                } else {
                    pstmt.setString(38, null);
                }
                pstmt.setString(39, BOSUuid.create((BOSObjectType)bosType).toString());
                pstmt.addBatch();
                if (++index <= 100) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private static void insertIntoBgFormTable(Context ctx, Connection conn, String tempForm) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)tempForm)) {
            return;
        }
        Object[] fs = BgViewServerHelper.getInsertFormFields();
        StringBuffer sql = new StringBuffer("Insert into T_MBg_BgForm (");
        BgViewHelper.convertArray(fs, sql);
        sql.append(") select ");
        BgViewHelper.convertArray(fs, sql);
        sql.append(" from ").append(tempForm);
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
            SQLUtils.execute((Connection)conn, (String)("Insert into T_MBg_BgFormEntry (FID, FBgFormID, FDimensionData)Select FEntryId, FID, FDimensionData From " + tempForm));
            SQLUtils.execute((Connection)conn, (String)("Insert into T_MBg_BgMeasureUnit(FID, FBgFormID, FBgElementID, FBgMeasureUnitID) select newbosid('BDC0C39C'), bgForm.FID, tempM.FBgElementID, tempM.FMeasureUnitID from " + tempForm + " bgForm, T_MBg_BgTemMeasureUnit tempM where bgForm.FBgTemplateId = tempM.FBgTemplateId"));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void updateTempFormXml(Context ctx, Connection conn, String tempForm) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)tempForm)) {
            return;
        }
        try {
            SQLUtils.execute((Connection)conn, (String)("update " + tempForm + " set FDimensionData = (select templateD.FData from  T_MBg_bgviewDimension templateD where templateD.FTemplateId = " + tempForm + ".FBgTemplateId )"));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static Set checkNumber(Context ctx, Connection conn, String oneField, String oneValue, String batchField, Set batchValues, boolean isException, String bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)oneValue) || StringUtils.isEmpty((String)oneValue) || StringUtils.isEmpty((String)batchField) || batchValues == null || batchValues.isEmpty()) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        boolean closeConn = false;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            if (conn == null) {
                closeConn = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select ").append(isException ? " top 1" : "").append(batchField).append(" from T_MBg_bgform where ").append(" FBgSchemeId = '" + bgSchemeId + "' and ").append(oneField).append(" = ? and ").append(batchField).append(" in(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = batchValues.toArray();
            int batchCount = (params.length - 1) / 50 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, oneValue);
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)50, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!isException) {
                        res.add(rst.getString(1));
                        continue;
                    }
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"existNumber", (Locale)ctx.getLocale())});
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                if (closeConn) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        if (closeConn) {
            SQLUtils.cleanup((Connection)conn);
        }
        return res;
    }

    private static String[] getInsertFormFields() {
        return new String[]{"FID", "FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FName", "FNumber", "FDescription", "FYear", "FPeriod", "FStartDate", "FEndDate", "FCompanyID", "FPeriodType", "FSourceType", "FCurrencyID", "FAuditedStatus", "FCheckedStatus", "FData", "FDataSource", "FState", "FBgSchemeID", "FBgTemplateID", "FBgPeriodID", "FBgVersionId", "FOrgUnitID", "FBgTypeID", "FMeasureUnitID", "FVersionNo", "FAdjustID", "FTemplateLastUpdateTime", "FXNum", "FIsChangeType", "FStateBeforeAudit", "FRecord", "FProcessType", "FBgRollRuleId"};
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map queryBgFormByOrgUnitId(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds) throws BOSException {
        if (bgFormInfo == null) return null;
        if (orgIds == null) return null;
        if (orgIds.length == 0) {
            return null;
        }
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            String orgViewId = BgSchemeFactory.getLocalInstance(ctx).getOrgViewId(bgFormInfo.getBgScheme().getId().toString());
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = BgViewServerHelper.getQuerySQL(ctx);
            sql.append(" and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId =?");
            sql.append(" where bgForm.FState <> ? and bgScheme.FId = ? ");
            sql.append(" and bgTemplate.FRootID = ? ");
            sql.append(" and bgOrgUnit.FViewId = ? ");
            sql.append(" and bgForm.FOrgUnitId in (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = (orgIds.length - 1) / 50 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, bgFormInfo.getBgPeriod().getId().toString());
                pstmt.setString(2, bgFormInfo.getCurrency().getId().toString());
                pstmt.setInt(3, 15);
                pstmt.setString(4, bgFormInfo.getBgScheme().getId().toString());
                pstmt.setString(5, bgFormInfo.getBgTemplate().getRootId().toString());
                pstmt.setString(6, orgViewId);
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)7, (int)i, (int)50, (Object[])orgIds);
                res = pstmt.executeQuery();
                while (res.next()) {
                    BgFormInfo b = BgViewServerHelper.buildBgFormInfo(res);
                    bgFormMap.put(b.getOrgUnit().getId().toString(), b);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (EASBizException e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    public static Map queryBgViewBgPeriod(Context ctx, IBgDimensionManagerBase bgDimensionManager, BgFormInfo bgForm, Map<String, BgPeriodDispCollection> periodCache) throws BOSException, EASBizException {
        if (bgDimensionManager == null || bgForm == null) {
            return null;
        }
        HashMap<IBgDimensionManagerBase, BgFormInfo> p = new HashMap<IBgDimensionManagerBase, BgFormInfo>();
        p.put(bgDimensionManager, bgForm);
        if (bgDimensionManager instanceof MbgViewListDimensionManager) {
            BgRollPartEnum rollPart = null;
            if (bgForm.getBgTemplate().getBgRollRule() != null) {
                rollPart = bgForm.getBgTemplate().getBgRollRule().getRollPart();
            }
            return BgViewServerHelper.queryMbgViewListBgPeriod(ctx, p, false, periodCache, rollPart);
        }
        return BgViewServerHelper.queryBgViewBgPeriod(ctx, p, periodCache);
    }

    public static Map queryBgViewBgPeriod(Context ctx, Map dim_bgFormMap, Map<String, BgPeriodDispCollection> periodCache) throws BOSException, EASBizException {
        if (dim_bgFormMap == null || dim_bgFormMap.isEmpty()) {
            return null;
        }
        BgRollPartEnum rollPart = null;
        HashSet<String> numbers = new HashSet<String>();
        for (IBgDimensionManager bgDimensionManager : dim_bgFormMap.keySet()) {
            int i;
            BgFormInfo bgForm = (BgFormInfo)dim_bgFormMap.get(bgDimensionManager);
            BgRollRuleInfo bgRollRule = bgForm.getBgTemplate().getBgRollRule();
            if (bgRollRule != null) {
                rollPart = bgRollRule.getRollPart();
            }
            BgDimensionBaseInfo dimen = null;
            for (i = 0; i < bgDimensionManager.getDimension().size(); ++i) {
                if (!MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(((BgDimensionBaseInfo)bgDimensionManager.getDimension().get(i)).getNumber())) continue;
                dimen = (BgDimensionBaseInfo)bgDimensionManager.getDimension().get(i);
                break;
            }
            if (dimen == null) {
                return null;
            }
            if (StringUtils.isEmpty((String)dimen.getValue()) || dimen.getMember().isEmpty()) {
                numbers.add(bgForm.getBgPeriod().getNumber());
                continue;
            }
            for (i = 0; i < dimen.getMember().size(); ++i) {
                BgDimensionMember member = (BgDimensionMember)dimen.getMember().get(i);
                int targetPeriodType = bgForm.getBgPeriod().getPeriodType().getValue();
                String targetPeriodNumber = bgForm.getBgPeriod().getNumber();
                if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                    targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                    targetPeriodType = 4;
                }
                numbers.add(BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)member.getNumber(), (int)targetPeriodType));
            }
        }
        return BgViewServerHelper.queryPeriodMapByNumbers(ctx, numbers, periodCache);
    }

    public static Map queryMbgViewListBgPeriodByPeriod(Context ctx, Map dim_bgPeriodMap, boolean isCheckExists, Map<String, BgPeriodDispCollection> periodCache) throws BOSException, EASBizException {
        return BgViewServerHelper.queryMbgViewListBgPeriodByPeriod(ctx, dim_bgPeriodMap, isCheckExists, periodCache, null);
    }

    public static Map queryMbgViewListBgPeriodByPeriod(Context ctx, Map dim_bgPeriodMap, boolean isCheckExists, Map<String, BgPeriodDispCollection> periodCache, BgRollPartEnum rollPart) throws BOSException, EASBizException {
        BgDimensionBaseInfo periodDim = null;
        MbgViewListRowCol viewListObj = null;
        BgPeriodInfo bgPeriod = null;
        HashSet<String> numbers = new HashSet<String>();
        for (IBgDimensionManagerBase iDimensionManager : dim_bgPeriodMap.keySet()) {
            bgPeriod = (BgPeriodInfo)dim_bgPeriodMap.get(iDimensionManager);
            if (iDimensionManager instanceof MbgViewListDimensionManager) {
                int i;
                MbgViewListDimensionManager dimensionManager = (MbgViewListDimensionManager)iDimensionManager;
                periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, dimensionManager.getViewDimension()) != null ? DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, dimensionManager.getViewDimension()) : periodDim;
                BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
                periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, dimensionManager.getPageDimension()) != null ? DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, dimensionManager.getPageDimension()) : periodDim;
                BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
                for (i = 0; i < dimensionManager.getRows().size(); ++i) {
                    if (!(dimensionManager.getRows().get(i) instanceof MbgViewListRowCol)) continue;
                    viewListObj = (MbgViewListRowCol)dimensionManager.getRows().get(i);
                    periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, viewListObj.getDimensions());
                    BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
                }
                for (i = 0; i < dimensionManager.getColumns().size(); ++i) {
                    if (!(dimensionManager.getColumns().get(i) instanceof MbgViewListRowCol)) continue;
                    viewListObj = (MbgViewListRowCol)dimensionManager.getColumns().get(i);
                    periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, viewListObj.getDimensions());
                    BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
                }
                continue;
            }
            periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getViewDimension()) != null ? DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getViewDimension()) : periodDim;
            BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
            periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getPageDimension()) != null ? DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getPageDimension()) : periodDim;
            BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
            periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getRowDimension()) != null ? DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getRowDimension()) : periodDim;
            BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
            periodDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getColDimension()) != null ? DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, iDimensionManager.getColDimension()) : periodDim;
            BgViewServerHelper.addMbgViewListPeriodNumbes(numbers, periodDim, bgPeriod, rollPart);
        }
        Map bgPeriodMap = BgViewServerHelper.queryPeriodMapByNumbers(ctx, numbers, periodCache);
        if (isCheckExists) {
            ArrayList<String> notExistPeriodNum = new ArrayList<String>();
            for (String number : numbers) {
                if (bgPeriodMap.containsKey(number) || BgPeriodNVariableHelper.checkIsDay((String)number)) continue;
                notExistPeriodNum.add(number);
            }
            if (!notExistPeriodNum.isEmpty()) {
                Collections.sort(notExistPeriodNum);
                throw new BgPeriodException(BgPeriodException.NOEXISTDETAIL, new Object[]{((Object)notExistPeriodNum).toString()});
            }
        }
        return bgPeriodMap;
    }

    public static Map queryMbgViewListBgPeriod(Context ctx, Map dim_bgFormMap, boolean isCheckExists, Map<String, BgPeriodDispCollection> periodCache) throws BOSException, EASBizException {
        return BgViewServerHelper.queryMbgViewListBgPeriod(ctx, dim_bgFormMap, isCheckExists, periodCache, null);
    }

    public static Map queryMbgViewListBgPeriod(Context ctx, Map dim_bgFormMap, boolean isCheckExists, Map<String, BgPeriodDispCollection> periodCache, BgRollPartEnum rollPart) throws BOSException, EASBizException {
        HashMap<IBgDimensionManagerBase, BgPeriodInfo> newMap = new HashMap<IBgDimensionManagerBase, BgPeriodInfo>();
        for (IBgDimensionManagerBase dimensionManager : dim_bgFormMap.keySet()) {
            newMap.put(dimensionManager, ((IDimDataQuery)dim_bgFormMap.get(dimensionManager)).getBizPeriod());
        }
        return BgViewServerHelper.queryMbgViewListBgPeriodByPeriod(ctx, newMap, isCheckExists, periodCache, rollPart);
    }

    private static void addMbgViewListPeriodNumbes(Set<String> numbers, BgDimensionBaseInfo periodDim, BgPeriodInfo bgFormPeriod, BgRollPartEnum rollPart) throws BgPeriodException {
        if (periodDim != null) {
            if (periodDim.getMember().isEmpty()) {
                numbers.add(bgFormPeriod.getNumber());
            } else {
                for (int j = 0; j < periodDim.getMember().size(); ++j) {
                    BgDimensionMember member = (BgDimensionMember)periodDim.getMember().get(j);
                    String targetPeriodNumber = bgFormPeriod.getNumber();
                    int targetPeriodType = bgFormPeriod.getPeriodType().getValue();
                    if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                        targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                        targetPeriodType = 4;
                    }
                    String number = BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)member.getNumber(), (int)targetPeriodType);
                    numbers.add(number);
                }
            }
        }
    }

    public static Map queryPeriodMapByNumbers(Context ctx, Set<String> numbers, Map<String, BgPeriodDispCollection> periodCache) throws BOSException {
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        if (numbers == null || numbers.isEmpty()) {
            return bgPeriodMap;
        }
        if (periodCache == null) {
            periodCache = new HashMap<String, BgPeriodDispCollection>();
        }
        HashSet<String> queryNumbers = new HashSet<String>(numbers);
        queryNumbers.removeAll(periodCache.keySet());
        BgPeriodDispCollection col = null;
        if (!queryNumbers.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("bgPeriod.id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("alias");
            evi.getSelector().add("longNumber");
            evi.getSelector().add("periodType");
            evi.getSelector().add("showlevel");
            evi.getSelector().add("endDate");
            evi.getSelector().add("beginDate");
            evi.getSelector().add("type.*");
            evi.getSelector().add("isLeaf");
            evi.getSelector().add("longNumber");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            col = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(evi);
            for (int i = 0; i < col.size(); ++i) {
                if (!periodCache.containsKey(col.get(i).getNumber())) {
                    periodCache.put(col.get(i).getNumber(), new BgPeriodDispCollection());
                }
                periodCache.get(col.get(i).getNumber()).add(col.get(i));
            }
        }
        col = new BgPeriodDispCollection();
        for (String number : numbers) {
            if (periodCache.get(number) == null) continue;
            col.addCollection(periodCache.get(number));
        }
        bgPeriodMap.clear();
        if (col != null && !col.isEmpty()) {
            Object[] result = BgNPeriodHelper.checkPeriodType((BgPeriodDispCollection)col);
            boolean hasFiscalYear = (Boolean)result[1];
            Set types = (Set)result[3];
            for (int i = 0; i < col.size(); ++i) {
                BgPeriodDispInfo period = col.get(i);
                if (!types.contains(period.getType().getNumber())) continue;
                bgPeriodMap.put(period.getNumber(), period.toBgPeriodInfo());
            }
        }
        return bgPeriodMap;
    }

    public static String getBgDataFilterByBgFormId() {
        return "Fid in(Select FBgDataId From T_MBg_BgDataEntry Where FBgFormId = ?)";
    }

    public static String getBgDataFilterByBgFormId(String dataEntryTableName) {
        return "Fid in(Select FBgDataId From " + dataEntryTableName + " Where FBgFormId = ?)";
    }

    public static void removeStateLock(ReportBaseInfo reportInfo) {
        try {
            BgViewServerHelper.removeStateLock(reportInfo, reportInfo.getBook());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void removeStateLock(ReportBaseInfo reportInfo, Book _book) {
        try {
            Range unLock = null;
            BgNFSHelper.disableCal(_book);
            BgNFSHelper.disableUndo(_book);
            boolean isRemoveTime = false;
            boolean isUnLock = false;
            BgSheetRange sheetRange = null;
            if (_book != null) {
                int _sheetSize = _book.getSheetCount();
                for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                    Sheet _sheet = _book.getSheet(_sheetIndex);
                    int rowCount = _sheet.getMaxRowIndex();
                    int colCount = _sheet.getMaxColIndex();
                    sheetRange = new BgSheetRange(_sheet);
                    for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                            Cell _cell = _sheet.getCell(rowIndex, colIndex, false);
                            if (BgNFSHelper.getCellChangeLastUpdataTime(_cell) != null) {
                                isRemoveTime = true;
                                BgNFSHelper.removeCellChangeLastUpdataTime(_cell);
                            }
                            if ((_cell == null || BgNFSHelper.getCellData(_cell, "BGDATA_STATE_LOCK") == null) && BgNFSHelper.getCellExtData(_cell, "BGDATA_EXPRESS_LOCK") == null) continue;
                            BgNFSHelper.removeCellData(_cell, "BGDATA_STATE_LOCK");
                            BgNFSHelper.removeCellExtData(_cell, "BGDATA_EXPRESS_LOCK");
                            BgNFSHelper.removeCellData(_cell, "BGDATA_CAN_UPDATE");
                            sheetRange.addCell(rowIndex, colIndex);
                        }
                    }
                    unLock = sheetRange.getRange();
                    if (unLock == null || unLock.isEmpty()) continue;
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setLocked(false);
                    unLock.setIgnoreProtected(true);
                    unLock.setStyle(sa, Styles.getEmptySA());
                    isUnLock = true;
                    unLock = null;
                }
            }
            if (isRemoveTime || isUnLock) {
                reportInfo.setBook(_book);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public static void batchUpdateRelationByInfo(Context ctx, Connection conn, List newForms) throws Exception {
        if (ctx == null || conn == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        ArrayList<String> bgFormIds = new ArrayList<String>();
        for (int i = 0; i < newForms.size(); ++i) {
            bgFormIds.add(((BgFormInfo)newForms.get(i)).getId().toString());
        }
        BgViewServerHelper.batchUpdateRelationByIds(ctx, conn, bgFormIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchUpdateRelationByIds(Context ctx, Connection conn, List bgFormIds) throws SQLException, BOSException {
        if (ctx == null || conn == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
        WeakHashMap relationMap = new WeakHashMap();
        ArrayList<String[]> relationRefParam = new ArrayList<String[]>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("Select bgForm.FID, bgForm.FBgSchemeId, bgForm.FOrgUnitId, entry.FDimensionData, bgTemplate.FData From T_MBg_BgFormEntry entry inner join T_MBg_BgForm bgForm on bgForm.FID = entry.FBgFormId inner join T_Mbg_BgViewDimension bgTemplate on  bgTemplate.FTemplateId = bgForm.FBgTemplateId Where entry.FDimensionData is not null and bgForm.FID in(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)selectSql).append(")");
        String updateSql = "Update T_MBg_BgFormEntry Set FDimensionData = ? Where FBgFormId = ?";
        PreparedStatement pstmtSelect = null;
        PreparedStatement pstmtUpdate = null;
        ResultSet res = null;
        Object[] ids = bgFormIds.toArray();
        int batchCount = MbgSqlHelper.getBatchCount((Object[])ids);
        MbgXMLParser parser2 = new MbgXMLParser(ctx);
        BgSchemeDimensionHelper schemeHelper = null;
        try {
            pstmtSelect = conn.prepareStatement(selectSql.toString());
            pstmtUpdate = conn.prepareStatement(updateSql);
            for (int i = 0; i < batchCount; ++i) {
                boolean hasUpdate = false;
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmtSelect, (int)i, (int)50, (Object[])ids);
                res = pstmtSelect.executeQuery();
                while (res.next()) {
                    try {
                        int r;
                        String bgSchemeId = res.getString("FBgSchemeId");
                        if (schemeHelper == null || !bgSchemeId.equals(schemeHelper.getBgSchemeId())) {
                            schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
                            cacheHelper.setMemberCacheHelper(new ViewListMemberCacheHelper());
                            cacheHelper.getMemberCacheHelper().setCtx(ctx);
                            cacheHelper.getMemberCacheHelper().setSchemeHelper(schemeHelper);
                        }
                        String bgFormId = res.getString("FID");
                        String orgId = res.getString("FOrgUnitId");
                        IMbgViewManager view = parser2.parse(res.getBytes("FDimensionData"));
                        IMbgViewManager bgTemplateView = parser2.parse(res.getBytes("FData"));
                        if (view == null) continue;
                        boolean hasExistGroupEmpty = false;
                        if (view.getRelationMaps() != null) {
                            for (r = 0; r < view.getRelationMaps().size(); ++r) {
                                MbgRelationMap relation = view.getRelationMaps().get(r);
                                relation.setGroup(cacheHelper.getRelationGroup(relation.getGroup().getId().toString()));
                                if (relation.getGroup() != null) continue;
                                hasExistGroupEmpty = true;
                            }
                        }
                        if (hasExistGroupEmpty) continue;
                        List<MbgRelationMap> relations = BgViewServerHelper.convertRelationMap(ctx, relationMap, orgId, view, bgTemplateView, false, cacheHelper, schemeHelper);
                        if (view.getRelationMaps() != null && !view.getRelationMaps().isEmpty() || relations != null && !relations.isEmpty()) {
                            view.setRelationMaps(relations);
                            if (!hasUpdate) {
                                hasUpdate = true;
                            }
                            new MbgXMLParser(ctx);
                            pstmtUpdate.setBytes(1, MbgXMLParser.unParse(view));
                            pstmtUpdate.setString(2, bgFormId);
                            pstmtUpdate.addBatch();
                            if (relations != null) {
                                for (r = 0; r < relations.size(); ++r) {
                                    String[] param = new String[2];
                                    relationRefParam.add(param);
                                    param[0] = relations.get(r).getGroup().getId().toString();
                                    param[1] = bgFormId;
                                }
                            }
                        }
                        view = MBGFormFacadeFactory.getLocalInstance(ctx).loadViewManager(bgFormId, null, view, null, orgId, true, false);
                        BgFacadeHelper.saveViewRef(ctx, bgSchemeId, bgFormId, orgId, BgRefDimMemberEnum.BgForm, (IMbgViewBase)view, true);
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
                if (hasUpdate) {
                    pstmtUpdate.executeBatch();
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmtSelect);
            SQLUtils.cleanup(pstmtUpdate);
            SQLUtils.cleanup(res);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmtSelect);
        SQLUtils.cleanup((Statement)pstmtUpdate);
        SQLUtils.cleanup(res);
        MbgDimRelationRefServerHelper.removeRelationRef(ctx, conn, bgFormIds);
        MbgDimRelationRefServerHelper.saveRelationRef(ctx, conn, relationRefParam);
    }

    public static List<MbgRelationMap> convertRelationMap(Context ctx, WeakHashMap relationMap, String orgId, IMbgViewManager view, IMbgViewManager bgTemplateView, boolean isReturnNew, DimensionCacheHelper cacheHelper, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        Iterator it;
        String groupId;
        HashMap<String, MbgRelationMap> relations = new HashMap<String, MbgRelationMap>();
        ArrayList groupIdList = new ArrayList();
        HashSet<String> noEmptyRelation = new HashSet<String>();
        if (bgTemplateView != null && bgTemplateView.getRelationMaps() != null) {
            for (int r = 0; r < bgTemplateView.getRelationMaps().size(); ++r) {
                if (bgTemplateView.getRelationMaps().get(r).getRelationShips().isEmpty()) continue;
                noEmptyRelation.add(bgTemplateView.getRelationMaps().get(r).getGroup().getId().toString());
            }
        }
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            IBgDimensionManager dimManager = view.getSheetManagers().get(s).getDimensionManager();
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                BgDimensionInfo dimension = (BgDimensionInfo)dimManager.getDimension().get(d);
                if (!dimension.isMapping()) continue;
                for (int m = 0; m < dimension.getMappingList().size(); ++m) {
                    groupId = dimension.getMappingList().get(m).getId().toString();
                    if (relations.containsKey(groupId)) continue;
                    relations.put(groupId, BgViewServerHelper.getRelationMap(ctx, orgId, groupId, relationMap, view, dimension.isSelectRelationship(), !noEmptyRelation.contains(groupId), isReturnNew));
                }
            }
        }
        if (cacheHelper.getMemberCacheHelper() == null) {
            cacheHelper.setMemberCacheHelper(new ViewListMemberCacheHelper());
            cacheHelper.getMemberCacheHelper().setCtx(ctx);
            cacheHelper.getMemberCacheHelper().setSchemeHelper(schemeHelper);
        }
        HashMap queryMap = new HashMap();
        DimensionRelationshipInfo info = null;
        String[] combins = null;
        String srcNumber = null;
        String dimNumber2 = null;
        String number2 = null;
        for (MbgRelationMap relation : relations.values()) {
            it = relation.getRelationShips().iterator();
            while (it.hasNext()) {
                info = (DimensionRelationshipInfo)it.next();
                combins = DimensionFormulaHelper.splitCombinations(info.getDimensionNumber());
                for (int c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number2 = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    dimNumber2 = schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber();
                    boolean isGlobal = cacheHelper.getMemberCacheHelper().isGlobal(dimNumber2, schemeHelper);
                    if (DimUtils.checkBaseDimension(dimNumber2) || DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber2) || isGlobal || cacheHelper.getMemberCacheHelper().getMembers(dimNumber2, orgId, isGlobal, number2, -1) != null) continue;
                    if (!queryMap.containsKey(dimNumber2)) {
                        queryMap.put(dimNumber2, new HashSet());
                    }
                    ((Set)queryMap.get(dimNumber2)).add(number2);
                }
            }
        }
        for (String dimNumber2 : queryMap.keySet()) {
            boolean isGlobal = cacheHelper.getMemberCacheHelper().isGlobal(dimNumber2, schemeHelper);
            Map memberMap = DimensionFormulaFacadeFactory.getLocalInstance(ctx).queryMembers(orgId, schemeHelper, dimNumber2, new HashSet((Collection)queryMap.get(dimNumber2)), false, null);
            for (String number2 : (Set)queryMap.get(dimNumber2)) {
                ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
                if (memberMap != null && memberMap.containsKey(number2)) {
                    members.add((BgDimensionMember)memberMap.get(number2));
                }
                cacheHelper.getMemberCacheHelper().putMembers(dimNumber2, orgId, isGlobal, number2, -1, members);
            }
        }
        for (MbgRelationMap relation : relations.values()) {
            it = relation.getRelationShips().iterator();
            block10: while (it.hasNext()) {
                info = (DimensionRelationshipInfo)it.next();
                combins = DimensionFormulaHelper.splitCombinations(info.getDimensionNumber());
                for (int c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number2 = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    dimNumber2 = schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber();
                    boolean isGlobal = cacheHelper.getMemberCacheHelper().isGlobal(dimNumber2, schemeHelper);
                    if (DimUtils.checkBaseDimension(dimNumber2) || DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber2) || isGlobal || cacheHelper.getMemberCacheHelper().getMembers(dimNumber2, orgId, isGlobal, number2, -1) != null && !cacheHelper.getMemberCacheHelper().getMembers(dimNumber2, orgId, isGlobal, number2, -1).isEmpty()) continue;
                    it.remove();
                    continue block10;
                }
            }
        }
        HashMap<String, CoreBaseCollection> relations1 = new HashMap<String, CoreBaseCollection>();
        HashMap hasRelations = new HashMap();
        MbgRelationMap relationMap1 = null;
        CoreBaseCollection relationCol = null;
        boolean isCsl = false;
        for (MbgRelationMap relation : relations.values()) {
            relationMap1 = relation;
            groupId = relationMap1.getGroup().getId().toString();
            boolean bl = isCsl = cacheHelper.getRelationGroup(groupId) == null ? false : cacheHelper.getRelationGroup(groupId).isIsCsl();
            if (relationMap1.getRelationShips().isEmpty() && !relationMap1.isFillWhereNull() || !relations.containsKey(groupId) || cacheHelper.getRelationGroup(groupId) == null) continue;
            relationCol = DimensionMemberRelationShipHelper.queryAllRelationByGroupId(ctx, cacheHelper.getRelationGroup(groupId), cacheHelper.getOrgUnitById(orgId, isCsl));
            relations1.put(groupId, relationCol);
            hasRelations.put(groupId, new HashSet());
            if (relationCol == null) continue;
            for (int i = 0; i < relationCol.size(); ++i) {
                ((Set)hasRelations.get(groupId)).add(((DimensionRelationshipInfo)relationCol.get(i)).getDimensionNumber());
            }
        }
        Iterator iterator = relations.values().iterator();
        while (iterator.hasNext()) {
            MbgRelationMap relation;
            relationMap1 = relation = (MbgRelationMap)iterator.next();
            groupId = relationMap1.getGroup().getId().toString();
            if (relationMap1.getRelationShips().isEmpty()) {
                if (!relationMap1.isFillWhereNull()) continue;
                relationMap1.getRelationShips().addObjectCollection((IObjectCollection)relations1.get(groupId));
                continue;
            }
            for (int s = relationMap1.getRelationShips().size() - 1; s >= 0; --s) {
                if (hasRelations.containsKey(groupId) && ((Set)hasRelations.get(groupId)).contains(relationMap1.getRelationShips().get(s).getDimensionNumber())) continue;
                relationMap1.getRelationShips().removeObject(s);
            }
        }
        if (relations.isEmpty()) {
            return null;
        }
        return new ArrayList<MbgRelationMap>(relations.values());
    }

    private static MbgRelationMap getRelationMap(Context ctx, String orgId, String groupId, WeakHashMap relationMap, IMbgViewManager view, boolean isSelectRelationship, boolean isEmptyRelation, boolean isReturnNew) throws EASBizException, BOSException {
        String key = orgId + "_" + groupId;
        if (relationMap.containsKey(key)) {
            return (MbgRelationMap)relationMap.get(key);
        }
        MbgRelationMap map = null;
        for (int i = 0; i < view.getRelationMaps().size(); ++i) {
            if (!groupId.equals(view.getRelationMaps().get(i).getGroup().getId().toString())) continue;
            map = view.getRelationMaps().get(i);
            relationMap.put(key, map);
            if (isEmptyRelation) break;
            return map;
        }
        if (map == null || isReturnNew) {
            map = new MbgRelationMap(view);
            DimensionRelationshipGroupInfo group = null;
            try {
                group = DimensionRelationshipGroupFactory.getLocalInstance(ctx).getDimensionRelationshipGroupInfo("select id, number, name, isLowerShow, entries.id, entries.dimName, entries.dimNumber, bgScheme.id  where id = '" + groupId + "'");
            }
            catch (ObjectNotFoundException e) {
                throw new DimensionException(DimensionException.RELATIONNOTFOUND);
            }
            map.setGroup(group);
        }
        if (!isSelectRelationship && isEmptyRelation) {
            map.getRelationShips().clear();
            map.getRelationShips().addObjectCollection((IObjectCollection)DimensionMemberRelationShipHelper.queryAllRelationByGroupId(ctx, map.getGroup(), (OrgUnitInfo)DimensionFilterHelper.queryCostCenter(ctx, orgId)));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, String key) throws SQLException, IOException {
        if (rst == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        InputStream in = rst.getBinaryStream(key);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, int index) throws SQLException, IOException {
        if (rst == null) {
            return null;
        }
        InputStream in = rst.getBinaryStream(index);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    public static void setBytes(PreparedStatement stat, int index, byte[] bytes) throws SQLException {
        if (stat == null) {
            return;
        }
        if (bytes != null && bytes.length > 0) {
            stat.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        } else {
            stat.setBytes(index, null);
        }
    }

    public static BgTemplateInfo getBgTemplateInfo(Connection conn, String bgTemplateId, boolean loadData) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        return BgViewServerHelper.getBgTemplateInfo(conn, BOSUuid.read((String)bgTemplateId), loadData);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgTemplateInfo getBgTemplateInfo(Connection conn, BOSUuid bgTemplateId, boolean loadData) throws EASBizException {
        if (conn == null) return null;
        if (bgTemplateId == null) {
            return null;
        }
        BgTemplateInfo bgTemplateInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tmp = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID, FNumber, FName, FLastUpdateTime, FOrgUnitID,FSourceType,FBgTypeId, " + (loadData ? " FData, " : "") + " FDefaultMeasureUnitID, FParentID, FRootId, FFormType From T_MBG_BgTemplate where FID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgTemplateId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setLastUpdateTime(rst.getTimestamp("FLastUpdateTime"));
                bgTemplateInfo.setSourceType(RptSrcTypeEnum.getEnum(rst.getInt("FSourceType")));
                String bgTypeId = rst.getString("FBgTypeId");
                if (!StringUtils.isEmpty((String)bgTypeId)) {
                    bgTemplateInfo.setBgType(new BgTypeInfo());
                    bgTemplateInfo.getBgType().setId(BOSUuid.read((String)bgTypeId));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FOrgUnitID")))) {
                    bgTemplateInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgTemplateInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (loadData) {
                    bgTemplateInfo.setZipData(BgViewServerHelper.getBytes(rst, "FData"));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FDefaultMeasureUnitID")))) {
                    bgTemplateInfo.setDefaultMeasureUnit(new MeasureUnitInfo());
                    bgTemplateInfo.getDefaultMeasureUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FParentID")))) {
                    bgTemplateInfo.setParent(new BgTemplateInfo());
                    bgTemplateInfo.getParent().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FRootId")))) {
                    bgTemplateInfo.setRootId(BOSUuid.read((String)_tmp));
                }
                bgTemplateInfo.setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (IOException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateInfo;
    }

    public static BgFormInfo getBgFormInfo(Context ctx, BOSUuid bgFormId, boolean loadData) throws EASBizException, BOSException {
        SelectorItemCollection sic = BgViewServerHelper.getSelectors();
        if (loadData) {
            sic.add("data");
        }
        return BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), sic);
    }

    public static BgFormInfo getBgFormInfoNoQueryData(Context ctx, BOSUuid bgFormId, boolean loadData) throws BOSException, EASBizException {
        SelectorItemCollection sic = BgViewServerHelper.getSelectors();
        if (loadData) {
            sic.add("data");
        }
        return (BgFormInfo)BgFormFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgFormId), sic, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgFormInfo getBgFormInfo(Connection conn, BOSUuid bgFormId, boolean loadData) throws EASBizException {
        if (conn == null) return null;
        if (bgFormId == null) {
            return null;
        }
        BgFormInfo bgFormInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tmp = null;
        int isRoll = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("Select bgForm.FID, bgForm.FNumber, bgForm.FName, bgForm.FControlUnitID, bgForm.FOrgUnitID, bgForm.FCompanyID, bgForm.FBgVersionID,bgVersion.FISROLLVERSION, bgForm.FBgSchemeID, bgForm.FBgTemplateId, bgForm.FTemplateLastUpdateTime, " + (loadData ? " bgForm.FData, bgForm.FAdjustMapData, " : "") + " bgForm.FBgPeriodID, bgForm.FCurrencyID, bgForm.FMeasureUnitID, bgForm.FDataSource, bgForm.FState, bgForm.FVersionNo, bgForm.FAdjustID, bgForm.FProcessType,  bgForm.FCertificateUserId, bgForm.FIsConfirm, bgTemplate.FFormType,bgPeriod.FNumber as pnumber,bgPeriod.FPeriodType as ptype,scheme.FRootID, specialItem.FDimensionNumber as sdimensionNumber , bgForm.FSourceType from T_MBG_BgForm bgForm  join T_MBg_BgTemplate bgTemplate on bgTemplate.FID = bgForm.FBgTemplateID  join T_MBG_BgPeriod bgPeriod on bgPeriod.FID = bgForm.FBgPeriodID join T_MBG_BgScheme scheme on scheme.FID = bgForm.FBgSchemeID  join T_MBG_BgVersion bgVersion on bgVersion.FID = bgForm.FBgVersionID  left join T_MBG_BgSpecialItems specialItem  on specialItem.fBgformID = bgForm.FID  where bgForm.FID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                bgFormInfo.setTemplateLastUpdateTime(rst.getTimestamp("FTemplateLastUpdateTime"));
                bgFormInfo.setProcessType(BgProcessEnum.getEnum(rst.getInt("FProcessType")));
                _tmp = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setCU(new CtrlUnitInfo());
                    bgFormInfo.getCU().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FOrgUnitID")))) {
                    bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCompanyID")))) {
                    bgFormInfo.setCompany(new CompanyOrgUnitInfo());
                    bgFormInfo.getCompany().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgSchemeID")))) {
                    bgFormInfo.setBgScheme(new BgSchemeInfo());
                    bgFormInfo.getBgScheme().setId(BOSUuid.read((String)_tmp));
                }
                bgFormInfo.setSourceType(com.kingdee.eas.fi.rpt.RptSrcTypeEnum.getEnum((int)rst.getInt("FSourceType")));
                _tmp = rst.getString("FBgVersionID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setBgVersion(new BgVersionInfo());
                    bgFormInfo.getBgVersion().setId(BOSUuid.read((String)_tmp));
                }
                isRoll = rst.getInt("FISROLLVERSION");
                if (!StringUtils.isEmpty((String)_tmp) && bgFormInfo.getBgVersion() != null) {
                    if (isRoll == 1) {
                        bgFormInfo.getBgVersion().setIsRollVersion(true);
                    } else {
                        bgFormInfo.getBgVersion().setIsRollVersion(false);
                    }
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgTemplateId")))) {
                    bgFormInfo.setBgTemplate(new BgTemplateInfo());
                    bgFormInfo.getBgTemplate().setId(BOSUuid.read((String)_tmp));
                    bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
                }
                if (loadData) {
                    bgFormInfo.setZipData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FData"));
                    bgFormInfo.setAdjustMapData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData"));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgPeriodID")))) {
                    bgFormInfo.setBgPeriod(new BgPeriodInfo());
                    bgFormInfo.getBgPeriod().setId(BOSUuid.read((String)_tmp));
                    bgFormInfo.getBgPeriod().setNumber(rst.getString("pnumber"));
                    bgFormInfo.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("ptype")));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCurrencyID")))) {
                    bgFormInfo.setCurrency(new CurrencyInfo());
                    bgFormInfo.getCurrency().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FMeasureUnitID")))) {
                    bgFormInfo.setMeasureUnit(new MeasureUnitInfo());
                    bgFormInfo.getMeasureUnit().setId(BOSUuid.read((String)_tmp));
                }
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                _tmp = rst.getString("FAdjustID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setAdjust(new BgFormInfo());
                    bgFormInfo.getAdjust().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCertificateUserId")))) {
                    bgFormInfo.setCertificateUserId(_tmp);
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("sdimensionNumber")))) {
                    bgFormInfo.getBgSpecialItems().add(new BgSpecialItemsInfo());
                    bgFormInfo.getBgSpecialItems().get(0).setDimensionNumber(_tmp);
                }
                bgFormInfo.setIsConfirm(rst.getBoolean("FIsConfirm"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (IOException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgFormInfo;
    }

    public static BgFormInfo getBgFormVer(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        BgFormInfo bgFormInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FID, FVersionNo from T_MBG_BgForm where FID = ?");
            pstmt.setString(1, bgFormId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgFormInfo;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("state");
        sic.add("processType");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("description");
        sic.add("versionNo");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longNumber");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.refCube");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.bgScenario.id");
        sic.add("bgTemplate.bgScenario.number");
        sic.add("bgTemplate.bgScenario.name");
        sic.add("bgTemplate.bgScenario.scenarioId");
        sic.add("bgTemplate.bgScheme.id");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("adjust.id");
        sic.add("adjustMapData");
        sic.add("auditTime");
        sic.add("courseOrgId");
        sic.add("bgSpecialItems.dimensionNumber");
        sic.add("bgSpecialItems.dimensionName");
        sic.add("bgSpecialItems.memberName");
        sic.add("bgSpecialItems.memberDisplayName");
        return sic;
    }

    public static BgSchemeInfo getBgSchemeCubeInfo(Context ctx, BgSchemeInfo model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return null;
        }
        return BgViewServerHelper.getBgSchemeCubeInfo(ctx, model.getId());
    }

    public static BgSchemeInfo getBgSchemeCubeInfo(Context ctx, String number) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        BgSchemeInfo root = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)"select FID from T_MBG_BgScheme where FNumber = ?", (Object[])new Object[]{number});
            if (rst.next()) {
                root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return root;
    }

    public static BgSchemeInfo getBgSchemeCubeInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return null;
        }
        SelectorItemCollection sic = BgCubeUtils.getRefDimSelector();
        return BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), sic);
    }

    public static BgSchemeInfo getBgSchemeInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return null;
        }
        Connection conn = null;
        BgSchemeInfo schemeInfo = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            schemeInfo = BgViewServerHelper.getBgSchemeInfo(ctx.getLocale(), conn, bgSchemeId);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return schemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgSchemeInfo getBgSchemeInfo(Locale locale, Connection conn, BOSUuid bgSchemeId) throws EASBizException {
        IRowSet rst;
        BgSchemeInfo bgSchemeInfo;
        block11: {
            if (conn == null || bgSchemeId == null) {
                return null;
            }
            bgSchemeInfo = null;
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            HashMap<String, BgDimSettingsInfo> settingMap = new HashMap<String, BgDimSettingsInfo>();
            rst = null;
            IRowSet _rst = null;
            String _tmpStr = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName_" + locale + " AS FName, FOrgUnitID, FIsFormal, FDateFrom, FDateTo, FPeriod, FRefCube From T_MBg_BgScheme where FID = ?");
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString()});
                if (!rst.next()) break block11;
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgSchemeInfo.setNumber(rst.getString("FNumber"));
                bgSchemeInfo.setName(rst.getString("FName"));
                _tmpStr = rst.getString("FOrgUnitID");
                if (!StringUtils.isEmpty((String)_tmpStr)) {
                    bgSchemeInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgSchemeInfo.getOrgUnit().setId(BOSUuid.read((String)_tmpStr));
                }
                bgSchemeInfo.setIsFormal(rst.getBoolean("FIsFormal"));
                bgSchemeInfo.setDateFrom(rst.getDate("FDateFrom"));
                bgSchemeInfo.setDateTo(rst.getDate("FDateTo"));
                bgSchemeInfo.setRefCube(rst.getString("FRefCube"));
                bgSchemeInfo.setPeriod(BgPeriodEnum.getEnum((int)rst.getInt("FPeriod")));
                sql = new StringBuffer();
                sql.append("select t.FID, t.FDimNumber, m.FID AS FMID, m.FMemberID, m.FNumber, m.FType from T_MBG_BgDimSettings t join T_MBG_BgDimSettingsMember m on t.FID = m.FBgDimSettingsID where FBgSchemeID = ?");
                try {
                    _rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString()});
                    while (_rst.next()) {
                        _tmpStr = _rst.getString("FID");
                        if (settingMap.containsKey(_tmpStr)) {
                            setting = (BgDimSettingsInfo)settingMap.get(_tmpStr);
                        } else {
                            setting = new BgDimSettingsInfo();
                            setting.setId(BOSUuid.read((String)_tmpStr));
                            setting.setDimNumber(_rst.getString("FDimNumber"));
                            bgSchemeInfo.getBgDimSettings().add(setting);
                            settingMap.put(_tmpStr, setting);
                        }
                        member = new BgDimSettingsMemberInfo();
                        member.setId(BOSUuid.read((String)_rst.getString("FMID")));
                        member.setMemberID(BOSUuid.read((String)_rst.getString("FMemberID")));
                        member.setNumber(_rst.getString("FNumber"));
                        member.setType(MemberTypeEnum.getEnum(_rst.getInt("FType")));
                        setting.getMembers().add(member);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(_rst);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)_rst);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgSchemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgPeriodInfo> getBgPeriodMap(Context ctx, List<String> bgPeriodNums) throws BOSException, EASBizException {
        Map<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        if (ctx == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgPeriodMap = BgViewServerHelper.getBgPeriodMap(conn, bgPeriodNums);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgPeriodMap;
    }

    public static Map<String, BgPeriodInfo> getBgPeriodMap(Connection conn, List<String> bgPeriodNums) throws EASBizException {
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        if (conn == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        _bgPeriodSet.addAll(bgPeriodNums);
        ArrayList<String> _bgPeriodNums = new ArrayList<String>();
        _bgPeriodNums.addAll(_bgPeriodSet);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = _bgPeriodNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FBgPeriodID, FNumber, FBeginDate, FEndDate from T_MBG_BgPeriodDisp where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        BgPeriodInfo bgPeriodInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgPeriodNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodInfo = new BgPeriodInfo();
                    bgPeriodInfo.setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                    bgPeriodInfo.setNumber(rst.getString("FNumber"));
                    bgPeriodInfo.setBeginDate((Date)rst.getDate("FBeginDate"));
                    bgPeriodInfo.setEndDate((Date)rst.getDate("FEndDate"));
                    bgPeriodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgPeriodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgElementInfo> getBgElementMap(Context ctx, List<String> bgElementNums) throws BOSException, EASBizException {
        Map<String, BgElementInfo> bgElementMap = new HashMap<String, BgElementInfo>();
        if (ctx == null || bgElementNums == null || bgElementNums.isEmpty()) {
            return bgElementMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgElementMap = BgViewServerHelper.getBgElementMap(conn, bgElementNums);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgElementMap;
    }

    public static Map<String, BgElementInfo> getBgElementMap(Connection conn, List<String> bgElementNums) throws EASBizException {
        HashMap<String, BgElementInfo> bgElementMap = new HashMap<String, BgElementInfo>();
        if (conn == null || bgElementNums == null || bgElementNums.isEmpty()) {
            return bgElementMap;
        }
        HashSet<String> _bgElementSet = new HashSet<String>();
        _bgElementSet.addAll(bgElementNums);
        ArrayList<String> _bgElementNums = new ArrayList<String>();
        _bgElementNums.addAll(_bgElementSet);
        int batchSize = 50;
        int size = _bgElementNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_MBG_BgElement where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        BgElementInfo bgElementInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgElementNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementInfo = new BgElementInfo();
                    bgElementInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgElementInfo.setNumber(rst.getString("FNumber"));
                    bgElementMap.put(bgElementInfo.getNumber(), bgElementInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgElementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CurrencyInfo> getCurrencyMap(Context ctx, List<String> currencyNums) throws BOSException, EASBizException {
        Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        if (ctx == null || currencyNums == null || currencyNums.isEmpty()) {
            return currencyMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            currencyMap = BgViewServerHelper.getCurrencyMap(conn, currencyNums);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return currencyMap;
    }

    public static Map<String, CurrencyInfo> getCurrencyMap(Connection conn, List<String> currencyNums) throws EASBizException {
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        if (conn == null || currencyNums == null || currencyNums.isEmpty()) {
            return currencyMap;
        }
        HashSet<String> _currencySet = new HashSet<String>();
        _currencySet.addAll(currencyNums);
        ArrayList<String> _currencyNums = new ArrayList<String>();
        _currencyNums.addAll(_currencySet);
        int batchSize = 50;
        int size = _currencyNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        CurrencyInfo currencyInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_currencyNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    currencyInfo.setNumber(rst.getString("FNumber"));
                    currencyMap.put(currencyInfo.getNumber(), currencyInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return currencyMap;
    }

    public static CompanyOrgUnitInfo getCompanyFromOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("longnumber");
            sic.add("isBizUnit");
            sic.add("accountTable.id");
            sic.add("accountPeriodType.id");
            sic.add("baseExchangeTable.id");
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgViewServerHelper.getCompanyFromOrgUnit(ctx, parent);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyFromOrgUnit(Context ctx, BOSUuid orgUnitId) throws Exception {
        if (ctx == null || orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo.cast(CompanyOrgUnitInfo.class);
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return BgViewServerHelper.getCompanyFromOrgUnit(ctx, parent);
        }
        return null;
    }

    public static Map getCurrencyInfo(Context ctx, Map currencysInfo, SelectorItemCollection sic) throws BOSException, EASBizException {
        if (currencysInfo == null) {
            currencysInfo = new HashMap<String, CurrencyInfo>();
        }
        CurrencyInfo currencyInfo = null;
        CurrencyCollection currencyCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (sic == null || sic.isEmpty()) {
            if (sic == null) {
                sic = new SelectorItemCollection();
            }
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("precision");
        }
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ICurrency iCurrency = null;
        try {
            iCurrency = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            if (iCurrency == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            currencyCol = iCurrency.getCurrencyCollection(view, true);
            if (currencyCol != null && !currencyCol.isEmpty()) {
                int n = currencyCol.size();
                for (int i = 0; i < n; ++i) {
                    currencyInfo = currencyCol.get(i);
                    currencysInfo.put(currencyInfo.getNumber(), currencyInfo);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return currencysInfo;
    }

    public static BOSUuid getAdjustId(Connection conn, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BOSUuid rebgFormId = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_MBg_BgForm where FAdjustId = ? and FState = ?");
            pstmt.setString(1, bgFormId.toString());
            pstmt.setInt(2, 4);
            rst = pstmt.executeQuery();
            rebgFormId = rst.next() ? BOSUuid.read((String)rst.getString(1)) : bgFormId;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return rebgFormId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getCostCenterOrgUnitIdAndNumber(Context ctx) throws Exception {
        if (ctx == null) {
            return null;
        }
        HashMap<String, String> costCenterMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FID, FNumber from T_ORG_CostCenter");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                costCenterMap.put(rst.getString("FNumber"), rst.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return costCenterMap;
    }

    public static Map<String, OrgUnitInfo> queryBgViewOrgUnit(Context ctx, String permNumber, BgFormInfo bgForm, String orgViewId, boolean isAdjust, boolean isOnlyCurrOrg, String currOrgId, boolean isOnlyLeaf, Set<String> orgNumber) throws BOSException, EASBizException {
        BgDimSettingsMemberCollection col;
        if (bgForm == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)orgViewId) && (col = BgDimSettingsMemberFactory.getLocalInstance(ctx).getBgDimSettingsMemberCollection("select memberId where type = 2 AND bgDimSettings.bgScheme.id = '" + bgForm.getBgScheme().getId() + "'")) != null && !col.isEmpty()) {
            orgViewId = col.get(0).getMemberID().toString();
        }
        BOSUuid orgUnitId = currOrgId != null ? BOSUuid.read((String)currOrgId) : bgForm.getOrgUnit().getId();
        BgOrgUnitInfo currOrg = BgViewServerHelper.getBgOrgUnit(ctx, BOSUuid.read((String)orgViewId), orgUnitId);
        HashMap<String, Object> orgMap = new HashMap<String, OrgUnitInfo>();
        if (currOrg == null) {
            return orgMap;
        }
        if (isOnlyCurrOrg && !StringUtils.isEmpty((String)currOrg.getOrgUnitID())) {
            orgMap.put(currOrg.getOrgUnitID().toString(), (OrgUnitInfo)currOrg.castToFullOrgUnitInfo());
            return orgMap;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempOrgIds = null;
        String sql = "select org.forgunitid, org.fnumber, org.fname_" + ctx.getLocale() + " fname, org.fsimplename, org.flevel, org.flongnumber, org.FIsLeaf, org.FDisplayName_" + ctx.getLocale() + " FDisplayName \nfrom T_MBg_bgform bgForm \ninner join T_Mbg_BgOrgUnit org on org.forgunitid = bgForm.forgunitid and org.FViewID = ? \nwhere org.FIsVirtual = 0 and bgForm.FBgSchemeId = ? and bgForm.FBgTemplateId = ? and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId = ? and bgForm.FBgVersionId = ? ";
        if (isAdjust) {
            sql = sql + " and bgForm.fstate in (2,4,35)";
        }
        if (isOnlyLeaf) {
            sql = sql + " and org.FIsLeaf = 1 ";
        }
        IRowSet rs = null;
        HashMap<String, String> orgNumbers = new HashMap<String, String>();
        HashSet parentNumbers = new HashSet();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            if (orgNumber != null && orgNumber.size() < 200 && !orgNumber.isEmpty()) {
                tempOrgIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, orgNumber, (String)"Nvarchar(80)");
                sql = sql + " and exists(Select FID FROM " + tempOrgIds + " temIds Where temIds.FID = org.FNumber)";
            }
            rs = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{orgViewId, bgForm.getBgScheme().getId().toString(), bgForm.getBgTemplate().getId().toString(), bgForm.getBgPeriod().getId().toString(), bgForm.getCurrency().getId().toString(), bgForm.getBgVersion().getId().toString()});
            while (rs.next()) {
                CostCenterOrgUnitInfo cost = new CostCenterOrgUnitInfo();
                cost.setId(BOSUuid.read((String)rs.getString("forgunitid")));
                cost.setNumber(rs.getString("fnumber"));
                cost.setName(rs.getString("fname"));
                cost.setLevel(rs.getInt("flevel"));
                cost.setSimpleName(rs.getString("fsimplename"));
                cost.setLongNumber(rs.getString("flongnumber"));
                cost.setIsLeaf(rs.getBoolean("FIsLeaf"));
                cost.setDisplayName(rs.getString("FDisplayName"));
                orgMap.put(cost.getId().toString(), (OrgUnitInfo)cost);
                orgNumbers.put(cost.getNumber(), cost.getId().toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempOrgIds);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempOrgIds);
        if (orgMap != null && !orgMap.isEmpty()) {
            IObjectPK[] orgPKs = new IObjectPK[orgMap.size()];
            int index = 0;
            Iterator it = orgMap.keySet().iterator();
            while (it.hasNext()) {
                orgPKs[index++] = new ObjectStringPK((String)it.next());
            }
            if (permNumber != null) {
                Set orgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPKs, permNumber);
                HashMap<String, OrgUnitInfo> tempMap = orgMap;
                orgMap = new HashMap();
                if (orgIds != null && !orgIds.isEmpty()) {
                    Iterator it2 = orgIds.iterator();
                    while (it2.hasNext()) {
                        String orgId = String.valueOf(it2.next());
                        if (!tempMap.containsKey(orgId)) continue;
                        orgMap.put(orgId, tempMap.get(orgId));
                    }
                }
            }
        }
        return orgMap;
    }

    public static Map<String, BgOrgUnitInfo> queryAcRecordOrgUnit(Context ctx, String permNumber, BgActualRecordInfo acRecord, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        BOSUuid orgUnitId;
        HashMap<String, BgOrgUnitInfo> resMap = new HashMap<String, BgOrgUnitInfo>();
        if (ctx == null || acRecord == null) {
            return resMap;
        }
        BgSchemeInfo schemeInfo = MbgDataHelper.getBgSchemeInfo(ctx, acRecord.getBgForm().getBgScheme().getId());
        BOSUuid bgViewId = schemeInfo.getEditOrgViewId();
        BgOrgUnitInfo ccOrgUnit = BgViewServerHelper.getBgOrgUnit(ctx, bgViewId, orgUnitId = acRecord.getBgForm().getOrgUnit().getId());
        if (ccOrgUnit == null) {
            return resMap;
        }
        resMap.put(ccOrgUnit.getNumber(), ccOrgUnit);
        if (isOnlyCurrOrg) {
            return resMap;
        }
        BgFormInfo bgFormInfo = acRecord.getBgForm();
        BgTemplateInfo templateInfo = bgFormInfo.getBgTemplate();
        BgPeriodInfo bgPeriodInfo = bgFormInfo.getBgPeriod();
        CurrencyInfo currencyInfo = bgFormInfo.getCurrency();
        BgPeriodInfo actualPeriod = acRecord.getBgPeriod();
        BgVersionInfo versionInfo = bgFormInfo.getBgVersion();
        BgOrgUnitInfo orgUnit = null;
        String bgSchemeId = schemeInfo.getId().toString();
        String rootTemplateId = templateInfo.getRootId().toString();
        String currencyId = currencyInfo.getId().toString();
        String bgPeriodId = bgPeriodInfo.getId().toString();
        String acPeriodId = actualPeriod.getId().toString();
        String bgVersionId = versionInfo.getId().toString();
        String _bgViewId = bgViewId.toString();
        HashSet<String> parentNumbers = new HashSet<String>();
        StringBuffer query = new StringBuffer();
        query.append("select FID, FNumber, FName_" + ctx.getLocale() + " FName, FLevel, FLongNumber, FOrgUnitId  from T_MBG_BgOrgUnit where FViewId = ? and FOrgUnitId in (select f.FOrgUnitId from T_MBG_BgForm f join T_MBG_BgActualRecord ac on f.FID = ac.FBgFormId join T_MBG_BgTemplate t on f.FBgTemplateId = t.FID where t.FrootID  = ? and f.FBgSchemeId = ? and f.FCurrencyID = ? and f.FBgPeriodID = ? and f.FBgVersionId = ? and ac.FBgPeriodID = ?)");
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString(), (Object[])new Object[]{_bgViewId, rootTemplateId, bgSchemeId, currencyId, bgPeriodId, bgVersionId, acPeriodId});
            while (rst.next()) {
                orgUnit = new BgOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setLevel(rst.getInt("FLevel"));
                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                orgUnit.setViewID(_bgViewId);
                orgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                resMap.put(orgUnit.getNumber(), orgUnit);
                String[] lns = orgUnit.getLongNumber().split("!");
                for (int i = 0; i < lns.length - 1; ++i) {
                    parentNumbers.add(lns[i]);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryAcRecordOrgUnit Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        if (isOnlyLeaf) {
            for (String number : parentNumbers) {
                resMap.remove(number);
            }
        }
        if (!resMap.isEmpty() && permNumber != null) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            IObjectPK[] orgPKs = new IObjectPK[resMap.size()];
            int index = 0;
            for (BgOrgUnitInfo _orgUnit : resMap.values()) {
                orgPKs[index++] = new ObjectUuidPK(_orgUnit.getId());
                tmpMap.put(_orgUnit.getOrgUnitID(), _orgUnit.getNumber());
            }
            Set orgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPKs, permNumber);
            if (orgIds != null && !orgIds.isEmpty()) {
                for (String _orgUnitId : orgIds) {
                    if (tmpMap.containsKey(_orgUnitId)) continue;
                    resMap.remove(tmpMap.get(_orgUnitId));
                }
            }
        }
        return resMap;
    }

    public static BOSUuid getBgViewIdBySchemeId(Context ctx, BOSUuid id) {
        try {
            BgSchemeInfo tmpScheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select bgDimSettings.id,bgDimSettings.name,bgDimSettings.number,bgDimSettings.dimnumber,bgDimSettings.members.id,bgDimSettings.members.name,bgDimSettings.members.number,bgDimSettings.members.type,bgDimSettings.members.memberID where id = '" + id.toString() + "'");
            return tmpScheme.getEditOrgViewId();
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public static BgOrgUnitInfo getBgOrgUnit(Context ctx, BOSUuid bgOrgViewId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgOrgViewId == null || orgUnitId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longNumber");
        sic.add("viewID");
        sic.add("orgUnitID");
        sic.add("isLeaf");
        sic.add("simpleName");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("IsVirtual", (Object)Boolean.FALSE, CompareType.EQUALS));
        view.setFilter(filter);
        BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        if (colls != null && !colls.isEmpty()) {
            return colls.get(0);
        }
        return null;
    }

    public static List<String> getCubeFields(Connection conn, String cubeTable) throws SQLException {
        ArrayList<String> refFields = new ArrayList<String>();
        List fields = BgDBUtils.getColumns((Connection)conn, (String)cubeTable);
        for (String refField : fields) {
            if (!refField.toUpperCase().matches("F[0-9]+") || refFields.contains(refField)) continue;
            refFields.add(refField);
        }
        return refFields;
    }

    public static String getBudgetViewID(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        return BgViewServerHelper.getBudgetViewID(ctx, bgScheme.getId().toString());
    }

    public static String getBudgetViewID(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgDimSettings.bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)2, CompareType.EQUALS));
        CoreBaseCollection coll = BgDimSettingsMemberFactory.getLocalInstance(ctx).getCollection(view);
        if (coll != null && coll.size() != 0) {
            return ((BgDimSettingsMemberInfo)coll.get(0)).getMemberID().toString();
        }
        return null;
    }

    public static void saveRelationByInfo(Context ctx, Map<String, List<MbgRelationMap>> relationMaps) throws BOSException, EASBizException {
        ArrayList<String[]> relationRefParam = new ArrayList<String[]>();
        HashSet<String> relationGroupIds = new HashSet<String>();
        for (String id : relationMaps.keySet()) {
            List<MbgRelationMap> relationMap = relationMaps.get(id);
            for (int i = 0; i < relationMap.size(); ++i) {
                MbgRelationMap mbgRelationMap = relationMap.get(i);
                if (mbgRelationMap.getGroup() == null) continue;
                String[] param = new String[2];
                if (relationGroupIds.contains(mbgRelationMap.getGroup().getId().toString())) continue;
                relationGroupIds.add(mbgRelationMap.getGroup().getId().toString());
                relationRefParam.add(param);
                param[0] = mbgRelationMap.getGroup().getId().toString();
                param[1] = id;
            }
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgDimRelationRefServerHelper.removeRelationRef(ctx, conn, new ArrayList<String>(relationMaps.keySet()));
            MbgDimRelationRefServerHelper.saveRelationRef(ctx, conn, relationRefParam);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

