/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgBookParserServerHelper {
    private static final Logger logger = Logger.getLogger((String)MbgBookParserServerHelper.class.getName());
    private DimensionMemberCheckFactory checkFactory = null;
    Timestamp formCreateTime = null;
    Timestamp tMax = null;

    public void setFormCreateTime(Timestamp time) throws BOSException {
        try {
            this.formCreateTime = time;
            this.tMax = new BgNPeriodHelper().getDayMaxTimeStampB(time);
        }
        catch (ParseException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public MbgBookParserServerHelper(Context ctx, BgSchemeDimensionHelper schemeHelper, boolean isDecompose) {
        this.checkFactory = new DimensionMemberCheckFactory(ctx, null, schemeHelper, isDecompose);
    }

    public List<BgDimensionMember> dealDimensionMembers(Context ctx, String orgId, BgSchemeDimensionHelper schemeHelper, IBgDimensionManager dimensionManager, BgDimensionInfo dimensionInfo, boolean isForMap, boolean isFilterDisable) throws EASBizException, BOSException {
        List<BgDimensionMember> newMembers = null;
        if (StringUtils.isEmpty((String)orgId) || dimensionInfo == null) {
            return newMembers;
        }
        if (!isForMap && dimensionInfo.getMemberValueType().getValue() == 2) {
            newMembers = this.getAllMemberForDimension(ctx, orgId, schemeHelper, dimensionInfo);
            if (isFilterDisable) {
                this.filterDisable(this.formCreateTime, newMembers);
            }
        } else if (!(isForMap || dimensionInfo.getMemberValueType().getValue() != 3 && dimensionInfo.getMemberValueType().getValue() != 1)) {
            newMembers = this.getAllMemberForMembers(ctx, orgId, schemeHelper, dimensionInfo);
            if (isFilterDisable) {
                this.filterDisable(this.formCreateTime, newMembers);
            }
        } else if (isForMap && dimensionInfo.getMemberValueType().getValue() == 4) {
            newMembers = this.getAllMemberForMap(ctx, orgId, dimensionInfo, dimensionManager);
        }
        return newMembers;
    }

    private List<BgDimensionMember> filterDisable(Timestamp formCreateTime, List<BgDimensionMember> newMembers) {
        BgDimensionMember member = null;
        if (formCreateTime == null) {
            for (int i = 0; i < newMembers.size(); ++i) {
                member = newMembers.get(i);
                if (member.getDisabledDate() == null) continue;
                newMembers.remove(i);
                --i;
            }
        } else {
            for (int i = 0; i < newMembers.size(); ++i) {
                member = newMembers.get(i);
                if (member.getDisabledDate() == null || this.tMax == null || member.getDisabledDate().getTime() >= this.tMax.getTime()) continue;
                newMembers.remove(i);
                --i;
            }
        }
        return newMembers;
    }

    private List<BgDimensionMember> getAllMemberForMap(Context ctx, String orgId, BgDimensionInfo dimensionInfo, IBgDimensionManager dimensionManager) throws EASBizException, BOSException {
        return this.checkFactory.getHelper(orgId, dimensionManager.getSheet().getViewManager()).getRelationMember(dimensionInfo);
    }

    public List<BgDimensionMember> getAllMemberForDimension(Context ctx, String orgId, BgSchemeDimensionHelper schemeHelper, BgDimensionInfo dimensionInfo) throws BOSException, EASBizException {
        HashMap<String, BgDimensionMember> dimensionMembers = new HashMap<String, BgDimensionMember>();
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        try {
            DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance(ctx, schemeHelper.getDimension(dimensionInfo.getNumber()), orgId, schemeHelper.getBgSchemeId(), null, null);
            IDataProvider biz = helper.getQueryExecutor();
            EntityViewInfo evi = helper.getEntityView();
            biz.setObjectView(evi);
            this.readMember(dimensionMembers, helper, schemeHelper, biz);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!dimensionMembers.isEmpty()) {
            result.addAll(dimensionMembers.values());
            Collections.sort(result);
        }
        return result;
    }

    protected void readMember(Map<String, BgDimensionMember> dimensionMembers, DimensionFilterHelper helper, BgSchemeDimensionHelper schemeHelper, IDataProvider biz) throws BOSException, DimensionException, SQLException {
        IRowSet rs = null;
        try {
            rs = biz.executeQuery();
        }
        catch (FindedTooMuchRecordsException e) {
            logger.error((Object)"", (Throwable)e);
            throw new DimensionException(DimensionException.MEMBEROOMUCHRECORDS);
        }
        if (rs == null) {
            return;
        }
        while (rs.next()) {
            String number = rs.getString(helper.getFieldFlag() + "number");
            String name = rs.getString(helper.getFieldFlag() + "name");
            String longNumber = null;
            int level = 0;
            boolean isLeaf = true;
            if (helper.isTreeBase()) {
                longNumber = rs.getString(helper.getFieldFlag() + "longNumber");
                level = rs.getInt(helper.getFieldFlag() + "level");
                isLeaf = rs.getBoolean(helper.getFieldFlag() + "isLeaf");
            }
            if (dimensionMembers.containsKey(number)) continue;
            BgDimensionMember member = new BgDimensionMember(helper.getDimension().getNumber(), schemeHelper.getRefField(helper.getDimension().getNumber()), name, number);
            member.setFillType(0);
            member.setSrcNumber(schemeHelper.getSrcNumber(helper.getDimension().getNumber()));
            if (helper.isTreeBase()) {
                member.setSortValue((Comparable)((Object)longNumber));
                member.setLevel(level);
                member.setLeaf(isLeaf);
            }
            if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(member.getType()) || !DimensionBaseConstants.necessary.contains(member.getType())) {
                member.setDisabledDate(rs.getTimestamp(helper.getFieldFlag() + "disabledDate"));
            }
            dimensionMembers.put(member.getNumber(), member);
        }
    }

    private List<BgDimensionMember> getAllMemberForMembers(Context ctx, String orgId, BgSchemeDimensionHelper schemeHelper, BgDimensionInfo dimensionInfo) throws BOSException, EASBizException {
        Map memberCol;
        Map subMap;
        ArrayList<BgDimensionMember> newDimensionMembers = new ArrayList<BgDimensionMember>();
        if (StringUtils.isEmpty((String)orgId) || dimensionInfo == null) {
            return newDimensionMembers;
        }
        List members = dimensionInfo.getMember();
        if (members == null || members.size() <= 0) {
            return newDimensionMembers;
        }
        HashMap queryMap = new HashMap();
        BgDimensionMember curMember2 = null;
        for (BgDimensionMember curMember2 : members) {
            if (curMember2 == null || curMember2.getNumber() == null) continue;
            if (!queryMap.containsKey(curMember2.getType())) {
                queryMap.put(curMember2.getType(), new HashMap());
            }
            subMap = (Map)queryMap.get(curMember2.getType());
            this.addQueryMember(subMap, curMember2.getNumber(), 0);
            if (curMember2.getFillType() == 0) continue;
            this.addQueryMember(subMap, curMember2.getNumber(), curMember2.getFillType());
        }
        HashMap cacheData = new HashMap();
        HashMap<String, DimensionFilterHelper> cacheHelper = new HashMap<String, DimensionFilterHelper>();
        for (String dimNumber : queryMap.keySet()) {
            BgDimensionInfo dim = schemeHelper.getDimension(dimNumber);
            if (!cacheData.containsKey(dimNumber)) {
                cacheData.put(dimNumber, new HashMap());
            }
            memberCol = (Map)cacheData.get(dimNumber);
            DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance(ctx, dim, orgId, schemeHelper.getBgSchemeId(), null, null);
            cacheHelper.put(dimNumber, helper);
            IDataProvider biz = helper.getQueryExecutor();
            subMap = (Map)queryMap.get(dimNumber);
            Object[] fillTypes = subMap.keySet().toArray(new Integer[0]);
            Arrays.sort(fillTypes);
            for (int f = 0; f < fillTypes.length; ++f) {
                String[] numbers = ((Set)subMap.get(fillTypes[f])).toArray(new String[0]);
                int batchCount = MbgSqlHelper.getBatchCount((int)numbers.length);
                for (int b = 0; b < batchCount; ++b) {
                    int index;
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setSelector(helper.getSelector());
                    evi.setFilter(helper.getFilter());
                    HashSet<String> filterNumber = new HashSet<String>();
                    StringBuffer maskString = new StringBuffer();
                    int count = evi.getFilter().getFilterItems().size();
                    if (!StringUtils.isEmpty((String)evi.getFilter().getMaskString())) {
                        maskString.append(evi.getFilter().getMaskString());
                    } else {
                        for (int i = 0; i < count; ++i) {
                            if (i > 0) {
                                maskString.append(" and ");
                            }
                            maskString.append("#").append(i);
                        }
                    }
                    if (count > 0) {
                        maskString.append(" and ");
                    }
                    maskString.append("(");
                    boolean isFirst = true;
                    for (int i = 0; i < 50 && (index = b * 50 + i) < numbers.length; ++i) {
                        if ((Integer)fillTypes[f] == 0 || !helper.isTreeBase()) {
                            filterNumber.add(numbers[index]);
                            continue;
                        }
                        if (!memberCol.containsKey(numbers[index])) continue;
                        BgDimensionMember member = (BgDimensionMember)memberCol.get(numbers[index]);
                        String longNumber = (String)((Object)member.getSortValue());
                        member.setFillType((Integer)fillTypes[f]);
                        if (!isFirst) {
                            maskString.append("  or ");
                        }
                        if ((Integer)fillTypes[f] == 3 || (Integer)fillTypes[f] == 6) {
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "level", (Object)member.getLevel()));
                            maskString.append("#").append(count++);
                        } else if ((Integer)fillTypes[f] == 2 || (Integer)fillTypes[f] == 5) {
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                            maskString.append("#").append(count++);
                        } else if ((Integer)fillTypes[f] == 1 || (Integer)fillTypes[f] == 4) {
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "level", (Object)(member.getLevel() + 1)));
                            maskString.append("(#").append(count++).append(" and #").append(count++).append(")");
                        }
                        isFirst = false;
                    }
                    boolean needQuery = false;
                    if ((Integer)fillTypes[f] == 0 || !helper.isTreeBase()) {
                        if (!filterNumber.isEmpty()) {
                            String numberField = "number";
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + numberField, filterNumber, CompareType.INCLUDE));
                            maskString.append("#").append(count).append(")");
                            evi.getFilter().setMaskString(maskString.toString());
                            needQuery = true;
                        }
                    } else if (!isFirst) {
                        needQuery = true;
                        maskString.append(")");
                        evi.getFilter().setMaskString(maskString.toString());
                    }
                    if (!needQuery) continue;
                    biz.setObjectView(evi);
                    try {
                        this.readMember(memberCol, helper, schemeHelper, biz);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
        HashSet<String> existMember = new HashSet<String>();
        for (BgDimensionMember curMember2 : members) {
            if (curMember2 == null) continue;
            if (StringUtils.isEmpty((String)curMember2.getSrcNumber())) {
                curMember2.setSrcNumber(schemeHelper.getSrcNumber(dimensionInfo.getNumber()));
            }
            if ((memberCol = (Map)cacheData.get(curMember2.getType())) == null || memberCol.size() <= 0) continue;
            String srcPropName = "number";
            BgDimensionMember info = (BgDimensionMember)memberCol.get(curMember2.getNumber());
            if (info == null) continue;
            info.setVersion(curMember2.getVersion());
            info.setFillType(curMember2.getFillType());
            if (!existMember.contains(curMember2.getNumber())) {
                if (curMember2.getFillType() != 1 && curMember2.getFillType() != 2 && curMember2.getFillType() != 3) {
                    newDimensionMembers.add(info);
                }
                existMember.add(curMember2.getNumber());
            }
            if (info.getSortValue() != null) {
                curMember2.setSortValue(info.getSortValue());
            }
            if (info.getLongName() != null) {
                curMember2.setLongName(info.getLongName());
            }
            BgDimensionMember curInfo2 = null;
            ArrayList<BgDimensionMember> tempMembersForSort = new ArrayList<BgDimensionMember>();
            if (curMember2.getFillType() == 0 || !((DimensionFilterHelper)cacheHelper.get(curMember2.getType())).isTreeBase()) continue;
            if (curMember2.getFillType() == 1 || curMember2.getFillType() == 4) {
                for (BgDimensionMember curInfo2 : memberCol.values()) {
                    if (curMember2.getFillType() == 1 && info.getNumber().equals(curInfo2.getNumber()) || info.getLevel() + 1 != curInfo2.getLevel() || !((String)((Object)curInfo2.getSortValue())).startsWith(info.getSortValue() + "!") || existMember.contains(curInfo2.getNumber())) continue;
                    tempMembersForSort.add(curInfo2);
                    existMember.add(curInfo2.getNumber());
                }
                this.addMember(newDimensionMembers, (DimensionFilterHelper)cacheHelper.get(curMember2.getType()), tempMembersForSort, existMember);
                continue;
            }
            if (curMember2.getFillType() == 2 || curMember2.getFillType() == 5) {
                for (BgDimensionMember curInfo2 : memberCol.values()) {
                    if (curMember2.getFillType() == 2 && info.getNumber().equals(curInfo2.getNumber()) || !((String)((Object)curInfo2.getSortValue())).startsWith(info.getSortValue() + "!") || existMember.contains(curInfo2.getNumber())) continue;
                    tempMembersForSort.add(curInfo2);
                    existMember.add(curInfo2.getNumber());
                }
                this.addMember(newDimensionMembers, (DimensionFilterHelper)cacheHelper.get(curMember2.getSrcNumber()), tempMembersForSort, existMember);
                continue;
            }
            if (curMember2.getFillType() != 3 && curMember2.getFillType() != 6) continue;
            for (BgDimensionMember curInfo2 : memberCol.values()) {
                if (curMember2.getFillType() == 3 && info.getNumber().equals(curInfo2.getNumber())) continue;
                int index = ((String)((Object)info.getSortValue())).lastIndexOf("!");
                boolean isYes = false;
                if (index == -1) {
                    if (curInfo2.getLevel() == 1) {
                        isYes = true;
                    }
                } else if (((String)((Object)curInfo2.getSortValue())).startsWith(info.getSortValue().toString().substring(0, index + 1)) && curInfo2.getLevel() == info.getLevel()) {
                    isYes = true;
                }
                if (!isYes || existMember.contains(curInfo2.getNumber())) continue;
                tempMembersForSort.add(curInfo2);
            }
            this.addMember(newDimensionMembers, (DimensionFilterHelper)cacheHelper.get(curMember2.getSrcNumber()), tempMembersForSort, existMember);
        }
        return newDimensionMembers;
    }

    protected void addQueryMember(Map<Integer, Set<String>> subMap, String number, int fillType) {
        if (!subMap.containsKey(fillType)) {
            subMap.put(fillType, new HashSet());
        }
        subMap.get(fillType).add(number);
    }

    private void addMember(List<BgDimensionMember> newDimensionMembers, DimensionFilterHelper filterHelper, List<BgDimensionMember> infos, Set<String> existMember) {
        Collections.sort(infos);
        for (BgDimensionMember info : infos) {
            info.setFilled(true);
            newDimensionMembers.add(info);
        }
    }
}

