/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgRefDimMemberEnum;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.BgRefDimMemberHelper;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgDataAssistCollection;
import com.kingdee.eas.ma.mbg.BgDataAssistEntryFactory;
import com.kingdee.eas.ma.mbg.BgDataAssistEntryInfo;
import com.kingdee.eas.ma.mbg.BgDataAssistFactory;
import com.kingdee.eas.ma.mbg.BgDataAssistInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.IBgDataAssistEntry;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellCollection;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.rabbitmq.rabbit.app.util.SQLUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgFormRollSHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.utils.MbgFormRollSHelper");
    public static final String RESOURCE_DECOMPOSE = "com.kingdee.eas.ma.mbg.MbgRollFormResource";
    protected static BgCodeNumberHelper numberCodeHelper = new BgCodeNumberHelper(null, null, "sourceType");
    protected static BgCodeNumberHelper nameCodeHelper = new BgCodeNumberHelper(null, "name", "sourceType");

    public static int checkNumberCodeRule(BgFormCollection bgFormCol, Map<String, String> errorMap) throws Exception {
        int failCount = 0;
        BgFormInfo bgFormInfo = null;
        String orgId = null;
        HashSet<String> orgIdFail = new HashSet<String>();
        Iterator iterator = bgFormCol.iterator();
        String defFormName = null;
        while (iterator.hasNext()) {
            bgFormInfo = (BgFormInfo)iterator.next();
            orgId = bgFormInfo.getOrgUnit().getId().toString();
            if (orgIdFail.contains(orgId)) {
                ++failCount;
                continue;
            }
            numberCodeHelper.init((IObjectValue)bgFormInfo, orgId);
            if (!numberCodeHelper.isHasCodeNumber()) {
                ++failCount;
                orgIdFail.add(orgId);
                errorMap.put(bgFormInfo.getId().toString(), EASResource.getString((String)RESOURCE_DECOMPOSE, (String)"codeNumberRollFail", (Object[])new Object[]{bgFormInfo.getOrgUnit().getName() + "(" + bgFormInfo.getOrgUnit().getNumber() + ")"}));
                iterator.remove();
                continue;
            }
            defFormName = bgFormInfo.getBgPeriod().getName() + bgFormInfo.getBgTemplate().getName() + bgFormInfo.getBgVersion().getName();
            numberCodeHelper.applyNumber((IObjectValue)bgFormInfo, orgId, "rollForm", true);
            if (nameCodeHelper.isHasCodeNumber()) {
                nameCodeHelper.applyNumber((IObjectValue)bgFormInfo, orgId, defFormName, true);
                continue;
            }
            bgFormInfo.setName(defFormName);
        }
        return failCount;
    }

    public static BgFormInfo generateHistroyRollForm(Context ctx, String oldFormId, BgFormInfo bgFormInfo) throws Exception {
        BgFormInfo result = null;
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgFormInfo.getBgScheme().getId().toString());
        String bgDataTable = bgFormInfo.getBgScheme().getRefCube();
        String descFormTable = null;
        String descDataTable = null;
        BgSchemeInfo bgScheme = bgFormInfo.getBgScheme();
        BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, schemeHelper, bgDataTable);
        ArrayList<String> addNewViewlistSourceFormIds = new ArrayList<String>();
        addNewViewlistSourceFormIds.add(oldFormId);
        String versionNumber = bgFormInfo.getBgVersion().getNumber();
        String oldVersionNumber = versionNumber.substring(0, versionNumber.indexOf("-"));
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            descFormTable = MbgFormRollSHelper.createDescFormTable(pool);
            descDataTable = MbgFormRollSHelper.createDescDataTable(pool);
            MbgFormRollSHelper.copyData(ctx, conn, oldFormId, bgFormInfo);
            boolean viewForm = MbgFormRollSHelper.isViewForm(bgFormInfo);
            IMbgViewBase sourceView = MbgFormRollSHelper.parse(ctx, bgFormInfo.getEntries().get(0).getDimensionData(), viewForm);
            if (viewForm) {
                if (sourceView != null && !sourceView.getSheetManagers().isEmpty()) {
                    MbgFormRollSHelper.replaceVersion(null, sourceView, bgFormInfo);
                    sourceView = MbgFormRollSHelper.loadViewManager(ctx, oldFormId, null, sourceView, null, bgFormInfo.getOrgUnit().getId().toString(), true, false);
                    MbgFormRollSHelper.fillVersion(sourceView, bgFormInfo);
                    bgFormInfo.getEntries().get(0).setDimensionData(MbgFormRollSHelper.unParse(ctx, sourceView, viewForm));
                }
                if (4 == bgFormInfo.getBgTemplate().getFormType().getValue()) {
                    MbgFormRollSHelper.deleteAssist(ctx, bgFormInfo, conn);
                    Set<String> assistIDs = MbgFormRollSHelper.saveAssist(ctx, oldFormId, bgFormInfo, conn);
                    MbgFormRollSHelper.saveAssistEntry(ctx, bgFormInfo, assistIDs);
                }
                BgFacadeHelper.saveViewRef1(ctx, schemeHelper, bgFormInfo.getId().toString(), bgFormInfo.getOrgUnit().getId().toString(), BgRefDimMemberEnum.BgForm, MbgFormRollSHelper.parse(ctx, bgFormInfo.getEntries().get(0).getDimensionData(), viewForm), true);
            } else {
                BgFacadeHelper.saveBgDataRef(ctx, bgDataTable, BgCubeUtils.getBudgetEntryCubeName(bgDataTable), schemeHelper, bgFormInfo, null, accIntHelper.getSplitTablesByAcc(null), accIntHelper.isUseAccInt());
            }
            if (2 == bgFormInfo.getBgTemplate().getFormType().getValue()) {
                MbgFormRollSHelper.innerCopyDesc(ctx, conn, descFormTable, descDataTable, bgScheme, oldVersionNumber, bgFormInfo.getBgVersion(), addNewViewlistSourceFormIds, true);
            }
            if (!viewForm) {
                BgRefDimMemberHelper.copyRefForRollForm((Context)ctx, (String)bgFormInfo.getBgScheme().getId().toString(), (String)bgFormInfo.getId().toString(), (String)bgFormInfo.getBgVersion().getId().toString(), (String)bgFormInfo.getOrgUnit().getId().toString());
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                pool.releaseTable(descDataTable);
                pool.releaseTable(descFormTable);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        pool.releaseTable(descDataTable);
        pool.releaseTable(descFormTable);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    private static void copyData(Context ctx, Connection conn, String oldFormId, BgFormInfo bgFormInfo) throws Exception {
        BgSchemeInfo rootBgScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgFormInfo.getBgScheme().getId());
        if (rootBgScheme == null) {
            return;
        }
        String bgDataTable = rootBgScheme.getRefCube();
        String cubeEntryName = BgCubeUtils.getCubeEntryName(bgDataTable, 1);
        if (bgDataTable == null || cubeEntryName == null) {
            return;
        }
        List<String> refFields = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String bgDataTmpTable = null;
        String bgDataEntryTmpTable = null;
        try {
            int i;
            refFields = BgViewServerHelper.getCubeFields(conn, bgDataTable);
            bgDataTmpTable = MbgFormRollSHelper.createTmpDataTable(refFields, pool);
            bgDataEntryTmpTable = MbgFormRollSHelper.createTmpDataEntry(pool);
            MbgFormRollSHelper.insertDataToBgDataTmpTable(bgDataTmpTable, bgDataTable, cubeEntryName, refFields, oldFormId, conn);
            MbgSqlHelper.execute((Connection)conn, (String)("Insert Into " + bgDataEntryTmpTable + "(FTargetFormId, FSourceDataId) Select FFormId, FDataId FROM " + cubeEntryName + " Where FFormId  ='" + oldFormId + "'"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataTmpTable + " Set Fversion = '" + bgFormInfo.getBgVersion().getVersionId() + "'"));
            MbgFormRollSHelper.dealHistoryDataUpdate(conn, bgDataTmpTable, bgDataTable);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataTmpTable + " Set FTargetDataId = newbosid('3BA4D30D') where FTargetDataId is null"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataEntryTmpTable + " t1 Set FTargetDataId = (Select FTargetDataId FROM " + bgDataTmpTable + " t2 Where t2.FID = t1.FSourceDataId)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + bgDataEntryTmpTable + " t1 Set FTargetFormId = '" + bgFormInfo.getId().toString() + "'"));
            MbgSqlHelper.execute((Connection)conn, (String)("delete " + bgDataTmpTable + " where exists (select * from " + bgDataTable + " where fid = " + bgDataTmpTable + ".FTargetDataId)"));
            StringBuffer sql = new StringBuffer();
            Timestamp now = new Timestamp(System.currentTimeMillis());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            sql.setLength(0);
            sql.append("Insert Into " + bgDataTable + "  (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate, FDataSource ");
            for (i = 0; i < refFields.size(); ++i) {
                sql.append(", ").append(refFields.get(i));
            }
            sql.append(", FAudOrgUnitId, FDetail");
            sql.append(") Select FTargetDataId, ?, ?, ?, ?, FOrgUnitId, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate, FDataSource ");
            for (i = 0; i < refFields.size(); ++i) {
                sql.append(", ").append(refFields.get(i));
            }
            sql.append(", FAudOrgUnitId, FDetail");
            sql.append(" FROM " + bgDataTmpTable);
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (Object)new Object[]{userId, now, userId, now});
            MbgSqlHelper.execute((Connection)conn, (String)("Insert into " + cubeEntryName + "(fdataId,fformId) select FTargetDataId,FTargetFormId from " + bgDataEntryTmpTable + " where FTargetDataId is not null"));
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                pool.releaseTable(bgDataTmpTable);
                pool.releaseTable(bgDataTmpTable);
                throw throwable;
            }
        }
        pool.releaseTable(bgDataTmpTable);
        pool.releaseTable(bgDataTmpTable);
    }

    private static String createTmpDataEntry(TempTablePool pool) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_Mbg_bgDatEnt(");
        sql.append("FSourceDataId VARCHAR(44) NOT NULL, ");
        sql.append("FTargetDataId VARCHAR(44), ");
        sql.append("FTargetFormId VARCHAR(44))");
        String bgDataEntryTmpTable = pool.createTempTable(sql.toString());
        return bgDataEntryTmpTable;
    }

    private static String createTmpDataTable(List<String> refFields, TempTablePool pool) throws Exception {
        StringBuffer str = new StringBuffer();
        String tmpStr = null;
        str.append("Create Table T_mbg_bgDataTmpTable( FID VARCHAR(44) DEFAULT '' NOT NULL, FTargetDataId VARCHAR(44),FCreatorID VARCHAR(44) DEFAULT '' NOT NULL, FCreateTime DateTime, FLastUpdateUserID VARCHAR(44) DEFAULT '' NOT NULL, FLastUpdateTime DateTime, FOrgUnitID VARCHAR(44) DEFAULT '' NOT NULL, FFormula NVARCHAR(300) DEFAULT '' NOT NULL, FValue NUMERIC(21,8) DEFAULT 0 NOT NULL, FTmpValue NUMERIC(21,8) DEFAULT 0 NOT NULL, ");
        int in = refFields.size();
        for (int i = 0; i < in; ++i) {
            tmpStr = refFields.get(i);
            str.append(tmpStr + " NVARCHAR(84), ");
        }
        str.append("FBgItemCombination NVARCHAR(300), FBgPeriodID VARCHAR(44) DEFAULT '' NOT NULL, FBgElementID VARCHAR(44) DEFAULT '' NOT NULL, FCurrencyID VARCHAR(44) DEFAULT '' NOT NULL, FScenario INT DEFAULT 0 NOT NULL, FVersion INT DEFAULT 0 NOT NULL, FState INT DEFAULT 1 NOT NULL, FIsUpdate INT DEFAULT 1 NOT NULL, FAudOrgUnitID VARCHAR(44), FAudUserID VARCHAR(44), FDetail INT DEFAULT 0 NOT NULL,FAudFormId VARCHAR(44), FDataSource NUMERIC(21,8), FReportOrgUnitID VARCHAR(44))");
        String bgDataTmpTable = pool.createTempTable(str.toString());
        return bgDataTmpTable;
    }

    private static void insertDataToBgDataTmpTable(String bgDataTmpTable, String bgDataTable, String cubeEntryName, List refFields, String bgFormId, Connection conn) throws BOSException {
        int i;
        MbgSqlHelper.execute((Connection)conn, (String)("TRUNCATE TABLE " + bgDataTmpTable));
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + bgDataTmpTable + " (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate, FDataSource,FAudOrgUnitId, FDetail ");
        for (i = 0; i < refFields.size(); ++i) {
            sql.append(", ").append(refFields.get(i));
        }
        sql.append(") Select FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FOrgUnitID, FFormula, FValue, FTmpValue, FBgItemCombination, FBgPeriodID, FBgElementID, FCurrencyID, FScenario, FVersion, FState, FIsUpdate, FDataSource,FAudOrgUnitId, FDetail ");
        for (i = 0; i < refFields.size(); ++i) {
            sql.append(", ").append(refFields.get(i));
        }
        sql.append(" FROM " + bgDataTable + "  Where FID IN (select FDataId from " + cubeEntryName + " where FFORMID ='" + bgFormId + "')");
        MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
    }

    private static void innerCopyDesc(Context ctx, Connection conn, String descFormTable, String descDataTable, BgSchemeInfo bgSchemeInfo, String sourceVersionNumber, BgVersionInfo targetVersionInfo, List<String> bgFormIds, boolean isUpdateExists) throws BOSException, EASBizException {
        if (bgSchemeInfo == null || sourceVersionNumber == null || targetVersionInfo == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        try {
            MbgSqlHelper.execute((Connection)conn, (String)("TRUNCATE TABLE " + descFormTable));
            MbgSqlHelper.execute((Connection)conn, (String)("TRUNCATE TABLE " + descDataTable));
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + descFormTable + "(FSourceFormID) Values(?)"), bgFormIds);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descFormTable + " t0 Set FBgSchemeId = (Select FBgSchemeId FROM T_MBg_BgForm t1 Where t1.FID = t0.FSourceFormID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descFormTable + " t0 Set FOrgUnitId = (Select FOrgUnitId FROM T_MBg_BgForm t1 Where t1.FID = t0.FSourceFormID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descFormTable + " t0 Set FBgTemplateId = (Select FBgTemplateId FROM T_MBg_BgForm t1 Where t1.FID = t0.FSourceFormID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descFormTable + " t0 Set FCurrencyId = (Select FCurrencyId FROM T_MBg_BgForm t1 Where t1.FID = t0.FSourceFormID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descFormTable + " t0 Set FBgPeriodId = (Select FBgPeriodId FROM T_MBg_BgForm t1 Where t1.FID = t0.FSourceFormID)"));
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + descFormTable + " t1 Set FTargetFormId = (Select TOP 1 t2.FAdjustID FROM T_Mbg_BgForm t2 Where t2.FBgSchemeId = t1.FBgSchemeId AND t2.FOrgUnitId = t1.FOrgUnitId AND t2.FBgTemplateId = t1.FBgTemplateId AND t2.FCurrencyId = t1.FCurrencyId AND t2.FBgPeriodId = t1.FBgPeriodId AND t2.FBgVersionID = ?)"), (Object)new Object[]{targetVersionInfo.getId().toString()});
            MbgSqlHelper.execute((Connection)conn, (String)("Delete " + descFormTable + " Where FTargetFormId IS NULL"));
            MbgSqlHelper.execute((Connection)conn, (String)("Insert Into " + descDataTable + "(FSourceDescID, FSourceFormId, FMemberNumber, FBgSchemeId, FOrgUnitId, FBgTemplateId, FCurrencyId, FBgPeriodId, FValue, FSheetIndex, FRowIndex, FColIndex, FIsRow) Select t0.FViewListDesId, t0.FBgFormId, t1.FMemberNumber, t1.FBgSchemeId, t1.FOrgUnitId, t1.FBgTemplateId, t1.FCurrencyId, t1.FBgPeriodId, t1.FValue_" + ctx.getLocale() + ", t1.FSheetIndex, t1.FRowIndex, t1.FColIndex, t1.FIsRow FROM T_MBG_MbgViewListDesCellEntry t0 Inner Join T_MBG_MbgViewListDesCell t1 ON T0.FViewListDesId = t1.FID Where t0.FBgFormId IN (Select FSourceFormID FROM " + descFormTable + ")"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descDataTable + " t0 Set FTargetFormId = (Select FTargetFormId FROM " + descFormTable + " t1 Where t0.FSourceFormId = t1.FSourceFormId)"));
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + descDataTable + " t0 Set FMemberNumber = Replace(FMemberNumber, ?, ?)"), (Object)new Object[]{DimensionFormulaHelper.getCombination(DimensionConstants.DEF_VERSION_SRCNUMBER, sourceVersionNumber), DimensionFormulaHelper.getCombination(DimensionConstants.DEF_VERSION_SRCNUMBER, targetVersionInfo.getNumber())});
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + descDataTable + " t0 Set FTargetDescID = (Select FID FROM T_MBG_MbgViewListDesCell t1 Where t1.FMemberNumber = t0.FMemberNumber AND t0.FBgSchemeId = t1.FBgSchemeId AND t0.FOrgUnitId = t1.FOrgUnitId AND t0.FBgTemplateId = t1.FBgTemplateId AND t0.FCurrencyId = t1.FCurrencyId AND t0.FBgPeriodId = t1.FBgPeriodId AND t0.FSheetIndex = t1.FSheetIndex AND t0.FRowIndex = t1.FRowIndex AND t0.FColIndex = t1.FColIndex AND t0.FIsRow = t1.FIsRow AND t1.FVersionId = ?)"), (Object)new Object[]{targetVersionInfo.getId().toString()});
            if (isUpdateExists) {
                MbgSqlHelper.execute((Connection)conn, (String)("Update T_MBG_MbgViewListDesCell t0 Set FValue_" + ctx.getLocale() + " = (Select FValue FROM " + descDataTable + " t1 Where t0.FID = t1.FTargetDescID) Where FID IN(Select FTargetDescID FROM " + descDataTable + " Where FTargetDescID IS NOT NULL)"));
            }
            MbgSqlHelper.execute((Connection)conn, (String)("Delete " + descDataTable + " Where FTargetDescID IS NOT NULL"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + descDataTable + " Set FTargetDescID = newbosid('45F786DD')"));
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into T_MBG_MbgViewListDesCell(FID, FVersionId, FMemberNumber, FBgSchemeId, FOrgUnitId, FBgTemplateId, FCurrencyId, FBgPeriodId, FValue_" + ctx.getLocale() + ", FSheetIndex, FRowIndex, FColIndex, FIsRow) Select FTargetDescID, ?, FMemberNumber, FBgSchemeId, FOrgUnitId, FBgTemplateId, FCurrencyId, FBgPeriodId, FValue, FSheetIndex, FRowIndex, FColIndex, FIsRow FROM " + descDataTable), (Object)new Object[]{targetVersionInfo.getId().toString()});
            MbgSqlHelper.execute((Connection)conn, (String)("Insert Into T_MBG_MbgViewListDesCellEntry(FID, FBgFormId, FViewListDesId) Select newbosid('02EB5395'), FTargetFormId, FTargetDescID FROM " + descDataTable));
            if (isUpdateExists) {
                MbgSqlHelper.execute((Connection)conn, (String)("Update T_MBG_MbgViewListEditNote t0 Set FValue = (Select t1.FValue FROM T_MBG_MbgViewListEditNote t1 ," + descFormTable + " t2 Where t1.FBgFormID = t2.FSourceFormId  AND t0.FBgFormID = t2.FTargetFormId AND t0.FSheetIndex = t1.FSheetIndex) Where FBgFormID IN(Select FTargetFormId FROM " + descFormTable + ")"));
            }
            MbgSqlHelper.execute((Connection)conn, (String)("Insert Into T_MBG_MbgViewListEditNote(FID, FBgFormId, FSheetIndex, FValue ) Select newbosid('9D8BE7F3'), t1.FTargetFormId, t0.FSheetIndex, t0.FValue FROM T_MBG_MbgViewListEditNote t0 Inner Join " + descFormTable + " t1 ON t0.FBgFormId = t1.FSourceFormId Where not exists(Select t2.FID FROM T_MBG_MbgViewListEditNote t2 Where t2.FBgFormId = t1.FTargetFormId AND t2.FSheetIndex = t0.FSheetIndex)"));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected static void replaceVersion(IMbgViewBase tempView, IMbgViewBase view, BgFormInfo bgFormInfo) {
        MbgViewListSheetManager sheet = null;
        MbgViewListDimensionInfo dimension = null;
        List dimensions = null;
        BgDimensionMember member2 = null;
        BgDimensionMember sourceMember = null;
        String versionNumber = bgFormInfo.getBgVersion().getNumber();
        String oldVersionNumber = versionNumber.substring(0, versionNumber.indexOf("-"));
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            sheet = (MbgViewListSheetManager)view.getSheetManagers().get(s);
            dimensions = MbgFormRollSHelper.getAllDimension(sheet);
            for (int d = 0; d < dimensions.size(); ++d) {
                if (!(dimensions.get(d) instanceof MbgViewListDimensionInfo)) continue;
                sourceMember = null;
                dimension = (MbgViewListDimensionInfo)dimensions.get(d);
                if (!dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER) || !BgMemberSelectTypeEnum.Member.equals((Object)dimension.getMemberType()) || !DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType()) && !DimensionMemberValueModeEnum.SelectMember.equals((Object)dimension.getMemberValueType())) continue;
                boolean isNeedAdd = true;
                for (BgDimensionMember member2 : dimension.getSelectMembers()) {
                    if (bgFormInfo.getBgVersion().getNumber().equals(member2.getNumber())) {
                        isNeedAdd = false;
                        break;
                    }
                    if (!oldVersionNumber.equals(member2.getNumber())) continue;
                    sourceMember = member2;
                }
                if (!isNeedAdd) continue;
                if (sourceMember != null) {
                    sourceMember.setAlias(bgFormInfo.getBgVersion().getName());
                    sourceMember.setNumber(bgFormInfo.getBgVersion().getNumber());
                    sourceMember.setSortValue((Comparable)((Object)bgFormInfo.getBgVersion().getNumber()));
                    sourceMember.setAttribute(bgFormInfo.getBgVersion().getId().toString());
                    continue;
                }
                member2 = new BgDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, bgFormInfo.getBgVersion().getId().toString(), bgFormInfo.getBgVersion().getName(), bgFormInfo.getBgVersion().getNumber());
                member2.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
                dimension.getSelectMembers().add(member2);
            }
        }
        MbgFormRollSHelper.replaceRelation(MbgViewListFormServerHelper.getRelationMaps((MbgViewListManager)view), bgFormInfo);
    }

    protected static List getAllDimension(IMbgSheetBase sheet) {
        return ((MbgViewListSheetManager)sheet).getDimensionManager().getAllDimensions();
    }

    protected static void replaceRelation(List<MbgRelationMap> relationMaps, BgFormInfo bgFormInfo) {
        if (relationMaps == null || relationMaps.isEmpty()) {
            return;
        }
        boolean hasTargetVersion = false;
        boolean hasVersion = false;
        String[] items = null;
        MbgRelationMap relationMap = null;
        String versionNumber = bgFormInfo.getBgVersion().getNumber();
        String oldVersionNumber = versionNumber.substring(0, versionNumber.indexOf("-"));
        block0: for (int r = 0; r < relationMaps.size(); ++r) {
            relationMap = relationMaps.get(r);
            for (int e = 0; e < relationMap.getGroup().getEntries().size(); ++e) {
                if (!DimensionConstants.DEF_VERSION_NUMBER.equals(relationMap.getGroup().getEntries().get(e).getDimNumber())) continue;
                hasVersion = true;
                for (int s = 0; s < relationMap.getRelationShips().size(); ++s) {
                    items = relationMap.getRelationShips().get(s).getDimensionNumber().split(",");
                    for (int i = 0; i < items.length; ++i) {
                        if (!DimensionConstants.DEF_VERSION_SRCNUMBER.equals(DimensionFormulaHelper.getSrcNumber(items[i])) || !versionNumber.equals(DimensionFormulaHelper.getMemberNumber(items[i]))) continue;
                        hasTargetVersion = true;
                        break block0;
                    }
                }
                continue block0;
            }
        }
        if (hasVersion && !hasTargetVersion) {
            BgViewHelper.replaceRelationVersion(relationMaps, oldVersionNumber, versionNumber);
        }
    }

    private static boolean isViewForm(BgFormInfo targetForm) {
        return 4 == targetForm.getBgTemplate().getFormType().getValue() || 2 == targetForm.getBgTemplate().getFormType().getValue();
    }

    protected static IMbgViewBase parse(Context ctx, byte[] bytes, boolean isViewList) throws Exception {
        if (isViewList) {
            return new MbgViewListXMLParser(ctx).parse(bytes);
        }
        return new MbgXMLParser(ctx).parse(bytes);
    }

    protected static byte[] unParse(Context ctx, IMbgViewBase view, boolean viewForm) throws DimensionException {
        if (viewForm) {
            return new MbgViewListXMLParser(ctx).unParse((MbgViewListManager)view);
        }
        new MbgXMLParser(ctx);
        return MbgXMLParser.unParse((IMbgViewManager)view);
    }

    protected static IMbgViewBase loadViewManager(Context ctx, String bgViewId, String orgViewId, IMbgViewBase viewManager, String permissionNumber, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws EASBizException, BOSException {
        return MBGViewListFormFacadeFactory.getLocalInstance(ctx).loadViewListManager(bgViewId, orgViewId, (MbgViewListManager)viewManager, permissionNumber, currOrgId, isOnlyCurrOrg, isOnlyLeaf);
    }

    protected static void fillVersion(IMbgViewBase view, BgFormInfo bgFormInfo) throws DimensionException {
        IMbgSheetBase sheet = null;
        BgDimensionBaseInfo dimension = null;
        List dimensions = null;
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            sheet = view.getSheetManagers().get(s);
            dimensions = MbgFormRollSHelper.getAllDimension(sheet);
            for (int d = 0; d < dimensions.size(); ++d) {
                dimension = (BgDimensionBaseInfo)dimensions.get(d);
                if (!dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
                if (DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType())) {
                    dimension.getMember().clear();
                    BgViewHelper.fillVersionDimensionMember(dimension, bgFormInfo.getBgVersion());
                    dimension.setValue(dimension.unParseMember());
                    continue;
                }
                if (!DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
                boolean hasMember = false;
                for (int mm = 0; mm < dimension.getMember().size(); ++mm) {
                    if (!bgFormInfo.getBgVersion().getNumber().equals(((BgDimensionMember)dimension.getMember().get(mm)).getNumber())) continue;
                    hasMember = true;
                    break;
                }
                if (hasMember) continue;
                BgDimensionMember member = new BgDimensionMember(dimension.getNumber(), bgFormInfo.getBgVersion().getId().toString(), bgFormInfo.getBgVersion().getName(), bgFormInfo.getBgVersion().getNumber());
                member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
                dimension.getMember().add(member);
            }
        }
    }

    private static void deleteAssist(Context ctx, BgFormInfo targetForm, Connection conn) throws BOSException, EASBizException {
        final HashSet desIds = new HashSet();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("SELECT FID FROM T_MBG_BgDataAssist WHERE FID IN (SELECT FAssistID FROM T_MBG_BgDataAssistEntry where FBgFormID = '" + targetForm.getId() + "')"), null, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                desIds.add(res.getString("FID"));
            }
        });
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Delete FROM T_MBG_BgDataAssistEntry WHERE FBgFormID = '" + targetForm.getId() + "'"), null, null);
        if (!desIds.isEmpty()) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", desIds, CompareType.INCLUDE));
            BgDataAssistFactory.getLocalInstance(ctx).delete(filterInfo);
        }
    }

    private static Set<String> saveAssist(Context ctx, String sourceFormId, BgFormInfo targetForm, Connection conn) throws BOSException, EASBizException {
        CoreBaseCollection colls = new CoreBaseCollection();
        final HashSet<String> ids = new HashSet<String>();
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("SELECT FID FROM T_MBG_BgDataAssist WHERE FID IN (SELECT FAssistID FROM T_MBG_BgDataAssistEntry where FBgFormID = '" + targetForm.getId() + "')"), (List)null, (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                ids.add(res.getString("FID"));
            }
        });
        if (!ids.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            BgDataAssistCollection bgDataAssistCollection = BgDataAssistFactory.getLocalInstance(ctx).getBgDataAssistCollection(evi);
            for (int i = 0; i < bgDataAssistCollection.size(); ++i) {
                BgDataAssistInfo bgDataAssistInfo = bgDataAssistCollection.get(i);
                bgDataAssistInfo.setId(BOSUuid.create((BOSObjectType)bgDataAssistInfo.getBOSType()));
                colls.add((CoreBaseInfo)bgDataAssistInfo);
                ids.add(bgDataAssistInfo.getId().toString());
            }
            if (!colls.isEmpty()) {
                BgDataAssistFactory.getLocalInstance(ctx).saveBatchData(colls);
                return ids;
            }
        }
        return null;
    }

    private static void saveSourceFormDescToTargetForm(BgFormInfo targetForm, String sourceFormId, Context ctx) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("SELECT FVIEWLISTDESID FROM T_MBG_MbgViewListDesCellEntry where FBGFORMID = '" + sourceFormId + "'"), CompareType.INNER));
        MbgViewListDesCellCollection mbgViewListDesCellCollection = MbgViewListDesCellFactory.getLocalInstance(ctx).getMbgViewListDesCellCollection(evi);
        for (int i = 0; i < mbgViewListDesCellCollection.size(); ++i) {
            MbgViewListDesCellInfo mbgViewListDesCellInfo = mbgViewListDesCellCollection.get(i);
            mbgViewListDesCellInfo.setId(BOSUuid.create((BOSObjectType)mbgViewListDesCellInfo.getBOSType()));
        }
        MbgViewListDesCellFactory.getLocalInstance(ctx).saveBatchColls(mbgViewListDesCellCollection, (IObjectValue)targetForm);
    }

    private static void saveAssistEntry(Context ctx, BgFormInfo targetForm, Set<String> assistIDs) throws BOSException, EASBizException {
        if (assistIDs != null) {
            IBgDataAssistEntry localInstance = BgDataAssistEntryFactory.getLocalInstance(ctx);
            CoreBaseCollection colls = new CoreBaseCollection();
            for (String id : assistIDs) {
                BgDataAssistEntryInfo bgDataAssistEntryInfo = new BgDataAssistEntryInfo();
                bgDataAssistEntryInfo.setId(BOSUuid.create((BOSObjectType)bgDataAssistEntryInfo.getBOSType()));
                bgDataAssistEntryInfo.setAssistId(BOSUuid.read((String)id));
                bgDataAssistEntryInfo.setBgFormId(targetForm.getAdjustId());
                colls.add((CoreBaseInfo)bgDataAssistEntryInfo);
            }
            localInstance.saveBatchData(colls);
        }
    }

    public static Set<String> getHasFormId(Context ctx, BgFormInfo baseInfo) throws BOSException, EASBizException {
        String formId = null;
        HashSet<String> existFormIds = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        Object tmpIdTable = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            ArrayList paramList = new ArrayList();
            StringBuffer sql = new StringBuffer();
            sql.append("Select t0.fid FROM T_MBG_BgForm t0 ");
            if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
                sql.append(" Left Join T_MBG_BgSpecialItems t1 ON t1.FBgFormId = t0.FID ");
            }
            sql.append("Where t0.FBgSchemeId = ? ");
            sql.append("AND t0.FOrgUnitId  = ? ");
            sql.append("AND t0.FBgTemplateId = ? ");
            sql.append("AND t0.FBgPeriodId = ? ");
            sql.append("AND t0.FBgVersionId  = ? ");
            sql.append("AND t0.FCurrencyId  = ?");
            sql.append("AND t0.FProcessType = ? ");
            if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
                sql.append(" AND (t1.FDimensionNumber = ? OR t1.FDimensionNumber IS NULL)");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, baseInfo.getBgScheme().getId().toString());
            pstmt.setString(2, baseInfo.getOrgUnit().getId().toString());
            pstmt.setString(3, baseInfo.getBgTemplate().getId().toString());
            pstmt.setString(4, baseInfo.getBgPeriod().getId().toString());
            pstmt.setString(5, baseInfo.getBgVersion().getId().toString());
            pstmt.setString(6, baseInfo.getCurrency().getId().toString());
            pstmt.setInt(7, baseInfo.getProcessType().getValue());
            if (baseInfo.getBgSpecialItems() != null && !baseInfo.getBgSpecialItems().isEmpty()) {
                pstmt.setString(8, baseInfo.getBgSpecialItems().get(0).getDimensionNumber());
            }
            res = pstmt.executeQuery();
            while (res.next()) {
                formId = res.getString("Fid");
                existFormIds.add(formId);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        if (existFormIds.isEmpty()) {
            return null;
        }
        return existFormIds;
    }

    private static String createDescFormTable(TempTablePool pool) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_MBG_VersionCopyD(");
        sql.append("FSourceFormId VARCHAR(44) NOT NULL PRIMARY KEY, ");
        sql.append("FBgSchemeId VARCHAR(44), ");
        sql.append("FOrgUnitId VARCHAR(44), ");
        sql.append("FBgTemplateId VARCHAR(44), ");
        sql.append("FCurrencyId VARCHAR(44), ");
        sql.append("FBgPeriodId VARCHAR(44), ");
        sql.append("FTargetFormId VARCHAR(44)");
        sql.append(")");
        String bgFormTmpTable = pool.createTempTable(sql.toString());
        pool.createIndex(bgFormTmpTable, "FBgSchemeId, FOrgUnitId, FBgTemplateId, FCurrencyId, FBgPeriodId", false, false);
        pool.createIndex(bgFormTmpTable, "FTargetFormId", false, false);
        return bgFormTmpTable;
    }

    private static String createDescDataTable(TempTablePool pool) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_MBG_VersionCopyDT (FSourceDescID Varchar(44), FSourceFormId Varchar(44), FMemberNumber Varchar(255), FTargetDescID Varchar(44), FTargetFormId Varchar(44), ");
        sql.append("FBgSchemeId VARCHAR(44), ");
        sql.append("FOrgUnitId VARCHAR(44), ");
        sql.append("FBgTemplateId VARCHAR(44), ");
        sql.append("FCurrencyId VARCHAR(44), ");
        sql.append("FBgPeriodId VARCHAR(44), ");
        sql.append("FValue NVarchar(2000), ");
        sql.append("FSheetIndex INT, ");
        sql.append("FRowIndex INT, ");
        sql.append("FColIndex INT, ");
        sql.append("FIsRow INT");
        sql.append(")");
        String tempTable = pool.createTempTable(sql.toString());
        return tempTable;
    }

    private static void dealHistoryDataUpdate(Connection conn, String bgDataTmpTable, String bgDataTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(bgDataTmpTable).append(" set FTargetDataId = (select fid from ").append(bgDataTable).append(" where ").append(" FOrgUnitID = ").append(bgDataTmpTable).append(".FOrgUnitID and ").append("fversion =").append(bgDataTmpTable).append(".Fversion and ").append("Fformula =").append(bgDataTmpTable).append(".Fformula )");
        MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(bgDataTable).append(" set ").append("fvalue = (select fValue from ").append(bgDataTmpTable).append(" where FTargetDataId =").append(bgDataTable).append(".fid) where  exists (select * from ").append(bgDataTmpTable).append(" where FTargetDataId = ").append(bgDataTable).append(".fid)");
        MbgSqlHelper.execute((Connection)conn, (String)sql.toString());
    }
}

