/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgViewListControlUtils {
    private static final Logger logger = Logger.getLogger((String)MbgViewListControlUtils.class.getName());
    private static final String DEF_GID = "-1";
    private static final String DEF_COMBIN = ",";
    private static final String DATA_TABLE_ALIAS = "bgData";
    private Context ctx = null;
    private Connection conn = null;
    private String orgUnitId = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private TempTablePool pool = null;
    private MbgViewListDimensionManager dimensionManager = null;
    private String bgVersionNumber = null;

    public MbgViewListControlUtils(Context ctx, Connection conn, String orgUnitId, BgSchemeDimensionHelper schemeHelper, TempTablePool pool, MbgViewListDimensionManager dimensionManager, String bgVersionNumber) {
        this.ctx = ctx;
        this.conn = conn;
        this.orgUnitId = orgUnitId;
        this.schemeHelper = schemeHelper;
        this.pool = pool;
        this.dimensionManager = dimensionManager;
        this.bgVersionNumber = bgVersionNumber;
    }

    public Map<String, String> getSubMemberTmpTableMap() throws Exception {
        HashMap<String, String> subMemberTmpTableMap = new HashMap<String, String>();
        ArrayList<Integer> refFields = new ArrayList<Integer>();
        List<String> allDims = this.schemeHelper.getAllDim();
        for (int i = 0; i < allDims.size(); ++i) {
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(allDims.get(i))) continue;
            refFields.add(DimensionCommonHelper.getField(this.schemeHelper.getRefField(allDims.get(i))));
        }
        Collections.sort(refFields);
        String refField = null;
        for (int i = 0; i < refFields.size(); ++i) {
            refField = this.getRefField((Integer)refFields.get(i));
            subMemberTmpTableMap.put(refField, this.createSubMemberTmpTable(this.conn, this.pool, refField));
        }
        HashMap<String, List<String[]>> paramMap = new HashMap<String, List<String[]>>();
        ArrayList<MbgViewListDimensionInfo> dimensions = new ArrayList<MbgViewListDimensionInfo>();
        dimensions.addAll(this.dimensionManager.getPageDimension());
        dimensions.addAll(this.dimensionManager.getViewDimension());
        this.processNoCombin(paramMap, dimensions, DEF_GID);
        dimensions.clear();
        this.processRowCol(paramMap, this.dimensionManager.getRows(), true);
        this.processRowCol(paramMap, this.dimensionManager.getColumns(), false);
        paramMap.remove(DimensionConstants.DEF_ORGUNIT_NUMBER);
        if (paramMap.size() != this.schemeHelper.getAllDim().size() - 1) {
            return subMemberTmpTableMap;
        }
        this.removeOtherVersion(paramMap);
        if (this.checkEmpty(paramMap)) {
            return subMemberTmpTableMap;
        }
        this.queryChild(paramMap);
        this.addSrcNumber(paramMap);
        this.insertToTable(paramMap, subMemberTmpTableMap);
        this.queryDataId(subMemberTmpTableMap);
        return subMemberTmpTableMap;
    }

    private void saveToTable(Map<String, String> subMemberTmpTableMap) throws BOSException {
        for (String refField : subMemberTmpTableMap.keySet()) {
            String tableName = subMemberTmpTableMap.get(refField);
            MbgSqlHelper.execute((Connection)this.conn, (String)("IF EXISTS(select * from KSQL_USERTABLES where KSQL_TABNAME ='T_MBg_" + refField + "') DROP TABLE T_MBg_" + refField));
            MbgSqlHelper.execute((Connection)this.conn, (String)("Select * Into T_MBg_" + refField + " FROM " + tableName));
        }
    }

    private void addSrcNumber(Map<String, List<String[]>> paramMap) {
        List<String[]> paramList = null;
        String dimNumber = null;
        String srcNumber = null;
        List<String> dimNumbers = this.schemeHelper.getAccAndOtherDim(false);
        for (int d = 0; d < dimNumbers.size(); ++d) {
            dimNumber = dimNumbers.get(d);
            srcNumber = this.schemeHelper.getSrcNumber(dimNumber);
            paramList = paramMap.get(dimNumber);
            for (int p = 0; p < paramList.size(); ++p) {
                paramList.get((int)p)[2] = DimensionFormulaHelper.getCombination(srcNumber, paramList.get(p)[2]);
            }
        }
    }

    private void queryDataId(Map<String, String> subMemberTmpTableMap) throws BOSException {
        this.queryDataId(subMemberTmpTableMap, DimensionConstants.DEF_SCENARIO_FIELD, "T_MBg_BgScenario");
        this.queryDataId(subMemberTmpTableMap, DimensionConstants.DEF_VERSION_FIELD, "T_MBg_BgVersion");
        this.queryDataId(subMemberTmpTableMap, DimensionConstants.DEF_CURRENCY_FIELD, "T_BD_Currency");
        this.queryDataId(subMemberTmpTableMap, DimensionConstants.DEF_ELEMENT_FIELD, "T_MBG_BgElement");
        this.queryDataId(subMemberTmpTableMap, DimensionConstants.DEF_PERIOD_FIELD, "T_Mbg_BgPeriod");
    }

    private void queryDataId(Map<String, String> subMemberTmpTableMap, String refField, String sourceTableName) throws BOSException {
        String targetTableName = subMemberTmpTableMap.get(refField);
        String targetField = this.getTargetField(refField);
        String sourceField = this.getSourceField(refField);
        MbgSqlHelper.execute((Connection)this.conn, (String)("Update " + targetTableName + " T0 Set " + targetField + " = (Select " + sourceField + " FROM " + sourceTableName + " T1 Where T0.FNumber = T1.FNumber)"));
    }

    private String getSourceField(String refField) {
        if (DimensionConstants.DEF_SCENARIO_FIELD.equals(refField)) {
            return "FScenarioID";
        }
        if (DimensionConstants.DEF_VERSION_FIELD.equals(refField)) {
            return "FVersionID";
        }
        return "FID";
    }

    private String getDataField(String refField) {
        if (DimensionConstants.DEF_SCENARIO_FIELD.equals(refField)) {
            return "FScenario";
        }
        if (DimensionConstants.DEF_VERSION_FIELD.equals(refField)) {
            return "FVersion";
        }
        if (DimensionConstants.DEF_CURRENCY_FIELD.equals(refField)) {
            return "FCurrencyId";
        }
        if (DimensionConstants.DEF_ELEMENT_FIELD.equals(refField)) {
            return "FBgElementId";
        }
        if (DimensionConstants.DEF_PERIOD_FIELD.equals(refField)) {
            return "FBgPeriodId";
        }
        return refField;
    }

    private String getTargetField(String refField) {
        if (DimensionConstants.DEF_SCENARIO_FIELD.equals(refField) || DimensionConstants.DEF_VERSION_FIELD.equals(refField)) {
            return "FIntegerID";
        }
        if (DimensionConstants.DEF_CURRENCY_FIELD.equals(refField) || DimensionConstants.DEF_ELEMENT_FIELD.equals(refField) || DimensionConstants.DEF_PERIOD_FIELD.equals(refField)) {
            return "FID";
        }
        return "FNumber";
    }

    private void processRowCol(Map<String, List<String[]>> paramMap, List<IMbgViewListObject> rowCols, boolean isRow) {
        MbgViewListRowCol rowObject = null;
        String groupId = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
            rowObject = (MbgViewListRowCol)rowCols.get(i);
            String string = groupId = isRow ? String.valueOf(rowObject.getIndex()) : Sheet.getColumnName((int)rowObject.getIndex(), (int)0, (boolean)true, (boolean)false);
            if (rowObject.isCombin()) {
                this.processCombin(paramMap, rowObject, groupId);
                continue;
            }
            this.processNoCombin(paramMap, rowObject.getDimensions(), groupId);
        }
    }

    private void queryChild(Map<String, List<String[]>> paramMap) throws EASBizException, BOSException {
        String dimNumber2 = null;
        for (String dimNumber2 : paramMap.keySet()) {
            this.queryChild(dimNumber2, paramMap.get(dimNumber2));
        }
    }

    private void queryChild(String dimNumber, List<String[]> paramList) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)dimNumber) || DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber)) {
            return;
        }
        DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance(this.ctx, this.schemeHelper.getDimension(dimNumber), this.orgUnitId, null, null, null);
        if (!helper.isTreeBase()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(helper.getFilter());
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.getSelector().add("longNumber");
        boolean hasDefFilter = !evi.getFilter().getFilterItems().isEmpty();
        IDataProvider queryExecutor = helper.getQueryExecutor();
        queryExecutor.setObjectView(evi);
        String baseSQL = queryExecutor.getSQL();
        String tableName = baseSQL.substring(baseSQL.indexOf("\""), baseSQL.indexOf("."));
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            int i;
            HashMap<String, String> number_longnumber = new HashMap<String, String>();
            String number = null;
            String longNumber = null;
            HashSet<String> paramSet = new HashSet<String>();
            for (int i2 = 0; i2 < paramList.size(); ++i2) {
                paramSet.add(paramList.get(i2)[2]);
            }
            List params = MbgSqlHelper.getBatchParams(null, (Object[])paramSet.toArray(), (int)50);
            paramSet.clear();
            StringBuffer sql = new StringBuffer(baseSQL);
            if (hasDefFilter) {
                sql.append(" AND ");
            } else {
                sql.append(" Where");
            }
            sql.append(tableName).append(".FNumber IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmt = this.conn.prepareStatement(sql.toString());
            for (int i3 = 0; i3 < params.size(); ++i3) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i3)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    number = rst.getString("Number");
                    longNumber = rst.getString("LongNumber");
                    paramSet.add(longNumber + "!%");
                    number_longnumber.put(number, longNumber);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            HashMap<String, Set<String>> childMap = new HashMap<String, Set<String>>();
            sql.setLength(baseSQL.length());
            if (hasDefFilter) {
                sql.append(" AND (");
            } else {
                sql.append(" Where");
            }
            for (i = 0; i < 50; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(tableName).append(".FLongNumber Like ?");
            }
            if (hasDefFilter) {
                sql.append(")");
            }
            params = MbgSqlHelper.getBatchParams(null, (Object[])paramSet.toArray(), (int)50);
            pstmt = this.conn.prepareStatement(sql.toString());
            for (i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    number = rst.getString("Number");
                    longNumber = rst.getString("LongNumber");
                    this.addChild(childMap, number, longNumber);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            int count = paramList.size();
            String[] temp = null;
            for (int i4 = 0; i4 < count; ++i4) {
                temp = paramList.get(i4);
                number = temp[2];
                longNumber = (String)number_longnumber.get(number);
                if (longNumber == null || !childMap.containsKey(longNumber)) continue;
                Iterator it = ((Set)childMap.get(longNumber)).iterator();
                while (it.hasNext()) {
                    paramList.add(new String[]{temp[0], temp[1], (String)it.next()});
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    private void addChild(Map<String, Set<String>> childMap, String number, String longNumber) {
        if (longNumber == null || number == null) {
            return;
        }
        int index = longNumber.lastIndexOf("!");
        if (index < 0) {
            return;
        }
        if (!childMap.containsKey(longNumber = longNumber.substring(0, index))) {
            childMap.put(longNumber, new HashSet());
        }
        childMap.get(longNumber).add(number);
        this.addChild(childMap, number, longNumber);
    }

    private boolean checkEmpty(Map<String, List<String[]>> paramMap) {
        HashSet<String> emptyGroupIds = new HashSet<String>();
        Set<String> rowDims = this.getDimensionsNum(this.dimensionManager.getRowDimension());
        Set<String> colDims = this.getDimensionsNum(this.dimensionManager.getColDimension());
        rowDims.remove(DimensionConstants.DEF_ORGUNIT_NUMBER);
        colDims.remove(DimensionConstants.DEF_ORGUNIT_NUMBER);
        HashMap<String, Set<String>> rowGroup = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> colGroup = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> tempGroup = null;
        String dimNumber2 = null;
        String groupId = null;
        List<String[]> paramList2 = null;
        for (String dimNumber2 : paramMap.keySet()) {
            if (rowDims.contains(dimNumber2)) {
                tempGroup = rowGroup;
            } else {
                if (!colDims.contains(dimNumber2)) continue;
                tempGroup = colGroup;
            }
            paramList2 = paramMap.get(dimNumber2);
            for (int i = 0; i < paramList2.size(); ++i) {
                groupId = paramList2.get(i)[0];
                if (!tempGroup.containsKey(groupId)) {
                    tempGroup.put(groupId, new HashSet());
                }
                ((Set)tempGroup.get(groupId)).add(dimNumber2);
            }
        }
        this.getEmptyGroup(emptyGroupIds, rowGroup, rowDims);
        this.getEmptyGroup(emptyGroupIds, colGroup, colDims);
        for (List<String[]> paramList2 : paramMap.values()) {
            Iterator<String[]> itParam = paramList2.iterator();
            while (itParam.hasNext()) {
                if (!emptyGroupIds.contains(itParam.next()[0])) continue;
                itParam.remove();
            }
            if (!paramList2.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Set<String> getDimensionsNum(List dimensions) {
        HashSet<String> numbers = new HashSet<String>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof BgDimensionBaseInfo)) continue;
            numbers.add(((BgDimensionBaseInfo)dimensions.get(i)).getNumber());
        }
        return numbers;
    }

    private void getEmptyGroup(Set<String> emptyGroupIds, Map<String, Set<String>> groups, Set<String> dims) {
        String groupId2 = null;
        for (String groupId2 : groups.keySet()) {
            if (groups.get(groupId2).equals(dims)) continue;
            emptyGroupIds.add(groupId2);
        }
    }

    private void removeOtherVersion(Map<String, List<String[]>> paramMap) {
        if (this.bgVersionNumber == null) {
            return;
        }
        List<String[]> paramList = paramMap.get(DimensionConstants.DEF_VERSION_NUMBER);
        Iterator<String[]> it = paramList.iterator();
        while (it.hasNext()) {
            if (this.bgVersionNumber.equals(it.next()[2])) continue;
            it.remove();
        }
    }

    private void insertToTable(Map<String, List<String[]>> paramMap, Map<String, String> subMemberTmpTableMap) throws SQLException {
        String dimNumber2 = null;
        String tmpTable = null;
        List<String[]> params = null;
        logger.debug((Object)"begin audit Data TmpTable!");
        for (String dimNumber2 : paramMap.keySet()) {
            tmpTable = subMemberTmpTableMap.get(this.schemeHelper.getRefField(dimNumber2));
            params = paramMap.get(dimNumber2);
            MbgSqlHelper.executeBatch((Connection)this.conn, (String)("Insert Into " + tmpTable + "(FGID, FCombNumber, FNumber) Values(?, ?, ?)"), params);
            logger.debug((Object)("dimNumber = " + dimNumber2 + "; size = " + params.size()));
        }
        logger.debug((Object)"end audit Data TmpTable!");
    }

    private void processCombin(Map<String, List<String[]>> paramMap, MbgViewListRowCol rowObject, String groupId) {
        BgDimensionMember combin = null;
        String[] dimNumbers = null;
        String[] numbers = null;
        HashSet<String> dimNumberSet = new HashSet<String>();
        for (int m = 0; m < rowObject.getCombinMembers().size(); ++m) {
            combin = rowObject.getCombinMembers().get(m);
            if (dimNumberSet.contains(combin.getNumber())) continue;
            dimNumberSet.add(combin.getNumber());
            dimNumbers = combin.getType().split(DEF_COMBIN);
            numbers = combin.getNumber().split(DEF_COMBIN);
            for (int d = 0; d < dimNumbers.length; ++d) {
                if (d >= numbers.length) continue;
                this.getDimParam(paramMap, dimNumbers[d]).add(new String[]{groupId, combin.getNumber(), numbers[d]});
            }
        }
    }

    private void processNoCombin(Map<String, List<String[]>> paramMap, List<MbgViewListDimensionInfo> dimensions, String groupId) {
        for (int i = 0; i < dimensions.size(); ++i) {
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensions.get(i).getNumber())) continue;
            this.processNoCombin(paramMap, dimensions.get(i), groupId);
        }
    }

    private void processNoCombin(Map<String, List<String[]>> paramMap, MbgViewListDimensionInfo dimension, String groupId) {
        List<String[]> paramList = this.getDimParam(paramMap, dimension.getNumber());
        BgDimensionMember member = null;
        HashSet<String> dimNumberSet = new HashSet<String>();
        for (int i = 0; i < dimension.getMember().size(); ++i) {
            member = (BgDimensionMember)dimension.getMember().get(i);
            if (dimNumberSet.contains(member.getNumber())) continue;
            dimNumberSet.add(member.getNumber());
            paramList.add(new String[]{groupId, DEF_COMBIN, member.getNumber()});
        }
    }

    private List<String[]> getDimParam(Map<String, List<String[]>> paramMap, String dimNumber) {
        if (!paramMap.containsKey(dimNumber)) {
            paramMap.put(dimNumber, new ArrayList());
        }
        return paramMap.get(dimNumber);
    }

    private String createSubMemberTmpTable(Connection conn, TempTablePool pool, String refField) throws Exception {
        String sql = "Create Table T_MBg_SubMember" + refField + "(FGID Varchar(20) NOT NULL, FCombNumber NVarchar(200) NOT NULL, FNumber NVarchar(200) NOT NULL, FID Varchar(44), FIntegerID INT )";
        String tableName = pool.createTempTable(sql);
        pool.createIndex(tableName, "FGID, FCombNumber", false, false);
        return tableName;
    }

    private String getRefField(Integer field) {
        return "F" + field;
    }

    public String getQuerySql(Map<String, String> subMemberTmpTable, String cubeName) throws Exception {
        StringBuffer fromSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        this.buildSql(subMemberTmpTable, this.dimensionManager.getPageDimension(), fromSql, whereSql, false);
        this.buildSql(subMemberTmpTable, this.dimensionManager.getViewDimension(), fromSql, whereSql, false);
        this.buildSql(subMemberTmpTable, this.dimensionManager.getRowDimension(), fromSql, whereSql, true);
        this.buildSql(subMemberTmpTable, this.dimensionManager.getColDimension(), fromSql, whereSql, true);
        StringBuffer sql = new StringBuffer();
        sql.append("Select ").append(DATA_TABLE_ALIAS).append(".FID, ").append(DATA_TABLE_ALIAS).append(".FState, ").append(DATA_TABLE_ALIAS).append(".FAudOrgUnitID from ").append(cubeName).append(" ").append(DATA_TABLE_ALIAS).append(", ");
        sql.append(fromSql).append(" Where ").append(whereSql).append(" And ").append(DATA_TABLE_ALIAS).append(".FOrgUnitId IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        return sql.toString();
    }

    public String getQueryTmpSql(String queryTmpTable, Map<String, String> subMemberTmpTable, String cubeName) throws Exception {
        StringBuffer fromSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        this.buildSql(subMemberTmpTable, this.dimensionManager.getPageDimension(), fromSql, whereSql, false);
        this.buildSql(subMemberTmpTable, this.dimensionManager.getViewDimension(), fromSql, whereSql, false);
        this.buildSql(subMemberTmpTable, this.dimensionManager.getRowDimension(), fromSql, whereSql, true);
        this.buildSql(subMemberTmpTable, this.dimensionManager.getColDimension(), fromSql, whereSql, true);
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(queryTmpTable).append("(FOrgUnitId, FFormula, FVersion)");
        sql.append("Select ").append(DATA_TABLE_ALIAS).append(".FOrgUnitId, ").append(DATA_TABLE_ALIAS).append(".FFormula, ").append(DATA_TABLE_ALIAS).append(".FVersion from ").append(cubeName).append(" ").append(DATA_TABLE_ALIAS).append(", ");
        sql.append(fromSql).append(" Where ").append(whereSql).append(" And ").append(DATA_TABLE_ALIAS).append(".FOrgUnitId  = ? ").append(" And ").append(DATA_TABLE_ALIAS).append(".FVersion = ?");
        return sql.toString();
    }

    private void buildSql(Map<String, String> subMemberTmpTable, List dimensions, StringBuffer fromSql, StringBuffer whereSql, boolean isJoin) {
        Integer baseField = null;
        String refField = null;
        int field = -1;
        MbgViewListDimensionInfo dimension = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimension = (MbgViewListDimensionInfo)dimensions.get(i)).getNumber())) continue;
            refField = this.schemeHelper.getRefField(dimension.getNumber());
            field = DimensionCommonHelper.getField(refField);
            if (isJoin) {
                if (fromSql.length() > 0) {
                    fromSql.append(", ");
                }
                fromSql.append(subMemberTmpTable.get(refField)).append(" T").append(field);
                if (whereSql.length() > 0) {
                    whereSql.append(" And ");
                }
                whereSql.append(DATA_TABLE_ALIAS).append(".").append(this.getDataField(refField)).append(" = T").append(field).append(".").append(this.getTargetField(refField));
                if (baseField == null) {
                    baseField = field;
                    continue;
                }
                whereSql.append(" And ");
                whereSql.append("T").append(baseField).append(".FGID = T").append(field).append(".FGID AND T").append(baseField).append(".FCombNumber = T").append(field).append(".FCombNumber");
                continue;
            }
            if (whereSql.length() > 0) {
                whereSql.append(" And ");
            }
            whereSql.append(DATA_TABLE_ALIAS).append(".").append(this.getDataField(refField)).append(" IN( Select ").append(this.getTargetField(refField)).append(" FROM ").append(subMemberTmpTable.get(refField)).append(")");
        }
    }
}

