/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgHideItemEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgRollPartEnum;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.BgVariateCollection;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionCollection;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellEntryInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteInfo;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgPeriodDecomposeUtils;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgViewListFormServerHelper {
    private static final Logger logger = Logger.getLogger((String)MbgViewListFormServerHelper.class.getName());

    public static StringBuffer getQuerySQL(Context ctx) {
        StringBuffer sql = new StringBuffer("select bgForm.FID bgForm_FID, bgForm.FSourceType bgForm_FSourceType, bgForm.FNumber bgForm_FNumber, bgForm.FName bgForm_FName, bgForm.FDescription bgForm_FDescription, bgForm.FState bgForm_FState, ");
        sql.append(" bgScheme.FID bgScheme_FID, tNode.FOrgUnitId bgScheme_FOrgUnitId, orgUnit.FNumber orgUnit_FNumber,bgOrgUnit.FLongNumber bgOrgUnit_FLongNumber,bgOrgUnit.FIsLeaf bgOrgUnit_FIsLeaf , orgUnit.FName_" + ctx.getLocale() + " orgUnit_FName, bgTemplate.FID bgTemplate_FID,");
        sql.append(" bgTemplate.FLastUpdateTime bgTemplate_FLastUpdateTime, bgTemplate.FBgTypeId bgTemplate_FBgTypeId, bgTemplate.FData bgTemplate_FData, bgTemplate.FFormType bgTemplate_FFormType , ");
        sql.append(" bgTemplate.FDefaultMeasureUnitID bgTemplate_FDMUID, bgForm.FBgPeriodId bgForm_FBgPeriodId, bgForm.FCurrencyID bgForm_FCurrencyID,");
        sql.append(" bgForm.FCreatorID bgForm_FCreatorID, bgForm.FADJUSTID bgForm_FADJUSTID , bgForm.FProcessType bgForm_FProcessType,bgForm.FIsRolled isRolled");
        sql.append(" from T_MBg_bgTemplate bgTemplate ");
        sql.append(" inner join T_Mbg_BgTemplateNode tNode on tNode.FBgTemplateId = bgTemplate.FID ");
        sql.append(" left join T_MBg_bgscheme bgScheme on bgScheme.FID = bgTemplate.FBgSchemeID ");
        sql.append(" left join T_Org_CostCenter orgUnit on tNode.FOrgUnitId = orgUnit.FID ");
        sql.append(" left join T_Mbg_BgOrgUnit bgOrgUnit on bgOrgUnit.FOrgUnitId = orgUnit.FID and bgOrgUnit.FIsVirtual = 0");
        sql.append(" left join T_MBg_bgform bgForm on bgForm.FBgSchemeId = bgScheme.FID and bgForm.FBgTemplateId = bgTemplate.FID and bgForm.FOrgUnitId = tNode.FOrgUnitId");
        return sql;
    }

    public static BgFormInfo buildBgFormInfo(ResultSet res) throws SQLException {
        BgFormInfo b = new BgFormInfo();
        if (!StringUtils.isEmpty((String)res.getString("bgForm_FID"))) {
            b.setId(BOSUuid.read((String)res.getString("bgForm_FID")));
            b.setNumber(res.getString("bgForm_FNumber"));
            b.setName(res.getString("bgForm_FName"));
            b.setDescription(res.getString("bgForm_FDescription"));
            b.setBgPeriod(new BgPeriodInfo());
            b.getBgPeriod().setId(BOSUuid.read((String)res.getString("bgForm_FBgPeriodId")));
            b.setCurrency(new CurrencyInfo());
            b.getCurrency().setId(BOSUuid.read((String)res.getString("bgForm_FCurrencyID")));
            b.setState(BgFormStateEnum.getEnum(res.getInt("bgForm_FState")));
            b.setSourceType(RptSrcTypeEnum.getEnum((int)res.getInt("bgForm_FSourceType")));
            b.setAdjust(new BgFormInfo());
            b.getAdjust().setId(BOSUuid.read((String)res.getString("bgForm_FADJUSTID")));
        }
        b.setBgScheme(new BgSchemeInfo());
        b.getBgScheme().setId(BOSUuid.read((String)res.getString("bgScheme_FID")));
        b.setOrgUnit(new FullOrgUnitInfo());
        b.getOrgUnit().setId(BOSUuid.read((String)res.getString("bgScheme_FOrgUnitId")));
        b.getOrgUnit().setNumber(res.getString("orgUnit_FNumber"));
        b.getOrgUnit().setName(res.getString("orgUnit_FName"));
        b.getOrgUnit().setLongNumber(res.getString("bgOrgUnit_FLongNumber"));
        b.getOrgUnit().setIsLeaf(res.getBoolean("bgOrgUnit_FIsLeaf"));
        b.setBgTemplate(new BgTemplateInfo());
        b.getBgTemplate().setId(BOSUuid.read((String)res.getString("bgTemplate_FID")));
        b.getBgTemplate().setFormType(BgTemFormTypeEnum.getEnum(res.getInt("bgTemplate_FFormType")));
        b.setTemplateLastUpdateTime(res.getTimestamp("bgTemplate_FLastUpdateTime"));
        if (!StringUtils.isEmpty((String)res.getString("bgTemplate_FBgTypeId"))) {
            b.setBgType(new BgTypeInfo());
            b.getBgType().setId(BOSUuid.read((String)res.getString("bgTemplate_FBgTypeId")));
        }
        b.setMeasureUnit(new MeasureUnitInfo());
        if (res.getString("bgTemplate_FDMUID") != null) {
            b.getMeasureUnit().setId(BOSUuid.read((String)res.getString("bgTemplate_FDMUID")));
        } else {
            b.getMeasureUnit().setId(null);
        }
        if (res.getString("bgForm_FCreatorID") != null) {
            b.setCreator(new UserInfo());
            b.getCreator().setId(BOSUuid.read((String)res.getString("bgForm_FCreatorID")));
        }
        b.setProcessType(BgProcessEnum.getEnum(res.getInt("bgForm_FProcessType")));
        if (res.getString("isRolled") != null) {
            b.setIsRolled(res.getBoolean("isRolled"));
        }
        return b;
    }

    public static void batchAddNewView(Context ctx, Connection conn, List newForms, boolean isCheckNumber, String bgSchemeId, String bgTemplateId, boolean isUpdateShowTemp, boolean isShowByTemp) throws BOSException, EASBizException {
        if (!(ctx == null || newForms.isEmpty() || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgTemplateId))) {
            boolean closeConn = false;
            try {
                if (conn == null) {
                    closeConn = true;
                    conn = EJBFactory.getConnection((Context)ctx);
                }
                if (isCheckNumber) {
                    MbgViewListFormServerHelper.checkNumber(ctx, conn, newForms, bgSchemeId);
                }
                MbgViewListFormServerHelper.fillRptPeriod(ctx, newForms);
                MbgViewListFormServerHelper.fillOrgInfo(ctx, conn, newForms);
                MbgViewListFormServerHelper.batchAddNew(ctx, conn, newForms, bgSchemeId, bgTemplateId, isUpdateShowTemp, isShowByTemp);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (closeConn) {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
    }

    private static void checkNumber(Context ctx, Connection conn, List newForms, String bgSchemeId) throws BOSException, EASBizException {
        int i;
        BgFormInfo b;
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashMap<String, Set> numbers = new HashMap<String, Set>();
        for (int i2 = 0; i2 < newForms.size(); ++i2) {
            b = (BgFormInfo)newForms.get(i2);
            if (!numbers.containsKey(b.getNumber())) {
                numbers.put(b.getNumber(), new HashSet());
            }
            ((Set)numbers.get(b.getNumber())).add(b.getOrgUnit().getId().toString());
        }
        Object[] ns = numbers.keySet().toArray();
        for (i = 0; i < ns.length; ++i) {
            String number = (String)ns[i];
            Set orgIds = (Set)numbers.get(ns[i]);
            if ((orgIds = MbgViewListFormServerHelper.checkNumber(ctx, conn, "FNumber", number, "FOrgUnitID", orgIds, false, bgSchemeId)) == null) {
                numbers.remove(number);
                continue;
            }
            numbers.put(number, orgIds);
        }
        for (i = newForms.size() - 1; i >= 0; --i) {
            Set orgIds;
            b = (BgFormInfo)newForms.get(i);
            if (numbers.get(b.getNumber()) == null || !(orgIds = (Set)numbers.get(b.getNumber())).contains(b.getOrgUnit().getId().toString())) continue;
            newForms.remove(i);
        }
    }

    public static void fillRptPeriod(Context ctx, List newForms) throws BOSException, EASBizException {
        int i;
        BgFormInfo b;
        if (ctx == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashSet<String> periodIds = new HashSet<String>();
        for (int i2 = 0; i2 < newForms.size(); ++i2) {
            b = (BgFormInfo)newForms.get(i2);
            periodIds.add(String.valueOf(b.getBgPeriod().getId()));
        }
        HashMap<String, BgPeriodInfo> bgPeriods = new HashMap<String, BgPeriodInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("periodType");
        evi.getSelector().add("year");
        evi.getSelector().add("month");
        evi.getSelector().add("halfYear");
        evi.getSelector().add("quart");
        evi.getSelector().add("beginDate");
        evi.getSelector().add("endDate");
        evi.getSelector().add("week");
        evi.getSelector().add("isLeaf");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
        BgPeriodCollection bgPeriodCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
        if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
            for (i = 0; i < bgPeriodCol.size(); ++i) {
                bgPeriods.put(bgPeriodCol.get(i).getId().toString(), bgPeriodCol.get(i));
            }
        }
        for (i = 0; i < newForms.size(); ++i) {
            b = (BgFormInfo)newForms.get(i);
            b.setBgPeriod((BgPeriodInfo)bgPeriods.get(b.getBgPeriod().getId().toString()));
            BgViewHelper.converPeriodToRPT(b);
        }
    }

    public static void fillOrgInfo(Context ctx, Connection conn, List newForms) throws BOSException, EASBizException {
        if (conn == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        HashMap orgInfo = new HashMap();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < newForms.size(); ++i) {
            ids.add(String.valueOf(((BgFormInfo)newForms.get(i)).getOrgUnit().getId()));
        }
        PreparedStatement pstmt = null;
        try {
            StringBuffer sql = new StringBuffer("Select FID, FControlUnitID, FParentID, FIsCompanyOrgUnit From T_Org_CostCenter Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            MbgViewListFormServerHelper.queryOrgInfo(pstmt, ids, orgInfo);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        ArrayList<BgFormInfo> rmForm = new ArrayList<BgFormInfo>();
        for (int i = 0; i < newForms.size(); ++i) {
            BgFormInfo b = (BgFormInfo)newForms.get(i);
            if (orgInfo.get(b.getOrgUnit().getId().toString()) == null) {
                rmForm.add(b);
                continue;
            }
            b.setCU(((FullOrgUnitInfo)orgInfo.get(b.getOrgUnit().getId().toString())).getCU());
            b.setCompany(new CompanyOrgUnitInfo());
            b.getCompany().setId(MbgViewListFormServerHelper.getCompanyId(b.getOrgUnit().getId().toString(), orgInfo));
        }
        newForms.removeAll(rmForm);
    }

    private static BOSUuid getCompanyId(String id, Map orgInfo) {
        if (StringUtils.isEmpty((String)id) || orgInfo == null || !orgInfo.containsKey(id)) {
            return null;
        }
        FullOrgUnitInfo org = (FullOrgUnitInfo)orgInfo.get(id);
        if (org.isIsCompanyOrgUnit()) {
            return org.getId();
        }
        if (org.getParent() == null) {
            return null;
        }
        return MbgViewListFormServerHelper.getCompanyId(org.getParent().getId().toString(), orgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryOrgInfo(PreparedStatement pstmt, Set ids, Map orgInfo) throws SQLException {
        if (pstmt == null || ids == null || ids.isEmpty() || orgInfo == null) {
            return;
        }
        ids.removeAll(orgInfo.keySet());
        if (ids.isEmpty()) {
            return;
        }
        Object[] params = ids.toArray();
        int batchCount = (params.length - 1) / 50 + 1;
        HashSet<String> newIds = new HashSet<String>();
        ResultSet res = null;
        try {
            for (int i = 0; i < batchCount; ++i) {
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)50, (Object[])params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    FullOrgUnitInfo org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)res.getString("FID")));
                    org.setIsCompanyOrgUnit(res.getBoolean("FIsCompanyOrgUnit"));
                    org.setCU(new CtrlUnitInfo());
                    org.getCU().setId(BOSUuid.read((String)res.getString("FControlUnitID")));
                    if (!StringUtils.isEmpty((String)res.getString("FParentID"))) {
                        org.setParent(new FullOrgUnitInfo());
                        org.getParent().setId(BOSUuid.read((String)res.getString("FParentID")));
                    }
                    if (!org.isIsCompanyOrgUnit() && org.getParent() != null) {
                        newIds.add(org.getParent().getId().toString());
                    }
                    orgInfo.put(org.getId().toString(), org);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        finally {
            SQLUtils.cleanup(res);
        }
        MbgViewListFormServerHelper.queryOrgInfo(pstmt, newIds, orgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchAddNew(Context ctx, Connection conn, List newForms, String bgSchemeId, String bgTemplateId, boolean isUpdateShowTemp, boolean isShowByTemp) throws BOSException, EASBizException {
        if (ctx == null || conn == null || newForms == null || newForms.isEmpty() || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgTemplateId)) {
            return;
        }
        String tempForm = null;
        try {
            tempForm = MbgViewListFormServerHelper.createTempFormTable(ctx, conn);
            MbgViewListFormServerHelper.insertTempFormTable(ctx, conn, tempForm, newForms);
            MbgViewListFormServerHelper.updateTempFormXml(ctx, conn, tempForm, bgSchemeId, bgTemplateId, newForms, isUpdateShowTemp, isShowByTemp);
            MbgViewListFormServerHelper.insertIntoBgFormTable(ctx, conn, tempForm);
            MbgViewListFormServerHelper.saveEditNote(ctx, conn, newForms, bgTemplateId);
            MbgViewListFormServerHelper.saveDesCell(ctx, conn, newForms, bgTemplateId);
            MbgViewListFormServerHelper.saveRelations(ctx, newForms);
        }
        finally {
            if (tempForm != null) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempForm);
            }
        }
    }

    private static void saveRelations(Context ctx, List newForms) throws BOSException, EASBizException {
        BgFormInfo newForm = null;
        try {
            HashMap<String, List<MbgRelationMap>> relationMaps = new HashMap<String, List<MbgRelationMap>>();
            int in = newForms.size();
            for (int i = 0; i < in; ++i) {
                byte[] bytes;
                MbgViewListManager view;
                newForm = (BgFormInfo)newForms.get(i);
                CoreBaseCollection col = BgFormEntryFactory.getLocalInstance(ctx).getCollection("select dimensionData, dimensionStyle where bgForm.id = '" + newForm.getId() + "'");
                if (col == null || col.isEmpty() || (view = new MbgViewListXMLParser(true).parse(bytes = ((BgFormEntryInfo)col.get(0)).getDimensionData())) == null) continue;
                List<MbgRelationMap> relationMap = MbgViewListFormServerHelper.getRelationMaps(view);
                relationMaps.put(newForm.getId().toString(), relationMap);
            }
            if (!relationMaps.isEmpty()) {
                BgViewServerHelper.saveRelationByInfo(ctx, relationMaps);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void saveDesCell(Context ctx, Connection conn, List<CoreBaseInfo> newForms, String bgTemplateId) throws BOSException {
        if (newForms == null || newForms.isEmpty()) {
            return;
        }
        ArrayList<String> newFormIds = new ArrayList<String>();
        int in = newForms.size();
        for (int i = 0; i < in; ++i) {
            newFormIds.add(newForms.get(i).getId().toString());
        }
        MbgViewListFormServerHelper.saveDesCellByIds(ctx, conn, newFormIds, bgTemplateId);
    }

    public static void saveDesCellByIds(Context ctx, Connection conn, List<String> newFormIds, String bgTemplateId) throws BOSException {
        if (newFormIds == null || newFormIds.isEmpty()) {
            return;
        }
        ArrayList<MbgUpdateDataBaseCopyInfo> copyInfos = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        String cellBosType = new MbgViewListDesCellInfo().getBOSType().toString();
        MbgUpdateDataBaseCopyInfo copyInfo = null;
        String formId = null;
        int in = newFormIds.size();
        for (int i = 0; i < in; ++i) {
            formId = newFormIds.get(i);
            copyInfo = new MbgUpdateDataBaseCopyInfo();
            copyInfos.add(copyInfo);
            copyInfo.setWhere("FID IN(Select FViewListDesId FROM T_MBG_MbgViewListDesCellEntry Where FBgFormId = ?)");
            copyInfo.addWhereParam(bgTemplateId);
            copyInfo.addReplace("FID", "newbosid('" + cellBosType + "')");
            copyInfo.addReplaceVar("FActualPeriodId", formId);
            copyInfo.addReplace("FIsFromTemplate", "1");
        }
        try {
            MbgUpdateDataBaseCopyHelper.copyDataBase(conn, "T_MBG_MbgViewListDesCell", copyInfos);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into T_MBG_MbgViewListDesCellEntry(FID, FViewListDesId, FBgFormId) Select newbosid('" + new MbgViewListDesCellEntryInfo().getBOSType() + "'), FID, FActualPeriodId FROM T_MBG_MbgViewListDesCell Where FActualPeriodId = ?"), newFormIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_MbgViewListDesCell Set FActualPeriodId = NULL Where FActualPeriodId = ?", newFormIds);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveEditNote(Context ctx, Connection conn, List newForms, String bgTemplateId) throws BOSException {
        if (conn == null || bgTemplateId == null) {
            return;
        }
        HashMap<Integer, String> editNote = new HashMap<Integer, String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String value = null;
        int sheetIndex = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FSheetIndex, FValue from T_MBG_MbgViewListEditNote where FBgTemplateID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgTemplateId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                sheetIndex = rst.getInt("FSheetIndex");
                value = rst.getString("FValue");
                editNote.put(sheetIndex, value);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        CoreBaseInfo newForm = null;
        String formId = null;
        try {
            int in = newForms.size();
            for (int i = 0; i < in; ++i) {
                newForm = (CoreBaseInfo)newForms.get(i);
                formId = newForm.getId().toString();
                BgDBUtils.executeUpdate((Connection)conn, (String)"Delete from T_MBG_MbgViewListEditNote where fBgFormId = ?", (Object[])new Object[]{formId});
                if (editNote.isEmpty()) continue;
                BOSObjectType bosType = new MbgViewListEditNoteInfo().getBOSType();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                Map.Entry entry2 = null;
                for (Map.Entry entry2 : editNote.entrySet()) {
                    paramList.add(new Object[]{BOSUuid.create((BOSObjectType)bosType).toString(), formId, entry2.getKey(), entry2.getValue()});
                }
                BgDBUtils.executeBatch((Connection)conn, (String)"Insert into T_MBG_MbgViewListEditNote(FID, FBgFormID, FSheetIndex, FValue) values (?, ?, ?, ?)", paramList);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private static String createTempFormTable(Context ctx, Connection conn) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String sql = "Create Table T_MBg_BgFormTemp (FID VARCHAR(44) ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName NVARCHAR(80),FNumber NVARCHAR(80),FDescription NVARCHAR(2000),FYear INT,FPeriod INT,FStartDate DateTime,FEndDate DateTime,FAuditorID VARCHAR(44),FTemplateID VARCHAR(44),FCompanyID VARCHAR(44),FPeriodType INT,FPublicStatus INT,FPublishedStatus INT,FCommittedStatus INT,FHandleStatus INT,FSourceType INT,FOrgTreeID VARCHAR(44),FCurrencyID VARCHAR(44),FAuditedTime DateTime,FAuditedStatus INT,FCheckedStatus INT,FData BLOB(10485760),FAdjustMapData BLOB(1048576),FDataSource INT,FState INT,FProcessType INT DEFAULT 1,FBgSchemeID VARCHAR(44),FBgTemplateID VARCHAR(44),FBgPeriodID VARCHAR(44), FBgVersionId VARCHAR(44), FOrgUnitID VARCHAR(44),FBgTypeID VARCHAR(44),FMeasureUnitID VARCHAR(44),FVersionNo NUMERIC(21,8) ,FAdjustID VARCHAR(44),FTemplateLastUpdateTime DateTime NOT NULL ,FXNum VARCHAR(100) ,FIsChangeType INT ,FCourseOrgId VARCHAR(44),FCourseUserId VARCHAR(44),FCourseTime DateTime,FCertificateUserId VARCHAR(44),FCertificateTime DateTime,FBackUserId VARCHAR(44),FBackTime DateTime,FStateBeforeAudit INT,FBgItemGroupID VARCHAR(44),FRecord INT ,FBgItemID VARCHAR(44), FEntryID varchar(44), FDimensionData BLOB(10485760),FBgRollRuleId VARCHAR(44))";
        try {
            return pool.createTempTable(sql);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private static void insertTempFormTable(Context ctx, Connection conn, String tempForm, List newForms) throws BOSException, EASBizException {
        if (ctx == null || conn == null || tempForm == null || newForms == null || newForms.isEmpty()) {
            return;
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        BOSObjectType bosType = new BgFormEntryInfo().getBOSType();
        int batchCount = 100;
        PreparedStatement pstmt = null;
        Object[] fs = MbgViewListFormServerHelper.getInsertFormFields();
        StringBuffer sql = new StringBuffer("INSERT INTO ").append(tempForm).append("(");
        BgViewHelper.convertArray(fs, sql);
        sql.append(", FEntryId) values (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)(fs.length + 1)).append(")");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int index = 0;
            for (int i = 0; i < newForms.size(); ++i) {
                BgFormInfo newForm = (BgFormInfo)newForms.get(i);
                pstmt.setString(1, newForm.getId().toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, now);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, now);
                pstmt.setString(6, newForm.getCU().getId().toString());
                pstmt.setString(7, newForm.getName());
                pstmt.setString(8, newForm.getNumber());
                pstmt.setString(9, newForm.getDescription());
                pstmt.setInt(10, newForm.getYear());
                pstmt.setInt(11, newForm.getPeriod());
                pstmt.setDate(12, new java.sql.Date(newForm.getBgPeriod().getBeginDate().getTime()));
                pstmt.setDate(13, new java.sql.Date(newForm.getBgPeriod().getEndDate().getTime()));
                pstmt.setString(14, newForm.getCompany().getId().toString());
                if (newForm.getPeriodType() != null) {
                    pstmt.setInt(15, newForm.getPeriodType().getValue());
                } else {
                    pstmt.setInt(15, newForm.getBgPeriod().getPeriodType().getValue());
                }
                pstmt.setInt(16, newForm.getSourceType().getValue());
                pstmt.setString(17, newForm.getCurrency().getId().toString());
                pstmt.setInt(18, 1);
                pstmt.setInt(19, 1);
                pstmt.setBytes(20, newForm.getBgTemplate().getData());
                pstmt.setInt(21, 0);
                pstmt.setInt(22, 1);
                pstmt.setString(23, newForm.getBgScheme().getId().toString());
                pstmt.setString(24, newForm.getBgTemplate().getId().toString());
                pstmt.setString(25, newForm.getBgPeriod().getId().toString());
                pstmt.setString(26, newForm.getBgVersion().getId().toString());
                pstmt.setString(27, newForm.getOrgUnit().getId().toString());
                if (newForm.getBgType() == null) {
                    pstmt.setString(28, null);
                } else {
                    pstmt.setString(28, newForm.getBgType().getId().toString());
                }
                if (newForm.getMeasureUnit() != null && newForm.getMeasureUnit().getId() != null) {
                    pstmt.setString(29, newForm.getMeasureUnit().getId().toString());
                } else {
                    pstmt.setString(29, null);
                }
                pstmt.setBigDecimal(30, BgNConstants.ONE);
                pstmt.setString(31, newForm.getId().toString());
                if (newForm.getTemplateLastUpdateTime() == null) {
                    pstmt.setTimestamp(32, now);
                } else {
                    pstmt.setTimestamp(32, newForm.getTemplateLastUpdateTime());
                }
                pstmt.setString(33, "");
                pstmt.setBoolean(34, false);
                pstmt.setInt(35, 1);
                pstmt.setInt(36, 0);
                pstmt.setInt(37, newForm.getProcessType().getValue());
                if (newForm.getBgRollRule() != null && newForm.getBgRollRule().getId() != null) {
                    pstmt.setString(38, newForm.getBgRollRule().getId().toString());
                } else {
                    pstmt.setString(38, null);
                }
                pstmt.setString(39, BOSUuid.create((BOSObjectType)bosType).toString());
                pstmt.addBatch();
                if (++index <= 100) continue;
                pstmt.executeBatch();
                index = 0;
            }
            if (index > 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private static void insertIntoBgFormTable(Context ctx, Connection conn, String tempForm) throws BOSException {
        if (conn == null || StringUtils.isEmpty((String)tempForm)) {
            return;
        }
        Object[] fs = MbgViewListFormServerHelper.getInsertFormFields();
        StringBuffer sql = new StringBuffer("Insert into T_MBg_BgForm (");
        BgViewHelper.convertArray(fs, sql);
        sql.append(") select ");
        BgViewHelper.convertArray(fs, sql);
        sql.append(" from ").append(tempForm).append(" t0");
        sql.append(" Where not exists (");
        sql.append("Select FID FROM T_MBG_BgForm  t1 Where t1.FBgSchemeId = t0.FBgSchemeId AND t0.FOrgUnitId = t1.FOrgUnitId AND t0.FBgTemplateId = t1.FBgTemplateId AND t0.FBgPeriodId = t1.FBgPeriodId AND t0.FCurrencyId = t1.FCurrencyId AND t0.FBgVersionId = t1.FBgVersionId AND t0.FProcessType = t1.FProcessType)");
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
            SQLUtils.execute((Connection)conn, (String)("Insert into T_MBg_BgFormEntry (FID, FBgFormID, FDimensionData)Select FEntryId, FID, FDimensionData From " + tempForm));
            SQLUtils.execute((Connection)conn, (String)("Insert into T_MBg_BgMeasureUnit(FID, FBgFormID, FBgElementID, FBgMeasureUnitID) select newbosid('BDC0C39C'), bgForm.FID, tempM.FBgElementID, tempM.FMeasureUnitID from " + tempForm + " bgForm, T_MBg_BgTemMeasureUnit tempM where bgForm.FBgTemplateId = tempM.FBgTemplateId"));
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkBgPeriodIsAcross(Context ctx, String bgSchemeId, IMbgViewBase viewManager1, IDimDataQuery bgForm) throws BOSException, EASBizException {
        Map bgPeriodMap;
        BgFormInfo info;
        BgRollRuleInfo bgRollRule;
        HashMap<IBgDimensionManagerBase, IDimDataQuery> p = new HashMap<IBgDimensionManagerBase, IDimDataQuery>();
        if (viewManager1 == null) {
            return;
        }
        for (int s = 0; s < viewManager1.getSheetManagers().size(); ++s) {
            p.put(viewManager1.getSheetManagers().get(s).getDimensionManager(), bgForm);
        }
        BgSchemeInfo bgScheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select dateFrom, dateTo where id = '" + bgSchemeId + "'");
        BgRollPartEnum rollPart = null;
        if (bgForm instanceof BgFormInfo && (bgRollRule = (info = (BgFormInfo)bgForm).getBgTemplate().getBgRollRule()) != null) {
            rollPart = bgRollRule.getRollPart();
        }
        if ((bgPeriodMap = BgViewServerHelper.queryMbgViewListBgPeriod(ctx, p, true, null, rollPart)) != null) {
            Date sBegin = BgNPeriodHelper.getDayBegin((Date)bgScheme.getDateFrom());
            Date sEnd = BgNPeriodHelper.getDayEnd((Date)bgScheme.getDateTo());
            Date pBegin = null;
            Date pEnd = null;
            for (BgPeriodInfo bgPeriod : bgPeriodMap.values()) {
                if (bgPeriod.getBeginDate() == null || BgNPeriodHelper.isAcross((Date)sBegin, (Date)sEnd, (Date)(pBegin = BgNPeriodHelper.getDayBegin((Date)bgPeriod.getBeginDate())), (Date)(pEnd = BgNPeriodHelper.getDayEnd((Date)bgPeriod.getEndDate())))) continue;
                throw new DimensionException(DimensionException.PERIODMEMBERNOFOUND, new Object[]{bgPeriod.getNumber()});
            }
        }
    }

    private static void updateTempFormXml(Context ctx, Connection conn, String tempForm, String bgSchemeId, String bgTemplateId, List newForms, boolean isUpdateShowTemp, boolean isShowByTemp) throws BOSException {
        byte[] bytes;
        MbgViewListXMLParser parse;
        MbgViewListManager viewManager;
        IRowSet rst;
        block10: {
            if (conn == null || StringUtils.isEmpty((String)tempForm) || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)bgTemplateId)) {
                return;
            }
            rst = null;
            viewManager = null;
            parse = null;
            bytes = null;
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select templateD.FData from  T_MBg_bgviewDimension templateD where templateD.FTemplateId = '" + bgTemplateId + "'"));
            while (rst.next()) {
                bytes = BgDBUtils.getBytes((ResultSet)rst, (String)"FData");
            }
            if (bytes != null) break block10;
            SQLUtils.cleanup((ResultSet)rst);
            return;
        }
        try {
            parse = new MbgViewListXMLParser(ctx);
            viewManager = parse.parse(bytes);
            MbgViewListManager viewManager1 = parse.parse(bytes);
            BgFormInfo bgForm = (BgFormInfo)newForms.get(0);
            MbgViewListFormServerHelper.checkBgPeriodIsAcross(ctx, bgSchemeId, viewManager1, bgForm);
            BgFormInfo bgForm2 = null;
            for (int f = 0; f < newForms.size(); ++f) {
                MbgViewListManager cloneViewManager = DimensionCommonHelper.cloneViewManager(viewManager);
                bgForm2 = (BgFormInfo)newForms.get(f);
                MbgViewListFormServerHelper.addDefDimMembers(cloneViewManager, bgForm2, isUpdateShowTemp, isShowByTemp);
                MbgViewListFormServerHelper.addSelecteCombinMembers(cloneViewManager, bgForm2.getOrgUnit());
                BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
                ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, schemeHelper, bgForm2.getOrgUnit().getId().toString());
                helper.parseMember(cloneViewManager);
                MbgViewListFormServerHelper.verifyPeriodVariable(cloneViewManager, bgForm2);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                if (MbgViewListFormServerHelper.getRelationMaps(viewManager).isEmpty()) {
                    paramList.add(new Object[]{parse.unParse(cloneViewManager), bgForm2.getId().toString()});
                    BgDBUtils.executeBatch((Connection)conn, (String)("update " + tempForm + " set FDimensionData = ? Where FID = ?"), paramList);
                    continue;
                }
                DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
                MbgViewListFormServerHelper.convertRelationMap(ctx, cloneViewManager, bgForm2.getOrgUnit().getId().toString(), cacheHelper);
                paramList.add(new Object[]{parse.unParse(cloneViewManager), bgForm2.getId().toString()});
                BgDBUtils.executeBatch((Connection)conn, (String)("update " + tempForm + " set FDimensionData = ? Where FID = ?"), paramList);
            }
            if (!(viewManager == null || BgHideItemEnum.UNHIDE.equals((Object)viewManager.getColHide()) && BgHideItemEnum.UNHIDE.equals((Object)viewManager.getRowHide()))) {
                StringBuffer sql = new StringBuffer("Insert into T_MBG_BgViewHideSetting (FID,FUserID,FBgFormID,FRowHideItem,FColHideItem");
                sql.append(") select newbosid('87BCAF86'), ?, FID, ?, ?");
                sql.append(" from ").append(tempForm).append(" t0");
                sql.append(" Where not exists (");
                sql.append("Select FID FROM T_MBG_BgForm  t1 Where t1.FBgSchemeId = t0.FBgSchemeId AND t0.FOrgUnitId = t1.FOrgUnitId AND t0.FBgTemplateId = t1.FBgTemplateId AND t0.FBgPeriodId = t1.FBgPeriodId AND t0.FCurrencyId = t1.FCurrencyId AND t0.FBgVersionId = t1.FBgVersionId)");
                MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (Object)new Object[]{ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), viewManager.getRowHide().getValue(), viewManager.getColHide().getValue()});
            }
        }
        catch (Exception e1) {
            try {
                logger.error((Object)"", (Throwable)e1);
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    private static void addSelecteCombinMembers(MbgViewListManager viewManager, FullOrgUnitInfo orgUnit) {
        List<IMbgViewListObject> rowCols = null;
        MbgViewListRowCol rowCol = null;
        BgDimensionBaseInfo orgDim = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            rowCols = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRows();
            for (int r = 0; r < rowCols.size(); ++r) {
                if (!(rowCols.get(r) instanceof MbgViewListRowCol)) continue;
                rowCol = (MbgViewListRowCol)rowCols.get(r);
                orgDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, rowCol.getDimensions());
                if (!rowCol.isCombin() || rowCol.getCombinSelectMembers().isEmpty()) continue;
                rowCol.getCombinMembers().clear();
                if (orgDim == null) {
                    rowCol.getCombinMembers().addAll(rowCol.getCombinSelectMembers());
                    continue;
                }
                List<Object[]> members = DimensionCommonHelper.getDimMembersByCombinMembers(rowCol);
                if (members.isEmpty()) continue;
                int orgIndex = rowCol.getDimensions().indexOf(orgDim);
                for (Object[] objs : members) {
                    if (objs[orgIndex] == null) {
                        MbgViewListDimensionMember member = new MbgViewListDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, orgUnit.getId().toString(), orgUnit.getName(), orgUnit.getNumber());
                        member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                        objs[orgIndex] = member;
                    }
                    BgDimensionMember[] ms = new BgDimensionMember[objs.length];
                    for (int i = 0; i < ms.length; ++i) {
                        ms[i] = (BgDimensionMember)objs[i];
                    }
                    rowCol.getCombinMembers().add(DimensionCommonHelper.getCombinMemberByDimMember(ms));
                }
            }
        }
    }

    public static void convertRelationMap(Context ctx, MbgViewListManager cloneViewManager, String orgUnitId, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        int r;
        List<MbgRelationMap> relationMaps = MbgViewListFormServerHelper.getRelationMaps(cloneViewManager);
        if (relationMaps == null || relationMaps.isEmpty()) {
            return;
        }
        MbgRelationMap relationMap = null;
        String groupId = null;
        CoreBaseCollection relationCol = null;
        HashMap<String, CoreBaseCollection> relations = new HashMap<String, CoreBaseCollection>();
        HashMap hasRelations = new HashMap();
        boolean isCsl = false;
        for (r = 0; r < relationMaps.size(); ++r) {
            relationMap = relationMaps.get(r);
            groupId = relationMap.getGroup().getId().toString();
            boolean bl = isCsl = cacheHelper.getRelationGroup(groupId) == null ? false : cacheHelper.getRelationGroup(groupId).isIsCsl();
            if (relationMap.getRelationShips().isEmpty() && !relationMap.isFillWhereNull() || relations.containsKey(groupId) || cacheHelper.getRelationGroup(groupId) == null) continue;
            relationCol = DimensionMemberRelationShipHelper.queryAllRelationByGroupId(ctx, cacheHelper.getRelationGroup(groupId), cacheHelper.getOrgUnitById(orgUnitId, isCsl));
            relations.put(groupId, relationCol);
            hasRelations.put(groupId, new HashSet());
            if (relationCol == null) continue;
            for (int i = 0; i < relationCol.size(); ++i) {
                ((Set)hasRelations.get(groupId)).add(((DimensionRelationshipInfo)relationCol.get(i)).getDimensionNumber());
            }
        }
        for (r = 0; r < relationMaps.size(); ++r) {
            relationMap = relationMaps.get(r);
            groupId = relationMap.getGroup().getId().toString();
            if (relationMap.getRelationShips().isEmpty()) {
                if (!relationMap.isFillWhereNull()) continue;
                relationMap.getRelationShips().addObjectCollection((IObjectCollection)relations.get(groupId));
                continue;
            }
            for (int s = relationMap.getRelationShips().size() - 1; s >= 0; --s) {
                if (hasRelations.containsKey(groupId) && ((Set)hasRelations.get(groupId)).contains(relationMap.getRelationShips().get(s).getDimensionNumber())) continue;
                relationMap.getRelationShips().removeObject(s);
            }
        }
    }

    private static void verifyPeriodVariable(MbgViewListManager viewManager, List newForms) throws BOSException, EASBizException {
        for (int p = 0; p < newForms.size(); ++p) {
            MbgViewListFormServerHelper.verifyPeriodVariable(viewManager, (IDimDataQuery)newForms.get(p));
        }
    }

    private static void verifyPeriodVariable(MbgViewListManager viewManager, IDimDataQuery form) throws BOSException, EASBizException {
        BgPeriodInfo bgPeriodInfo = form.getBizPeriod();
        BgFormInfo info = (BgFormInfo)form;
        if (viewManager == null || bgPeriodInfo == null) {
            return;
        }
        BgDimensionBaseInfo periodDim = null;
        List<MbgViewListDimensionInfo> memberList = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            memberList = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getAllDimensions();
            for (int k = 0; k < memberList.size(); ++k) {
                if (!"BG_Period".equals(memberList.get(k).getNumber())) continue;
                periodDim = memberList.get(k);
            }
            if (periodDim == null) continue;
            for (int i = 0; i < periodDim.getMember().size(); ++i) {
                BgDimensionMember member = (BgDimensionMember)periodDim.getMember().get(i);
                BgRollRuleInfo bgRollRule = info.getBgTemplate().getBgRollRule();
                BgRollPartEnum rollPart = null;
                if (bgRollRule != null) {
                    rollPart = bgRollRule.getRollPart();
                }
                String targetPeriodNumber = bgPeriodInfo.getNumber();
                int targetPeriodType = bgPeriodInfo.getPeriodType().getValue();
                if (BgRollPartEnum.month_quarterRoll.equals((Object)rollPart)) {
                    targetPeriodNumber = BgFormHelper.getFirstMontPeriod(targetPeriodNumber, rollPart);
                    targetPeriodType = 4;
                }
                BgPeriodNVariableHelper.getBgPeriodByN((String)targetPeriodNumber, (String)member.getNumber(), (int)targetPeriodType);
            }
        }
    }

    public static List<MbgRelationMap> getRelationMaps(MbgViewListManager viewManager) {
        ArrayList<MbgRelationMap> relationMaps = new ArrayList<MbgRelationMap>();
        MbgViewListDimensionManager dimManager = null;
        List<IMbgViewListObject> rowCols = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            dimManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            MbgViewListFormServerHelper.addRelationMap(dimManager.getPageRelationMaps(), relationMaps);
            rowCols = dimManager.getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                MbgViewListFormServerHelper.addRelationMap(((MbgViewListRowCol)rowCols.get(i)).getRelationMaps(), relationMaps);
            }
        }
        return relationMaps;
    }

    private static void addRelationMap(List<MbgRelationMap> sourceRelationMaps, List<MbgRelationMap> targetRelationMaps) {
        if (sourceRelationMaps == null) {
            return;
        }
        for (int r = 0; r < sourceRelationMaps.size(); ++r) {
            targetRelationMaps.add(sourceRelationMaps.get(r));
        }
    }

    private static Set checkNumber(Context ctx, Connection conn, String oneField, String oneValue, String batchField, Set batchValues, boolean isException, String bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)oneValue) || StringUtils.isEmpty((String)oneValue) || StringUtils.isEmpty((String)batchField) || batchValues == null || batchValues.isEmpty()) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        boolean closeConn = false;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            if (conn == null) {
                closeConn = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select ").append(isException ? " top 1" : "").append(batchField).append(" from T_MBg_bgform where ").append(" FBgSchemeID = '" + bgSchemeId + "' and ").append(oneField).append(" = ? and ").append(batchField).append(" in(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = batchValues.toArray();
            int batchCount = (params.length - 1) / 50 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, oneValue);
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)2, (int)i, (int)50, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!isException) {
                        res.add(rst.getString(1));
                        continue;
                    }
                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"existNumber", (Locale)ctx.getLocale())});
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                if (closeConn) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        if (closeConn) {
            SQLUtils.cleanup((Connection)conn);
        }
        return res;
    }

    private static String[] getInsertFormFields() {
        return new String[]{"FID", "FCreatorID", "FCreateTime", "FLastUpdateUserID", "FLastUpdateTime", "FControlUnitID", "FName", "FNumber", "FDescription", "FYear", "FPeriod", "FStartDate", "FEndDate", "FCompanyID", "FPeriodType", "FSourceType", "FCurrencyID", "FAuditedStatus", "FCheckedStatus", "FData", "FDataSource", "FState", "FBgSchemeID", "FBgTemplateID", "FBgPeriodID", "FBgVersionId", "FOrgUnitID", "FBgTypeID", "FMeasureUnitID", "FVersionNo", "FAdjustID", "FTemplateLastUpdateTime", "FXNum", "FIsChangeType", "FStateBeforeAudit", "FRecord", "FProcessType", "FBgRollRuleId"};
    }

    public static Map queryBgFormByOrgUnitId(Context ctx, BgFormInfo bgFormInfo, Object[] orgIds) throws BOSException {
        if (bgFormInfo == null || orgIds == null || orgIds.length == 0) {
            return null;
        }
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = MbgViewListFormServerHelper.getQuerySQL(ctx);
            sql.append(" and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId =?");
            sql.append(" where bgForm.FState <> ? and bgScheme.FId = ? ");
            sql.append(" and bgTemplate.FRootID = ? ");
            sql.append(" and bgForm.FProcessType = ? ");
            sql.append(" and bgForm.FOrgUnitId in (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            int batchCount = (orgIds.length - 1) / 50 + 1;
            for (int i = 0; i < batchCount; ++i) {
                pstmt.setString(1, bgFormInfo.getBgPeriod().getId().toString());
                pstmt.setString(2, bgFormInfo.getCurrency().getId().toString());
                pstmt.setInt(3, 15);
                pstmt.setString(4, bgFormInfo.getBgScheme().getId().toString());
                pstmt.setString(5, bgFormInfo.getBgTemplate().getRootId().toString());
                pstmt.setInt(6, bgFormInfo.getProcessType().getValue());
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)7, (int)i, (int)50, (Object[])orgIds);
                res = pstmt.executeQuery();
                while (res.next()) {
                    BgFormInfo b = MbgViewListFormServerHelper.buildBgFormInfo(res);
                    bgFormMap.put(b.getOrgUnit().getId().toString(), b);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    public static String getBgDataFilterByBgFormId() {
        return "Fid in(Select FBgDataId From T_MBg_BgDataEntry Where FBgFormId = ?)";
    }

    public static String getBgDataFilterByBgFormId(String dataEntryTableName) {
        return "Fid in(Select FBgDataId From " + dataEntryTableName + " Where FBgFormId = ?)";
    }

    public static void removeStateLock(ReportBaseInfo reportInfo) {
        try {
            Range unLock = null;
            Book _book = reportInfo.getBook();
            BgNFSHelper.disableCal(_book);
            BgNFSHelper.disableUndo(_book);
            if (_book != null) {
                int _sheetSize = _book.getSheetCount();
                for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                    Sheet _sheet = _book.getSheet(_sheetIndex);
                    int rowCount = _sheet.getMaxRowIndex();
                    int colCount = _sheet.getMaxColIndex();
                    for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                            Cell _cell = _sheet.getCell(rowIndex, colIndex, false);
                            if (_cell == null || BgNFSHelper.getCellData(_cell, "BGDATA_STATE_LOCK") == null) continue;
                            BgNFSHelper.removeCellData(_cell, "BGDATA_STATE_LOCK");
                            BgNFSHelper.removeCellData(_cell, "BGDATA_CAN_UPDATE");
                            if (unLock == null) {
                                unLock = _sheet.getRange(_cell);
                                continue;
                            }
                            unLock.addAll((SortedCellBlockArray)_sheet.getRange(_cell));
                        }
                    }
                }
            }
            if (unLock != null) {
                StyleAttributes sa = Styles.getEmptySA();
                sa.setLocked(false);
                unLock.setIgnoreProtected(true);
                unLock.setStyle(sa, Styles.getEmptySA());
                reportInfo.setBook(_book);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, String key) throws SQLException, IOException {
        if (rst == null || StringUtils.isEmpty((String)key)) {
            return null;
        }
        InputStream in = rst.getBinaryStream(key);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(ResultSet rst, int index) throws SQLException, IOException {
        if (rst == null) {
            return null;
        }
        InputStream in = rst.getBinaryStream(index);
        if (in == null) {
            return null;
        }
        int len = -1;
        int blockSize = 1024;
        byte[] block = new byte[1024];
        byte[] bytes = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            do {
                if ((len = in.read(block)) <= 0) continue;
                byteOut.write(block, 0, len);
            } while (len == 1024);
            bytes = byteOut.toByteArray();
        }
        finally {
            in.close();
            byteOut.close();
        }
        return bytes;
    }

    public static void setBytes(PreparedStatement stat, int index, byte[] bytes) throws SQLException {
        if (stat == null) {
            return;
        }
        if (bytes != null && bytes.length > 0) {
            stat.setBinaryStream(index, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
        } else {
            stat.setBytes(index, null);
        }
    }

    public static BgTemplateInfo getBgTemplateInfo(Connection conn, String bgTemplateId, boolean loadData) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        return MbgViewListFormServerHelper.getBgTemplateInfo(conn, BOSUuid.read((String)bgTemplateId), loadData);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgTemplateInfo getBgTemplateInfo(Connection conn, BOSUuid bgTemplateId, boolean loadData) throws EASBizException {
        if (conn == null) return null;
        if (bgTemplateId == null) {
            return null;
        }
        BgTemplateInfo bgTemplateInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tmp = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID, FNumber, FName, FLastUpdateTime, FOrgUnitID, " + (loadData ? " FData, " : "") + " FDefaultMeasureUnitID, FParentID, FRootId, FFormType From T_MBG_BgTemplate where FID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgTemplateId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setLastUpdateTime(rst.getTimestamp("FLastUpdateTime"));
                _tmp = rst.getString("FOrgUnitID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgTemplateInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgTemplateInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (loadData) {
                    bgTemplateInfo.setZipData(MbgViewListFormServerHelper.getBytes(rst, "FData"));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FDefaultMeasureUnitID")))) {
                    bgTemplateInfo.setDefaultMeasureUnit(new MeasureUnitInfo());
                    bgTemplateInfo.getDefaultMeasureUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FParentID")))) {
                    bgTemplateInfo.setParent(new BgTemplateInfo());
                    bgTemplateInfo.getParent().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FRootId")))) {
                    bgTemplateInfo.setRootId(BOSUuid.read((String)_tmp));
                }
                bgTemplateInfo.setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (IOException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateInfo;
    }

    public static BgFormInfo getBgFormInfo(Context ctx, BOSUuid bgFormId, boolean loadData) throws EASBizException, BOSException {
        SelectorItemCollection sic = MbgViewListFormServerHelper.getSelectors();
        if (loadData) {
            sic.add("data");
        }
        sic.add("isRolled");
        return (BgFormInfo)BgFormFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgFormId), sic);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BgFormInfo getBgFormInfo(Connection conn, BOSUuid bgFormId, boolean loadData) throws EASBizException {
        if (conn == null) return null;
        if (bgFormId == null) {
            return null;
        }
        BgFormInfo bgFormInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _tmp = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select bgForm.FID, bgForm.FNumber, bgForm.FName, bgForm.FControlUnitID, bgForm.FOrgUnitID, bgForm.FCompanyID, bgForm.FBgSchemeID, bgForm.FBgTemplateId, bgForm.FTemplateLastUpdateTime, " + (loadData ? " bgForm.FData, bgForm.FAdjustMapData, " : "") + " bgForm.FBgPeriodID, bgForm.FCurrencyID, bgForm.FMeasureUnitID, bgForm.FDataSource, bgForm.FState, bgForm.FVersionNo, bgForm.FAdjustID,  bgForm.FCertificateUserId, bgForm.FIsConfirm, bgTemplate.FFormType,bgPeriod.FNumber as pnumber,bgPeriod.FPeriodType as ptype,scheme.FRootID  from T_MBG_BgForm bgForm  join T_MBg_BgTemplate bgTemplate on bgTemplate.FID = bgForm.FBgTemplateID  join T_MBG_BgPeriod bgPeriod on bgPeriod.FID = bgForm.FBgPeriodID join T_MBG_BgScheme scheme on scheme.FID = bgForm.FBgSchemeID where bgForm.FID = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                bgFormInfo.setTemplateLastUpdateTime(rst.getTimestamp("FTemplateLastUpdateTime"));
                _tmp = rst.getString("FControlUnitID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setCU(new CtrlUnitInfo());
                    bgFormInfo.getCU().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FOrgUnitID")))) {
                    bgFormInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCompanyID")))) {
                    bgFormInfo.setCompany(new CompanyOrgUnitInfo());
                    bgFormInfo.getCompany().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgSchemeID")))) {
                    bgFormInfo.setBgScheme(new BgSchemeInfo());
                    bgFormInfo.getBgScheme().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgTemplateId")))) {
                    bgFormInfo.setBgTemplate(new BgTemplateInfo());
                    bgFormInfo.getBgTemplate().setId(BOSUuid.read((String)_tmp));
                    bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("FFormType")));
                }
                if (loadData) {
                    bgFormInfo.setZipData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FData"));
                    bgFormInfo.setAdjustMapData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"FAdjustMapData"));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FBgPeriodID")))) {
                    bgFormInfo.setBgPeriod(new BgPeriodInfo());
                    bgFormInfo.getBgPeriod().setId(BOSUuid.read((String)_tmp));
                    bgFormInfo.getBgPeriod().setNumber(rst.getString("pnumber"));
                    bgFormInfo.getBgPeriod().setPeriodType(BgPeriodEnum.getEnum((int)rst.getInt("ptype")));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCurrencyID")))) {
                    bgFormInfo.setCurrency(new CurrencyInfo());
                    bgFormInfo.getCurrency().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FMeasureUnitID")))) {
                    bgFormInfo.setMeasureUnit(new MeasureUnitInfo());
                    bgFormInfo.getMeasureUnit().setId(BOSUuid.read((String)_tmp));
                }
                bgFormInfo.setDataSource(BgFormDataSourceEnum.getEnum(rst.getInt("FDataSource")));
                bgFormInfo.setState(BgFormStateEnum.getEnum(rst.getInt("FState")));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
                _tmp = rst.getString("FAdjustID");
                if (!StringUtils.isEmpty((String)_tmp)) {
                    bgFormInfo.setAdjust(new BgFormInfo());
                    bgFormInfo.getAdjust().setId(BOSUuid.read((String)_tmp));
                }
                if (!StringUtils.isEmpty((String)(_tmp = rst.getString("FCertificateUserId")))) {
                    bgFormInfo.setCertificateUserId(_tmp);
                }
                bgFormInfo.setIsConfirm(rst.getBoolean("FIsConfirm"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (IOException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgFormInfo;
    }

    public static BgFormInfo getBgFormVer(Connection conn, String bgFormId) throws EASBizException {
        if (conn == null || StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        BgFormInfo bgFormInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FID, FVersionNo from T_MBG_BgForm where FID = ?");
            pstmt.setString(1, bgFormId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgFormInfo.setVersionNo(rst.getBigDecimal("FVersionNo"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgFormInfo;
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("state");
        sic.add("processType");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("description");
        sic.add("versionNo");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("company.isBizUnit");
        sic.add("company.accountPeriodType.id");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgScheme.refCube");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.bgScenario.id");
        sic.add("bgTemplate.bgScenario.number");
        sic.add("bgTemplate.bgScenario.name");
        sic.add("bgTemplate.bgScenario.scenarioId");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("bgPeriod.beginDate");
        sic.add("bgPeriod.endDate");
        sic.add("bgPeriod.year");
        sic.add("bgPeriod.halfYear");
        sic.add("bgPeriod.quarter");
        sic.add("bgPeriod.month");
        sic.add("bgPeriod.week");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("bgVersion.isRollVersion");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.id");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.sheet.sheetID");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("adjust.id");
        sic.add("adjustMapData");
        sic.add("auditTime");
        sic.add("courseOrgId");
        sic.add("company.id");
        sic.add("company.number");
        sic.add("company.name");
        sic.add("orgTree.id");
        sic.add("orgTree.name");
        sic.add("orgTree.number");
        sic.add("year");
        sic.add("period");
        sic.add("sourceType");
        return sic;
    }

    public static BgSchemeInfo getBgSchemeCubeInfo(Context ctx, BgSchemeInfo model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return null;
        }
        return MbgViewListFormServerHelper.getBgSchemeCubeInfo(ctx, model.getId());
    }

    public static BgSchemeInfo getBgSchemeCubeInfo(Context ctx, String number) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        BgSchemeInfo root = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)"select FID from T_MBG_BgScheme where FNumber = ?", (Object[])new Object[]{number});
            if (rst.next()) {
                root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, BOSUuid.read((String)rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return root;
    }

    public static BgSchemeInfo getBgSchemeCubeInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return null;
        }
        SelectorItemCollection sic = BgCubeUtils.getRefDimSelector();
        return BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), sic);
    }

    public static BgSchemeInfo getBgSchemeInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return null;
        }
        Connection conn = null;
        BgSchemeInfo schemeInfo = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            schemeInfo = MbgViewListFormServerHelper.getBgSchemeInfo(ctx.getLocale(), conn, bgSchemeId);
        }
        catch (SQLDataException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return schemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgSchemeInfo getBgSchemeInfo(Locale locale, Connection conn, BOSUuid bgSchemeId) throws EASBizException {
        IRowSet rst;
        BgSchemeInfo bgSchemeInfo;
        block11: {
            if (conn == null || bgSchemeId == null) {
                return null;
            }
            bgSchemeInfo = null;
            BgDimSettingsInfo setting = null;
            BgDimSettingsMemberInfo member = null;
            HashMap<String, BgDimSettingsInfo> settingMap = new HashMap<String, BgDimSettingsInfo>();
            rst = null;
            IRowSet _rst = null;
            String _tmpStr = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName_" + locale + " AS FName, FOrgUnitID, FIsFormal, FDateFrom, FDateTo, FPeriod, FRefCube From T_MBg_BgScheme where FID = ?");
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString()});
                if (!rst.next()) break block11;
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgSchemeInfo.setNumber(rst.getString("FNumber"));
                bgSchemeInfo.setName(rst.getString("FName"));
                _tmpStr = rst.getString("FOrgUnitID");
                if (!StringUtils.isEmpty((String)_tmpStr)) {
                    bgSchemeInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgSchemeInfo.getOrgUnit().setId(BOSUuid.read((String)_tmpStr));
                }
                bgSchemeInfo.setIsFormal(rst.getBoolean("FIsFormal"));
                bgSchemeInfo.setDateFrom(rst.getDate("FDateFrom"));
                bgSchemeInfo.setDateTo(rst.getDate("FDateTo"));
                bgSchemeInfo.setRefCube(rst.getString("FRefCube"));
                bgSchemeInfo.setPeriod(BgPeriodEnum.getEnum((int)rst.getInt("FPeriod")));
                sql = new StringBuffer();
                sql.append("select t.FID, t.FDimNumber, m.FID AS FMID, m.FMemberID, m.FType from T_MBG_BgDimSettings t join T_MBG_BgDimSettingsMember m on t.FID = m.FBgDimSettingsID where FBgSchemeID = ?");
                try {
                    _rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString()});
                    while (_rst.next()) {
                        _tmpStr = _rst.getString("FID");
                        if (settingMap.containsKey(_tmpStr)) {
                            setting = (BgDimSettingsInfo)settingMap.get(_tmpStr);
                        } else {
                            setting = new BgDimSettingsInfo();
                            setting.setId(BOSUuid.read((String)_tmpStr));
                            setting.setDimNumber(_rst.getString("FDimNumber"));
                            bgSchemeInfo.getBgDimSettings().add(setting);
                            settingMap.put(_tmpStr, setting);
                        }
                        member = new BgDimSettingsMemberInfo();
                        member.setId(BOSUuid.read((String)_rst.getString("FMID")));
                        member.setMemberID(BOSUuid.read((String)_rst.getString("FMemberID")));
                        member.setType(MemberTypeEnum.getEnum(_rst.getInt("FType")));
                        setting.getMembers().add(member);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(_rst);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)_rst);
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgSchemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgPeriodInfo> getBgPeriodMap(Context ctx, List<String> bgPeriodNums) throws BOSException, EASBizException {
        Map<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        if (ctx == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgPeriodMap = MbgViewListFormServerHelper.getBgPeriodMap(conn, bgPeriodNums);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgPeriodMap;
    }

    public static Map<String, BgPeriodInfo> getBgPeriodMap(Connection conn, List<String> bgPeriodNums) throws EASBizException {
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        if (conn == null || bgPeriodNums == null || bgPeriodNums.isEmpty()) {
            return bgPeriodMap;
        }
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        _bgPeriodSet.addAll(bgPeriodNums);
        ArrayList<String> _bgPeriodNums = new ArrayList<String>();
        _bgPeriodNums.addAll(_bgPeriodSet);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = _bgPeriodNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FBgPeriodID, FNumber, FBeginDate, FEndDate from T_MBG_BgPeriodDisp where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        BgPeriodInfo bgPeriodInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgPeriodNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodInfo = new BgPeriodInfo();
                    bgPeriodInfo.setId(BOSUuid.read((String)rst.getString("FBgPeriodID")));
                    bgPeriodInfo.setNumber(rst.getString("FNumber"));
                    bgPeriodInfo.setBeginDate((Date)rst.getDate("FBeginDate"));
                    bgPeriodInfo.setEndDate((Date)rst.getDate("FEndDate"));
                    bgPeriodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgPeriodMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, BgElementInfo> getBgElementMap(Context ctx, List<String> bgElementNums) throws BOSException, EASBizException {
        Map<String, BgElementInfo> bgElementMap = new HashMap<String, BgElementInfo>();
        if (ctx == null || bgElementNums == null || bgElementNums.isEmpty()) {
            return bgElementMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            bgElementMap = MbgViewListFormServerHelper.getBgElementMap(conn, bgElementNums);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgElementMap;
    }

    public static Map<String, BgElementInfo> getBgElementMap(Connection conn, List<String> bgElementNums) throws EASBizException {
        HashMap<String, BgElementInfo> bgElementMap = new HashMap<String, BgElementInfo>();
        if (conn == null || bgElementNums == null || bgElementNums.isEmpty()) {
            return bgElementMap;
        }
        HashSet<String> _bgElementSet = new HashSet<String>();
        _bgElementSet.addAll(bgElementNums);
        ArrayList<String> _bgElementNums = new ArrayList<String>();
        _bgElementNums.addAll(_bgElementSet);
        int batchSize = 50;
        int size = _bgElementNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_MBG_BgElement where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        BgElementInfo bgElementInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_bgElementNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgElementInfo = new BgElementInfo();
                    bgElementInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgElementInfo.setNumber(rst.getString("FNumber"));
                    bgElementMap.put(bgElementInfo.getNumber(), bgElementInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return bgElementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CurrencyInfo> getCurrencyMap(Context ctx, List<String> currencyNums) throws BOSException, EASBizException {
        Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        if (ctx == null || currencyNums == null || currencyNums.isEmpty()) {
            return currencyMap;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            currencyMap = MbgViewListFormServerHelper.getCurrencyMap(conn, currencyNums);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return currencyMap;
    }

    public static Map<String, CurrencyInfo> getCurrencyMap(Connection conn, List<String> currencyNums) throws EASBizException {
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        if (conn == null || currencyNums == null || currencyNums.isEmpty()) {
            return currencyMap;
        }
        HashSet<String> _currencySet = new HashSet<String>();
        _currencySet.addAll(currencyNums);
        ArrayList<String> _currencyNums = new ArrayList<String>();
        _currencyNums.addAll(_currencySet);
        int batchSize = 50;
        int size = _currencyNums.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FNumber from T_BD_Currency where FNumber IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        CurrencyInfo currencyInfo = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)_currencyNums.get(pos));
                    } else {
                        pstmt.setString(x, BgBaseConstants.noFindStr);
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    currencyInfo.setNumber(rst.getString("FNumber"));
                    currencyMap.put(currencyInfo.getNumber(), currencyInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return currencyMap;
    }

    public static CompanyOrgUnitInfo getCompanyFromOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("longnumber");
            sic.add("isBizUnit");
            sic.add("accountTable.id");
            sic.add("accountPeriodType.id");
            sic.add("baseExchangeTable.id");
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), sic);
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return MbgViewListFormServerHelper.getCompanyFromOrgUnit(ctx, parent);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyFromOrgUnit(Context ctx, BOSUuid orgUnitId) throws Exception {
        if (ctx == null || orgUnitId == null) {
            return null;
        }
        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return (CompanyOrgUnitInfo)orgUnitInfo.cast(CompanyOrgUnitInfo.class);
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return MbgViewListFormServerHelper.getCompanyFromOrgUnit(ctx, parent);
        }
        return null;
    }

    public static Map getCurrencyInfo(Context ctx, Map currencysInfo, SelectorItemCollection sic) throws BOSException, EASBizException {
        if (currencysInfo == null) {
            currencysInfo = new HashMap<String, CurrencyInfo>();
        }
        CurrencyInfo currencyInfo = null;
        CurrencyCollection currencyCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (sic == null || sic.isEmpty()) {
            if (sic == null) {
                sic = new SelectorItemCollection();
            }
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("precision");
        }
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ICurrency iCurrency = null;
        try {
            iCurrency = ctx != null ? CurrencyFactory.getLocalInstance((Context)ctx) : CurrencyFactory.getRemoteInstance();
            if (iCurrency == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            currencyCol = iCurrency.getCurrencyCollection(view, true);
            if (currencyCol != null && !currencyCol.isEmpty()) {
                int n = currencyCol.size();
                for (int i = 0; i < n; ++i) {
                    currencyInfo = currencyCol.get(i);
                    currencysInfo.put(currencyInfo.getNumber(), currencyInfo);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return currencysInfo;
    }

    public static BOSUuid getAdjustId(Connection conn, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BOSUuid rebgFormId = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_MBg_BgForm where FAdjustId = ? and FState = ?");
            pstmt.setString(1, bgFormId.toString());
            pstmt.setInt(2, 4);
            rst = pstmt.executeQuery();
            rebgFormId = rst.next() ? BOSUuid.read((String)rst.getString(1)) : bgFormId;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return rebgFormId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getCostCenterOrgUnitIdAndNumber(Context ctx) throws Exception {
        if (ctx == null) {
            return null;
        }
        HashMap<String, String> costCenterMap = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pstmt = conn.prepareStatement("select FID, FNumber from T_ORG_CostCenter");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                costCenterMap.put(rst.getString("FNumber"), rst.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                throw ex;
                catch (SQLDataException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return costCenterMap;
    }

    public static Map queryBgViewOrgUnit(Context ctx, String permNumber, BgFormInfo bgForm, String orgViewId, boolean isAdjust, boolean isOnlyCurrOrg, String currOrgId, boolean isOnlyLeaf) throws BOSException, EASBizException {
        BgDimSettingsMemberCollection col;
        if (bgForm == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)orgViewId) && (col = BgDimSettingsMemberFactory.getLocalInstance(ctx).getBgDimSettingsMemberCollection("select memberId where type = 2 AND bgDimSettings.bgScheme.id = '" + bgForm.getBgScheme().getId() + "'")) != null && !col.isEmpty()) {
            orgViewId = col.get(0).getMemberID().toString();
        }
        BOSUuid orgUnitId = currOrgId != null ? BOSUuid.read((String)currOrgId) : bgForm.getOrgUnit().getId();
        BgOrgUnitInfo currOrg = MbgViewListFormServerHelper.getBgOrgUnit(ctx, BOSUuid.read((String)orgViewId), orgUnitId);
        HashMap<String, Object> orgMap = new HashMap<String, Object>();
        if (currOrg == null) {
            return orgMap;
        }
        if (isOnlyCurrOrg) {
            orgMap.put(currOrg.getId().toString(), currOrg.castToFullOrgUnitInfo());
            return orgMap;
        }
        String sql = "select org.forgunitid, org.fnumber, org.fname_" + ctx.getLocale() + " fname, org.flevel, org.flongnumber \nfrom T_MBg_bgform bgForm \nleft join T_MBg_bgscheme bgScheme on bgScheme.fid = bgForm.fbgschemeid \nleft join T_MBg_bgtemplate bgTemplate on bgTemplate.fid = bgForm.fbgtemplateid \ninner join T_Mbg_BgOrgUnit org on org.forgunitid = bgForm.forgunitid and org.FViewID = ? \nleft join T_MBg_bgformentry entries on entries.fbgformid = bgForm.fid \nwhere bgScheme.FId = ? and bgTemplate.FRootId = ? and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId = ? and bgForm.FBgVersionId = ? ";
        if (isAdjust) {
            sql = sql + " and bgForm.fstate in (2,4,35)";
        }
        if (isOnlyLeaf) {
            sql = sql + " and org.FIsLeaf = 1 ";
        }
        IRowSet rs = null;
        HashMap<String, String> orgNumbers = new HashMap<String, String>();
        HashSet parentNumbers = new HashSet();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgViewId, bgForm.getBgScheme().getId().toString(), bgForm.getBgTemplate().getRootId().toString(), bgForm.getBgPeriod().getId().toString(), bgForm.getCurrency().getId().toString(), bgForm.getBgVersion().getId().toString()});
            while (rs.next()) {
                CostCenterOrgUnitInfo cost = new CostCenterOrgUnitInfo();
                cost.setId(BOSUuid.read((String)rs.getString("forgunitid")));
                cost.setNumber(rs.getString("fnumber"));
                cost.setName(rs.getString("fname"));
                cost.setLevel(rs.getInt("flevel"));
                cost.setLongNumber(rs.getString("flongnumber"));
                orgMap.put(cost.getId().toString(), cost);
                orgNumbers.put(cost.getNumber(), cost.getId().toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        if (orgMap != null && !orgMap.isEmpty()) {
            IObjectPK[] orgPKs = new IObjectPK[orgMap.size()];
            int index = 0;
            Iterator it = orgMap.keySet().iterator();
            while (it.hasNext()) {
                orgPKs[index++] = new ObjectStringPK((String)it.next());
            }
            if (permNumber != null) {
                Set orgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPKs, permNumber);
                HashMap<String, Object> tempMap = orgMap;
                orgMap = new HashMap();
                if (orgIds != null && !orgIds.isEmpty()) {
                    Iterator it2 = orgIds.iterator();
                    while (it2.hasNext()) {
                        String orgId = String.valueOf(it2.next());
                        if (!tempMap.containsKey(orgId)) continue;
                        orgMap.put(orgId, tempMap.get(orgId));
                    }
                }
            }
        }
        return orgMap;
    }

    public static Map<String, BgOrgUnitInfo> queryAcRecordOrgUnit(Context ctx, String permNumber, BgActualRecordInfo acRecord, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        BOSUuid orgUnitId;
        HashMap<String, BgOrgUnitInfo> resMap = new HashMap<String, BgOrgUnitInfo>();
        if (ctx == null || acRecord == null) {
            return resMap;
        }
        BOSUuid bgViewId = MbgViewListFormServerHelper.getBgViewIdBySchemeId(ctx, acRecord.getBgForm().getBgScheme().getId());
        BgOrgUnitInfo ccOrgUnit = MbgViewListFormServerHelper.getBgOrgUnit(ctx, bgViewId, orgUnitId = acRecord.getBgForm().getOrgUnit().getId());
        if (ccOrgUnit == null) {
            return resMap;
        }
        resMap.put(ccOrgUnit.getNumber(), ccOrgUnit);
        if (isOnlyCurrOrg) {
            return resMap;
        }
        BgFormInfo bgFormInfo = acRecord.getBgForm();
        BgSchemeInfo schemeInfo = bgFormInfo.getBgScheme();
        BgTemplateInfo templateInfo = bgFormInfo.getBgTemplate();
        BgPeriodInfo bgPeriodInfo = bgFormInfo.getBgPeriod();
        CurrencyInfo currencyInfo = bgFormInfo.getCurrency();
        BgPeriodInfo actualPeriod = acRecord.getBgPeriod();
        BgVersionInfo versionInfo = bgFormInfo.getBgVersion();
        BgOrgUnitInfo orgUnit = null;
        String bgSchemeId = schemeInfo.getId().toString();
        String rootTemplateId = templateInfo.getRootId().toString();
        String currencyId = currencyInfo.getId().toString();
        String bgPeriodId = bgPeriodInfo.getId().toString();
        String acPeriodId = actualPeriod.getId().toString();
        String bgVersionId = versionInfo.getId().toString();
        String _bgViewId = bgViewId.toString();
        HashSet<String> parentNumbers = new HashSet<String>();
        StringBuffer query = new StringBuffer();
        query.append("select FID, FNumber, FName_" + ctx.getLocale() + " FName, FLevel, FLongNumber, FOrgUnitId  from T_MBG_BgOrgUnit where FViewId = ? and FOrgUnitId in (select f.FOrgUnitId from T_MBG_BgForm f join T_MBG_BgActualRecord ac on f.FID = ac.FBgFormId join T_MBG_BgTemplate t on f.FBgTemplateId = t.FID where t.FrootID  = ? and f.FBgSchemeId = ? and f.FCurrencyID = ? and f.FBgPeriodID = ? and f.FBgVersionId = ? and ac.FBgPeriodID = ?) and FLongNumber Like ?");
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString(), (Object[])new Object[]{_bgViewId, rootTemplateId, bgSchemeId, currencyId, bgPeriodId, bgVersionId, acPeriodId, ccOrgUnit.getLongNumber() + "!%"});
            while (rst.next()) {
                orgUnit = new BgOrgUnitInfo();
                orgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                orgUnit.setNumber(rst.getString("FNumber"));
                orgUnit.setName(rst.getString("FName"));
                orgUnit.setLevel(rst.getInt("FLevel"));
                orgUnit.setLongNumber(rst.getString("FLongNumber"));
                orgUnit.setViewID(_bgViewId);
                orgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                resMap.put(orgUnit.getNumber(), orgUnit);
                String[] lns = orgUnit.getLongNumber().split("!");
                for (int i = 0; i < lns.length - 1; ++i) {
                    parentNumbers.add(lns[i]);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryAcRecordOrgUnit Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        if (isOnlyLeaf) {
            for (String number : parentNumbers) {
                resMap.remove(number);
            }
        }
        if (!resMap.isEmpty() && permNumber != null) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            IObjectPK[] orgPKs = new IObjectPK[resMap.size()];
            int index = 0;
            for (BgOrgUnitInfo _orgUnit : resMap.values()) {
                orgPKs[index++] = new ObjectUuidPK(_orgUnit.getId());
                tmpMap.put(_orgUnit.getOrgUnitID(), _orgUnit.getNumber());
            }
            Set orgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPKs, permNumber);
            if (orgIds != null && !orgIds.isEmpty()) {
                for (String _orgUnitId : orgIds) {
                    if (tmpMap.containsKey(_orgUnitId)) continue;
                    resMap.remove(tmpMap.get(_orgUnitId));
                }
            }
        }
        return resMap;
    }

    public static BOSUuid getBgViewIdBySchemeId(Context ctx, BOSUuid id) {
        try {
            BgSchemeInfo tmpScheme = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select bgDimSettings.id,bgDimSettings.name,bgDimSettings.number,bgDimSettings.dimnumber,bgDimSettings.members.id,bgDimSettings.members.name,bgDimSettings.members.number,bgDimSettings.members.type,bgDimSettings.members.memberID where id = '" + id.toString() + "'");
            return tmpScheme.getEditOrgViewId();
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public static BgOrgUnitInfo getBgOrgUnit(Context ctx, BOSUuid bgOrgViewId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgOrgViewId == null || orgUnitId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longNumber");
        sic.add("viewID");
        sic.add("orgUnitID");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        if (colls != null && !colls.isEmpty()) {
            return colls.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCubeFields(Connection conn, String cubeTable) throws SQLException {
        ArrayList<String> refFields = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("SELECT KSQL_COL_NAME from KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = ?");
            pstmt.setString(1, cubeTable);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String refField = rst.getString(1);
                if (!refField.matches("F[0-9]+") || refFields.contains(refField)) continue;
                refFields.add(refField);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return refFields;
    }

    public static String getBudgetViewID(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        if (bgScheme == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgDimSettings.bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)2, CompareType.EQUALS));
        CoreBaseCollection coll = BgDimSettingsMemberFactory.getLocalInstance(ctx).getCollection(view);
        if (coll != null && coll.size() != 0) {
            return ((BgDimSettingsMemberInfo)coll.get(0)).getMemberID().toString();
        }
        return null;
    }

    public static BgFormCollection getBgForm(Context ctx, BgFormInfo _bgForm, Set curOrgNums, SelectorItemCollection sic, Integer valueType) throws BOSException {
        BgFormCollection bgFormCollection;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        String tempIds = null;
        try {
            BgFormCollection col;
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(sic);
            evi.setFilter(new FilterInfo());
            HashSet<Integer> state = new HashSet<Integer>();
            if (valueType != null && (valueType == 16 || valueType == 32 || valueType == 2048)) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fid from T_MBg_bgform where fid <> fadjustid", CompareType.NOTINNER));
            } else {
                state.add(new Integer(15));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("state", state, CompareType.NOTINCLUDE));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35 , 6 , 101 ) and fid <> fadjustid", CompareType.NOTINNER));
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)_bgForm.getBgScheme().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.root.id", (Object)_bgForm.getBgTemplate().getRootId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)_bgForm.getBgPeriod().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)_bgForm.getCurrency().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)_bgForm.getBgVersion().getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("processType", (Object)_bgForm.getProcessType().getValue()));
            if (curOrgNums.size() > 10) {
                conn = EJBFactory.getConnection((Context)ctx);
                tempIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, (Collection)curOrgNums, (String)"NVarchar(80)");
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)("Select FID FROM " + tempIds), CompareType.INNER));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)curOrgNums, CompareType.INCLUDE));
            }
            bgFormCollection = col = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempIds);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempIds);
        return bgFormCollection;
    }

    public static SelectorItemCollection getFormSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgScheme.number");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.longnumber");
        sic.add("bgPeriod.year");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("bgVersion.id");
        sic.add("bgVersion.number");
        sic.add("bgVersion.name");
        sic.add("bgVersion.versionId");
        sic.add("processType");
        return sic;
    }

    public static BgFormInfo queryBgFormInfo(Context ctx, String bgFormId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.number");
        evi.getSelector().add("orgUnit.longNumber");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.root.id");
        evi.getSelector().add("bgScheme.id");
        evi.getSelector().add("bgPeriod.id");
        evi.getSelector().add("bgPeriod.number");
        evi.getSelector().add("bgPeriod.name");
        evi.getSelector().add("bgPeriod.periodType");
        evi.getSelector().add("bgPeriod.level");
        evi.getSelector().add("bgPeriod.longNumber");
        evi.getSelector().add("currency.id");
        evi.getSelector().add("currency.number");
        evi.getSelector().add("currency.name");
        evi.getSelector().add("state");
        evi.getSelector().add("bgVersion.id");
        evi.getSelector().add("bgVersion.number");
        evi.getSelector().add("bgVersion.name");
        evi.getSelector().add("processType");
        evi.getSelector().add("bgTemplate.bgRollRule.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormId));
        BgFormCollection col = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
        if (col != null && !col.isEmpty()) {
            return col.get(0);
        }
        return null;
    }

    public static void reSaveOldBgVariateMembers(Map<Integer, Map<String, MbgViewListDimensionInfo>> viewPageMap, Map<Integer, Map<Integer, Map<String, MbgViewListDimensionInfo>>> rowColMap, MbgViewListSheetManager sheetManager) {
        int i;
        int index;
        if (viewPageMap == null || rowColMap == null || sheetManager == null) {
            return;
        }
        MbgViewListDimensionInfo dimensionInfo = null;
        MbgViewListRowCol rowColInfo = null;
        MbgViewListDimensionManager dimensionManager = sheetManager.getDimensionManager();
        for (index = 0; index < dimensionManager.getViewDimension().size(); ++index) {
            dimensionInfo = (MbgViewListDimensionInfo)dimensionManager.getViewDimension().get(index);
            if (BgMemberSelectTypeEnum.Variate != dimensionInfo.getMemberType()) continue;
            if (!viewPageMap.containsKey(1)) {
                viewPageMap.put(1, new HashMap());
            }
            viewPageMap.get(1).put(dimensionInfo.getNumber(), dimensionInfo);
        }
        for (index = 0; index < dimensionManager.getPageDimension().size(); ++index) {
            dimensionInfo = (MbgViewListDimensionInfo)dimensionManager.getPageDimension().get(index);
            if (BgMemberSelectTypeEnum.Variate != dimensionInfo.getMemberType()) continue;
            if (!viewPageMap.containsKey(2)) {
                viewPageMap.put(2, new HashMap());
            }
            viewPageMap.get(2).put(dimensionInfo.getNumber(), dimensionInfo);
        }
        for (index = 0; index < dimensionManager.getRows().size(); ++index) {
            if (!(dimensionManager.getRows().get(index) instanceof MbgViewListRowCol)) continue;
            rowColInfo = (MbgViewListRowCol)dimensionManager.getRows().get(index);
            for (i = 0; i < rowColInfo.getDimensions().size(); ++i) {
                dimensionInfo = rowColInfo.getDimensions().get(i);
                if (!(dimensionInfo instanceof MbgViewListDimensionInfo) || BgMemberSelectTypeEnum.Variate != dimensionInfo.getMemberType()) continue;
                if (!rowColMap.containsKey(3)) {
                    rowColMap.put(3, new HashMap());
                }
                if (!rowColMap.get(3).containsKey(rowColInfo.getIndex())) {
                    rowColMap.get(3).put(rowColInfo.getIndex(), new HashMap());
                }
                rowColMap.get(3).get(rowColInfo.getIndex()).put(dimensionInfo.getNumber(), dimensionInfo);
            }
        }
        for (index = 0; index < dimensionManager.getColumns().size(); ++index) {
            if (!(dimensionManager.getColumns().get(index) instanceof MbgViewListRowCol)) continue;
            rowColInfo = (MbgViewListRowCol)dimensionManager.getColumns().get(index);
            for (i = 0; i < rowColInfo.getDimensions().size(); ++i) {
                dimensionInfo = rowColInfo.getDimensions().get(i);
                if (!(dimensionInfo instanceof MbgViewListDimensionInfo) || BgMemberSelectTypeEnum.Variate != dimensionInfo.getMemberType()) continue;
                if (!rowColMap.containsKey(4)) {
                    rowColMap.put(4, new HashMap());
                }
                if (!rowColMap.get(4).containsKey(rowColInfo.getIndex())) {
                    rowColMap.get(4).put(rowColInfo.getIndex(), new HashMap());
                }
                rowColMap.get(4).get(rowColInfo.getIndex()).put(dimensionInfo.getNumber(), dimensionInfo);
            }
        }
    }

    public static void reFillBgVariateMembers(MbgViewListSheetManager oldSheetManager, MbgViewListSheetManager newSheetManager) {
        HashMap<Integer, Map<String, MbgViewListDimensionInfo>> viewPageMap = new HashMap<Integer, Map<String, MbgViewListDimensionInfo>>();
        HashMap<Integer, Map<Integer, Map<String, MbgViewListDimensionInfo>>> rowColMap = new HashMap<Integer, Map<Integer, Map<String, MbgViewListDimensionInfo>>>();
        MbgViewListFormServerHelper.reSaveOldBgVariateMembers(viewPageMap, rowColMap, oldSheetManager);
        MbgViewListDimensionManager dimensionManager = newSheetManager.getDimensionManager();
        MbgViewListFormServerHelper.fillViewPageVa(viewPageMap, dimensionManager.getViewDimension(), 1);
        MbgViewListFormServerHelper.fillViewPageVa(viewPageMap, dimensionManager.getPageDimension(), 2);
        MbgViewListFormServerHelper.fillRowColVa(rowColMap, dimensionManager.getRows(), 3);
        MbgViewListFormServerHelper.fillRowColVa(rowColMap, dimensionManager.getColumns(), 4);
    }

    private static void fillViewPageVa(Map<Integer, Map<String, MbgViewListDimensionInfo>> viewPageMap, List viewPageDims, int target) {
        if (viewPageMap == null || viewPageMap.isEmpty()) {
            return;
        }
        for (int index = 0; index < viewPageDims.size(); ++index) {
            MbgViewListDimensionInfo dimensionInfo = (MbgViewListDimensionInfo)viewPageDims.get(index);
            if (BgMemberSelectTypeEnum.Variate != dimensionInfo.getMemberType() || !viewPageMap.containsKey(target) || !viewPageMap.get(target).containsKey(dimensionInfo.getNumber())) continue;
            dimensionInfo.getMember().clear();
            List members = viewPageMap.get(target).get(dimensionInfo.getNumber()).getMember();
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgDimensionMember) || members.get(i) instanceof MbgViewListDimensionMember) continue;
                BgDimensionMember curMember = (BgDimensionMember)members.get(i);
                MbgViewListDimensionMember.addMember(curMember, dimensionInfo.getMember(), members.get(i), false);
            }
        }
    }

    private static void fillRowColVa(Map<Integer, Map<Integer, Map<String, MbgViewListDimensionInfo>>> rowColMap, List<IMbgViewListObject> rowCols, int target) {
        if (rowCols == null) {
            return;
        }
        for (int index = 0; index < rowCols.size(); ++index) {
            if (!(rowCols.get(index) instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowColInfo = (MbgViewListRowCol)rowCols.get(index);
            for (int i = 0; i < rowColInfo.getDimensions().size(); ++i) {
                if (!(rowColInfo.getDimensions().get(i) instanceof MbgViewListDimensionInfo)) continue;
                MbgViewListDimensionInfo dimensionInfo = rowColInfo.getDimensions().get(i);
                MbgViewListFormServerHelper.fillVa(rowColInfo, dimensionInfo, rowColMap, target);
            }
        }
    }

    private static void fillVa(MbgViewListRowCol rowColInfo, MbgViewListDimensionInfo dimensionInfo, Map<Integer, Map<Integer, Map<String, MbgViewListDimensionInfo>>> rowColMap, int targe) {
        if (rowColMap == null || rowColMap.isEmpty()) {
            return;
        }
        if (BgMemberSelectTypeEnum.Variate == dimensionInfo.getMemberType() && dimensionInfo.getMemberValueType() != DimensionMemberValueModeEnum.RelationMapping && rowColMap.containsKey(targe) && rowColMap.get(targe).containsKey(rowColInfo.getIndex()) && rowColMap.get(targe).get(rowColInfo.getIndex()).containsKey(dimensionInfo.getNumber())) {
            dimensionInfo.getMember().clear();
            List members = rowColMap.get(targe).get(rowColInfo.getIndex()).get(dimensionInfo.getNumber()).getMember();
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgDimensionMember) || members.get(i) instanceof MbgViewListDimensionMember) continue;
                BgDimensionMember curMember = (BgDimensionMember)members.get(i);
                MbgViewListDimensionMember.addMember(curMember, dimensionInfo.getMember(), members.get(i), false);
            }
        }
    }

    public static Set<String> getFormula(Context ctx, BgFormInfo bgForm, BgSchemeDimensionHelper bgSchemeHelper) throws BOSException {
        if (ctx == null || bgForm == null) {
            return null;
        }
        BgTemFormTypeEnum formType = bgForm.getBgTemplate().getFormType();
        HashSet<String> formulas = new HashSet<String>();
        try {
            IMbgViewBase manager = bgForm.getView(ctx, bgForm.getBgScheme());
            if (formType.equals((Object)BgTemFormTypeEnum.FIXEDFORM) || formType.equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
                formulas.clear();
                formulas.addAll(BgPeriodDecomposeUtils.getFormulaSetOfBook(bgForm.getBook()));
            } else if (formType.equals((Object)BgTemFormTypeEnum.VIEWLIST)) {
                formulas.clear();
                for (int index = 0; index < manager.getSheetManagers().size(); ++index) {
                    formulas.addAll(MbgViewListFormServerHelper.buildFormula((MbgViewListSheetManager)manager.getSheetManagers().get(index), bgSchemeHelper, null));
                }
            } else if (formType.equals((Object)BgTemFormTypeEnum.VIEWFORM)) {
                formulas.clear();
                formulas.addAll(BgViewHelper.buildFormula((IMbgViewManager)manager, null, bgSchemeHelper));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (formulas == null || formulas.isEmpty()) {
            return null;
        }
        return formulas;
    }

    public static Set<String> buildFormula(MbgViewListSheetManager sheetManager, BgSchemeDimensionHelper schemeHelper, BgDimensionMember queryMember) throws BOSException, EASBizException {
        final HashSet<String> formulas = new HashSet<String>();
        final HashMap clone = new HashMap();
        BgViewHelper.IFormulaProcessor processor = new BgViewHelper.IFormulaProcessor(){

            @Override
            public void process(String formula, String versionNumber, String scenarioNumber) {
                if (!StringUtils.isEmpty((String)formula)) {
                    formulas.add(formula);
                }
            }

            @Override
            public Map<Integer, String> getCloneMap() {
                return clone;
            }
        };
        MbgViewListFormServerHelper.buildFormula(sheetManager, processor, schemeHelper, queryMember);
        return formulas;
    }

    public static void buildFormula(MbgViewListSheetManager sheetManager, BgViewHelper.IFormulaProcessor processor, BgSchemeDimensionHelper schemeHelper, BgDimensionMember queryMember) throws BOSException {
        BgViewHelper.buildFormula(sheetManager, processor, schemeHelper, queryMember);
    }

    public static void addDefDimMembers(MbgViewListManager viewManager, List newForms, boolean isUpdateShowTemp, boolean isShowByTemp) throws Exception {
        if (viewManager == null || newForms == null) {
            return;
        }
        BgVersionInfo defVer = null;
        BgPeriodInfo defPer = null;
        CurrencyInfo defCurrency = null;
        if (newForms.size() > 0) {
            IDimDataQuery form = (IDimDataQuery)newForms.get(0);
            defVer = form.getBizVersion();
            defPer = form.getBizPeriod();
            defCurrency = form.getBizCurrency();
        }
        List sheets = viewManager.getSheetManagers();
        for (MbgViewListSheetManager sheet : sheets) {
            MbgViewListDimensionManager dimensionManager = sheet.getDimensionManager();
            MbgViewListFormServerHelper.addDefMembersForPeriod(dimensionManager, defPer);
            MbgViewListFormServerHelper.addDefMembersForVersion(dimensionManager, defVer);
            MbgViewListFormServerHelper.addDefMembersForCurrency(dimensionManager, defCurrency);
            if (!isUpdateShowTemp) continue;
            sheet.setRowColShowbyTemp(isShowByTemp);
        }
    }

    public static void addDefDimMembers(MbgViewListManager viewManager, IDimDataQuery form, boolean isUpdateShowTemp, boolean isShowByTemp) throws Exception {
        if (viewManager == null || form == null) {
            return;
        }
        BgVersionInfo defVer = null;
        BgPeriodInfo defPer = null;
        CurrencyInfo defCurrency = null;
        defVer = form.getBizVersion();
        defPer = form.getBizPeriod();
        defCurrency = form.getBizCurrency();
        List sheets = viewManager.getSheetManagers();
        for (MbgViewListSheetManager sheet : sheets) {
            MbgViewListDimensionManager dimensionManager = sheet.getDimensionManager();
            MbgViewListFormServerHelper.addDefMembersForPeriod(dimensionManager, defPer);
            MbgViewListFormServerHelper.addDefMembersForVersion(dimensionManager, defVer);
            MbgViewListFormServerHelper.addDefMembersForCurrency(dimensionManager, defCurrency);
            MbgViewListFormServerHelper.addDefMembersForOrgUnit(dimensionManager, form.getBizOrgUnit());
            if (!isUpdateShowTemp) continue;
            sheet.setRowColShowbyTemp(isShowByTemp);
        }
    }

    private static void addDefMembersForOrgUnit(MbgViewListDimensionManager dimensionManager, FullOrgUnitInfo org) {
        List<MbgViewListDimensionInfo> dimensions = dimensionManager.getAllDimensions(false);
        BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, org.getId().toString(), org.getName(), org.getNumber());
        member.setLevel(org.getLevel());
        member.setSortValue((Comparable)((Object)org.getLongNumber()));
        member.setSrcNumber(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
        member.setSimpleName(org.getSimpleName());
        member.setLongName(org.getDisplayName());
        member.setLeaf(org.isIsLeaf());
        for (MbgViewListDimensionInfo dim : dimensions) {
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber()) || !dim.getSelectMembers().isEmpty()) continue;
            dim.getSelectMembers().add(MbgViewListDimensionMember.getInstance(member));
        }
    }

    protected static void addDefMembersForVersion(MbgViewListDimensionManager dimensionManager, BgVersionInfo defVer) {
        Object viewMem;
        if (dimensionManager == null || defVer == null) {
            return;
        }
        List<IMbgViewListObject> rowsCols = dimensionManager.getRowCols();
        for (IMbgViewListObject row : rowsCols) {
            if (!(row instanceof MbgViewListRowCol)) continue;
            List<MbgViewListDimensionInfo> rowDim = ((MbgViewListRowCol)row).getDimensions();
            block1: for (MbgViewListDimensionInfo dimension : rowDim) {
                if (!dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER) || !DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType()) || !MbgViewListFormServerHelper.checkNeedAddDefault(dimension.getSelectMembers(), defVer.getNumber())) continue;
                List canAddMembers = dimension.getCanAddMember();
                if (canAddMembers.size() == 0) {
                    viewMem = new MbgViewListDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, DimensionConstants.DEF_VERSION_FIELD, defVer.getName(), defVer.getNumber());
                    ((BgDimensionMember)viewMem).setVersion(BgNConstants.ONE);
                    dimension.getMember().add(viewMem);
                    dimension.getSelectMembers().add(viewMem);
                    continue;
                }
                for (BgDimensionMember member : canAddMembers) {
                    if (!member.getNumber().equals(defVer.getNumber())) continue;
                    MbgViewListDimensionMember viewMem2 = new MbgViewListDimensionMember(member.getType(), member.getAttribute(), member.getName(), member.getNumber());
                    viewMem2.setVersion(BgNConstants.ONE);
                    dimension.getMember().add(viewMem2);
                    dimension.getSelectMembers().add(viewMem2);
                    continue block1;
                }
            }
        }
        List pageDim = dimensionManager.getPageDimension();
        block3: for (MbgViewListDimensionInfo dimension : pageDim) {
            if (!dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) continue;
            if (!MbgViewListFormServerHelper.checkNeedAddDefault(dimension.getSelectMembers(), defVer.getNumber())) break;
            List canAddMembers = dimension.getCanAddMember();
            if (canAddMembers.size() == 0) {
                MbgViewListDimensionMember viewMem3 = new MbgViewListDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, DimensionConstants.DEF_VERSION_FIELD, defVer.getName(), defVer.getNumber());
                viewMem3.setVersion(BgNConstants.ONE);
                dimension.getMember().add(viewMem3);
                dimension.getSelectMembers().add(viewMem3);
                continue;
            }
            for (BgDimensionMember member : canAddMembers) {
                if (!member.getNumber().equals(defVer.getNumber())) continue;
                viewMem = new MbgViewListDimensionMember(member.getType(), member.getAttribute(), member.getName(), member.getNumber());
                ((BgDimensionMember)viewMem).setVersion(BgNConstants.ONE);
                dimension.getMember().add(viewMem);
                dimension.getSelectMembers().add(viewMem);
                continue block3;
            }
        }
    }

    protected static boolean checkNeedAddDefault(List selectedMembers, String number) {
        if (StringUtils.isEmpty((String)number) || selectedMembers == null) {
            return false;
        }
        for (int i = 0; i < selectedMembers.size(); ++i) {
            if (!(selectedMembers.get(i) instanceof BgDimensionMember)) {
                return false;
            }
            if (!number.equals(((BgDimensionMember)selectedMembers.get(i)).getNumber())) continue;
            return false;
        }
        return true;
    }

    protected static void addDefMembersForPeriod(MbgViewListDimensionManager dimensionManager, BgPeriodInfo defPer) {
        if (dimensionManager == null || defPer == null) {
            return;
        }
        List<IMbgViewListObject> rowsCols = dimensionManager.getRowCols();
        for (IMbgViewListObject row : rowsCols) {
            if (!(row instanceof MbgViewListRowCol)) continue;
            List<MbgViewListDimensionInfo> rowDim = ((MbgViewListRowCol)row).getDimensions();
            for (MbgViewListDimensionInfo dimension : rowDim) {
                if (!DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType()) || !dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || !MbgViewListFormServerHelper.checkNeedAddDefault(dimension.getSelectMembers(), defPer.getNumber())) continue;
                MbgViewListDimensionMember viewMem = new MbgViewListDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, defPer.getName(), defPer.getNumber());
                viewMem.setVersion(BgNConstants.ONE);
                dimension.getMember().add(viewMem);
                dimension.getSelectMembers().add(viewMem);
            }
        }
        List pageDim = dimensionManager.getPageDimension();
        for (MbgViewListDimensionInfo dimension : pageDim) {
            if (!dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) || !DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType())) continue;
            if (!MbgViewListFormServerHelper.checkNeedAddDefault(dimension.getSelectMembers(), defPer.getNumber())) break;
            MbgViewListDimensionMember viewMem = new MbgViewListDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, defPer.getName(), defPer.getNumber());
            viewMem.setVersion(BgNConstants.ONE);
            dimension.getMember().add(viewMem);
            dimension.getSelectMembers().add(viewMem);
        }
    }

    protected static void addDefMembersForCurrency(MbgViewListDimensionManager dimensionManager, CurrencyInfo defCurrency) {
        Object viewMem;
        if (dimensionManager == null || defCurrency == null) {
            return;
        }
        List<IMbgViewListObject> rowsCols = dimensionManager.getRowCols();
        for (IMbgViewListObject row : rowsCols) {
            if (!(row instanceof MbgViewListRowCol)) continue;
            List<MbgViewListDimensionInfo> rowDim = ((MbgViewListRowCol)row).getDimensions();
            block1: for (MbgViewListDimensionInfo dimension : rowDim) {
                if (!dimension.getNumber().equals(DimensionConstants.DEF_CURRENCY_NUMBER) || !DimensionMemberValueModeEnum.Null.equals((Object)dimension.getMemberValueType()) || !MbgViewListFormServerHelper.checkNeedAddDefault(dimension.getSelectMembers(), defCurrency.getNumber())) continue;
                List canAddMembers = dimension.getCanAddMember();
                if (canAddMembers.size() == 0) {
                    viewMem = new MbgViewListDimensionMember(DimensionConstants.DEF_CURRENCY_NUMBER, DimensionConstants.DEF_CURRENCY_FIELD, defCurrency.getName(), defCurrency.getNumber());
                    ((BgDimensionMember)viewMem).setVersion(BgNConstants.ONE);
                    dimension.getMember().add(viewMem);
                    dimension.getSelectMembers().add(viewMem);
                    continue;
                }
                for (BgDimensionMember member : canAddMembers) {
                    if (!member.getNumber().equals(defCurrency.getNumber())) continue;
                    MbgViewListDimensionMember viewMem2 = new MbgViewListDimensionMember(member.getType(), member.getAttribute(), member.getName(), member.getNumber());
                    viewMem2.setVersion(BgNConstants.ONE);
                    dimension.getMember().add(viewMem2);
                    dimension.getSelectMembers().add(viewMem2);
                    continue block1;
                }
            }
        }
        List pageDim = dimensionManager.getPageDimension();
        block3: for (MbgViewListDimensionInfo dimension : pageDim) {
            if (!dimension.getNumber().equals(DimensionConstants.DEF_CURRENCY_NUMBER)) continue;
            if (!MbgViewListFormServerHelper.checkNeedAddDefault(dimension.getSelectMembers(), defCurrency.getNumber())) break;
            List canAddMembers = dimension.getCanAddMember();
            if (canAddMembers.size() == 0) {
                MbgViewListDimensionMember viewMem3 = new MbgViewListDimensionMember(DimensionConstants.DEF_CURRENCY_NUMBER, DimensionConstants.DEF_CURRENCY_FIELD, defCurrency.getName(), defCurrency.getNumber());
                viewMem3.setVersion(BgNConstants.ONE);
                dimension.getMember().add(viewMem3);
                dimension.getSelectMembers().add(viewMem3);
                continue;
            }
            for (BgDimensionMember member : canAddMembers) {
                if (!member.getNumber().equals(defCurrency.getNumber())) continue;
                viewMem = new MbgViewListDimensionMember(member.getType(), member.getAttribute(), member.getName(), member.getNumber());
                ((BgDimensionMember)viewMem).setVersion(BgNConstants.ONE);
                dimension.getMember().add(viewMem);
                dimension.getSelectMembers().add(viewMem);
                continue block3;
            }
        }
    }

    public static MbgViewListManager updateMembers(Context ctx, MbgViewListManager viewManager, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        MbgViewListDimensionInfo dim;
        int m;
        List<MbgViewListDimensionInfo> dimensions;
        MbgViewListDimensionManager dimensionManager;
        int index;
        if (viewManager == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgUnitId)) {
            return viewManager;
        }
        MBgTemplateHelper.startLog("Start updateMembers");
        ViewListMemberCacheHelper cacheHelper = null;
        if (viewManager.getMemberCacheHelper() != null) {
            cacheHelper = viewManager.getMemberCacheHelper();
        } else {
            cacheHelper = new ViewListMemberCacheHelper();
            cacheHelper.setCtx(ctx);
        }
        if (cacheHelper.getSchemeHelper() == null) {
            cacheHelper.setSchemeHelper(new BgSchemeDimensionHelper(ctx, bgSchemeId));
        }
        List<BgDimensionInfo> alldims = cacheHelper.getSchemeHelper().getAllDimensions();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < alldims.size(); ++i) {
            map.put(alldims.get(i).getNumber(), alldims.get(i).getName());
        }
        HashSet<String> propSet = new HashSet<String>();
        HashSet<String> variSet = new HashSet<String>();
        for (index = 0; index < viewManager.getSheetManagers().size(); ++index) {
            dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(index)).getDimensionManager();
            dimensions = dimensionManager.getAllDimensions();
            for (m = 0; m < dimensions.size(); ++m) {
                dim = dimensions.get(m);
                if (!map.containsKey(dim.getNumber())) continue;
                dim.setName((String)map.get(dim.getNumber()));
                dim.setAlias((String)map.get(dim.getNumber()));
            }
        }
        for (index = 0; index < viewManager.getSheetManagers().size(); ++index) {
            dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(index)).getDimensionManager();
            dimensions = dimensionManager.getAllDimensions();
            for (m = 0; m < dimensions.size(); ++m) {
                int i;
                List selectMembers;
                dim = dimensions.get(m);
                if (BgMemberSelectTypeEnum.Member.equals((Object)dim.getMemberType())) {
                    MbgViewListFormServerHelper.updateDimMemberName(ctx, dim, cacheHelper, cacheHelper.getSchemeHelper(), bgSchemeId, orgUnitId);
                    continue;
                }
                if (BgMemberSelectTypeEnum.Property.equals((Object)dim.getMemberType())) {
                    selectMembers = dim.getSelectMembers();
                    if (selectMembers.isEmpty()) continue;
                    for (i = 0; i < selectMembers.size(); ++i) {
                        if (!(selectMembers.get(i) instanceof BgPropertyInfo)) continue;
                        propSet.add(((BgPropertyInfo)selectMembers.get(i)).getId().toString());
                    }
                    continue;
                }
                if (!BgMemberSelectTypeEnum.Variate.equals((Object)dim.getMemberType()) || (selectMembers = dim.getSelectMembers()).isEmpty()) continue;
                for (i = 0; i < selectMembers.size(); ++i) {
                    if (!(selectMembers.get(i) instanceof BgVariateInfo)) continue;
                    variSet.add(((BgVariateInfo)selectMembers.get(i)).getId().toString());
                }
            }
        }
        MBgTemplateHelper.logTime("End updateMembers");
        MbgViewListDimensionManager dimManager = null;
        DimensionCacheHelper groupHelper = new DimensionCacheHelper(ctx);
        List<IMbgViewListObject> rowCols = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            dimManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            MbgViewListFormServerHelper.updateRelationGroup(groupHelper, dimManager.getPageRelationMaps());
            rowCols = dimManager.getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                MbgViewListFormServerHelper.updateRelationGroup(groupHelper, ((MbgViewListRowCol)rowCols.get(i)).getRelationMaps());
            }
        }
        MbgViewListFormServerHelper.updatePropAndVari(ctx, viewManager, propSet, variSet);
        MBgTemplateHelper.logTime("End updatePropAndVari");
        return viewManager;
    }

    private static void updateRelationGroup(DimensionCacheHelper groupHelper, List<MbgRelationMap> relationMaps) throws BOSException {
        if (relationMaps != null && !relationMaps.isEmpty()) {
            DimensionRelationshipGroupInfo _group = null;
            for (MbgRelationMap relationMap : relationMaps) {
                _group = groupHelper.getRelationGroup(relationMap.getGroup().getId().toString());
                if (_group == null) continue;
                relationMap.setGroup(_group);
            }
        }
    }

    private static void updatePropAndVari(Context ctx, MbgViewListManager viewManager, Set<String> propSet, Set<String> variSet) throws BOSException {
        Map<String, BgVariateInfo> variMap = MbgViewListFormServerHelper.getVariMap(ctx, variSet);
        Map<String, BgPropertyInfo> propMap = MbgViewListFormServerHelper.getPropMap(ctx, propSet);
        if (!variMap.isEmpty() || !propMap.isEmpty()) {
            for (int index = 0; index < viewManager.getSheetManagers().size(); ++index) {
                MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(index)).getDimensionManager();
                List<MbgViewListDimensionInfo> dimensions = dimensionManager.getAllDimensions();
                for (int m = 0; m < dimensions.size(); ++m) {
                    int i;
                    List canAddMembers;
                    List selectMembers;
                    MbgViewListDimensionInfo dim = dimensions.get(m);
                    if (BgMemberSelectTypeEnum.Property.equals((Object)dim.getMemberType())) {
                        selectMembers = dim.getSelectMembers();
                        if (!selectMembers.isEmpty()) {
                            for (int i2 = 0; i2 < selectMembers.size(); ++i2) {
                                if (!(selectMembers.get(i2) instanceof BgPropertyInfo) || !propMap.containsKey(((BgPropertyInfo)selectMembers.get(i2)).getId().toString())) continue;
                                ((BgPropertyInfo)selectMembers.get(i2)).setName(propMap.get(((BgPropertyInfo)selectMembers.get(i2)).getId().toString()).getName());
                            }
                        }
                        if ((canAddMembers = dim.getCanAddMember()).isEmpty()) continue;
                        for (i = 0; i < canAddMembers.size(); ++i) {
                            if (!(canAddMembers.get(i) instanceof BgPropertyInfo) || !propMap.containsKey(((BgPropertyInfo)canAddMembers.get(i)).getId().toString())) continue;
                            ((BgPropertyInfo)canAddMembers.get(i)).setName(propMap.get(((BgPropertyInfo)canAddMembers.get(i)).getId().toString()).getName());
                        }
                        continue;
                    }
                    if (!BgMemberSelectTypeEnum.Variate.equals((Object)dim.getMemberType())) continue;
                    selectMembers = dim.getSelectMembers();
                    if (!selectMembers.isEmpty()) {
                        for (int i3 = 0; i3 < selectMembers.size(); ++i3) {
                            if (!(selectMembers.get(i3) instanceof BgVariateInfo) || !variMap.containsKey(((BgVariateInfo)selectMembers.get(i3)).getId().toString())) continue;
                            ((BgVariateInfo)selectMembers.get(i3)).setName(variMap.get(((BgVariateInfo)selectMembers.get(i3)).getId().toString()).getName());
                        }
                    }
                    if ((canAddMembers = dim.getCanAddMember()).isEmpty()) continue;
                    for (i = 0; i < canAddMembers.size(); ++i) {
                        if (!(canAddMembers.get(i) instanceof BgVariateInfo) || !variMap.containsKey(((BgVariateInfo)canAddMembers.get(i)).getId().toString())) continue;
                        ((BgVariateInfo)canAddMembers.get(i)).setName(variMap.get(((BgVariateInfo)canAddMembers.get(i)).getId().toString()).getName());
                    }
                }
            }
        }
    }

    private static Map<String, BgVariateInfo> getVariMap(Context ctx, Set<String> variSet) throws BOSException {
        HashMap<String, BgVariateInfo> variMap = new HashMap<String, BgVariateInfo>();
        if (variSet == null || variSet.isEmpty()) {
            return variMap;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", variSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        BgVariateCollection colls = BgVariateFactory.getLocalInstance(ctx).getBgVariateCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int index = 0; index < colls.size(); ++index) {
                variMap.put(colls.get(index).getId().toString(), colls.get(index));
            }
        }
        return variMap;
    }

    private static Map<String, BgPropertyInfo> getPropMap(Context ctx, Set<String> propSet) throws BOSException {
        HashMap<String, BgPropertyInfo> propMap = new HashMap<String, BgPropertyInfo>();
        if (propSet == null || propSet.isEmpty()) {
            return propMap;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", propSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        BgPropertyCollection colls = BgPropertyFactory.getLocalInstance((Context)ctx).getBgPropertyCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int index = 0; index < colls.size(); ++index) {
                propMap.put(colls.get(index).getId().toString(), colls.get(index));
            }
        }
        return propMap;
    }

    public static void updateDimMemberName(Context ctx, MbgViewListDimensionInfo dim, ViewListMemberCacheHelper cacheHelper, BgSchemeDimensionHelper bgSchemeDimensionHelper, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        int i;
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
            return;
        }
        ArrayList members = new ArrayList();
        members.addAll(dim.getSelectMembers());
        members.addAll(dim.getCanAddMember());
        HashMap<String, BgDimensionMember> memberMap = new HashMap<String, BgDimensionMember>();
        for (i = 0; i < members.size(); ++i) {
            if (!(members.get(i) instanceof BgDimensionMember)) continue;
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            memberMap.put(member.getNumber(), member);
        }
        if (memberMap.isEmpty()) {
            return;
        }
        cacheHelper.updateMemberName(orgUnitId, dim.getNumber(), memberMap);
        if (memberMap.isEmpty()) {
            return;
        }
        if (!dim.getSelectMembers().isEmpty()) {
            for (i = 0; i < dim.getSelectMembers().size(); ++i) {
                if (!memberMap.containsKey(((BgDimensionMember)dim.getSelectMembers().get(i)).getNumber())) continue;
                ((BgDimensionMember)dim.getSelectMembers().get(i)).setName(((BgDimensionMember)memberMap.get(((BgDimensionMember)dim.getSelectMembers().get(i)).getNumber())).getName());
            }
        }
        if (!dim.getCanAddMember().isEmpty()) {
            for (i = 0; i < dim.getCanAddMember().size(); ++i) {
                if (!memberMap.containsKey(((BgDimensionMember)dim.getCanAddMember().get(i)).getNumber())) continue;
                ((BgDimensionMember)dim.getCanAddMember().get(i)).setName(((BgDimensionMember)memberMap.get(((BgDimensionMember)dim.getCanAddMember().get(i)).getNumber())).getName());
            }
        }
    }

    public static boolean isOrgOnRow(MbgViewListDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return false;
        }
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            if (!(rows.get(i) instanceof MbgViewListRowCol)) continue;
            List<MbgViewListDimensionInfo> rowDimensions = ((MbgViewListRowCol)rows.get(i)).getDimensions();
            for (int j = 0; j < rowDimensions.size(); ++j) {
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(rowDimensions.get(j).getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOrgOnPageOrView(IBgDimensionManagerBase dimensionManager) {
        List viewDimension = dimensionManager.getViewDisplayDimension();
        for (int i = 0; i < viewDimension.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)viewDimension.get(i)).getNumber())) continue;
            return Boolean.TRUE;
        }
        List pageDimension = dimensionManager.getPageDisplayDimension();
        for (int i = 0; i < pageDimension.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(((BgDimensionBaseInfo)pageDimension.get(i)).getNumber())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void backupCanAddMember(MbgViewListManager viewManager) {
        if (viewManager == null) {
            return;
        }
        List<MbgViewListDimensionInfo> dimensions = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            dimensions = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getAllDimensions();
            for (int d = 0; d < dimensions.size(); ++d) {
                if (dimensions.get(d).getOrignCanAddMember() != null || dimensions.get(d).getCanAddMember() == null) continue;
                dimensions.get(d).setOrignCanAddMember(new ArrayList(dimensions.get(d).getCanAddMember()));
            }
        }
    }

    public static Map<String, Map<Integer, IMbgViewListObject>> getViewListIndexObjectsByTemp(List<IMbgViewListObject> viewlistOrgCols, String currentOrgNum) {
        LinkedHashMap<String, Map<Integer, IMbgViewListObject>> returnMap = new LinkedHashMap<String, Map<Integer, IMbgViewListObject>>();
        if (viewlistOrgCols == null) {
            return returnMap;
        }
        Integer objectIndex = -1;
        int size = viewlistOrgCols.size();
        for (int index = 0; index < size; ++index) {
            IMbgViewListObject viewlistObj = viewlistOrgCols.get(index);
            objectIndex = MbgViewListFormServerHelper.getIndex(viewlistObj);
            String orgMemberNum = null;
            if (viewlistObj instanceof MbgViewListRowCol) {
                MbgViewListRowCol rowCol = (MbgViewListRowCol)viewlistObj;
                List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                for (int j = 0; j < dimensions.size(); ++j) {
                    MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                    if (dimInfo.getMember().size() == 1) {
                        orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                        break;
                    }
                    if (dimInfo.getMember().size() > 1) {
                        orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                        continue;
                    }
                    return returnMap;
                }
            } else if (orgMemberNum == null && currentOrgNum != null) {
                if (!returnMap.containsKey(currentOrgNum)) {
                    returnMap.put(currentOrgNum, new LinkedHashMap());
                }
                ((Map)returnMap.get(currentOrgNum)).put(objectIndex, viewlistObj);
            }
            if (orgMemberNum == null) continue;
            if (!returnMap.containsKey(orgMemberNum)) {
                returnMap.put(orgMemberNum, new LinkedHashMap());
            }
            ((Map)returnMap.get(orgMemberNum)).put(objectIndex, viewlistObj);
        }
        return returnMap;
    }

    public static Integer getIndex(IMbgViewListObject viewlistObj) {
        if (viewlistObj instanceof AbstractMbgViewListObject) {
            return ((AbstractMbgViewListObject)viewlistObj).getInitIndex();
        }
        return viewlistObj.getIndex();
    }

    public static Map<String, Map<Integer, IMbgViewListObject>> getViewListIndexObjectsByTemp(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow, String currentOrgNum) {
        LinkedHashMap<String, Map<Integer, IMbgViewListObject>> returnMap = new LinkedHashMap<String, Map<Integer, IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        List<IMbgViewListObject> viewlistOrgCols = isOrgOnRow != false ? dimensionManager.getRows() : dimensionManager.getColumns();
        return MbgViewListFormServerHelper.getViewListIndexObjectsByTemp(viewlistOrgCols, currentOrgNum);
    }

    public static Map<String, List<IMbgViewListObject>> getViewListObjectsByOrg(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow) {
        IMbgViewListObject rowObject;
        int i;
        LinkedHashMap<String, List<IMbgViewListObject>> returnMap = new LinkedHashMap<String, List<IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        ArrayList<IMbgViewListObject> tempList = new ArrayList<IMbgViewListObject>();
        ArrayList<IMbgViewListObject> objectist = null;
        List<IMbgViewListObject> rowCols = null;
        String orgMemberNum = null;
        int maxIndex = -1;
        rowCols = isOrgOnRow != false ? dimensionManager.getRows() : dimensionManager.getColumns();
        for (i = 0; i < rowCols.size(); ++i) {
            rowObject = rowCols.get(i);
            if (MbgViewListFormServerHelper.getIndex(rowObject) < maxIndex) continue;
            maxIndex = MbgViewListFormServerHelper.getIndex(rowObject);
        }
        for (i = 0; i < rowCols.size(); ++i) {
            rowObject = rowCols.get(i);
            if (MbgViewListFormServerHelper.getIndex(rowObject) > maxIndex) continue;
            tempList.add(rowObject);
            if (rowObject instanceof MbgViewListRowCol) {
                MbgViewListRowCol row = (MbgViewListRowCol)rowObject;
                List<MbgViewListDimensionInfo> dimensions = row.getDimensions();
                for (int j = 0; j < dimensions.size(); ++j) {
                    MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                    if (dimInfo.getMember().size() == 1) {
                        orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                        break;
                    }
                    return null;
                }
            }
            if (MbgViewListFormServerHelper.getIndex(rowObject) != maxIndex || orgMemberNum == null) continue;
            objectist = new ArrayList<IMbgViewListObject>();
            objectist.addAll(tempList);
            returnMap.put(orgMemberNum, objectist);
            tempList.clear();
            orgMemberNum = null;
        }
        return returnMap;
    }

    public static Map<String, Map<Integer, IMbgViewListObject>> getViewListIndexObjects(Map<String, MbgViewListManager> viewlistManagerMap, int sheetIndex, Boolean isOrgOnRow) {
        HashMap<String, Map<Integer, IMbgViewListObject>> returnMap = new HashMap<String, Map<Integer, IMbgViewListObject>>();
        if (viewlistManagerMap == null || viewlistManagerMap.isEmpty()) {
            return returnMap;
        }
        Integer objectIndex = -1;
        for (String orgNum : viewlistManagerMap.keySet()) {
            MbgViewListManager viewlistManager = viewlistManagerMap.get(orgNum);
            returnMap.put(orgNum, new LinkedHashMap());
            List<IMbgViewListObject> tmpLst = isOrgOnRow != false ? ((MbgViewListSheetManager)viewlistManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getRows() : ((MbgViewListSheetManager)viewlistManager.getSheetManagers().get(sheetIndex)).getDimensionManager().getColumns();
            int size = tmpLst.size();
            for (int index = 0; index < size; ++index) {
                IMbgViewListObject viewlistObj = tmpLst.get(index);
                objectIndex = MbgViewListFormServerHelper.getIndex(viewlistObj);
                if (((Map)returnMap.get(orgNum)).containsKey(objectIndex)) continue;
                ((Map)returnMap.get(orgNum)).put(objectIndex, viewlistObj);
            }
        }
        return returnMap;
    }

    public static Map<String, Map<String, MbgViewListCell>> getViewListCellsByTemp(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow, String currentOrgNum) {
        LinkedHashMap<String, Map<String, MbgViewListCell>> returnMap = new LinkedHashMap<String, Map<String, MbgViewListCell>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        Integer objectIndex = -1;
        List<IMbgViewListObject> rows = dimensionManager.getRows();
        List<IMbgViewListObject> cols = dimensionManager.getColumns();
        if (isOrgOnRow.booleanValue()) {
            int size = rows.size();
            for (int index = 0; index < size; ++index) {
                MbgViewListCell cell;
                int xIndex;
                IMbgViewListObject viewlistObj = rows.get(index);
                objectIndex = MbgViewListFormServerHelper.getIndex(viewlistObj);
                String orgMemberNum = null;
                if (viewlistObj instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowCol = (MbgViewListRowCol)viewlistObj;
                    List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                    for (int j = 0; j < dimensions.size(); ++j) {
                        MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                        if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                        if (dimInfo.getMember().size() == 1) {
                            orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                            break;
                        }
                        return returnMap;
                    }
                } else if (orgMemberNum == null && currentOrgNum != null) {
                    if (!returnMap.containsKey(currentOrgNum)) {
                        returnMap.put(currentOrgNum, new HashMap());
                    }
                    for (xIndex = 0; xIndex < cols.size(); ++xIndex) {
                        cell = new MbgViewListCell();
                        cell.setRow(viewlistObj);
                        cell.setCol(cols.get(xIndex));
                        ((Map)returnMap.get(currentOrgNum)).put(MbgViewListFormServerHelper.getIndex(viewlistObj) + ":" + MbgViewListFormServerHelper.getIndex(cols.get(xIndex)), cell);
                    }
                }
                if (orgMemberNum == null) continue;
                if (!returnMap.containsKey(orgMemberNum)) {
                    returnMap.put(orgMemberNum, new HashMap());
                }
                for (xIndex = 0; xIndex < cols.size(); ++xIndex) {
                    cell = new MbgViewListCell();
                    cell.setRow(viewlistObj);
                    cell.setCol(cols.get(xIndex));
                    ((Map)returnMap.get(orgMemberNum)).put(MbgViewListFormServerHelper.getIndex(viewlistObj) + ":" + MbgViewListFormServerHelper.getIndex(cols.get(xIndex)), cell);
                }
            }
        } else {
            int size = cols.size();
            for (int index = 0; index < size; ++index) {
                MbgViewListCell cell;
                int xIndex;
                IMbgViewListObject viewlistObj = cols.get(index);
                objectIndex = MbgViewListFormServerHelper.getIndex(viewlistObj);
                String orgMemberNum = null;
                if (viewlistObj instanceof MbgViewListRowCol) {
                    MbgViewListRowCol rowCol = (MbgViewListRowCol)viewlistObj;
                    List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
                    for (int j = 0; j < dimensions.size(); ++j) {
                        MbgViewListDimensionInfo dimInfo = dimensions.get(j);
                        if (!MBGLayoutConstants.BG_ORGANIZATION.equals(dimInfo.getNumber())) continue;
                        if (dimInfo.getMember().size() == 1) {
                            orgMemberNum = ((BgDimensionMember)dimInfo.getMember().get(0)).getNumber();
                            break;
                        }
                        return returnMap;
                    }
                } else if (orgMemberNum == null && currentOrgNum != null) {
                    if (!returnMap.containsKey(currentOrgNum)) {
                        returnMap.put(currentOrgNum, new HashMap());
                    }
                    for (xIndex = 0; xIndex < rows.size(); ++xIndex) {
                        cell = new MbgViewListCell();
                        cell.setRow(rows.get(xIndex));
                        cell.setCol(viewlistObj);
                        ((Map)returnMap.get(currentOrgNum)).put(MbgViewListFormServerHelper.getIndex(rows.get(xIndex)) + ":" + MbgViewListFormServerHelper.getIndex(viewlistObj), cell);
                    }
                }
                if (orgMemberNum == null) continue;
                if (!returnMap.containsKey(orgMemberNum)) {
                    returnMap.put(orgMemberNum, new HashMap());
                }
                for (xIndex = 0; xIndex < rows.size(); ++xIndex) {
                    cell = new MbgViewListCell();
                    cell.setRow(rows.get(xIndex));
                    cell.setCol(viewlistObj);
                    ((Map)returnMap.get(orgMemberNum)).put(MbgViewListFormServerHelper.getIndex(rows.get(xIndex)) + ":" + MbgViewListFormServerHelper.getIndex(viewlistObj), cell);
                }
            }
        }
        return returnMap;
    }

    public static Boolean checkHasCombin(MbgViewListManager viewManager) {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            List<IMbgViewListObject> rows = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRows();
            for (int index = 0; index < rows.size(); ++index) {
                if (!(rows.get(index) instanceof MbgViewListRowCol) || !((MbgViewListRowCol)rows.get(index)).isCombin()) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, List<IMbgViewListObject>> getViewListObjectsByTemp(MbgViewListDimensionManager dimensionManager, Boolean isOrgOnRow, String currentOrgNum) {
        LinkedHashMap<String, List<IMbgViewListObject>> returnMap = new LinkedHashMap<String, List<IMbgViewListObject>>();
        if (dimensionManager == null) {
            return returnMap;
        }
        Map<String, Map<Integer, IMbgViewListObject>> indexObjMap = MbgViewListFormServerHelper.getViewListIndexObjectsByTemp(dimensionManager, isOrgOnRow, currentOrgNum);
        for (String orgNum : indexObjMap.keySet()) {
            Map<Integer, IMbgViewListObject> tmpMap = indexObjMap.get(orgNum);
            returnMap.put(orgNum, new ArrayList());
            Iterator<IMbgViewListObject> it = tmpMap.values().iterator();
            while (it.hasNext()) {
                ((List)returnMap.get(orgNum)).add(it.next());
            }
        }
        return returnMap;
    }

    public static void checkPeriodType(Context ctx, MbgViewListSheetManager cloneSheet, MbgViewListManager view) throws BOSException, EASBizException {
        HashSet<String> bgPeriodNumbers = new HashSet<String>();
        MbgViewListSheetManager _sheet = null;
        List<MbgViewListDimensionInfo> allDims = null;
        List<IMbgViewListObject> rowCols = null;
        BgDimensionBaseInfo _dim = null;
        MbgViewListRowCol rowCol = null;
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            int m;
            _sheet = (MbgViewListSheetManager)view.getSheetManagers().get(s);
            if (cloneSheet != null && _sheet.getSheetName().equals(cloneSheet.getSheetName())) {
                _sheet = cloneSheet;
            }
            allDims = _sheet.getDimensionManager().getAllDimensions();
            for (int d = 0; d < allDims.size(); ++d) {
                if (!(allDims.get(d) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_PERIOD_NUMBER.equals((_dim = (BgDimensionBaseInfo)allDims.get(d)).getNumber())) continue;
                for (m = 0; m < _dim.getMember().size(); ++m) {
                    if (!(_dim.getMember().get(m) instanceof BgDimensionMember)) continue;
                    bgPeriodNumbers.add(((BgDimensionMember)_dim.getMember().get(m)).getNumber());
                }
            }
            rowCols = _sheet.getDimensionManager().getRowCols();
            for (int r = 0; r < rowCols.size(); ++r) {
                if (!(rowCols.get(r) instanceof MbgViewListRowCol) || !(rowCol = (MbgViewListRowCol)rowCols.get(r)).isCombin()) continue;
                for (m = 0; m < rowCol.getCombinMembers().size(); ++m) {
                    BgDimensionMember _member = rowCol.getCombinMembers().get(m);
                    String[] combin = _member.getCombNumber().split(",");
                    for (int c = 0; c < combin.length; ++c) {
                        if (!DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(DimensionFormulaHelper.getSrcNumber(combin[c]))) continue;
                        bgPeriodNumbers.add(DimensionFormulaHelper.getMemberNumber(combin[c]));
                    }
                }
            }
        }
        if (!bgPeriodNumbers.isEmpty()) {
            BgPeriodDispFactory.getLocalInstance((Context)ctx).checkPeriodType(bgPeriodNumbers, true);
        }
    }

    public static Map<String, IMbgViewBase> getViewMap(Context ctx, Object[] bgTemplateInfos) throws Exception {
        HashMap<String, IMbgViewBase> result = new HashMap<String, IMbgViewBase>();
        Set<String> ids = DimensionCommonHelper.getIds(bgTemplateInfos);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("data");
        evi.getSelector().add("template.id");
        evi.getSelector().add("template.formType");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("template.id", ids, CompareType.INCLUDE));
        BgViewDimensionCollection col = BgViewDimensionFactory.getLocalInstance(ctx).getBgViewDimensionCollection(evi);
        byte[] datas = null;
        MbgXMLParser viewParser = new MbgXMLParser(ctx);
        MbgViewListXMLParser viewListParser = new MbgViewListXMLParser(ctx);
        for (int i = 0; i < col.size(); ++i) {
            datas = col.get(i).getData();
            if (datas == null || datas.length == 0) continue;
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)col.get(i).getTemplate().getFormType())) {
                result.put(col.get(i).getTemplate().getId().toString(), viewListParser.parse(datas));
                continue;
            }
            result.put(col.get(i).getTemplate().getId().toString(), viewParser.parse(datas));
        }
        return result;
    }
}

