/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.FindedTooMuchRecordsException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgDimHelper;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.Node;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListMemberParserServerHelper {
    private static final Logger logger = Logger.getLogger((String)ViewListMemberParserServerHelper.class.getName());
    private Context ctx = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private boolean isReParsePeriod = false;
    private String orgId = null;
    private boolean isQueryAllRelation = false;
    private String unitGroupId = null;
    private Map<String, DimensionFilterHelper> cacheHelper = new HashMap<String, DimensionFilterHelper>();
    private DimensionCacheHelper relationCachHelper = null;
    private Map<String, DimensionRelationshipCollection> allRelations = new HashMap<String, DimensionRelationshipCollection>();
    private ViewListMemberCacheHelper memberCacheHelper = new ViewListMemberCacheHelper();
    Timestamp formCreateTime = null;
    Timestamp tMax = null;

    public ViewListMemberCacheHelper getMemberCacheHelper() {
        return this.memberCacheHelper;
    }

    public void setMemberCacheHelper(ViewListMemberCacheHelper memberCacheHelper) {
        this.memberCacheHelper = memberCacheHelper;
    }

    public void setFormCreateTime(Timestamp time) throws BOSException {
        try {
            this.formCreateTime = time;
            this.tMax = new BgNPeriodHelper().getDayMaxTimeStampB(time);
        }
        catch (ParseException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public ViewListMemberParserServerHelper(Context ctx, String bgSchemeId, String orgId) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.orgId = orgId;
        this.schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        this.relationCachHelper = new DimensionCacheHelper(ctx);
    }

    public ViewListMemberParserServerHelper(Context ctx, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.schemeHelper = schemeHelper;
        this.relationCachHelper = new DimensionCacheHelper(ctx);
    }

    public ViewListMemberParserServerHelper(Context ctx, BgSchemeDimensionHelper schemeHelper, String orgId) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.schemeHelper = schemeHelper;
        this.orgId = orgId;
        this.relationCachHelper = new DimensionCacheHelper(ctx);
    }

    public void setReParsePeriod(boolean isReParsePeriod) {
        this.isReParsePeriod = isReParsePeriod;
    }

    public void setQueryAllRelation(boolean isQueryAllRelation) {
        this.isQueryAllRelation = isQueryAllRelation;
    }

    public void setUnitGroupId(String unitGroupId) {
        this.unitGroupId = unitGroupId;
    }

    private DimensionFilterHelper getFilterHelper(String dimNumber, String orgId) throws DimensionException {
        if (!this.cacheHelper.containsKey(dimNumber)) {
            this.cacheHelper.put(dimNumber, DimensionFilterHelper.getLocaleIntance(this.ctx, this.schemeHelper.getDimensionOnCheck(dimNumber), orgId, this.schemeHelper.getBgSchemeId(), null, this.unitGroupId));
        }
        return this.cacheHelper.get(dimNumber);
    }

    private DimensionRelationshipCollection getAllRelations(String orgId, DimensionRelationshipGroupInfo group) throws EASBizException, BOSException {
        if (group == null || group.getId() == null) {
            return null;
        }
        if (!this.allRelations.containsKey(group.getId().toString()) && orgId != null) {
            DimensionRelationshipCollection col = new DimensionRelationshipCollection();
            CoreBaseCollection col1 = null;
            col1 = group.isIsCsl() ? DimensionMemberRelationShipHelper.queryAllRelationByGroupId(this.ctx, group, null) : DimensionMemberRelationShipHelper.queryAllRelationByGroupId(this.ctx, group, this.relationCachHelper.getOrgUnitById(orgId));
            if (col1 != null) {
                col.addObjectCollection((IObjectCollection)col1);
            }
            this.allRelations.put(group.getId().toString(), col);
        }
        return this.allRelations.get(group.getId().toString());
    }

    public void parseMember(MbgViewListManager viewManager) throws EASBizException, BOSException {
        this.parseMember(viewManager, false);
    }

    public void parseMember(MbgViewListManager viewManager, boolean isOnlyLeaf) throws EASBizException, BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            this.parseMember(conn, this.orgId != null ? this.orgId : ContextUtil.getCurrentCostUnit((Context)this.ctx).getId().toString(), viewManager, isOnlyLeaf);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public void parseMember(Connection conn, String orgId, MbgViewListManager viewManager, boolean isOnlyLeaf) throws EASBizException, BOSException {
        if (viewManager.getMemberCacheHelper() != null) {
            this.memberCacheHelper = viewManager.getMemberCacheHelper();
        }
        this.memberCacheHelper.setCtx(this.ctx);
        HashSet<String> selectAllDim = new HashSet<String>();
        HashMap<String, Map<Integer, Set<String>>> queryMap = new HashMap<String, Map<Integer, Set<String>>>();
        HashSet<String> variSet = new HashSet<String>();
        HashSet<String> propSet = new HashSet<String>();
        HashSet<String> otherSet = new HashSet<String>();
        ArrayList<MbgViewListDimensionInfo> periodAliasDims = new ArrayList<MbgViewListDimensionInfo>();
        List<BgDimensionInfo> alldims = this.schemeHelper.getAllDimensions();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < alldims.size(); ++i) {
            map.put(alldims.get(i).getNumber(), alldims.get(i).getName());
        }
        for (int index = 0; index < viewManager.getSheetManagers().size(); ++index) {
            MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(index)).getDimensionManager();
            List<MbgViewListDimensionInfo> dimensions = dimensionManager.getAllDimensions();
            for (int m = 0; m < dimensions.size(); ++m) {
                MbgViewListDimensionInfo dim = dimensions.get(m);
                if (!map.containsKey(dim.getNumber())) continue;
                dim.setName((String)map.get(dim.getNumber()));
                dim.setAlias((String)map.get(dim.getNumber()));
            }
        }
        this.prepareRelationMember(viewManager, queryMap);
        this.prepareMember(viewManager, selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
        Map<String, List<BgDimensionMember>> variMembers = this.queryVariateMember(conn, orgId, variSet, false);
        Map<String, List<BgDimensionMember>> propMembers = this.queryPropertyMember(conn, orgId, propSet);
        HashMap<String, Map<String, BgDimensionMember>> members = new HashMap<String, Map<String, BgDimensionMember>>();
        this.queryAllMember(conn, orgId, members, selectAllDim, viewManager);
        this.queryMember(conn, orgId, members, queryMap, viewManager);
        if (isOnlyLeaf) {
            this.setOtherLeaf(this.ctx, orgId, members);
        }
        Map<String, Node> treeNodes = this.parseTreeNode(members, otherSet);
        this.parseMember(orgId, viewManager, members, treeNodes, variMembers, propMembers, isOnlyLeaf);
        this.parseRelationMember(orgId, viewManager, members);
        this.parsePeriodAlias(conn, orgId, periodAliasDims);
    }

    private void parseRelationMember(String orgId, MbgViewListManager viewManager, Map<String, Map<String, BgDimensionMember>> members) {
        MbgViewListDimensionManager dimManager = null;
        List<IMbgViewListObject> rowCols = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            dimManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            this.parseRelationMember(orgId, dimManager.getPageRelationMaps(), dimManager.getPageDimension(), members);
            rowCols = dimManager.getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                this.parseRelationMember(orgId, ((MbgViewListRowCol)rowCols.get(i)).getRelationMaps(), ((MbgViewListRowCol)rowCols.get(i)).getDimensions(), members);
            }
        }
    }

    private void parseRelationMember(String orgId, List<MbgRelationMap> relationMaps, List dimensions, Map<String, Map<String, BgDimensionMember>> members) {
        if (relationMaps == null || relationMaps.isEmpty() || members == null || members.isEmpty()) {
            return;
        }
        HashMap hasMembers = new HashMap();
        MbgViewListDimensionInfo dimension = null;
        HashSet<String> subSet = null;
        for (int d = 0; d < dimensions.size(); ++d) {
            if (!(dimensions.get(d) instanceof MbgViewListDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimension = (MbgViewListDimensionInfo)dimensions.get(d)).getNumber()) || DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
            subSet = new HashSet<String>();
            hasMembers.put(dimension.getNumber(), subSet);
            for (int m = 0; m < dimension.getMember().size(); ++m) {
                subSet.add(((BgDimensionMember)dimension.getMember().get(m)).getNumber());
            }
        }
        Map<String, BgDimensionInfo> dimMap = this.schemeHelper.getDimensionBySrcNumber();
        HashMap<String, MbgViewListDimensionInfo> dimensionMap = new HashMap<String, MbgViewListDimensionInfo>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
            dimension = (MbgViewListDimensionInfo)dimensions.get(i);
            dimensionMap.put(dimension.getNumber(), dimension);
        }
        HashMap relationShips = new HashMap();
        List subRelationList = null;
        BgDimensionMember[] subMember = null;
        MbgRelationMap relationMap = null;
        DimensionRelationshipInfo info = null;
        String[] combins = null;
        String dimNumber2 = null;
        String srcNumber = null;
        String number = null;
        BgDimensionMember curMember = null;
        for (int r = 0; r < relationMaps.size(); ++r) {
            relationMap = relationMaps.get(r);
            block4: for (int s = relationMap.getRelationShips().size() - 1; s >= 0; --s) {
                int c;
                info = relationMap.getRelationShips().get(s);
                combins = DimensionFormulaHelper.splitCombinations(info.getDimensionNumber());
                subMember = new BgDimensionMember[combins.length];
                for (c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    dimNumber2 = dimMap.get(srcNumber).getNumber();
                    if (members.containsKey(dimNumber2) && members.get(dimNumber2).containsKey(number) || DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber2) && BgPeriodNVariableHelper.checkCanConvert((String)number)) {
                        if (hasMembers.containsKey(dimNumber2) && !((Set)hasMembers.get(dimNumber2)).contains(number)) continue block4;
                        if (members.get(dimNumber2).get(number) != null) {
                            subMember[c] = members.get(dimNumber2).get(number);
                            continue;
                        }
                        if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber2) || !BgPeriodNVariableHelper.checkCanConvert((String)number)) continue;
                        curMember = new BgDimensionMember(DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.DEF_PERIOD_FIELD, number, number);
                        curMember.setSrcNumber(DimensionConstants.DEF_PERIOD_SRCNUMBER);
                        subMember[c] = curMember;
                        continue;
                    }
                    relationMap.getRelationShips().removeObject(s);
                    continue block4;
                }
                for (c = 0; c < subMember.length; ++c) {
                    dimension = (MbgViewListDimensionInfo)dimensionMap.get(subMember[c].getType());
                    if (!DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
                    if (!relationShips.containsKey(subMember[c].getType())) {
                        relationShips.put(subMember[c].getType(), new ArrayList());
                    }
                    if ((subRelationList = (List)relationShips.get(subMember[c].getType())).contains(subMember[c])) continue;
                    subRelationList.add(subMember[c]);
                }
            }
        }
        for (String dimNumber2 : relationShips.keySet()) {
            ((MbgViewListDimensionInfo)dimensionMap.get(dimNumber2)).getMember().clear();
            subRelationList = (List)relationShips.get(dimNumber2);
            MbgViewListDimensionMember.addMembers(subRelationList, ((MbgViewListDimensionInfo)dimensionMap.get(dimNumber2)).getMember(), dimensionMap.get(dimNumber2), true, false);
            ((MbgViewListDimensionInfo)dimensionMap.get(dimNumber2)).getSelectMembers().clear();
            MbgViewListDimensionMember.addMembers(subRelationList, ((MbgViewListDimensionInfo)dimensionMap.get(dimNumber2)).getSelectMembers(), dimensionMap.get(dimNumber2), true, false);
        }
    }

    private void prepareRelationMember(MbgViewListManager viewManager, Map<String, Map<Integer, Set<String>>> queryMap) throws EASBizException, BOSException {
        MbgViewListDimensionManager dimManager = null;
        List<IMbgViewListObject> rowCols = null;
        String _orgId = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            dimManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager();
            this.prepareRelationMember(this.orgId, dimManager.getPageRelationMaps(), queryMap, viewManager.isNeedReadRelation());
            rowCols = dimManager.getRowCols();
            for (int i = 0; i < rowCols.size(); ++i) {
                BgDimensionMember _member;
                if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
                BgDimensionBaseInfo dimension = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, ((MbgViewListRowCol)rowCols.get(i)).getDimensions());
                _orgId = this.orgId;
                if (dimension != null && dimension.getMember().size() == 1 && dimension.getMember().get(0) instanceof BgDimensionMember && BOSUuid.isValid((String)(_member = (BgDimensionMember)dimension.getMember().get(0)).getAttribute(), (boolean)true)) {
                    _orgId = _member.getAttribute();
                }
                this.prepareRelationMember(_orgId, ((MbgViewListRowCol)rowCols.get(i)).getRelationMaps(), queryMap, viewManager.isNeedReadRelation());
            }
        }
    }

    private void prepareRelationMember(String orgId, List<MbgRelationMap> relationMaps, Map<String, Map<Integer, Set<String>>> queryMap, boolean isReadRelation) throws EASBizException, BOSException {
        if (relationMaps == null || relationMaps.isEmpty() || queryMap == null) {
            return;
        }
        Map<String, BgDimensionInfo> dimMap = this.schemeHelper.getDimensionBySrcNumber();
        MbgRelationMap relationMap = null;
        DimensionRelationshipInfo info = null;
        String[] combins = null;
        String srcNumber = null;
        String number = null;
        String dimNumber = null;
        for (int i = 0; i < relationMaps.size(); ++i) {
            relationMap = relationMaps.get(i);
            if (isReadRelation && relationMap.getRelationShips().isEmpty() && (relationMap.isFillWhereNull() || this.isQueryAllRelation)) {
                relationMap.getRelationShips().addObjectCollection((IObjectCollection)this.getAllRelations(orgId, this.relationCachHelper.getRelationGroup(relationMap.getGroup().getId().toString())));
            }
            for (int s = 0; s < relationMap.getRelationShips().size(); ++s) {
                info = relationMap.getRelationShips().get(s);
                combins = DimensionFormulaHelper.splitCombinations(info.getDimensionNumber());
                for (int c = 0; c < combins.length; ++c) {
                    srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                    number = DimensionFormulaHelper.getMemberNumber(combins[c]);
                    dimNumber = dimMap.get(srcNumber).getNumber();
                    this.addQueryMember(queryMap, dimNumber, number, 0);
                }
            }
        }
    }

    private void setOtherLeaf(Context ctx, String orgId, Map<String, Map<String, BgDimensionMember>> members) throws EASBizException, BOSException {
        HashMap queryMap = new HashMap();
        String dimNumber2 = null;
        String srcNumber = null;
        BgDimensionMember member2 = null;
        HashSet<String> subSet = null;
        for (String dimNumber2 : members.keySet()) {
            srcNumber = this.schemeHelper.getSrcNumber(dimNumber2);
            if (!DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber) && !DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber) && !DimensionConstants.DEF_VERSION_SRCNUMBER.equals(srcNumber)) continue;
            subSet = new HashSet<String>();
            queryMap.put(srcNumber, subSet);
            for (BgDimensionMember member2 : members.get(dimNumber2).values()) {
                subSet.add(member2.getNumber());
            }
        }
        Map leafMap = DimensionFormulaFacadeFactory.getLocalInstance(ctx).getLeafMember(orgId, this.schemeHelper.getBgSchemeId(), queryMap, this.schemeHelper.getDimensionBySrcNumber(), false);
        for (String dimNumber2 : members.keySet()) {
            srcNumber = this.schemeHelper.getSrcNumber(dimNumber2);
            if (!DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber) && !DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber) && !DimensionConstants.DEF_VERSION_SRCNUMBER.equals(srcNumber)) continue;
            subSet = leafMap != null ? (Set)leafMap.get(srcNumber) : new HashSet();
            for (BgDimensionMember member2 : members.get(dimNumber2).values()) {
                if (subSet != null && subSet.contains(member2.getNumber())) {
                    member2.setLeaf(true);
                    continue;
                }
                member2.setLeaf(false);
            }
        }
    }

    private void parsePeriodAlias(Connection conn, String orgId, List<MbgViewListDimensionInfo> periodAliasDims) throws BOSException {
        BgDimensionMember member;
        MbgViewListDimensionInfo dimension;
        if (periodAliasDims == null || periodAliasDims.isEmpty()) {
            return;
        }
        HashMap<String, String> alias = new HashMap<String, String>();
        for (int d = 0; d < periodAliasDims.size(); ++d) {
            dimension = periodAliasDims.get(d);
            for (int m = 0; m < dimension.getMember().size(); ++m) {
                member = (BgDimensionMember)dimension.getMember().get(m);
                alias.put(member.getNumber(), member.getName());
            }
        }
        Set<String> periodTypeIds = BgSchemeDimensionHelper.getMemberSet(this.schemeHelper.getDimension(DimensionConstants.DEF_PERIOD_NUMBER), false);
        StringBuffer sql = new StringBuffer();
        sql.append("Select FNumber, FAlias FROM T_Mbg_BgPeriodDisp Where FTypeId IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)periodTypeIds.size()).append(") ");
        sql.append("And FNumber IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        List paramList = MbgSqlHelper.getBatchParams((Object[])periodTypeIds.toArray(), (Object[])alias.keySet().toArray(), (int)50);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < paramList.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    alias.put(rst.getString("FNumber"), rst.getString("FAlias"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        for (int d = 0; d < periodAliasDims.size(); ++d) {
            dimension = periodAliasDims.get(d);
            for (int m = 0; m < dimension.getMember().size(); ++m) {
                member = (BgDimensionMember)dimension.getMember().get(m);
                member.setAlias((String)alias.get(member.getNumber()));
            }
        }
    }

    public void prepareMember(MbgViewListManager viewManager, Set<String> selectAllDim, Map<String, Map<Integer, Set<String>>> queryMap, Set<String> variSet, Set<String> propSet, Set<String> otherSet, List<MbgViewListDimensionInfo> periodAliasDims) {
        if (viewManager == null) {
            return;
        }
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            this.prepareMember((MbgViewListSheetManager)viewManager.getSheetManagers().get(s), selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
        }
    }

    private void prepareMember(MbgViewListSheetManager sheetManager, Set<String> selectAllDim, Map<String, Map<Integer, Set<String>>> queryMap, Set<String> variSet, Set<String> propSet, Set<String> otherSet, List<MbgViewListDimensionInfo> periodAliasDims) {
        ArrayList dimensions = new ArrayList();
        dimensions.addAll(sheetManager.getDimensionManager().getPageDimension());
        dimensions.addAll(sheetManager.getDimensionManager().getViewDimension());
        MbgViewListDimensionInfo dimension = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(sheetManager.getDimensionManager().getDimension().get(i) instanceof MbgViewListDimensionInfo)) continue;
            dimension = (MbgViewListDimensionInfo)dimensions.get(i);
            this.prepareMember(dimension, selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
        }
        List<IMbgViewListObject> rowCols = sheetManager.getDimensionManager().getRowCols();
        MbgViewListRowCol row = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
            row = (MbgViewListRowCol)rowCols.get(i);
            if (row.isCombin()) {
                this.prepareCombinMember(row, queryMap);
                continue;
            }
            for (int d = 0; d < row.getDimensions().size(); ++d) {
                this.prepareMember(row.getDimensions().get(d), selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
            }
        }
        dimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, sheetManager.getDimensionManager().getDimension());
        if (!"ALIAS".equals(dimension.getShowType())) {
            periodAliasDims.clear();
        }
    }

    private void parseMember(String orgId, MbgViewListManager viewManager, Map<String, Map<String, BgDimensionMember>> members, Map<String, Node> treeNodes, Map<String, List<BgDimensionMember>> variMembers, Map<String, List<BgDimensionMember>> propMembers, boolean isOnlyLeaf) throws EASBizException, BOSException {
        if (viewManager == null) {
            return;
        }
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            this.parseMember(orgId, (MbgViewListSheetManager)viewManager.getSheetManagers().get(s), members, treeNodes, variMembers, propMembers, isOnlyLeaf);
        }
    }

    private void parseMember(String orgId, MbgViewListSheetManager sheetManager, Map<String, Map<String, BgDimensionMember>> members, Map<String, Node> treeNodes, Map<String, List<BgDimensionMember>> variMembers, Map<String, List<BgDimensionMember>> propMembers, boolean isOnlyLeaf) throws EASBizException, BOSException {
        ArrayList dimensions = new ArrayList();
        dimensions.addAll(sheetManager.getDimensionManager().getPageDimension());
        dimensions.addAll(sheetManager.getDimensionManager().getViewDimension());
        MbgViewListDimensionInfo dimension = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(sheetManager.getDimensionManager().getDimension().get(i) instanceof MbgViewListDimensionInfo) || !sheetManager.isParserDimension((dimension = (MbgViewListDimensionInfo)dimensions.get(i)).getNumber())) continue;
            this.parseMember(orgId, dimension, null, members, variMembers, propMembers, treeNodes, isOnlyLeaf);
        }
        List<IMbgViewListObject> rowCols = sheetManager.getDimensionManager().getRowCols();
        MbgViewListRowCol row = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
            row = (MbgViewListRowCol)rowCols.get(i);
            if (row.isCombin()) {
                ViewlistCombinHelper.parseCombinMembers(row, members);
                continue;
            }
            for (int d = 0; d < row.getDimensions().size(); ++d) {
                if (!sheetManager.isParserDimension(row.getDimensions().get(d).getNumber())) continue;
                this.parseMember(orgId, row.getDimensions().get(d), row, members, variMembers, propMembers, treeNodes, isOnlyLeaf);
            }
        }
    }

    private void parseMember(String orgId, MbgViewListDimensionInfo dimension, MbgViewListRowCol rowObject, Map<String, Map<String, BgDimensionMember>> members, Map<String, List<BgDimensionMember>> variMembers, Map<String, List<BgDimensionMember>> propMembers, Map<String, Node> treeNodes, boolean isOnlyLeaf) throws EASBizException, BOSException {
        String key;
        ArrayList<BgDimensionMember> subList = new ArrayList<BgDimensionMember>();
        if (BgMemberSelectTypeEnum.Variate.equals((Object)dimension.getMemberType())) {
            dimension.getMember().clear();
            for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                if (dimension.getSelectMembers().get(i) instanceof BgVariateInfo) {
                    subList.clear();
                    key = ((BgVariateInfo)dimension.getSelectMembers().get(i)).getId().toString();
                    if (this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), key, -1) != null) {
                        subList.addAll(this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), key, -1));
                    } else {
                        if (variMembers.containsKey(key)) {
                            for (int x = 0; x < variMembers.get(key).size(); ++x) {
                                if (!dimension.getNumber().equals(variMembers.get(key).get(x).getType())) continue;
                                subList.add(variMembers.get(key).get(x));
                            }
                        }
                        this.memberCacheHelper.putMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), key, -1, variMembers.get(key));
                    }
                    MbgViewListDimensionMember.addMembers(subList, dimension.getMember(), dimension.getSelectMembers().get(i), false, isOnlyLeaf);
                    continue;
                }
                if (!(dimension.getSelectMembers().get(i) instanceof BgDimensionMember)) continue;
                MbgViewListDimensionMember.addMember((BgDimensionMember)dimension.getSelectMembers().get(i), dimension.getMember(), dimension.getSelectMembers().get(i), isOnlyLeaf);
            }
        } else if (BgMemberSelectTypeEnum.Property.equals((Object)dimension.getMemberType())) {
            if (!dimension.getSelectMembers().isEmpty()) {
                dimension.getMember().clear();
                Map existMembers = null;
                if (!DimensionConstants.necessary.contains(dimension.getNumber())) {
                    HashSet<String> propertiesNumber = new HashSet<String>();
                    List<BgDimensionMember> list = null;
                    Set<String> keySet = propMembers.keySet();
                    for (String temp : keySet) {
                        list = propMembers.get(temp);
                        for (int k = 0; k < list.size(); ++k) {
                            propertiesNumber.add(list.get(k).getNumber());
                        }
                    }
                    IDimensionFormulaFacade facade = null;
                    facade = this.ctx == null ? DimensionFormulaFacadeFactory.getRemoteInstance() : DimensionFormulaFacadeFactory.getLocalInstance(this.ctx);
                    existMembers = facade.queryMembers(orgId, this.schemeHelper, dimension.getNumber(), propertiesNumber, false, null);
                }
                for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                    if (dimension.getSelectMembers().get(i) instanceof BgPropertyInfo) {
                        subList.clear();
                        key = ((BgPropertyInfo)dimension.getSelectMembers().get(i)).getId().toString();
                        if (this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), key, -1) != null) {
                            subList.addAll(this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), key, -1));
                        } else if (propMembers.containsKey(key)) {
                            subList.addAll((Collection<BgDimensionMember>)propMembers.get(key));
                        }
                        this.filterDisable(this.formCreateTime, subList);
                        for (int j = 0; j < subList.size(); ++j) {
                            if (existMembers == null || existMembers.isEmpty() || existMembers.containsKey(((BgDimensionMember)subList.get(j)).getNumber())) continue;
                            subList.remove(j);
                            --j;
                        }
                        MbgViewListDimensionMember.addMembers(subList, dimension.getMember(), dimension.getSelectMembers().get(i), false, isOnlyLeaf);
                        continue;
                    }
                    if (!(dimension.getSelectMembers().get(i) instanceof BgDimensionMember)) continue;
                    MbgViewListDimensionMember.addMember((BgDimensionMember)dimension.getSelectMembers().get(i), dimension.getMember(), dimension.getSelectMembers().get(i), isOnlyLeaf);
                }
            } else if (!dimension.getMember().isEmpty()) {
                subList.clear();
                subList.addAll(dimension.getMember());
                dimension.getMember().clear();
                for (int i = 0; i < subList.size(); ++i) {
                    if (subList.get(i) instanceof BgDimensionMember) {
                        dimension.getMember().add(MbgViewListDimensionMember.getInstance((BgDimensionMember)subList.get(i)));
                        continue;
                    }
                    if (!(subList.get(i) instanceof MbgViewListDimensionMember)) continue;
                    dimension.getMember().add(subList.get(i));
                }
            }
        } else if (BgMemberSelectTypeEnum.Member.equals((Object)dimension.getMemberType())) {
            BgDimensionMember curMember;
            Map<String, BgDimensionMember> subMap;
            HashMap<String, BgDimensionMember> oldDimMap = new HashMap<String, BgDimensionMember>();
            for (int x = 0; x < dimension.getMember().size(); ++x) {
                if (!(dimension.getMember().get(x) instanceof BgDimensionMember)) continue;
                oldDimMap.put(((BgDimensionMember)dimension.getMember().get(x)).getNumber(), (BgDimensionMember)dimension.getMember().get(x));
            }
            dimension.getMember().clear();
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                if (DimensionMemberValueModeEnum.All.equals((Object)dimension.getMemberValueType())) {
                    subList.clear();
                    if (this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1) != null) {
                        subList.addAll(this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1));
                    } else {
                        subMap = members.get(dimension.getNumber());
                        subList.addAll(subMap.values());
                        this.memberCacheHelper.putMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1, new ArrayList<BgDimensionMember>(subMap.values()));
                    }
                    MbgViewListDimensionMember.addMembers(subList, dimension.getMember(), dimension, true, isOnlyLeaf);
                } else {
                    subMap = members.get(dimension.getNumber());
                    for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                        if (dimension.getSelectMembers().get(i) instanceof BgDimensionMember) {
                            curMember = (BgDimensionMember)dimension.getSelectMembers().get(i);
                            if (curMember != null && oldDimMap.containsKey(curMember.getNumber())) {
                                curMember.setVersion(((BgDimensionMember)oldDimMap.get(curMember.getNumber())).getVersion());
                            }
                        } else {
                            BgPeriodInfo periodInfo = (BgPeriodInfo)dimension.getSelectMembers().get(i);
                            curMember = new BgDimensionMember(dimension.getNumber(), dimension.getRefField(), periodInfo.getName(), periodInfo.getNumber());
                            if (curMember != null && oldDimMap.containsKey(curMember.getNumber())) {
                                curMember.setVersion(((BgDimensionMember)oldDimMap.get(curMember.getNumber())).getVersion());
                            }
                            if (periodInfo.get("versionNum") instanceof BigDecimal) {
                                curMember.setVersion(periodInfo.getBigDecimal("versionNum"));
                            }
                        }
                        if (this.isReParsePeriod && (subMap == null || !subMap.containsKey(curMember.getNumber()))) continue;
                        MbgViewListDimensionMember.addMember(curMember, dimension.getMember(), dimension.getSelectMembers().get(i), isOnlyLeaf);
                    }
                }
            } else {
                subMap = members.get(dimension.getNumber());
                Node rootNode = treeNodes.get(dimension.getNumber());
                if (DimensionMemberValueModeEnum.All.equals((Object)dimension.getMemberValueType())) {
                    subList.clear();
                    if (this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1) != null) {
                        subList.addAll(this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1));
                    } else {
                        if (subMap != null) {
                            subList.addAll(subMap.values());
                        }
                        this.memberCacheHelper.putMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1, new ArrayList<BgDimensionMember>(subList));
                    }
                    MbgViewListDimensionMember.addMembers(subList, dimension.getMember(), dimension, true, isOnlyLeaf);
                } else if (!dimension.getSelectMembers().isEmpty()) {
                    for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                        curMember = (BgDimensionMember)dimension.getSelectMembers().get(i);
                        if (curMember == null || curMember.getNumber() == null) continue;
                        subList.clear();
                        if (this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), curMember.getNumber(), curMember.getFillType()) != null) {
                            subList.addAll(this.memberCacheHelper.getMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), curMember.getNumber(), curMember.getFillType()));
                        } else {
                            this.buildMember(subList, curMember, subMap, rootNode);
                            this.memberCacheHelper.putMembers(dimension.getNumber(), orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), curMember.getNumber(), curMember.getFillType(), new ArrayList<BgDimensionMember>(subList));
                        }
                        for (int y = 0; y < subList.size(); ++y) {
                            if (!oldDimMap.containsKey(((BgDimensionMember)subList.get(y)).getNumber())) continue;
                            ((BgDimensionMember)subList.get(y)).setVersion(((BgDimensionMember)oldDimMap.get(((BgDimensionMember)subList.get(y)).getNumber())).getVersion());
                        }
                        MbgViewListDimensionMember.addMembers(subList, dimension.getMember(), curMember, true, isOnlyLeaf);
                    }
                }
            }
        }
        String refField = this.schemeHelper.getRefField(dimension.getNumber());
        String srcNumber = this.schemeHelper.getSrcNumber(dimension.getNumber());
        for (int i = 0; i < dimension.getMember().size(); ++i) {
            MbgViewListDimensionMember member = (MbgViewListDimensionMember)dimension.getMember().get(i);
            member.setType(dimension.getNumber());
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) {
                member.setAttribute(refField);
            }
            member.setSrcNumber(srcNumber);
            this.setLevelConfig(member, rowObject);
        }
    }

    private void setLevelConfig(MbgViewListDimensionMember member, MbgViewListRowCol rowObject) {
        if (member == null || rowObject == null) {
            return;
        }
        Integer level = rowObject.getLevelConfig(member.getType(), member.getSource());
        if (level != null) {
            member.setLevel(member.getLevel() + level);
        }
    }

    private List<BgDimensionMember> buildMember(List<BgDimensionMember> subList, BgDimensionMember curMember, Map<String, BgDimensionMember> subMap, Node rootNode) {
        if (subList == null) {
            subList = new ArrayList<BgDimensionMember>();
        } else {
            subList.clear();
        }
        BgDimensionMember self = subMap.get(curMember.getNumber());
        if (self == null) {
            return subList;
        }
        if (curMember.getFillType() == 0) {
            subList.add(self);
        } else if (curMember.getFillType() == 1) {
            this.buildChildMember(subList, self, rootNode, true, false);
        } else if (curMember.getFillType() == 4) {
            this.buildChildMember(subList, self, rootNode, false, false);
        } else if (curMember.getFillType() == 2) {
            this.buildChildMember(subList, self, rootNode, true, true);
        } else if (curMember.getFillType() == 5) {
            this.buildChildMember(subList, self, rootNode, false, true);
        } else if (curMember.getFillType() == 3) {
            this.buildEqualMember(subList, self, rootNode, true);
        } else if (curMember.getFillType() == 6) {
            this.buildEqualMember(subList, self, rootNode, false);
        }
        this.filterDisable(this.formCreateTime, subList);
        Collections.sort(subList);
        return subList;
    }

    private List<BgDimensionMember> filterDisable(Timestamp formCreateTime, List<BgDimensionMember> subList) {
        BgDimensionMember member = null;
        if (formCreateTime == null) {
            for (int i = 0; i < subList.size(); ++i) {
                member = subList.get(i);
                if (member.getDisabledDate() == null) continue;
                subList.remove(i);
                --i;
            }
        } else {
            for (int i = 0; i < subList.size(); ++i) {
                member = subList.get(i);
                if (member.getDisabledDate() == null || this.tMax == null || member.getDisabledDate().getTime() >= this.tMax.getTime()) continue;
                subList.remove(i);
                --i;
            }
        }
        return subList;
    }

    private void buildEqualMember(List<BgDimensionMember> subList, BgDimensionMember self, Node rootNode, boolean needSubSelf) {
        Node thisNode = rootNode.searchNode((String)((Object)self.getSortValue()));
        this.buildEqualMember(subList, needSubSelf ? self : null, thisNode.getParent(), thisNode.getLevel());
    }

    private void buildEqualMember(List<BgDimensionMember> subList, BgDimensionMember noEquals, Node node, int level) {
        if (node.getLevel() == level) {
            if (node.getMember() != null && node.getMember() != noEquals) {
                subList.add(node.getMember());
            }
        } else if (node.getLevel() < level) {
            Iterator<Node> it = node.getChildNode().values().iterator();
            while (it.hasNext()) {
                this.buildEqualMember(subList, noEquals, it.next(), level);
            }
        }
    }

    private void buildChildMember(List<BgDimensionMember> subList, BgDimensionMember self, Node rootNode, boolean needSubSelf, boolean isAllChild) {
        if (!needSubSelf) {
            subList.add(self);
        }
        Node thisNode = rootNode.searchNode((String)((Object)self.getSortValue()));
        this.buildChildMember(subList, thisNode, isAllChild);
    }

    private void buildChildMember(List<BgDimensionMember> subList, Node thisNode, boolean isAllChild) {
        Node childNode2 = null;
        for (Node childNode2 : thisNode.getChildNode().values()) {
            if (childNode2.getMember() != null) {
                subList.add(childNode2.getMember());
            }
            if (!isAllChild) continue;
            this.buildChildMember(subList, childNode2, isAllChild);
        }
    }

    private Map<String, Node> parseTreeNode(Map<String, Map<String, BgDimensionMember>> members, Set<String> otherSet) throws EASBizException, BOSException {
        HashMap<String, Node> result = new HashMap<String, Node>();
        for (String dimNumber : otherSet) {
            Map<String, BgDimensionMember> subMap = members.get(dimNumber);
            if (subMap == null || subMap.isEmpty()) continue;
            result.put(dimNumber, Node.buildNode(subMap.values()));
        }
        return result;
    }

    public void queryMember(Connection conn, String orgId, Map<String, Map<String, BgDimensionMember>> members, Map<String, Map<Integer, Set<String>>> queryMap, MbgViewListManager viewManager) throws EASBizException, BOSException {
        this.queryMember(conn, orgId, members, queryMap, null, viewManager);
    }

    public void queryMember(Connection conn, String orgId, Map<String, Map<String, BgDimensionMember>> members, Map<String, Map<Integer, Set<String>>> queryMap, Map<String, Boolean> queryByName, MbgViewListManager viewManager) throws EASBizException, BOSException {
        this.queryMember(conn, orgId, members, queryMap, null, viewManager, null);
    }

    public void queryMember(Connection conn, String orgId, Map<String, Map<String, BgDimensionMember>> members, Map<String, Map<Integer, Set<String>>> queryMap, Map<String, Boolean> queryByName, MbgViewListManager viewManager, List dimensions) throws EASBizException, BOSException {
        if (this.getMemberCacheHelper() != null) {
            this.getMemberCacheHelper().setCtx(this.ctx);
        }
        Map<String, Set<String>> canAddMemberNumbers = this.getCanAddMemberNumbers(dimensions);
        for (String dimNumber : queryMap.keySet()) {
            if (viewManager != null && !viewManager.isParserDimension(dimNumber)) continue;
            BgDimensionInfo dim = this.schemeHelper.getDimensionOnCheck(dimNumber);
            DimensionFilterHelper helper = this.getFilterHelper(dimNumber, orgId);
            IDataProvider biz = helper.getQueryExecutor();
            Map<Integer, Set<String>> subMap = queryMap.get(dimNumber);
            if (!members.containsKey(dimNumber)) {
                members.put(dimNumber, new HashMap());
            }
            Map<String, BgDimensionMember> memberCol = members.get(dimNumber);
            Object[] fillTypes = subMap.keySet().toArray(new Integer[0]);
            Arrays.sort(fillTypes);
            BgDimensionMember member = null;
            for (int f = 0; f < fillTypes.length; ++f) {
                String[] numbers = subMap.get(fillTypes[f]).toArray(new String[0]);
                int batchCount = MbgSqlHelper.getBatchCount((int)numbers.length);
                for (int b = 0; b < batchCount; ++b) {
                    int index;
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setSelector(helper.getSelector());
                    if (this.getMemberCacheHelper().getDimViewCacheMap().containsKey(dim.getViewId())) {
                        helper.setSegregationRule(this.getMemberCacheHelper().getDimViewCacheMap().get(dim.getViewId()).getSegregationRule().getValue());
                        evi.setFilter(helper.getFilter(this.getMemberCacheHelper().getDimViewCacheMap().get(dim.getViewId()).getSegregationRule().getValue() != 1));
                    } else {
                        evi.setFilter(helper.getFilter());
                    }
                    HashSet<String> filterNumber = new HashSet<String>();
                    StringBuffer maskString = new StringBuffer();
                    int count = evi.getFilter().getFilterItems().size();
                    if (!StringUtils.isEmpty((String)evi.getFilter().getMaskString())) {
                        maskString.append(evi.getFilter().getMaskString());
                    } else {
                        for (int i = 0; i < count; ++i) {
                            if (i > 0) {
                                maskString.append(" and ");
                            }
                            maskString.append("#").append(i);
                        }
                    }
                    if (count > 0) {
                        maskString.append(" and ");
                    }
                    maskString.append("(");
                    boolean isFirst = true;
                    for (int i = 0; i < 50 && (index = b * 50 + i) < numbers.length; ++i) {
                        if ((Integer)fillTypes[f] == 0 || !helper.isTreeBase()) {
                            filterNumber.add(numbers[index]);
                            continue;
                        }
                        if (!memberCol.containsKey(numbers[index])) continue;
                        member = memberCol.get(numbers[index]);
                        member.setFillType((Integer)fillTypes[f]);
                        String longNumber = (String)((Object)member.getSortValue());
                        if (!isFirst) {
                            maskString.append("  or ");
                        }
                        if ((Integer)fillTypes[f] == 3 || (Integer)fillTypes[f] == 6) {
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "level", (Object)member.getLevel()));
                            maskString.append("#").append(count++);
                        } else if ((Integer)fillTypes[f] == 2 || (Integer)fillTypes[f] == 5) {
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                            maskString.append("#").append(count++);
                        } else if ((Integer)fillTypes[f] == 1 || (Integer)fillTypes[f] == 4) {
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + "level", (Object)(member.getLevel() + 1)));
                            maskString.append("(#").append(count++).append(" and #").append(count++).append(")");
                        }
                        isFirst = false;
                    }
                    boolean needQuery = false;
                    if ((Integer)fillTypes[f] == 0 || !helper.isTreeBase()) {
                        filterNumber.remove(null);
                        if (!filterNumber.isEmpty()) {
                            String numberField = "number";
                            if (queryByName != null && queryByName.get(dimNumber).booleanValue()) {
                                numberField = "name";
                            }
                            evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + numberField, filterNumber, CompareType.INCLUDE));
                            maskString.append("#").append(count).append(")");
                            evi.getFilter().setMaskString(maskString.toString());
                            needQuery = true;
                        }
                    } else if (!isFirst) {
                        needQuery = true;
                        maskString.append(")");
                        evi.getFilter().setMaskString(maskString.toString());
                    }
                    if (!needQuery) continue;
                    biz.setObjectView(evi);
                    try {
                        this.readMember(memberCol, helper, this.schemeHelper, biz, queryByName != null ? queryByName.get(dimNumber) : null, canAddMemberNumbers != null ? canAddMemberNumbers.get(dimNumber) : null);
                        continue;
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
    }

    private void queryAllMember(Connection conn, String orgId, Map<String, Map<String, BgDimensionMember>> members, Set<String> selectAllDim, MbgViewListManager viewManager) throws EASBizException, BOSException {
        try {
            for (String dimNumber : selectAllDim) {
                if (!viewManager.isParserDimension(dimNumber)) continue;
                DimensionFilterHelper helper = this.getFilterHelper(dimNumber, orgId);
                IDataProvider biz = helper.getQueryExecutor();
                EntityViewInfo evi = helper.getEntityView();
                biz.setObjectView(evi);
                if (!members.containsKey(dimNumber)) {
                    members.put(dimNumber, new HashMap());
                }
                this.readMember(members.get(dimNumber), helper, this.schemeHelper, biz);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void readMember(Map<String, BgDimensionMember> dimensionMembers, DimensionFilterHelper helper, BgSchemeDimensionHelper schemeHelper, IDataProvider biz) throws BOSException, DimensionException, SQLException {
        this.readMember(dimensionMembers, helper, schemeHelper, biz, null);
    }

    protected void readMember(Map<String, BgDimensionMember> dimensionMembers, DimensionFilterHelper helper, BgSchemeDimensionHelper schemeHelper, IDataProvider biz, Boolean queryByName) throws BOSException, DimensionException, SQLException {
        this.readMember(dimensionMembers, helper, schemeHelper, biz, null, null);
    }

    protected void readMember(Map<String, BgDimensionMember> dimensionMembers, DimensionFilterHelper helper, BgSchemeDimensionHelper schemeHelper, IDataProvider biz, Boolean queryByName, Set<String> canAddMemberNumbers) throws BOSException, DimensionException, SQLException {
        IRowSet rs = null;
        try {
            rs = biz.executeQuery();
        }
        catch (FindedTooMuchRecordsException e) {
            logger.error((Object)"", (Throwable)e);
            throw new DimensionException(DimensionException.MEMBEROOMUCHRECORDS);
        }
        if (rs == null) {
            return;
        }
        ArrayList<String> periodList = new ArrayList<String>();
        HashSet<String> periodSet = new HashSet<String>();
        while (rs.next()) {
            String number = rs.getString(helper.getFieldFlag() + "number");
            String name = rs.getString(helper.getFieldFlag() + "name");
            if (number != null && canAddMemberNumbers != null && !canAddMemberNumbers.isEmpty() && !canAddMemberNumbers.contains(number)) continue;
            String longNumber = null;
            String longName = null;
            int level = 0;
            boolean isLeaf = true;
            if (helper.isTreeBase()) {
                longNumber = rs.getString(helper.getFieldFlag() + "longNumber");
                level = rs.getInt(helper.getFieldFlag() + "level");
                isLeaf = rs.getBoolean(helper.getFieldFlag() + "isLeaf");
                longName = rs.getString(helper.getFieldFlag() + "displayName");
            }
            if (queryByName != null && queryByName.booleanValue() && !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(helper.getDimension().getNumber())) {
                if (!periodList.contains(name)) {
                    periodList.add(name);
                } else {
                    periodSet.add(name);
                }
            }
            if (dimensionMembers.containsKey(queryByName != null && queryByName != false ? name : number) && (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(helper.getDimension().getNumber()) || name == null || dimensionMembers.get(number).getName() != null && dimensionMembers.get(number).getName().length() <= name.length())) continue;
            BgDimensionMember member = new BgDimensionMember(helper.getDimension().getNumber(), schemeHelper.getRefField(helper.getDimension().getNumber()), name, number);
            member.setFillType(0);
            member.setSrcNumber(schemeHelper.getSrcNumber(helper.getDimension().getNumber()));
            if (helper.isTreeBase()) {
                member.setSortValue((Comparable)((Object)longNumber));
                member.setLevel(level);
                member.setLeaf(isLeaf);
                member.setLongName(longName);
            }
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(member.getType()) && !DimensionCommonHelper.isOrgTreeDimension(helper.getDimension()).booleanValue()) {
                member.setAttribute(rs.getString(helper.getFieldFlag() + "orgUnitId"));
            }
            if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(member.getType()) || !DimensionBaseConstants.necessary.contains(member.getType())) {
                member.setDisabledDate(rs.getTimestamp(helper.getFieldFlag() + "disabledDate"));
            }
            dimensionMembers.put(queryByName != null && queryByName != false ? member.getName() : member.getNumber(), member);
        }
        if (queryByName != null && queryByName.booleanValue() && !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(helper.getDimension().getNumber())) {
            for (String periodName : periodSet) {
                if (!dimensionMembers.containsKey(periodName)) continue;
                dimensionMembers.remove(periodName);
            }
        }
    }

    public Map<String, Set<String>> getCanAddMemberNumbers(List dimensions) {
        if (dimensions == null) {
            return null;
        }
        HashMap<String, Set<String>> canAddNumbersMap = new HashMap<String, Set<String>>();
        for (Object tmp : dimensions) {
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)tmp;
            if (!canAddNumbersMap.containsKey(dim.getNumber())) {
                canAddNumbersMap.put(dim.getNumber(), new HashSet());
            }
            for (Object m : dim.getCanAddMember()) {
                ((Set)canAddNumbersMap.get(dim.getNumber())).add(BgViewHelper.getNumber(m));
            }
        }
        return canAddNumbersMap;
    }

    public Map<String, List<BgDimensionMember>> queryPropertyMember(Connection conn, String orgId, Set<String> propSet) throws EASBizException, BOSException {
        HashMap<String, List<BgDimensionMember>> result = new HashMap<String, List<BgDimensionMember>>();
        if (propSet == null || propSet.isEmpty()) {
            return result;
        }
        HashSet<String> newPropSet = new HashSet<String>(propSet);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String longNumber;
            String id;
            int i;
            StringBuffer sql = new StringBuffer();
            HashMap<String, Set<String>> childPropMap = new HashMap<String, Set<String>>();
            HashMap parentLongNumber = new HashMap();
            sql.setLength(0);
            sql.append("Select FID, FBgPropertySortID, FLongNumber, FIsLeaf FROM T_MBG_BgProperty Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FBgPropertySortID, FLongNumber");
            List paramList = MbgSqlHelper.getBatchParams(null, (Object[])newPropSet.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < paramList.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (rst.getBoolean("FIsLeaf")) continue;
                    id = rst.getString("FID");
                    String propSortId = rst.getString("FBgPropertySortID");
                    longNumber = rst.getString("FLongNumber") + "!%";
                    if (!parentLongNumber.containsKey(propSortId)) {
                        parentLongNumber.put(propSortId, new HashMap());
                    }
                    ((Map)parentLongNumber.get(propSortId)).put(longNumber, id);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            sql.setLength(0);
            sql.append("Select FID, FLongNumber FROM T_MBG_BgProperty Where FBgPropertySortID = ? AND (");
            for (i = 0; i < 50; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(" FLongNumber LIKE ? ");
            }
            sql.append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (String propSortId : parentLongNumber.keySet()) {
                paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{propSortId}, (Object[])((Map)parentLongNumber.get(propSortId)).keySet().toArray(), (int)50);
                for (int i2 = 0; i2 < paramList.size(); ++i2) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i2)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        id = rst.getString("FID");
                        newPropSet.add(id);
                        longNumber = rst.getString("FLongNumber");
                        this.addToParent(childPropMap, (Map)parentLongNumber.get(propSortId), id, longNumber);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            HashMap propMap = new HashMap();
            String sourceType2 = null;
            sql.setLength(0);
            sql.append("Select prop.FID, propSort.FSourceType,propSort.FSegregationRule  FROM T_MBG_BgProperty prop INNER JOIN T_MBG_BgPropertySort propSort ON propSort.FID = prop.FBgPropertySortID Where prop.FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            paramList = MbgSqlHelper.getBatchParams(null, (Object[])newPropSet.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i3 = 0; i3 < paramList.size(); ++i3) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i3)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    sourceType2 = rst.getString("FSourceType");
                    if (!propMap.containsKey(sourceType2)) {
                        propMap.put(sourceType2, new HashSet());
                    }
                    ((Set)propMap.get(sourceType2)).add(rst.getString("FID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            for (String sourceType2 : propMap.keySet()) {
                sql.setLength(0);
                if ("E68E9293".equals(sourceType2)) {
                    sql.append("Select acct.FID, acct.FNumber, acct.FName_" + this.ctx.getLocale() + " FName,acct.FDisplayName_" + this.ctx.getLocale() + " FDisplayName, acct.FLongNumber, acct.FIsLeaf, prop.FPropertyID ,acct.FDisabledDate FROM T_MBG_PropertyRefSource prop INNER JOIN T_MBG_BgAccount acct ON prop.FSourceID =  acct.FID Where acct.FBgAccountViewID = ? AND prop.FPropertyID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                    paramList = MbgSqlHelper.getBatchParams((Object[])new Object[]{this.schemeHelper.getDimensionOnCheck(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()}, (Object[])((Set)propMap.get(sourceType2)).toArray(), (int)50);
                } else {
                    if ("33F82845".equals(sourceType2)) continue;
                    if ("D177852B".equals(sourceType2)) {
                        int i4;
                        HashSet<String> propertyIDSet = new HashSet<String>();
                        HashSet<String> orgSegIDSet = new HashSet<String>();
                        HashSet<String> equSegIDSet = new HashSet<String>();
                        sql.setLength(0);
                        sql.append("Select prop.FID, propSort.FSegregationRule as segregationRule,v.FSegregationRule  FROM T_MBG_BgProperty prop INNER JOIN T_MBG_BgPropertySort propSort ON propSort.FID = prop.FBgPropertySortID INNER JOIN T_MBG_PropertyRefSource sour on sour.FPropertyID = prop.FID INNER JOIN T_MBG_MbgMember memb ON memb.FID = sour.FSourceID INNER JOIN T_MBG_MbgView v on v.FID = memb.FViewId Where prop.FID IN(");
                        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                        paramList = MbgSqlHelper.getBatchParams(null, (Object[])((Set)propMap.get(sourceType2)).toArray(), (int)50);
                        pstmt = conn.prepareStatement(sql.toString());
                        for (int i5 = 0; i5 < paramList.size(); ++i5) {
                            MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i5)));
                            rst = pstmt.executeQuery();
                            while (rst.next()) {
                                if (rst.getInt("segregationRule") == 0) {
                                    propertyIDSet.add(rst.getString("FID"));
                                    continue;
                                }
                                if (rst.getInt("FSegregationRule") == 2) {
                                    orgSegIDSet.add(rst.getString("FID"));
                                    continue;
                                }
                                if (rst.getInt("FSegregationRule") == 0) {
                                    equSegIDSet.add(rst.getString("FID"));
                                    continue;
                                }
                                propertyIDSet.add(rst.getString("FID"));
                            }
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                        if (!orgSegIDSet.isEmpty()) {
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            viewInfo.setFilter(new FilterInfo());
                            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
                            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", orgSegIDSet, CompareType.INCLUDE));
                            BgPropertyCollection colls = BgPropertyFactory.getLocalInstance((Context)this.ctx).getBgPropertyCollection(viewInfo);
                            for (i4 = 0; i4 < colls.size(); ++i4) {
                                propertyIDSet.add(colls.get(i4).getId().toString());
                            }
                        }
                        if (!equSegIDSet.isEmpty()) {
                            OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
                            Set parentAndChildOrgUnitIds = MbgDimHelper.getParentAndChildrenOrgUnitIds((Context)this.ctx, (OrgUnitInfo)orgUnitInfo);
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            viewInfo.setFilter(new FilterInfo());
                            if (!parentAndChildOrgUnitIds.isEmpty()) {
                                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)parentAndChildOrgUnitIds, CompareType.INCLUDE));
                            }
                            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("id", equSegIDSet, CompareType.INCLUDE));
                            BgPropertyCollection colls = BgPropertyFactory.getLocalInstance((Context)this.ctx).getBgPropertyCollection(viewInfo);
                            for (int i6 = 0; i6 < colls.size(); ++i6) {
                                propertyIDSet.add(colls.get(i6).getId().toString());
                            }
                        }
                        ArrayList<String> mbgDimViewIds = new ArrayList<String>();
                        List<String> mbgDims = this.schemeHelper.getAccAndOtherDim(true);
                        for (i4 = 0; i4 < mbgDims.size(); ++i4) {
                            mbgDimViewIds.add(this.schemeHelper.getDimension(mbgDims.get(i4)).getViewId());
                        }
                        sql.setLength(0);
                        sql.append("Select memb.FID, memb.FNumber, memb.FName_" + this.ctx.getLocale() + " FName, memb.FLongNumber,memb.FDisplayName_" + this.ctx.getLocale() + " FDisplayName, dim.FSrcNumber, memb.FIsLeaf, prop.FPropertyID ,memb.FDisabledDate FROM T_MBG_PropertyRefSource prop INNER JOIN T_MBG_MbgMember memb ON memb.FID = prop.FSourceID  inner join T_MBG_MbgDim dim on memb.FMbgDimID = dim.FID Where memb.FViewId IN(");
                        MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)mbgDimViewIds.size()).append(")").append(" AND prop.FPropertyID IN(");
                        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                        paramList = MbgSqlHelper.getBatchParams((Object[])mbgDimViewIds.toArray(), (Object[])propertyIDSet.toArray(), (int)50);
                    }
                }
                if (sql.length() <= 0) continue;
                pstmt = conn.prepareStatement(sql.toString());
                for (int i7 = 0; i7 < paramList.size(); ++i7) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i7)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        String propId = rst.getString("FPropertyID");
                        if (!result.containsKey(propId)) {
                            result.put(propId, new ArrayList());
                        }
                        BgDimensionMember member = new BgDimensionMember(null, rst.getString("FID"), rst.getString("FName"), rst.getString("FNumber"));
                        member.setSortValue((Comparable)((Object)rst.getString("FLongNumber")));
                        member.setLongName(rst.getString("FDisplayName"));
                        member.setLeaf(rst.getBoolean("FIsLeaf"));
                        member.setDisabledDate(rst.getTimestamp("FDisabledDate"));
                        member.setSrcNumber("D177852B".equals(sourceType2) ? rst.getString("FSrcNumber") : DimensionBaseConstants.DEF_INDEX_SRCNUMBER);
                        ((List)result.get(propId)).add(member);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            ArrayList repeatList = new ArrayList();
            for (String key : result.keySet()) {
                List lst = (List)result.get(key);
                repeatList.addAll(lst);
            }
            Iterator itParent = childPropMap.keySet().iterator();
            while (itParent.hasNext()) {
                List parentMember = null;
                id = (String)itParent.next();
                for (String childId : (Set)childPropMap.get(id)) {
                    List childMember = (List)result.get(childId);
                    if (childMember == null || childMember.isEmpty()) continue;
                    if (!result.containsKey(id)) {
                        result.put(id, new ArrayList());
                        for (BgDimensionMember member : childMember) {
                            if (propSet.contains(childId)) {
                                if (repeatList.contains(member)) continue;
                                ((List)result.get(id)).add(member);
                                continue;
                            }
                            ((List)result.get(id)).add(member);
                        }
                        continue;
                    }
                    parentMember = (List)result.get(id);
                    for (int i8 = 0; i8 < childMember.size(); ++i8) {
                        if (!propSet.contains(id) || propSet.contains(childId) || parentMember.contains(childMember.get(i8))) continue;
                        parentMember.add(childMember.get(i8));
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return result;
    }

    private void addToParent(Map<String, Set<String>> childPropMap, Map<String, String> parentLongNumber, String id, String longNumber) {
        if (childPropMap == null || parentLongNumber == null || parentLongNumber.isEmpty() || StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)longNumber)) {
            return;
        }
        int lastIndex = longNumber.lastIndexOf("!");
        if (lastIndex < 0) {
            return;
        }
        String parentId = parentLongNumber.get((longNumber = longNumber.substring(0, lastIndex)) + "!%");
        if (parentId != null) {
            if (!childPropMap.containsKey(parentId)) {
                childPropMap.put(parentId, new HashSet());
            }
            childPropMap.get(parentId).add(id);
        }
        this.addToParent(childPropMap, parentLongNumber, id, longNumber);
    }

    public Map<String, List<BgDimensionMember>> queryVariateMember(Connection conn, String orgId, Set<String> variSet, final boolean isNumber) throws EASBizException, BOSException {
        final HashMap<String, List<BgDimensionMember>> result = new HashMap<String, List<BgDimensionMember>>();
        if (variSet == null || variSet.isEmpty()) {
            return result;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID, FNumber, FDimNumber, FMemberId, FMemberNumber, FMemberName_" + this.ctx.getLocale() + " FMemberName FROM T_MBG_BgVariate Where FBgSchemeId = ? AND FBgVariateClass = " + 0 + " AND " + (isNumber ? "FNumber" : "FID") + " IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{this.schemeHelper.getBgSchemeId()}, (Object[])variSet.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String varId = res.getString("FID");
                if (isNumber) {
                    varId = res.getString("FNumber");
                }
                String dimNumber = res.getString("FDimNumber");
                BgDimensionInfo dimension = ViewListMemberParserServerHelper.this.schemeHelper.getDimension(dimNumber);
                BgDimensionMember member = new BgDimensionMember(dimNumber, res.getString("FMemberId"), res.getString("FMemberName"), res.getString("FMemberNumber"));
                if (!result.containsKey(varId)) {
                    result.put(varId, new ArrayList());
                }
                ((List)result.get(varId)).add(member);
            }
        });
        return result;
    }

    private void prepareCombinMember(MbgViewListRowCol row, Map<String, Map<Integer, Set<String>>> queryMap) {
        List<Object[]> members = ViewlistCombinHelper.getDimMembersByCombinMembers(row);
        if (!members.isEmpty()) {
            for (int i = 0; i < members.size(); ++i) {
                Object[] memberArr = members.get(i);
                for (int j = 0; j < memberArr.length; ++j) {
                    if (!(memberArr[j] instanceof MbgViewListDimensionMember)) continue;
                    MbgViewListDimensionMember curMember = (MbgViewListDimensionMember)memberArr[j];
                    this.addQueryMember(queryMap, curMember.getType(), curMember.getNumber(), 0);
                }
            }
        }
    }

    private void prepareMember(MbgViewListDimensionInfo dimension, Set<String> selectAllDim, Map<String, Map<Integer, Set<String>>> queryMap, Set<String> variSet, Set<String> propSet, Set<String> otherSet, List<MbgViewListDimensionInfo> periodAliasDims) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                            periodAliasDims.add(dimension);
                        }
                        if (!BgMemberSelectTypeEnum.Variate.equals((Object)dimension.getMemberType())) break block5;
                        for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                            if (!(dimension.getSelectMembers().get(i) instanceof BgVariateInfo)) continue;
                            String id = ((BgVariateInfo)dimension.getSelectMembers().get(i)).getId().toString();
                            if (this.memberCacheHelper.getMembers(dimension.getNumber(), this.orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), id, -1) != null) continue;
                            variSet.add(id);
                        }
                        break block6;
                    }
                    if (!BgMemberSelectTypeEnum.Property.equals((Object)dimension.getMemberType())) break block7;
                    for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                        if (!(dimension.getSelectMembers().get(i) instanceof BgPropertyInfo)) continue;
                        String id = ((BgPropertyInfo)dimension.getSelectMembers().get(i)).getId().toString();
                        if (this.memberCacheHelper.getMembers(dimension.getNumber(), this.orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), id, -1) != null) continue;
                        propSet.add(id);
                    }
                    break block6;
                }
                if (!BgMemberSelectTypeEnum.Member.equals((Object)dimension.getMemberType())) break block6;
                if (!DimensionMemberValueModeEnum.All.equals((Object)dimension.getMemberValueType())) break block8;
                if (this.memberCacheHelper.getMembers(dimension.getNumber(), this.orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), dimension.getNumber(), -1) != null) break block6;
                queryMap.remove(dimension.getNumber());
                selectAllDim.add(dimension.getNumber());
                break block6;
            }
            if (dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) && this.isReParsePeriod || !dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) && !selectAllDim.contains(dimension.getNumber())) {
                for (int i = 0; i < dimension.getSelectMembers().size(); ++i) {
                    BgDimensionMember curMember = (BgDimensionMember)dimension.getSelectMembers().get(i);
                    if (curMember == null || curMember.getNumber() == null || this.memberCacheHelper.getMembers(dimension.getNumber(), this.orgId, this.memberCacheHelper.isGlobal(dimension.getNumber(), this.schemeHelper), curMember.getNumber(), curMember.getFillType()) != null) continue;
                    this.addQueryMember(queryMap, dimension.getNumber(), curMember.getNumber(), 0);
                    if (curMember.getFillType() == 0) continue;
                    otherSet.add(dimension.getNumber());
                    this.addQueryMember(queryMap, dimension.getNumber(), curMember.getNumber(), curMember.getFillType());
                }
            }
        }
    }

    protected void addQueryMember(Map<String, Map<Integer, Set<String>>> queryMap, String dimNumber, String number, int fillType) {
        Map<Integer, Set<String>> subMap;
        if (!queryMap.containsKey(dimNumber)) {
            queryMap.put(dimNumber, new HashMap());
        }
        if (!(subMap = queryMap.get(dimNumber)).containsKey(fillType)) {
            subMap.put(fillType, new HashSet());
        }
        subMap.get(fillType).add(number);
    }

    public Map checkMemberExists(Map<String, Set<String>> queryMember, String orgId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            orgId = ContextUtil.getCurrentCostUnit((Context)this.ctx).getId().toString();
        }
        HashMap resultMap = new HashMap();
        Set<String> subSet = null;
        BgDimensionInfo dim = null;
        EntityViewInfo evi = null;
        String numberField = null;
        for (String dimNumber : queryMember.keySet()) {
            numberField = "number";
            subSet = queryMember.get(dimNumber);
            resultMap.put(dimNumber, new HashMap());
            for (String number : subSet) {
                ((Map)resultMap.get(dimNumber)).put(number, Boolean.FALSE);
            }
            dim = this.schemeHelper.getDimensionOnCheck(dimNumber);
            DimensionFilterHelper helper = this.getFilterHelper(dimNumber, orgId);
            IDataProvider biz = helper.getQueryExecutor();
            String[] numbers = subSet.toArray(new String[0]);
            int batchCount = MbgSqlHelper.getBatchCount((int)numbers.length);
            for (int b = 0; b < batchCount; ++b) {
                int index;
                int i;
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(helper.getFieldFlag() + numberField);
                evi.setFilter(helper.getFilter());
                HashSet<String> filterNumber = new HashSet<String>();
                StringBuffer maskString = new StringBuffer();
                int count = evi.getFilter().getFilterItems().size();
                if (!StringUtils.isEmpty((String)evi.getFilter().getMaskString())) {
                    maskString.append(evi.getFilter().getMaskString());
                } else {
                    for (i = 0; i < count; ++i) {
                        if (i > 0) {
                            maskString.append(" and ");
                        }
                        maskString.append("#").append(i);
                    }
                }
                if (count > 0) {
                    maskString.append(" and ");
                }
                maskString.append("(");
                for (i = 0; i < 50 && (index = b * 50 + i) < numbers.length; ++i) {
                    filterNumber.add(numbers[index]);
                }
                evi.getFilter().getFilterItems().add(new FilterItemInfo(helper.getFieldFlag() + numberField, filterNumber, CompareType.INCLUDE));
                maskString.append("#").append(count).append("))");
                evi.getFilter().setMaskString(maskString.toString());
                biz.setObjectView(evi);
                IRowSet rs = null;
                try {
                    rs = biz.executeQuery();
                    while (rs != null && rs.next()) {
                        String number;
                        number = rs.getString(helper.getFieldFlag() + "number");
                        ((Map)resultMap.get(dimNumber)).put(number, Boolean.TRUE);
                    }
                    continue;
                }
                catch (FindedTooMuchRecordsException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new DimensionException(DimensionException.MEMBEROOMUCHRECORDS);
                }
                catch (SQLException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return resultMap;
    }

    public void parseCanAddMember(MbgViewListManager viewManager, boolean isCombin, boolean isOnlyLeaf) throws EASBizException, BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            this.parseCanAddMember(conn, this.orgId != null ? this.orgId : ContextUtil.getCurrentCostUnit((Context)this.ctx).getId().toString(), viewManager, isCombin, isOnlyLeaf);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void parseCanAddMember(Connection conn, String orgId, MbgViewListManager viewManager, boolean isCombin, boolean isOnlyLeaf) throws EASBizException, BOSException {
        HashSet<String> selectAllDim = new HashSet<String>();
        HashMap<String, Map<Integer, Set<String>>> queryMap = new HashMap<String, Map<Integer, Set<String>>>();
        HashSet<String> variSet = new HashSet<String>();
        HashSet<String> propSet = new HashSet<String>();
        HashSet<String> otherSet = new HashSet<String>();
        ArrayList<MbgViewListDimensionInfo> periodAliasDims = new ArrayList<MbgViewListDimensionInfo>();
        this.prepareCanAddMember(viewManager, selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
        Map<String, List<BgDimensionMember>> variMembers = this.queryVariateMember(conn, orgId, variSet, false);
        Map<String, List<BgDimensionMember>> propMembers = this.queryPropertyMember(conn, orgId, propSet);
        HashMap<String, Map<String, BgDimensionMember>> members = new HashMap<String, Map<String, BgDimensionMember>>();
        this.queryAllMember(conn, orgId, members, selectAllDim, viewManager);
        this.queryMember(conn, orgId, members, queryMap, viewManager);
        Map<String, Node> treeNodes = this.parseTreeNode(members, otherSet);
        this.parseCanAddMember(orgId, viewManager, members, treeNodes, variMembers, propMembers, isCombin);
        this.parsePeriodAlias(conn, orgId, periodAliasDims);
    }

    private void prepareCanAddMember(MbgViewListManager viewManager, Set<String> selectAllDim, Map<String, Map<Integer, Set<String>>> queryMap, Set<String> variSet, Set<String> propSet, Set<String> otherSet, List<MbgViewListDimensionInfo> periodAliasDims) {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            this.prepareCanAddMember((MbgViewListSheetManager)viewManager.getSheetManagers().get(s), selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
        }
    }

    private void prepareCanAddMember(MbgViewListSheetManager sheetManager, Set<String> selectAllDim, Map<String, Map<Integer, Set<String>>> queryMap, Set<String> variSet, Set<String> propSet, Set<String> otherSet, List<MbgViewListDimensionInfo> periodAliasDims) {
        List<IMbgViewListObject> rowCols = sheetManager.getDimensionManager().getRowCols();
        MbgViewListRowCol row = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
            row = (MbgViewListRowCol)rowCols.get(i);
            for (int d = 0; d < row.getDimensions().size(); ++d) {
                this.prepareCanAddMember(row.getDimensions().get(d), selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
            }
        }
        MbgViewListDimensionInfo dimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, sheetManager.getDimensionManager().getDimension());
        if (dimension != null && !"ALIAS".equals(dimension.getShowType())) {
            periodAliasDims.clear();
        }
    }

    private void prepareCanAddMember(MbgViewListDimensionInfo dimension, Set<String> selectAllDim, Map<String, Map<Integer, Set<String>>> queryMap, Set<String> variSet, Set<String> propSet, Set<String> otherSet, List<MbgViewListDimensionInfo> periodAliasDims) {
        block11: {
            block12: {
                int i;
                block10: {
                    if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                        periodAliasDims.add(dimension);
                    }
                    if (!BgMemberSelectTypeEnum.Variate.equals((Object)dimension.getMemberType())) break block10;
                    for (int i2 = 0; i2 < dimension.getCanAddMember().size(); ++i2) {
                        if (!(dimension.getCanAddMember().get(i2) instanceof BgVariateInfo)) continue;
                        variSet.add(((BgVariateInfo)dimension.getCanAddMember().get(i2)).getId().toString());
                    }
                    break block11;
                }
                if (!BgMemberSelectTypeEnum.Property.equals((Object)dimension.getMemberType())) break block12;
                for (i = 0; i < dimension.getCanAddMember().size(); ++i) {
                    if (!(dimension.getCanAddMember().get(i) instanceof BgPropertyInfo)) continue;
                    propSet.add(((BgPropertyInfo)dimension.getCanAddMember().get(i)).getId().toString());
                }
                if (dimension.getOrignCanAddMember() == null) break block11;
                for (i = 0; i < dimension.getOrignCanAddMember().size(); ++i) {
                    if (!(dimension.getOrignCanAddMember().get(i) instanceof BgPropertyInfo)) continue;
                    propSet.add(((BgPropertyInfo)dimension.getOrignCanAddMember().get(i)).getId().toString());
                }
                break block11;
            }
            if (BgMemberSelectTypeEnum.Member.equals((Object)dimension.getMemberType())) {
                if (DimensionMemberValueModeEnum.All.equals((Object)dimension.getMemberValueType())) {
                    queryMap.remove(dimension.getNumber());
                    selectAllDim.add(dimension.getNumber());
                } else if (!dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER) && !selectAllDim.contains(dimension.getNumber())) {
                    if (dimension.getCanAddMember() != null && !dimension.getCanAddMember().isEmpty() && dimension.getOrignCanAddMember() != null && !dimension.getOrignCanAddMember().isEmpty()) {
                        dimension.getCanAddMember().clear();
                        dimension.getCanAddMember().addAll(dimension.getOrignCanAddMember());
                    }
                    for (int i = 0; i < dimension.getCanAddMember().size(); ++i) {
                        BgDimensionMember curMember = (BgDimensionMember)dimension.getCanAddMember().get(i);
                        if (curMember == null || curMember.getNumber() == null) continue;
                        this.addQueryMember(queryMap, dimension.getNumber(), curMember.getNumber(), 0);
                        if (curMember.getFillType() == 0) continue;
                        otherSet.add(dimension.getNumber());
                        this.addQueryMember(queryMap, dimension.getNumber(), curMember.getNumber(), curMember.getFillType());
                    }
                }
            }
        }
    }

    private void parseCanAddMember(String orgId, MbgViewListManager viewManager, Map<String, Map<String, BgDimensionMember>> members, Map<String, Node> treeNodes, Map<String, List<BgDimensionMember>> variMembers, Map<String, List<BgDimensionMember>> propMembers, boolean isCombin) throws EASBizException, BOSException {
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            this.parseCanAddMember(orgId, (MbgViewListSheetManager)viewManager.getSheetManagers().get(s), members, treeNodes, variMembers, propMembers, isCombin);
        }
    }

    private void parseCanAddMember(String orgId, MbgViewListSheetManager sheetManager, Map<String, Map<String, BgDimensionMember>> members, Map<String, Node> treeNodes, Map<String, List<BgDimensionMember>> variMembers, Map<String, List<BgDimensionMember>> propMembers, boolean isCombin) throws EASBizException, BOSException {
        List<IMbgViewListObject> rowCols = sheetManager.getDimensionManager().getRowCols();
        MbgViewListRowCol row = null;
        for (int i = 0; i < rowCols.size(); ++i) {
            if (!(rowCols.get(i) instanceof MbgViewListRowCol)) continue;
            row = (MbgViewListRowCol)rowCols.get(i);
            for (int d = 0; d < row.getDimensions().size(); ++d) {
                this.parseCanAddMember(orgId, row.getDimensions().get(d), row, members, variMembers, propMembers, treeNodes, null);
            }
        }
        List<IMbgViewListObject> rows = sheetManager.getDimensionManager().getRows();
        if (isCombin) {
            HashMap<String, List<BgDimensionMember>> allMembersMap = new HashMap<String, List<BgDimensionMember>>();
            for (int i = 0; i < rows.size(); ++i) {
                if (!(rows.get(i) instanceof MbgViewListRowCol) || !(row = (MbgViewListRowCol)rows.get(i)).isCombin()) continue;
                for (int d = 0; d < row.getDimensions().size(); ++d) {
                    this.parseCanAddMember(orgId, row.getDimensions().get(d), row, members, variMembers, propMembers, treeNodes, allMembersMap);
                }
            }
        }
    }

    private void parseCanAddMember(String orgId, MbgViewListDimensionInfo dimension, MbgViewListRowCol rowObject, Map<String, Map<String, BgDimensionMember>> members, Map<String, List<BgDimensionMember>> variMembers, Map<String, List<BgDimensionMember>> propMembers, Map<String, Node> treeNodes, Map<String, List<BgDimensionMember>> allMembersMap) throws BOSException, EASBizException {
        String key;
        ArrayList<BgDimensionMember> subList = new ArrayList<BgDimensionMember>();
        ArrayList canAddLst = null;
        if (BgMemberSelectTypeEnum.Variate.equals((Object)dimension.getMemberType())) {
            if (!rowObject.isCombin()) {
                return;
            }
            canAddLst = new ArrayList();
            if (dimension.getOrignCanAddMember() != null) {
                canAddLst.addAll(dimension.getOrignCanAddMember());
            } else {
                canAddLst.addAll(dimension.getCanAddMember());
            }
            dimension.getCanAddMember().clear();
            for (int i = 0; i < canAddLst.size(); ++i) {
                if (!(canAddLst.get(i) instanceof BgVariateInfo)) continue;
                subList.clear();
                key = ((BgVariateInfo)canAddLst.get(i)).getId().toString();
                if (variMembers.containsKey(key)) {
                    subList.addAll((Collection)variMembers.get(key));
                }
                MbgViewListDimensionMember.addMembers(subList, dimension.getCanAddMember(), canAddLst.get(i), false, false);
            }
        } else if (BgMemberSelectTypeEnum.Property.equals((Object)dimension.getMemberType())) {
            if (!rowObject.isCombin()) {
                return;
            }
            canAddLst = new ArrayList();
            if (dimension.getOrignCanAddMember() != null) {
                canAddLst.addAll(dimension.getOrignCanAddMember());
            } else {
                canAddLst.addAll(dimension.getCanAddMember());
            }
            dimension.getCanAddMember().clear();
            for (int i = 0; i < canAddLst.size(); ++i) {
                if (!(canAddLst.get(i) instanceof BgPropertyInfo)) continue;
                subList.clear();
                key = ((BgPropertyInfo)canAddLst.get(i)).getId().toString();
                if (propMembers.containsKey(key)) {
                    subList.addAll((Collection<BgDimensionMember>)propMembers.get(key));
                }
                this.reFillMemberType(dimension, subList);
                MbgViewListDimensionMember.addMembers(subList, dimension.getCanAddMember(), canAddLst.get(i), false, false);
            }
        } else if (BgMemberSelectTypeEnum.Member.equals((Object)dimension.getMemberType())) {
            BgDimensionMember curMember;
            int i;
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber())) {
                canAddLst = new ArrayList();
                if (dimension.getOrignCanAddMember() != null) {
                    canAddLst.addAll(dimension.getOrignCanAddMember());
                } else {
                    canAddLst.addAll(dimension.getCanAddMember());
                }
                dimension.getCanAddMember().clear();
                for (i = 0; i < canAddLst.size(); ++i) {
                    if (canAddLst.get(i) instanceof BgDimensionMember) {
                        curMember = (BgDimensionMember)canAddLst.get(i);
                    } else {
                        BgPeriodInfo periodInfo = (BgPeriodInfo)canAddLst.get(i);
                        curMember = new BgDimensionMember(dimension.getNumber(), dimension.getRefField(), periodInfo.getName(), periodInfo.getNumber());
                    }
                    this.reFillMemberType(dimension, subList);
                    MbgViewListDimensionMember.addMember(curMember, dimension.getCanAddMember(), canAddLst.get(i), false);
                }
            } else if (dimension.getOrignCanAddMember() != null && !dimension.getOrignCanAddMember().isEmpty()) {
                Map<String, BgDimensionMember> subMap = members.get(dimension.getNumber());
                if (subMap == null || subMap.isEmpty()) {
                    return;
                }
                Node rootNode = treeNodes.get(dimension.getNumber());
                if (rootNode != null) {
                    canAddLst = new ArrayList();
                    if (dimension.getOrignCanAddMember() != null) {
                        canAddLst.addAll(dimension.getOrignCanAddMember());
                    } else {
                        canAddLst.addAll(dimension.getCanAddMember());
                    }
                    dimension.getCanAddMember().clear();
                    for (i = 0; i < canAddLst.size(); ++i) {
                        curMember = (BgDimensionMember)canAddLst.get(i);
                        if (curMember == null || curMember.getNumber() == null) continue;
                        subList.clear();
                        this.buildMember(subList, curMember, subMap, rootNode);
                        MbgViewListDimensionMember.addMembers(subList, dimension.getCanAddMember(), curMember, true, false);
                    }
                }
            }
        }
        String refField = this.schemeHelper.getRefField(dimension.getNumber());
        String srcNumber = this.schemeHelper.getSrcNumber(dimension.getNumber());
        for (int i = 0; i < dimension.getCanAddMember().size(); ++i) {
            BgDimensionMember member = (BgDimensionMember)dimension.getCanAddMember().get(i);
            member.setType(dimension.getNumber());
            member.setAttribute(refField);
            member.setSrcNumber(srcNumber);
        }
    }

    private void reFillMemberType(MbgViewListDimensionInfo dimension, List memberList) {
        if (memberList != null && !memberList.isEmpty()) {
            for (int index = 0; index < memberList.size(); ++index) {
                if (!(memberList.get(index) instanceof BgDimensionMember) || ((BgDimensionMember)memberList.get(index)).getType() != null) continue;
                ((BgDimensionMember)memberList.get(index)).setType(dimension.getNumber());
            }
        }
    }

    public List<MbgViewListDimensionMember> getAllMemberForDimension(Context ctx, String orgId, MbgViewListDimensionInfo dimensionInfo) throws BOSException, EASBizException {
        HashMap<String, BgDimensionMember> dimensionMembers = new HashMap<String, BgDimensionMember>();
        ArrayList<MbgViewListDimensionMember> result = new ArrayList<MbgViewListDimensionMember>();
        try {
            DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance(ctx, this.schemeHelper.getDimensionOnCheck(dimensionInfo.getNumber()), orgId, this.schemeHelper.getBgSchemeId(), null, this.unitGroupId);
            IDataProvider biz = helper.getQueryExecutor();
            EntityViewInfo evi = helper.getEntityView();
            biz.setObjectView(evi);
            this.readMember(dimensionMembers, helper, this.schemeHelper, biz);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (!dimensionMembers.isEmpty()) {
            MbgViewListDimensionMember viewlistMember = null;
            Iterator ite = dimensionMembers.values().iterator();
            while (ite.hasNext()) {
                viewlistMember = MbgViewListDimensionMember.getInstance((BgDimensionMember)ite.next());
                result.add(viewlistMember);
            }
            Collections.sort(result);
        }
        return result;
    }
}

