/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.calctrace;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizRelyFactory;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.BinaryExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FormulaExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcQuery;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizAlgoParam;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcSimpleInfo;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceBaseInfo;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceInfo;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceUtils;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcValue;
import com.kingdee.eas.ma.mbg.calctrace.ICalcTraceInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.MemberObject;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BizCalcTraceResult
implements Serializable {
    private static final long serialVersionUID = 7203828684519148224L;
    private static Logger logger = Logger.getLogger((String)BizCalcTraceResult.class.getName());
    private Map<String, OrgUnitInfo> orgUnitCache = new HashMap<String, OrgUnitInfo>();
    private Context ctx = null;
    private boolean isCalcTrace = false;
    private String formula = null;
    private String orgUnitId = null;
    private String bgVersionNumber = null;
    private String bgProcess = null;
    private List<BizCalcTraceInfo> bizCalcTraces = null;

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public boolean isCalcTrace() {
        return this.isCalcTrace;
    }

    public void setCalcTrace(boolean isCalcTrace) {
        this.isCalcTrace = isCalcTrace;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public String getBgVersionNumber() {
        return this.bgVersionNumber;
    }

    public void setBgVersionNumber(String bgVersionNumber) {
        this.bgVersionNumber = bgVersionNumber;
    }

    public String getBgProcess() {
        return this.bgProcess;
    }

    public void setBgProcess(String bgProcess) {
        this.bgProcess = bgProcess;
    }

    public List<BizCalcTraceInfo> getBizCalcTraces() {
        return this.bizCalcTraces;
    }

    public void setBizCalcTraces(List<BizCalcTraceInfo> bizCalcTraces) {
        this.bizCalcTraces = bizCalcTraces;
    }

    public BizCalcTraceInfo getBizCalcTrace() {
        BizCalcTraceInfo info = null;
        if (this.getBizCalcTraces() == null || this.getBizCalcTraces().isEmpty()) {
            // empty if block
        }
        if (info == null) {
            info = BizCalcTraceInfo.getInstance();
            if (this.getBizCalcTraces() == null) {
                this.bizCalcTraces = new ArrayList<BizCalcTraceInfo>();
            }
        }
        return info;
    }

    public void parse(Context ctx, IDimensionParameter parameter) throws Exception {
        this.setCalcTrace(false);
        this.queryBizRely();
        this.bizCalcRelation(parameter);
        this.transDimensions(parameter);
    }

    public void queryBizRely() throws BOSException {
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        if (infos == null || infos.isEmpty()) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        List lst = null;
        for (BizCalcTraceInfo info : infos) {
            idSet.add(info.getBizCalcId());
        }
        Map preBizCalcMap = BizRelyFactory.getLocalInstance((Context)this.getCtx()).getPreCalc(idSet);
        if (preBizCalcMap != null && !preBizCalcMap.isEmpty()) {
            for (BizCalcTraceInfo info : infos) {
                if (!preBizCalcMap.containsKey(info.getBizCalcId())) continue;
                lst = (List)preBizCalcMap.get(info.getBizCalcId());
                for (BizCalcInfo bizCalc : lst) {
                    BizCalcSimpleInfo simpleInfo = new BizCalcSimpleInfo(bizCalc);
                    if (info.getRelys() == null) {
                        info.setRelys(new ArrayList<BizCalcSimpleInfo>());
                    }
                    info.getRelys().add(simpleInfo);
                }
            }
        }
    }

    public void transDimensions(IDimensionParameter parameter) throws Exception {
        if (this.getBizCalcTraces() == null || this.getBizCalcTraces().isEmpty()) {
            return;
        }
        Map<String, String> fieldNumbers = this.getMemberNumByFormula(parameter.getDataManager().getSrcFieldMap(), this.getFormula(), this.getBgVersionNumber(), true);
        if (fieldNumbers.isEmpty() || this.getBizCalcTraces() == null || this.getBizCalcTraces().isEmpty()) {
            return;
        }
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        Collections.sort(infos, new Comparator<BizCalcTraceInfo>(){

            @Override
            public int compare(BizCalcTraceInfo o1, BizCalcTraceInfo o2) {
                return o1.getSeq() - o2.getSeq();
            }
        });
        HashMap<String, Set<String>> allDimNumbers = new HashMap<String, Set<String>>();
        String field2 = null;
        for (String field2 : fieldNumbers.keySet()) {
            if (!allDimNumbers.containsKey(field2)) {
                allDimNumbers.put(field2, new HashSet());
            }
            ((Set)allDimNumbers.get(field2)).add(fieldNumbers.get(field2));
        }
        this.traceChild(this.getRootInfo(infos), allDimNumbers, fieldNumbers);
        this.mergeFromMembers(parameter, allDimNumbers);
        IDimension dimension = null;
        MemberObject member = null;
        String number2 = null;
        ArrayList<IDimension> dims = new ArrayList<IDimension>();
        dims.addAll(parameter.getRowDims());
        dims.addAll(parameter.getColDims());
        dims.addAll(parameter.getPageDims());
        parameter.getRowDims().addAll(parameter.getPageDims());
        parameter.getPageDims().clear();
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            dimension = (IDimension)dims.get(i);
            field2 = dimension.getField();
            if (!allDimNumbers.containsKey(field2)) continue;
            for (String number2 : (Set)allDimNumbers.get(field2)) {
                member = new MemberObject();
                if (number2.indexOf(":") > 0) {
                    member.setNumber(number2.split(":")[1]);
                } else {
                    member.setNumber(number2);
                }
                member.setSrcNumber(dimension.getSrcNumber());
                dimension.addMember(member);
            }
            if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getNumber())) {
                DimUtils.transScenarioNumber(this.getCtx(), dimension);
            } else if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getNumber())) {
                DimUtils.transVersionNumber(this.getCtx(), dimension);
            } else {
                DimUtils.queryItemLongNumber(this.getCtx(), parameter, dimension);
                DimUtils.transMdxMemberNumber(this.getCtx(), parameter, dimension);
            }
            parameter.getDimensionMap().put(dimension.getNumber(), dimension);
        }
        IDimension orgDim = parameter.getDimensionMap().get(DimensionConstants.DEF_ORGUNIT_NUMBER);
        if (!orgDim.getDimensionMember().isEmpty() && orgDim.getDimensionMember().size() > 1) {
            IMember orgMember = null;
            HashSet<String> orgUnitIds = new HashSet<String>();
            if (parameter.getOrgUnitId() != null) {
                orgUnitIds.add(parameter.getOrgUnitId().toString());
            }
            for (int i = 0; i < orgDim.getDimensionMember().size(); ++i) {
                orgMember = orgDim.getDimensionMember().get(i);
                if (!this.orgUnitCache.containsKey(orgMember.getNumber())) continue;
                orgUnitIds.add(this.orgUnitCache.get(orgMember.getNumber()).getId().toString());
            }
            parameter.setQeryOrgIds(orgUnitIds);
        }
        String orgViewId = parameter.getBgOrgViewId().toString();
        List<IMember> orgMembers = orgDim.getDimensionMember();
        HashSet<String> orgNumbers = new HashSet<String>();
        for (IMember iMember : orgMembers) {
            orgNumbers.add(iMember.getNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("longNumber");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)orgViewId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", orgNumbers, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)Boolean.FALSE, CompareType.EQUALS));
        BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(this.ctx).getBgOrgUnitCollection(view);
        if (colls != null && !colls.isEmpty()) {
            HashMap<String, BgOrgUnitInfo> bgOrgMap = new HashMap<String, BgOrgUnitInfo>();
            for (int i = 0; i < colls.size(); ++i) {
                bgOrgMap.put(colls.get(i).getNumber(), colls.get(i));
            }
            for (IMember iMember : orgMembers) {
                if (!bgOrgMap.containsKey(iMember.getNumber())) continue;
                iMember.setMdxNumber(((BgOrgUnitInfo)bgOrgMap.get(iMember.getNumber())).getLongNumber());
            }
        }
        this.setShowStr(parameter, allDimNumbers);
    }

    public void setShowStr(IDimensionParameter parameter, Map<String, Set<String>> allDimNumbers) throws EASBizException, BOSException {
        Map<String, Map<String, BgDimensionMember>> membersMap = BizCalcTraceUtils.queryMembersName(this.getCtx(), allDimNumbers, parameter.getOrgUnitId().toString(), parameter.getBgSchemeId().toString());
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.getCtx(), parameter.getBgSchemeId().toString());
        Map<String, BgDimensionInfo> fieldDimsMap = schemeHelper.getDimensionByRefField();
        HashMap<String, String> numberAndfieldMap = new HashMap<String, String>();
        String field2 = null;
        String dimNumber = null;
        for (String field2 : fieldDimsMap.keySet()) {
            dimNumber = fieldDimsMap.get(field2).getNumber();
            numberAndfieldMap.put(dimNumber, field2);
        }
        this.appendShowStr(parameter, schemeHelper, this.getRootInfo(this.getBizCalcTraces()), membersMap, numberAndfieldMap);
    }

    public void setShowStr(IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper, ICalcTraceInfo info, Map<String, Map<String, BgDimensionMember>> membersMap, Map<String, String> numberAndfieldMap) {
        Map<String, String> filedMembers = info.getFiledMembers();
        Map<String, OrgUnitInfo> idOrgMap = this.getIdOrgMap(parameter, info);
        StringBuffer showStr = null;
        String showDimNums = null;
        String showDimNum = null;
        String memberNum = null;
        String filed = null;
        String dimMemberNum = null;
        String[] showDims = null;
        if (!StringUtils.isEmpty((String)info.getShowDimNums()) && filedMembers != null) {
            showStr = new StringBuffer();
            showDimNums = info.getShowDimNums();
            showDims = showDimNums.split(",");
            for (int i = 0; i < showDims.length; ++i) {
                showDimNum = showDims[i];
                filed = numberAndfieldMap.get(showDimNum);
                dimMemberNum = filedMembers.get(filed);
                if (!StringUtils.isEmpty((String)dimMemberNum) && membersMap.containsKey(filed)) {
                    if (DimUtils.checkBaseDimension(showDimNum)) {
                        memberNum = dimMemberNum;
                        showStr.append(membersMap.get(filed).get(memberNum).getName()).append(" ");
                        continue;
                    }
                    if (dimMemberNum.indexOf(":") != 3) continue;
                    memberNum = dimMemberNum.substring(4, dimMemberNum.length());
                    showStr.append(membersMap.get(filed).get(memberNum).getName()).append(" ");
                    continue;
                }
                if (!filed.equals(DimensionConstants.DEF_ORGUNIT_FIELD)) continue;
                showStr.append(idOrgMap.get(info.getOrgUnitid()).getName()).append(" ");
            }
            info.setShowStr(showStr.toString());
        }
        this.setCommonMap(parameter, schemeHelper, info, membersMap, numberAndfieldMap);
        this.checkIsDetail(parameter, schemeHelper, info);
    }

    protected Map<String, OrgUnitInfo> getIdOrgMap(IDimensionParameter parameter, ICalcTraceInfo info) {
        HashMap<String, OrgUnitInfo> idOrgMap = new HashMap<String, OrgUnitInfo>();
        if (!this.orgUnitCache.isEmpty()) {
            String orgNumber2 = null;
            Object orgId = null;
            for (String orgNumber2 : this.orgUnitCache.keySet()) {
                idOrgMap.put(this.orgUnitCache.get(orgNumber2).getId().toString(), this.orgUnitCache.get(orgNumber2));
            }
        }
        if (!StringUtils.isEmpty((String)info.getOrgUnitid()) && !idOrgMap.containsKey(info.getOrgUnitid())) {
            idOrgMap.put(info.getOrgUnitid(), parameter.getDataManager().getOrgUnit());
        }
        return idOrgMap;
    }

    public void setCommonMap(IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper, ICalcTraceInfo info, Map<String, Map<String, BgDimensionMember>> membersMap, Map<String, String> numberAndfieldMap) {
        BgSchemeInfo bgSchemeInfo = parameter.getDataManager().getBgScheme();
        BgOrgUnitInfo bgOrgUnitInfo = parameter.getDataManager().getBgOrgUnit();
        Map<String, OrgUnitInfo> idOrgMap = this.getIdOrgMap(parameter, info);
        Map<String, String> commonMembersMap = ((BizCalcTraceBaseInfo)info).getCommonMembersMap();
        if (!commonMembersMap.isEmpty()) {
            return;
        }
        String schemeN = bgSchemeInfo.getName() + "(" + bgSchemeInfo.getNumber() + ")";
        String bgOrgUnitN = bgOrgUnitInfo.getName() + "(" + bgOrgUnitInfo.getNumber() + ")";
        if (idOrgMap.containsKey(info.getOrgUnitid())) {
            bgOrgUnitN = idOrgMap.get(info.getOrgUnitid()).getName() + "(" + idOrgMap.get(info.getOrgUnitid()).getNumber() + ")";
        }
        commonMembersMap.put(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"bgScheme", (Locale)this.ctx.getLocale()), schemeN);
        commonMembersMap.put(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"bgOrgUnit", (Locale)this.ctx.getLocale()), bgOrgUnitN);
        Map<String, String> fieldMembers = info.getFiledMembers();
        List<BgDimensionInfo> dimensions = schemeHelper.getAllDimensions();
        BgDimensionInfo dimension = null;
        String dimMemberNum = null;
        String memberNum = null;
        String alias = null;
        String dimensionN = null;
        if (fieldMembers != null) {
            for (int i = 0; i < dimensions.size(); ++i) {
                dimension = dimensions.get(i);
                alias = dimension.getAlias();
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) || !fieldMembers.containsKey(dimension.getRefField())) continue;
                dimMemberNum = fieldMembers.get(dimension.getRefField());
                if (!membersMap.containsKey(dimension.getRefField())) continue;
                if (DimUtils.checkBaseDimension(dimension.getNumber())) {
                    memberNum = dimMemberNum;
                    dimensionN = membersMap.get(dimension.getRefField()).get(memberNum).getName() + "(" + memberNum + ")";
                } else if (dimMemberNum.indexOf(":") == 3) {
                    memberNum = dimMemberNum.substring(4, dimMemberNum.length());
                    dimensionN = membersMap.get(dimension.getRefField()).get(memberNum).getName() + "(" + memberNum + ")";
                }
                commonMembersMap.put(alias, dimensionN);
            }
        }
        if (!StringUtils.isEmpty((String)info.getBgProcess())) {
            commonMembersMap.put(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"processType", (Locale)this.ctx.getLocale()), BgProcessEnum.getEnum(info.getBgProcess()).getAlias());
        }
    }

    public void appendShowStr(IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper, ICalcTraceInfo info, Map<String, Map<String, BgDimensionMember>> membersMap, Map<String, String> numberAndfieldMap) {
        this.setShowStr(parameter, schemeHelper, info, membersMap, numberAndfieldMap);
        if (info instanceof BizCalcTraceInfo && ((BizCalcTraceInfo)info).children != null) {
            BizCalcTraceInfo bizCalcTraceInfo = (BizCalcTraceInfo)info;
            for (int i = 0; i < bizCalcTraceInfo.getChildCount(); ++i) {
                this.appendShowStr(parameter, schemeHelper, bizCalcTraceInfo.getChildAt(i), membersMap, numberAndfieldMap);
            }
        }
    }

    public BizCalcTraceInfo getRootInfo(List<BizCalcTraceInfo> infos) {
        if (infos != null && !infos.isEmpty()) {
            for (BizCalcTraceInfo info : infos) {
                if (info.getSeq() != 1) continue;
                return info;
            }
        }
        return null;
    }

    public void traceChild(BizCalcTraceInfo info, Map<String, Set<String>> allDimNumbers, Map<String, String> fieldNumbers) {
        ICalcTraceInfo child = null;
        String field2 = null;
        Map<String, String> dimNumbers = null;
        if (info.children != null) {
            for (int i = 0; i < info.getChildCount(); ++i) {
                child = info.getChildAt(i);
                dimNumbers = child.getFiledMembers();
                if (dimNumbers == null || dimNumbers.isEmpty()) continue;
                for (String field2 : dimNumbers.keySet()) {
                    if (!allDimNumbers.containsKey(field2)) {
                        allDimNumbers.put(field2, new HashSet());
                    }
                    allDimNumbers.get(field2).add(dimNumbers.get(field2));
                }
                if (!(child instanceof BizCalcTraceInfo)) continue;
                if (((BizCalcTraceInfo)child).children != null) {
                    this.traceChild((BizCalcTraceInfo)child, allDimNumbers, info.getFiledMembers());
                }
                this.mergeRightMembers(allDimNumbers, (BizCalcTraceInfo)child);
            }
        }
        this.mergeRightMembers(allDimNumbers, info);
    }

    protected void mergeRightMembers(Map<String, Set<String>> allDimNumbers, BizCalcTraceInfo info) {
        Map<String, Map<String, Set<String>>> rightMembers = info.getRightMembers();
        String field2 = null;
        String exprStr2 = null;
        Map<String, Set<String>> membersMap = null;
        for (String exprStr2 : rightMembers.keySet()) {
            membersMap = rightMembers.get(exprStr2);
            for (String field2 : membersMap.keySet()) {
                if (!allDimNumbers.containsKey(field2)) {
                    allDimNumbers.put(field2, new HashSet());
                }
                allDimNumbers.get(field2).addAll((Collection<String>)membersMap.get(field2));
            }
        }
    }

    public Map<String, String> getNewFieldNumbers(Map<String, String> fieldNumbers) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Iterator<String> ite = fieldNumbers.keySet().iterator();
        while (ite.hasNext()) {
            newMap.put(ite.next(), null);
        }
        return newMap;
    }

    private boolean checkMatch(Map<String, String> fieldNumbers) {
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        Map<String, Map<String, Set<String>>> refNumLeftMap = null;
        String field2 = null;
        Set<String> numbers = null;
        HashMap<BizCalcTraceInfo, Boolean> matchMap = new HashMap<BizCalcTraceInfo, Boolean>();
        for (BizCalcTraceInfo info : infos) {
            matchMap.put(info, Boolean.TRUE);
            refNumLeftMap = info.getLeftMembers();
            block1: for (String exprStr : refNumLeftMap.keySet()) {
                Map<String, Set<String>> membersMap = refNumLeftMap.get(exprStr);
                for (String field2 : membersMap.keySet()) {
                    numbers = membersMap.get(field2);
                    if (!fieldNumbers.containsKey(field2) || numbers.contains(fieldNumbers.get(field2))) continue;
                    matchMap.remove(info);
                    continue block1;
                }
            }
        }
        return !matchMap.isEmpty();
    }

    public Map<String, Map<String, Set<String>>> bizCalcRelation(IDimensionParameter parameter) throws Exception {
        Map<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        Map<String, String> fieldNumbers = this.getMemberNumByFormula(srcFieldMap, this.getFormula(), this.getBgVersionNumber(), true);
        if (fieldNumbers.isEmpty()) {
            return result;
        }
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        if (infos == null || infos.isEmpty()) {
            return result;
        }
        HashMap<String, Map<String, Set<String>>> refNumLeftMap = null;
        HashMap<String, Map<String, Set<String>>> refNumRightMap = null;
        for (BizCalcTraceInfo info : infos) {
            refNumLeftMap = new HashMap<String, Map<String, Set<String>>>();
            refNumRightMap = new HashMap<String, Map<String, Set<String>>>();
            result = BizCalcTraceUtils.bizCaclRelation(srcFieldMap, refNumLeftMap, refNumRightMap, (BinaryExpr)((BinaryExpr)info.getExpre()).clone());
            info.setLeftMembers(refNumLeftMap);
            info.setRightMembers(refNumRightMap);
            info.parseFormula(this.getCtx(), fieldNumbers, this.orgUnitCache, info.checkPriority(infos));
            info.parseOnlyRightExpr();
        }
        this.checkScope(parameter);
        if (!this.checkMatch(fieldNumbers)) {
            this.getBizCalcTraces().clear();
            return result;
        }
        this.calcRelyTree(fieldNumbers);
        this.removeExtraInfos();
        this.calcRightValues(parameter, fieldNumbers);
        return result;
    }

    protected void checkScope(IDimensionParameter parameter) {
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        Map<String, String> fieldSrcMap = parameter.getDataManager().getFieldSrcMap();
        BizCalcTraceInfo info = null;
        Map<String, Set<String>> scopes = null;
        Map<String, String> filedMembers = null;
        String field2 = null;
        Iterator<BizCalcTraceInfo> it = infos.iterator();
        while (it.hasNext()) {
            info = it.next();
            if (info.checkPriority(infos)) continue;
            filedMembers = info.getFiledMembers();
            scopes = info.getScopes();
            boolean isMatch = true;
            if (scopes != null && !scopes.isEmpty() && filedMembers != null && !filedMembers.isEmpty()) {
                for (String field2 : filedMembers.keySet()) {
                    if (!scopes.containsKey(field2) || scopes.get(field2).isEmpty() || scopes.get(field2).contains(filedMembers.get(field2)) || fieldSrcMap.containsKey(field2) && scopes.get(field2).contains(fieldSrcMap.get(field2) + ":" + filedMembers.get(field2))) continue;
                    isMatch = false;
                    break;
                }
            }
            if (isMatch) continue;
            it.remove();
        }
    }

    protected void calcRightValues(IDimensionParameter parameter, Map<String, String> fieldNumbers) {
        BizCalcTraceInfo root = this.getRootInfo(this.getBizCalcTraces());
        if (root == null) {
            return;
        }
        this.calcRightValues(parameter, root, fieldNumbers);
        if (root.getChildCount() > 0) {
            this.calcChildRightValues(parameter, root, fieldNumbers);
        }
    }

    protected void calcChildRightValues(IDimensionParameter parameter, BizCalcTraceInfo info, Map<String, String> fieldNumbers) {
        for (int i = 0; i < info.getChildCount(); ++i) {
            if (!(info.getChildAt(i) instanceof BizCalcTraceInfo)) continue;
            this.calcRightValues(parameter, (BizCalcTraceInfo)info.getChildAt(i), fieldNumbers);
            this.calcChildRightValues(parameter, (BizCalcTraceInfo)info.getChildAt(i), fieldNumbers);
        }
    }

    protected void calcRightValues(IDimensionParameter parameter, BizCalcTraceInfo info, Map<String, String> fieldNumbers) {
        block16: {
            String key;
            block15: {
                BizCalcTraceInfo child = null;
                key = null;
                if (info.children == null) break block15;
                HashMap<String, BizCalcTraceInfo> childFormulas = new HashMap<String, BizCalcTraceInfo>();
                for (int index = 0; index < info.getChildCount(); ++index) {
                    if (!(info.getChildAt(index) instanceof BizCalcTraceInfo)) continue;
                    child = (BizCalcTraceInfo)info.getChildAt(index);
                    childFormulas.put(child.getOrgFormulaKey(), child);
                }
                if (info.members.isEmpty()) break block16;
                Map.Entry<String, IExpress> mEntry2 = null;
                IExpress expr = null;
                for (Map.Entry<String, IExpress> mEntry2 : info.members.entrySet()) {
                    BizCalcValue bizCalcValue;
                    expr = mEntry2.getValue();
                    key = mEntry2.getKey();
                    if (expr instanceof MdxMemberExpr) {
                        bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, expr);
                        bizCalcValue.parseFormula(this.getCtx(), info.getFiledMembers(), this.orgUnitCache, false);
                        bizCalcValue.setOriginalExpr(expr.toString());
                        bizCalcValue.setLeftOriginalExpr(expr.toString());
                        if (StringUtils.isEmpty((String)bizCalcValue.getBgProcess())) {
                            bizCalcValue.setBgProcess(info.getBgProcess());
                        }
                        if (!childFormulas.keySet().contains(bizCalcValue.getOrgFormulaKey())) {
                            info.add(bizCalcValue);
                            info.childMember.put(key, bizCalcValue);
                            continue;
                        }
                        if (bizCalcValue.getOriginalExpr().indexOf("@Lead") > 0) {
                            info.add(bizCalcValue);
                            info.childMember.put(key, bizCalcValue);
                            continue;
                        }
                        info.childMember.put(key, (ICalcTraceInfo)childFormulas.get(bizCalcValue.getOrgFormulaKey()));
                        continue;
                    }
                    if (expr instanceof FormulaExpr) {
                        this.calcChildFormulaExpr(parameter, info, key, (FormulaExpr)expr);
                        continue;
                    }
                    if (expr instanceof NameExpr) {
                        bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, null);
                        bizCalcValue.setCalcResult(expr.toString());
                        bizCalcValue.setOriginalExpr(expr.getOriginalExpr());
                        bizCalcValue.setShowStr(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"bgVariate", (Locale)this.ctx.getLocale()));
                        String expre = bizCalcValue.getOriginalExpr();
                        bizCalcValue.getCommonMembersMap().put(" ", expre);
                        info.add(bizCalcValue);
                        info.childMember.put(key, bizCalcValue);
                        continue;
                    }
                    if (!(expr instanceof FunctionExpr)) continue;
                    bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, null);
                    bizCalcValue.setCalcResult(expr.toString());
                    bizCalcValue.setOriginalExpr(expr.getOriginalExpr());
                    bizCalcValue.setLeftOriginalExpr(expr.toString());
                    info.childMember.put(key, bizCalcValue);
                }
                break block16;
            }
            if (!info.members.isEmpty()) {
                Map.Entry<String, IExpress> mEntry3 = null;
                IExpress expr = null;
                for (Map.Entry<String, IExpress> mEntry3 : info.members.entrySet()) {
                    BizCalcValue bizCalcValue;
                    expr = mEntry3.getValue();
                    key = mEntry3.getKey();
                    if (expr instanceof MdxMemberExpr) {
                        bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, expr);
                        bizCalcValue.parseFormula(this.getCtx(), info.getFiledMembers(), this.orgUnitCache, false);
                        bizCalcValue.setOriginalExpr(expr.toString());
                        bizCalcValue.setLeftOriginalExpr(expr.toString());
                        if (StringUtils.isEmpty((String)bizCalcValue.getBgProcess())) {
                            bizCalcValue.setBgProcess(info.getBgProcess());
                        }
                        if (!StringUtils.isEmpty((String)info.getFormula()) && !bizCalcValue.getOrgFormulaKey().equals(info.getOrgFormulaKey())) {
                            info.add(bizCalcValue);
                            info.childMember.put(key, bizCalcValue);
                            continue;
                        }
                        if (bizCalcValue.getOriginalExpr().indexOf("@Lead") <= 0) continue;
                        info.add(bizCalcValue);
                        info.childMember.put(key, bizCalcValue);
                        continue;
                    }
                    if (expr instanceof FormulaExpr) {
                        this.calcChildFormulaExpr(parameter, info, key, (FormulaExpr)expr);
                        continue;
                    }
                    if (expr instanceof NameExpr) {
                        bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, null);
                        bizCalcValue.setCalcResult(expr.toString());
                        bizCalcValue.setOriginalExpr(expr.getOriginalExpr());
                        bizCalcValue.setShowStr(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"bgVariate", (Locale)this.ctx.getLocale()));
                        String expre = bizCalcValue.getOriginalExpr();
                        bizCalcValue.getCommonMembersMap().put(" ", expre);
                        info.add(bizCalcValue);
                        info.childMember.put(key, bizCalcValue);
                        continue;
                    }
                    if (!(expr instanceof FunctionExpr)) continue;
                    bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, null);
                    bizCalcValue.setCalcResult(expr.toString());
                    bizCalcValue.setOriginalExpr(expr.getOriginalExpr());
                    bizCalcValue.setLeftOriginalExpr(expr.toString());
                    info.childMember.put(key, bizCalcValue);
                }
            }
        }
    }

    protected void calcChildFormulaExpr(IDimensionParameter parameter, BizCalcTraceInfo info, String key, FormulaExpr expr) {
        Map bgFormulaMap = null;
        if (parameter.getDataManager().getCalcStrategy().getUtils() != null) {
            Object[] obj = null;
            bgFormulaMap = parameter.getDataManager().getCalcStrategy().getUtils().getBgFormulaMap();
            String originalExpr = info.getOriginalExpr();
            if (!StringUtils.isEmpty((String)originalExpr) && bgFormulaMap.get(originalExpr) != null) {
                obj = (Object[])((Map)bgFormulaMap.get(originalExpr)).get(expr.toString());
            } else if (info.getExpre() instanceof BinaryExpr && !StringUtils.isEmpty((String)(originalExpr = ((BinaryExpr)info.getExpre()).getOriginalExpr())) && bgFormulaMap.get(originalExpr) != null) {
                obj = (Object[])((Map)bgFormulaMap.get(originalExpr)).get(expr.toString());
            }
            if (obj != null) {
                Object calcResult = null;
                String expre = null;
                if (obj != null) {
                    if (obj[0] != null) {
                        expre = obj[0].toString();
                    }
                    if (obj[1] != null) {
                        calcResult = obj[1];
                    }
                }
                BizCalcValue bizCalcValue = new BizCalcValue(info, info.getOrgUnitid(), null, null);
                bizCalcValue.setOriginalExpr(expr.toString());
                bizCalcValue.setLeftOriginalExpr(expr.toString());
                bizCalcValue.setIsFormulaExr(true);
                bizCalcValue.setCalcResult(calcResult);
                info.add(bizCalcValue);
                info.childMember.put(key, bizCalcValue);
                bizCalcValue.getCommonMembersMap().put(" ", expre);
                if (expr.formulaName.equalsIgnoreCase("MbgRefBgTem")) {
                    bizCalcValue.setShowStr(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"otherFormula", (Locale)this.ctx.getLocale()));
                } else if (expr.formulaName.equalsIgnoreCase("ACCT")) {
                    bizCalcValue.setShowStr(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"acctFormula", (Locale)this.ctx.getLocale()));
                } else if (expr.formulaName.equalsIgnoreCase("Acctitem")) {
                    bizCalcValue.setShowStr(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"rptFormula", (Locale)this.ctx.getLocale()));
                } else if (expr.formulaName.equalsIgnoreCase("Mbgadjust") || expr.formulaName.equalsIgnoreCase("Mbgadjustdate")) {
                    bizCalcValue.setShowStr(EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"adjustFormula", (Locale)this.ctx.getLocale()));
                }
            }
        }
    }

    private void removeExtraInfos() {
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        BizCalcTraceInfo info = null;
        for (int i = infos.size() - 1; i >= 0; --i) {
            info = infos.get(i);
            if (info.getSeq() >= 0) continue;
            this.getBizCalcTraces().remove(info);
        }
    }

    protected boolean checkInScope(BizCalcTraceInfo info) {
        boolean inScope = true;
        Map<String, String> filedMembers = info.getFiledMembers();
        Map<String, Set<String>> scopes = info.getScopes();
        String field2 = null;
        if (scopes != null && !scopes.isEmpty() && filedMembers != null && !filedMembers.isEmpty()) {
            for (String field2 : filedMembers.keySet()) {
                if (!scopes.containsKey(field2) || scopes.get(field2).isEmpty() || scopes.get(field2).contains(filedMembers.get(field2))) continue;
                inScope = false;
                break;
            }
        }
        return inScope;
    }

    protected void calcRelyTree(Map<String, String> fieldNumbers) {
        List<BizCalcTraceInfo> calcInfos = this.getBizCalcTraces();
        Map<String, Map<String, Set<String>>> refNumLeftMap = null;
        Set<String> numbers = null;
        String field2 = null;
        ArrayList<BizCalcTraceInfo> infos = new ArrayList<BizCalcTraceInfo>();
        for (int i = 0; i < calcInfos.size(); ++i) {
            BizCalcTraceInfo info = calcInfos.get(i);
            if (info.getRightMembers().isEmpty()) {
                try {
                    infos.add(info.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            infos.add(info);
        }
        logger.error((Object)("BizCalcTraceResult calcRelyTree fieldNumbers:" + fieldNumbers));
        this.printInfosLog(infos);
        logger.error((Object)"BizCalcTraceResult calcRelyTree start ***************");
        BizCalcTraceInfo info = null;
        for (int i = infos.size() - 1; i >= 0; --i) {
            info = (BizCalcTraceInfo)infos.get(i);
            if (!StringUtils.isEmpty((String)info.getFormula())) {
                if (!info.getFormula().equals(this.getFormula()) || !info.getOrgUnitid().equals(this.getOrgUnitId()) || !info.getBgVersionNumber().equals(this.getBgVersionNumber()) || !info.getBgProcess().equals(this.getBgProcess()) || !this.checkInScope(info)) continue;
                info.setSeq(1);
                this.calcRelyNew(info, infos, fieldNumbers);
                break;
            }
            refNumLeftMap = info.getLeftMembers();
            block4: for (String exprStr : refNumLeftMap.keySet()) {
                Map<String, Set<String>> membersMap = refNumLeftMap.get(exprStr);
                for (String field2 : membersMap.keySet()) {
                    numbers = membersMap.get(field2);
                    if (!fieldNumbers.containsKey(field2) || !numbers.contains(fieldNumbers.get(field2))) continue;
                    info.setSeq(1);
                    info.setFormula(this.getFormula());
                    this.calcRelyNew(info, infos, fieldNumbers);
                    continue block4;
                }
            }
        }
        logger.error((Object)"BizCalcTraceResult calcRelyTree end ***********");
    }

    protected boolean check(Map<String, Set<String>> parentRight, Map<String, Set<String>> childLeft, Map<String, String> fieldNumbers) {
        boolean match = true;
        Set<String> pNumbers = null;
        Set<String> cNumbers = null;
        String field2 = null;
        HashSet<String> fields = new HashSet<String>();
        fields.addAll(childLeft.keySet());
        fields.addAll(parentRight.keySet());
        for (String field2 : fields) {
            cNumbers = childLeft.get(field2);
            if (cNumbers == null) {
                if (parentRight.get(field2) != null) {
                    cNumbers = new HashSet<String>();
                    cNumbers.addAll((Collection<String>)parentRight.get(field2));
                } else {
                    cNumbers = new HashSet<String>();
                    cNumbers.add(fieldNumbers.get(field2));
                }
            }
            if (parentRight.containsKey(field2)) {
                pNumbers = parentRight.get(field2);
                if (this.equals(pNumbers, cNumbers)) continue;
                match = false;
                break;
            }
            if (parentRight.containsKey(field2) || !fieldNumbers.containsKey(field2) || cNumbers.contains(fieldNumbers.get(field2))) continue;
            match = false;
            break;
        }
        return match;
    }

    protected boolean equals(Set<String> set1, Set<String> set2) {
        boolean isEqual = true;
        for (String s1 : set1) {
            if (set2.contains(s1)) continue;
            isEqual = false;
            break;
        }
        if (isEqual) {
            for (String s2 : set2) {
                if (set1.contains(s2)) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }

    @Deprecated
    protected void calcRely(BizCalcTraceInfo curInfo, List<BizCalcTraceInfo> infos, Map<String, String> fieldNumbers) {
        BizCalcTraceInfo info = null;
        for (int i = infos.size() - 1; i >= 0; --i) {
            info = infos.get(i);
            if (info.getSeq() >= 0) continue;
            Map<String, Map<String, Set<String>>> refNumLeftMap = info.getLeftMembers();
            Map<String, Set<String>> leftMembersMap = null;
            Iterator<String> iter = refNumLeftMap.keySet().iterator();
            while (iter.hasNext()) {
                leftMembersMap = refNumLeftMap.get(iter.next());
                block4: for (String exprStr : curInfo.getRightMembers().keySet()) {
                    Map<String, Set<String>> rightMembersMap = curInfo.getRightMembers().get(exprStr);
                    for (String field : rightMembersMap.keySet()) {
                        HashSet numbers = new HashSet(rightMembersMap.get(field));
                        if (!leftMembersMap.containsKey(field)) continue;
                        numbers.retainAll((Collection)leftMembersMap.get(field));
                        if (numbers.isEmpty()) continue block4;
                        int cSeq = curInfo.getSeq() + 1;
                        if (curInfo.getChildCount() > 0) {
                            boolean exist = false;
                            for (int x = 0; x < curInfo.getChildCount(); ++x) {
                                if (!curInfo.getChildAt(x).getFormula().equals(info.getFormula())) continue;
                                exist = true;
                                break;
                            }
                            if (exist) continue;
                            info.setSeq(cSeq);
                            curInfo.add(info);
                            ArrayList<BizCalcTraceInfo> clones = new ArrayList<BizCalcTraceInfo>();
                            for (BizCalcTraceInfo cInfo : infos) {
                                try {
                                    BizCalcTraceInfo cloneInfo = cInfo.clone();
                                    cloneInfo.setSeq(-2);
                                    clones.add(cloneInfo);
                                }
                                catch (CloneNotSupportedException cloneNotSupportedException) {}
                            }
                            this.calcRely(info, clones, fieldNumbers);
                            continue;
                        }
                        info.setSeq(cSeq);
                        curInfo.add(info);
                        this.calcRely(info, infos, fieldNumbers);
                    }
                }
            }
        }
    }

    protected void calcRelyNew(BizCalcTraceInfo curInfo, List<BizCalcTraceInfo> infos, Map<String, String> fieldNumbers) {
        this.printInfoLog(curInfo);
        BizCalcTraceInfo info = null;
        for (int i = infos.size() - 1; i >= 0; --i) {
            info = infos.get(i);
            if (info.getSeq() >= 0) continue;
            Map<String, Map<String, Set<String>>> refNumLeftMap = info.getLeftMembers();
            Map<String, Set<String>> leftMembersMap = null;
            Iterator<String> iter = refNumLeftMap.keySet().iterator();
            while (iter.hasNext()) {
                leftMembersMap = refNumLeftMap.get(iter.next());
                for (String exprStr : curInfo.getRightMembers().keySet()) {
                    Map<String, Set<String>> rightMembersMap = curInfo.getRightMembers().get(exprStr);
                    if (info.checkPriority(infos) && info.getScopes() != null && !info.getScopes().isEmpty()) {
                        boolean inScope = true;
                        HashMap<String, String> temFieldNumbers = new HashMap<String, String>();
                        temFieldNumbers.putAll(fieldNumbers);
                        block9: for (String af : rightMembersMap.keySet()) {
                            Set<String> aset = rightMembersMap.get(af);
                            for (String va : aset) {
                                if (info.getScopes().containsKey(af) && !info.getScopes().get(af).contains(va)) {
                                    inScope = false;
                                    break block9;
                                }
                                temFieldNumbers.put(af, va);
                            }
                        }
                        for (String bf : temFieldNumbers.keySet()) {
                            String bv = (String)temFieldNumbers.get(bf);
                            if (!info.getScopes().containsKey(bf) || info.getScopes().get(bf).contains(bv)) continue;
                            inScope = false;
                            break;
                        }
                        if (!inScope || rightMembersMap.isEmpty()) continue;
                        info.parseFormula(this.ctx, temFieldNumbers, this.orgUnitCache, false);
                        if (!this.check(rightMembersMap, leftMembersMap, temFieldNumbers)) continue;
                        int cSeq = curInfo.getSeq() + 1;
                        if (curInfo.getChildCount() > 0) {
                            boolean exist = false;
                            for (int x = 0; x < curInfo.getChildCount(); ++x) {
                                if (!curInfo.getChildAt(x).getFormula().equals(info.getFormula()) || !curInfo.getChildAt(x).getBgVersionNumber().equals(info.getFormula()) || !curInfo.getChildAt(x).getOrgUnitid().equals(info.getOrgUnitid())) continue;
                                exist = true;
                                break;
                            }
                            if (exist || curInfo.containsChild(info)) continue;
                            info.setSeq(cSeq);
                            curInfo.add(info);
                            ArrayList<BizCalcTraceInfo> clones = new ArrayList<BizCalcTraceInfo>();
                            for (BizCalcTraceInfo cInfo : infos) {
                                if (cInfo.getSeq() > 0) {
                                    try {
                                        BizCalcTraceInfo cloneInfo = cInfo.clone();
                                        cloneInfo.setSeq(-2);
                                        clones.add(cloneInfo);
                                    }
                                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                                    continue;
                                }
                                clones.add(cInfo);
                            }
                            if (clones.isEmpty()) continue;
                            this.calcRelyNew(info, clones, temFieldNumbers);
                            continue;
                        }
                        info.setSeq(cSeq);
                        curInfo.add(info);
                        this.calcRelyNew(info, infos, temFieldNumbers);
                        continue;
                    }
                    if (!this.check(rightMembersMap, leftMembersMap, fieldNumbers)) continue;
                    int cSeq = curInfo.getSeq() + 1;
                    if (curInfo.getChildCount() > 0) {
                        boolean exist = false;
                        for (int x = 0; x < curInfo.getChildCount(); ++x) {
                            if (!curInfo.getChildAt(x).getFormula().equals(info.getFormula()) || !curInfo.getChildAt(x).getBgVersionNumber().equals(info.getFormula()) || !curInfo.getChildAt(x).getOrgUnitid().equals(info.getOrgUnitid())) continue;
                            exist = true;
                            break;
                        }
                        if (!exist && !curInfo.containsChild(info)) {
                            info.setSeq(cSeq);
                            curInfo.add(info);
                            ArrayList<BizCalcTraceInfo> clones = new ArrayList<BizCalcTraceInfo>();
                            for (BizCalcTraceInfo cInfo : infos) {
                                if (cInfo.getSeq() > 0) {
                                    try {
                                        BizCalcTraceInfo cloneInfo = cInfo.clone();
                                        cloneInfo.setSeq(-2);
                                        clones.add(cloneInfo);
                                    }
                                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                                    continue;
                                }
                                clones.add(cInfo);
                            }
                            if (clones.isEmpty()) continue;
                            this.calcRelyNew(info, clones, fieldNumbers);
                            continue;
                        }
                        if (rightMembersMap.keySet().size() <= leftMembersMap.keySet().size()) continue;
                        try {
                            BizCalcTraceInfo cloneInfo = info.clone();
                            this.doDifferFileds(cloneInfo, rightMembersMap, leftMembersMap);
                            cloneInfo.setSeq(cSeq);
                            curInfo.add(cloneInfo);
                            this.calcRelyNew(cloneInfo, infos, fieldNumbers);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (rightMembersMap.keySet().size() > leftMembersMap.keySet().size()) {
                        this.doDifferFileds(info, rightMembersMap, leftMembersMap);
                        info.setSeq(cSeq);
                        curInfo.add(info);
                        this.calcRelyNew(info, infos, fieldNumbers);
                        continue;
                    }
                    info.setSeq(cSeq);
                    curInfo.add(info);
                    this.calcRelyNew(info, infos, fieldNumbers);
                }
            }
        }
    }

    protected void doDifferFileds(BizCalcTraceInfo info, Map<String, Set<String>> rightMembersMap, Map<String, Set<String>> leftMembersMap) {
        if (rightMembersMap.keySet().size() > leftMembersMap.keySet().size()) {
            String field2 = null;
            Set<String> numbers = null;
            boolean need = false;
            for (String field2 : rightMembersMap.keySet()) {
                numbers = rightMembersMap.get(field2);
                if (leftMembersMap.containsKey(field2) || numbers.size() != 1) continue;
                for (String n : numbers) {
                    info.getFiledMembers().put(field2, n);
                    need = true;
                }
            }
            if (need) {
                info.parseFormula(this.getCtx(), info.getFiledMembers(), this.orgUnitCache, false);
            }
        }
    }

    public void setTrace(BizAlgoParam bizAlgoParam, IDimensionParameter parameter, BizCalcInfo calc, BizCalcSubsetInfo subCalc, IExpress expr) {
        if (this != null && this.isCalcTrace()) {
            BizCalcTraceInfo bizCalcTraceInfo = this.getBizCalcTrace();
            bizCalcTraceInfo.setBizCalcId(calc.getId().toString());
            bizCalcTraceInfo.setBizCalcNumber(calc.getNumber());
            bizCalcTraceInfo.setBizCalcName(calc.getName());
            bizCalcTraceInfo.setBizSubId(subCalc.getId().toString());
            bizCalcTraceInfo.setBizSubName(subCalc.getName());
            bizCalcTraceInfo.setOriginalExpr(expr.toString());
            bizCalcTraceInfo.setExpre(expr);
            if (!StringUtils.isEmpty((String)subCalc.getShowDimNums())) {
                bizCalcTraceInfo.setShowDimNums(subCalc.getShowDimNums());
            } else {
                bizCalcTraceInfo.setShowDimNums(DimensionConstants.DEF_PERIOD_NUMBER + "," + DimensionConstants.DEF_ACCOUNT_NUMBER);
            }
            Map scopeMap = null;
            try {
                if (this.getCtx() != null && parameter != null) {
                    Map oldScopeMap = subCalc.getScopeMap();
                    subCalc.setScopeMap(null);
                    scopeMap = subCalc.getScopeData(parameter.getDataManager().getVariate(), DimUtils.getPeriodStandardNumber(parameter), null, true, true, this.ctx, parameter.getDataManager().getBgScheme(), parameter.getDataManager().getDimensions());
                    subCalc.setScopeMap(oldScopeMap);
                }
            }
            catch (Exception e) {
                logger.error((Object)"BizCalcTraceResult setTrace errror:", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (expr instanceof BinaryExpr) {
                bizCalcTraceInfo.setScopes(scopeMap);
                bizCalcTraceInfo.setLeftOriginalExpr(((BinaryExpr)expr).left.toString());
            }
            if (parameter.getBillId() != null) {
                bizCalcTraceInfo.setBgFormId(parameter.getBillId().toString());
            }
            if (parameter.getDataManager().getDimDataQuery() != null) {
                bizCalcTraceInfo.setBgFormName(parameter.getDataManager().getDimDataQuery().getName());
            }
            if (parameter.getOrgUnitId() != null) {
                bizCalcTraceInfo.setOrgUnitid(parameter.getOrgUnitId().toString());
            }
            if (!StringUtils.isEmpty((String)this.getBgVersionNumber())) {
                bizCalcTraceInfo.setBgVersionNumber(this.getBgVersionNumber());
            }
            if (!StringUtils.isEmpty((String)this.getBgProcess())) {
                bizCalcTraceInfo.setBgProcess(this.getBgProcess());
            }
            this.getBizCalcTraces().add(bizCalcTraceInfo);
        }
    }

    public void transResult(Context ctx, IDimensionParameter parameter, Object data) {
        if (this.getBizCalcTraces() != null && !this.getBizCalcTraces().isEmpty()) {
            BizCalcTraceInfo rootInfo = this.getRootInfo(this.getBizCalcTraces());
            if (data instanceof Map[]) {
                this.fillValue((ICalcTraceInfo)rootInfo, (Map[])data);
            } else if (data instanceof Map) {
                this.fillValue((ICalcTraceInfo)rootInfo, data);
            }
            this.calculationNew(rootInfo);
        }
    }

    protected void calculation(BizCalcTraceInfo info) {
        String nullStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"nullStr", (Locale)this.ctx.getLocale());
        String thisDataStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"thisData", (Locale)this.ctx.getLocale());
        ICalcTraceInfo childInfo = null;
        String key2 = null;
        String expression = null;
        if (info.getExpre() instanceof BinaryExpr && ((BinaryExpr)info.getExpre()).right != null) {
            expression = ((BinaryExpr)info.getExpre()).right.toPlanString();
            if (!info.childMember.isEmpty()) {
                for (String key2 : info.childMember.keySet()) {
                    childInfo = info.childMember.get(key2);
                    if (childInfo.getCalcResult() == null) {
                        expression = expression.replace(key2, nullStr);
                        continue;
                    }
                    if (childInfo.getCalcResult() instanceof BigDecimal && ((BigDecimal)childInfo.getCalcResult()).compareTo(BigDecimal.ZERO) < 0) {
                        expression = expression.replace(key2, "(" + childInfo.getCalcResult().toString() + ")");
                        continue;
                    }
                    expression = expression.replace(key2, childInfo.getCalcResult().toString());
                }
            }
        }
        if (this.checkExpressionBigDecimal(expression)) {
            if (info.getCalcResult() != null) {
                info.setCalculation(thisDataStr + info.getCalcResult());
            } else {
                info.setCalculation(thisDataStr + nullStr);
            }
        } else if (info.getCalcResult() != null) {
            info.setCalculation(thisDataStr + expression + "\n" + BizCalcTraceUtils.getSpaces(thisDataStr.length()) + "=" + info.getCalcResult());
        } else {
            info.setCalculation(thisDataStr + expression + "\n" + BizCalcTraceUtils.getSpaces(thisDataStr.length()) + "=" + nullStr);
        }
        if (info.getChildCount() > 0) {
            for (int i = 0; i < info.getChildCount(); ++i) {
                if (!(info.getChildAt(i) instanceof BizCalcTraceInfo)) continue;
                this.calculation((BizCalcTraceInfo)info.getChildAt(i));
            }
        }
    }

    protected String getReplaceName(List<String> calcSet) {
        return "$-" + TableToolkit.int2pos((int)calcSet.size()) + "$";
    }

    protected void calculationNew(BizCalcTraceInfo info) {
        ArrayList<String> calcSet = new ArrayList<String>();
        String nullStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"nullStr", (Locale)this.ctx.getLocale());
        ICalcTraceInfo childInfo = null;
        String key2 = null;
        String expression = null;
        String dimExpression = null;
        String calcResulstStr = null;
        String replaceName = null;
        if (info.getExpre() instanceof BinaryExpr && ((BinaryExpr)info.getExpre()).right != null) {
            expression = ((BinaryExpr)info.getExpre()).right.toPlanString();
            dimExpression = ((BinaryExpr)info.getExpre()).right.toPlanString();
            if (!info.childMember.isEmpty()) {
                if (info.getChildCount() > 0) {
                    for (int i = info.getChildCount() - 1; i >= 0; --i) {
                        info.remove(i);
                    }
                }
                for (String key2 : info.childMember.keySet()) {
                    replaceName = this.getReplaceName(calcSet);
                    childInfo = info.childMember.get(key2);
                    info.add(childInfo);
                    if (childInfo.getCalcResult() == null) {
                        calcResulstStr = nullStr;
                        expression = expression.replace(key2, nullStr);
                        dimExpression = dimExpression.replace(key2, childInfo.getShowStr() + " " + replaceName + " ");
                    } else {
                        calcResulstStr = childInfo.getCalcResult().toString();
                        if (childInfo.getCalcResult() instanceof BigDecimal && ((BigDecimal)childInfo.getCalcResult()).compareTo(BigDecimal.ZERO) < 0) {
                            expression = expression.replace(key2, "(" + childInfo.getCalcResult().toString() + ")").replaceAll(" ", "");
                            dimExpression = dimExpression.replace(key2, "(" + childInfo.getShowStr() + " " + replaceName + " )");
                        } else {
                            expression = expression.replace(key2, childInfo.getCalcResult().toString()).replaceAll(" ", "");
                            dimExpression = dimExpression.replace(key2, childInfo.getShowStr() + " " + replaceName + " ");
                        }
                    }
                    info.getReplaceResult().put(replaceName, calcResulstStr);
                    calcSet.add(key2);
                }
            }
        }
        if (this.checkExpressionBigDecimal(expression) || nullStr.equals(expression)) {
            if (info.getCalcResult() != null) {
                info.setCalculation(info.getCalcResult());
            } else {
                info.setCalculation(nullStr);
            }
            info.setDimCalculation(info.getShowStr() + "\n=" + dimExpression);
        } else if (info.getCalcResult() != null) {
            info.setCalculation(expression + "\n=" + info.getCalcResult());
            info.setDimCalculation(info.getShowStr() + "\n=" + dimExpression);
        } else {
            info.setCalculation(expression + "\n=" + nullStr);
            info.setDimCalculation(info.getShowStr() + "\n=" + dimExpression);
        }
        if (info.getChildCount() > 0) {
            for (int i = 0; i < info.getChildCount(); ++i) {
                if (!(info.getChildAt(i) instanceof BizCalcTraceInfo)) continue;
                this.calculationNew((BizCalcTraceInfo)info.getChildAt(i));
            }
        }
    }

    public int maxDepth(ICalcTraceInfo root) {
        if (!(root instanceof BizCalcTraceInfo)) {
            return 0;
        }
        BizCalcTraceInfo info = (BizCalcTraceInfo)root;
        if (info == null || info.children == null) {
            return 0;
        }
        int max = 0;
        for (int i = 0; i < info.children.size(); ++i) {
            if (!(info.children.get(i) instanceof BizCalcTraceInfo)) continue;
            max = Math.max(max, this.maxDepth(info.children.get(i)));
        }
        return 1 + max;
    }

    public void sortByDeep(Vector<ICalcTraceInfo> children) {
        Collections.sort(children, new Comparator<ICalcTraceInfo>(){

            @Override
            public int compare(ICalcTraceInfo b1, ICalcTraceInfo b2) {
                int d1 = BizCalcTraceResult.this.maxDepth(b1);
                int d2 = BizCalcTraceResult.this.maxDepth(b2);
                return d2 - d1;
            }
        });
    }

    @Deprecated
    protected void calculation() {
        String nullStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"nullStr", (Locale)this.ctx.getLocale());
        String thisDataStr = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"thisData", (Locale)this.ctx.getLocale());
        ICalcTraceInfo childInfo = null;
        String key2 = null;
        String expression = null;
        for (BizCalcTraceInfo info : this.getBizCalcTraces()) {
            if (info.getExpre() instanceof BinaryExpr && ((BinaryExpr)info.getExpre()).right != null) {
                expression = ((BinaryExpr)info.getExpre()).right.toPlanString();
                if (!info.childMember.isEmpty()) {
                    for (String key2 : info.childMember.keySet()) {
                        childInfo = info.childMember.get(key2);
                        if (childInfo.getCalcResult() == null) {
                            expression = expression.replace(key2, nullStr);
                            continue;
                        }
                        if (childInfo.getCalcResult() instanceof BigDecimal && ((BigDecimal)childInfo.getCalcResult()).compareTo(BigDecimal.ZERO) < 0) {
                            expression = expression.replace(key2, "(" + childInfo.getCalcResult().toString() + ")");
                            continue;
                        }
                        expression = expression.replace(key2, childInfo.getCalcResult().toString());
                    }
                }
            }
            if (this.checkExpressionBigDecimal(expression)) {
                if (info.getCalcResult() != null) {
                    info.setCalculation(thisDataStr + info.getCalcResult());
                    continue;
                }
                info.setCalculation(thisDataStr + nullStr);
                continue;
            }
            if (info.getCalcResult() != null) {
                info.setCalculation(thisDataStr + expression + "\n" + BizCalcTraceUtils.getSpaces(thisDataStr.length()) + "=" + info.getCalcResult());
                continue;
            }
            info.setCalculation(thisDataStr + expression + "\n" + BizCalcTraceUtils.getSpaces(thisDataStr.length()) + "=" + nullStr);
        }
    }

    protected boolean checkExpressionBigDecimal(String expression) {
        boolean isBigDecimal = true;
        try {
            new BigDecimal(expression);
        }
        catch (Exception e) {
            isBigDecimal = false;
        }
        return isBigDecimal;
    }

    public void after() {
        this.setCtx(null);
        this.orgUnitCache.clear();
        BizCalcTraceInfo root = this.getRootInfo(this.getBizCalcTraces());
        this.doAfter(root);
        List<BizCalcTraceInfo> infos = this.getBizCalcTraces();
        if (infos != null && !infos.isEmpty()) {
            for (BizCalcTraceInfo info : infos) {
                this.doAfter(info);
            }
        }
    }

    protected void doAfter(BizCalcTraceInfo info) {
        if (info == null) {
            return;
        }
        this.clear(info);
        if (info.getChildCount() > 0) {
            for (int i = 0; i < info.getChildCount(); ++i) {
                if (info.getChildAt(i) instanceof BizCalcTraceInfo) {
                    this.doAfter((BizCalcTraceInfo)info.getChildAt(i));
                    continue;
                }
                if (!(info.getChildAt(i) instanceof BizCalcValue)) continue;
                ((BizCalcValue)info.getChildAt(i)).setFiledMembers(null);
            }
        }
    }

    protected void clear(BizCalcTraceInfo info) {
        if (info == null) {
            return;
        }
        info.setScopes(null);
        info.clearMembers();
        info.clearChildMember();
        info.setLeftMembers(null);
        info.setRightMembers(null);
        info.setFiledMembers(null);
        if (info.getExpre() instanceof BinaryExpr) {
            ((BinaryExpr)info.getExpre()).left = null;
            ((BinaryExpr)info.getExpre()).right = null;
        }
    }

    public void fillValue(ICalcTraceInfo info, Object data) {
        String formulaKey = null;
        Map dataMap = (Map)data;
        String orgId2 = null;
        for (String orgId2 : dataMap.keySet()) {
            Map valueMap = (Map)dataMap.get(orgId2);
            if (orgId2.equals(info.getOrgUnitid()) && !StringUtils.isEmpty((String)info.getBgVersionNumber()) && !StringUtils.isEmpty((String)info.getFormula()) && valueMap.containsKey(formulaKey = DimUtils.getDimDataKey(info.getFormula(), info.getBgVersionNumber()))) {
                BgNDataInfo dataInfo = (BgNDataInfo)valueMap.get(formulaKey);
                if (dataInfo.getState() == 5) {
                    info.setCalcResult(dataInfo.getAdjustValue());
                } else if (dataInfo.getBizActual() != BgNConstants.ZERO) {
                    info.setCalcResult(dataInfo.getBizActual());
                } else {
                    info.setCalcResult(dataInfo.getBudgetValue());
                }
            }
            if (!(info instanceof BizCalcTraceInfo) || ((BizCalcTraceInfo)info).children == null) continue;
            ICalcTraceInfo child = null;
            for (int i = 0; i < ((BizCalcTraceInfo)info).getChildCount(); ++i) {
                child = ((BizCalcTraceInfo)info).getChildAt(i);
                if (orgId2.equals(child.getOrgUnitid()) && !StringUtils.isEmpty((String)child.getBgVersionNumber()) && !StringUtils.isEmpty((String)child.getFormula()) && valueMap.containsKey(formulaKey = DimUtils.getDimDataKey(child.getFormula(), child.getBgVersionNumber()))) {
                    BgNDataInfo dataInfo = (BgNDataInfo)valueMap.get(formulaKey);
                    if (dataInfo.getState() == 5) {
                        child.setCalcResult(dataInfo.getAdjustValue());
                    } else if (dataInfo.getBizActual() != BgNConstants.ZERO) {
                        child.setCalcResult(dataInfo.getBizActual());
                    } else {
                        child.setCalcResult(dataInfo.getBudgetValue());
                    }
                }
                if (!(child instanceof BizCalcTraceInfo) || ((BizCalcTraceInfo)child).children == null) continue;
                this.fillValue(child, data);
            }
        }
    }

    public void fillValue(ICalcTraceInfo info, Map[] CMPDataMap) {
        String formulaKey = null;
        String orgId2 = null;
        Map orgValueMap = CMPDataMap[BgProcessEnum.getEnum(info.getBgProcess()).getValue() - 1];
        for (String orgId2 : orgValueMap.keySet()) {
            Map valueMap = (Map)orgValueMap.get(orgId2);
            if (!orgId2.equals(info.getOrgUnitid()) || StringUtils.isEmpty((String)info.getBgVersionNumber()) || StringUtils.isEmpty((String)info.getFormula()) || !valueMap.containsKey(formulaKey = DimUtils.getDimDataKey(info.getFormula(), info.getBgVersionNumber()))) continue;
            BgNDataInfo dataInfo = (BgNDataInfo)valueMap.get(formulaKey);
            this.setValue(info, dataInfo);
        }
        if (info instanceof BizCalcTraceInfo && ((BizCalcTraceInfo)info).children != null) {
            ICalcTraceInfo child = null;
            for (int i = 0; i < ((BizCalcTraceInfo)info).getChildCount(); ++i) {
                child = ((BizCalcTraceInfo)info).getChildAt(i);
                if (StringUtils.isEmpty((String)child.getFormula())) continue;
                orgValueMap = CMPDataMap[BgProcessEnum.getEnum(child.getBgProcess()).getValue() - 1];
                for (String orgId2 : orgValueMap.keySet()) {
                    Map valueMap = (Map)orgValueMap.get(orgId2);
                    if (!orgId2.equals(child.getOrgUnitid()) || StringUtils.isEmpty((String)child.getBgVersionNumber()) || StringUtils.isEmpty((String)child.getFormula()) || !valueMap.containsKey(formulaKey = DimUtils.getDimDataKey(child.getFormula(), child.getBgVersionNumber()))) continue;
                    BgNDataInfo dataInfo = (BgNDataInfo)valueMap.get(formulaKey);
                    this.setValue(child, dataInfo);
                }
                if (!(child instanceof BizCalcTraceInfo) || ((BizCalcTraceInfo)child).children == null) continue;
                this.fillValue(child, CMPDataMap);
            }
        }
    }

    protected void setValue(ICalcTraceInfo info, BgNDataInfo dataInfo) {
        if (dataInfo.getState() == 5) {
            info.setCalcResult(dataInfo.getBudgetValue());
        } else if (dataInfo.getBizActual() != BgNConstants.ZERO) {
            info.setCalcResult(dataInfo.getBizActual());
        } else if (dataInfo.getAddActualValue() != BgNConstants.ZERO) {
            info.setCalcResult(dataInfo.getAddActualValue());
        } else {
            info.setCalcResult(dataInfo.getBudgetValue());
        }
    }

    public void process(Context ctx, IDimensionParameter parameter) throws Exception {
        Map<String, String> srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        Map<String, String> fieldNumbers = this.getMemberNumByFormula(srcFieldMap, this.getFormula(), this.getBgVersionNumber(), true);
        HashSet<String> bgPeriodNums = new HashSet<String>();
        bgPeriodNums.add(fieldNumbers.get(DimensionConstants.DEF_PERIOD_FIELD));
        String bgSchemeId = parameter.getBgSchemeId().toString();
        List<BizCalcInfo> allBizCalcs = this.queryAllBizCalc(ctx, bgSchemeId, bgPeriodNums);
    }

    public List<BizCalcInfo> queryAllBizCalc(Context ctx, String bgSchemeId, Set<String> bgPeriodNums) throws BOSException {
        List allBizCalcs = null;
        BizCalcQuery query = new BizCalcQuery(ctx);
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            allBizCalcs = query.queryBizCalc(conn, BOSUuid.read((String)bgSchemeId), null, null, null, false, bgPeriodNums, null);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return allBizCalcs;
    }

    public Map<String, String> getMemberNumByFormula(Map<String, String> srcFieldMap, String formula, String bgVersionNumber, boolean hasSrc) {
        TreeMap<String, String> numMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String[] params = BgNFSHelper.parseFormulaPara(formula);
        String bgItemNumber = params[0];
        if (bgItemNumber.indexOf(",") > 0) {
            String[] memArr;
            for (String mem : memArr = bgItemNumber.split(",")) {
                if (mem.indexOf(":") <= 0) continue;
                String[] arrs = mem.split(":");
                if (hasSrc) {
                    numMap.put(srcFieldMap.get(arrs[0]), mem);
                    continue;
                }
                numMap.put(srcFieldMap.get(arrs[0]), arrs[1]);
            }
        } else if (bgItemNumber.indexOf(":") > 0) {
            String[] arrs = bgItemNumber.split(":");
            if (hasSrc) {
                numMap.put(srcFieldMap.get(arrs[0]), bgItemNumber);
            } else {
                numMap.put(srcFieldMap.get(arrs[0]), arrs[1]);
            }
        }
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER), params[1]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_ELEMENT_SRCNUMBER), params[2]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_CURRENCY_SRCNUMBER), params[5]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER), params[3]);
        numMap.put(srcFieldMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER), bgVersionNumber);
        return numMap;
    }

    public void reQueryDataForm(Context ctx, BgFormInfo currentForm) throws EASBizException, BOSException {
        if (this.getBizCalcTraces() == null || this.getBizCalcTraces().isEmpty()) {
            return;
        }
        this.reQueryDataForm(ctx, currentForm, this.getRootInfo(this.getBizCalcTraces()));
    }

    public void reQueryDataForm(Context ctx, BgFormInfo currentForm, ICalcTraceInfo calcTraceInfo) throws EASBizException, BOSException {
        String orgId = calcTraceInfo.getOrgUnitid();
        String formula = calcTraceInfo.getFormula();
        if (calcTraceInfo.getCalcResult() == null) {
            calcTraceInfo.setBgFormId(null);
            calcTraceInfo.setBgFormName(null);
        } else if (StringUtils.isEmpty((String)formula) && calcTraceInfo instanceof BizCalcValue) {
            calcTraceInfo.setBgFormId(null);
            calcTraceInfo.setBgFormName(null);
        }
        if (!StringUtils.isEmpty((String)calcTraceInfo.getBgFormId())) {
            BgFormInfo reFormInfo;
            String bgschemeId = currentForm.getBgScheme().getId().toString();
            String versionNumber = calcTraceInfo.getBgVersionNumber();
            BgVersionInfo bgVersionInfo = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionInfo("where number = '" + versionNumber + "'");
            HashMap<String, String> parameter = new HashMap<String, String>();
            parameter.put("schemeId", bgschemeId);
            parameter.put("orgId", orgId);
            parameter.put("versionId", String.valueOf(bgVersionInfo.getVersionId()));
            parameter.put("formula", formula);
            parameter.put("form", calcTraceInfo.getBgFormId());
            parameter.put("templateId", currentForm.getBgTemplate().getId().toString());
            parameter.put("processType", !StringUtils.isEmpty((String)calcTraceInfo.getBgProcess()) ? calcTraceInfo.getBgProcess() : currentForm.getProcessType().getName());
            String formId = BgDimensionFacadeFactory.getLocalInstance(ctx).queryFormByData(parameter);
            if (!StringUtils.isEmpty((String)formId) && (reFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select number, name where id = '" + formId + "'")) != null) {
                calcTraceInfo.setBgFormId(reFormInfo.getId().toString());
                calcTraceInfo.setBgFormName(reFormInfo.getName());
            }
        }
        if (calcTraceInfo instanceof BizCalcTraceInfo && ((BizCalcTraceInfo)calcTraceInfo).children != null) {
            for (int i = 0; i < ((BizCalcTraceInfo)calcTraceInfo).children.size(); ++i) {
                this.reQueryDataForm(ctx, currentForm, ((BizCalcTraceInfo)calcTraceInfo).children.get(i));
            }
        }
    }

    public void checkIsDetail(IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper, ICalcTraceInfo info) {
        if (StringUtils.isEmpty((String)info.getFormula()) || parameter.getBgTemplateId() == null) {
            return;
        }
        try {
            String bgTemplateId = parameter.getBgTemplateId().toString();
            String orgUnitId = info.getOrgUnitid();
            String formula = info.getFormula();
            HashSet<String> formulas = new HashSet<String>();
            formulas.add(formula);
            String versionNumber = info.getBgVersionNumber();
            HashSet<String> versionNumbers = new HashSet<String>();
            versionNumbers.add(versionNumber);
            String process = info.getBgProcess();
            boolean isDecompose = false;
            isDecompose = !process.equals(BgProcessEnum.C01.getAlias()) && !process.equals(BgProcessEnum.C01.getName());
            DimensionMemberCheckHelper checkHelper = DimensionMemberCheckHelper.getLocalIntance(this.getCtx(), null, orgUnitId, bgTemplateId, schemeHelper, formulas, versionNumbers, isDecompose);
            if (checkHelper.canSave(formula, null, versionNumber)) {
                info.setIsDetail(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"checkIsDetail error:", (Throwable)e);
        }
    }

    public void mergeFromMembers(IDimensionParameter parameter, Map<String, Set<String>> allDimNumbers) throws Exception {
        ArrayList<IDimDataQuery> billValues = new ArrayList<IDimDataQuery>();
        billValues.add(parameter.getDataManager().getDimDataQuery());
        Map<String, Map<String, Set<String>>> formsMembersMap = BizCalcTraceUtils.parseFormDimData(this.ctx, parameter.getDataManager().getBgScheme(), billValues, parameter.getDataManager().getSrcFieldMap());
        HashMap<String, Set<String>> formMembersMap = new HashMap<String, Set<String>>();
        formMembersMap.putAll(formsMembersMap.get(parameter.getDataManager().getDimDataQuery().getId().toString()));
        if (!formMembersMap.isEmpty() && !allDimNumbers.isEmpty()) {
            for (String filed : formMembersMap.keySet()) {
                if (!allDimNumbers.containsKey(filed)) continue;
                allDimNumbers.get(filed).addAll((Collection)formMembersMap.get(filed));
            }
        }
    }

    public void printInfosLog(List<BizCalcTraceInfo> infos) {
        if (infos != null && !infos.isEmpty()) {
            BizCalcTraceInfo info = null;
            for (int i = 0; i < infos.size(); ++i) {
                info = infos.get(i);
                this.printInfoLog(info);
            }
        }
    }

    public void printInfoLog(BizCalcTraceInfo info) {
        String str = info.getSeq() + ":" + info.getBizCalcName() + "(" + info.getBizCalcNumber() + ") " + info.getBizSubName() + " " + info.originalExpr + " ";
        logger.error((Object)str);
        logger.error((Object)("formula : " + info.getFormula() + " ; orgUnitId : " + info.getOrgUnitid()));
    }
}

