/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BgAdjustBillParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BgSchemeInfo bgScheme;
    private BgElementInfo bgElement;
    private BgScenarioInfo scenario;
    private BgVersionInfo version;
    private CurrencyInfo currency;
    private BgDimensionMember indexMember;
    private BgDimensionMember refMember;
    private BgPeriodCollection periods;
    private BgProcessEnum processType;
    private Map<String, String> dimNameMap = new HashMap<String, String>();
    private String billId;
    private List<String> formula;
    private List<BgOrgUnitInfo> orgUnits = null;

    public Map<String, String> getDimNameMap() {
        return this.dimNameMap;
    }

    public BgProcessEnum getProcessType() {
        return this.processType;
    }

    public void setProcessType(BgProcessEnum processType) {
        this.processType = processType;
    }

    public BgElementInfo getBgElement() {
        return this.bgElement;
    }

    public void setBgElement(BgElementInfo bgElement) {
        this.bgElement = bgElement;
    }

    public BgScenarioInfo getScenario() {
        return this.scenario;
    }

    public void setScenario(BgScenarioInfo scenario) {
        this.scenario = scenario;
    }

    public BgVersionInfo getVersion() {
        return this.version;
    }

    public void setVersion(BgVersionInfo version) {
        this.version = version;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public BgDimensionMember getIndexMember() {
        return this.indexMember;
    }

    public void setIndexMember(BgDimensionMember indexMember) {
        this.indexMember = indexMember;
    }

    public BgDimensionMember getRefMember() {
        return this.refMember;
    }

    public void setRefMember(BgDimensionMember refMember) {
        this.refMember = refMember;
    }

    public BgPeriodCollection getPeriods() {
        return this.periods;
    }

    public void setPeriods(BgPeriodCollection periods) {
        this.periods = periods;
    }

    public BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    public void setBgScheme(BgSchemeInfo bgScheme) {
        this.bgScheme = bgScheme;
    }

    public List<BgOrgUnitInfo> getOrgUnits() {
        if (this.orgUnits == null) {
            this.orgUnits = new ArrayList<BgOrgUnitInfo>();
        }
        return this.orgUnits;
    }

    public void setOrgUnits(List<BgOrgUnitInfo> orgUnits) {
        this.orgUnits = orgUnits;
    }

    public List<String> getFormula() {
        if (this.formula == null) {
            this.formula = new ArrayList<String>();
            if (this.indexMember == null || this.bgElement == null || this.currency == null || this.scenario == null || this.periods == null || this.periods.isEmpty()) {
                return this.formula;
            }
            String indexItemNumber = this.indexMember.getSrcNumber() + ":" + this.indexMember.getNumber();
            if (this.refMember != null) {
                StringBuffer refNumber = new StringBuffer();
                String[] refItemSrcNumber = this.refMember.getSrcNumber().split(",");
                String[] refItemNumber = this.refMember.getNumber().split(",");
                if (refItemSrcNumber.length != 0 && refItemSrcNumber.length == refItemNumber.length) {
                    for (int index = 0; index < refItemSrcNumber.length; ++index) {
                        refNumber.append(refItemSrcNumber[index]).append(":").append(refItemNumber[index]).append(",");
                    }
                    refNumber.deleteCharAt(refNumber.length() - 1);
                    indexItemNumber = indexItemNumber + "," + refNumber.toString();
                }
            }
            String elementNumber = this.bgElement.getNumber();
            String currencyNumber = this.currency.getNumber();
            String scenarioNumber = this.scenario.getNumber();
            for (int index = 0; index < this.periods.size(); ++index) {
                String periodNumber = this.periods.get(index).getNumber();
                String formulaStr = BgNFSHelper.getFormulaFromParam(indexItemNumber, periodNumber, elementNumber, currencyNumber, scenarioNumber);
                if (StringUtils.isEmpty((String)formulaStr)) continue;
                this.formula.add(formulaStr);
            }
        }
        return this.formula;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }
}

