/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

public class BgDimensionMember
implements Comparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2303613143546665484L;
    private String type = null;
    private String attribute = null;
    private String name = null;
    private String number = null;
    private String alias = null;
    private int level = 1;
    private boolean isLeaf = true;
    private Comparable sortValue = null;
    private int fillType = 0;
    private String simpleName = null;
    private Timestamp disabledDate = null;
    private String longName = null;
    private String srcNumber = null;
    private boolean isHide = false;
    private boolean isLegal = true;
    private boolean isFilled = false;
    private boolean isAllowEdit = false;
    private BigDecimal version = BigDecimal.ZERO;

    private BgDimensionMember() {
    }

    public BgDimensionMember(String type, String attribute, String name, String number) {
        this.attribute = attribute;
        this.name = name;
        this.number = number;
        this.type = type;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Timestamp getDisabledDate() {
        return this.disabledDate;
    }

    public void setDisabledDate(Timestamp disabledDate) {
        this.disabledDate = disabledDate;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public boolean isHide() {
        return this.isHide;
    }

    public void setHide(boolean isHide) {
        this.isHide = isHide;
    }

    public String getSrcNumber() {
        return this.srcNumber;
    }

    public String getSrcNumberHasDefault() {
        if (this.srcNumber != null) {
            return this.srcNumber;
        }
        return DimensionFormulaHelper.getDefaultSrcNumber(this.getType());
    }

    public void setSrcNumber(String srcNumber) {
        this.srcNumber = srcNumber;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setSortValue(Comparable sortValue) {
        this.sortValue = sortValue;
    }

    public Comparable getSortValue() {
        if (this.sortValue == null) {
            return this.number;
        }
        return this.sortValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.getName())) {
            return this.getNumber();
        }
        return "[" + this.getNumber() + "]" + this.getName();
    }

    public boolean isAllowEdit() {
        return this.isAllowEdit;
    }

    public void setAllowEdit(boolean isAllowEdit) {
        this.isAllowEdit = isAllowEdit;
    }

    public BigDecimal getVersion() {
        return this.version;
    }

    public void setVersion(BigDecimal version) {
        this.version = version;
    }

    public int compareTo(Object o) {
        if (o instanceof BgDimensionMember) {
            BgDimensionMember m = (BgDimensionMember)o;
            int result = DimensionCommonHelper.compare((Comparable)((Object)this.srcNumber), (Comparable)((Object)m.srcNumber));
            if (result == 0) {
                return DimensionCommonHelper.compare(this.getSortValue(), m.getSortValue());
            }
            return result;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BgDimensionMember) {
            if (((BgDimensionMember)obj).getType() != null && !((BgDimensionMember)obj).getType().equalsIgnoreCase(this.getType())) {
                return false;
            }
            if (((BgDimensionMember)obj).getSrcNumber() != null && this.getSrcNumber() != null && !((BgDimensionMember)obj).getSrcNumber().equalsIgnoreCase(this.getSrcNumber())) {
                return false;
            }
            return ((BgDimensionMember)obj).getNumber().equalsIgnoreCase(this.getNumber());
        }
        return false;
    }

    public String getRefField() {
        String refField = DimensionFormulaHelper.getDefaultRefField(this.getType());
        if (refField != null) {
            return refField;
        }
        return this.getAttribute();
    }

    public int hashCode() {
        return this.getType().hashCode() + this.getNumber().hashCode();
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public void setLegal(boolean isLegal) {
        this.isLegal = isLegal;
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFilled(boolean isFilled) {
        this.isFilled = isFilled;
    }

    public String getCombNumber() {
        return this.getCombNumber(true);
    }

    public String getCombNumber(boolean isAddNull) {
        String[] srcNumber = this.getSrcNumber().split(",");
        String[] number = this.getNumber().split(",");
        StringBuffer result = new StringBuffer();
        if (!isAddNull || srcNumber.length == number.length) {
            for (int j = 0; j < number.length; ++j) {
                if (!isAddNull && StringUtils.isEmpty((String)number[j])) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(DimensionFormulaHelper.getCombination(srcNumber[j], number[j]));
            }
        }
        return result.toString();
    }

    public BgDimensionMember clone() throws CloneNotSupportedException {
        BgDimensionMember member = (BgDimensionMember)super.clone();
        member.setType(this.getType());
        member.setAttribute(this.getAttribute());
        member.setName(this.getName());
        member.setNumber(this.getNumber());
        member.setSortValue(this.getSortValue());
        member.setSrcNumber(this.getSrcNumber());
        member.setLongName(this.getLongName());
        member.setAlias(this.getAlias());
        return member;
    }
}

