/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import java.math.BigDecimal;

public class BgNViewDataInfo
extends BgNDataInfo {
    private static final long serialVersionUID = -3381562964434605497L;
    private String orgUnitId;
    private String id;
    private String bgSchemeId;
    private int bgVersionValue = 0;
    private BigDecimal beforYearValue = null;
    private BigDecimal curYearValue = null;

    public BgNViewDataInfo(BigDecimal oldValue) {
        this.setOldValue(oldValue);
    }

    public BgNViewDataInfo() {
    }

    public BgNViewDataInfo(BgNDataInfo dataInfo) {
        this.setOldValue(dataInfo.getOldValue());
        this.setState(dataInfo.getState());
        this.setFormType(dataInfo.getFormType());
        this.setFormula(dataInfo.getFormula());
        this.setBudgetValue(dataInfo.getBudgetValueNoDef());
        this.setTransitBudget(dataInfo.getTransitBudget());
        this.setActualValue(dataInfo.getActualValueNoDef());
        this.setAddActualValue(dataInfo.getAddActualNoDef());
        this.setBizActual(dataInfo.getBizActualNoDef());
        this.setAdjustValue(dataInfo.getAdjustValue());
        this.setBgItemId(dataInfo.getBgItemId());
        this.setBgItemNumber(dataInfo.getBgItemNumber());
        this.setBgPeriodId(dataInfo.getBgPeriodId());
        this.setBgPeriodNumber(dataInfo.getBgPeriodNumber());
        this.setBgElementId(dataInfo.getBgElementId());
        this.setBgElementNumber(dataInfo.getBgElementNumber());
        this.setCurrencyId(dataInfo.getCurrencyId());
        this.setCurrencyNumber(dataInfo.getCurrencyNumber());
        this.setBgScenario(dataInfo.getBgScenario());
        this.setBgVersion(dataInfo.getBgVersion());
        this.setBgDataSource(dataInfo.getBgDataSource());
    }

    public void setBgSchemeId(String bgSchemeId) {
        this.bgSchemeId = bgSchemeId;
    }

    public String getBgSchemeId() {
        return this.bgSchemeId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getOrgUnitId() {
        return this.orgUnitId;
    }

    @Override
    public void setOrgUnitId(String orgUnitId) {
        this.orgUnitId = orgUnitId;
    }

    public void setBgVersionValue(int bgVersionValue) {
        this.bgVersionValue = bgVersionValue;
    }

    public int getBgVersionValue() {
        return this.bgVersionValue;
    }

    public BigDecimal getExeDiff() {
        return this.getBudgetValue().subtract(this.getBizActual()).subtract(this.getTransitBudget());
    }

    public BigDecimal getExeProcess() {
        BigDecimal bgValue = this.getBudgetValueNoDef();
        if (bgValue == null || BigDecimal.ZERO.equals(bgValue)) {
            return null;
        }
        BigDecimal actValue = this.getBizActual();
        return actValue.divide(bgValue.subtract(this.getTransitBudget()), 4, 4);
    }

    public BigDecimal getExeDiffRate() {
        BigDecimal bgValue = this.getBudgetValueNoDef() != null ? this.getBudgetValueNoDef() : BigDecimal.ZERO;
        BigDecimal subtract = bgValue.subtract(this.getTransitBudget());
        if (BigDecimal.ZERO.compareTo(subtract) == 0) {
            return null;
        }
        BigDecimal exeDiff = this.getExeDiff();
        return exeDiff.divide(subtract, 4, 4);
    }

    public BigDecimal getBeforeYearAddRate(BgScenarioType type) {
        BigDecimal bgValue = this.getBeforYearValueNoDef();
        if (bgValue == null || BigDecimal.ZERO.equals(bgValue)) {
            return null;
        }
        BigDecimal value = BigDecimal.ZERO;
        if (BgScenarioType.ActualData.equals((Object)type)) {
            value = this.getBizActual();
        } else if (BgScenarioType.BudgetData.equals((Object)type)) {
            value = this.getBudgetValue();
        }
        BigDecimal exeDiff = value.subtract(bgValue);
        return exeDiff.divide(bgValue, 4, 4);
    }

    public BigDecimal getBeforYearValueNoDef() {
        return this.beforYearValue;
    }

    public void setBeforYearValue(BigDecimal beforYearValue) {
        this.beforYearValue = beforYearValue;
    }

    public BigDecimal getCurYearValue() {
        if (this.curYearValue == null) {
            return BgNConstants.ZERO;
        }
        return this.curYearValue;
    }

    public BigDecimal getCurYearValueNoDef() {
        return this.curYearValue;
    }

    public void setCurYearValue(BigDecimal curYearValue) {
        this.curYearValue = curYearValue;
    }
}

