/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeCollection;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryCollection;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeEntryTemplateInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeFactory;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCalculateSchemePeriodCollection;
import com.kingdee.eas.ma.mbg.BgCalculateSchemePeriodInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgReCalcSchemeHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateNodeCollection;
import com.kingdee.eas.ma.mbg.BgTemplateNodeFactory;
import com.kingdee.eas.ma.mbg.BgTemplateNodeInfo;
import com.kingdee.eas.ma.mbg.IBgCalculateScheme;
import com.kingdee.eas.ma.mbg.common.AbstractBgSchemeCopy;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeParam;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgReClacCopy
extends AbstractBgSchemeCopy {
    public BgReClacCopy(BgCopySchemeParam param, BgSchemeInfo scheme, boolean isAddScheme, Context ctx, BgSchemeInfo target) {
        super(param, scheme, isAddScheme, ctx, target);
    }

    @Override
    public boolean isCopy(BgCopySchemeParam param) {
        return param.isCopyReCalc() && this.getScheme() != null && this.getTarget() != null;
    }

    @Override
    protected List<BgCopySchemeResult> dealCopyByParam() throws Exception {
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        CoreBaseCollection colls = new CoreBaseCollection();
        BgSchemeInfo targetScheme = this.getTarget();
        BgSchemeDimensionHelper bgSchemeDimensionHelper = new BgSchemeDimensionHelper(this.ctx, targetScheme.getId().toString());
        String bgOrgViewId = bgSchemeDimensionHelper.getBgOrgViewId();
        EntityViewInfo view = this.getCalculateScheme(targetScheme, false);
        BgCalculateSchemeCollection targetCalculateSchemeColls = this.getCalculateSchemeInterface().getBgCalculateSchemeCollection(view);
        HashSet<String> uniKey = new HashSet<String>();
        for (int i = 0; i < targetCalculateSchemeColls.size(); ++i) {
            BgCalculateSchemeInfo bgCalculateSchemeInfo = targetCalculateSchemeColls.get(i);
            String key = this.getKey(bgCalculateSchemeInfo);
            uniKey.add(key);
        }
        BgTemplateNodeCollection nodeCols = this.getTempNodes(this.ctx, targetScheme, bgOrgViewId);
        Map<BOSUuid, Map<String, BgTemplateInfo>> templatesMap = this.getTemplateNodeMap(nodeCols);
        Date dateFrom = targetScheme.getDateFrom();
        Date dateTo = targetScheme.getDateTo();
        HashSet<String> existsOrgId = new HashSet<String>();
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(this.ctx).getBgOrgUnitCollection("where viewID ='" + bgOrgViewId + "'");
        for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
            existsOrgId.add(bgOrgUnitCollection.get(i).getOrgUnitID());
        }
        BgDimensionInfo dimensionVersion = bgSchemeDimensionHelper.getDimension(DimensionConstants.DEF_VERSION_NUMBER);
        List memberVersion = dimensionVersion.getMember();
        HashSet<String> numberVersionSet = new HashSet<String>();
        for (int i = 0; i < memberVersion.size(); ++i) {
            BgDimensionMember dimensionMember = (BgDimensionMember)memberVersion.get(i);
            numberVersionSet.add(dimensionMember.getNumber());
        }
        BgDimensionInfo dimensionCurrcy = bgSchemeDimensionHelper.getDimension(DimensionConstants.DEF_CURRENCY_NUMBER);
        List memberCurrcy = dimensionCurrcy.getMember();
        HashSet<String> numberCurrcySet = new HashSet<String>();
        for (int i = 0; i < memberCurrcy.size(); ++i) {
            BgDimensionMember dimensionMember = (BgDimensionMember)memberCurrcy.get(i);
            numberCurrcySet.add(dimensionMember.getNumber());
        }
        Set<String> periodTypeIds = BgSchemeDimensionHelper.getMemberSet(bgSchemeDimensionHelper.getDimension(DimensionConstants.DEF_PERIOD_NUMBER), false);
        BgSchemeInfo sourceScheme = this.getScheme();
        view = this.getCalculateScheme(sourceScheme, true);
        BgCalculateSchemeCollection bgCalculateSchemeCollection = this.getCalculateSchemeInterface().getBgCalculateSchemeCollection(view);
        if (bgCalculateSchemeCollection == null || bgCalculateSchemeCollection.isEmpty()) {
            return result;
        }
        BgCopySchemeResult item = null;
        block6: for (int i = 0; i < bgCalculateSchemeCollection.size(); ++i) {
            BgCalculateSchemeInfo bgCalculateSchemeInfo = bgCalculateSchemeCollection.get(i);
            bgCalculateSchemeInfo.setId(BOSUuid.create((BOSObjectType)bgCalculateSchemeInfo.getBOSType()));
            bgCalculateSchemeInfo.setRootId(bgCalculateSchemeInfo.getId());
            FullOrgUnitInfo orgUnit = bgCalculateSchemeInfo.getOrgUnit();
            BOSUuid orgId = orgUnit.getId();
            String key = this.getKey(bgCalculateSchemeInfo);
            if (uniKey.contains(key)) continue;
            if (!existsOrgId.contains(orgUnit.getId().toString())) {
                String baseMsg = EASResource.getString((String)this.RES, (String)"reCalc");
                String name = this.getName(bgCalculateSchemeInfo);
                String orgName = this.getOrgName(bgCalculateSchemeInfo);
                String copyResult = EASResource.getString((String)this.RES, (String)"notExistsOrgInCalcScheme");
                item = new BgCopySchemeResult();
                item.setBaseMsg(baseMsg);
                item.setName(name);
                item.setOrgName(orgName);
                item.setCopyResult(copyResult);
                result.add(item);
                continue;
            }
            BgVersionInfo bgVersion = bgCalculateSchemeInfo.getBgVersion();
            String numberVersion = bgVersion.getNumber();
            CurrencyInfo currency = bgCalculateSchemeInfo.getCurrency();
            String numberCurr = currency.getNumber();
            if (!numberVersionSet.contains(numberVersion) || !numberCurrcySet.contains(numberCurr)) {
                String baseMsg = EASResource.getString((String)this.RES, (String)"reCalc");
                String name = this.getName(bgCalculateSchemeInfo);
                String orgName = this.getOrgName(bgCalculateSchemeInfo);
                String copyResult = EASResource.getString((String)this.RES, (String)"notExistsMemberInCalcScheme");
                item = new BgCopySchemeResult();
                item.setBaseMsg(baseMsg);
                item.setName(name);
                item.setOrgName(orgName);
                item.setCopyResult(copyResult);
                result.add(item);
                continue;
            }
            Map<String, BgTemplateInfo> map = templatesMap.get(orgId);
            Set<String> set4TemplateNumber = null;
            if (map != null) {
                set4TemplateNumber = map.keySet();
            }
            if (set4TemplateNumber == null || set4TemplateNumber.isEmpty()) {
                bgCalculateSchemeInfo.getEntry().clear();
            }
            BgCalculateSchemeEntryCollection entry = bgCalculateSchemeInfo.getEntry();
            Iterator iter = entry.iterator();
            while (iter.hasNext()) {
                BgPeriodInfo periodInfo;
                BgCalculateSchemeEntryInfo bgCalculateSchemeEntryInfo = (BgCalculateSchemeEntryInfo)iter.next();
                BgCalculateSchemeEntryTemplateInfo template = bgCalculateSchemeEntryInfo.getTemplate();
                BgTemplateInfo templateInfo = template.getTemplate();
                if (set4TemplateNumber != null && !set4TemplateNumber.contains(templateInfo.getNumber())) {
                    iter.remove();
                    continue;
                }
                templateInfo.setId(map.get(templateInfo.getNumber()).getId());
                template.setTemplate(templateInfo);
                template.setId(BOSUuid.create((BOSObjectType)template.getBOSType()));
                template.setEntry(bgCalculateSchemeEntryInfo);
                bgCalculateSchemeEntryInfo.setBgCalculateScheme(bgCalculateSchemeInfo);
                bgCalculateSchemeEntryInfo.setId(BOSUuid.create((BOSObjectType)bgCalculateSchemeEntryInfo.getBOSType()));
                BgCalculateSchemePeriodCollection periods = template.getPeriod();
                HashSet<String> pset = new HashSet<String>();
                Iterator ite = periods.iterator();
                while (ite.hasNext()) {
                    BgCalculateSchemePeriodInfo calcPeriod = (BgCalculateSchemePeriodInfo)ite.next();
                    calcPeriod.setId(BOSUuid.create((BOSObjectType)calcPeriod.getBOSType()));
                    calcPeriod.setTemplate(template);
                    periodInfo = calcPeriod.getPeriod();
                    if (periodInfo.getBeginDate().before(dateFrom) || periodInfo.getEndDate().after(dateTo)) {
                        ite.remove();
                        continue;
                    }
                    pset.add(periodInfo.getId().toString());
                }
                if (!pset.isEmpty()) {
                    BgPeriodDispCollection bgPeriodDispCollection = this.getPeriodDisp(periodTypeIds, pset);
                    if (!bgPeriodDispCollection.isEmpty()) {
                        HashSet<String> pset2 = new HashSet<String>();
                        for (int j = 0; j < bgPeriodDispCollection.size(); ++j) {
                            pset2.add(bgPeriodDispCollection.get(j).getBgPeriod().getId().toString());
                        }
                        Iterator ite2 = periods.iterator();
                        while (ite2.hasNext()) {
                            BgCalculateSchemePeriodInfo calcPeriod = (BgCalculateSchemePeriodInfo)ite2.next();
                            BgPeriodInfo periodInfo2 = calcPeriod.getPeriod();
                            if (pset2.contains(periodInfo2.getId().toString())) continue;
                            ite2.remove();
                        }
                    } else {
                        periods.clear();
                    }
                }
                if (periods == null || periods.isEmpty() || pset.isEmpty()) {
                    String baseMsg = EASResource.getString((String)this.RES, (String)"reCalc");
                    String name = this.getName(bgCalculateSchemeInfo);
                    String orgName = this.getOrgName(bgCalculateSchemeInfo);
                    String copyResult = EASResource.getString((String)this.RES, (String)"notExistsMemberInCalcScheme");
                    item = new BgCopySchemeResult();
                    item.setBaseMsg(baseMsg);
                    item.setName(name);
                    item.setOrgName(orgName);
                    item.setCopyResult(copyResult);
                    result.add(item);
                    continue block6;
                }
                StringBuffer periodAlias = new StringBuffer();
                for (int p = 0; p < periods.size(); ++p) {
                    periodInfo = periods.get(p).getPeriod();
                    if (periodAlias.length() > 0) {
                        periodAlias.append(";");
                    }
                    periodAlias.append(periodInfo.getName()).append("(").append(periodInfo.getNumber().split("\\.")[0]).append(")");
                }
                bgCalculateSchemeInfo.setPeriodNums(periodAlias.toString());
            }
            if (bgCalculateSchemeInfo.getEntry() == null || bgCalculateSchemeInfo.getEntry().isEmpty()) {
                String baseMsg = EASResource.getString((String)this.RES, (String)"reCalc");
                String name = this.getName(bgCalculateSchemeInfo);
                String orgName = this.getOrgName(bgCalculateSchemeInfo);
                String copyResult = EASResource.getString((String)this.RES, (String)"notExistsMemberInCalcScheme");
                item = new BgCopySchemeResult();
                item.setBaseMsg(baseMsg);
                item.setName(name);
                item.setOrgName(orgName);
                item.setCopyResult(copyResult);
                result.add(item);
                continue;
            }
            if (this.isAddScheme()) {
                bgCalculateSchemeInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bgCalculateSchemeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            } else {
                bgCalculateSchemeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            }
            bgCalculateSchemeInfo.setBgScheme(targetScheme);
            if (this.isAddScheme()) {
                bgCalculateSchemeInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                bgCalculateSchemeInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bgCalculateSchemeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                bgCalculateSchemeInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            } else {
                bgCalculateSchemeInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                bgCalculateSchemeInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            }
            colls.add((CoreBaseInfo)bgCalculateSchemeInfo);
        }
        if (!colls.isEmpty()) {
            this.getCalculateSchemeInterface().saveBatchData(colls);
        }
        return result;
    }

    private BgPeriodDispCollection getPeriodDisp(Set periodTypeIds, Set<String> pset) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)periodTypeIds, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", pset, CompareType.INCLUDE));
        BgPeriodDispCollection bgPeriodDispCollection = BgPeriodDispFactory.getLocalInstance((Context)this.ctx).getBgPeriodDispCollection(evi);
        return bgPeriodDispCollection;
    }

    private BgTemplateNodeCollection getTempNodes(Context ctx, BgSchemeInfo targetScheme, String bgOrgViewId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.number");
        evi.getSelector().add("bgTemplate.name");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.number");
        evi.getSelector().add("orgUnit.name");
        evi.getSelector().add("orgUnit.longNumber");
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("bgTemplate.number"));
        evi.getSorter().add(new SorterItemInfo("orgUnit.number"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("select forgUnitid from T_mbg_BgorgUnit where fisouSealup = 0 and FIsVirtual = 0 and fviewID = '" + bgOrgViewId + "'"), CompareType.INNER));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.bgScheme.id", (Object)targetScheme.getId()));
        BgTemplateNodeCollection nodeCols = BgTemplateNodeFactory.getLocalInstance(ctx).getBgTemplateNodeCollection(evi);
        return nodeCols;
    }

    private Map<BOSUuid, Map<String, BgTemplateInfo>> getTemplateNodeMap(BgTemplateNodeCollection nodeCols) {
        HashMap<BOSUuid, Map<String, BgTemplateInfo>> templatesMap = new HashMap<BOSUuid, Map<String, BgTemplateInfo>>();
        for (int i = 0; i < nodeCols.size(); ++i) {
            BgTemplateNodeInfo bgTemplateNodeInfo = nodeCols.get(i);
            BOSUuid orgId = bgTemplateNodeInfo.getOrgUnit().getId();
            BgTemplateInfo bgTemplate = bgTemplateNodeInfo.getBgTemplate();
            if (!templatesMap.containsKey(orgId)) {
                templatesMap.put(orgId, new HashMap());
            }
            Map map = (Map)templatesMap.get(orgId);
            map.put(bgTemplate.getNumber(), bgTemplate);
        }
        return templatesMap;
    }

    private IBgCalculateScheme getCalculateSchemeInterface() throws BOSException {
        return BgCalculateSchemeFactory.getLocalInstance(this.ctx);
    }

    private String getKey(BgCalculateSchemeInfo bgCalculateSchemeInfo) {
        FullOrgUnitInfo orgUnit = bgCalculateSchemeInfo.getOrgUnit();
        String numberOrg = orgUnit.getNumber();
        String numberCalc = bgCalculateSchemeInfo.getNumber();
        String key = numberOrg + "_" + numberCalc;
        return key;
    }

    private String getOrgName(BgCalculateSchemeInfo bgCalculateSchemeInfo) {
        return bgCalculateSchemeInfo.getOrgUnit().getNumber() + "(" + bgCalculateSchemeInfo.getOrgUnit().getName() + ")";
    }

    private String getName(BgCalculateSchemeInfo bgCalculateSchemeInfo) {
        return bgCalculateSchemeInfo.getName() + "(" + bgCalculateSchemeInfo.getNumber() + ")";
    }

    private EntityViewInfo getCalculateScheme(BgSchemeInfo sourceScheme, boolean isRoot) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(BgReCalcSchemeHelper.getSelectors());
        view.getSelector().add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)sourceScheme.getId().toString(), CompareType.EQUALS));
        if (isRoot) {
            filter.getFilterItems().add(new FilterItemInfo("parent.id", null));
        }
        SorterItemInfo sortItem1 = new SorterItemInfo("orgUnit.number");
        sortItem1.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem1);
        SorterItemInfo sortItem2 = new SorterItemInfo("number");
        sortItem2.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem2);
        return view;
    }
}

