/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.mbg.common.AbstractBookParseHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgSheetParseHelper;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormExportProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgBookParseHelper
extends AbstractBookParseHelper {
    private static Logger logger = Logger.getLogger((String)MbgBookParseHelper.class.getName());

    public MbgBookParseHelper(IBookDimensionParse f7Parse, FullOrgUnitInfo orgUnitInfo, Map<String, IMbgViewManager> bgViewManagerForMulOrg, Map<String, FullOrgUnitInfo> orgUnitMap, boolean isCheckFull, DimensionMemberFilterInfo memberFilter, DimensionCacheHelper cacheHelper) {
        super(f7Parse, orgUnitInfo, bgViewManagerForMulOrg, orgUnitMap, isCheckFull, memberFilter, cacheHelper);
    }

    public List<KDTextField> getAttrTxtsFromPnl(KDPanel subPnl) {
        if (subPnl == null || StringUtils.isEmpty((String)subPnl.getName()) || !subPnl.getName().endsWith("_PNL")) {
            return null;
        }
        ArrayList<KDTextField> attrList = new ArrayList<KDTextField>();
        Component component = null;
        for (int i = 0; i < subPnl.getComponentCount(); ++i) {
            component = subPnl.getComponent(i);
            if (!"PropertyKDLabelContainer".equals(component.getName())) continue;
            attrList.add((KDTextField)((KDLabelContainer)component).getBoundEditor());
        }
        return attrList;
    }

    @Override
    protected List<? extends IMbgSheetBase> getSheetManagersForStyle() {
        if (this.getBgViewManagerForStyle() != null) {
            return this.getBgViewManagerForStyle().getSheetManagers();
        }
        return null;
    }

    @Override
    protected List<? extends IMbgSheetBase> getSheetManagers(String orgUnitNumber) {
        return ((IMbgViewManager)this.getBgViewManagerForMulOrg().get(orgUnitNumber)).getSheetManagers();
    }

    @Override
    public void getSheet(CoreUIObject ownerUI, IProvider provider, String orgNumForDimensionData, Map<String, ? extends IMbgSheetBase> bgSheetManagerForMulOrg, Sheet sheet, DimensionMemberCheckFactory checkFactory, String permissionNumber) throws Exception {
        MBgTemplateHelper.logTime("Start MbgBookParseHelper.getSheet");
        try {
            Iterator<String> orgNumIterator = bgSheetManagerForMulOrg.keySet().iterator();
            while (orgNumIterator.hasNext()) {
                MBgTemplateHelper.verifyDimensionManager((IBgDimensionManager)bgSheetManagerForMulOrg.get(orgNumIterator.next()).getDimensionManager());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        MbgSheetParseHelper sheetParseHelper = null;
        if (provider instanceof MBGFormExportProvider) {
            this.getViewPnlMap().clear();
            this.getPagePnlMap().clear();
        }
        BgNFSHelper.disableUndo(sheet.getBook());
        BgNFSHelper.disableCal(sheet.getBook());
        Range r = sheet.getSheetRange();
        r = sheet.getRowRange(0, sheet.getMaxRowIndex());
        r.setIgnoreProtected(true);
        r.delete(true);
        r = sheet.getColRange(0, sheet.getMaxColIndex());
        r.setIgnoreProtected(true);
        r.delete(true);
        IMbgSheetManager sheetManagerForStyle = (IMbgSheetManager)this.getSheetManagersForStyle().get(sheet.getIndex());
        sheet.setName(sheetManagerForStyle.getSheetName());
        IBgDimensionManager dimensionManagerForStyle = sheetManagerForStyle.getDimensionManager();
        IBgDimensionManager dimensionManagerForData = (IBgDimensionManager)bgSheetManagerForMulOrg.get(orgNumForDimensionData).getDimensionManager();
        List viewDimenions = MBgTemplateHelper.getDimensions(dimensionManagerForData, MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getViewDisplayDimension()));
        List pageDimenions = MBgTemplateHelper.getDimensions(dimensionManagerForData, MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getPageDisplayDimension()));
        this.createViewOrPagePnl(ownerUI, sheet, null, dimensionManagerForData, viewDimenions, this.getViewPnlMap(), this.isViewF7Enable(), permissionNumber);
        this.createViewOrPagePnl(ownerUI, sheet, null, dimensionManagerForData, pageDimenions, this.getPagePnlMap(), this.isPageF7Enable(), permissionNumber);
        HashMap<String, IBgDimensionManager> bgDimensionManagerForMulOrg = new HashMap<String, IBgDimensionManager>();
        String orgNum2 = null;
        for (String orgNum2 : bgSheetManagerForMulOrg.keySet()) {
            bgDimensionManagerForMulOrg.put(orgNum2, (IBgDimensionManager)bgSheetManagerForMulOrg.get(orgNum2).getDimensionManager());
        }
        String curOrgId = this.getCacheHelper().getOrgUnitByNumber(orgNumForDimensionData).getId().toString();
        sheetParseHelper = new MbgSheetParseHelper(orgNumForDimensionData, this.getVersionNumber(), dimensionManagerForStyle, bgDimensionManagerForMulOrg, this.getMemberFilter(), this.isCheckFull(), this.getCacheHelper().isShowAlias(this.getOrgViewId(), curOrgId));
        List viewMembers = BgViewHelper.getCurrPageMember(this.getViewF7List(sheet.getSheetIndex()), MBgTemplateHelper.getDimensions((IBgDimensionManagerBase)bgDimensionManagerForMulOrg.get(orgNumForDimensionData), MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getViewDisplayDimension())));
        List pageMembers = BgViewHelper.getCurrPageMember(this.getPageF7List(sheet.getSheetIndex()), MBgTemplateHelper.getDimensions((IBgDimensionManagerBase)bgDimensionManagerForMulOrg.get(orgNumForDimensionData), MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getPageDisplayDimension())));
        sheetParseHelper.setViewMembers(viewMembers);
        sheetParseHelper.setPageMembers(pageMembers);
        sheetParseHelper.parseRowAndColDimension(sheet, this.getColHeadStyle(dimensionManagerForStyle.getFormStyleInfo()), this.getDataStyleWithoutNumberFormat(dimensionManagerForStyle.getFormStyleInfo()), checkFactory);
        int headerRowCount = this.parseStyle(dimensionManagerForStyle, sheet, this.getCacheHelper().getOrgUnitByNumber(orgNumForDimensionData).getName());
        BgNFSHelper.setSheetProtection(sheet, true, dimensionManagerForStyle.getSheetOperation());
        HashMap bgDataMap = new HashMap();
        BgDimensionMember orgDimMember = this.getCurOrgMemberForOnCol(orgNumForDimensionData, dimensionManagerForData);
        BgDimensionParseCommonHelper.parseBgItem(this.getCtx(), 0, sheet, viewMembers, pageMembers, bgDataMap, this.getDataStyle(dimensionManagerForStyle.getFormStyleInfo()), headerRowCount, this.isCheckFull(), sheetParseHelper.getMbgRowDatas(), orgNumForDimensionData, provider, DimensionCommonHelper.getItemFields(dimensionManagerForStyle.getSheet()), orgDimMember);
        sheetParseHelper.clear();
        BgNFSHelper.disableUndo(sheet.getBook());
        BgNFSHelper.disableCal(sheet.getBook());
        StyleAttributes s1 = Styles.getEmptySA();
        s1.setWrapText(true);
        sheet.appendSSA((ShareStyleAttributes)s1);
        StyleAttributes sa = Styles.getEmptySA();
        StyleAttributes saInnerBorder = Styles.getEmptySA();
        sa.setBorderColor(Styles.Position.LEFT, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.RIGHT, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.TOP, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        saInnerBorder.setBorderColor(Styles.Position.INNER_H, Color.LIGHT_GRAY);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_H, LineStyle.SINGLE_LINE);
        saInnerBorder.setBorderColor(Styles.Position.INNER_V, Color.LIGHT_GRAY);
        saInnerBorder.setBorderLineStyle(Styles.Position.INNER_V, LineStyle.SINGLE_LINE);
        MBgTemplateHelper.setRangeStyle(sheet, 0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), sa, saInnerBorder);
        this.setWidthStyle(sheet, sheetManagerForStyle);
        this.setSpliteInfo(sheet, sheetManagerForStyle);
        if (this.isReadonly()) {
            MBgTemplateHelper.setSheetLocked(sheet);
        }
        BgNFSHelper.enableUndo(sheet.getBook());
        long endTime = System.currentTimeMillis();
        MBgTemplateHelper.logTime("End MbgBookParseHelper.getSheet");
    }

    private BgDimensionMember getCurOrgMemberForOnCol(String orgNumForDimensionData, IBgDimensionManager dimensionManagerForData) {
        if (MBgTemplateHelper.isOrgOnCol(dimensionManagerForData)) {
            List dimensions = dimensionManagerForData.getColDisplayDimension();
            for (int i = 0; i < dimensions.size(); ++i) {
                BgDimensionInfo bgDimensionInfo = (BgDimensionInfo)dimensions.get(i);
                if (!MBGLayoutConstants.BG_ORGANIZATION.equals(bgDimensionInfo.getNumber())) continue;
                for (int j = 0; j < bgDimensionInfo.getMember().size(); ++j) {
                    BgDimensionMember itemDimMember = (BgDimensionMember)bgDimensionInfo.getMember().get(j);
                    if (!orgNumForDimensionData.equals(itemDimMember.getNumber())) continue;
                    return itemDimMember;
                }
            }
        }
        return null;
    }

    private int parseStyle(IBgDimensionManager dimensionManager, Sheet sheet, String orgName) {
        if (dimensionManager == null || sheet == null) {
            return 0;
        }
        int maxRowIndex = -1;
        Range lockRange = sheet.getRange(-1, -1, -1, -1);
        Row row = null;
        Cell cell = null;
        StyleAttributes sa = null;
        int rowIndex = 0;
        if (!StringUtils.isEmpty((String)dimensionManager.getFormStyleInfo().getFormName())) {
            row = BgNFSHelper.addRow(sheet, rowIndex);
            ++rowIndex;
            Range r = sheet.getRange(row.getRow(), 0, row.getRow(), sheet.getMaxColIndex());
            r.setIgnoreProtected(true);
            r.merge();
            cell = MBgTemplateHelper.getCell(sheet, 0, 0, true);
            cell.setUserObject("isHeaderCell", (Object)true);
            BgNFSHelper.setValue(cell, dimensionManager.getFormStyleInfo().getFormName());
            sa = Styles.getEmptySA();
            sa.setFont(dimensionManager.getFormStyleInfo().getFormStyleAttributes().getFont());
            sa.setFontSize(dimensionManager.getFormStyleInfo().getFormStyleAttributes().getFontSize());
            sa.setBold(dimensionManager.getFormStyleInfo().getFormStyleAttributes().isBold());
            sa.setItalic(dimensionManager.getFormStyleInfo().getFormStyleAttributes().isItalic());
            sa.setUnderline(dimensionManager.getFormStyleInfo().getFormStyleAttributes().isUnderline());
            sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            MBgTemplateHelper.setRangeStyle(r, sa, null);
            ++maxRowIndex;
            lockRange.addAll((SortedCellBlockArray)r);
        }
        boolean[][] position = new boolean[4][3];
        if (!StringUtils.isEmpty((String)dimensionManager.getFormStyleInfo().getUnitName())) {
            String unitname = dimensionManager.getFormStyleInfo().getUnitName();
            if ("=MbgGetCurrentOrg(\"Name\")".equalsIgnoreCase(unitname)) {
                unitname = orgName;
            }
            maxRowIndex = this.setUnitText(sheet, lockRange, this.getString("com.kingdee.eas.ma.mbg.DimensionCommonResource", "unitTitle"), unitname, false, dimensionManager.getFormStyleInfo().isUnitAppointPosition() ? dimensionManager.getFormStyleInfo().getUnitPosition() : "", dimensionManager.getFormStyleInfo().getUnitHorizontalAlign(), maxRowIndex, position, rowIndex);
        }
        if (!StringUtils.isEmpty((String)dimensionManager.getFormStyleInfo().getDateName())) {
            maxRowIndex = this.setUnitText(sheet, lockRange, this.getString("com.kingdee.eas.ma.mbg.DimensionCommonResource", "dateTitle"), dimensionManager.getFormStyleInfo().getDateName(), false, dimensionManager.getFormStyleInfo().isDateAppointPosition() ? dimensionManager.getFormStyleInfo().getDatePosition() : "", dimensionManager.getFormStyleInfo().getDateHorizontalAlign(), maxRowIndex, position, rowIndex);
        }
        if (!StringUtils.isEmpty((String)dimensionManager.getFormStyleInfo().getFormNumberName())) {
            maxRowIndex = this.setUnitText(sheet, lockRange, this.getString("com.kingdee.eas.ma.mbg.DimensionCommonResource", "formNumber"), dimensionManager.getFormStyleInfo().getFormNumberName(), true, dimensionManager.getFormStyleInfo().isFormNumberAppointPosition() ? dimensionManager.getFormStyleInfo().getFormNumberPosition() : "", dimensionManager.getFormStyleInfo().getFormNumberHorizontalAlign(), maxRowIndex, position, rowIndex);
        }
        if (dimensionManager.getFormStyleInfo().isMeasureUnitIsShow()) {
            maxRowIndex = this.setUnitText(sheet, lockRange, this.getString("com.kingdee.eas.ma.mbg.DimensionCommonResource", "measureUnit"), dimensionManager.getDefaultMeasureUnit().getName(), false, dimensionManager.getFormStyleInfo().getMeasureUnitPosition(), dimensionManager.getFormStyleInfo().getMeasureUnitHorizontalAlign(), maxRowIndex, position, rowIndex);
        }
        BgViewHelper.setLocked(true, lockRange);
        return maxRowIndex + 1;
    }

    private int setUnitText(Sheet sheet, Range lockRange, String title, String name, boolean isNumberFormat, String position, int horizontalAlign, int maxRowIndex, boolean[][] positionArr, int startRowIndex) {
        int rowIndex = -1;
        int colIndex = -1;
        if (!StringUtils.isEmpty((String)position)) {
            SheetBaseMath.getColumnIndexByName((String)"");
            if (TableToolkit.isCellRef((String)position)) {
                Rect rect = TableToolkit.range2xy((String)position);
                rowIndex = rect.y1;
                colIndex = rect.x1;
            }
        }
        if (rowIndex >= 0 && colIndex >= 0) {
            colIndex = colIndex > sheet.getMaxColIndex() ? sheet.getMaxColIndex() : colIndex;
        } else {
            int i;
            int align = horizontalAlign;
            if (1 == align) {
                colIndex = 0;
                for (i = 0; i < positionArr.length; ++i) {
                    if (positionArr[i][0]) continue;
                    rowIndex = i + startRowIndex;
                    break;
                }
                positionArr[rowIndex - startRowIndex][0] = true;
            } else if (2 == align) {
                colIndex = sheet.getMaxColIndex() / 2;
                for (i = 0; i < positionArr.length; ++i) {
                    if (positionArr[i][1]) continue;
                    rowIndex = i + startRowIndex;
                    break;
                }
                positionArr[rowIndex - startRowIndex][1] = true;
            } else if (3 == align) {
                colIndex = sheet.getMaxColIndex() - 1 >= 0 ? sheet.getMaxColIndex() - 1 : sheet.getMaxColIndex();
                for (i = 0; i < positionArr.length; ++i) {
                    if (positionArr[i][2]) continue;
                    rowIndex = i + startRowIndex;
                    break;
                }
                positionArr[rowIndex - startRowIndex][2] = true;
            }
        }
        if (rowIndex >= 0 && colIndex >= 0) {
            for (int i = maxRowIndex + 1; i <= rowIndex; ++i) {
                BgNFSHelper.addRow(sheet, i, false);
                ++maxRowIndex;
            }
            maxRowIndex = maxRowIndex > rowIndex ? maxRowIndex : rowIndex;
            Cell cell = MBgTemplateHelper.getCell(sheet, rowIndex, colIndex, true);
            cell.setUserObject("isHeaderCell", (Object)true);
            BgNFSHelper.setValue(cell, title);
            cell.setSSA((ShareStyleAttributes)MbgBookParseHelper.getStyle(cell.getStyle(), horizontalAlign));
            cell = MBgTemplateHelper.getCell(sheet, rowIndex, colIndex + 1, true);
            cell.setUserObject("isHeaderCell", (Object)true);
            if (TableToolkit.isFormulaLine((String)name)) {
                BgNFSHelper.setExpression(cell, name);
            } else {
                BgNFSHelper.setValue(cell, name);
            }
            if (isNumberFormat) {
                BgNFSHelper.setNumberFormat(cell, "@");
            }
            lockRange.addAll((SortedCellBlockArray)sheet.getRange(rowIndex, colIndex, rowIndex, colIndex + 1));
        }
        return maxRowIndex;
    }

    public static Style getStyle(Style cellStyle, int align) {
        StyleAttributes style = Styles.getSA((ShareStyleAttributes)cellStyle);
        style.setHorizontalAlign(ViewListStyleHelper.convertHorizontalAlign(align));
        return new Style((ShareStyleAttributes)style);
    }

    public IMbgViewManager getBgViewManagerForStyle() {
        return (IMbgViewManager)this.getBgViewManagerForMulOrg().get(this.getOrgUnitInfo().getNumber());
    }
}

