/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IDimensionColumn;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.RelationUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.ExtendColIndexComparator;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgSheetParseHelper {
    private static Logger logger = Logger.getLogger((String)MbgSheetParseHelper.class.getName());
    private Map<String, MBGRowData> mbgRowDatas = new HashMap<String, MBGRowData>();
    private Map<String, IBgDimensionManager> bgDimensionManagerForMulOrg = new HashMap<String, IBgDimensionManager>();
    private IBgDimensionManager bgDimensionManagerForStyle = null;
    private String curOrgNum = null;
    private List<BgDimensionMember> viewMembers = null;
    private List<BgDimensionMember> pageMembers = null;
    private DimensionMemberFilterInfo memberFilter = null;
    private boolean isCheckFull = true;
    private String versionNumber = null;
    private boolean isShowAlias = false;

    public MbgSheetParseHelper(String orgUnitNum, String versionNumber, IBgDimensionManager bgDimensionManagerForStyle, Map<String, IBgDimensionManager> bgDimensionManagerForMulOrg, DimensionMemberFilterInfo memberFilter, boolean isCheckFull, boolean isShowAlias) {
        this.bgDimensionManagerForMulOrg.putAll(bgDimensionManagerForMulOrg);
        this.bgDimensionManagerForStyle = bgDimensionManagerForStyle;
        this.versionNumber = versionNumber;
        this.curOrgNum = orgUnitNum;
        this.memberFilter = memberFilter;
        this.isCheckFull = isCheckFull;
        this.isShowAlias = isShowAlias;
    }

    public IBgDimensionManager getBgDimensionManagerForStyle() {
        return this.bgDimensionManagerForStyle;
    }

    public IBgDimensionManager getBgDimensionManagerForData() {
        return this.bgDimensionManagerForMulOrg.get(this.curOrgNum);
    }

    public void parseRowAndColDimension(Sheet sheet, StyleAttributes colHeaderStyle, StyleAttributes dataStyle, DimensionMemberCheckFactory checkFactory) throws Exception {
        BgDimensionParseCommonHelper.setSheetStyle(sheet, this.getBgDimensionManagerForData(), dataStyle);
        Range colHeaderStyleRange = sheet.getRange(-1, -1, -1, -1);
        boolean startRowIndex = false;
        int startColIndex = 0;
        int startColMergeIndex = 0;
        this.loadEffectiveItemCombin(checkFactory);
        if (this.getRowDimensionForStyle().size() > 0) {
            startColIndex = this.parseRowDimension(sheet, checkFactory);
        }
        startColMergeIndex = startColIndex = this.parseCalculateCol(sheet, startColIndex, 0, this.getShowCount(this.getColDimensionForStyle()));
        if (this.getColDimensionForStyle().size() > 0) {
            startColIndex = this.parseColDimension(sheet, startColIndex, checkFactory);
        }
        this.parseDescriptionCol(sheet, startColIndex, 0, this.getShowCount(this.getColDimensionForStyle()));
        this.parseFixedPositionExtendCol(sheet, 0, this.getShowCount(this.getColDimensionForStyle()));
        this.mergeCol(startColMergeIndex, sheet.getMaxColIndex(), 0, this.getShowCount(this.getColDimensionForStyle()) - 1, sheet);
        colHeaderStyleRange.addAll((SortedCellBlockArray)sheet.getRange(0, 0, this.getShowCount(this.getColDimensionForStyle()) - 1, sheet.getMaxColIndex()));
        MBgTemplateHelper.logTime("start MBgTemplateHelper.setRangeStyle s colHeaderStyle");
        colHeaderStyle.setWrapText(true);
        MBgTemplateHelper.setRangeStyle(colHeaderStyleRange, colHeaderStyle, null);
        MBgTemplateHelper.logTime("start MBgTemplateHelper.setRangeStyle s dataStyle");
        MBgTemplateHelper.logTime("end MBgTemplateHelper.setRangeStyle s dataStyle");
        checkFactory.clearDimensionRelation();
    }

    private void mergeCol(int startColIndex, int endColIndex, int rowIndex, int endRowIndex, Sheet sheet) {
        if (rowIndex == endRowIndex || startColIndex >= endColIndex || rowIndex > endRowIndex) {
            return;
        }
        Cell cell = null;
        Cell nextCell = null;
        int startMergeColIndex = startColIndex;
        int endMergeColIndex = startColIndex;
        boolean isEquas = false;
        for (int i = startColIndex; i < endColIndex; ++i) {
            cell = MBgTemplateHelper.getCell(sheet, rowIndex, i, false);
            nextCell = MBgTemplateHelper.getCell(sheet, rowIndex, i + 1, false);
            isEquas = false;
            BgDimensionMember member1 = BgDimensionParseCommonHelper.getCellMember(cell);
            BgDimensionMember member2 = BgDimensionParseCommonHelper.getCellMember(nextCell);
            if (member1 != null || member2 != null) {
                isEquas = DimensionCommonHelper.isEquals(member1, member2);
            } else if (cell != null && nextCell != null && sheet.getMergeBlock(rowIndex, i) == null && sheet.getMergeBlock(rowIndex, i + 1) == null && cell.getText() != null && nextCell.getText() != null && cell.getText().equals(nextCell.getText())) {
                isEquas = true;
            }
            if (isEquas) {
                endMergeColIndex = i + 1;
                if (i + 1 < endColIndex) continue;
            }
            if (startMergeColIndex < endMergeColIndex) {
                Range r = sheet.getRange(rowIndex, startMergeColIndex, rowIndex, endMergeColIndex);
                r.setIgnoreProtected(true);
                StyleAttributes sa = Styles.getEmptySA();
                sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                r.merge();
                MBgTemplateHelper.setRangeStyle(r, sa, null);
                this.mergeCol(startMergeColIndex, endMergeColIndex, rowIndex + 1, endRowIndex, sheet);
            }
            startMergeColIndex = i + 1;
            endMergeColIndex = i + 1;
        }
    }

    private void parseFixedPositionExtendCol(Sheet sheet, int startRowIndex, int endRowIndex) {
        int i;
        ArrayList<IDimensionColumn> leaveCol = new ArrayList<IDimensionColumn>();
        HashSet<String> numbers = new HashSet<String>(MBgTemplateHelper.getDimensionsNum(this.getBgDimensionManagerForStyle().getRowDisplayDimension()));
        HashSet<String> descDimNums = new HashSet<String>(MBgTemplateHelper.getDimensionsNum(BgDescriptionColumn.getDescriptionBindDimension(this.getBgDimensionManagerForStyle())));
        if (this.getBgDimensionManagerForStyle().getAttributeCol().size() > 0) {
            BgAttributeColumn curAttr = null;
            for (i = 0; i < this.getBgDimensionManagerForStyle().getAttributeCol().size(); ++i) {
                curAttr = this.getBgDimensionManagerForStyle().getAttributeCol().get(i);
                if (curAttr.getIndex() < 0 || !numbers.contains(curAttr.getDimensionInfo().getNumber())) continue;
                leaveCol.add(curAttr);
            }
        }
        if (this.getBgDimensionManagerForStyle().getCalcuteCol().size() > 0) {
            BgCalcuteColumn curCal = null;
            for (i = 0; i < this.getBgDimensionManagerForStyle().getCalcuteCol().size(); ++i) {
                curCal = this.getBgDimensionManagerForStyle().getCalcuteCol().get(i);
                if (curCal.getIndex() < 0) continue;
                leaveCol.add(curCal);
            }
        }
        if (this.getBgDimensionManagerForStyle().getDescriptionCol().size() > 0) {
            BgDescriptionColumn curDes = null;
            for (i = 0; i < this.getBgDimensionManagerForStyle().getDescriptionCol().size(); ++i) {
                curDes = this.getBgDimensionManagerForStyle().getDescriptionCol().get(i);
                HashSet<String> myBindDims = new HashSet<String>(MBgTemplateHelper.getDimensionsNum(curDes.getDimensions()));
                if (curDes.getIndex() < 0 || !myBindDims.equals(descDimNums)) continue;
                leaveCol.add(curDes);
            }
        }
        int maxColIndex = sheet.getMaxColIndex();
        if (leaveCol.size() > 0) {
            Collections.sort(leaveCol, new ExtendColIndexComparator());
            Object curObj = null;
            Column column = null;
            String bgAttrColName = null;
            for (int i2 = 0; i2 < leaveCol.size(); ++i2) {
                int rowIndex;
                int index;
                curObj = leaveCol.get(i2);
                maxColIndex = sheet.getMaxColIndex();
                if (maxColIndex < 0) {
                    maxColIndex = 0;
                }
                if (curObj instanceof BgAttributeColumn) {
                    BgAttributeColumn curProperty = curObj;
                    if (!curProperty.getDimensionInfo().isShow()) continue;
                    index = curProperty.getIndex() > maxColIndex + 1 ? maxColIndex : curProperty.getIndex();
                    column = BgNFSHelper.addColumn(sheet, index);
                    column.setUserObject("attr_col", (Object)curProperty);
                    bgAttrColName = curProperty.getColumnName();
                    for (rowIndex = startRowIndex; rowIndex < endRowIndex; ++rowIndex) {
                        BgNFSHelper.setValue(sheet.getCell(rowIndex, column.getCol(), true), StringUtils.isEmpty((String)bgAttrColName) ? curProperty.getAlias() : bgAttrColName);
                    }
                    if (endRowIndex - startRowIndex > 1) {
                        Range r = sheet.getRange(startRowIndex, column.getCol(), endRowIndex - 1, column.getCol());
                        r.setIgnoreProtected(true);
                        r.merge();
                    }
                    BgViewHelper.setLocked(true, sheet.getRange(startRowIndex, column.getCol(), sheet.getMaxRowIndex(), column.getCol()));
                } else if (curObj instanceof BgCalcuteColumn) {
                    BgCalcuteColumn curCal = curObj;
                    index = curCal.getIndex() > maxColIndex + 1 ? maxColIndex : curCal.getIndex();
                    column = BgNFSHelper.addColumn(sheet, index);
                    column.setUserObject("cal_col", (Object)curCal);
                    for (rowIndex = startRowIndex; rowIndex < endRowIndex; ++rowIndex) {
                        BgNFSHelper.setValue(sheet.getCell(rowIndex, column.getCol(), true), curCal.getAlias());
                    }
                    for (rowIndex = endRowIndex; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                        Row row = sheet.getRow(rowIndex, false);
                        if (row == null || row.getUserObjectValue("subTotal_row") != null) continue;
                        BgNFSHelper.setExpression(MBgTemplateHelper.getCell(sheet, rowIndex, column.getCol(), true), curCal.getFormula());
                    }
                    if (endRowIndex - startRowIndex > 1) {
                        Range r = sheet.getRange(startRowIndex, column.getCol(), endRowIndex - 1, column.getCol());
                        r.setIgnoreProtected(true);
                        r.merge();
                    }
                    BgViewHelper.setLocked(true, sheet.getRange(startRowIndex, column.getCol(), sheet.getMaxRowIndex(), column.getCol()));
                    StyleAttributes s1 = Styles.getEmptySA();
                    s1.setLocked(true);
                    s1.setWrapText(true);
                    s1.setNumberFormat("");
                    MBgTemplateHelper.setRangeStyle(sheet.getRange(startRowIndex, column.getCol(), sheet.getMaxRowIndex(), column.getCol()), s1, null);
                } else if (curObj instanceof BgDescriptionColumn) {
                    BgDescriptionColumn curDes = curObj;
                    index = curDes.getIndex() > maxColIndex + 1 ? maxColIndex + 1 : curDes.getIndex();
                    column = BgNFSHelper.addColumn(sheet, index);
                    column.setUserObject("des_col", (Object)curDes);
                    for (rowIndex = startRowIndex; rowIndex < endRowIndex; ++rowIndex) {
                        BgNFSHelper.setValue(sheet.getCell(rowIndex, column.getCol(), true), curDes.getAlias());
                    }
                    if (endRowIndex - startRowIndex > 1) {
                        Range r = sheet.getRange(startRowIndex, column.getCol(), endRowIndex - 1, column.getCol());
                        r.setIgnoreProtected(true);
                        r.merge();
                    }
                    BgViewHelper.setLocked(true, sheet.getRange(startRowIndex, column.getCol(), endRowIndex - 1, column.getCol()));
                }
                if (column != null && endRowIndex - startRowIndex <= 1) continue;
            }
        }
    }

    private void parseDescriptionCol(Sheet sheet, int startColIndex, int startRowIndex, int endRowIndex) {
        List<BgDescriptionColumn> desCol = this.getBgDimensionManagerForStyle().getDescriptionCol();
        HashSet<String> desDimNumbs = new HashSet<String>(MBgTemplateHelper.getDimensionsNum(BgDescriptionColumn.getDescriptionBindDimension(this.getBgDimensionManagerForStyle())));
        if (desCol != null) {
            for (int i = 0; i < desCol.size(); ++i) {
                HashSet<String> myDimNums = new HashSet<String>(MBgTemplateHelper.getDimensionsNum(desCol.get(i).getDimensions()));
                if (!desDimNumbs.equals(myDimNums) || desCol.get(i).getIndex() >= 0) continue;
                sheet.getColumn(startColIndex, true).setUserObject("des_col", (Object)desCol.get(i));
                for (int rowIndex = startRowIndex; rowIndex < endRowIndex; ++rowIndex) {
                    BgNFSHelper.setValue(sheet.getCell(rowIndex, startColIndex, true), desCol.get(i).getAlias());
                }
                if (endRowIndex - startRowIndex > 1) {
                    Range r = sheet.getRange(startRowIndex, startColIndex, endRowIndex - 1, startColIndex);
                    r.setIgnoreProtected(true);
                    r.merge();
                }
                BgViewHelper.setLocked(true, sheet.getRange(startRowIndex, startColIndex, sheet.getMaxRowIndex(), startColIndex));
                ++startColIndex;
            }
        }
    }

    public boolean isShowDescription() {
        for (int i = 0; i < this.getBgDimensionManagerForStyle().getColDisplayDimension().size(); ++i) {
            if (!((BgDimensionInfo)this.getBgDimensionManagerForStyle().getColDisplayDimension().get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
            return false;
        }
        return true;
    }

    private int parseCalculateCol(Sheet sheet, int startColIndex, int startRowIndex, int endRowIndex) {
        List<BgCalcuteColumn> calCol = this.getBgDimensionManagerForStyle().getCalcuteCol();
        if (calCol != null) {
            for (int i = 0; i < calCol.size(); ++i) {
                int rowIndex;
                if (calCol.get(i).getIndex() >= 0) continue;
                sheet.getColumn(startColIndex, true).setUserObject("cal_col", (Object)calCol.get(i));
                for (rowIndex = startRowIndex; rowIndex < endRowIndex; ++rowIndex) {
                    BgNFSHelper.setValue(sheet.getCell(rowIndex, startColIndex, true), calCol.get(i).getAlias());
                }
                if (endRowIndex - startRowIndex > 1) {
                    Range r = sheet.getRange(startRowIndex, startColIndex, endRowIndex - 1, startColIndex);
                    r.setIgnoreProtected(true);
                    r.merge();
                }
                for (rowIndex = endRowIndex; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                    Row row = sheet.getRow(rowIndex, false);
                    if (row == null || row.getUserObjectValue("subTotal_row") != null) continue;
                    BgNFSHelper.setExpression(MBgTemplateHelper.getCell(sheet, rowIndex, startColIndex, true), calCol.get(i).getFormula());
                }
                BgViewHelper.setLocked(true, sheet.getRange(startRowIndex, startColIndex, sheet.getMaxRowIndex(), startColIndex));
                ++startColIndex;
            }
        }
        return startColIndex;
    }

    private int parseRowDimension(Sheet sheet, DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        StyleAttributes align = Styles.getEmptySA();
        align.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        align.setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
        List<BgDimensionInfo> rowDimensions = this.getRowDimensionForData();
        HashMap<Integer, Integer> dimensionColPos = new HashMap<Integer, Integer>();
        int hearderRowCounts = this.getShowCount(this.getColDimensionForStyle());
        int startColIndex = 0;
        for (int dimensionIndex = 0; dimensionIndex < rowDimensions.size(); ++dimensionIndex) {
            BgDimensionInfo curDimensionInfo = rowDimensions.get(dimensionIndex);
            List<BgAttributeColumn> attrCol = MBgTemplateHelper.getPropertiesForDim(this.getBgDimensionManagerForStyle(), curDimensionInfo);
            if (curDimensionInfo.isShow()) {
                Range r;
                Column curCol = sheet.getColumn(startColIndex, true);
                for (int rowIndex = 0; rowIndex < hearderRowCounts; ++rowIndex) {
                    BgNFSHelper.setValue(sheet.getCell(rowIndex, curCol.getCol(), true), curDimensionInfo.getAlias());
                    BgDimensionParseCommonHelper.setFilterDimension(sheet.getCell(rowIndex, curCol.getCol(), true), curDimensionInfo);
                }
                if (hearderRowCounts > 1) {
                    r = sheet.getRange(0, startColIndex, hearderRowCounts - 1, startColIndex);
                    r.setIgnoreProtected(true);
                    r.merge();
                    MBgTemplateHelper.setRangeStyle(r, align, null);
                } else {
                    r = sheet.getRange(0, curCol.getCol());
                    r.setIgnoreProtected(true);
                    MBgTemplateHelper.setRangeStyle(r, align, null);
                }
                dimensionColPos.put(dimensionIndex, startColIndex);
                ++startColIndex;
                String colName = null;
                if (attrCol == null || attrCol.size() <= 0) continue;
                for (int i = 0; i < attrCol.size(); ++i) {
                    if (attrCol.get(i).getIndex() >= 0) continue;
                    Column col = sheet.getColumn(startColIndex, true);
                    col.setUserObject("attr_col", (Object)attrCol.get(i));
                    for (int rowIndex = 0; rowIndex < hearderRowCounts; ++rowIndex) {
                        colName = attrCol.get(i).getColumnName();
                        BgNFSHelper.setValue(sheet.getCell(rowIndex, col.getCol(), true), StringUtils.isEmpty((String)colName) ? attrCol.get(i).getAlias() : colName);
                    }
                    if (hearderRowCounts > 1) {
                        Range r2 = sheet.getRange(0, startColIndex, hearderRowCounts - 1, startColIndex);
                        r2.setIgnoreProtected(true);
                        r2.merge();
                    }
                    ++startColIndex;
                }
                continue;
            }
            dimensionColPos.put(dimensionIndex, -1);
        }
        ArrayList<List<BgDimensionMember>> membersForRowDimension = new ArrayList<List<BgDimensionMember>>();
        for (int dimensionIndex = 0; dimensionIndex < rowDimensions.size(); ++dimensionIndex) {
            membersForRowDimension.add(MBgTemplateHelper.getOneDimensionMembersForAllOrg(this.bgDimensionManagerForMulOrg, rowDimensions.get(dimensionIndex), sheet.getSheetName(), this.memberFilter, checkFactory));
        }
        int matchCount = this.parseRowDimension(sheet, rowDimensions, membersForRowDimension, dimensionColPos, new ArrayList<BgDimensionMember>(), 0, hearderRowCounts, checkFactory, false);
        StyleAttributes s1 = Styles.getEmptySA();
        s1.setLocked(true);
        s1.setWrapText(true);
        s1.setNumberFormat("@");
        MBgTemplateHelper.setRangeStyle(sheet.getRange(0, 0, hearderRowCounts + matchCount - 1, startColIndex - 1), s1, null);
        return startColIndex;
    }

    private int parseRowDimension(Sheet sheet, List<BgDimensionInfo> rowDimensions, List<List<BgDimensionMember>> membersForRowDimension, Map<Integer, Integer> dimensionColPos, List<BgDimensionMember> _tmpMembers, int dimensionIndex, int startRow, DimensionMemberCheckFactory checkFactory, boolean hasRelation) throws EASBizException, BOSException {
        BgDimensionMember member;
        int endRow = startRow;
        if (!this.checkFull(_tmpMembers)) {
            return 0;
        }
        if (!this.checkHasMember(_tmpMembers)) {
            return 0;
        }
        if (_tmpMembers.size() > 1 && DimensionConstants.DEF_ORGUNIT_NUMBER.equals((member = _tmpMembers.get(_tmpMembers.size() - 1)).getType()) && !StringUtils.isEmpty((String)member.getNumber()) && !this.mbgRowDatas.isEmpty()) {
            hasRelation = true;
        }
        if (_tmpMembers.size() == rowDimensions.size()) {
            if (!hasRelation || this.isInRalation(_tmpMembers)) {
                Row row = sheet.getRow(endRow, true);
                BgDimensionParseCommonHelper.addDimensionInfo(row, _tmpMembers);
                for (int i = 0; i < _tmpMembers.size(); ++i) {
                    if (dimensionColPos.get(i) == null || dimensionColPos.get(i) < 0) continue;
                    Cell cell = row.getCell(dimensionColPos.get(i).intValue(), true);
                    if (_tmpMembers.get(i).getNumber() == null) {
                        BgNFSHelper.setValue(cell, rowDimensions.get(i).getName());
                        continue;
                    }
                    BgDimensionParseCommonHelper.setValue(cell, _tmpMembers.get(i), rowDimensions.get(i).getShowType(), this.getBgDimensionManagerForData().getSheet().getViewManager(), false, this.isShowAlias);
                }
                return 1;
            }
            return 0;
        }
        if (hasRelation && !_tmpMembers.isEmpty() && !this.isInRalation(_tmpMembers)) {
            return 0;
        }
        BgDimensionInfo curDimensionInfo = rowDimensions.get(dimensionIndex);
        hasRelation = this.hasRelation(checkFactory, curDimensionInfo, _tmpMembers);
        List<BgDimensionMember> members = membersForRowDimension.get(dimensionIndex);
        boolean hasMember = false;
        if (members != null) {
            for (int memberIndex = 0; memberIndex < members.size(); ++memberIndex) {
                BgDimensionMember curMember = members.get(memberIndex);
                ArrayList<BgDimensionMember> _newTmpMembers = new ArrayList<BgDimensionMember>();
                _newTmpMembers.addAll(_tmpMembers);
                _newTmpMembers.add(curMember);
                int matchCount = this.parseRowDimension(sheet, rowDimensions, membersForRowDimension, dimensionColPos, _newTmpMembers, dimensionIndex + 1, endRow, checkFactory, hasRelation);
                if (matchCount > 0) {
                    hasMember = true;
                }
                if (matchCount > 1) {
                    Range r = sheet.getRange(endRow, dimensionColPos.get(_tmpMembers.size()).intValue(), endRow + matchCount - 1, dimensionColPos.get(_tmpMembers.size()).intValue());
                    this.mergeRowMemberRange(r);
                }
                endRow += matchCount;
            }
        }
        if (!hasMember) {
            List<BgDimensionMember> membernew = membersForRowDimension.get(dimensionIndex);
            for (int memberIndex = 0; memberIndex < membernew.size(); ++memberIndex) {
                BgDimensionMember curMember = membernew.get(memberIndex);
                ArrayList<BgDimensionMember> _newTmpMembers = new ArrayList<BgDimensionMember>();
                _newTmpMembers.addAll(_tmpMembers);
                _newTmpMembers.add(curMember);
                int matchCount = this.parseRowDimension(sheet, rowDimensions, membersForRowDimension, dimensionColPos, _newTmpMembers, dimensionIndex + 1, endRow, checkFactory, hasRelation);
                if (matchCount > 1) {
                    Range r = sheet.getRange(endRow, dimensionColPos.get(_tmpMembers.size()).intValue(), endRow + matchCount - 1, dimensionColPos.get(_tmpMembers.size()).intValue());
                    this.mergeRowMemberRange(r);
                }
                endRow += matchCount;
            }
        }
        if (endRow - startRow > 0 && curDimensionInfo.isSubTotal()) {
            Row row = BgNFSHelper.addRow(sheet, endRow);
            for (int i = 0; i < _tmpMembers.size(); ++i) {
                if (dimensionColPos.get(i) == null || dimensionColPos.get(i) < 0) continue;
                Cell cell = row.getCell(dimensionColPos.get(i).intValue(), true);
                if (_tmpMembers.get(i).getNumber() == null) {
                    BgNFSHelper.setValue(cell, rowDimensions.get(i).getName());
                    continue;
                }
                BgDimensionParseCommonHelper.setValue(cell, _tmpMembers.get(i), rowDimensions.get(i).getShowType(), this.getBgDimensionManagerForData().getSheet().getViewManager(), false, this.isShowAlias);
            }
            BgNFSHelper.setValue(row.getCell(dimensionColPos.get(_tmpMembers.size()).intValue(), true), EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"subTotal2"));
            row.setUserObject("subTotal_row", (Object)(startRow + "," + (endRow - 1)));
            ++endRow;
        }
        if (endRow - startRow > 0 && curDimensionInfo.isDimTotal()) {
            boolean flag = false;
            if (_tmpMembers.size() == 1 && (_tmpMembers.get(0).getType().equalsIgnoreCase(MBGLayoutConstants.BG_ORGANIZATION) || _tmpMembers.get(0).getType().equalsIgnoreCase(MBGLayoutConstants.BG_PERIOD) || _tmpMembers.get(0).getType().equalsIgnoreCase(MBGLayoutConstants.BG_CURRENCY) || _tmpMembers.get(0).getType().equalsIgnoreCase(MBGLayoutConstants.BG_ELEMENT))) {
                flag = true;
            }
            if (!flag) {
                Row row = BgNFSHelper.addRow(sheet, endRow);
                for (int i = 0; i < _tmpMembers.size(); ++i) {
                    if (dimensionColPos.get(i) == null || dimensionColPos.get(i) < 0) continue;
                    Cell cell = row.getCell(dimensionColPos.get(i).intValue(), true);
                    if (_tmpMembers.get(i).getNumber() == null) {
                        BgNFSHelper.setValue(cell, rowDimensions.get(i).getName());
                        continue;
                    }
                    BgDimensionParseCommonHelper.setValue(cell, _tmpMembers.get(i), rowDimensions.get(i).getShowType(), this.getBgDimensionManagerForData().getSheet().getViewManager(), false, this.isShowAlias);
                }
                BgNFSHelper.setValue(row.getCell(dimensionColPos.get(_tmpMembers.size()).intValue(), true), EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"subTotal2"));
                row.setUserObject("dimTotal_row", (Object)(startRow + "," + (endRow - 1)));
                row.setUserObject("DIMENSION", _tmpMembers);
                ++endRow;
            }
        }
        return endRow - startRow;
    }

    private boolean checkHasMember(List<BgDimensionMember> _tmpMembers) {
        if (_tmpMembers == null || _tmpMembers.isEmpty()) {
            return true;
        }
        String orgNumber = null;
        for (int i = 0; i < _tmpMembers.size(); ++i) {
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(_tmpMembers.get(i).getType())) continue;
            orgNumber = _tmpMembers.get(i).getNumber();
        }
        if (orgNumber == null || !this.bgDimensionManagerForMulOrg.containsKey(orgNumber)) {
            return true;
        }
        IBgDimensionManager dimManager = this.bgDimensionManagerForMulOrg.get(orgNumber);
        block1: for (int m = 0; m < _tmpMembers.size(); ++m) {
            BgDimensionMember member = _tmpMembers.get(m);
            if (member.getNumber() == null || DimensionConstants.DEF_ORGUNIT_NUMBER.equals(member.getType())) continue;
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                BgDimensionInfo dim = (BgDimensionInfo)dimManager.getDimension().get(d);
                if (!member.getType().equals(dim.getNumber())) continue;
                boolean hasMember = false;
                for (int m1 = 0; m1 < dim.getMember().size(); ++m1) {
                    BgDimensionMember member1 = (BgDimensionMember)dim.getMember().get(m1);
                    if (!member.getNumber().equals(member1.getNumber())) continue;
                    hasMember = true;
                    break;
                }
                if (hasMember) continue block1;
                return false;
            }
        }
        return true;
    }

    private boolean checkFull(List<BgDimensionMember> _tmpMembers) {
        if (_tmpMembers == null || _tmpMembers.isEmpty()) {
            return true;
        }
        if (this.isCheckFull) {
            for (int i = 0; i < _tmpMembers.size(); ++i) {
                if (_tmpMembers.get(i).getNumber() != null) continue;
                return false;
            }
        }
        return true;
    }

    private void mergeRowMemberRange(Range range) {
        if (range != null) {
            range.setIgnoreProtected(true);
            range.merge();
            range.setUserObject("row_member_merge", (Object)Boolean.TRUE);
            StyleAttributes sa = Styles.getEmptySA();
            sa.setVerticalAlign(Styles.VerticalAlignment.TOP);
            MBgTemplateHelper.setRangeStyle(range, sa, null);
        }
    }

    private int parseColDimension(Sheet sheet, int startColIndex, DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        List<BgDimensionInfo> colDimensions = this.getColDimensionForData();
        HashMap<Integer, Integer> dimensionRowPos = new HashMap<Integer, Integer>();
        int startRowIndex = 0;
        for (int i = 0; i < colDimensions.size(); ++i) {
            if (colDimensions.get(i).isShow()) {
                dimensionRowPos.put(i, startRowIndex);
                ++startRowIndex;
                continue;
            }
            dimensionRowPos.put(i, -1);
        }
        int matchCount = this.parseCloumnDimension(sheet, colDimensions, dimensionRowPos, new ArrayList<BgDimensionMember>(), 0, startColIndex, checkFactory, false);
        BgViewHelper.setLocked(true, sheet.getRange(0, startColIndex, startRowIndex - 1, startColIndex + matchCount - 1));
        return startColIndex + matchCount;
    }

    private int parseCloumnDimension(Sheet sheet, List<BgDimensionInfo> CloumnDimensions, Map<Integer, Integer> dimensionRowPos, List<BgDimensionMember> _tmpMembers, int dimensionIndex, int startCloumIndex, DimensionMemberCheckFactory checkFactory, boolean hasRelation) throws EASBizException, BOSException {
        int endCloumIndex = startCloumIndex;
        if (!this.checkFull(_tmpMembers)) {
            return 0;
        }
        if (_tmpMembers.size() == CloumnDimensions.size()) {
            if (!hasRelation || this.isInRalation(_tmpMembers)) {
                Column cloumn = sheet.getColumn(endCloumIndex, true);
                BgDimensionParseCommonHelper.addDimensionInfo(cloumn, _tmpMembers);
                for (int i = 0; i < _tmpMembers.size(); ++i) {
                    if (dimensionRowPos.get(i) == null || dimensionRowPos.get(i) < 0) continue;
                    Cell cell = sheet.getCell(dimensionRowPos.get(i).intValue(), cloumn.getCol(), true);
                    if (_tmpMembers.get(i).getNumber() == null) {
                        BgNFSHelper.setValue(cell, CloumnDimensions.get(i).getName());
                    } else {
                        BgDimensionParseCommonHelper.setValue(cell, _tmpMembers.get(i), CloumnDimensions.get(i).getShowType(), this.getBgDimensionManagerForData().getSheet().getViewManager(), false, this.isShowAlias);
                    }
                    BgNFSHelper.setNumberFormat(cell, "@");
                }
                return 1;
            }
            return 0;
        }
        if (hasRelation && !_tmpMembers.isEmpty() && !this.isInRalation(_tmpMembers)) {
            return 0;
        }
        BgDimensionInfo curDimensionInfo = CloumnDimensions.get(dimensionIndex);
        hasRelation = this.hasRelation(checkFactory, curDimensionInfo, _tmpMembers);
        List<BgDimensionMember> members = MBgTemplateHelper.getOneDimensionMembersForAllOrg(this.bgDimensionManagerForMulOrg, curDimensionInfo, sheet.getSheetName(), this.memberFilter, checkFactory);
        boolean hasMember = false;
        if (members != null) {
            for (int memberIndex = 0; memberIndex < members.size(); ++memberIndex) {
                BgDimensionMember curMember = members.get(memberIndex);
                ArrayList<BgDimensionMember> _newTmpMembers = new ArrayList<BgDimensionMember>();
                _newTmpMembers.addAll(_tmpMembers);
                _newTmpMembers.add(curMember);
                int matchCount = this.parseCloumnDimension(sheet, CloumnDimensions, dimensionRowPos, _newTmpMembers, dimensionIndex + 1, endCloumIndex, checkFactory, hasRelation);
                if (matchCount > 0) {
                    hasMember = true;
                }
                endCloumIndex += matchCount;
            }
        }
        if (!hasMember) {
            ArrayList<BgDimensionMember> _newTmpMembers = new ArrayList<BgDimensionMember>();
            _newTmpMembers.addAll(_tmpMembers);
            _newTmpMembers.add(new BgDimensionMember(curDimensionInfo.getNumber(), curDimensionInfo.getRefField(), null, null));
            int matchCount = this.parseCloumnDimension(sheet, CloumnDimensions, dimensionRowPos, _newTmpMembers, dimensionIndex + 1, endCloumIndex, checkFactory, hasRelation);
            endCloumIndex += matchCount;
        }
        return endCloumIndex - startCloumIndex;
    }

    private int getShowCount(List<BgDimensionInfo> dimensions) {
        int count = 0;
        if (dimensions != null) {
            for (int i = 0; i < dimensions.size(); ++i) {
                if (!dimensions.get(i).isShow()) continue;
                ++count;
            }
        }
        return count;
    }

    private void loadEffectiveItemCombin(DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        this.mbgRowDatas.clear();
        if (this.hasRelation(checkFactory, this.getBgDimensionManagerForStyle().getDimension(), this.curOrgNum)) {
            this.loadEffectiveItemCombin(this.getPageMembers(), this.getViewMembers(), checkFactory);
        }
    }

    private boolean hasRelation(DimensionMemberCheckFactory checkFactory, List<BgDimensionInfo> bgDimension, String orgNumber) throws EASBizException, BOSException {
        for (int i = 0; i < bgDimension.size(); ++i) {
            if (!this.hasRelation(checkFactory, bgDimension.get(i), orgNumber)) continue;
            return true;
        }
        return false;
    }

    private boolean hasRelation(DimensionMemberCheckFactory checkFactory, BgDimensionInfo bgDimension, List<BgDimensionMember> _tmpMembers) throws EASBizException, BOSException {
        String org = this.curOrgNum;
        if (_tmpMembers != null && !_tmpMembers.isEmpty()) {
            for (int o = 0; o < _tmpMembers.size(); ++o) {
                if (!DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(_tmpMembers.get(o).getSrcNumber())) continue;
                org = _tmpMembers.get(o).getNumber();
                break;
            }
        }
        return this.hasRelation(checkFactory, bgDimension, org);
    }

    public boolean hasRelation(DimensionMemberCheckFactory checkFactory, BgDimensionInfo bgDimension, String org) throws EASBizException, BOSException {
        if (this.bgDimensionManagerForMulOrg.get(org) == null) {
            return false;
        }
        DimensionMemberCheckHelper checkHelper = checkFactory.getHelperByNumber(org, this.bgDimensionManagerForMulOrg.get(org).getSheet().getViewManager());
        return checkHelper != null && checkHelper.hasRelation(bgDimension);
    }

    private void loadEffectiveItemCombin(List<BgDimensionMember> pageMembers, List<BgDimensionMember> viewMembers, DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        long time = System.currentTimeMillis();
        ArrayList<BgDimensionMember> newPageMembers = new ArrayList<BgDimensionMember>();
        if (pageMembers != null) {
            newPageMembers.addAll(pageMembers);
        }
        if (viewMembers != null) {
            newPageMembers.addAll(viewMembers);
        }
        boolean isOrgInView = this.getIsOrgOnPageOrView();
        String viewOrgNumber = null;
        for (int i = 0; i < newPageMembers.size(); ++i) {
            if (!DimensionConstants.ORGUNIT_NUMBER.equalsIgnoreCase(((BgDimensionMember)newPageMembers.get(i)).getType())) continue;
            viewOrgNumber = ((BgDimensionMember)newPageMembers.get(i)).getNumber();
            break;
        }
        if (isOrgInView) {
            if (viewOrgNumber == null) {
                viewOrgNumber = this.curOrgNum;
            }
            ArrayList<BgDimensionInfo> list = new ArrayList<BgDimensionInfo>();
            list.addAll(this.getColDimensionForData());
            list.addAll(this.getRowDimensionForData());
            list.addAll(this.getHideDimensionForData());
            this.loadEffectiveItemCombin(newPageMembers, list, viewOrgNumber, checkFactory);
        } else {
            Set<String> keySet = this.bgDimensionManagerForMulOrg.keySet();
            String orgNum2 = null;
            List curColDimension = null;
            List curRowDimension = null;
            for (String orgNum2 : keySet) {
                curColDimension = MBgTemplateHelper.getDimensions(this.bgDimensionManagerForMulOrg.get(orgNum2), MBgTemplateHelper.getDimensionsNum(this.getColDimensionForStyle()));
                curRowDimension = MBgTemplateHelper.getDimensions(this.bgDimensionManagerForMulOrg.get(orgNum2), MBgTemplateHelper.getDimensionsNum(this.getRowDimensionForStyle()));
                if (curColDimension == null || curRowDimension == null) continue;
                ArrayList<BgDimensionInfo> list = new ArrayList<BgDimensionInfo>();
                list.addAll(curColDimension);
                list.addAll(curRowDimension);
                list.addAll(this.getHideDimensionForData());
                this.loadEffectiveItemCombin(newPageMembers, list, orgNum2, checkFactory);
            }
        }
        System.out.println("Use Time:" + (System.currentTimeMillis() - time));
    }

    public boolean getIsOrgOnPageOrView() {
        List<BgDimensionInfo> viewDimension = this.getViewDimensionForStyle();
        for (int i = 0; i < viewDimension.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(viewDimension.get(i).getNumber())) continue;
            return Boolean.TRUE;
        }
        List<BgDimensionInfo> pageDimension = this.getPageDimensionForStyle();
        for (int i = 0; i < pageDimension.size(); ++i) {
            if (!MBGLayoutConstants.BG_ORGANIZATION.equals(pageDimension.get(i).getNumber())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void loadEffectiveItemCombin(List<BgDimensionMember> pageMembers, List<BgDimensionInfo> otherDimensions, String orgNumber, DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        RelationUtils utils = RelationUtils.getInstance(checkFactory.getSchemeHelper());
        MBGRowData mbgRowData = new MBGRowData(this.getBgDimensionManagerForStyle().getDimension(), false, checkFactory.getSchemeHelper());
        mbgRowData.setHasRelation(true);
        this.mbgRowDatas.put(orgNumber, mbgRowData);
        HashMap<String, BgDimensionMember> pageMemMap = new HashMap<String, BgDimensionMember>();
        for (int i = 0; i < pageMembers.size(); ++i) {
            pageMemMap.put(pageMembers.get(i).getType(), pageMembers.get(i));
        }
        IBgDimensionManager dimensionManager = this.bgDimensionManagerForMulOrg.get(orgNumber);
        if (dimensionManager == null) {
            return;
        }
        List<String[]> combinas = utils.queryRelation(this.getRelationMaps(dimensionManager, checkFactory), dimensionManager.getSheet());
        if (combinas != null && !combinas.isEmpty()) {
            String[] oneComb = combinas.get(0);
            mbgRowData.setRefFieldSort(oneComb);
            for (int i = 1; i < combinas.size(); ++i) {
                oneComb = combinas.get(i);
                mbgRowData.addEffectiveItemCombin(oneComb);
            }
        }
        mbgRowData.afterLoadData();
    }

    public List<MbgRelationMap> getRelationMaps(IBgDimensionManager dimensionManager, DimensionMemberCheckFactory checkFactory) throws EASBizException, BOSException {
        DimensionMemberCheckHelper checkHelper = checkFactory.getHelperByNumber(this.curOrgNum, dimensionManager.getSheet().getViewManager());
        List<MbgRelationMap> relations = dimensionManager.getSheet().getViewManager().getRelationMaps();
        if (relations == null || relations.isEmpty()) {
            HashMap<String, MbgRelationMap> maps = new HashMap<String, MbgRelationMap>();
            for (int i = 0; i < dimensionManager.getDimension().size(); ++i) {
                BgDimensionInfo dimension = (BgDimensionInfo)dimensionManager.getDimension().get(i);
                if (!DimensionMemberValueModeEnum.RelationMapping.equals((Object)dimension.getMemberValueType())) continue;
                for (int m = 0; m < dimension.getMappingList().size(); ++m) {
                    DimensionMemberRelationShipHelper shipHelper;
                    DimensionRelationshipGroupInfo group = dimension.getMappingList().get(m);
                    if (maps.containsKey(group.getId().toString()) || (shipHelper = checkHelper.getRelationHelper(group.getId().toString(), null)) == null) continue;
                    maps.put(group.getId().toString(), DimensionMemberRelationShipHelper.buildRelationMap(shipHelper, dimensionManager.getSheet().getViewManager()));
                }
            }
            relations = new ArrayList<MbgRelationMap>();
            relations.addAll(maps.values());
        }
        return relations;
    }

    private boolean isInRalation(List<BgDimensionMember> members) {
        ArrayList<BgDimensionMember> allMembers = new ArrayList<BgDimensionMember>();
        if (this.getViewMembers() != null) {
            allMembers.addAll(this.getViewMembers());
        }
        if (this.getPageMembers() != null) {
            allMembers.addAll(this.getPageMembers());
        }
        if (members != null) {
            allMembers.addAll(members);
        }
        BgDimensionMember orgMember = null;
        for (int i = 0; i < allMembers.size(); ++i) {
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionMember)allMembers.get(i)).getType())) continue;
            orgMember = (BgDimensionMember)allMembers.get(i);
            break;
        }
        String orgNumber = this.curOrgNum;
        if (orgMember != null && !StringUtils.isEmpty((String)orgMember.getNumber())) {
            orgNumber = orgMember.getNumber();
        }
        if (this.mbgRowDatas.containsKey(orgNumber)) {
            return this.mbgRowDatas.get(orgNumber).isInRalation(allMembers);
        }
        return false;
    }

    public static void addDimensionInfo(IRow row, BgDimensionMember dimensionMember) {
        if (row == null || dimensionMember == null) {
            return;
        }
        ArrayList _obj = row.getUserObject();
        if (_obj instanceof List) {
            ((List)_obj).add(dimensionMember);
        } else {
            _obj = new ArrayList();
            ((List)_obj).add(dimensionMember);
            row.setUserObject(_obj);
        }
    }

    public static void addDimensionInfo(IColumn column, BgDimensionMember dimensionMember) {
        if (column == null || dimensionMember == null) {
            return;
        }
        ArrayList _obj = column.getUserObject();
        if (_obj instanceof List) {
            ((List)_obj).add(dimensionMember);
        } else {
            _obj = new ArrayList();
            ((List)_obj).add(dimensionMember);
            column.setUserObject(_obj);
        }
    }

    public void setViewMembers(List<BgDimensionMember> viewMembers) {
        this.viewMembers = viewMembers;
    }

    public void setPageMembers(List<BgDimensionMember> pageMembers) {
        this.pageMembers = pageMembers;
    }

    public List<BgDimensionMember> getViewMembers() {
        return this.viewMembers;
    }

    public List<BgDimensionMember> getPageMembers() {
        return this.pageMembers;
    }

    public List<BgDimensionInfo> getPageDimensionForStyle() {
        return this.getBgDimensionManagerForStyle().getPageDisplayDimension();
    }

    public List<BgDimensionInfo> getPageDimensionForData() {
        return MBgTemplateHelper.getDimensions(this.getBgDimensionManagerForData(), MBgTemplateHelper.getDimensionsNum(this.getPageDimensionForStyle()));
    }

    public List<BgDimensionInfo> getViewDimensionForStyle() {
        return this.getBgDimensionManagerForStyle().getViewDisplayDimension();
    }

    public List<BgDimensionInfo> getViewDimensionForData() {
        return MBgTemplateHelper.getDimensions(this.getBgDimensionManagerForData(), MBgTemplateHelper.getDimensionsNum(this.getViewDimensionForStyle()));
    }

    public List<BgDimensionInfo> getRowDimensionForStyle() {
        return this.getBgDimensionManagerForStyle().getRowDisplayDimension();
    }

    public List<BgDimensionInfo> getRowDimensionForData() {
        return MBgTemplateHelper.getDimensions(this.getBgDimensionManagerForData(), MBgTemplateHelper.getDimensionsNum(this.getRowDimensionForStyle()));
    }

    public List<BgDimensionInfo> getColDimensionForStyle() {
        return this.getBgDimensionManagerForStyle().getColDisplayDimension();
    }

    public List<BgDimensionInfo> getColDimensionForData() {
        return MBgTemplateHelper.getDimensions(this.getBgDimensionManagerForData(), MBgTemplateHelper.getDimensionsNum(this.getColDimensionForStyle()));
    }

    public List<BgDimensionInfo> getHideDimensionForStyle() {
        return this.getBgDimensionManagerForStyle().getHideDisplayDimension();
    }

    public List<BgDimensionInfo> getHideDimensionForData() {
        return MBgTemplateHelper.getDimensions(this.getBgDimensionManagerForData(), MBgTemplateHelper.getDimensionsNum(this.getHideDimensionForStyle()));
    }

    public Map<String, MBGRowData> getMbgRowDatas() {
        return this.mbgRowDatas;
    }

    public void clear() {
        if (this.mbgRowDatas != null) {
            this.mbgRowDatas.clear();
        }
        this.bgDimensionManagerForMulOrg.clear();
    }
}

