/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import java.util.ArrayList;
import java.util.List;

public class MbgViewListResultData {
    private BgMemberSelectTypeEnum memberType = BgMemberSelectTypeEnum.Member;
    private List members = new ArrayList();
    private List canAddMembers = new ArrayList();
    private MbgRelationMap relationMap = null;
    private String editFormat = "name";

    public BgMemberSelectTypeEnum getMemberType() {
        return this.memberType;
    }

    public void setMemberType(BgMemberSelectTypeEnum memberType) {
        this.memberType = memberType;
    }

    public List getMembers() {
        return this.members;
    }

    public void setMembers(List members) {
        this.members = members;
    }

    public List getCanAddMembers() {
        return this.canAddMembers;
    }

    public void setCanAddMembers(List canAddMembers) {
        this.canAddMembers = canAddMembers;
    }

    public MbgRelationMap getRelationMap() {
        return this.relationMap;
    }

    public void setRelationMap(MbgRelationMap relationMap) {
        this.relationMap = relationMap;
    }

    public String getEditFormat() {
        return this.editFormat;
    }

    public void setEditFormat(String editFormat) {
        this.editFormat = editFormat;
    }

    public String toString() {
        StringBuffer value = new StringBuffer();
        if (this.getRelationMap() != null && this.getRelationMap().getGroup() != null) {
            if ("number".equals(this.getEditFormat())) {
                value.append(this.getRelationMap().getGroup().getNumber());
            } else {
                value.append(this.getRelationMap().getGroup().getName());
            }
        } else {
            this.toString(value, this.members);
            this.toString(value, this.canAddMembers);
        }
        return value.toString();
    }

    public void toString(StringBuffer value, List datas) {
        if (datas == null || datas.isEmpty()) {
            return;
        }
        if (value.length() > 0) {
            value.append(",");
        }
        for (int i = 0; i < datas.size(); ++i) {
            if (i > 0) {
                value.append(";");
            }
            if ("number".equals(this.getEditFormat())) {
                value.append(BgCommCHelper.getValue(datas.get(i), (String)"number"));
                continue;
            }
            value.append(BgCommCHelper.getValue(datas.get(i), (String)"name"));
        }
    }

    public boolean isEmpty() {
        return this.relationMap == null && this.members.isEmpty() && this.canAddMembers.isEmpty();
    }

    public static MbgViewListResultData getResultData(MbgViewListDimensionInfo info) {
        MbgViewListResultData data = new MbgViewListResultData();
        data.memberType = info.getMemberType();
        data.members.addAll(info.getSelectMembers());
        data.canAddMembers.addAll(info.getCanAddMember());
        if (data.isEmpty()) {
            return null;
        }
        return data;
    }

    public static MbgViewListResultData getResultData(MbgViewListDimensionInfo dimension, List<MbgRelationMap> relationMaps) {
        if (dimension == null || relationMaps == null || relationMaps.isEmpty() || dimension.getMappingList() == null || dimension.getMappingList().isEmpty()) {
            return null;
        }
        MbgRelationMap relationMap = null;
        BOSUuid groupId = dimension.getMappingList().get(0).getId();
        for (int i = 0; i < relationMaps.size(); ++i) {
            if (!relationMaps.get(i).getGroup().getId().equals((Object)groupId)) continue;
            relationMap = relationMaps.get(i);
            break;
        }
        if (relationMap != null) {
            MbgViewListResultData data = new MbgViewListResultData();
            data.setRelationMap(relationMap);
            return data;
        }
        return null;
    }

    public static MbgViewListResultData getResultData(MbgViewListRowCol rowColObj) {
        MbgViewListResultData data = new MbgViewListResultData();
        data.memberType = BgMemberSelectTypeEnum.Member;
        data.members.addAll(rowColObj.getCombinSelectMembers());
        if (data.isEmpty()) {
            return null;
        }
        return data;
    }

    public void save(MbgViewListDimensionInfo info) {
        info.setMemberType(this.getMemberType());
        info.getSelectMembers().clear();
        info.getSelectMembers().addAll(this.getMembers());
        info.getCanAddMember().clear();
        info.getCanAddMember().addAll(this.getCanAddMembers());
    }

    private List<BgDimensionMember> castToMembers(List members) {
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        if (members != null) {
            for (int i = 0; i < members.size(); ++i) {
                result.add(DimensionFormulaHelper.convertToMember(members.get(i)));
            }
        }
        return result;
    }
}

