/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormTitleEnum;
import com.kingdee.eas.ma.mbg.BgHideItemEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgDimTypeEnum;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MBgViewListStyleAttributes;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDescription;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.ConditionalFormatHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MbgViewListXMLParser {
    private boolean isTemplate = false;
    private Context ctx;
    private static final Logger logger = Logger.getLogger((String)MbgViewListXMLParser.class.getName());
    public static final String ENCODING = "UTF-8";
    public static final String DOCUMENT_VIEW = "view";
    public static final String DOCUMENT_DIMENSION = "dimension";
    public static final String DOCUMENT_VALUE = "value";
    public static final String DOCUMENT_ROW = "row";
    public static final String DOCUMENT_LAYOUT = "layout";
    public static final String DOCUMENT_SHOW_TYPE = "showType";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_ORG_ADD_TYPE = "orgAddType";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_EDIT_SCEN_NUMBER = "editScenNumber";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_FONT_SIZE = "font_size";
    private static final String ATTR_FONT_COLOR = "font_color";
    private static final String ATTR_BACKGROUND = "background";
    private static final String ATTR_ISBOLD = "isBold";
    private static final String ATTR_ISITALIC = "isItalic";
    private static final String ATTR_ISUNDERLINE = "isUnderLine";
    private static final String ATTR_ISCALCFIRST = "isCalculateFirstByRow";
    public static final String ATTR_FONT_STYLE = "font_style";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_HORIZONTAL_ALIGN = "horizontalAlign";
    public static final String ATTR_APPOINT_POSITION = "appointPosition";
    public static final String ATTR_POSITION = "position";
    public static final String ATTR_PRECISION = "precision";
    public static final String ATTR_SEPARATOR = "separator";
    public static final String ATTR_DISPLAY = "display";
    public static final String ATTR_DISPLAY_FORMAT = "display-format";
    public static final String ATTR_CURRENCYDECNUMS = "currencyDecNums";
    public static final String ATTR_NOCURRENCYDECNUMS = "noCurrencyDecNums";
    public static final String ATTR_RATEDECNUMS = "rateDecNums";
    public static final String ATTR_CURRENCYHASGROUPSEP = "currencyHasGroupSep";
    public static final String ATTR_NOCURRENCYGROUPSEP = "noCurrencyGroupSep";
    public static final String ATTR_RATEHASGROUPSEP = "rateHasGroupSep";
    public static final String ATTR_CURRENCYNEGATIVEINDEX = "currencyNegativeIndex";
    public static final String ATTR_NOCURRENCYNEGATIVEINDEX = "noCurrencyNegativeIndex";
    public static final String ATTR_RATENEGATIVEINDEX = "rateNegativeIndex";
    public static final String ATTR_CURRENCYSHOWPERCENT = "currencyShowPercent";
    public static final String ATTR_NOCURRENCYSHOWPERCENT = "noCurrencyShowPercent";
    public static final String ATTR_RATESHOWPERCENT = "rateShowPercent";
    public static final String ATTR_CURRENCYMEASUREUNIT = "currencyMeasureUnit";
    public static final String ATTR_NOCURRENCYMEASUREUNIT = "noCurrencyMeasureUnit";
    public static final String ATTR_RATEMEASUREUNIT = "rateMeasureUnit";
    public static final String ATTR_ROWCOLSHOWBYTEMP = "rowColShowbyTemp";
    public static final String ATTR_CANEDITOTHERADDEDBGFORM = "canEditOtherAddedBgForm";
    public static final String ATTR_CALCDATATYPE = "calcDataType";
    public static final String ATTR_CALCDECNUMS = "calcDecNums";
    public static final String ATTR_CALCHASGROUPSEP = "calcHasGroupSep";
    public static final String ATTR_CALCNEGATIVEFORMATE = "calcNegativeFormate";
    public static final String ATTR_CALCMEASUREUNIT = "calcMeasureUnit";
    public static final String ATTR_CALCSHOWPERCENT = "calcShowPercent";
    public static final String ATTR_ROWMEMBERMERGE = "rowMemberMerge";
    public static final String ATTR_DATATYPE = "dataType";
    public static final String ATTR_ELEDATA = "eleData";
    public static final String ATTR_MEASUREUNIT = "measureUnit";
    public static final String ATTR_MEASURECOF = "measureCof";
    public static final String ATTR_SPLIT_FIRSTROW = "firstRow";
    public static final String ATTR_SPLIT_FIRSTCOL = "firstCol";
    public static final String ATTR_SPLIT_FIRSTROW2 = "firstRow2";
    public static final String ATTR_SPLIT_FIRSTCOL2 = "firstCol2";
    public static final String ATTR_SPLIT_COLSPLIT = "colSplit";
    public static final String ATTR_SPLIT_ROWSPLIT = "rowSplit";
    public static final String ATTR_SPLIT_ACTIVEPANE = "activePane";
    public static final String ATTR_SPLIT_ISFREEZED = "isFreezed";
    public static final String ATTR_SPLIT_COLFIXLINE = "colFixLine";
    public static final String ATTR_SPLIT_ROWFIXLINE = "rowFixLine";
    private static final String DOCUMENT_SHEET = "sheet";
    private static final String DOCUMENT_ALIAS = "alias";
    private static final String DOCUMENT_INDEX = "index";
    private static final String DOCUMENT_INIT_INDEX = "initIndex";
    private static final String DOCUMENT_HAS_SHOW = "hasShow";
    private static final String DOCUMENT_PERIOD_SHOW_STYLE = "periodShowStyle";
    private static final String DOCUMENT_NUMBER = "number";
    private static final String DOCUMENT_MEMBER_VALUE_TYPE = "memberValueType";
    private static final String DOCUMENT_DINAMIC_ADD_MEMBER = "dinamicAddMember";
    private static final String DOCUMENT_DINAMIC_SELECT_RELATIONSHIP = "selectRelationship";
    private static final String DOCUMENT_DINAMIC_ADD_MEMBER_Range = "dinamicAddMemberRange";
    public static final String DOCUMENT_MEMBER_MAPPING = "mapping";
    private static final String DOCUMENT_SELECT_MEMBER = "selectMember";
    private static final String DOCUMENT_ATTRIBUTE = "attribute";
    private static final String DOCUMENT_CALCULATE = "calculate";
    private static final String DOCUMENT_FORMULA = "formula";
    private static final String DOCUMENT_DESCRIPTION = "description";
    private static final String DOCUMENT_CANDELETETEMPLATEMEMBERS = "canDeleteTemplateMembers";
    private static final String DOCUMENT_MEMBER = "member";
    private static final String DOCUMENT_LEVELCONFIG = "levelConfig";
    private static final String DOCUMENT_LEVEL = "level";
    private static final String DOCUMENT_STYLE = "style";
    private static final String DOCUMENT_COLUMN = "column";
    private static final String DOCUMENT_CELL = "cell";
    private static final String DOCUMENT_ID = "id";
    private static final String DOCUMENT_SRC_NUMBER = "srcNumber";
    private static final String DOCUMENT_NAME = "name";
    private static final String DOCUMENT_TYPE_NAME = "typeName";
    private static final String DOCUMENT_DIMENSION_NUMBER = "dimensionNumber";
    private static final String DOCUMENT_DIMENSION_NAME = "dimensionname";
    private static final String DOCUMENT_BGPERIODTYPE = "bgPeriodType";
    private static final String DOCUMENT_ROWHIDE = "rowHide";
    private static final String DOCUMENT_COLHIDE = "colHide";
    private static final String DOCUMENT_MEMBERTYPE = "memberType";
    private static final String DOCUMENT_ORGDIMTYPE = "orgDimType";
    private static final String DOCUMENT_MEMBERFILLTYPE = "memberFillType";
    private static final String DOCUMENT_ISCOMBIN = "isCombin";
    private static final String DOCUMENT_COMBINSELECTMEMBER = "combinSelectMembers";
    private static final String DOCUMENT_ISREADONLY = "isReadonly";
    public static final String DOCUMENT_STYLE_WIDTH = "width";
    public static final String DOCUMENT_STYLE_PRINT = "print";
    public static final String DOCUMENT_DATA_TYPE = "dataType";
    public static final String DOCUMENT_ELE_DATA = "eleData";
    public static final String DOCUMENT_MEASURE_COF = "cof";
    public static final String DOCUMENT_HEAD_STYLE = "headStyle";
    public static final String DOCUMENT_UNIT = "unit";
    public static final String DOCUMENT_DATE = "date";
    public static final String DOCUMENT_MEASURE_UNIT = "measureUnit";
    public static final String DOCUMENT_FORMNUMBER = "formNumber";
    public static final String DOCUMENT_CURRENCYUNIT = "currencyUnit";
    public static final String DOCUMENT_CURRENCY = "currency";
    public static final String DOCUMENT_NOCURRENCYUNIT = "noCurrency";
    public static final String DOCUMENT_RATE = "rate";
    public static final String DOCUMENT_CALCDATASTYLE = "calcDataStyle";
    public static final String Document_ValueVartial = "valueVariate";
    public static final String Document_TemplateConditionaFormat = "TemplateConditionaFormat";
    public static final String Document_FormConditionaFormat = "FormConditionaFormat";
    public static final String DOCUMENT_ADDFORMROLL = "isAddFromRoll";
    public static final String DOCUMENT_RELATION_MAP = "relationMap";
    public static final String DOCUMENT_RELATION_FILLTYPE = "relationMapFillType";
    public static final String DOCUMENT_RELATION_GROUP = "group";
    public static final String DOCUMENT_RELATIONSHIP = "relationShip";
    public static final String DOCUMENT_RELATIONSHIP_FROM_TEMPLATE = "relationIsFromTemplate";
    public static final String DOCUMENT_SPLIT_INFO = "splitInfo";
    private static final String DOCUMENT_SHEET_ID = "sheetID";
    private static final String DOCUMENT_SHEET_HIDE = "isSheetHide";
    public static final String NULL_ID = "null";
    public static final String DOCUMENT_ROWMEMBERMERGE = "rowMemberMerge";

    public MbgViewListXMLParser(boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public MbgViewListXMLParser() {
    }

    public MbgViewListXMLParser(Context ctx) {
        this.ctx = ctx;
    }

    public MbgViewListManager parse(byte[] bytes) throws Exception {
        Element view;
        if (bytes == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        MbgViewListManager mbgViewManager = new MbgViewListManager();
        if (document != null && document.getRootElement() != null && (view = document.getRootElement()) != null && DOCUMENT_VIEW.equalsIgnoreCase(view.getName())) {
            String version = BgViewHelper.getElementAttr(view, ATTR_VERSION);
            mbgViewManager.setVersion(version);
            String orgAddType = BgViewHelper.getElementAttr(view, ATTR_ORG_ADD_TYPE);
            if (!StringUtils.isEmpty((String)orgAddType)) {
                mbgViewManager.setOrgAddType(Integer.parseInt(orgAddType));
            }
            String rowHide = BgViewHelper.getElementAttr(view, DOCUMENT_ROWHIDE);
            mbgViewManager.setRowHide(BgHideItemEnum.getEnum(rowHide));
            String colHide = BgViewHelper.getElementAttr(view, DOCUMENT_COLHIDE);
            mbgViewManager.setColHide(BgHideItemEnum.getEnum(colHide));
            MbgViewListXMLParser.parseValueVariate(mbgViewManager, view);
            this.parseView(mbgViewManager, view);
        }
        return mbgViewManager;
    }

    public Map<String, MbgViewListDimensionInfo> parseSpecialDimensions(byte[] bytes) throws BOSException {
        Element view;
        LinkedHashMap<String, MbgViewListDimensionInfo> specialDimensions = new LinkedHashMap<String, MbgViewListDimensionInfo>();
        if (bytes == null || bytes.length == 0) {
            return specialDimensions;
        }
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (DocumentException e) {
            throw new BOSException((Throwable)e);
        }
        if (document != null && document.getRootElement() != null && (view = document.getRootElement()) != null && DOCUMENT_VIEW.equalsIgnoreCase(view.getName())) {
            MbgViewListDimensionInfo dimension = null;
            Iterator it = view.elementIterator(DOCUMENT_DIMENSION);
            while (it.hasNext()) {
                dimension = this.parseViewListDimension((Element)it.next());
                specialDimensions.put(dimension.getNumber(), dimension);
            }
        }
        return specialDimensions;
    }

    private void parseConditionaFormat(MbgViewListDimensionManager dimensionManager, Element sheetElement) throws Exception {
        String condStr = BgViewHelper.getElementValue(sheetElement, Document_TemplateConditionaFormat);
        ConditionalFormatHelper.parseTemplateConditionaFormat(dimensionManager, condStr);
        condStr = BgViewHelper.getElementValue(sheetElement, Document_FormConditionaFormat);
        ConditionalFormatHelper.parseFormConditionaFormat(dimensionManager, condStr);
    }

    public static void parseValueVariate(IMbgViewBase viewManager, Element viewElement) {
        Element vElement = null;
        Iterator it = viewElement.elementIterator(Document_ValueVartial);
        while (it.hasNext()) {
            vElement = (Element)it.next();
            viewManager.getValueVariates().add(new BgDimensionMember("NUMERIC", "NUMERIC", BgViewHelper.getElementValue(vElement, "name"), BgViewHelper.getElementValue(vElement, DOCUMENT_NUMBER)));
        }
    }

    private void parseView(MbgViewListManager mbgViewManager, Element view) throws Exception {
        if (mbgViewManager == null || view == null) {
            return;
        }
        Element sheetEle = null;
        MbgViewListSheetManager mbgSheetManager = null;
        int sheetIndex = 0;
        Iterator it = view.elementIterator(DOCUMENT_SHEET);
        while (it.hasNext()) {
            sheetEle = (Element)it.next();
            mbgSheetManager = new MbgViewListSheetManager(mbgViewManager);
            mbgViewManager.getSheetManagers().add(mbgSheetManager);
            mbgSheetManager.setSheetID(BgViewHelper.getElementAttr(sheetEle, DOCUMENT_SHEET_ID));
            if (mbgSheetManager.getSheetID() == null) {
                mbgSheetManager.setSheetID(BOSUuid.create((String)"FF66566A").toString());
            }
            mbgSheetManager.setSheetHide(Boolean.parseBoolean(BgViewHelper.getElementAttr(sheetEle, DOCUMENT_SHEET_HIDE)));
            mbgSheetManager.setSheetIndex(sheetIndex++);
            mbgSheetManager.setSheetName(BgViewHelper.getElementAttr(sheetEle, "name"));
            mbgSheetManager.setRowColShowbyTemp(BgViewHelper.getElementAttr(sheetEle, ATTR_ROWCOLSHOWBYTEMP) == null ? Boolean.TRUE : Boolean.parseBoolean(BgViewHelper.getElementAttr(sheetEle, ATTR_ROWCOLSHOWBYTEMP)));
            String isNeedDes = BgViewHelper.getElementAttr(sheetEle, DOCUMENT_DESCRIPTION);
            mbgSheetManager.setNeedDescription(Boolean.parseBoolean(isNeedDes));
            mbgSheetManager.setCanDeleteTemplateMembers(BgViewHelper.getElementAttr(sheetEle, DOCUMENT_CANDELETETEMPLATEMEMBERS) == null ? Boolean.FALSE : Boolean.parseBoolean(BgViewHelper.getElementAttr(sheetEle, DOCUMENT_CANDELETETEMPLATEMEMBERS)));
            if (BgViewHelper.getElementAttr(sheetEle, ATTR_CANEDITOTHERADDEDBGFORM) != null) {
                mbgSheetManager.setCanEditOtherAddedBgForm(Boolean.parseBoolean(BgViewHelper.getElementAttr(sheetEle, ATTR_CANEDITOTHERADDEDBGFORM)));
            }
            Iterator itScen = sheetEle.elementIterator(ATTR_EDIT_SCEN_NUMBER);
            while (itScen.hasNext()) {
                Element e = (Element)itScen.next();
                BgScenarioInfo info = new BgScenarioInfo();
                info.setId(BOSUuid.read((String)BgViewHelper.getElementValue(e, DOCUMENT_ID)));
                info.setNumber(BgViewHelper.getElementValue(e, DOCUMENT_NUMBER));
                info.setName(BgViewHelper.getElementValue(e, "name"));
                mbgSheetManager.getEditScens().add(info);
            }
            this.parseViewListSheet(mbgSheetManager, sheetEle);
            this.parseWidthStyle(mbgSheetManager, sheetEle);
            this.parsePrintStyle(mbgSheetManager, sheetEle);
            this.parseConditionaFormat(mbgSheetManager.getDimensionManager(), sheetEle);
            this.parseSpliteInfo(mbgSheetManager, sheetEle);
        }
    }

    private void parseViewListSheet(MbgViewListSheetManager mbgSheetManager, Element sheetEle) throws Exception {
        if (mbgSheetManager == null || sheetEle == null) {
            return;
        }
        Element dimensionEle = sheetEle.element(DOCUMENT_DIMENSION);
        if (dimensionEle != null) {
            this.parseViewListDimension(mbgSheetManager.getDimensionManager(), dimensionEle);
        }
        Element rowEle = sheetEle.element(DOCUMENT_ROW);
        this.parseViewListObject(rowEle, mbgSheetManager.getDimensionManager(), mbgSheetManager.getDimensionManager().getRows());
        Element colEle = sheetEle.element(DOCUMENT_COLUMN);
        this.parseViewListObject(colEle, mbgSheetManager.getDimensionManager(), mbgSheetManager.getDimensionManager().getColumns());
        Element cellEle = sheetEle.element(DOCUMENT_CELL);
        this.parseViewListObject(cellEle, mbgSheetManager.getDimensionManager(), mbgSheetManager.getDimensionManager().getCells());
        mbgSheetManager.getDimensionManager().setPageRelationMaps(new ArrayList<MbgRelationMap>());
        this.parseRelationMap(mbgSheetManager.getDimensionManager().getPageRelationMaps(), sheetEle);
    }

    private void parseRelationMap(List<MbgRelationMap> maps, Element parentElement) {
        if (maps == null || parentElement == null) {
            return;
        }
        Iterator it = parentElement.elementIterator(DOCUMENT_RELATION_MAP);
        while (it.hasNext()) {
            Element relationElement = (Element)it.next();
            MbgRelationMap relationMap = new MbgRelationMap(null);
            relationMap.setFillWhereNull(Boolean.TRUE.toString().equalsIgnoreCase(BgViewHelper.getElementValue(relationElement, DOCUMENT_RELATION_FILLTYPE)));
            maps.add(relationMap);
            this.parseRelationGroup(relationMap, relationElement.element(DOCUMENT_RELATION_GROUP));
            Iterator itShip = relationElement.elementIterator(DOCUMENT_RELATIONSHIP);
            while (itShip.hasNext()) {
                relationMap.getRelationShips().add(this.parseRelationShip((Element)itShip.next()));
            }
        }
    }

    private DimensionRelationshipInfo parseRelationShip(Element shipElement) {
        DimensionRelationshipInfo ship = new DimensionRelationshipInfo();
        ship.setDimensionNumber(BgViewHelper.getElementValue(shipElement, DOCUMENT_DIMENSION_NUMBER));
        ship.setDimensionName(BgViewHelper.getElementValue(shipElement, DOCUMENT_DIMENSION_NAME));
        ship.setFromTemplate(Boolean.parseBoolean(BgViewHelper.getElementValue(shipElement, DOCUMENT_RELATIONSHIP_FROM_TEMPLATE)));
        return ship;
    }

    private void parseRelationGroup(MbgRelationMap relationMap, Element groupElement) {
        DimensionRelationshipGroupInfo group = new DimensionRelationshipGroupInfo();
        relationMap.setGroup(group);
        group.setId(BOSUuid.read((String)BgViewHelper.getElementValue(groupElement, DOCUMENT_ID)));
        group.setNumber(BgViewHelper.getElementValue(groupElement, DOCUMENT_NUMBER));
        group.setName(BgViewHelper.getElementValue(groupElement, "name"));
        Iterator it = groupElement.elementIterator(DOCUMENT_DIMENSION);
        while (it.hasNext()) {
            Element element = (Element)it.next();
            DimRelashipGroupEntryInfo entry = new DimRelashipGroupEntryInfo();
            entry.setDimRelashipGroup(group);
            this.parseRelationDimension(entry, element);
            group.getEntries().add(entry);
        }
    }

    private void parseRelationDimension(DimRelashipGroupEntryInfo entry, Element relationDimension) {
        entry.setDimNumber(BgViewHelper.getElementValue(relationDimension, DOCUMENT_DIMENSION_NUMBER));
        entry.setDimName(BgViewHelper.getElementValue(relationDimension, DOCUMENT_DIMENSION_NAME));
    }

    private void parseViewListObject(Element rowEle, MbgViewListDimensionManager dimensionManager, List objects) {
        IMbgViewListStyle obj = null;
        Element e = null;
        String eleName = null;
        Iterator iterator = rowEle.elementIterator();
        while (iterator.hasNext()) {
            e = (Element)iterator.next();
            obj = null;
            eleName = e.getName();
            if (DOCUMENT_ROW.equals(eleName)) {
                obj = new MbgViewListRowCol();
                this.parseViewListObject(e, (MbgViewListRowCol)obj);
            } else if (DOCUMENT_CALCULATE.equals(eleName)) {
                obj = new MbgViewListCalcutor();
                this.parseViewListObject(e, (MbgViewListCalcutor)obj);
            } else if (DOCUMENT_DESCRIPTION.equals(eleName)) {
                obj = new MbgViewListDescription();
                this.parseViewListObject(e, (MbgViewListDescription)obj);
            } else if (DOCUMENT_CELL.equals(eleName)) {
                obj = new MbgViewListCell();
                this.parseViewListObject(e, dimensionManager, (MbgViewListCell)obj);
                if (((MbgViewListCell)obj).getRow() == null || ((MbgViewListCell)obj).getCol() == null) continue;
            }
            if (obj == null) continue;
            objects.add(obj);
        }
    }

    private void parseViewListObject(Element element, MbgViewListRowCol object) {
        if (element == null || object == null) {
            return;
        }
        object.setCombin(Boolean.parseBoolean(BgViewHelper.getElementValue(element, DOCUMENT_ISCOMBIN)));
        object.setIndex(Integer.parseInt(BgViewHelper.getElementValue(element, "index")));
        object.setReadonly(Boolean.parseBoolean(BgViewHelper.getElementValue(element, DOCUMENT_ISREADONLY)));
        object.setAddFromRoll(Boolean.parseBoolean(BgViewHelper.getElementValue(element, DOCUMENT_ADDFORMROLL)));
        this.parseViewListStyle(element, object);
        String strInitIndex = BgViewHelper.getElementValue(element, DOCUMENT_INIT_INDEX);
        if (strInitIndex == null) {
            object.setInitIndex(object.getIndex());
        } else {
            object.setInitIndex(Integer.parseInt(strInitIndex));
        }
        Iterator it = element.elementIterator(DOCUMENT_DIMENSION);
        while (it.hasNext()) {
            object.getDimensions().add(this.parseViewListDimension((Element)it.next()));
        }
        it = element.elementIterator(DOCUMENT_COMBINSELECTMEMBER);
        while (it.hasNext()) {
            object.getCombinSelectMembers().add(this.parseViewListCombinMember((Element)it.next()));
        }
        it = element.elementIterator(DOCUMENT_MEMBER);
        while (it.hasNext()) {
            object.getCombinMembers().add(this.parseViewListCombinMember((Element)it.next()));
        }
        it = element.elementIterator(DOCUMENT_LEVELCONFIG);
        while (it.hasNext()) {
            this.parseViewListLevelConfig((Element)it.next(), object);
        }
        object.setRelationMaps(new ArrayList<MbgRelationMap>());
        this.parseRelationMap(object.getRelationMaps(), element);
    }

    private void parseViewListLevelConfig(Element element, MbgViewListRowCol object) {
        String dimNumber = BgViewHelper.getElementValue(element, DOCUMENT_DIMENSION_NUMBER);
        String memberNumber = BgViewHelper.getElementValue(element, DOCUMENT_MEMBER);
        String level = BgViewHelper.getElementValue(element, DOCUMENT_LEVEL);
        object.setLevelConfig(dimNumber, memberNumber, Integer.parseInt(level));
    }

    private BgDimensionMember parseViewListCombinMember(Element element) {
        if (element == null) {
            return null;
        }
        String attribute = BgViewHelper.getElementValue(element, DOCUMENT_ATTRIBUTE);
        String dimNumber = BgViewHelper.getElementValue(element, DOCUMENT_DIMENSION_NUMBER);
        String number = BgViewHelper.getElementValue(element, DOCUMENT_NUMBER);
        String name = BgViewHelper.getElementValue(element, "name");
        String srcNumber = BgViewHelper.getElementValue(element, DOCUMENT_SRC_NUMBER);
        BgDimensionMember member = new BgDimensionMember(dimNumber, attribute, name, number);
        member.setSrcNumber(srcNumber);
        return member;
    }

    private void parseViewListObject(Element element, MbgViewListCalcutor object) {
        if (element == null || object == null) {
            return;
        }
        object.setReadonly(Boolean.parseBoolean(BgViewHelper.getElementValue(element, DOCUMENT_ISREADONLY)));
        object.setIndex(Integer.parseInt(BgViewHelper.getElementValue(element, "index")));
        object.setAlias(BgViewHelper.getElementValue(element, DOCUMENT_ALIAS));
        object.setFormula(BgViewHelper.getElementValue(element, DOCUMENT_FORMULA));
        String strInitIndex = BgViewHelper.getElementValue(element, DOCUMENT_INIT_INDEX);
        if (strInitIndex == null) {
            object.setInitIndex(object.getIndex());
        } else {
            object.setInitIndex(Integer.parseInt(strInitIndex));
        }
        this.parseViewListCalcDataStyle(element, object);
        this.parseViewListStyle(element, object);
    }

    private void parseViewListCalcDataStyle(Element element, MbgViewListCalcutor object) {
        if (element == null || object == null) {
            return;
        }
        Element styleEle = element.element(DOCUMENT_CALCDATASTYLE);
        if (styleEle == null) {
            return;
        }
        object.setDataStyleInfo(new ViewListCalculatorDataStyleInfo());
        object.getDataStyleInfo().setDecNums(Integer.parseInt(BgViewHelper.getElementValue(styleEle, ATTR_CALCDECNUMS)));
        object.getDataStyleInfo().setHasGroupSep(Boolean.parseBoolean(BgViewHelper.getElementValue(styleEle, ATTR_CALCHASGROUPSEP)));
        object.getDataStyleInfo().setMeasureUnit(Integer.parseInt(BgViewHelper.getElementValue(styleEle, ATTR_CALCMEASUREUNIT)));
        object.getDataStyleInfo().setNegativeIndex(Integer.parseInt(BgViewHelper.getElementValue(styleEle, ATTR_CALCNEGATIVEFORMATE)));
        object.getDataStyleInfo().setShowPercent(Boolean.parseBoolean(BgViewHelper.getElementValue(styleEle, ATTR_CALCSHOWPERCENT)));
    }

    private void parseViewListObject(Element element, MbgViewListDescription object) {
        if (element == null || object == null) {
            return;
        }
        object.setReadonly(Boolean.parseBoolean(BgViewHelper.getElementValue(element, DOCUMENT_ISREADONLY)));
        object.setIndex(Integer.parseInt(BgViewHelper.getElementValue(element, "index")));
        object.setAlias(BgViewHelper.getElementValue(element, DOCUMENT_ALIAS));
        String strInitIndex = BgViewHelper.getElementValue(element, DOCUMENT_INIT_INDEX);
        if (strInitIndex == null) {
            object.setInitIndex(object.getIndex());
        } else {
            object.setInitIndex(Integer.parseInt(strInitIndex));
        }
        this.parseViewListStyle(element, object);
    }

    private void parseViewListObject(Element element, MbgViewListDimensionManager dimensionManager, MbgViewListCell object) {
        if (element == null || object == null) {
            return;
        }
        object.setReadonly(Boolean.parseBoolean(BgViewHelper.getElementValue(element, DOCUMENT_ISREADONLY)));
        int row = Integer.parseInt(BgViewHelper.getElementValue(element, DOCUMENT_ROW));
        if (dimensionManager.getRows().size() > row) {
            int col = Integer.parseInt(BgViewHelper.getElementValue(element, DOCUMENT_COLUMN));
            if (col >= dimensionManager.getColumns().size()) {
                return;
            }
            object.setRow(dimensionManager.getRows().get(row));
            object.setCol(dimensionManager.getColumns().get(col));
            object.setCalculateFirstByRow(Boolean.parseBoolean(BgViewHelper.getElementValue(element, ATTR_ISCALCFIRST)));
            this.parseViewListStyle(element, object);
        }
    }

    private void parseViewListStyle(Element element, IMbgViewListStyle object) {
        if (element == null || object == null) {
            return;
        }
        Element styleEle = element.element("style");
        if (styleEle == null) {
            return;
        }
        object.setStyle(new MBgViewListStyleAttributes());
        object.getStyle().setFont((Font)new KDFont(BgViewHelper.getElementValue(styleEle, ATTR_FONT), 0, Integer.parseInt(BgViewHelper.getElementValue(styleEle, ATTR_FONT_SIZE))));
        object.getStyle().setFontColor(Color.decode(BgViewHelper.getElementValue(styleEle, ATTR_FONT_COLOR)));
        object.getStyle().setBackgroundColor(Color.decode(BgViewHelper.getElementValue(styleEle, ATTR_BACKGROUND)));
        object.getStyle().setBold(Boolean.parseBoolean(BgViewHelper.getElementValue(styleEle, ATTR_ISBOLD)));
        object.getStyle().setItalic(Boolean.parseBoolean(BgViewHelper.getElementValue(styleEle, ATTR_ISITALIC)));
        object.getStyle().setUnderline(Boolean.parseBoolean(BgViewHelper.getElementValue(styleEle, ATTR_ISUNDERLINE)));
    }

    private void parseViewListDimension(MbgViewListDimensionManager bgDimensionManager, Element dimension) {
        if (bgDimensionManager == null || dimension == null) {
            return;
        }
        Iterator it = dimension.elementIterator();
        while (it.hasNext()) {
            Element memberEle = (Element)it.next();
            if (DOCUMENT_DIMENSION.equals(memberEle.getName())) {
                MbgViewListDimensionInfo d = this.parseViewListDimension(memberEle);
                d.setDimensionManager(bgDimensionManager);
                bgDimensionManager.addDimensionInfo(d);
                continue;
            }
            if (!DOCUMENT_ATTRIBUTE.equals(memberEle.getName())) continue;
            MbgViewListAtribute attrib = this.parseViewListAttribute(memberEle);
            bgDimensionManager.addAttribute(attrib);
        }
    }

    private MbgViewListAtribute parseViewListAttribute(Element memberEle) {
        if (memberEle == null) {
            return null;
        }
        MbgViewListAtribute attrib = new MbgViewListAtribute();
        attrib.setPropertySort(new BgPropertySortInfo());
        attrib.setDimNumber(BgViewHelper.getElementValue(memberEle, DOCUMENT_DIMENSION_NUMBER));
        attrib.getPropertySort().setId(!BgViewHelper.getElementValue(memberEle, DOCUMENT_ID).equals(NULL_ID) ? BOSUuid.read((String)BgViewHelper.getElementValue(memberEle, DOCUMENT_ID)) : null);
        attrib.getPropertySort().setNumber(BgViewHelper.getElementValue(memberEle, DOCUMENT_NUMBER));
        attrib.getPropertySort().setName(BgViewHelper.getElementValue(memberEle, "name"));
        attrib.setLayout(BgViewHelper.getElementValue(memberEle, DOCUMENT_LAYOUT));
        attrib.setIndex(Integer.parseInt(BgViewHelper.getElementValue(memberEle, "index")));
        attrib.setReadonly(Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMENT_ISREADONLY)));
        return attrib;
    }

    private MbgViewListDimensionInfo parseViewListDimension(Element memberEle) {
        String number = BgViewHelper.getElementValue(memberEle, DOCUMENT_NUMBER);
        String alias = BgViewHelper.getElementValue(memberEle, DOCUMENT_ALIAS);
        int memberValueType = Integer.parseInt(BgViewHelper.getElementValue(memberEle, DOCUMENT_MEMBER_VALUE_TYPE));
        String value = BgViewHelper.getElementValue(memberEle, "value");
        String attribute = BgViewHelper.getElementValue(memberEle, DOCUMENT_ATTRIBUTE);
        String layout = BgViewHelper.getElementValue(memberEle, DOCUMENT_LAYOUT);
        if (DOCUMENT_VIEW.equals(layout)) {
            layout = "page";
        }
        String showType = BgViewHelper.getElementValue(memberEle, DOCUMENT_SHOW_TYPE);
        int index = Integer.parseInt(BgViewHelper.getElementValue(memberEle, "index"));
        Boolean isShow = Boolean.parseBoolean(BgViewHelper.getElementValue(memberEle, DOCUMENT_HAS_SHOW));
        int periodStyle = 1;
        try {
            periodStyle = Integer.parseInt(BgViewHelper.getElementValue(memberEle, DOCUMENT_PERIOD_SHOW_STYLE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Element bgPeriodTypeEle = null;
        BgPeriodTypeInfo bgTypeInfo = null;
        bgPeriodTypeEle = memberEle.element(DOCUMENT_BGPERIODTYPE);
        if (bgPeriodTypeEle != null) {
            bgTypeInfo = new BgPeriodTypeInfo();
            bgTypeInfo.setId(BOSUuid.read((String)BgViewHelper.getElementValue(bgPeriodTypeEle, DOCUMENT_ID)));
            bgTypeInfo.setNumber(BgViewHelper.getElementValue(bgPeriodTypeEle, DOCUMENT_NUMBER));
            bgTypeInfo.setName(BgViewHelper.getElementValue(bgPeriodTypeEle, "name"));
        }
        String memberType = BgViewHelper.getElementValue(memberEle, DOCUMENT_MEMBERTYPE);
        String orgDimType = BgViewHelper.getElementValue(memberEle, DOCUMENT_ORGDIMTYPE);
        String mappingValue = BgViewHelper.getElementValue(memberEle, DOCUMENT_MEMBER_MAPPING);
        MbgViewListDimensionInfo dimension = this.getDimension(number, alias, memberValueType, value, attribute, layout, showType, index, isShow, periodStyle, bgTypeInfo, memberType, orgDimType);
        dimension.parseMappingList(mappingValue);
        if (4 != memberValueType) {
            this.parseMembers(memberEle, memberType, DOCUMENT_SELECT_MEMBER, dimension.getSelectMembers(), dimension);
            this.parseMembers(memberEle, memberType, DOCUMENT_DINAMIC_ADD_MEMBER_Range, dimension.getCanAddMember(), dimension);
        }
        return dimension;
    }

    private void parseMembers(Element memberEle, String memberType, String memberKey, List selectMembers, MbgViewListDimensionInfo dimension) {
        Iterator it = memberEle.elementIterator(memberKey);
        while (it.hasNext()) {
            Element subEle = (Element)it.next();
            String id = BgViewHelper.getElementValue(subEle, DOCUMENT_ID);
            String number = BgViewHelper.getElementValue(subEle, DOCUMENT_NUMBER);
            String name = BgViewHelper.getElementValue(subEle, "name");
            String typeName = BgViewHelper.getElementValue(subEle, DOCUMENT_TYPE_NAME);
            String alias = BgViewHelper.getElementValue(subEle, DOCUMENT_ALIAS);
            String version = BgViewHelper.getElementValue(subEle, ATTR_VERSION);
            if (number == null) continue;
            if (BgMemberSelectTypeEnum.Member.getName().equals(memberType)) {
                if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimension.getNumber()) && BOSUuid.isValidLength((String)id)) {
                    BgPeriodInfo period = new BgPeriodInfo();
                    period.setId(BOSUuid.read((String)id));
                    period.setNumber(number);
                    period.setName(name);
                    period.setDisplayName(alias);
                    selectMembers.add(period);
                    continue;
                }
                BgDimensionMember member = new BgDimensionMember(dimension.getNumber(), id, name, number);
                String fillType = BgViewHelper.getElementValue(subEle, DOCUMENT_MEMBERFILLTYPE);
                if (!StringUtils.isEmpty((String)fillType)) {
                    member.setFillType(Integer.parseInt(fillType));
                }
                if (!StringUtils.isEmpty((String)version)) {
                    member.setVersion(new BigDecimal(version));
                }
                selectMembers.add(member);
                continue;
            }
            if (BgMemberSelectTypeEnum.Variate.getName().equals(memberType)) {
                BgVariateInfo variate = new BgVariateInfo();
                variate.setId(BOSUuid.read((String)id));
                variate.setNumber(number);
                variate.setName(name);
                selectMembers.add(variate);
                continue;
            }
            if (!BgMemberSelectTypeEnum.Property.getName().equals(memberType)) continue;
            BgPropertyInfo prop = new BgPropertyInfo();
            prop.setId(BOSUuid.read((String)id));
            prop.setNumber(number);
            prop.setName(name);
            prop.setBgPropertySort(new BgPropertySortInfo());
            prop.getBgPropertySort().setName(typeName);
            selectMembers.add(prop);
        }
    }

    private MbgViewListDimensionInfo getDimension(String number, String alias, int memberValueType, String value, String attribute, String layout, String showType, int index, boolean isShow, int periodStyle, BgPeriodTypeInfo bgPeriodType, String memberType, String orgDimType) {
        MbgViewListDimensionInfo dimensionInfo = new MbgViewListDimensionInfo(null);
        dimensionInfo.setMemberType(BgMemberSelectTypeEnum.getEnum(memberType));
        dimensionInfo.setNumber(number);
        dimensionInfo.setAlias(alias);
        dimensionInfo.setName(alias);
        dimensionInfo.setMemberValueType(DimensionMemberValueModeEnum.getEnum(memberValueType));
        dimensionInfo.setValue(value);
        dimensionInfo.setAttribute(attribute);
        dimensionInfo.setLayout(layout);
        dimensionInfo.setShowType(showType);
        dimensionInfo.setIndex(index);
        dimensionInfo.setShow(isShow);
        dimensionInfo.setPeriodDisplayStyle(periodStyle);
        dimensionInfo.setBgPeriodType(bgPeriodType);
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(number)) {
            dimensionInfo.setOrgDimType(BgOrgDimTypeEnum.getEnum(orgDimType));
        }
        dimensionInfo.parse();
        return dimensionInfo;
    }

    public byte[] unParse(MbgViewListManager mbgViewManager) throws DimensionException {
        if (mbgViewManager == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeXMLStream(bos, mbgViewManager);
        return bos.toByteArray();
    }

    public byte[] unParseSpecialDimension(Map<String, MbgViewListDimensionInfo> specialDimensions) throws DimensionException {
        if (specialDimensions == null || specialDimensions.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeXMLStream((OutputStream)bos, specialDimensions);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String fileName, MbgViewListManager mbgViewManager) throws DimensionException, IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(new File(fileName));
            this.writeXMLStream((OutputStream)fos, mbgViewManager);
            fos.close();
        }
    }

    private void writeXMLStream(ByteArrayOutputStream bos, MbgViewListManager mbgViewManager) throws DimensionException {
        this.writeXMLStream((OutputStream)bos, mbgViewManager);
    }

    private void writeXMLStream(OutputStream out, Map<String, MbgViewListDimensionInfo> specialDimensions) throws DimensionException {
        if (out == null || specialDimensions == null) {
            return;
        }
        Document doc = this.buildDocument(specialDimensions);
        this.writeDocument(out, doc);
    }

    private void writeDocument(OutputStream out, Document doc) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        try {
            writer = new XMLWriter(out, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private void writeXMLStream(OutputStream out, MbgViewListManager mbgViewManager) throws DimensionException {
        if (out == null || mbgViewManager == null) {
            return;
        }
        Document doc = this.buildDocument(mbgViewManager);
        this.writeDocument(out, doc);
    }

    private Document buildDocument(MbgViewListManager mbgViewManager) throws DimensionException {
        if (mbgViewManager == null || mbgViewManager.getSheetManagers().isEmpty()) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement(DOCUMENT_VIEW);
        view.addAttribute(ATTR_VERSION, mbgViewManager.getVersion() == null ? "2.0" : mbgViewManager.getVersion());
        view.addAttribute(ATTR_ORG_ADD_TYPE, Integer.toString(mbgViewManager.getOrgAddType()));
        view.addAttribute(DOCUMENT_ROWHIDE, mbgViewManager.getRowHide().getName());
        view.addAttribute(DOCUMENT_COLHIDE, mbgViewManager.getColHide().getName());
        MbgViewListXMLParser.buildDcoumentValueVariate(mbgViewManager, view);
        for (int s = 0; s < mbgViewManager.getSheetManagers().size(); ++s) {
            this.buildDocument(view, (MbgViewListSheetManager)mbgViewManager.getSheetManagers().get(s));
        }
        return doc;
    }

    private Document buildDocument(Map<String, MbgViewListDimensionInfo> specialDimensions) throws DimensionException {
        if (specialDimensions == null || specialDimensions.isEmpty()) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element view = doc.addElement(DOCUMENT_VIEW);
        for (MbgViewListDimensionInfo dimension : specialDimensions.values()) {
            this.buildDocument(view, dimension);
        }
        return doc;
    }

    private void buildDocumentConditionaFormat(MbgViewListDimensionManager dimensionManager, Element sheetElement) throws DimensionException {
        String conStr = ConditionalFormatHelper.getTemplateConditionaFormat(dimensionManager);
        if (!StringUtils.isEmpty((String)conStr)) {
            sheetElement.addElement(Document_TemplateConditionaFormat).setText(conStr);
        }
        if (!StringUtils.isEmpty((String)(conStr = ConditionalFormatHelper.getFormConditionaFormat(dimensionManager)))) {
            sheetElement.addElement(Document_FormConditionaFormat).setText(conStr);
        }
    }

    public static void buildDcoumentValueVariate(IMbgViewBase viewManager, Element viewElement) {
        BgDimensionMember member = null;
        Element vElement = null;
        for (int i = 0; i < viewManager.getValueVariates().size(); ++i) {
            member = viewManager.getValueVariates().get(i);
            vElement = viewElement.addElement(Document_ValueVartial);
            BgViewHelper.addElementText(vElement, DOCUMENT_NUMBER, member.getNumber());
            BgViewHelper.addElementText(vElement, "name", member.getName());
        }
    }

    private void buildDocument(Element parentEle, MbgViewListSheetManager sheetManager) throws DimensionException {
        if (parentEle == null || sheetManager == null) {
            return;
        }
        Element sheet = parentEle.addElement(DOCUMENT_SHEET);
        sheet.addAttribute(DOCUMENT_SHEET_ID, sheetManager.getSheetID());
        sheet.addAttribute(DOCUMENT_SHEET_HIDE, String.valueOf(sheetManager.isSheetHide()));
        sheet.addAttribute("index", String.valueOf(sheetManager.getSheetIndex()));
        sheet.addAttribute("name", sheetManager.getSheetName());
        sheet.addAttribute(ATTR_ROWCOLSHOWBYTEMP, String.valueOf(sheetManager.isRowColShowbyTemp()));
        sheet.addAttribute(DOCUMENT_DESCRIPTION, String.valueOf(sheetManager.isNeedDescription()));
        sheet.addAttribute(DOCUMENT_CANDELETETEMPLATEMEMBERS, String.valueOf(sheetManager.isCanDeleteTemplateMembers()));
        if (sheetManager.canEditOtherAddedBgForm != null) {
            sheet.addAttribute(ATTR_CANEDITOTHERADDEDBGFORM, sheetManager.canEditOtherAddedBgForm != null ? String.valueOf(sheetManager.canEditOtherAddedBgForm) : Boolean.TRUE.toString());
        }
        for (int i = 0; i < sheetManager.getEditScens().size(); ++i) {
            Element e = sheet.addElement(ATTR_EDIT_SCEN_NUMBER);
            e.addElement(DOCUMENT_ID).setText(sheetManager.getEditScens().get(i).getId().toString());
            e.addElement(DOCUMENT_NUMBER).setText(sheetManager.getEditScens().get(i).getNumber());
            e.addElement("name").setText(sheetManager.getEditScens().get(i).getName());
        }
        this.buildDocument(sheet, sheetManager.getDimensionManager());
        MbgViewListXMLParser.buildWidthDocument(sheet, sheetManager);
        MbgViewListXMLParser.buildPrintSettingDocument(sheet, sheetManager);
        this.buildDocumentConditionaFormat(sheetManager.getDimensionManager(), sheet);
        MbgViewListXMLParser.buildSpliteDocument(sheet, sheetManager);
    }

    private void buildDocument(Element parentEle, MbgViewListDimensionManager bgDimensionManager) throws DimensionException {
        if (parentEle == null || bgDimensionManager == null) {
            return;
        }
        Element dimensionEle = parentEle.addElement(DOCUMENT_DIMENSION);
        List dimensions = bgDimensionManager.getDimension();
        IMbgViewListObject obj2 = null;
        for (IMbgViewListObject obj2 : dimensions) {
            if (obj2 instanceof MbgViewListDimensionInfo) {
                this.buildDocument(dimensionEle, (MbgViewListDimensionInfo)obj2);
                continue;
            }
            if (!(obj2 instanceof MbgViewListAtribute)) continue;
            this.buildDocument(dimensionEle, (MbgViewListAtribute)obj2);
        }
        Element rowEle = parentEle.addElement(DOCUMENT_ROW);
        this.buildDocument(rowEle, bgDimensionManager.getRows());
        Element colEle = parentEle.addElement(DOCUMENT_COLUMN);
        this.buildDocument(colEle, bgDimensionManager.getColumns());
        Element cellEle = parentEle.addElement(DOCUMENT_CELL);
        this.buildDocument(cellEle, bgDimensionManager.getCells());
        this.buildRelationMap(parentEle, bgDimensionManager.getPageRelationMaps());
    }

    private void buildRelationMap(Element view, List<MbgRelationMap> relationMaps) {
        if (view == null || relationMaps == null || relationMaps.isEmpty()) {
            return;
        }
        for (int i = 0; i < relationMaps.size(); ++i) {
            MbgRelationMap relationMap = relationMaps.get(i);
            Element relationElement = view.addElement(DOCUMENT_RELATION_MAP);
            relationElement.addElement(DOCUMENT_RELATION_FILLTYPE).setText(String.valueOf(relationMap.isFillWhereNull()));
            MbgViewListXMLParser.buildGroup(relationElement, relationMap.getGroup());
            for (int s = 0; s < relationMap.getRelationShips().size(); ++s) {
                this.buildRelationShip(relationElement, relationMap.getRelationShips().get(s));
            }
        }
    }

    private void buildRelationShip(Element relationElement, DimensionRelationshipInfo relationShip) {
        if (relationElement == null || relationShip == null) {
            return;
        }
        if (this.isTemplate && !relationShip.isFromTemplate()) {
            return;
        }
        Element element = relationElement.addElement(DOCUMENT_RELATIONSHIP);
        element.addElement(DOCUMENT_DIMENSION_NUMBER).setText(relationShip.getDimensionNumber());
        element.addElement(DOCUMENT_DIMENSION_NAME).setText(relationShip.getDimensionName());
        element.addElement(DOCUMENT_RELATIONSHIP_FROM_TEMPLATE).setText(String.valueOf(relationShip.isFromTemplate()));
    }

    private static void buildGroup(Element relationElement, DimensionRelationshipGroupInfo group) {
        if (relationElement == null || group == null) {
            return;
        }
        Element groupElement = relationElement.addElement(DOCUMENT_RELATION_GROUP);
        groupElement.addElement(DOCUMENT_ID).setText(group.getId().toString());
        groupElement.addElement(DOCUMENT_NUMBER).setText(group.getNumber());
        groupElement.addElement("name").setText(group.getName());
        for (int i = 0; i < group.getEntries().size(); ++i) {
            MbgViewListXMLParser.buildRelationDimension(group.getEntries().get(i), groupElement.addElement(DOCUMENT_DIMENSION));
        }
    }

    private static void buildRelationDimension(DimRelashipGroupEntryInfo entry, Element dimension) {
        dimension.addElement(DOCUMENT_DIMENSION_NAME).setText(entry.getDimName());
        dimension.addElement(DOCUMENT_DIMENSION_NUMBER).setText(entry.getDimNumber());
    }

    private void buildDocument(Element parentEle, List objects) throws DimensionException {
        for (Object obj : objects) {
            if (obj instanceof MbgViewListRowCol) {
                this.buildDocument(parentEle, (MbgViewListRowCol)obj);
                continue;
            }
            if (obj instanceof MbgViewListCalcutor) {
                this.buildDocument(parentEle, (MbgViewListCalcutor)obj);
                continue;
            }
            if (obj instanceof MbgViewListDescription) {
                this.buildDocument(parentEle, (MbgViewListDescription)obj);
                continue;
            }
            if (!(obj instanceof MbgViewListCell)) continue;
            this.buildDocument(parentEle, (MbgViewListCell)obj);
        }
    }

    private void buildDocument(Element parentEle, MbgViewListCell cell) {
        if (parentEle == null || cell == null) {
            return;
        }
        Element cellEle = parentEle.addElement(DOCUMENT_CELL);
        cellEle.addElement(DOCUMENT_ISREADONLY).setText(String.valueOf(cell.isReadonly()));
        cellEle.addElement(DOCUMENT_ROW).setText(String.valueOf(cell.getRow().getIndex()));
        cellEle.addElement(DOCUMENT_COLUMN).setText(String.valueOf(cell.getCol().getIndex()));
        cellEle.addElement(ATTR_ISCALCFIRST).setText(String.valueOf(cell.isCalculateFirstByRow()));
        this.buildDocument(cellEle, cell.getStyle());
    }

    private void buildDocument(Element parentEle, MbgViewListRowCol obj) throws DimensionException {
        int i;
        if (parentEle == null || obj == null) {
            return;
        }
        Element member = parentEle.addElement(DOCUMENT_ROW);
        member.addElement(DOCUMENT_ISCOMBIN).setText(String.valueOf(obj.isCombin()));
        member.addElement("index").setText(String.valueOf(obj.getIndex()));
        if (obj.getInitIndex() >= 0) {
            member.addElement(DOCUMENT_INIT_INDEX).setText(String.valueOf(obj.getInitIndex()));
        } else {
            member.addElement(DOCUMENT_INIT_INDEX).setText(String.valueOf(obj.getIndex()));
        }
        member.addElement(DOCUMENT_ISREADONLY).setText(String.valueOf(obj.isReadonly()));
        member.addElement(DOCUMENT_ADDFORMROLL).setText(String.valueOf(obj.isAddFromRoll()));
        this.buildDocument(member, obj.getStyle());
        for (i = 0; i < obj.getDimensions().size(); ++i) {
            this.buildDocument(member, obj.getDimensions().get(i));
        }
        for (i = 0; i < obj.getCombinSelectMembers().size(); ++i) {
            this.buildDocument(member, obj.getCombinSelectMembers().get(i), DOCUMENT_COMBINSELECTMEMBER);
        }
        for (i = 0; i < obj.getCombinMembers().size(); ++i) {
            this.buildDocument(member, obj.getCombinMembers().get(i), DOCUMENT_MEMBER);
        }
        this.buildDocument(member, obj.getLevelConfig());
        this.buildRelationMap(member, obj.getRelationMaps());
    }

    private void buildDocument(Element parentEle, Map<String, Map<String, Integer>> levelConfig) {
        if (parentEle == null || levelConfig == null) {
            return;
        }
        String dimNumber2 = null;
        Integer level = null;
        Map<String, Integer> subMap = null;
        for (String dimNumber2 : levelConfig.keySet()) {
            subMap = levelConfig.get(dimNumber2);
            for (String memberNumber : subMap.keySet()) {
                level = subMap.get(memberNumber);
                Element element = parentEle.addElement(DOCUMENT_LEVELCONFIG);
                element.addElement(DOCUMENT_DIMENSION_NUMBER).setText(dimNumber2);
                element.addElement(DOCUMENT_MEMBER).setText(memberNumber);
                element.addElement(DOCUMENT_LEVEL).setText(String.valueOf(level));
            }
        }
    }

    private void buildDocument(Element parentEle, MBgViewListStyleAttributes style) {
        if (parentEle == null || style == null) {
            return;
        }
        Element styleEle = parentEle.addElement("style");
        styleEle.addElement(ATTR_FONT).setText(style.getFontName());
        styleEle.addElement(ATTR_FONT_SIZE).setText(String.valueOf(style.getFontSize()));
        styleEle.addElement(ATTR_FONT_COLOR).setText(String.valueOf(style.getFontColor().getRGB()));
        styleEle.addElement(ATTR_BACKGROUND).setText(String.valueOf(style.getBackgroundColor().getRGB()));
        styleEle.addElement(ATTR_ISBOLD).setText(String.valueOf(style.isBold()));
        styleEle.addElement(ATTR_ISITALIC).setText(String.valueOf(style.isItalic()));
        styleEle.addElement(ATTR_ISUNDERLINE).setText(String.valueOf(style.isUnderline()));
    }

    private void buildDocument(Element parentEle, BgDimensionMember member, String memberKey) {
        if (parentEle == null || member == null) {
            return;
        }
        Element mEle = parentEle.addElement(memberKey);
        mEle.addElement(DOCUMENT_ATTRIBUTE).setText(member.getAttribute() == null ? "" : member.getAttribute());
        mEle.addElement(DOCUMENT_NUMBER).setText(member.getNumber());
        mEle.addElement("name").setText(member.getName());
        mEle.addElement(DOCUMENT_SRC_NUMBER).setText(member.getSrcNumber());
        mEle.addElement(DOCUMENT_DIMENSION_NUMBER).setText(member.getType());
        mEle.addElement(DOCUMENT_MEMBERFILLTYPE).setText(String.valueOf(member.getFillType()));
    }

    private void buildDocument(Element parentEle, MbgViewListDimensionInfo bgDimensionInfo) throws DimensionException {
        if (parentEle == null || bgDimensionInfo == null) {
            return;
        }
        Element member = parentEle.addElement(DOCUMENT_DIMENSION);
        member.addElement(DOCUMENT_NUMBER).setText(bgDimensionInfo.getNumber());
        member.addElement(DOCUMENT_ALIAS).setText(bgDimensionInfo.getAlias() == null ? "" : bgDimensionInfo.getAlias());
        member.addElement(DOCUMENT_MEMBER_VALUE_TYPE).setText(Integer.toString(bgDimensionInfo.getMemberValueType().getValue()));
        String value = bgDimensionInfo.unParseMember();
        member.addElement("value").setText(value == null ? "" : value);
        member.addElement(DOCUMENT_ATTRIBUTE).setText(bgDimensionInfo.getAttribute() == null ? "" : bgDimensionInfo.getAttribute());
        member.addElement(DOCUMENT_LAYOUT).setText(bgDimensionInfo.getLayout() == null ? "" : bgDimensionInfo.getLayout());
        member.addElement(DOCUMENT_SHOW_TYPE).setText(bgDimensionInfo.getShowType() == null ? "NAME" : bgDimensionInfo.getShowType());
        member.addElement(DOCUMENT_DINAMIC_ADD_MEMBER).setText(Boolean.toString(bgDimensionInfo.isDinamicAdd()));
        String mappingValue = bgDimensionInfo.unParseMappingList();
        member.addElement(DOCUMENT_MEMBER_MAPPING).setText(mappingValue == null ? "" : mappingValue);
        member.addElement(DOCUMENT_DINAMIC_SELECT_RELATIONSHIP).setText(Boolean.toString(bgDimensionInfo.isSelectRelationship()));
        member.addElement("index").setText(Integer.toString(bgDimensionInfo.getIndex()));
        member.addElement(DOCUMENT_HAS_SHOW).setText(Boolean.toString(bgDimensionInfo.isShow()));
        member.addElement(DOCUMENT_PERIOD_SHOW_STYLE).setText(Integer.toString(bgDimensionInfo.getPeriodDisplayStyle()));
        if (bgDimensionInfo.getBgPeriodType() != null) {
            Element bgPerildTypeEle = member.addElement(DOCUMENT_BGPERIODTYPE);
            bgPerildTypeEle.addElement(DOCUMENT_ID).setText(bgDimensionInfo.getBgPeriodType().getId().toString());
            bgPerildTypeEle.addElement(DOCUMENT_NUMBER).setText(bgDimensionInfo.getBgPeriodType().getNumber());
            bgPerildTypeEle.addElement("name").setText(bgDimensionInfo.getBgPeriodType().getName());
        }
        member.addElement(DOCUMENT_MEMBERTYPE).setText(bgDimensionInfo.getMemberType().getName());
        if (bgDimensionInfo.getOrgDimType() != null) {
            member.addElement(DOCUMENT_ORGDIMTYPE).setText(bgDimensionInfo.getOrgDimType().getName());
        }
        this.buildDocument(member, DOCUMENT_SELECT_MEMBER, bgDimensionInfo.getMemberType(), bgDimensionInfo.getSelectMembers());
        if (bgDimensionInfo.getOrignCanAddMember() != null) {
            this.buildDocument(member, DOCUMENT_DINAMIC_ADD_MEMBER_Range, bgDimensionInfo.getMemberType(), bgDimensionInfo.getOrignCanAddMember());
        } else {
            this.buildDocument(member, DOCUMENT_DINAMIC_ADD_MEMBER_Range, bgDimensionInfo.getMemberType(), bgDimensionInfo.getCanAddMember());
        }
    }

    private void buildDocument(Element parentEle, String memberKey, BgMemberSelectTypeEnum memberType, List selectMembers) {
        for (int i = 0; i < selectMembers.size(); ++i) {
            Element subEle = parentEle.addElement(memberKey);
            if (BgMemberSelectTypeEnum.Member.equals((Object)memberType)) {
                if (selectMembers.get(i) instanceof BgDimensionMember) {
                    BgDimensionMember member = (BgDimensionMember)selectMembers.get(i);
                    if (member.getNumber() == null) {
                        parentEle.remove(subEle);
                        continue;
                    }
                    subEle.addElement(DOCUMENT_ID).setText(String.valueOf(member.getAttribute()));
                    subEle.addElement(DOCUMENT_NUMBER).setText(member.getNumber());
                    subEle.addElement("name").setText(StringUtils.cnulls((String)member.getName()));
                    subEle.addElement(DOCUMENT_MEMBERFILLTYPE).setText(String.valueOf(member.getFillType()));
                    if (member.getVersion() == null) continue;
                    subEle.addElement(ATTR_VERSION).setText(String.valueOf(member.getVersion()));
                    continue;
                }
                if (!(selectMembers.get(i) instanceof BgPeriodInfo)) continue;
                BgPeriodInfo period = (BgPeriodInfo)selectMembers.get(i);
                if (period.getId() == null) {
                    subEle.addElement(DOCUMENT_ID).setText("000000000000000000000000000=");
                } else {
                    subEle.addElement(DOCUMENT_ID).setText(period.getId().toString());
                }
                subEle.addElement(DOCUMENT_NUMBER).setText(period.getNumber());
                subEle.addElement("name").setText(period.getName());
                if (StringUtils.isEmpty((String)period.getDisplayName())) continue;
                subEle.addElement(DOCUMENT_ALIAS).setText(period.getDisplayName());
                continue;
            }
            if (BgMemberSelectTypeEnum.Variate.equals((Object)memberType)) {
                if (!(selectMembers.get(i) instanceof BgVariateInfo)) continue;
                BgVariateInfo variate = (BgVariateInfo)selectMembers.get(i);
                subEle.addElement(DOCUMENT_ID).setText(variate.getId().toString());
                subEle.addElement(DOCUMENT_NUMBER).setText(variate.getNumber());
                subEle.addElement("name").setText(variate.getName());
                continue;
            }
            if (!BgMemberSelectTypeEnum.Property.equals((Object)memberType) || !(selectMembers.get(i) instanceof BgPropertyInfo)) continue;
            BgPropertyInfo prop = (BgPropertyInfo)selectMembers.get(i);
            subEle.addElement(DOCUMENT_ID).setText(prop.getId().toString());
            subEle.addElement(DOCUMENT_NUMBER).setText(prop.getNumber());
            subEle.addElement("name").setText(prop.getName());
            subEle.addElement(DOCUMENT_TYPE_NAME).setText(prop.getBgPropertySort().getName());
        }
    }

    private void buildDocument(Element parentEle, MbgViewListAtribute attribute) throws DimensionException {
        if (parentEle == null || attribute == null) {
            return;
        }
        Element member = parentEle.addElement(DOCUMENT_ATTRIBUTE);
        member.addElement(DOCUMENT_DIMENSION_NUMBER).setText(attribute.getDimNumber());
        member.addElement(DOCUMENT_ID).setText(attribute.getPropertySort().getId() != null ? attribute.getPropertySort().getId().toString() : NULL_ID);
        member.addElement(DOCUMENT_NUMBER).setText(attribute.getPropertySort().getNumber());
        member.addElement("name").setText(attribute.getPropertySort().getName());
        member.addElement(DOCUMENT_LAYOUT).setText(attribute.getLayout());
        member.addElement(DOCUMENT_ISREADONLY).setText(String.valueOf(attribute.isReadonly()));
        member.addElement("index").setText(String.valueOf(attribute.getIndex()));
    }

    private void buildDocument(Element parentEle, MbgViewListCalcutor calculate) {
        if (parentEle == null || parentEle == null) {
            return;
        }
        Element calEle = parentEle.addElement(DOCUMENT_CALCULATE);
        calEle.addElement(DOCUMENT_ISREADONLY).setText(String.valueOf(calculate.isReadonly()));
        calEle.addElement(DOCUMENT_ALIAS).setText(calculate.getAlias());
        calEle.addElement(DOCUMENT_FORMULA).setText(calculate.getFormula());
        calEle.addElement("index").setText(Integer.toString(calculate.getIndex()));
        if (calculate.getInitIndex() >= 0) {
            calEle.addElement(DOCUMENT_INIT_INDEX).setText(String.valueOf(calculate.getInitIndex()));
        } else {
            calEle.addElement(DOCUMENT_INIT_INDEX).setText(String.valueOf(calculate.getIndex()));
        }
        this.buildDocument(calEle, calculate.getDataStyleInfo());
        this.buildDocument(calEle, calculate.getStyle());
    }

    private void buildDocument(Element parentEle, ViewListCalculatorDataStyleInfo calcDataStyle) {
        if (parentEle == null || calcDataStyle == null) {
            return;
        }
        Element styleEle = parentEle.addElement(DOCUMENT_CALCDATASTYLE);
        styleEle.addElement(ATTR_CALCDECNUMS).setText(String.valueOf(calcDataStyle.getDecNums()));
        styleEle.addElement(ATTR_CALCHASGROUPSEP).setText(String.valueOf(calcDataStyle.isHasGroupSep()));
        styleEle.addElement(ATTR_CALCNEGATIVEFORMATE).setText(String.valueOf(calcDataStyle.getNegativeIndex()));
        styleEle.addElement(ATTR_CALCMEASUREUNIT).setText(String.valueOf(calcDataStyle.getMeasureUnit()));
        styleEle.addElement(ATTR_CALCSHOWPERCENT).setText(String.valueOf(calcDataStyle.isShowPercent()));
    }

    private void buildDocument(Element parentEle, MbgViewListDescription description) {
        if (parentEle == null || parentEle == null) {
            return;
        }
        Element descriptionEle = parentEle.addElement(DOCUMENT_DESCRIPTION);
        descriptionEle.addElement(DOCUMENT_ISREADONLY).setText(String.valueOf(description.isReadonly()));
        descriptionEle.addElement(DOCUMENT_ALIAS).setText(description.getAlias());
        descriptionEle.addElement("index").setText(Integer.toString(description.getIndex()));
        if (description.getInitIndex() >= 0) {
            descriptionEle.addElement(DOCUMENT_INIT_INDEX).setText(String.valueOf(description.getInitIndex()));
        } else {
            descriptionEle.addElement(DOCUMENT_INIT_INDEX).setText(String.valueOf(description.getIndex()));
        }
        this.buildDocument(descriptionEle, description.getStyle());
    }

    private static void buildWidthDocument(Element sheet, MbgViewListSheetManager curMbgSheetManager) {
        if (sheet == null || curMbgSheetManager == null || curMbgSheetManager.getWidthMap().isEmpty()) {
            return;
        }
        Element styleWidth = sheet.addElement(DOCUMENT_STYLE_WIDTH);
        int defRow = curMbgSheetManager.getWidth(true, -1);
        int defCol = curMbgSheetManager.getWidth(false, -1);
        if (defRow == -1) {
            defRow = 19;
        }
        if (defCol == -1) {
            defCol = 72;
        }
        for (String key : curMbgSheetManager.getWidthMap().keySet()) {
            int value = curMbgSheetManager.getWidthMap().get(key);
            if (!key.endsWith("-1")) {
                int defValue;
                int n = defValue = key.startsWith(DOCUMENT_ROW) ? defRow : defCol;
                if (value == defValue) continue;
            }
            Element member = styleWidth.addElement(DOCUMENT_MEMBER);
            member.addElement("name").setText(key);
            member.addElement("value").setText(String.valueOf(value));
        }
    }

    private void parseWidthStyle(MbgViewListSheetManager mbgSheetManager, Element sheetEle) {
        if (sheetEle == null || mbgSheetManager == null) {
            return;
        }
        mbgSheetManager.getWidthMap().clear();
        Element styleWidth = sheetEle.element(DOCUMENT_STYLE_WIDTH);
        if (styleWidth == null) {
            return;
        }
        Iterator it = styleWidth.elementIterator(DOCUMENT_MEMBER);
        while (it.hasNext()) {
            Element member = (Element)it.next();
            mbgSheetManager.getWidthMap().put(BgViewHelper.getElementValue(member, "name"), new Integer(BgViewHelper.getElementValue(member, "value")));
        }
    }

    public static TemplateStyleInfo parseStyle(byte[] bytes) throws Exception {
        if (bytes == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        TemplateStyleInfo templateStyleInfo = new TemplateStyleInfo();
        if (document != null && document.getRootElement() != null) {
            Element view = document.getRootElement();
            Iterator iterator = view.elementIterator();
            while (iterator.hasNext()) {
                Element member = (Element)iterator.next();
                if (DOCUMENT_HEAD_STYLE.equals(member.getName())) {
                    templateStyleInfo.setBgFormTitle((BgFormTitleEnum)((Object)BgFormTitleEnum.getEnumMap().get(member.attributeValue("value"))));
                    templateStyleInfo.getFormStyleAttributes().setFont((Font)new KDFont(member.attributeValue(ATTR_FONT), Integer.parseInt(member.attributeValue(ATTR_FONT_STYLE)), Integer.parseInt(member.attributeValue(ATTR_SIZE))));
                    templateStyleInfo.setBgFormTitleHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.parseStyleAttributes(member.attributeValue("style"), templateStyleInfo.getFormStyleAttributes());
                    continue;
                }
                if (DOCUMENT_UNIT.equals(member.getName())) {
                    templateStyleInfo.setUnitName(member.attributeValue("value"));
                    templateStyleInfo.setUnitHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.setUnitPosition(Integer.parseInt(member.attributeValue(ATTR_POSITION)));
                    continue;
                }
                if (DOCUMENT_DATE.equals(member.getName())) {
                    templateStyleInfo.setDateName(member.attributeValue("value"));
                    templateStyleInfo.setDateHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.setDatePosition(Integer.parseInt(member.attributeValue(ATTR_APPOINT_POSITION)));
                    continue;
                }
                if (DOCUMENT_CURRENCYUNIT.equals(member.getName())) {
                    templateStyleInfo.setCurrencyUnitName(member.attributeValue("value"));
                    templateStyleInfo.setCurrencyUnitHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    templateStyleInfo.setCurrencyUnitPosition(Integer.parseInt(member.attributeValue(ATTR_APPOINT_POSITION)));
                    continue;
                }
                if (DOCUMENT_COLUMN.equals(member.getName())) {
                    templateStyleInfo.getColumnHeaderStyleAttributes().setFont((Font)new KDFont(member.attributeValue(ATTR_FONT), Integer.parseInt(member.attributeValue(ATTR_FONT_STYLE)), Integer.parseInt(member.attributeValue(ATTR_SIZE))));
                    templateStyleInfo.parseStyleAttributes(member.attributeValue("style"), templateStyleInfo.getColumnHeaderStyleAttributes());
                    if (member.attributeValue(ATTR_HORIZONTAL_ALIGN) == null) continue;
                    templateStyleInfo.setColHeaderHorizontalAlign(Integer.parseInt(member.attributeValue(ATTR_HORIZONTAL_ALIGN)));
                    continue;
                }
                if (DOCUMENT_CELL.equals(member.getName())) {
                    templateStyleInfo.getDataStyleAttributes().setFont((Font)new KDFont(member.attributeValue(ATTR_FONT), Integer.parseInt(member.attributeValue(ATTR_FONT_STYLE)), Integer.parseInt(member.attributeValue(ATTR_SIZE))));
                    templateStyleInfo.parseStyleAttributes(member.attributeValue("style"), templateStyleInfo.getDataStyleAttributes());
                    continue;
                }
                if (DOCUMENT_CURRENCY.equals(member.getName())) {
                    templateStyleInfo.setCurrencyDecNums(Integer.parseInt(member.attributeValue(ATTR_CURRENCYDECNUMS)));
                    templateStyleInfo.setCurrencyHasGroupSep(Boolean.parseBoolean(member.attributeValue(ATTR_CURRENCYHASGROUPSEP)));
                    templateStyleInfo.setCurrencyNegativeIndex(Integer.parseInt(member.attributeValue(ATTR_CURRENCYNEGATIVEINDEX)));
                    templateStyleInfo.setCurrencyMeasureUnit(Integer.parseInt(member.attributeValue(ATTR_CURRENCYMEASUREUNIT)));
                    templateStyleInfo.setCurrencyShowPercent(Boolean.parseBoolean(member.attributeValue(ATTR_CURRENCYSHOWPERCENT)));
                    continue;
                }
                if (DOCUMENT_NOCURRENCYUNIT.equals(member.getName())) {
                    templateStyleInfo.setNoCurrencyDecNums(Integer.parseInt(member.attributeValue(ATTR_NOCURRENCYDECNUMS)));
                    templateStyleInfo.setNoCurrencyGroupSep(Boolean.parseBoolean(member.attributeValue(ATTR_NOCURRENCYGROUPSEP)));
                    templateStyleInfo.setNoCurrencyNegativeIndex(Integer.parseInt(member.attributeValue(ATTR_NOCURRENCYNEGATIVEINDEX)));
                    templateStyleInfo.setNoCurrencyMeasureUnit(Integer.parseInt(member.attributeValue(ATTR_NOCURRENCYMEASUREUNIT)));
                    templateStyleInfo.setNoCurrencyShowPercent(Boolean.parseBoolean(member.attributeValue(ATTR_NOCURRENCYSHOWPERCENT)));
                    continue;
                }
                if (DOCUMENT_RATE.equals(member.getName())) {
                    templateStyleInfo.setRateDecNums(Integer.parseInt(member.attributeValue(ATTR_RATEDECNUMS)));
                    templateStyleInfo.setRateHasGroupSep(Boolean.parseBoolean(member.attributeValue(ATTR_RATEHASGROUPSEP)));
                    templateStyleInfo.setRateNegativeIndex(Integer.parseInt(member.attributeValue(ATTR_RATENEGATIVEINDEX)));
                    templateStyleInfo.setRateMeasureUnit(Integer.parseInt(member.attributeValue(ATTR_RATEMEASUREUNIT)));
                    templateStyleInfo.setRateShowPercent(Boolean.parseBoolean(member.attributeValue(ATTR_RATESHOWPERCENT)));
                    continue;
                }
                if ("rowMemberMerge".equals(member.getName())) {
                    templateStyleInfo.setRowMemberMerge(Boolean.parseBoolean(member.attributeValue("rowMemberMerge")));
                    continue;
                }
                if ("dataType".equals(member.getName())) {
                    templateStyleInfo.setDataTYpe(Boolean.parseBoolean(member.attributeValue("dataType")));
                    continue;
                }
                if ("eleData".equals(member.getName())) {
                    Object[] object = null;
                    Iterator it = member.elementIterator(DOCUMENT_MEMBER);
                    while (it.hasNext()) {
                        Element element = (Element)it.next();
                        object = new Object[]{new Integer(BgViewHelper.getElementValue(element, ATTR_CURRENCYDECNUMS)), new Boolean(BgViewHelper.getElementValue(element, ATTR_CURRENCYHASGROUPSEP)), new Integer(BgViewHelper.getElementValue(element, ATTR_CURRENCYNEGATIVEINDEX)), new Integer(BgViewHelper.getElementValue(element, ATTR_CURRENCYMEASUREUNIT)), new Boolean(BgViewHelper.getElementValue(element, ATTR_CURRENCYSHOWPERCENT))};
                        templateStyleInfo.getEleMap().put(BgViewHelper.getElementValue(element, "name"), object);
                    }
                    continue;
                }
                if ("measureUnit".equals(member.getName())) {
                    templateStyleInfo.setMeasureUnitIndex(Integer.parseInt(member.attributeValue("measureUnit")));
                    continue;
                }
                if (!DOCUMENT_MEASURE_COF.equals(member.getName())) continue;
                templateStyleInfo.setCof(new BigDecimal(member.attributeValue(ATTR_MEASURECOF)));
            }
        }
        return templateStyleInfo;
    }

    private static void buildPrintSettingDocument(Element sheet, MbgViewListSheetManager curMbgSheetManager) {
        if (sheet == null || curMbgSheetManager == null || curMbgSheetManager.getPrintMap().isEmpty()) {
            return;
        }
        Element stylePrint = sheet.addElement(DOCUMENT_STYLE_PRINT);
        for (String key : curMbgSheetManager.getPrintMap().keySet()) {
            String value = curMbgSheetManager.getPrintMap().get(key);
            if (value == null) continue;
            Element member = stylePrint.addElement(DOCUMENT_MEMBER);
            member.addElement("name").setText(key);
            member.addElement("value").setText(value);
        }
    }

    private void parsePrintStyle(MbgViewListSheetManager mbgSheetManager, Element sheetEle) {
        if (sheetEle == null || mbgSheetManager == null) {
            return;
        }
        mbgSheetManager.getPrintMap().clear();
        Element styleWidth = sheetEle.element(DOCUMENT_STYLE_PRINT);
        if (styleWidth == null) {
            return;
        }
        Iterator it = styleWidth.elementIterator(DOCUMENT_MEMBER);
        while (it.hasNext()) {
            Element member = (Element)it.next();
            mbgSheetManager.getPrintMap().put(BgViewHelper.getElementValue(member, "name"), BgViewHelper.getElementValue(member, "value"));
        }
    }

    public static byte[] unParseStyle(TemplateStyleInfo templateStyleInfo) {
        if (templateStyleInfo == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Document doc = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        Element ele = doc.addElement(DOCUMENT_VIEW);
        MbgViewListXMLParser.buildDocument(ele, templateStyleInfo);
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)bos, format);
            writer.write(doc);
            writer.close();
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return bos.toByteArray();
    }

    private static void buildDocument(Element styleEle, TemplateStyleInfo templateStyleInfo) {
        if (styleEle == null || templateStyleInfo == null) {
            return;
        }
        Element headStyleEle = styleEle.addElement(DOCUMENT_HEAD_STYLE);
        headStyleEle.addAttribute("value", templateStyleInfo.getBgFormTitle().getName() == null ? "" : templateStyleInfo.getBgFormTitle().getName());
        headStyleEle.addAttribute(ATTR_FONT, templateStyleInfo.getFormStyleAttributes().getFontName());
        headStyleEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(templateStyleInfo.getFormStyleAttributes().getFont().getSize()));
        headStyleEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(templateStyleInfo.getFormStyleAttributes().getFont().getStyle()));
        headStyleEle.addAttribute(ATTR_SIZE, Integer.toString(templateStyleInfo.getFormStyleAttributes().getFontSize()));
        headStyleEle.addAttribute("style", templateStyleInfo.unParseStyleAttributes(templateStyleInfo.getFormStyleAttributes()));
        headStyleEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getBgFormTitleHorizontalAlign()));
        Element unitEle = styleEle.addElement(DOCUMENT_UNIT);
        unitEle.addAttribute("value", templateStyleInfo.getUnitName() == null ? "" : templateStyleInfo.getUnitName());
        unitEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getUnitHorizontalAlign()));
        unitEle.addAttribute(ATTR_POSITION, Integer.toString(templateStyleInfo.getUnitPosition()));
        Element dateEle = styleEle.addElement(DOCUMENT_DATE);
        dateEle.addAttribute("value", templateStyleInfo.getDateName() == null ? "" : templateStyleInfo.getDateName());
        dateEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getDateHorizontalAlign()));
        dateEle.addAttribute(ATTR_APPOINT_POSITION, Integer.toString(templateStyleInfo.getDatePosition()));
        Element currencyEle = styleEle.addElement(DOCUMENT_CURRENCYUNIT);
        currencyEle.addAttribute("value", templateStyleInfo.getCurrencyUnitName() == null ? "" : templateStyleInfo.getCurrencyUnitName());
        currencyEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getCurrencyUnitHorizontalAlign()));
        currencyEle.addAttribute(ATTR_APPOINT_POSITION, Integer.toString(templateStyleInfo.getCurrencyUnitPosition()));
        Element columnEle = styleEle.addElement(DOCUMENT_COLUMN);
        columnEle.addAttribute(ATTR_FONT, templateStyleInfo.getColumnHeaderStyleAttributes().getFontName());
        columnEle.addAttribute(ATTR_SIZE, Integer.toString(templateStyleInfo.getColumnHeaderStyleAttributes().getFontSize()));
        columnEle.addAttribute("style", templateStyleInfo.unParseStyleAttributes(templateStyleInfo.getColumnHeaderStyleAttributes()));
        columnEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(templateStyleInfo.getColumnHeaderStyleAttributes().getFont().getSize()));
        columnEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(templateStyleInfo.getColumnHeaderStyleAttributes().getFont().getStyle()));
        columnEle.addAttribute(ATTR_HORIZONTAL_ALIGN, Integer.toString(templateStyleInfo.getColHeaderHorizontalAlign()));
        Element cellEle = styleEle.addElement(DOCUMENT_CELL);
        cellEle.addAttribute(ATTR_FONT, templateStyleInfo.getDataStyleAttributes().getFontName());
        cellEle.addAttribute(ATTR_SIZE, Integer.toString(templateStyleInfo.getDataStyleAttributes().getFontSize()));
        cellEle.addAttribute("style", templateStyleInfo.unParseStyleAttributes(templateStyleInfo.getDataStyleAttributes()));
        cellEle.addAttribute(ATTR_FONT_SIZE, Integer.toString(templateStyleInfo.getDataStyleAttributes().getFont().getSize()));
        cellEle.addAttribute(ATTR_FONT_STYLE, Integer.toString(templateStyleInfo.getDataStyleAttributes().getFont().getStyle()));
        Element columnCurrency = styleEle.addElement(DOCUMENT_CURRENCY);
        columnCurrency.addAttribute(ATTR_CURRENCYDECNUMS, Integer.toString(templateStyleInfo.getCurrencyDecNums()));
        columnCurrency.addAttribute(ATTR_CURRENCYHASGROUPSEP, Boolean.toString(templateStyleInfo.isCurrencyHasGroupSep()));
        columnCurrency.addAttribute(ATTR_CURRENCYNEGATIVEINDEX, Integer.toString(templateStyleInfo.getCurrencyNegativeIndex()));
        columnCurrency.addAttribute(ATTR_CURRENCYMEASUREUNIT, Integer.toString(templateStyleInfo.getCurrencyMeasureUnit()));
        columnCurrency.addAttribute(ATTR_CURRENCYSHOWPERCENT, Boolean.toString(templateStyleInfo.isCurrencyShowPercent()));
        Element columnNoCurrency = styleEle.addElement(DOCUMENT_NOCURRENCYUNIT);
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYDECNUMS, Integer.toString(templateStyleInfo.getNoCurrencyDecNums()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYGROUPSEP, Boolean.toString(templateStyleInfo.isNoCurrencyGroupSep()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYNEGATIVEINDEX, Integer.toString(templateStyleInfo.getNoCurrencyNegativeIndex()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYMEASUREUNIT, Integer.toString(templateStyleInfo.getNoCurrencyMeasureUnit()));
        columnNoCurrency.addAttribute(ATTR_NOCURRENCYSHOWPERCENT, Boolean.toString(templateStyleInfo.isNoCurrencyShowPercent()));
        Element columnRate = styleEle.addElement(DOCUMENT_RATE);
        columnRate.addAttribute(ATTR_RATEDECNUMS, Integer.toString(templateStyleInfo.getRateDecNums()));
        columnRate.addAttribute(ATTR_RATEHASGROUPSEP, Boolean.toString(templateStyleInfo.isRateHasGroupSep()));
        columnRate.addAttribute(ATTR_RATENEGATIVEINDEX, Integer.toString(templateStyleInfo.getRateNegativeIndex()));
        columnRate.addAttribute(ATTR_RATEMEASUREUNIT, Integer.toString(templateStyleInfo.getRateMeasureUnit()));
        columnRate.addAttribute(ATTR_RATESHOWPERCENT, Boolean.toString(templateStyleInfo.isRateShowPercent()));
        Element columnRowMemberMerge = styleEle.addElement("rowMemberMerge");
        columnRowMemberMerge.addAttribute("rowMemberMerge", Boolean.toString(templateStyleInfo.isRowMemberMerge()));
        Element dataType = styleEle.addElement("dataType");
        dataType.addAttribute("dataType", Boolean.toString(templateStyleInfo.isDataTYpe()));
        Element measureUnit = styleEle.addElement("measureUnit");
        measureUnit.addAttribute("measureUnit", Integer.toString(templateStyleInfo.getMeasureUnitIndex()));
        Element cof = styleEle.addElement(DOCUMENT_MEASURE_COF);
        cof.addAttribute(ATTR_MEASURECOF, templateStyleInfo.getCof().toString());
        if (!templateStyleInfo.isDataTYpe()) {
            Element eleData = styleEle.addElement("eleData");
            for (String key : templateStyleInfo.getEleMap().keySet()) {
                Object[] value = templateStyleInfo.getEleMap().get(key);
                Element member = eleData.addElement(DOCUMENT_MEMBER);
                member.addElement("name").setText(key);
                member.addElement(ATTR_CURRENCYDECNUMS).setText(String.valueOf(value[0]));
                member.addElement(ATTR_CURRENCYHASGROUPSEP).setText(String.valueOf(value[1]));
                member.addElement(ATTR_CURRENCYNEGATIVEINDEX).setText(String.valueOf(value[2]));
                member.addElement(ATTR_CURRENCYMEASUREUNIT).setText(String.valueOf(value[3]));
                member.addElement(ATTR_CURRENCYSHOWPERCENT).setText(String.valueOf(value[4]));
            }
        }
    }

    private static void buildSpliteDocument(Element sheet, MbgViewListSheetManager curMbgSheetManager) {
        if (sheet == null || curMbgSheetManager == null || curMbgSheetManager.getSplitInfo() == null) {
            return;
        }
        String strSplit = curMbgSheetManager.getSplitInfo();
        String[] arr = strSplit.split(BgBaseConstants.SEP_THR_STR);
        Element splite = sheet.addElement(DOCUMENT_SPLIT_INFO);
        splite.addElement(ATTR_SPLIT_FIRSTROW).setText(String.valueOf(arr[0]));
        splite.addElement(ATTR_SPLIT_FIRSTCOL).setText(String.valueOf(arr[1]));
        splite.addElement(ATTR_SPLIT_FIRSTROW2).setText(String.valueOf(arr[2]));
        splite.addElement(ATTR_SPLIT_FIRSTCOL2).setText(String.valueOf(arr[3]));
        splite.addElement(ATTR_SPLIT_COLSPLIT).setText(String.valueOf(arr[4]));
        splite.addElement(ATTR_SPLIT_ROWSPLIT).setText(String.valueOf(arr[5]));
        splite.addElement(ATTR_SPLIT_ACTIVEPANE).setText(String.valueOf(arr[6]));
        splite.addElement(ATTR_SPLIT_ISFREEZED).setText(String.valueOf(arr[7]));
        splite.addElement(ATTR_SPLIT_COLFIXLINE).setText(String.valueOf(arr[8]));
        splite.addElement(ATTR_SPLIT_ROWFIXLINE).setText(String.valueOf(arr[9]));
    }

    private void parseSpliteInfo(MbgViewListSheetManager mbgSheetManager, Element sheetEle) {
        if (sheetEle == null || mbgSheetManager == null) {
            return;
        }
        Element member = sheetEle.element(DOCUMENT_SPLIT_INFO);
        if (member == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTROW)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTCOL)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTROW2)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_FIRSTCOL2)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_COLSPLIT)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ROWSPLIT)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ACTIVEPANE)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ISFREEZED)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_COLFIXLINE)).append(BgBaseConstants.SEP_THR_STR).append(BgViewHelper.getElementValue(member, ATTR_SPLIT_ROWFIXLINE));
        mbgSheetManager.setSplitInfo(sb.toString());
    }
}

