/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.StyleAttributes;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.common.ViewListMemberRender;
import com.kingdee.eas.ma.mbg.common.ViewListSheetParseHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewListExportSheetParseHelper
extends ViewListSheetParseHelper {
    public ViewListExportSheetParseHelper(String orgUnitNum, String versionNumber, MbgViewListSheetManager sheetManager, Map<String, MbgViewListSheetManager> bgDimensionManagerForMulOrg, DimensionMemberFilterInfo memberFilter, boolean isCheckFull, String sheetTitle) {
        super(orgUnitNum, versionNumber, sheetManager, bgDimensionManagerForMulOrg, memberFilter, isCheckFull, sheetTitle);
    }

    private int calculateRowHeadColCount(MbgViewListSheetManager sheetManager) {
        return sheetManager.getDimensionManager().getRowDimension().size();
    }

    private int calculateColHeadRowCount(MbgViewListSheetManager sheetManager) {
        return sheetManager.getDimensionManager().getColDimension().size();
    }

    @Override
    public void parseRowAndColDimension(Sheet sheet, TemplateStyleInfo templateStyle, BgSchemeDimensionHelper schemeHelper) throws Exception {
        this.templateStyle = templateStyle;
        this.checkIsCsl(schemeHelper);
        int rowIndex = this.calculateHeaderRowCount();
        this.loadEffectiveItemCombin(schemeHelper);
        MbgViewListSheetManager pageMemOnRowSheetManager = DimensionCommonHelper.cloneSheetManager(this.sheetManager);
        BgViewHelper.movePageDimensionsToRow(pageMemOnRowSheetManager, false);
        int colIndex = this.parseColDimension(sheet, rowIndex, pageMemOnRowSheetManager);
        int endRowIndex = this.parseRowDimension(rowIndex, colIndex, sheet, pageMemOnRowSheetManager);
        if (this.isPageDimensionsEmpty()) {
            this.parseCell(sheet, rowIndex + 1, this.calculateRowHeadColCount(pageMemOnRowSheetManager), endRowIndex, colIndex);
        }
        this.parseHeader(sheet, colIndex);
        this.parseEditNote(sheet);
        com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes borderStyle = Styles.getEmptySA();
        borderStyle.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        borderStyle.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        borderStyle.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        borderStyle.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        Color borderColor = new Color(150, 150, 150);
        borderStyle.setBorderColor(Styles.Position.LEFT, borderColor);
        borderStyle.setBorderColor(Styles.Position.RIGHT, borderColor);
        borderStyle.setBorderColor(Styles.Position.TOP, borderColor);
        borderStyle.setBorderColor(Styles.Position.BOTTOM, borderColor);
        MBgTemplateHelper.setRangeStyle(sheet.getRange(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex()), borderStyle, borderStyle);
    }

    private int parseColDimension(Sheet sheet, int rowIndex, MbgViewListSheetManager pageMemOnRowSheetManager) {
        ++rowIndex;
        int headRow = this.calculateColHeadRowCount(pageMemOnRowSheetManager);
        int headCol = this.calculateRowHeadColCount(pageMemOnRowSheetManager);
        MbgViewListSheetManager memberAutoFilterSheet = DimensionCommonHelper.cloneSheetManager(this.sheetManager);
        for (int c = 0; c < pageMemOnRowSheetManager.getDimensionManager().getRowDimension().size(); ++c) {
            IMbgViewListObject object = (IMbgViewListObject)pageMemOnRowSheetManager.getDimensionManager().getRowDimension().get(c);
            ViewListHelper.setDimension(sheet.getColumn(c, true), object);
            if (headRow > 1) {
                Range r = sheet.getRange(rowIndex, c, rowIndex + headRow - 1, c);
                r.setIgnoreProtected(true);
                r.merge();
            }
            BgNFSHelper.setValue(sheet.getCell(rowIndex, c, true), this.getDisplayName(object));
            if (!(object instanceof MbgViewListDimensionInfo)) continue;
            MBgTemplateHelper.processMemberFilter((MbgViewListDimensionInfo)object, this.sheetManager.getSheetName(), this.memberFilter, false);
            BgDimensionBaseInfo curDimension = DimensionCommonHelper.searchDimension(((MbgViewListDimensionInfo)object).getNumber(), memberAutoFilterSheet.getDimensionManager());
            BgDimensionParseCommonHelper.setFilterDimension(sheet.getCell(rowIndex, c, true), curDimension);
        }
        MBgTemplateHelper.setRangeStyle(sheet.getRange(rowIndex, 0, rowIndex + headRow - 1, headCol), ViewListStyleHelper.getHeaderStyle(this.templateStyle), null);
        ViewListSheetParseHelper.ColObjectProcessor processor = new ViewListSheetParseHelper.ColObjectProcessor(this, headRow, rowIndex, headCol);
        this.fillRowCol(sheet, pageMemOnRowSheetManager.getDimensionManager().getColDimension(), pageMemOnRowSheetManager.getDimensionManager().getColumns(), processor, true);
        this.sheetManager.getDimensionManager().getColumns().clear();
        this.sheetManager.getDimensionManager().getColumns().addAll(pageMemOnRowSheetManager.getDimensionManager().getColumns());
        return processor.colIndex - 1;
    }

    protected int parseRowDimension(int rowIndex, int endColIndex, Sheet sheet, MbgViewListSheetManager pageMemOnRowSheetManager) {
        int startRowIndex = ++rowIndex + this.sheetManager.getDimensionManager().getColDimension().size();
        int startCellColIndex = this.calculateRowHeadColCount(pageMemOnRowSheetManager);
        int headCol = this.calculateRowHeadColCount(pageMemOnRowSheetManager);
        ViewListSheetParseHelper.RowObjectProcessor processor = new ViewListSheetParseHelper.RowObjectProcessor(this, headCol, startRowIndex, 0);
        if (this.isPageDimensionsEmpty()) {
            this.fillRowCol(sheet, this.sheetManager.getDimensionManager().getRowDimension(), this.sheetManager.getDimensionManager().getRows(), processor, false);
        } else {
            this.fillPageAndRow(sheet, this.sheetManager.getDimensionManager().getRowDimension(), this.sheetManager.getDimensionManager().getRows(), processor, startCellColIndex, endColIndex);
        }
        return processor.rowIndex - 1;
    }

    private boolean isPageDimensionsEmpty() {
        return this.sheetManager.getDimensionManager().getPageDimension() == null || this.sheetManager.getDimensionManager().getPageDimension().isEmpty();
    }

    private void fillPageAndRow(Sheet sheet, List dimensions, List<IMbgViewListObject> objects, ViewListSheetParseHelper.RowColObejctProcessor processor, int startCellColIndex, int endColIndex) {
        int i;
        if (sheet == null || objects == null || objects.isEmpty()) {
            return;
        }
        List oldPageDimensions = this.sheetManager.getDimensionManager().getPageDimension();
        ArrayList<MbgViewListDimensionInfo> pageDimensions = new ArrayList<MbgViewListDimensionInfo>();
        MbgViewListDimensionInfo dimInfo = null;
        for (i = oldPageDimensions.size() - 1; i >= 0; --i) {
            if (!(oldPageDimensions.get(i) instanceof MbgViewListDimensionInfo) || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (MbgViewListDimensionInfo)oldPageDimensions.get(i)).getNumber())) continue;
            pageDimensions.add(dimInfo);
            break;
        }
        for (i = 0; i < oldPageDimensions.size(); ++i) {
            if (!(oldPageDimensions.get(i) instanceof MbgViewListDimensionInfo) || DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (MbgViewListDimensionInfo)oldPageDimensions.get(i)).getNumber())) continue;
            pageDimensions.add(dimInfo);
        }
        HashMap<String, Integer> pageDimIndexMap = new HashMap<String, Integer>();
        for (int i2 = pageDimensions.size() - 1; i2 >= 0; --i2) {
            if (!(pageDimensions.get(i2) instanceof MbgViewListDimensionInfo)) continue;
            pageDimIndexMap.put(((MbgViewListDimensionInfo)pageDimensions.get(i2)).getNumber(), i2);
        }
        ArrayList<Object[]> pageMembers = new ArrayList<Object[]>();
        BgDimensionMember[] oneMember = new BgDimensionMember[pageDimensions.size()];
        this.buildPageMember(pageDimIndexMap, pageDimensions, pageMembers, oneMember, 0);
        for (int p = 0; p < pageMembers.size(); ++p) {
            Object[] onePageMember = (Object[])pageMembers.get(p);
            int startRowIndex1 = processor.startRowIndex;
            if (this.getBgDimensionManagerForMulOrg().containsKey(this.getPageOrgNumber(onePageMember))) {
                objects = this.getBgDimensionManagerForMulOrg().get(this.getPageOrgNumber(onePageMember)).getDimensionManager().getRows();
            }
            this.fillRow(sheet, dimensions, objects, processor, onePageMember);
            this.parseCell(sheet, startRowIndex1, startCellColIndex, processor.rowIndex - 1, endColIndex);
        }
        this.mergePageMembers(sheet, pageDimensions);
    }

    protected String getPageOrgNumber(Object[] onePageMember) {
        String orgNumber = "";
        if (onePageMember != null && onePageMember.length > 0) {
            for (int i = 0; i < onePageMember.length; ++i) {
                if (!(onePageMember[i] instanceof MbgViewListDimensionMember) || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(((MbgViewListDimensionMember)onePageMember[i]).getType())) continue;
                orgNumber = ((MbgViewListDimensionMember)onePageMember[i]).getNumber();
            }
        }
        return orgNumber;
    }

    private void fillRow(Sheet sheet, List dimensions, List<IMbgViewListObject> objects, ViewListSheetParseHelper.RowColObejctProcessor processor, Object[] onePageMember) {
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo)) continue;
            dimIndexMap.put(((MbgViewListDimensionInfo)dimensions.get(i)).getNumber(), i);
        }
        ArrayList<Object> attDims = new ArrayList<Object>();
        if (onePageMember != null && onePageMember.length > 0) {
            for (int i = 0; i < onePageMember.length; ++i) {
                attDims.add(onePageMember[i]);
            }
        }
        attDims.addAll(dimensions);
        processor.processAttribMap(dimensions);
        IMbgViewListObject object = null;
        ArrayList<Object[]> members = new ArrayList<Object[]>();
        CellBlock[] mergeBlocks = null;
        for (int i = 0; i < objects.size(); ++i) {
            StyleAttributes style;
            int m;
            object = objects.get(i);
            if (processor.isShowRowCol()) {
                ViewListHelper.setRowColStart(sheet.getCell(processor.startRowIndex, processor.startColIndex, true));
            }
            members.clear();
            this.calcMembers(sheet, dimIndexMap, object, members, processor.dimensionCount - onePageMember.length, processor.getLayout());
            for (m = 0; m < members.size(); ++m) {
                Object[] oneCombin = (Object[])members.get(m);
                Object[] newOnebin = new Object[onePageMember.length + oneCombin.length];
                for (int x = 0; x < onePageMember.length; ++x) {
                    newOnebin[x] = onePageMember[x];
                }
                for (int y = 0; y < oneCombin.length; ++y) {
                    newOnebin[onePageMember.length + y] = oneCombin[y];
                }
                oneCombin = newOnebin;
                CellBlock block = processor.getCombinBlock();
                this.fillProperty(oneCombin, attDims);
                this.fillOneCombin(sheet, processor, object, oneCombin, block);
                processor.setFlag(sheet, object, oneCombin);
                processor.nextCombin();
            }
            if (object instanceof MbgViewListRowCol) {
                mergeBlocks = processor.getMergeBlock();
                processor.setRowColIndex((MbgViewListRowCol)object);
                for (m = 0; m < mergeBlocks.length; ++m) {
                    this.mergeBlock(sheet, mergeBlocks[m], processor, true);
                }
            } else {
                mergeBlocks = new CellBlock[]{processor.getObjectBlock()};
                for (m = 0; m < mergeBlocks.length; ++m) {
                    this.mergeBlock(sheet, mergeBlocks[m], processor, false);
                }
            }
            if ((style = ((IMbgViewListStyle)((Object)object)).getStyle()) == null) {
                style = this.templateStyle.getColumnHeaderStyleAttributes();
            }
            com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes styleAttrib = ViewListStyleHelper.convertStyle(style);
            styleAttrib.setNumberFormat("@");
            styleAttrib.setLocked(true);
            styleAttrib.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            MBgTemplateHelper.setRangeStyle(sheet.getRange(processor.getObjectBlock()), styleAttrib, null);
            processor.nextObject();
        }
    }

    protected void fillOneCombin(Sheet sheet, ViewListSheetParseHelper.RowColObejctProcessor processor, IMbgViewListObject object, Object[] oneCombin, CellBlock block) {
        int index = 0;
        Cell cell = null;
        for (int r = block.getRow(); r <= block.getRow2(); ++r) {
            for (int c = block.getCol(); c <= block.getCol2(); ++c) {
                cell = sheet.getCell(r, c, true);
                Object oneMember = oneCombin[index];
                String showType = null;
                if (oneMember instanceof BgDimensionMember) {
                    showType = DimensionCommonHelper.searchDimension(((BgDimensionMember)oneMember).getType(), this.sheetManager.getDimensionManager().getDimension()).getShowType();
                }
                oneMember = ViewListMemberRender.createExpaneMember(oneMember);
                ViewListHelper.setHeadCell(cell, oneMember, showType);
                ++index;
            }
        }
    }

    private void mergePageMembers(Sheet sheet, List pageDimensions) {
        int startRowIndex = -1;
        int startColIndex = -1;
        int lastRowIndex = -1;
        int lastColIndex = -1;
        Object lastObject = null;
        Object curObject = null;
        Object nextCurObject = null;
        Cell cell = null;
        Cell nextCell = null;
        MergeBlocks sheetMerger = sheet.getMerger(false);
        for (int c = 0; c < pageDimensions.size(); ++c) {
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                cell = sheet.getCell(r, c, false);
                nextCell = sheet.getCell(r + 1, c, false);
                if (cell == null) continue;
                curObject = ViewListHelper.getHeadCellValue(cell);
                nextCurObject = ViewListHelper.getHeadCellValue(nextCell);
                if (curObject == null) continue;
                if (!curObject.equals(lastObject)) {
                    lastObject = curObject;
                    startRowIndex = r;
                    startColIndex = c;
                }
                if (curObject.equals(nextCurObject)) continue;
                if (cell != null && cell.getMerge(false) != null) {
                    r = cell.getMerge(false).getRow2();
                }
                lastRowIndex = r;
                lastColIndex = c;
                Range range = sheet.getRange(startRowIndex, startColIndex, lastRowIndex, lastColIndex);
                range.setIgnoreProtected(true);
                CellBlock rangeBlock = range.getBlock(0);
                if (rangeBlock != null && sheetMerger != null && sheetMerger.getTouchedBlocks(rangeBlock) != null) {
                    if (!sheetMerger.getTouchedBlocks(rangeBlock).contains(rangeBlock)) {
                        sheetMerger.remove(sheetMerger.getTouchedBlocks(rangeBlock));
                    }
                    if (sheetMerger.getTouchedBlocks(rangeBlock) != null && sheetMerger.getTouchedBlocks(rangeBlock).size() == 1 && sheetMerger.getTouchedBlocks(rangeBlock).get(0) != null && sheetMerger.getTouchedBlocks(rangeBlock).get(0).equals(rangeBlock)) {
                        sheetMerger.remove(sheetMerger.getTouchedBlocks(rangeBlock));
                    }
                }
                range.merge();
            }
        }
    }

    private void buildPageMember(Map<String, Integer> dimIndexMap, List<MbgViewListDimensionInfo> dimensions, List<Object[]> members, BgDimensionMember[] oneMember, int dimIndex) {
        MbgViewListDimensionInfo dimension = dimensions.get(dimIndex);
        ArrayList<MbgViewListDimensionMember> thisMembers = null;
        if (this.isShowDefaultMember && dimension.getMember().isEmpty()) {
            thisMembers = new ArrayList<MbgViewListDimensionMember>();
            MbgViewListDimensionMember member = new MbgViewListDimensionMember(dimension.getNumber(), dimension.getRefField(), dimension.getName(), null);
            member.setAlias(member.getName());
            thisMembers.add(member);
        } else {
            thisMembers = dimension.getMember();
        }
        if (!thisMembers.isEmpty()) {
            for (int m = 0; m < thisMembers.size(); ++m) {
                oneMember[dimIndexMap.get((Object)dimension.getNumber()).intValue()] = (BgDimensionMember)thisMembers.get(m);
                if (dimIndex == dimensions.size() - 1) {
                    Object[] ms = new Object[oneMember.length];
                    System.arraycopy(oneMember, 0, ms, 0, oneMember.length);
                    members.add(ms);
                    continue;
                }
                this.buildPageMember(dimIndexMap, dimensions, members, oneMember, dimIndex + 1);
            }
        }
    }

    @Override
    protected String getMemberRelationShipKey(String orgNumber, MbgViewListRowCol object, String layout) {
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(this.sheetManager.getDimensionManager());
        int index = object.getIndex();
        if (!isorgOnPageOrView && !orgNumber.equals(this.curOrgNum)) {
            index = object.getInitIndex();
        }
        return DimensionMemberRelationShipHelper.getKey(orgNumber, layout, index);
    }
}

